import{s as Po,o as Vo,n as A}from"../chunks/scheduler.9bc65507.js";import{S as Ao,i as Qo,g as c,s as r,r as g,A as So,h as p,f as a,c as i,j as Z,u as _,x as u,k as B,y as s,a as m,v as b,d as M,t as y,w as T}from"../chunks/index.707bf1b6.js";import{T as at}from"../chunks/Tip.c2ecdbf4.js";import{D as V}from"../chunks/Docstring.17db21ae.js";import{C as nt}from"../chunks/CodeBlock.54a9f38d.js";import{E as ot}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as ie}from"../chunks/Heading.342b1fa6.js";function Yo(w){let t,h="Example:",l,d,f;return d=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1wdENvbmZpZyUyQyUyME1wdE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1wdCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTXB0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1wdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MptConfig, MptModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mpt configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MptConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function Oo(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(l){t=p(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,d){m(l,t,d)},p:A,d(l){l&&a(t)}}}function Do(w){let t,h="Example:",l,d,f;return d=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNcHRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBbW9kZWwlMjAlM0QlMjBNcHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptModel.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function Ko(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(l){t=p(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,d){m(l,t,d)},p:A,d(l){l&&a(t)}}}function en(w){let t,h="Example:",l,d,f;return d=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1wdEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForCausalLM.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function tn(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(l){t=p(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,d){m(l,t,d)},p:A,d(l){l&&a(t)}}}function on(w){let t,h="Example of single-label classification:",l,d,f;return d=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-ykxpe4"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function nn(w){let t,h="Example of multi-label classification:",l,d,f;return d=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtb3NhaWNtbCUyRm1wdC03YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1l8e32d"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function sn(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(l){t=p(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,d){m(l,t,d)},p:A,d(l){l&&a(t)}}}function an(w){let t,h="Example:",l,d,f;return d=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForTokenClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,l=r(),g(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=i(o),_(d.$$.fragment,o)},m(o,v){m(o,t,v),m(o,l,v),b(d,o,v),f=!0},p:A,i(o){f||(M(d.$$.fragment,o),f=!0)},o(o){y(d.$$.fragment,o),f=!1},d(o){o&&(a(t),a(l)),T(d,o)}}}function rn(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(l){t=p(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,d){m(l,t,d)},p:A,d(l){l&&a(t)}}}function ln(w){let t,h,l,d,f,o,v,rt,le,ho='The MPT model was proposed by the <a href="https://www.mosaicml.com/" rel="nofollow">MosaicML</a> team and released with multiple sizes and finetuned variants. The MPT models is a series of open source and commercially usable LLMs pre-trained on 1T tokens.',it,de,fo="MPT models are GPT-style decoder-only transformers with several improvements: performance-optimized layer implementations, architecture changes that provide greater training stability, and the elimination of context length limits by replacing positional embeddings with ALiBi.",lt,ce,go="<li>MPT base: MPT base pre-trained models on next token prediction</li> <li>MPT instruct: MPT base models fine-tuned on instruction based tasks</li> <li>MPT storywriter: MPT base models fine-tuned for 2500 steps on 65k-token excerpts of fiction books contained in the books3 corpus, this enables the model to handle very long sequences</li>",dt,pe,_o='The original code is available at the  <a href="https://github.com/mosaicml/llm-foundry/tree/main" rel="nofollow"><code>llm-foundry</code></a> repository.',ct,me,bo='Read more about it <a href="https://www.mosaicml.com/blog/mpt-7b" rel="nofollow">in the release blogpost</a>',pt,ue,Mo="Tips:",mt,he,yo='<li><p>Learn more about some techniques behind training of the model <a href="https://github.com/mosaicml/llm-foundry/blob/main/TUTORIAL.md#faqs" rel="nofollow">in this section of llm-foundry repository</a></p></li> <li><p>If you want to use the advanced version of the model (triton kernels, direct flash attention integration), you can still use the original model implementation by adding <code>trust_remote_code=True</code> when calling <code>from_pretrained</code>.</p></li> <li><p><a href="https://colab.research.google.com/drive/1HCpQkLL7UXW8xJUJJ29X7QAeNJKO0frZ?usp=sharing" rel="nofollow">Fine-tuning Notebook</a> on how to fine-tune MPT-7B on a free Google Colab instance to turn the model into a Chatbot.</p></li>',ut,fe,ht,F,ge,jt,Ue,To=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a>. It is used to instantiate a Mpt model
according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to the Mpt-7b architecture
<a href="https://huggingface.co/mosaicml/mpt-7b" rel="nofollow">mosaicml/mpt-7b</a>.`,xt,We,vo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Jt,Y,ft,_e,gt,C,be,zt,Ne,wo="The bare Mpt Model transformer outputting raw hidden-states without any specific head on top.",Ft,Ie,ko=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Ut,qe,$o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,L,Me,Nt,Ze,Co='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a> forward method, overrides the <code>__call__</code> special method.',It,O,qt,D,_t,ye,bt,j,Te,Zt,Be,jo=`The MPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Bt,Le,xo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Lt,He,Jo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ht,H,ve,Gt,Ge,zo='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Rt,K,Xt,ee,Mt,we,yt,k,ke,Et,Re,Fo="The MPT Model transformer with a sequence classification head on top (linear layer).",Pt,Xe,Uo=`<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1) do.`,Vt,Ee,Wo=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,At,Pe,No=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Qt,Ve,Io=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,St,z,$e,Yt,Ae,qo='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ot,te,Dt,oe,Kt,ne,Tt,Ce,vt,x,je,eo,Qe,Zo=`MPT Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,to,Se,Bo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,oo,Ye,Lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,no,G,xe,so,Oe,Ho='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForTokenClassification">MptForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',ao,se,ro,ae,wt,Je,kt,J,ze,io,De,Go=`The MPT Model transformer with a span classification head on top for extractive question-answering tasks like SQuAD
(a linear layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,lo,Ke,Ro=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,co,et,Xo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,Q,Fe,mo,tt,Eo='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',uo,re,$t,st,Ct;return f=new ie({props:{title:"MPT",local:"mpt",headingTag:"h1"}}),v=new ie({props:{title:"Overview",local:"overview",headingTag:"h2"}}),fe=new ie({props:{title:"MptConfig",local:"transformers.MptConfig",headingTag:"h2"}}),ge=new V({props:{name:"class transformers.MptConfig",anchor:"transformers.MptConfig",parameters:[{name:"d_model",val:": int = 2048"},{name:"n_heads",val:": int = 16"},{name:"n_layers",val:": int = 24"},{name:"expansion_ratio",val:": int = 4"},{name:"max_seq_len",val:": int = 2048"},{name:"vocab_size",val:": int = 50368"},{name:"resid_pdrop",val:": float = 0.0"},{name:"layer_norm_epsilon",val:": float = 1e-05"},{name:"emb_pdrop",val:": float = 0.0"},{name:"learned_pos_emb",val:": bool = True"},{name:"attn_config",val:": MptAttentionConfig = None"},{name:"init_device",val:": str = 'cpu'"},{name:"logit_scale",val:": typing.Union[float, str, NoneType] = None"},{name:"no_bias",val:": bool = True"},{name:"verbose",val:": int = 0"},{name:"embedding_fraction",val:": float = 1.0"},{name:"norm_type",val:": str = 'low_precision_layernorm'"},{name:"use_cache",val:": bool = False"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MptConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"d_model"},{anchor:"transformers.MptConfig.n_heads",description:`<strong>n_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_heads"},{anchor:"transformers.MptConfig.n_layers",description:`<strong>n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layers"},{anchor:"transformers.MptConfig.expansion_ratio",description:`<strong>expansion_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The ratio of the up/down scale in the MLP.`,name:"expansion_ratio"},{anchor:"transformers.MptConfig.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length of the model.`,name:"max_seq_len"},{anchor:"transformers.MptConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50368) &#x2014;
Vocabulary size of the Mpt model. Defines the maximum number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a>. Check <a href="https://huggingface.co/bigscience/mpt/discussions/120#633d28389addb8530b406c2a" rel="nofollow">this
discussion</a> on how the
<code>vocab_size</code> has been defined.`,name:"vocab_size"},{anchor:"transformers.MptConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability applied to the attention output before combining with residual.`,name:"resid_pdrop"},{anchor:"transformers.MptConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.MptConfig.emb_pdrop",description:`<strong>emb_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the embedding layer.`,name:"emb_pdrop"},{anchor:"transformers.MptConfig.learned_pos_emb",description:`<strong>learned_pos_emb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use learned positional embeddings.`,name:"learned_pos_emb"},{anchor:"transformers.MptConfig.attn_config",description:`<strong>attn_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary used to configure the model&#x2019;s attention module.`,name:"attn_config"},{anchor:"transformers.MptConfig.init_device",description:`<strong>init_device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to use for parameter initialization. Defined for backward compatibility`,name:"init_device"},{anchor:"transformers.MptConfig.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If not None, scale the logits by this value.`,name:"logit_scale"},{anchor:"transformers.MptConfig.no_bias",description:`<strong>no_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in all linear layers.`,name:"no_bias"},{anchor:"transformers.MptConfig.verbose",description:`<strong>verbose</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The verbosity level to use for logging. Used in the previous versions of MPT models for logging. This
argument is deprecated.`,name:"verbose"},{anchor:"transformers.MptConfig.embedding_fraction",description:`<strong>embedding_fraction</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The fraction to scale the gradients of the embedding layer by.`,name:"embedding_fraction"},{anchor:"transformers.MptConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;low_precision_layernorm&quot;</code>) &#x2014;
Type of layer norm to use. All MPT models uses the same layer norm implementation. Defined for backward
compatibility.`,name:"norm_type"},{anchor:"transformers.MptConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.MptConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/configuration_mpt.py#L121"}}),Y=new ot({props:{anchor:"transformers.MptConfig.example",$$slots:{default:[Yo]},$$scope:{ctx:w}}}),_e=new ie({props:{title:"MptModel",local:"transformers.MptModel",headingTag:"h2"}}),be=new V({props:{name:"class transformers.MptModel",anchor:"transformers.MptModel",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L355"}}),Me=new V({props:{name:"forward",anchor:"transformers.MptModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.MptModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.MptModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new at({props:{$$slots:{default:[Oo]},$$scope:{ctx:w}}}),D=new ot({props:{anchor:"transformers.MptModel.forward.example",$$slots:{default:[Do]},$$scope:{ctx:w}}}),ye=new ie({props:{title:"MptForCausalLM",local:"transformers.MptForCausalLM",headingTag:"h2"}}),Te=new V({props:{name:"class transformers.MptForCausalLM",anchor:"transformers.MptForCausalLM",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L512"}}),ve=new V({props:{name:"forward",anchor:"transformers.MptForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.MptForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.MptForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MptForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new at({props:{$$slots:{default:[Ko]},$$scope:{ctx:w}}}),ee=new ot({props:{anchor:"transformers.MptForCausalLM.forward.example",$$slots:{default:[en]},$$scope:{ctx:w}}}),we=new ie({props:{title:"MptForSequenceClassification",local:"transformers.MptForSequenceClassification",headingTag:"h2"}}),ke=new V({props:{name:"class transformers.MptForSequenceClassification",anchor:"transformers.MptForSequenceClassification",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L671"}}),$e=new V({props:{name:"forward",anchor:"transformers.MptForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.MptForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.MptForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MptForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new at({props:{$$slots:{default:[tn]},$$scope:{ctx:w}}}),oe=new ot({props:{anchor:"transformers.MptForSequenceClassification.forward.example",$$slots:{default:[on]},$$scope:{ctx:w}}}),ne=new ot({props:{anchor:"transformers.MptForSequenceClassification.forward.example-2",$$slots:{default:[nn]},$$scope:{ctx:w}}}),Ce=new ie({props:{title:"MptForTokenClassification",local:"transformers.MptForTokenClassification",headingTag:"h2"}}),je=new V({props:{name:"class transformers.MptForTokenClassification",anchor:"transformers.MptForTokenClassification",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L784"}}),xe=new V({props:{name:"forward",anchor:"transformers.MptForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**deprecated_arguments",val:""}],parametersDescription:[{anchor:"transformers.MptForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.MptForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.MptForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MptForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L802",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new at({props:{$$slots:{default:[sn]},$$scope:{ctx:w}}}),ae=new ot({props:{anchor:"transformers.MptForTokenClassification.forward.example",$$slots:{default:[an]},$$scope:{ctx:w}}}),Je=new ie({props:{title:"MptForQuestionAnswering",local:"transformers.MptForQuestionAnswering",headingTag:"h2"}}),ze=new V({props:{name:"class transformers.MptForQuestionAnswering",anchor:"transformers.MptForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MptForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L873"}}),Fe=new V({props:{name:"forward",anchor:"transformers.MptForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.MptForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.MptForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MptForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MptForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L882"}}),re=new at({props:{$$slots:{default:[rn]},$$scope:{ctx:w}}}),{c(){t=c("meta"),h=r(),l=c("p"),d=r(),g(f.$$.fragment),o=r(),g(v.$$.fragment),rt=r(),le=c("p"),le.innerHTML=ho,it=r(),de=c("p"),de.textContent=fo,lt=r(),ce=c("ul"),ce.innerHTML=go,dt=r(),pe=c("p"),pe.innerHTML=_o,ct=r(),me=c("p"),me.innerHTML=bo,pt=r(),ue=c("p"),ue.textContent=Mo,mt=r(),he=c("ul"),he.innerHTML=yo,ut=r(),g(fe.$$.fragment),ht=r(),F=c("div"),g(ge.$$.fragment),jt=r(),Ue=c("p"),Ue.innerHTML=To,xt=r(),We=c("p"),We.innerHTML=vo,Jt=r(),g(Y.$$.fragment),ft=r(),g(_e.$$.fragment),gt=r(),C=c("div"),g(be.$$.fragment),zt=r(),Ne=c("p"),Ne.textContent=wo,Ft=r(),Ie=c("p"),Ie.innerHTML=ko,Ut=r(),qe=c("p"),qe.innerHTML=$o,Wt=r(),L=c("div"),g(Me.$$.fragment),Nt=r(),Ze=c("p"),Ze.innerHTML=Co,It=r(),g(O.$$.fragment),qt=r(),g(D.$$.fragment),_t=r(),g(ye.$$.fragment),bt=r(),j=c("div"),g(Te.$$.fragment),Zt=r(),Be=c("p"),Be.textContent=jo,Bt=r(),Le=c("p"),Le.innerHTML=xo,Lt=r(),He=c("p"),He.innerHTML=Jo,Ht=r(),H=c("div"),g(ve.$$.fragment),Gt=r(),Ge=c("p"),Ge.innerHTML=zo,Rt=r(),g(K.$$.fragment),Xt=r(),g(ee.$$.fragment),Mt=r(),g(we.$$.fragment),yt=r(),k=c("div"),g(ke.$$.fragment),Et=r(),Re=c("p"),Re.textContent=Fo,Pt=r(),Xe=c("p"),Xe.innerHTML=Uo,Vt=r(),Ee=c("p"),Ee.innerHTML=Wo,At=r(),Pe=c("p"),Pe.innerHTML=No,Qt=r(),Ve=c("p"),Ve.innerHTML=Io,St=r(),z=c("div"),g($e.$$.fragment),Yt=r(),Ae=c("p"),Ae.innerHTML=qo,Ot=r(),g(te.$$.fragment),Dt=r(),g(oe.$$.fragment),Kt=r(),g(ne.$$.fragment),Tt=r(),g(Ce.$$.fragment),vt=r(),x=c("div"),g(je.$$.fragment),eo=r(),Qe=c("p"),Qe.textContent=Zo,to=r(),Se=c("p"),Se.innerHTML=Bo,oo=r(),Ye=c("p"),Ye.innerHTML=Lo,no=r(),G=c("div"),g(xe.$$.fragment),so=r(),Oe=c("p"),Oe.innerHTML=Ho,ao=r(),g(se.$$.fragment),ro=r(),g(ae.$$.fragment),wt=r(),g(Je.$$.fragment),kt=r(),J=c("div"),g(ze.$$.fragment),io=r(),De=c("p"),De.innerHTML=Go,lo=r(),Ke=c("p"),Ke.innerHTML=Ro,co=r(),et=c("p"),et.innerHTML=Xo,po=r(),Q=c("div"),g(Fe.$$.fragment),mo=r(),tt=c("p"),tt.innerHTML=Eo,uo=r(),g(re.$$.fragment),$t=r(),st=c("p"),this.h()},l(e){const n=So("svelte-u9bgzb",document.head);t=p(n,"META",{name:!0,content:!0}),n.forEach(a),h=i(e),l=p(e,"P",{}),Z(l).forEach(a),d=i(e),_(f.$$.fragment,e),o=i(e),_(v.$$.fragment,e),rt=i(e),le=p(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1f4n6zy"&&(le.innerHTML=ho),it=i(e),de=p(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1ipzlev"&&(de.textContent=fo),lt=i(e),ce=p(e,"UL",{"data-svelte-h":!0}),u(ce)!=="svelte-re1aby"&&(ce.innerHTML=go),dt=i(e),pe=p(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-si6x57"&&(pe.innerHTML=_o),ct=i(e),me=p(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-124zaeu"&&(me.innerHTML=bo),pt=i(e),ue=p(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-axv494"&&(ue.textContent=Mo),mt=i(e),he=p(e,"UL",{"data-svelte-h":!0}),u(he)!=="svelte-7pyst1"&&(he.innerHTML=yo),ut=i(e),_(fe.$$.fragment,e),ht=i(e),F=p(e,"DIV",{class:!0});var R=Z(F);_(ge.$$.fragment,R),jt=i(R),Ue=p(R,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1i1d0io"&&(Ue.innerHTML=To),xt=i(R),We=p(R,"P",{"data-svelte-h":!0}),u(We)!=="svelte-o55m63"&&(We.innerHTML=vo),Jt=i(R),_(Y.$$.fragment,R),R.forEach(a),ft=i(e),_(_e.$$.fragment,e),gt=i(e),C=p(e,"DIV",{class:!0});var U=Z(C);_(be.$$.fragment,U),zt=i(U),Ne=p(U,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1tl93fy"&&(Ne.textContent=wo),Ft=i(U),Ie=p(U,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-1ymzemc"&&(Ie.innerHTML=ko),Ut=i(U),qe=p(U,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-hswkmf"&&(qe.innerHTML=$o),Wt=i(U),L=p(U,"DIV",{class:!0});var X=Z(L);_(Me.$$.fragment,X),Nt=i(X),Ze=p(X,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-10g2gzo"&&(Ze.innerHTML=Co),It=i(X),_(O.$$.fragment,X),qt=i(X),_(D.$$.fragment,X),X.forEach(a),U.forEach(a),_t=i(e),_(ye.$$.fragment,e),bt=i(e),j=p(e,"DIV",{class:!0});var W=Z(j);_(Te.$$.fragment,W),Zt=i(W),Be=p(W,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-fj8rfo"&&(Be.textContent=jo),Bt=i(W),Le=p(W,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-1ymzemc"&&(Le.innerHTML=xo),Lt=i(W),He=p(W,"P",{"data-svelte-h":!0}),u(He)!=="svelte-hswkmf"&&(He.innerHTML=Jo),Ht=i(W),H=p(W,"DIV",{class:!0});var E=Z(H);_(ve.$$.fragment,E),Gt=i(E),Ge=p(E,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-13tbzng"&&(Ge.innerHTML=zo),Rt=i(E),_(K.$$.fragment,E),Xt=i(E),_(ee.$$.fragment,E),E.forEach(a),W.forEach(a),Mt=i(e),_(we.$$.fragment,e),yt=i(e),k=p(e,"DIV",{class:!0});var $=Z(k);_(ke.$$.fragment,$),Et=i($),Re=p($,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-15wt48j"&&(Re.textContent=Fo),Pt=i($),Xe=p($,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-q1992o"&&(Xe.innerHTML=Uo),Vt=i($),Ee=p($,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-10ugs3m"&&(Ee.innerHTML=Wo),At=i($),Pe=p($,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1ymzemc"&&(Pe.innerHTML=No),Qt=i($),Ve=p($,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=Io),St=i($),z=p($,"DIV",{class:!0});var N=Z(z);_($e.$$.fragment,N),Yt=i(N),Ae=p(N,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-i17e5a"&&(Ae.innerHTML=qo),Ot=i(N),_(te.$$.fragment,N),Dt=i(N),_(oe.$$.fragment,N),Kt=i(N),_(ne.$$.fragment,N),N.forEach(a),$.forEach(a),Tt=i(e),_(Ce.$$.fragment,e),vt=i(e),x=p(e,"DIV",{class:!0});var I=Z(x);_(je.$$.fragment,I),eo=i(I),Qe=p(I,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-9z7yxo"&&(Qe.textContent=Zo),to=i(I),Se=p(I,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-1ymzemc"&&(Se.innerHTML=Bo),oo=i(I),Ye=p(I,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=Lo),no=i(I),G=p(I,"DIV",{class:!0});var P=Z(G);_(xe.$$.fragment,P),so=i(P),Oe=p(P,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-1fxeom4"&&(Oe.innerHTML=Ho),ao=i(P),_(se.$$.fragment,P),ro=i(P),_(ae.$$.fragment,P),P.forEach(a),I.forEach(a),wt=i(e),_(Je.$$.fragment,e),kt=i(e),J=p(e,"DIV",{class:!0});var q=Z(J);_(ze.$$.fragment,q),io=i(q),De=p(q,"P",{"data-svelte-h":!0}),u(De)!=="svelte-n1oyui"&&(De.innerHTML=Go),lo=i(q),Ke=p(q,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1ymzemc"&&(Ke.innerHTML=Ro),co=i(q),et=p(q,"P",{"data-svelte-h":!0}),u(et)!=="svelte-hswkmf"&&(et.innerHTML=Xo),po=i(q),Q=p(q,"DIV",{class:!0});var S=Z(Q);_(Fe.$$.fragment,S),mo=i(S),tt=p(S,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-1pr97os"&&(tt.innerHTML=Eo),uo=i(S),_(re.$$.fragment,S),S.forEach(a),q.forEach(a),$t=i(e),st=p(e,"P",{}),Z(st).forEach(a),this.h()},h(){B(t,"name","hf:doc:metadata"),B(t,"content",dn),B(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){s(document.head,t),m(e,h,n),m(e,l,n),m(e,d,n),b(f,e,n),m(e,o,n),b(v,e,n),m(e,rt,n),m(e,le,n),m(e,it,n),m(e,de,n),m(e,lt,n),m(e,ce,n),m(e,dt,n),m(e,pe,n),m(e,ct,n),m(e,me,n),m(e,pt,n),m(e,ue,n),m(e,mt,n),m(e,he,n),m(e,ut,n),b(fe,e,n),m(e,ht,n),m(e,F,n),b(ge,F,null),s(F,jt),s(F,Ue),s(F,xt),s(F,We),s(F,Jt),b(Y,F,null),m(e,ft,n),b(_e,e,n),m(e,gt,n),m(e,C,n),b(be,C,null),s(C,zt),s(C,Ne),s(C,Ft),s(C,Ie),s(C,Ut),s(C,qe),s(C,Wt),s(C,L),b(Me,L,null),s(L,Nt),s(L,Ze),s(L,It),b(O,L,null),s(L,qt),b(D,L,null),m(e,_t,n),b(ye,e,n),m(e,bt,n),m(e,j,n),b(Te,j,null),s(j,Zt),s(j,Be),s(j,Bt),s(j,Le),s(j,Lt),s(j,He),s(j,Ht),s(j,H),b(ve,H,null),s(H,Gt),s(H,Ge),s(H,Rt),b(K,H,null),s(H,Xt),b(ee,H,null),m(e,Mt,n),b(we,e,n),m(e,yt,n),m(e,k,n),b(ke,k,null),s(k,Et),s(k,Re),s(k,Pt),s(k,Xe),s(k,Vt),s(k,Ee),s(k,At),s(k,Pe),s(k,Qt),s(k,Ve),s(k,St),s(k,z),b($e,z,null),s(z,Yt),s(z,Ae),s(z,Ot),b(te,z,null),s(z,Dt),b(oe,z,null),s(z,Kt),b(ne,z,null),m(e,Tt,n),b(Ce,e,n),m(e,vt,n),m(e,x,n),b(je,x,null),s(x,eo),s(x,Qe),s(x,to),s(x,Se),s(x,oo),s(x,Ye),s(x,no),s(x,G),b(xe,G,null),s(G,so),s(G,Oe),s(G,ao),b(se,G,null),s(G,ro),b(ae,G,null),m(e,wt,n),b(Je,e,n),m(e,kt,n),m(e,J,n),b(ze,J,null),s(J,io),s(J,De),s(J,lo),s(J,Ke),s(J,co),s(J,et),s(J,po),s(J,Q),b(Fe,Q,null),s(Q,mo),s(Q,tt),s(Q,uo),b(re,Q,null),m(e,$t,n),m(e,st,n),Ct=!0},p(e,[n]){const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),Y.$set(R);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),O.$set(U);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),D.$set(X);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),K.$set(W);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),ee.$set(E);const $={};n&2&&($.$$scope={dirty:n,ctx:e}),te.$set($);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),oe.$set(N);const I={};n&2&&(I.$$scope={dirty:n,ctx:e}),ne.$set(I);const P={};n&2&&(P.$$scope={dirty:n,ctx:e}),se.$set(P);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),ae.$set(q);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),re.$set(S)},i(e){Ct||(M(f.$$.fragment,e),M(v.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(Y.$$.fragment,e),M(_e.$$.fragment,e),M(be.$$.fragment,e),M(Me.$$.fragment,e),M(O.$$.fragment,e),M(D.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(ve.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(we.$$.fragment,e),M(ke.$$.fragment,e),M($e.$$.fragment,e),M(te.$$.fragment,e),M(oe.$$.fragment,e),M(ne.$$.fragment,e),M(Ce.$$.fragment,e),M(je.$$.fragment,e),M(xe.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(Je.$$.fragment,e),M(ze.$$.fragment,e),M(Fe.$$.fragment,e),M(re.$$.fragment,e),Ct=!0)},o(e){y(f.$$.fragment,e),y(v.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(Y.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(Me.$$.fragment,e),y(O.$$.fragment,e),y(D.$$.fragment,e),y(ye.$$.fragment,e),y(Te.$$.fragment,e),y(ve.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(we.$$.fragment,e),y(ke.$$.fragment,e),y($e.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y(xe.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(Je.$$.fragment,e),y(ze.$$.fragment,e),y(Fe.$$.fragment,e),y(re.$$.fragment,e),Ct=!1},d(e){e&&(a(h),a(l),a(d),a(o),a(rt),a(le),a(it),a(de),a(lt),a(ce),a(dt),a(pe),a(ct),a(me),a(pt),a(ue),a(mt),a(he),a(ut),a(ht),a(F),a(ft),a(gt),a(C),a(_t),a(bt),a(j),a(Mt),a(yt),a(k),a(Tt),a(vt),a(x),a(wt),a(kt),a(J),a($t),a(st)),a(t),T(f,e),T(v,e),T(fe,e),T(ge),T(Y),T(_e,e),T(be),T(Me),T(O),T(D),T(ye,e),T(Te),T(ve),T(K),T(ee),T(we,e),T(ke),T($e),T(te),T(oe),T(ne),T(Ce,e),T(je),T(xe),T(se),T(ae),T(Je,e),T(ze),T(Fe),T(re)}}}const dn='{"title":"MPT","local":"mpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"MptConfig","local":"transformers.MptConfig","sections":[],"depth":2},{"title":"MptModel","local":"transformers.MptModel","sections":[],"depth":2},{"title":"MptForCausalLM","local":"transformers.MptForCausalLM","sections":[],"depth":2},{"title":"MptForSequenceClassification","local":"transformers.MptForSequenceClassification","sections":[],"depth":2},{"title":"MptForTokenClassification","local":"transformers.MptForTokenClassification","sections":[],"depth":2},{"title":"MptForQuestionAnswering","local":"transformers.MptForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function cn(w){return Vo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends Ao{constructor(t){super(),Qo(this,t,cn,ln,Po,{})}}export{bn as component};
