import{s as Wo,o as Fo,n as $t}from"../chunks/scheduler.9bc65507.js";import{S as Vo,i as Io,g as l,s as n,r as m,A as Lo,h as i,f as t,c as s,j,u as h,x as p,k as J,y as a,a as r,v as f,d as u,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as Uo}from"../chunks/Tip.c2ecdbf4.js";import{D as z}from"../chunks/Docstring.17db21ae.js";import{C as wt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Zo}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as Y}from"../chunks/Heading.342b1fa6.js";function Bo(Z){let c,k="Example:",T,y,v;return y=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaDJUZXh0MkNvbmZpZyUyQyUyMFNwZWVjaDJUZXh0MkZvckNhdXNhbExNJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNwZWVjaDJUZXh0MiUyMHMydF90cmFuc2Zvcm1lcl9zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFNwZWVjaDJUZXh0MkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzMnRfdHJhbnNmb3JtZXJfcyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoMlRleHQyRm9yQ2F1c2FsTE0oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Config, Speech2Text2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Speech2Text2 s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Speech2Text2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the s2t_transformer_s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Speech2Text2ForCausalLM(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=l("p"),c.textContent=k,T=n(),m(y.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=k),T=s(d),h(y.$$.fragment,d)},m(d,w){r(d,c,w),r(d,T,w),f(y,d,w),v=!0},p:$t,i(d){v||(u(y.$$.fragment,d),v=!0)},o(d){g(y.$$.fragment,d),v=!1},d(d){d&&(t(c),t(T)),_(y,d)}}}function Go(Z){let c,k=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=k},l(T){c=i(T,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1ob8jsn"&&(c.innerHTML=k)},m(T,y){r(T,c,y)},p:$t,d(T){T&&t(c)}}}function No(Z){let c,k=`This class method is simply calling <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=k},l(T){c=i(T,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1qvfzw2"&&(c.innerHTML=k)},m(T,y){r(T,c,y)},p:$t,d(T){T&&t(c)}}}function Eo(Z){let c,k="Example:",T,y,v;return y=new wt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    SpeechEncoderDecoderModel,
<span class="hljs-meta">... </span>    Speech2Text2ForCausalLM,
<span class="hljs-meta">... </span>    Wav2Vec2Model,
<span class="hljs-meta">... </span>    Speech2Text2Config,
<span class="hljs-meta">... </span>    Wav2Vec2Config,
<span class="hljs-meta">... </span>    Wav2Vec2FeatureExtractor,
<span class="hljs-meta">... </span>    Speech2Text2Tokenizer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = Wav2Vec2FeatureExtractor()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = Speech2Text2Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = Wav2Vec2Model(Wav2Vec2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = Speech2Text2ForCausalLM(Speech2Text2Config())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init random speech2text model</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel(encoder=encoder, decoder=decoder)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = tokenizer.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.decoder_start_token_id = tokenizer.bos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pre-process inputs and labels</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(inputs=input_values, labels=decoder_input_ids).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># backprop loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){c=l("p"),c.textContent=k,T=n(),m(y.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=k),T=s(d),h(y.$$.fragment,d)},m(d,w){r(d,c,w),r(d,T,w),f(y,d,w),v=!0},p:$t,i(d){v||(u(y.$$.fragment,d),v=!0)},o(d){g(y.$$.fragment,d),v=!1},d(d){d&&(t(c),t(T)),_(y,d)}}}function Ro(Z){let c,k,T,y,v,d,w,Qe,Q,oo=`The Speech2Text2 model is used together with <a href="wav2vec2">Wav2Vec2</a> for Speech Translation models proposed in
<a href="https://arxiv.org/abs/2104.06678" rel="nofollow">Large-Scale Self- and Semi-Supervised Learning for Speech Translation</a> by
Changhan Wang, Anne Wu, Juan Pino, Alexei Baevski, Michael Auli, Alexis Conneau.`,De,D,no=`Speech2Text2 is a <em>decoder-only</em> transformer model that can be used with any speech <em>encoder-only</em>, such as
<a href="wav2vec2">Wav2Vec2</a> or <a href="hubert">HuBERT</a> for Speech-to-Text tasks. Please refer to the
<a href="speech-encoder-decoder">SpeechEncoderDecoder</a> class on how to combine Speech2Text2 with any speech <em>encoder-only</em>
model.`,Ae,A,so='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">Patrick von Platen</a>.',Oe,O,ao='The original code can be found <a href="https://github.com/pytorch/fairseq/blob/1f7ef9ed1e1061f8c7f88f8b94c7186834398690/fairseq/models/wav2vec/wav2vec2_asr.py#L266" rel="nofollow">here</a>.',Ke,K,ro="Tips:",et,ee,lo=`<li>Speech2Text2 achieves state-of-the-art results on the CoVoST Speech Translation dataset. For more information, see
the <a href="https://huggingface.co/models?other=speech2text2" rel="nofollow">official models</a> .</li> <li>Speech2Text2 is always used within the <a href="speech-encoder-decoder">SpeechEncoderDecoder</a> framework.</li> <li>Speech2Text2’s tokenizer is based on <a href="https://github.com/glample/fastBPE" rel="nofollow">fastBPE</a>.</li>`,tt,te,ot,oe,io=`Speech2Text2’s <a href="/docs/transformers/main/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> model accepts raw waveform input values from speech and
makes use of <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> to translate the input speech
autoregressively to the target language.`,nt,ne,co=`The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> class is responsible for preprocessing the input speech and
<a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> decodes the generated target tokens to the target string. The
<a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> wraps <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> and
<a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> into a single instance to both extract the input features and decode the
predicted token ids.`,st,se,po="<li>Step-by-step Speech Translation</li>",at,ae,rt,re,mo="<li><p>Speech Translation via Pipelines</p> <p>The automatic speech recognition pipeline can also be used to translate speech in just a couple lines of code</p></li>",lt,le,it,ie,ho='See <a href="https://huggingface.co/models?filter=speech2text2" rel="nofollow">model hub</a> to look for Speech2Text2 checkpoints.',ct,ce,dt,de,fo='<li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',pt,pe,mt,C,me,jt,Ce,uo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a>. It is used to
instantiate an Speech2Text2 model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Speech2Text2
<a href="https://huggingface.co/facebook/s2t-wav2vec2-large-en-de" rel="nofollow">facebook/s2t-wav2vec2-large-en-de</a> architecture.`,Jt,Se,go=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ct,L,ht,he,ft,x,fe,St,ze,_o="Constructs a Speech2Text2Tokenizer.",zt,Ue,To=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains some of the main methods. Users should refer to
the superclass for more information regarding such methods.`,Ut,B,ue,Zt,Ze,yo="Convert a list of lists of token ids into a list of strings by calling decode.",Wt,W,ge,Ft,We,bo=`Converts a sequence of ids in a string, using the tokenizer and vocabulary with options to remove special
tokens and clean up tokenization spaces.`,Vt,Fe,vo="Similar to doing <code>self.convert_tokens_to_string(self.convert_ids_to_tokens(token_ids))</code>.",It,Ve,_e,ut,Te,gt,b,ye,Lt,Ie,xo=`Constructs a Speech2Text2 processor which wraps a Speech2Text2 feature extractor and a Speech2Text2 tokenizer into
a single processor.`,Bt,Le,ko=`<a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> and <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>.
See the <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor.decode">decode()</a> for more information.`,Gt,G,be,Nt,Be,Mo=`When used in normal mode, this method forwards all its arguments to AutoFeatureExtractor’s
<code>__call__()</code> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Speech2Text2Tokenizer’s <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__"><strong>call</strong>()</a>. Please refer to the doctsring of the above two
methods for more information.`,Et,F,ve,Rt,Ge,wo="Instantiate a processor associated with a pretrained model.",qt,N,Ht,V,xe,Xt,Ne,$o=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Processor.from_pretrained">from_pretrained()</a> method.`,Pt,E,Yt,R,ke,Qt,Ee,jo=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Dt,q,Me,At,Re,Jo=`This method forwards all its arguments to Speech2Text2Tokenizer’s <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.decode">decode()</a>. Please refer
to the docstring of this method for more information.`,_t,we,Tt,S,$e,Ot,qe,Co=`The Speech2Text2 Decoder with a language modeling head. Can be used as the decoder part of <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> and <code>SpeechEncoderDecoder</code>.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Kt,He,So=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,eo,H,je,to,X,yt,Ye,bt;return v=new Y({props:{title:"Speech2Text2",local:"speech2text2",headingTag:"h1"}}),w=new Y({props:{title:"Overview",local:"overview",headingTag:"h2"}}),te=new Y({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ae=new wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU3BlZWNoMlRleHQyUHJvY2Vzc29yJTJDJTIwU3BlZWNoRW5jb2RlckRlY29kZXJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFtb2RlbCUyMCUzRCUyMFNwZWVjaEVuY29kZXJEZWNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaDJUZXh0MlByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzMnQtd2F2MnZlYzItbGFyZ2UtZW4tZGUlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0cyU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCUyQyUyMGF0dGVudGlvbl9tYXNrJTNEaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Speech2Text2Processor, SpeechEncoderDecoderModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Speech2Text2Processor.from_pretrained(<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=inputs[<span class="hljs-string">&quot;input_values&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids)`,wrap:!1}}),le=new wt({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbGlicmlzcGVlY2hfZW4lMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGczJ0LXdhdjJ2ZWMyLWxhcmdlLWVuLWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0QlMjJmYWNlYm9vayUyRnMydC13YXYydmVjMi1sYXJnZS1lbi1kZSUyMiUyQyUwQSklMEElMEF0cmFuc2xhdGlvbl9kZSUyMCUzRCUyMGFzcihsaWJyaXNwZWVjaF9lbiU1QjAlNUQlNUIlMjJmaWxlJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_en = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>    feature_extractor=<span class="hljs-string">&quot;facebook/s2t-wav2vec2-large-en-de&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_de = asr(librispeech_en[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;file&quot;</span>])`,wrap:!1}}),ce=new Y({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),pe=new Y({props:{title:"Speech2Text2Config",local:"transformers.Speech2Text2Config",headingTag:"h2"}}),me=new z({props:{name:"class transformers.Speech2Text2Config",anchor:"transformers.Speech2Text2Config",parameters:[{name:"vocab_size",val:" = 10000"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 4"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 2"},{name:"scale_embedding",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"max_target_positions",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50265) &#x2014;
Vocabulary size of the Speech2Text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a>`,name:"vocab_size"},{anchor:"transformers.Speech2Text2Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.Speech2Text2Config.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.Speech2Text2Config.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.Speech2Text2Config.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.Speech2Text2Config.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the pooler. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.Speech2Text2Config.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, and pooler.`,name:"dropout"},{anchor:"transformers.Speech2Text2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Speech2Text2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.Speech2Text2Config.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.
<a href="https://arxiv.org/abs/1909.11556%3E%60" rel="nofollow">https://arxiv.org/abs/1909.11556&gt;\`</a>__ for more details.`,name:"init_std"},{anchor:"transformers.Speech2Text2Config.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.Speech2Text2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.Speech2Text2Config.max_target_positions",description:`<strong>max_target_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_target_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/configuration_speech_to_text_2.py#L31"}}),L=new Zo({props:{anchor:"transformers.Speech2Text2Config.example",$$slots:{default:[Bo]},$$scope:{ctx:Z}}}),he=new Y({props:{title:"Speech2TextTokenizer",local:"transformers.Speech2Text2Tokenizer",headingTag:"h2"}}),fe=new z({props:{name:"class transformers.Speech2Text2Tokenizer",anchor:"transformers.Speech2Text2Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"do_lower_case",val:" = False"},{name:"merges_file",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.Speech2Text2Tokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sentence token.`,name:"bos_token"},{anchor:"transformers.Speech2Text2Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sentence token.`,name:"eos_token"},{anchor:"transformers.Speech2Text2Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.Speech2Text2Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.</p>
<p>**kwargs &#x2014;
Additional keyword arguments passed along to <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>`,name:"pad_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/tokenization_speech_to_text_2.py#L73"}}),ue=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Tokenizer.batch_decode",parameters:[{name:"sequences",val:": typing.Union[typing.List[int], typing.List[typing.List[int]], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), ForwardRef('tf.Tensor')]"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded sentences.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ge=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Tokenizer.decode",parameters:[{name:"token_ids",val:": typing.Union[int, typing.List[int], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), ForwardRef('tf.Tensor')]"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Tokenizer.decode.token_ids",description:`<strong>token_ids</strong> (<code>Union[int, List[int], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"token_ids"},{anchor:"transformers.Speech2Text2Tokenizer.decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Speech2Text2Tokenizer.decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Speech2Text2Tokenizer.decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3716",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded sentence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),_e=new z({props:{name:"save_vocabulary",anchor:"transformers.Speech2Text2Tokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/tokenization_speech_to_text_2.py#L240"}}),Te=new Y({props:{title:"Speech2Text2Processor",local:"transformers.Speech2Text2Processor",headingTag:"h2"}}),ye=new z({props:{name:"class transformers.Speech2Text2Processor",anchor:"transformers.Speech2Text2Processor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>AutoFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Speech2Text2Processor.tokenizer",description:`<strong>tokenizer</strong> (<code>Speech2Text2Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L24"}}),be=new z({props:{name:"__call__",anchor:"transformers.Speech2Text2Processor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L46"}}),ve=new z({props:{name:"from_pretrained",anchor:"transformers.Speech2Text2Processor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L168"}}),N=new Uo({props:{$$slots:{default:[Go]},$$scope:{ctx:Z}}}),xe=new z({props:{name:"save_pretrained",anchor:"transformers.Speech2Text2Processor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2Processor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.Speech2Text2Processor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L93"}}),E=new Uo({props:{$$slots:{default:[No]},$$scope:{ctx:Z}}}),ke=new z({props:{name:"batch_decode",anchor:"transformers.Speech2Text2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L85"}}),Me=new z({props:{name:"decode",anchor:"transformers.Speech2Text2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/processing_speech_to_text_2.py#L92"}}),we=new Y({props:{title:"Speech2Text2ForCausalLM",local:"transformers.Speech2Text2ForCausalLM",headingTag:"h2"}}),$e=new z({props:{name:"class transformers.Speech2Text2ForCausalLM",anchor:"transformers.Speech2Text2ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/modeling_speech_to_text_2.py#L695"}}),je=new z({props:{name:"forward",anchor:"transformers.Speech2Text2ForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Speech2Text2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used
in the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:`,name:"encoder_attention_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"use_cache"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Speech2Text2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/speech_to_text_2/modeling_speech_to_text_2.py#L728",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config"
>Speech2Text2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Zo({props:{anchor:"transformers.Speech2Text2ForCausalLM.forward.example",$$slots:{default:[Eo]},$$scope:{ctx:Z}}}),{c(){c=l("meta"),k=n(),T=l("p"),y=n(),m(v.$$.fragment),d=n(),m(w.$$.fragment),Qe=n(),Q=l("p"),Q.innerHTML=oo,De=n(),D=l("p"),D.innerHTML=no,Ae=n(),A=l("p"),A.innerHTML=so,Oe=n(),O=l("p"),O.innerHTML=ao,Ke=n(),K=l("p"),K.textContent=ro,et=n(),ee=l("ul"),ee.innerHTML=lo,tt=n(),m(te.$$.fragment),ot=n(),oe=l("p"),oe.innerHTML=io,nt=n(),ne=l("p"),ne.innerHTML=co,st=n(),se=l("ul"),se.innerHTML=po,at=n(),m(ae.$$.fragment),rt=n(),re=l("ul"),re.innerHTML=mo,lt=n(),m(le.$$.fragment),it=n(),ie=l("p"),ie.innerHTML=ho,ct=n(),m(ce.$$.fragment),dt=n(),de=l("ul"),de.innerHTML=fo,pt=n(),m(pe.$$.fragment),mt=n(),C=l("div"),m(me.$$.fragment),jt=n(),Ce=l("p"),Ce.innerHTML=uo,Jt=n(),Se=l("p"),Se.innerHTML=go,Ct=n(),m(L.$$.fragment),ht=n(),m(he.$$.fragment),ft=n(),x=l("div"),m(fe.$$.fragment),St=n(),ze=l("p"),ze.textContent=_o,zt=n(),Ue=l("p"),Ue.innerHTML=To,Ut=n(),B=l("div"),m(ue.$$.fragment),Zt=n(),Ze=l("p"),Ze.textContent=yo,Wt=n(),W=l("div"),m(ge.$$.fragment),Ft=n(),We=l("p"),We.textContent=bo,Vt=n(),Fe=l("p"),Fe.innerHTML=vo,It=n(),Ve=l("div"),m(_e.$$.fragment),ut=n(),m(Te.$$.fragment),gt=n(),b=l("div"),m(ye.$$.fragment),Lt=n(),Ie=l("p"),Ie.textContent=xo,Bt=n(),Le=l("p"),Le.innerHTML=ko,Gt=n(),G=l("div"),m(be.$$.fragment),Nt=n(),Be=l("p"),Be.innerHTML=Mo,Et=n(),F=l("div"),m(ve.$$.fragment),Rt=n(),Ge=l("p"),Ge.textContent=wo,qt=n(),m(N.$$.fragment),Ht=n(),V=l("div"),m(xe.$$.fragment),Xt=n(),Ne=l("p"),Ne.innerHTML=$o,Pt=n(),m(E.$$.fragment),Yt=n(),R=l("div"),m(ke.$$.fragment),Qt=n(),Ee=l("p"),Ee.innerHTML=jo,Dt=n(),q=l("div"),m(Me.$$.fragment),At=n(),Re=l("p"),Re.innerHTML=Jo,_t=n(),m(we.$$.fragment),Tt=n(),S=l("div"),m($e.$$.fragment),Ot=n(),qe=l("p"),qe.innerHTML=Co,Kt=n(),He=l("p"),He.innerHTML=So,eo=n(),H=l("div"),m(je.$$.fragment),to=n(),m(X.$$.fragment),yt=n(),Ye=l("p"),this.h()},l(e){const o=Lo("svelte-u9bgzb",document.head);c=i(o,"META",{name:!0,content:!0}),o.forEach(t),k=s(e),T=i(e,"P",{}),j(T).forEach(t),y=s(e),h(v.$$.fragment,e),d=s(e),h(w.$$.fragment,e),Qe=s(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1q6drml"&&(Q.innerHTML=oo),De=s(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-iqjgnk"&&(D.innerHTML=no),Ae=s(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-pps277"&&(A.innerHTML=so),Oe=s(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1u4lnwc"&&(O.innerHTML=ao),Ke=s(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-axv494"&&(K.textContent=ro),et=s(e),ee=i(e,"UL",{"data-svelte-h":!0}),p(ee)!=="svelte-1gpn7jr"&&(ee.innerHTML=lo),tt=s(e),h(te.$$.fragment,e),ot=s(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-21n52g"&&(oe.innerHTML=io),nt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1cwi16t"&&(ne.innerHTML=co),st=s(e),se=i(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-acy5fb"&&(se.innerHTML=po),at=s(e),h(ae.$$.fragment,e),rt=s(e),re=i(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-eepefx"&&(re.innerHTML=mo),lt=s(e),h(le.$$.fragment,e),it=s(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1lbi5m8"&&(ie.innerHTML=ho),ct=s(e),h(ce.$$.fragment,e),dt=s(e),de=i(e,"UL",{"data-svelte-h":!0}),p(de)!=="svelte-162aebv"&&(de.innerHTML=fo),pt=s(e),h(pe.$$.fragment,e),mt=s(e),C=i(e,"DIV",{class:!0});var U=j(C);h(me.$$.fragment,U),jt=s(U),Ce=i(U,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1241j52"&&(Ce.innerHTML=uo),Jt=s(U),Se=i(U,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-o55m63"&&(Se.innerHTML=go),Ct=s(U),h(L.$$.fragment,U),U.forEach(t),ht=s(e),h(he.$$.fragment,e),ft=s(e),x=i(e,"DIV",{class:!0});var $=j(x);h(fe.$$.fragment,$),St=s($),ze=i($,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-16s7215"&&(ze.textContent=_o),zt=s($),Ue=i($,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1tlp8g2"&&(Ue.innerHTML=To),Ut=s($),B=i($,"DIV",{class:!0});var Je=j(B);h(ue.$$.fragment,Je),Zt=s(Je),Ze=i(Je,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1deng2j"&&(Ze.textContent=yo),Je.forEach(t),Wt=s($),W=i($,"DIV",{class:!0});var I=j(W);h(ge.$$.fragment,I),Ft=s(I),We=i(I,"P",{"data-svelte-h":!0}),p(We)!=="svelte-vbfkpu"&&(We.textContent=bo),Vt=s(I),Fe=i(I,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-125uxon"&&(Fe.innerHTML=vo),I.forEach(t),It=s($),Ve=i($,"DIV",{class:!0});var zo=j(Ve);h(_e.$$.fragment,zo),zo.forEach(t),$.forEach(t),ut=s(e),h(Te.$$.fragment,e),gt=s(e),b=i(e,"DIV",{class:!0});var M=j(b);h(ye.$$.fragment,M),Lt=s(M),Ie=i(M,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-cccwan"&&(Ie.textContent=xo),Bt=s(M),Le=i(M,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-uxbioi"&&(Le.innerHTML=ko),Gt=s(M),G=i(M,"DIV",{class:!0});var vt=j(G);h(be.$$.fragment,vt),Nt=s(vt),Be=i(vt,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1xm4s9k"&&(Be.innerHTML=Mo),vt.forEach(t),Et=s(M),F=i(M,"DIV",{class:!0});var Xe=j(F);h(ve.$$.fragment,Xe),Rt=s(Xe),Ge=i(Xe,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1cj8dcb"&&(Ge.textContent=wo),qt=s(Xe),h(N.$$.fragment,Xe),Xe.forEach(t),Ht=s(M),V=i(M,"DIV",{class:!0});var Pe=j(V);h(xe.$$.fragment,Pe),Xt=s(Pe),Ne=i(Pe,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-y5isdl"&&(Ne.innerHTML=$o),Pt=s(Pe),h(E.$$.fragment,Pe),Pe.forEach(t),Yt=s(M),R=i(M,"DIV",{class:!0});var xt=j(R);h(ke.$$.fragment,xt),Qt=s(xt),Ee=i(xt,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-ez4wef"&&(Ee.innerHTML=jo),xt.forEach(t),Dt=s(M),q=i(M,"DIV",{class:!0});var kt=j(q);h(Me.$$.fragment,kt),At=s(kt),Re=i(kt,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-144thod"&&(Re.innerHTML=Jo),kt.forEach(t),M.forEach(t),_t=s(e),h(we.$$.fragment,e),Tt=s(e),S=i(e,"DIV",{class:!0});var P=j(S);h($e.$$.fragment,P),Ot=s(P),qe=i(P,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-kknl4p"&&(qe.innerHTML=Co),Kt=s(P),He=i(P,"P",{"data-svelte-h":!0}),p(He)!=="svelte-hswkmf"&&(He.innerHTML=So),eo=s(P),H=i(P,"DIV",{class:!0});var Mt=j(H);h(je.$$.fragment,Mt),to=s(Mt),h(X.$$.fragment,Mt),Mt.forEach(t),P.forEach(t),yt=s(e),Ye=i(e,"P",{}),j(Ye).forEach(t),this.h()},h(){J(c,"name","hf:doc:metadata"),J(c,"content",qo),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,c),r(e,k,o),r(e,T,o),r(e,y,o),f(v,e,o),r(e,d,o),f(w,e,o),r(e,Qe,o),r(e,Q,o),r(e,De,o),r(e,D,o),r(e,Ae,o),r(e,A,o),r(e,Oe,o),r(e,O,o),r(e,Ke,o),r(e,K,o),r(e,et,o),r(e,ee,o),r(e,tt,o),f(te,e,o),r(e,ot,o),r(e,oe,o),r(e,nt,o),r(e,ne,o),r(e,st,o),r(e,se,o),r(e,at,o),f(ae,e,o),r(e,rt,o),r(e,re,o),r(e,lt,o),f(le,e,o),r(e,it,o),r(e,ie,o),r(e,ct,o),f(ce,e,o),r(e,dt,o),r(e,de,o),r(e,pt,o),f(pe,e,o),r(e,mt,o),r(e,C,o),f(me,C,null),a(C,jt),a(C,Ce),a(C,Jt),a(C,Se),a(C,Ct),f(L,C,null),r(e,ht,o),f(he,e,o),r(e,ft,o),r(e,x,o),f(fe,x,null),a(x,St),a(x,ze),a(x,zt),a(x,Ue),a(x,Ut),a(x,B),f(ue,B,null),a(B,Zt),a(B,Ze),a(x,Wt),a(x,W),f(ge,W,null),a(W,Ft),a(W,We),a(W,Vt),a(W,Fe),a(x,It),a(x,Ve),f(_e,Ve,null),r(e,ut,o),f(Te,e,o),r(e,gt,o),r(e,b,o),f(ye,b,null),a(b,Lt),a(b,Ie),a(b,Bt),a(b,Le),a(b,Gt),a(b,G),f(be,G,null),a(G,Nt),a(G,Be),a(b,Et),a(b,F),f(ve,F,null),a(F,Rt),a(F,Ge),a(F,qt),f(N,F,null),a(b,Ht),a(b,V),f(xe,V,null),a(V,Xt),a(V,Ne),a(V,Pt),f(E,V,null),a(b,Yt),a(b,R),f(ke,R,null),a(R,Qt),a(R,Ee),a(b,Dt),a(b,q),f(Me,q,null),a(q,At),a(q,Re),r(e,_t,o),f(we,e,o),r(e,Tt,o),r(e,S,o),f($e,S,null),a(S,Ot),a(S,qe),a(S,Kt),a(S,He),a(S,eo),a(S,H),f(je,H,null),a(H,to),f(X,H,null),r(e,yt,o),r(e,Ye,o),bt=!0},p(e,[o]){const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),L.$set(U);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),N.$set($);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),E.$set(Je);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),X.$set(I)},i(e){bt||(u(v.$$.fragment,e),u(w.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(L.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(N.$$.fragment,e),u(xe.$$.fragment,e),u(E.$$.fragment,e),u(ke.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(je.$$.fragment,e),u(X.$$.fragment,e),bt=!0)},o(e){g(v.$$.fragment,e),g(w.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(L.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(N.$$.fragment,e),g(xe.$$.fragment,e),g(E.$$.fragment,e),g(ke.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(X.$$.fragment,e),bt=!1},d(e){e&&(t(k),t(T),t(y),t(d),t(Qe),t(Q),t(De),t(D),t(Ae),t(A),t(Oe),t(O),t(Ke),t(K),t(et),t(ee),t(tt),t(ot),t(oe),t(nt),t(ne),t(st),t(se),t(at),t(rt),t(re),t(lt),t(it),t(ie),t(ct),t(dt),t(de),t(pt),t(mt),t(C),t(ht),t(ft),t(x),t(ut),t(gt),t(b),t(_t),t(Tt),t(S),t(yt),t(Ye)),t(c),_(v,e),_(w,e),_(te,e),_(ae,e),_(le,e),_(ce,e),_(pe,e),_(me),_(L),_(he,e),_(fe),_(ue),_(ge),_(_e),_(Te,e),_(ye),_(be),_(ve),_(N),_(xe),_(E),_(ke),_(Me),_(we,e),_($e),_(je),_(X)}}}const qo='{"title":"Speech2Text2","local":"speech2text2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"Speech2Text2Config","local":"transformers.Speech2Text2Config","sections":[],"depth":2},{"title":"Speech2TextTokenizer","local":"transformers.Speech2Text2Tokenizer","sections":[],"depth":2},{"title":"Speech2Text2Processor","local":"transformers.Speech2Text2Processor","sections":[],"depth":2},{"title":"Speech2Text2ForCausalLM","local":"transformers.Speech2Text2ForCausalLM","sections":[],"depth":2}],"depth":1}';function Ho(Z){return Fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ko extends Vo{constructor(c){super(),Io(this,c,Ho,Ro,Wo,{})}}export{Ko as component};
