import{s as Ta,o as Ca,n as Vt}from"../chunks/scheduler.9bc65507.js";import{S as Pa,i as Ua,g as l,s as r,r as p,A as Ia,h as i,f as t,c as a,j as x,u as f,x as d,k as $,y as n,a as o,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as Ir}from"../chunks/Tip.c2ecdbf4.js";import{D as w}from"../chunks/Docstring.17db21ae.js";import{C as Et}from"../chunks/CodeBlock.54a9f38d.js";import{E as kr}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as ie}from"../chunks/Heading.342b1fa6.js";function ka(X){let m,y=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){m=l("p"),m.innerHTML=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-1ob8jsn"&&(m.innerHTML=y)},m(v,b){o(v,m,b)},p:Vt,d(v){v&&t(m)}}}function Xa(X){let m,y="Examples:",v,b,M;return b=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBcHJvY2Vzc29yLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBwcm9jZXNzb3IlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=r(),p(b.$$.fragment)},l(c){m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-kvfsh7"&&(m.textContent=y),v=a(c),f(b.$$.fragment,c)},m(c,C){o(c,m,C),o(c,v,C),u(b,c,C),M=!0},p:Vt,i(c){M||(h(b.$$.fragment,c),M=!0)},o(c){g(b.$$.fragment,c),M=!1},d(c){c&&(t(m),t(v)),_(b,c)}}}function Za(X){let m,y="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){m=l("p"),m.textContent=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-15rpg4"&&(m.textContent=y)},m(v,b){o(v,m,b)},p:Vt,d(v){v&&t(m)}}}function Ja(X){let m,y=`This class method is simply calling <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){m=l("p"),m.innerHTML=y},l(v){m=i(v,"P",{"data-svelte-h":!0}),d(m)!=="svelte-1qvfzw2"&&(m.innerHTML=y)},m(v,b){o(v,m,b)},p:Vt,d(v){v&&t(m)}}}function La(X){let m,y="Examples:",v,b,M;return b=new Et({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=r(),p(b.$$.fragment)},l(c){m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-kvfsh7"&&(m.textContent=y),v=a(c),f(b.$$.fragment,c)},m(c,C){o(c,m,C),o(c,v,C),u(b,c,C),M=!0},p:Vt,i(c){M||(h(b.$$.fragment,c),M=!0)},o(c){g(b.$$.fragment,c),M=!1},d(c){c&&(t(m),t(v)),_(b,c)}}}function ja(X){let m,y="Example:",v,b,M;return b=new Et({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){m=l("p"),m.textContent=y,v=r(),p(b.$$.fragment)},l(c){m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-11lpom8"&&(m.textContent=y),v=a(c),f(b.$$.fragment,c)},m(c,C){o(c,m,C),o(c,v,C),u(b,c,C),M=!0},p:Vt,i(c){M||(h(b.$$.fragment,c),M=!0)},o(c){g(b.$$.fragment,c),M=!1},d(c){c&&(t(m),t(v)),_(b,c)}}}function qa(X){let m,y,v,b,M,c,C,Xr="Processors can mean two different things in the Transformers library:",Ht,me,Zr=`<li>the objects that pre-process inputs for multi-modal models such as <a href="../model_doc/wav2vec2">Wav2Vec2</a> (speech and text)
or <a href="../model_doc/clip">CLIP</a> (text and vision)</li> <li>deprecated objects that were used in older versions of the library to preprocess data for GLUE or SQUAD.</li>`,Bt,de,Ft,ce,Jr=`Any multi-modal model will require an object to encode or decode the data that groups several modalities (among text,
vision and audio). This is handled by objects called processors, which group together two or more processing objects
such as tokenizers (for the text modality), image processors (for vision) and feature extractors (for audio).`,Nt,pe,Lr="Those processors inherit from the following base class that implements the saving and loading functionality:",Gt,U,fe,Hs,ct,jr="This is a mixin used to provide saving/loading functionality for all processor classes.",Bs,j,ue,Fs,pt,qr="Instantiate a processor associated with a pretrained model.",Ns,W,Gs,q,he,Ss,ft,Vr="Upload the processor files to the 🤗 Model Hub.",Ws,R,Rs,V,ge,Qs,ut,zr=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Ds,Q,As,z,_e,Ys,ht,Er=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5Processor.from_pretrained">from_pretrained()</a> method.`,Os,D,St,ve,Wt,be,Hr=`All processors follow the same architecture which is that of the
<a href="/docs/transformers/main/en/main_classes/processors#transformers.DataProcessor">DataProcessor</a>. The processor returns a list of
<a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a>. These
<a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a> can be converted to
<a href="/docs/transformers/main/en/main_classes/processors#transformers.InputFeatures">InputFeatures</a> in order to be fed to the model.`,Rt,T,xe,Ks,gt,Br="Base class for data converters for sequence classification data sets.",er,A,$e,tr,_t,Fr='Gets a collection of <a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',sr,Y,ye,rr,vt,Nr="Gets an example from a dict with tensorflow tensors.",ar,O,Me,or,bt,Gr="Gets the list of labels for this data set.",nr,K,we,lr,xt,Sr='Gets a collection of <a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',ir,ee,Te,mr,$t,Wr='Gets a collection of <a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',dr,te,Ce,cr,yt,Rr=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,Qt,Z,Pe,pr,Mt,Qr="A single training/test example for simple sequence classification.",fr,se,Ue,ur,wt,Dr="Serializes this instance to a JSON string.",Dt,J,Ie,hr,Tt,Ar="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",gr,re,ke,_r,Ct,Yr="Serializes this instance to a JSON string.",At,Xe,Yt,Ze,Or=`<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> is a benchmark that evaluates the
performance of models across a diverse set of existing NLU tasks. It was released together with the paper <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
multi-task benchmark and analysis platform for natural language understanding</a>`,Ot,Je,Kr=`This library hosts a total of 10 processors for the following tasks: MRPC, MNLI, MNLI (mismatched), CoLA, SST2, STSB,
QQP, QNLI, RTE and WNLI.`,Kt,Le,ea="Those processors are:",es,je,ta="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",ts,qe,sa=`Additionally, the following method can be used to load values from a data file and convert them to a list of
<a href="/docs/transformers/main/en/main_classes/processors#transformers.InputExample">InputExample</a>.`,ss,B,Ve,vr,Pt,ra="Loads a data file into a list of <code>InputFeatures</code>",rs,ze,as,Ee,aa=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">The Cross-Lingual NLI Corpus (XNLI)</a> is a benchmark that evaluates the
quality of cross-lingual text representations. XNLI is crowd-sourced dataset based on <a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>: pairs of text are labeled with textual entailment annotations for 15
different languages (including both high-resource language such as English and low-resource languages such as Swahili).`,os,He,oa='It was released together with the paper <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a>',ns,Be,na="This library hosts the processor to load the XNLI data:",ls,Fe,la="<li><code>~data.processors.utils.XnliProcessor</code></li>",is,Ne,ia="Please note that since the gold labels are available on the test set, evaluation is performed on the test set.",ms,Ge,ma='An example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> script.',ds,Se,cs,We,da=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> is a benchmark that
evaluates the performance of models on question answering. Two versions are available, v1.1 and v2.0. The first version
(v1.1) was released together with the paper <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a>. The second version (v2.0) was released alongside the paper <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t
Know: Unanswerable Questions for SQuAD</a>.`,ps,Re,ca="This library hosts a processor for each of the two versions:",fs,Qe,us,De,pa="Those processors are:",hs,Ae,fa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",gs,Ye,ua="They both inherit from the abstract class <code>~data.processors.utils.SquadProcessor</code>",_s,I,Oe,br,Ut,ha=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,xr,ae,Ke,$r,It,ga="Returns the evaluation example from the data directory.",yr,E,et,Mr,kt,_a="Creates a list of <code>SquadExample</code> using a TFDS dataset.",wr,oe,Tr,ne,tt,Cr,Xt,va="Returns the training examples from the data directory.",vs,st,ba=`Additionally, the following method can be used to convert SQuAD examples into
<code>~data.processors.utils.SquadFeatures</code> that can be used as model inputs.`,bs,L,rt,Pr,Zt,xa=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,Ur,le,xs,at,$a=`These processors as well as the aforementioned method can be used with files containing the data as well as with the
<em>tensorflow_datasets</em> package. Examples are given below.`,$s,ot,ys,nt,ya="Here is an example using the processors as well as the conversion method using data files:",Ms,lt,ws,it,Ma="Using <em>tensorflow_datasets</em> is as easy as using a data file:",Ts,mt,Cs,dt,wa='Another example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> script.',Ps,zt,Us;return M=new ie({props:{title:"Processors",local:"processors",headingTag:"h1"}}),de=new ie({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),fe=new w({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L42"}}),ue=new w({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L168"}}),W=new Ir({props:{$$slots:{default:[ka]},$$scope:{ctx:X}}}),he=new w({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": typing.Optional[bool] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = False"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L791"}}),R=new kr({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Xa]},$$scope:{ctx:X}}}),ge=new w({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L231"}}),Q=new Ir({props:{warning:!0,$$slots:{default:[Za]},$$scope:{ctx:X}}}),_e=new w({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L93"}}),D=new Ir({props:{$$slots:{default:[Ja]},$$scope:{ctx:X}}}),ve=new ie({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),xe=new w({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L80"}}),$e=new w({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L97"}}),ye=new w({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L83"}}),Me=new w({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L105"}}),we=new w({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L101"}}),Te=new w({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L93"}}),Ce=new w({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L109"}}),Pe=new w({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": typing.Optional[str] = None"},{name:"label",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L30"}}),Ue=new w({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L49"}}),Ie=new w({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": typing.List[int]"},{name:"attention_mask",val:": typing.Optional[typing.List[int]] = None"},{name:"token_type_ids",val:": typing.Optional[typing.List[int]] = None"},{name:"label",val:": typing.Union[int, float, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L55"}}),ke=new w({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L75"}}),Xe=new ie({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ve=new w({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": typing.Union[typing.List[transformers.data.processors.utils.InputExample], ForwardRef('tf.data.Dataset')]"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),ze=new ie({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),Se=new ie({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),Qe=new ie({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),Oe=new w({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L541"}}),Ke=new w({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L629"}}),et=new w({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),oe=new kr({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[La]},$$scope:{ctx:X}}}),tt=new w({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L607"}}),rt=new w({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),le=new kr({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[ja]},$$scope:{ctx:X}}}),ot=new ie({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),lt=new Et({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),mt=new Et({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){m=l("meta"),y=r(),v=l("p"),b=r(),p(M.$$.fragment),c=r(),C=l("p"),C.textContent=Xr,Ht=r(),me=l("ul"),me.innerHTML=Zr,Bt=r(),p(de.$$.fragment),Ft=r(),ce=l("p"),ce.textContent=Jr,Nt=r(),pe=l("p"),pe.textContent=Lr,Gt=r(),U=l("div"),p(fe.$$.fragment),Hs=r(),ct=l("p"),ct.textContent=jr,Bs=r(),j=l("div"),p(ue.$$.fragment),Fs=r(),pt=l("p"),pt.textContent=qr,Ns=r(),p(W.$$.fragment),Gs=r(),q=l("div"),p(he.$$.fragment),Ss=r(),ft=l("p"),ft.textContent=Vr,Ws=r(),p(R.$$.fragment),Rs=r(),V=l("div"),p(ge.$$.fragment),Qs=r(),ut=l("p"),ut.innerHTML=zr,Ds=r(),p(Q.$$.fragment),As=r(),z=l("div"),p(_e.$$.fragment),Ys=r(),ht=l("p"),ht.innerHTML=Er,Os=r(),p(D.$$.fragment),St=r(),p(ve.$$.fragment),Wt=r(),be=l("p"),be.innerHTML=Hr,Rt=r(),T=l("div"),p(xe.$$.fragment),Ks=r(),gt=l("p"),gt.textContent=Br,er=r(),A=l("div"),p($e.$$.fragment),tr=r(),_t=l("p"),_t.innerHTML=Fr,sr=r(),Y=l("div"),p(ye.$$.fragment),rr=r(),vt=l("p"),vt.textContent=Nr,ar=r(),O=l("div"),p(Me.$$.fragment),or=r(),bt=l("p"),bt.textContent=Gr,nr=r(),K=l("div"),p(we.$$.fragment),lr=r(),xt=l("p"),xt.innerHTML=Sr,ir=r(),ee=l("div"),p(Te.$$.fragment),mr=r(),$t=l("p"),$t.innerHTML=Wr,dr=r(),te=l("div"),p(Ce.$$.fragment),cr=r(),yt=l("p"),yt.textContent=Rr,Qt=r(),Z=l("div"),p(Pe.$$.fragment),pr=r(),Mt=l("p"),Mt.textContent=Qr,fr=r(),se=l("div"),p(Ue.$$.fragment),ur=r(),wt=l("p"),wt.textContent=Dr,Dt=r(),J=l("div"),p(Ie.$$.fragment),hr=r(),Tt=l("p"),Tt.textContent=Ar,gr=r(),re=l("div"),p(ke.$$.fragment),_r=r(),Ct=l("p"),Ct.textContent=Yr,At=r(),p(Xe.$$.fragment),Yt=r(),Ze=l("p"),Ze.innerHTML=Or,Ot=r(),Je=l("p"),Je.textContent=Kr,Kt=r(),Le=l("p"),Le.textContent=ea,es=r(),je=l("ul"),je.innerHTML=ta,ts=r(),qe=l("p"),qe.innerHTML=sa,ss=r(),B=l("div"),p(Ve.$$.fragment),vr=r(),Pt=l("p"),Pt.innerHTML=ra,rs=r(),p(ze.$$.fragment),as=r(),Ee=l("p"),Ee.innerHTML=aa,os=r(),He=l("p"),He.innerHTML=oa,ns=r(),Be=l("p"),Be.textContent=na,ls=r(),Fe=l("ul"),Fe.innerHTML=la,is=r(),Ne=l("p"),Ne.textContent=ia,ms=r(),Ge=l("p"),Ge.innerHTML=ma,ds=r(),p(Se.$$.fragment),cs=r(),We=l("p"),We.innerHTML=da,ps=r(),Re=l("p"),Re.textContent=ca,fs=r(),p(Qe.$$.fragment),us=r(),De=l("p"),De.textContent=pa,hs=r(),Ae=l("ul"),Ae.innerHTML=fa,gs=r(),Ye=l("p"),Ye.innerHTML=ua,_s=r(),I=l("div"),p(Oe.$$.fragment),br=r(),Ut=l("p"),Ut.textContent=ha,xr=r(),ae=l("div"),p(Ke.$$.fragment),$r=r(),It=l("p"),It.textContent=ga,yr=r(),E=l("div"),p(et.$$.fragment),Mr=r(),kt=l("p"),kt.innerHTML=_a,wr=r(),p(oe.$$.fragment),Tr=r(),ne=l("div"),p(tt.$$.fragment),Cr=r(),Xt=l("p"),Xt.textContent=va,vs=r(),st=l("p"),st.innerHTML=ba,bs=r(),L=l("div"),p(rt.$$.fragment),Pr=r(),Zt=l("p"),Zt.textContent=xa,Ur=r(),p(le.$$.fragment),xs=r(),at=l("p"),at.innerHTML=$a,$s=r(),p(ot.$$.fragment),ys=r(),nt=l("p"),nt.textContent=ya,Ms=r(),p(lt.$$.fragment),ws=r(),it=l("p"),it.innerHTML=Ma,Ts=r(),p(mt.$$.fragment),Cs=r(),dt=l("p"),dt.innerHTML=wa,Ps=r(),zt=l("p"),this.h()},l(e){const s=Ia("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(t),y=a(e),v=i(e,"P",{}),x(v).forEach(t),b=a(e),f(M.$$.fragment,e),c=a(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-8nvl5z"&&(C.textContent=Xr),Ht=a(e),me=i(e,"UL",{"data-svelte-h":!0}),d(me)!=="svelte-1r5mt3j"&&(me.innerHTML=Zr),Bt=a(e),f(de.$$.fragment,e),Ft=a(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-16hpp4n"&&(ce.textContent=Jr),Nt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-x3ucqc"&&(pe.textContent=Lr),Gt=a(e),U=i(e,"DIV",{class:!0});var k=x(U);f(fe.$$.fragment,k),Hs=a(k),ct=i(k,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1s4wckx"&&(ct.textContent=jr),Bs=a(k),j=i(k,"DIV",{class:!0});var F=x(j);f(ue.$$.fragment,F),Fs=a(F),pt=i(F,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1cj8dcb"&&(pt.textContent=qr),Ns=a(F),f(W.$$.fragment,F),F.forEach(t),Gs=a(k),q=i(k,"DIV",{class:!0});var N=x(q);f(he.$$.fragment,N),Ss=a(N),ft=i(N,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1cwsjho"&&(ft.textContent=Vr),Ws=a(N),f(R.$$.fragment,N),N.forEach(t),Rs=a(k),V=i(k,"DIV",{class:!0});var G=x(V);f(ge.$$.fragment,G),Qs=a(G),ut=i(G,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-hhsvto"&&(ut.innerHTML=zr),Ds=a(G),f(Q.$$.fragment,G),G.forEach(t),As=a(k),z=i(k,"DIV",{class:!0});var S=x(z);f(_e.$$.fragment,S),Ys=a(S),ht=i(S,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-y5isdl"&&(ht.innerHTML=Er),Os=a(S),f(D.$$.fragment,S),S.forEach(t),k.forEach(t),St=a(e),f(ve.$$.fragment,e),Wt=a(e),be=i(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-48co4p"&&(be.innerHTML=Hr),Rt=a(e),T=i(e,"DIV",{class:!0});var P=x(T);f(xe.$$.fragment,P),Ks=a(P),gt=i(P,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1bsw04k"&&(gt.textContent=Br),er=a(P),A=i(P,"DIV",{class:!0});var Is=x(A);f($e.$$.fragment,Is),tr=a(Is),_t=i(Is,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-fiwhzw"&&(_t.innerHTML=Fr),Is.forEach(t),sr=a(P),Y=i(P,"DIV",{class:!0});var ks=x(Y);f(ye.$$.fragment,ks),rr=a(ks),vt=i(ks,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-pplryq"&&(vt.textContent=Nr),ks.forEach(t),ar=a(P),O=i(P,"DIV",{class:!0});var Xs=x(O);f(Me.$$.fragment,Xs),or=a(Xs),bt=i(Xs,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-3oqyjr"&&(bt.textContent=Gr),Xs.forEach(t),nr=a(P),K=i(P,"DIV",{class:!0});var Zs=x(K);f(we.$$.fragment,Zs),lr=a(Zs),xt=i(Zs,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-cbpgrz"&&(xt.innerHTML=Sr),Zs.forEach(t),ir=a(P),ee=i(P,"DIV",{class:!0});var Js=x(ee);f(Te.$$.fragment,Js),mr=a(Js),$t=i(Js,"P",{"data-svelte-h":!0}),d($t)!=="svelte-xngr19"&&($t.innerHTML=Wr),Js.forEach(t),dr=a(P),te=i(P,"DIV",{class:!0});var Ls=x(te);f(Ce.$$.fragment,Ls),cr=a(Ls),yt=i(Ls,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1jevh15"&&(yt.textContent=Rr),Ls.forEach(t),P.forEach(t),Qt=a(e),Z=i(e,"DIV",{class:!0});var Jt=x(Z);f(Pe.$$.fragment,Jt),pr=a(Jt),Mt=i(Jt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-vkt0pi"&&(Mt.textContent=Qr),fr=a(Jt),se=i(Jt,"DIV",{class:!0});var js=x(se);f(Ue.$$.fragment,js),ur=a(js),wt=i(js,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-5ayq1f"&&(wt.textContent=Dr),js.forEach(t),Jt.forEach(t),Dt=a(e),J=i(e,"DIV",{class:!0});var Lt=x(J);f(Ie.$$.fragment,Lt),hr=a(Lt),Tt=i(Lt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-168wf64"&&(Tt.textContent=Ar),gr=a(Lt),re=i(Lt,"DIV",{class:!0});var qs=x(re);f(ke.$$.fragment,qs),_r=a(qs),Ct=i(qs,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-5ayq1f"&&(Ct.textContent=Yr),qs.forEach(t),Lt.forEach(t),At=a(e),f(Xe.$$.fragment,e),Yt=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-pgkk87"&&(Ze.innerHTML=Or),Ot=a(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1iz8kjk"&&(Je.textContent=Kr),Kt=a(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-ejlsq2"&&(Le.textContent=ea),es=a(e),je=i(e,"UL",{"data-svelte-h":!0}),d(je)!=="svelte-my8qym"&&(je.innerHTML=ta),ts=a(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1ocpnlg"&&(qe.innerHTML=sa),ss=a(e),B=i(e,"DIV",{class:!0});var Vs=x(B);f(Ve.$$.fragment,Vs),vr=a(Vs),Pt=i(Vs,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-5lvrve"&&(Pt.innerHTML=ra),Vs.forEach(t),rs=a(e),f(ze.$$.fragment,e),as=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-9mlx1z"&&(Ee.innerHTML=aa),os=a(e),He=i(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1qabksm"&&(He.innerHTML=oa),ns=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-uho2qa"&&(Be.textContent=na),ls=a(e),Fe=i(e,"UL",{"data-svelte-h":!0}),d(Fe)!=="svelte-1e2xq99"&&(Fe.innerHTML=la),is=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-sz5yy2"&&(Ne.textContent=ia),ms=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1u88c3m"&&(Ge.innerHTML=ma),ds=a(e),f(Se.$$.fragment,e),cs=a(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1i4abtq"&&(We.innerHTML=da),ps=a(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-zxdzom"&&(Re.textContent=ca),fs=a(e),f(Qe.$$.fragment,e),us=a(e),De=i(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-ejlsq2"&&(De.textContent=pa),hs=a(e),Ae=i(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1qiv3qf"&&(Ae.innerHTML=fa),gs=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1r22nj6"&&(Ye.innerHTML=ua),_s=a(e),I=i(e,"DIV",{class:!0});var H=x(I);f(Oe.$$.fragment,H),br=a(H),Ut=i(H,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-173gxyd"&&(Ut.textContent=ha),xr=a(H),ae=i(H,"DIV",{class:!0});var zs=x(ae);f(Ke.$$.fragment,zs),$r=a(zs),It=i(zs,"P",{"data-svelte-h":!0}),d(It)!=="svelte-wmaktk"&&(It.textContent=ga),zs.forEach(t),yr=a(H),E=i(H,"DIV",{class:!0});var jt=x(E);f(et.$$.fragment,jt),Mr=a(jt),kt=i(jt,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-11nqnea"&&(kt.innerHTML=_a),wr=a(jt),f(oe.$$.fragment,jt),jt.forEach(t),Tr=a(H),ne=i(H,"DIV",{class:!0});var Es=x(ne);f(tt.$$.fragment,Es),Cr=a(Es),Xt=i(Es,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-d5zv1x"&&(Xt.textContent=va),Es.forEach(t),H.forEach(t),vs=a(e),st=i(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-12wzh89"&&(st.innerHTML=ba),bs=a(e),L=i(e,"DIV",{class:!0});var qt=x(L);f(rt.$$.fragment,qt),Pr=a(qt),Zt=i(qt,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-169nh0g"&&(Zt.textContent=xa),Ur=a(qt),f(le.$$.fragment,qt),qt.forEach(t),xs=a(e),at=i(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-2mj9lk"&&(at.innerHTML=$a),$s=a(e),f(ot.$$.fragment,e),ys=a(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1q119ra"&&(nt.textContent=ya),Ms=a(e),f(lt.$$.fragment,e),ws=a(e),it=i(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-9ecb4t"&&(it.innerHTML=Ma),Ts=a(e),f(mt.$$.fragment,e),Cs=a(e),dt=i(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-8lr0dh"&&(dt.innerHTML=wa),Ps=a(e),zt=i(e,"P",{}),x(zt).forEach(t),this.h()},h(){$(m,"name","hf:doc:metadata"),$(m,"content",Va),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){n(document.head,m),o(e,y,s),o(e,v,s),o(e,b,s),u(M,e,s),o(e,c,s),o(e,C,s),o(e,Ht,s),o(e,me,s),o(e,Bt,s),u(de,e,s),o(e,Ft,s),o(e,ce,s),o(e,Nt,s),o(e,pe,s),o(e,Gt,s),o(e,U,s),u(fe,U,null),n(U,Hs),n(U,ct),n(U,Bs),n(U,j),u(ue,j,null),n(j,Fs),n(j,pt),n(j,Ns),u(W,j,null),n(U,Gs),n(U,q),u(he,q,null),n(q,Ss),n(q,ft),n(q,Ws),u(R,q,null),n(U,Rs),n(U,V),u(ge,V,null),n(V,Qs),n(V,ut),n(V,Ds),u(Q,V,null),n(U,As),n(U,z),u(_e,z,null),n(z,Ys),n(z,ht),n(z,Os),u(D,z,null),o(e,St,s),u(ve,e,s),o(e,Wt,s),o(e,be,s),o(e,Rt,s),o(e,T,s),u(xe,T,null),n(T,Ks),n(T,gt),n(T,er),n(T,A),u($e,A,null),n(A,tr),n(A,_t),n(T,sr),n(T,Y),u(ye,Y,null),n(Y,rr),n(Y,vt),n(T,ar),n(T,O),u(Me,O,null),n(O,or),n(O,bt),n(T,nr),n(T,K),u(we,K,null),n(K,lr),n(K,xt),n(T,ir),n(T,ee),u(Te,ee,null),n(ee,mr),n(ee,$t),n(T,dr),n(T,te),u(Ce,te,null),n(te,cr),n(te,yt),o(e,Qt,s),o(e,Z,s),u(Pe,Z,null),n(Z,pr),n(Z,Mt),n(Z,fr),n(Z,se),u(Ue,se,null),n(se,ur),n(se,wt),o(e,Dt,s),o(e,J,s),u(Ie,J,null),n(J,hr),n(J,Tt),n(J,gr),n(J,re),u(ke,re,null),n(re,_r),n(re,Ct),o(e,At,s),u(Xe,e,s),o(e,Yt,s),o(e,Ze,s),o(e,Ot,s),o(e,Je,s),o(e,Kt,s),o(e,Le,s),o(e,es,s),o(e,je,s),o(e,ts,s),o(e,qe,s),o(e,ss,s),o(e,B,s),u(Ve,B,null),n(B,vr),n(B,Pt),o(e,rs,s),u(ze,e,s),o(e,as,s),o(e,Ee,s),o(e,os,s),o(e,He,s),o(e,ns,s),o(e,Be,s),o(e,ls,s),o(e,Fe,s),o(e,is,s),o(e,Ne,s),o(e,ms,s),o(e,Ge,s),o(e,ds,s),u(Se,e,s),o(e,cs,s),o(e,We,s),o(e,ps,s),o(e,Re,s),o(e,fs,s),u(Qe,e,s),o(e,us,s),o(e,De,s),o(e,hs,s),o(e,Ae,s),o(e,gs,s),o(e,Ye,s),o(e,_s,s),o(e,I,s),u(Oe,I,null),n(I,br),n(I,Ut),n(I,xr),n(I,ae),u(Ke,ae,null),n(ae,$r),n(ae,It),n(I,yr),n(I,E),u(et,E,null),n(E,Mr),n(E,kt),n(E,wr),u(oe,E,null),n(I,Tr),n(I,ne),u(tt,ne,null),n(ne,Cr),n(ne,Xt),o(e,vs,s),o(e,st,s),o(e,bs,s),o(e,L,s),u(rt,L,null),n(L,Pr),n(L,Zt),n(L,Ur),u(le,L,null),o(e,xs,s),o(e,at,s),o(e,$s,s),u(ot,e,s),o(e,ys,s),o(e,nt,s),o(e,Ms,s),u(lt,e,s),o(e,ws,s),o(e,it,s),o(e,Ts,s),u(mt,e,s),o(e,Cs,s),o(e,dt,s),o(e,Ps,s),o(e,zt,s),Us=!0},p(e,[s]){const k={};s&2&&(k.$$scope={dirty:s,ctx:e}),W.$set(k);const F={};s&2&&(F.$$scope={dirty:s,ctx:e}),R.$set(F);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),Q.$set(N);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),D.$set(G);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),oe.$set(S);const P={};s&2&&(P.$$scope={dirty:s,ctx:e}),le.$set(P)},i(e){Us||(h(M.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(W.$$.fragment,e),h(he.$$.fragment,e),h(R.$$.fragment,e),h(ge.$$.fragment,e),h(Q.$$.fragment,e),h(_e.$$.fragment,e),h(D.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(oe.$$.fragment,e),h(tt.$$.fragment,e),h(rt.$$.fragment,e),h(le.$$.fragment,e),h(ot.$$.fragment,e),h(lt.$$.fragment,e),h(mt.$$.fragment,e),Us=!0)},o(e){g(M.$$.fragment,e),g(de.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(W.$$.fragment,e),g(he.$$.fragment,e),g(R.$$.fragment,e),g(ge.$$.fragment,e),g(Q.$$.fragment,e),g(_e.$$.fragment,e),g(D.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Se.$$.fragment,e),g(Qe.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(oe.$$.fragment,e),g(tt.$$.fragment,e),g(rt.$$.fragment,e),g(le.$$.fragment,e),g(ot.$$.fragment,e),g(lt.$$.fragment,e),g(mt.$$.fragment,e),Us=!1},d(e){e&&(t(y),t(v),t(b),t(c),t(C),t(Ht),t(me),t(Bt),t(Ft),t(ce),t(Nt),t(pe),t(Gt),t(U),t(St),t(Wt),t(be),t(Rt),t(T),t(Qt),t(Z),t(Dt),t(J),t(At),t(Yt),t(Ze),t(Ot),t(Je),t(Kt),t(Le),t(es),t(je),t(ts),t(qe),t(ss),t(B),t(rs),t(as),t(Ee),t(os),t(He),t(ns),t(Be),t(ls),t(Fe),t(is),t(Ne),t(ms),t(Ge),t(ds),t(cs),t(We),t(ps),t(Re),t(fs),t(us),t(De),t(hs),t(Ae),t(gs),t(Ye),t(_s),t(I),t(vs),t(st),t(bs),t(L),t(xs),t(at),t($s),t(ys),t(nt),t(Ms),t(ws),t(it),t(Ts),t(Cs),t(dt),t(Ps),t(zt)),t(m),_(M,e),_(de,e),_(fe),_(ue),_(W),_(he),_(R),_(ge),_(Q),_(_e),_(D),_(ve,e),_(xe),_($e),_(ye),_(Me),_(we),_(Te),_(Ce),_(Pe),_(Ue),_(Ie),_(ke),_(Xe,e),_(Ve),_(ze,e),_(Se,e),_(Qe,e),_(Oe),_(Ke),_(et),_(oe),_(tt),_(rt),_(le),_(ot,e),_(lt,e),_(mt,e)}}}const Va='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function za(X){return Ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends Pa{constructor(m){super(),Ua(this,m,za,qa,Ta,{})}}export{Wa as component};
