import{s as Ol,o as es,n as Lo}from"../chunks/scheduler.9bc65507.js";import{S as ts,i as ns,g as s,s as o,r,A as as,h as i,f as n,c as l,j as k,u as d,x as c,k as z,y as g,a,v as m,d as p,t as u,w as f,m as os,n as ls}from"../chunks/index.707bf1b6.js";import{T as Jo}from"../chunks/Tip.c2ecdbf4.js";import{D as Kt}from"../chunks/Docstring.17db21ae.js";import{C as $}from"../chunks/CodeBlock.54a9f38d.js";import{H as b}from"../chunks/Heading.342b1fa6.js";function ss(v){let h;return{c(){h=os("GPTQ quantization only works for text model for now. Futhermore, the quantization process can a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the hub if there is not a GPTQ quantized version of the model. If not, you can submit a demand on github.")},l(M){h=ls(M,"GPTQ quantization only works for text model for now. Futhermore, the quantization process can a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the hub if there is not a GPTQ quantized version of the model. If not, you can submit a demand on github.")},m(M,y){a(M,h,y)},d(M){M&&n(h)}}}function is(v){let h,M="Note that once a model has been loaded in 4-bit it is currently not possible to push the quantized weights on the Hub. Note also that you cannot train 4-bit weights as this is not supported yet. However you can use 4-bit models to train extra parameters, this will be covered in the next section.";return{c(){h=s("p"),h.textContent=M},l(y){h=i(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1173kmw"&&(h.textContent=M)},m(y,C){a(y,h,C)},p:Lo,d(y){y&&n(h)}}}function rs(v){let h,M=`Note that once a model has been loaded in 8-bit it is currently not possible to push the quantized weights on the Hub except if you use the latest <code>transformers</code> and <code>bitsandbytes</code>. Note also that you cannot train 8-bit weights as this is not supported yet. However you can use 8-bit models to train extra parameters, this will be covered in the next section.
Note also that <code>device_map</code> is optional but setting <code>device_map = &#39;auto&#39;</code> is prefered for inference as it will dispatch efficiently the model on the available ressources.`;return{c(){h=s("p"),h.innerHTML=M},l(y){h=i(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-17mr1dr"&&(h.innerHTML=M)},m(y,C){a(y,h,C)},p:Lo,d(y){y&&n(h)}}}function ds(v){let h,M="Pushing 8bit models on the Hub is strongely encouraged for large models. This will allow the community to benefit from the memory footprint reduction and loading for example large models on a Google Colab.";return{c(){h=s("p"),h.textContent=M},l(y){h=i(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1bu8wqo"&&(h.textContent=M)},m(y,C){a(y,h,C)},p:Lo,d(y){y&&n(h)}}}function ms(v){let h,M,y,C,X,mn,V,pn,F,Ro="🤗 Transformers has integrated <code>optimum</code> API to perform GPTQ quantization on language models. You can load and quantize your model in 8, 4, 3 or even 2 bits without a big drop of performance and faster inference speed! This is supported by most GPU hardwares.",un,L,No="To learn more about the the quantization model, check out:",fn,R,Ho='<li>the <a href="https://arxiv.org/pdf/2210.17323.pdf" rel="nofollow">GPTQ</a> paper</li> <li>the <code>optimum</code> <a href="https://huggingface.co/docs/optimum/llm_quantization/usage_guides/quantization" rel="nofollow">guide</a> on GPTQ quantization</li> <li>the <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow"><code>AutoGPTQ</code></a> library used as the backend</li>',cn,N,hn,H,Io="You need to have the following requirements installed to run the code below:",bn,I,Ao=`<li><p>Install latest <code>AutoGPTQ</code> library
<code>pip install auto-gptq</code></p></li> <li><p>Install latest <code>optimum</code> from source
<code>pip install git+https://github.com/huggingface/optimum.git</code></p></li> <li><p>Install latest <code>transformers</code> from source
<code>pip install git+https://github.com/huggingface/transformers.git</code></p></li> <li><p>Install latest <code>accelerate</code> library
<code>pip install --upgrade accelerate</code></p></li>`,gn,A,Po="Note that GPTQ integration supports for now only text models and you may encounter unexpected behaviour for vision, speech or multi-modal models.",yn,P,$n,E,Eo="GPTQ is a quantization method that requires weights calibration before using the quantized models. If you want to quantize transformers model from scratch, it might take some time before producing the quantized model (~5 min on a Google colab for <code>facebook/opt-350m</code> model).",_n,Y,Yo="Hence, there are two different scenarios where you want to use GPTQ-quantized models. The first use case would be to load models that has been already quantized by other users that are available on the Hub, the second use case would be to quantize your model from scratch and save it or push it on the Hub so that other users can also use it.",Mn,S,wn,D,So='In order to load and quantize a model, you need to create a <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>. You need to pass the number of <code>bits</code>, a <code>dataset</code> in order to calibrate the quantization and the <code>tokenizer</code> of the model in order prepare the dataset.',Tn,K,vn,O,Do="Note that you can pass your own dataset as a list of string. However, it is highly recommended to use the dataset from the GPTQ paper.",Cn,ee,Jn,te,kn,ne,Ko="You can quantize a model by using <code>from_pretrained</code> and setting the <code>quantization_config</code>.",zn,ae,qn,oe,Oo="Note that you will need a GPU to quantize a model. We will put the model in the cpu and move the modules back and forth to the gpu in order to quantize them.",xn,le,el="If you want to maximize your gpus usage while using cpu offload, you can set <code>device_map = &quot;auto&quot;</code>.",Wn,se,Zn,ie,tl='Note that disk offload is not supported. Furthermore, if you are out of memory because of the dataset, you may have to pass <code>max_memory</code> in <code>from_pretained</code>. Checkout this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">guide</a> to learn more about <code>device_map</code> and <code>max_memory</code>.',Un,q,jn,re,Gn,de,nl="You can push the quantized model like any 🤗 model to Hub with <code>push_to_hub</code>. The quantization config will be saved and pushed along the model.",Bn,me,Qn,pe,al="If you want to save your quantized model on your local machine, you can also do it with <code>save_pretrained</code>:",Xn,ue,Vn,fe,ol="Note that if you have quantized your model with a <code>device_map</code>, make sure to move the entire model to one of your gpus or the <code>cpu</code> before saving it.",Fn,ce,Ln,he,Rn,be,ll=`You can load a quantized model from the Hub by using <code>from_pretrained</code>.
Make sure that the pushed weights are quantized, by checking that the attribute <code>quantization_config</code> is present in the model configuration object.`,Nn,ge,Hn,ye,sl="If you want to load a model faster and without allocating more memory than needed, the <code>device_map</code> argument also works with quantized model. Make sure that you have <code>accelerate</code> library installed.",In,$e,An,_e,Pn,Me,il='For 4-bit model, you can use the exllama kernels in order to a faster inference speed. It is activated by default. You can change that behavior by passing <code>disable_exllama</code> in <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>. This will overwrite the quantization config stored in the config. Note that you will only be able to overwrite the attributes related to the kernels. Furthermore, you need to have the entire model on gpus if you want to use exllama kernels.',En,we,Yn,Te,rl="Note that only 4-bit models are supported for now. Furthermore, it is recommended to deactivate the exllama kernels if you are finetuning a quantized model with peft.",Sn,ve,Dn,Ce,dl=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been quantized with GPTQ.
Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,Kn,Je,On,ke,ml='Check out the Google Colab <a href="https://colab.research.google.com/drive/1_TIrmuKOFhuRRiTWN94iLKUFu6ZX4ceb?usp=sharing" rel="nofollow">notebook</a> to learn how to quantize your model with GPTQ and how finetune the quantized model with peft.',ea,ze,ta,T,qe,ko,Ot,pl=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>optimum</code> api for gptq quantization relying on auto_gptq backend.`,zo,x,xe,qo,en,ul="Safety checker that arguments are correct",na,We,aa,Ze,fl=`🤗 Transformers is closely integrated with most used modules on <code>bitsandbytes</code>. You can load your model in 8-bit precision with few lines of code.
This is supported by most of the GPU hardwares since the <code>0.37.0</code> release of <code>bitsandbytes</code>.`,oa,Ue,cl='Learn more about the quantization method in the <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">LLM.int8()</a> paper, or the <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blogpost</a> about the collaboration.',la,je,hl="Since its <code>0.39.0</code> release, you can load any model that supports <code>device_map</code> using 4-bit quantization, leveraging FP4 data type.",sa,Ge,bl='If you want to quantize your own pytorch model, check out this <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/quantization" rel="nofollow">documentation</a> from 🤗 Accelerate library.',ia,Be,gl="Here are the things you can do using <code>bitsandbytes</code> integration",ra,Qe,da,Xe,yl='You can quantize a model by using the <code>load_in_8bit</code> or <code>load_in_4bit</code> argument when calling the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method as long as your model supports loading with 🤗 Accelerate and contains <code>torch.nn.Linear</code> layers. This should work for any modality as well.',ma,Ve,pa,Fe,$l="By default all other modules (e.g. <code>torch.nn.LayerNorm</code>) will be converted in <code>torch.float16</code>, but if you want to change their <code>dtype</code> you can overwrite the <code>torch_dtype</code> argument:",ua,Le,fa,Re,ca,Ne,ha,He,_l="Make sure that you have installed the requirements below before running any of the code snippets below.",ba,Ie,Ml=`<li><p>Latest <code>bitsandbytes</code> library
<code>pip install bitsandbytes&gt;=0.39.0</code></p></li> <li><p>Install latest <code>accelerate</code> <code>pip install --upgrade accelerate</code></p></li> <li><p>Install latest <code>transformers</code> <code>pip install --upgrade transformers</code></p></li>`,ga,Ae,ya,Pe,wl='<li><p><strong>Advanced usage:</strong> Refer to <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">this Google Colab notebook</a> for advanced usage of 4-bit quantization with all the possible options.</p></li> <li><p><strong>Faster inference with <code>batch_size=1</code> :</strong> Since the <code>0.40.0</code> release of bitsandbytes, for <code>batch_size=1</code> you can benefit from fast inference. Check out <a href="https://github.com/TimDettmers/bitsandbytes/releases/tag/0.40.0" rel="nofollow">these release notes</a> and make sure to have a version that is greater than <code>0.40.0</code> to benefit from this feature out of the box.</p></li> <li><p><strong>Training:</strong> According to <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">QLoRA paper</a>, for training 4-bit base models (e.g. using LoRA adapters) one should use <code>bnb_4bit_quant_type=&#39;nf4&#39;</code>.</p></li> <li><p><strong>Inference:</strong> For inference, <code>bnb_4bit_quant_type</code> does not have a huge impact on the performance. However for consistency with the model’s weights, make sure you use the same <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> arguments.</p></li>',$a,Ee,_a,Ye,Tl="By using <code>load_in_4bit=True</code> when calling the <code>.from_pretrained</code> method, you can divide your memory use by 4 (roughly).",Ma,Se,wa,W,Ta,De,va,Ke,vl="You can load a model by roughly halving the memory requirements by using <code>load_in_8bit=True</code> argument when calling <code>.from_pretrained</code> method",Ca,Oe,Ja,et,Cl='Then, use your model as you would usually use a <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',ka,tt,Jl="You can check the memory footprint of your model with <code>get_memory_footprint</code> method.",za,nt,qa,at,kl="With this integration we were able to load large models on smaller devices and run them without any issue.",xa,Z,Wa,ot,Za,lt,zl="Here we will cover some advanced use cases you can perform with FP4 quantization",Ua,st,ja,it,ql="The compute dtype is used to change the dtype that will be used during computation. For example, hidden states could be in <code>float32</code> but computation can be set to bf16 for speedups. By default, the compute dtype is set to <code>float32</code>.",Ga,rt,Ba,dt,Qa,mt,xl="You can also use the NF4 data type, which is a new 4bit datatype adapted for weights that have been initialized using a normal distribution. For that run:",Xa,pt,Va,ut,Fa,ft,Wl="We also advise users to use the nested quantization technique. This saves more memory at no additional performance - from our empirical observations, this enables fine-tuning llama-13b model on an NVIDIA-T4 16GB with a sequence length of 1024, batch size of 1 and gradient accumulation steps of 4.",La,ct,Ra,ht,Na,bt,Zl=`You can push a quantized model on the Hub by naively using <code>push_to_hub</code> method. This will first push the quantization configuration file, then push the quantized model weights.
Make sure to use <code>bitsandbytes&gt;0.37.2</code> (at this time of writing, we tested it on <code>bitsandbytes==0.38.0.post1</code>) to be able to use this feature.`,Ha,gt,Ia,U,Aa,yt,Pa,$t,Ul="You can load a quantized model from the Hub by using <code>from_pretrained</code> method. Make sure that the pushed weights are quantized, by checking that the attribute <code>quantization_config</code> is present in the model configuration object.",Ea,_t,Ya,Mt,jl=`Note that in this case, you don’t need to specify the arguments <code>load_in_8bit=True</code>, but you need to make sure that <code>bitsandbytes</code> and <code>accelerate</code> are installed.
Note also that <code>device_map</code> is optional but setting <code>device_map = &#39;auto&#39;</code> is prefered for inference as it will dispatch efficiently the model on the available ressources.`,Sa,wt,Da,Tt,Gl="This section is intended to advanced users, that want to explore what it is possible to do beyond loading and running 8-bit models.",Ka,vt,Oa,Ct,Bl="One of the advanced use case of this is being able to load a model and dispatch the weights between <code>CPU</code> and <code>GPU</code>. Note that the weights that will be dispatched on CPU <strong>will not</strong> be converted in 8-bit, thus kept in <code>float32</code>. This feature is intended for users that want to fit a very large model and dispatch the model between GPU and CPU.",eo,Jt,Ql='First, load a <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> from <code>transformers</code> and set the attribute <code>llm_int8_enable_fp32_cpu_offload</code> to <code>True</code>:',to,kt,no,zt,Xl="Let’s say you want to load <code>bigscience/bloom-1b7</code> model, and you have just enough GPU RAM to fit the entire model except the <code>lm_head</code>. Therefore write a custom device_map as follows:",ao,qt,oo,xt,Vl="And load your model as follows:",lo,Wt,so,Zt,Fl="And that’s it! Enjoy your model!",io,Ut,ro,jt,Ll=`You can play with the <code>llm_int8_threshold</code> argument to change the threshold of the outliers. An “outlier” is a hidden state value that is greater than a certain threshold.
This corresponds to the outlier threshold for outlier detection as described in <code>LLM.int8()</code> paper. Any hidden states value that is above this threshold will be considered an outlier and the operation on those values will be done in fp16. Values are usually normally distributed, that is, most values are in the range [-3.5, 3.5], but there are some exceptional systematic outliers that are very differently distributed for large models. These outliers are often in the interval [-60, -6] or [6, 60]. Int8 quantization works well for values of magnitude ~5, but beyond that, there is a significant performance penalty. A good default threshold is 6, but a lower threshold might be needed for more unstable models (small models, fine-tuning).
This argument can impact the inference speed of the model. We suggest to play with this parameter to find which one is the best for your use case.`,mo,Gt,po,Bt,uo,Qt,Rl="Some models has several modules that needs to be not converted in 8-bit to ensure stability. For example Jukebox model has several <code>lm_head</code> modules that should be skipped. Play with <code>llm_int8_skip_modules</code>",fo,Xt,co,Vt,ho,Ft,Nl=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been loaded in 8-bit.
This enables fine-tuning large models such as <code>flan-t5-large</code> or <code>facebook/opt-6.7b</code> in a single google Colab. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,bo,Lt,Hl="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. You can also set the device map to a specific device if needed (e.g. <code>cuda:0</code>, <code>0</code>, <code>torch.device(&#39;cuda:0&#39;)</code>). Please note that <code>device_map=auto</code> should be used for inference only.",go,Rt,yo,_,Nt,xo,tn,Il=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>bitsandbytes</code>.`,Wo,nn,Al="This replaces <code>load_in_8bit</code> or <code>load_in_4bit</code>therefore both options are mutually exclusive.",Zo,an,Pl=`Currently only supports <code>LLM.int8()</code>, <code>FP4</code>, and <code>NF4</code> quantization. If more methods are added to <code>bitsandbytes</code>,
then more arguments will be added to this class.`,Uo,j,Ht,jo,on,El="Returns <code>True</code> if the model is quantizable, <code>False</code> otherwise.",Go,G,It,Bo,ln,Yl="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",Qo,B,At,Xo,sn,Sl=`This method returns the quantization method used for the model. If the model is not quantizable, it returns
<code>None</code>.`,Vo,Q,Pt,Fo,rn,Dl=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,$o,Et,_o,Yt,Kl='Please have a look at <a href="https://huggingface.co/docs/optimum/index" rel="nofollow">Optimum documentation</a> to learn more about quantization methods that are supported by <code>optimum</code> and see if these are applicable for your use case.',Mo,dn,wo;return X=new b({props:{title:"Quantize 🤗 Transformers models",local:"quantize--transformers-models",headingTag:"h1"}}),V=new b({props:{title:"AutoGPTQ Integration",local:"autogptq-integration",headingTag:"h2"}}),N=new b({props:{title:"Requirements",local:"requirements",headingTag:"h3"}}),P=new b({props:{title:"Load and quantize a model",local:"load-and-quantize-a-model",headingTag:"h3"}}),S=new b({props:{title:"GPTQ Configuration",local:"gptq-configuration",headingTag:"h4"}}),K=new $({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwZGF0YXNldCUyMCUzRCUyMCUyMmM0JTIyJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset = <span class="hljs-string">&quot;c4&quot;</span>, tokenizer=tokenizer)`,wrap:!1}}),ee=new $({props:{code:"ZGF0YXNldCUyMCUzRCUyMCU1QiUyMmF1dG8tZ3B0cSUyMGlzJTIwYW4lMjBlYXN5LXRvLXVzZSUyMG1vZGVsJTIwcXVhbnRpemF0aW9uJTIwbGlicmFyeSUyMHdpdGglMjB1c2VyLWZyaWVuZGx5JTIwYXBpcyUyQyUyMGJhc2VkJTIwb24lMjBHUFRRJTIwYWxnb3JpdGhtLiUyMiU1RCUwQXF1YW50aXphdGlvbiUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTIwJTNEJTIwZGF0YXNldCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplcik=",highlighted:`dataset = [<span class="hljs-string">&quot;auto-gptq is an easy-to-use model quantization library with user-friendly apis, based on GPTQ algorithm.&quot;</span>]
quantization = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset = dataset, tokenizer=tokenizer)`,wrap:!1}}),te=new b({props:{title:"Quantization",local:"quantization",headingTag:"h4"}}),ae=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=gptq_config)`,wrap:!1}}),se=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),q=new Jo({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:v}}}),re=new b({props:{title:"Push quantized model to 🤗 Hub",local:"push-quantized-model-to--hub",headingTag:"h3"}}),me=new $({props:{code:"cXVhbnRpemVkX21vZGVsLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIpJTBBdG9rZW5pemVyLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),ue=new $({props:{code:"cXVhbnRpemVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyb3B0LTEyNW0tZ3B0cSUyMik=",highlighted:`quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),ce=new $({props:{code:"cXVhbnRpemVkX21vZGVsLnRvKCUyMmNwdSUyMiklMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.to(<span class="hljs-string">&quot;cpu&quot;</span>)
quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),he=new b({props:{title:"Load a quantized model from the 🤗 Hub",local:"load-a-quantized-model-from-the--hub",headingTag:"h3"}}),ge=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>)`,wrap:!1}}),$e=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),_e=new b({props:{title:"Exllama kernels for faster inference",local:"exllama-kernels-for-faster-inference",headingTag:"h3"}}),we=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkaXNhYmxlX2V4bGxhbWElM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMGdwdHFfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, disable_exllama=<span class="hljs-literal">False</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config = gptq_config)`,wrap:!1}}),ve=new b({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h4"}}),Je=new b({props:{title:"Example demo",local:"example-demo",headingTag:"h3"}}),ze=new b({props:{title:"GPTQConfig",local:"transformers.GPTQConfig",headingTag:"h3"}}),qe=new Kt({props:{name:"class transformers.GPTQConfig",anchor:"transformers.GPTQConfig",parameters:[{name:"bits",val:": int"},{name:"tokenizer",val:": typing.Any = None"},{name:"dataset",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"group_size",val:": int = 128"},{name:"damp_percent",val:": float = 0.1"},{name:"desc_act",val:": bool = False"},{name:"sym",val:": bool = True"},{name:"true_sequential",val:": bool = True"},{name:"use_cuda_fp16",val:": bool = False"},{name:"model_seqlen",val:": typing.Optional[int] = None"},{name:"block_name_to_quantize",val:": typing.Optional[str] = None"},{name:"module_name_preceding_first_block",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"disable_exllama",val:": bool = False"},{name:"max_input_length",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTQConfig.bits",description:`<strong>bits</strong> (<code>int</code>) &#x2014;
The number of bits to quantize to, supported numbers are (2, 3, 4, 8).`,name:"bits"},{anchor:"transformers.GPTQConfig.tokenizer",description:`<strong>tokenizer</strong> (<code>str</code> or <code>PreTrainedTokenizerBase</code>, <em>optional</em>) &#x2014;
The tokenizer used to process the dataset. You can pass either:<ul>
<li>A custom tokenizer object.</li>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"tokenizer"},{anchor:"transformers.GPTQConfig.dataset",description:`<strong>dataset</strong> (<code>Union[List[str]]</code>, <em>optional</em>) &#x2014;
The dataset used for quantization. You can provide your own dataset in a list of string or just use the
original datasets used in GPTQ paper [&#x2018;wikitext2&#x2019;,&#x2018;c4&#x2019;,&#x2018;c4-new&#x2019;,&#x2018;ptb&#x2019;,&#x2018;ptb-new&#x2019;]`,name:"dataset"},{anchor:"transformers.GPTQConfig.group_size",description:`<strong>group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The group size to use for quantization. Recommended value is 128 and -1 uses per-column quantization.`,name:"group_size"},{anchor:"transformers.GPTQConfig.damp_percent",description:`<strong>damp_percent</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The percent of the average Hessian diagonal to use for dampening. Recommended value is 0.1.`,name:"damp_percent"},{anchor:"transformers.GPTQConfig.desc_act",description:`<strong>desc_act</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to quantize columns in order of decreasing activation size. Setting it to False can significantly
speed up inference but the perplexity may become slightly worse. Also known as act-order.`,name:"desc_act"},{anchor:"transformers.GPTQConfig.sym",description:`<strong>sym</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use symetric quantization.`,name:"sym"},{anchor:"transformers.GPTQConfig.true_sequential",description:`<strong>true_sequential</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to perform sequential quantization even within a single Transformer block. Instead of quantizing
the entire block at once, we perform layer-wise quantization. As a result, each layer undergoes
quantization using inputs that have passed through the previously quantized layers.`,name:"true_sequential"},{anchor:"transformers.GPTQConfig.use_cuda_fp16",description:`<strong>use_cuda_fp16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use optimized cuda kernel for fp16 model. Need to have model in fp16.`,name:"use_cuda_fp16"},{anchor:"transformers.GPTQConfig.model_seqlen",description:`<strong>model_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length that the model can take.`,name:"model_seqlen"},{anchor:"transformers.GPTQConfig.block_name_to_quantize",description:`<strong>block_name_to_quantize</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The transformers block name to quantize.`,name:"block_name_to_quantize"},{anchor:"transformers.GPTQConfig.module_name_preceding_first_block",description:`<strong>module_name_preceding_first_block</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The layers that are preceding the first Transformer block.`,name:"module_name_preceding_first_block"},{anchor:"transformers.GPTQConfig.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The batch size used when processing the dataset`,name:"batch_size"},{anchor:"transformers.GPTQConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The pad token id. Needed to prepare the dataset when <code>batch_size</code> &gt; 1.`,name:"pad_token_id"},{anchor:"transformers.GPTQConfig.disable_exllama",description:`<strong>disable_exllama</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use exllama backend. Only works with <code>bits</code> = 4.`,name:"disable_exllama"},{anchor:"transformers.GPTQConfig.max_input_length",description:`<strong>max_input_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum input length. This is needed to initialize a buffer that depends on the maximum expected input
length. It is specific to the exllama backend with act-order.`,name:"max_input_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L303"}}),xe=new Kt({props:{name:"post_init",anchor:"transformers.GPTQConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L399"}}),We=new b({props:{title:"bitsandbytes Integration",local:"bitsandbytes-integration",headingTag:"h2"}}),Qe=new b({props:{title:"General usage",local:"general-usage",headingTag:"h3"}}),Ve=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSklMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),Le=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzhiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype
torch.float32`,wrap:!1}}),Re=new b({props:{title:"FP4 quantization",local:"fp4-quantization",headingTag:"h3"}}),Ne=new b({props:{title:"Requirements",local:"requirements",headingTag:"h4"}}),Ae=new b({props:{title:"Tips and best practices",local:"tips-and-best-practices",headingTag:"h4"}}),Ee=new b({props:{title:"Load a large model in 4bit",local:"load-a-large-model-in-4bit",headingTag:"h4"}}),Se=new $({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install transformers accelerate bitsandbytes</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new Jo({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:v}}}),De=new b({props:{title:"Load a large model in 8bit",local:"load-a-large-model-in-8bit",headingTag:"h3"}}),Oe=new $({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install transformers accelerate bitsandbytes</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),nt=new $({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),Z=new Jo({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:v}}}),ot=new b({props:{title:"Advanced use cases",local:"advanced-use-cases",headingTag:"h4"}}),st=new b({props:{title:"Change the compute dtype",local:"change-the-compute-dtype",headingTag:"h5"}}),rt=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),dt=new b({props:{title:"Using NF4 (Normal Float 4) data type",local:"using-nf4-normal-float-4-data-type",headingTag:"h5"}}),pt=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=nf4_config)`,wrap:!1}}),ut=new b({props:{title:"Use nested quantization for more memory efficient inference",local:"use-nested-quantization-for-more-memory-efficient-inference",headingTag:"h5"}}),ct=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0Rkb3VibGVfcXVhbnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=double_quant_config)`,wrap:!1}}),ht=new b({props:{title:"Push quantized models on the 🤗 Hub",local:"push-quantized-models-on-the--hub",headingTag:"h3"}}),gt=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),U=new Jo({props:{warning:!0,$$slots:{default:[ds]},$$scope:{ctx:v}}}),yt=new b({props:{title:"Load a quantized model from the 🤗 Hub",local:"load-a-quantized-model-from-the--hub",headingTag:"h3"}}),_t=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),wt=new b({props:{title:"Advanced use cases",local:"advanced-use-cases",headingTag:"h3"}}),vt=new b({props:{title:"Offload between cpu and gpu",local:"offload-between-cpu-and-gpu",headingTag:"h4"}}),kt=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobGxtX2ludDhfZW5hYmxlX2ZwMzJfY3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),qt=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),Wt=new $({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),Ut=new b({props:{title:"Play with llm_int8_threshold",local:"play-with-llmint8threshold",headingTag:"h4"}}),Gt=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfdGhyZXNob2xkJTNEMTAlMkMlMEEpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)
tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),Bt=new b({props:{title:"Skip the conversion of some modules",local:"skip-the-conversion-of-some-modules",headingTag:"h4"}}),Xt=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)
tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),Vt=new b({props:{title:"Fine-tune a model that has been loaded in 8-bit",local:"fine-tune-a-model-that-has-been-loaded-in-8-bit",headingTag:"h4"}}),Rt=new b({props:{title:"BitsAndBytesConfig",local:"transformers.BitsAndBytesConfig",headingTag:"h3"}}),Nt=new Kt({props:{name:"class transformers.BitsAndBytesConfig",anchor:"transformers.BitsAndBytesConfig",parameters:[{name:"load_in_8bit",val:" = False"},{name:"load_in_4bit",val:" = False"},{name:"llm_int8_threshold",val:" = 6.0"},{name:"llm_int8_skip_modules",val:" = None"},{name:"llm_int8_enable_fp32_cpu_offload",val:" = False"},{name:"llm_int8_has_fp16_weight",val:" = False"},{name:"bnb_4bit_compute_dtype",val:" = None"},{name:"bnb_4bit_quant_type",val:" = 'fp4'"},{name:"bnb_4bit_use_double_quant",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitsAndBytesConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 8-bit quantization with LLM.int8().`,name:"load_in_8bit"},{anchor:"transformers.BitsAndBytesConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 4-bit quantization by replacing the Linear layers with FP4/NF4 layers from
<code>bitsandbytes</code>.`,name:"load_in_4bit"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_threshold",description:`<strong>llm_int8_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 6) &#x2014;
This corresponds to the outlier threshold for outlier detection as described in <code>LLM.int8() : 8-bit Matrix Multiplication for Transformers at Scale</code> paper: <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">https://arxiv.org/abs/2208.07339</a> Any hidden states value
that is above this threshold will be considered an outlier and the operation on those values will be done
in fp16. Values are usually normally distributed, that is, most values are in the range [-3.5, 3.5], but
there are some exceptional systematic outliers that are very differently distributed for large models.
These outliers are often in the interval [-60, -6] or [6, 60]. Int8 quantization works well for values of
magnitude ~5, but beyond that, there is a significant performance penalty. A good default threshold is 6,
but a lower threshold might be needed for more unstable models (small models, fine-tuning).`,name:"llm_int8_threshold"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_skip_modules",description:`<strong>llm_int8_skip_modules</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
An explicit list of the modules that we do not want to convert in 8-bit. This is useful for models such as
Jukebox that has several heads in different places and not necessarily at the last position. For example
for <code>CausalLM</code> models, the last <code>lm_head</code> is kept in its original <code>dtype</code>.`,name:"llm_int8_skip_modules"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_enable_fp32_cpu_offload",description:`<strong>llm_int8_enable_fp32_cpu_offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for advanced use cases and users that are aware of this feature. If you want to split
your model in different parts and run some parts in int8 on GPU and some parts in fp32 on CPU, you can use
this flag. This is useful for offloading large models such as <code>google/flan-t5-xxl</code>. Note that the int8
operations will not be run on CPU.`,name:"llm_int8_enable_fp32_cpu_offload"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_has_fp16_weight",description:`<strong>llm_int8_has_fp16_weight</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag runs LLM.int8() with 16-bit main weights. This is useful for fine-tuning as the weights do not
have to be converted back and forth for the backward pass.`,name:"llm_int8_has_fp16_weight"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_compute_dtype",description:`<strong>bnb_4bit_compute_dtype</strong> (<code>torch.dtype</code> or str, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
This sets the computational type which might be different than the input time. For example, inputs might be
fp32, but computation can be set to bf16 for speedups.`,name:"bnb_4bit_compute_dtype"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, {fp4, nf4}, defaults to <code>fp4</code>) &#x2014;
This sets the quantization data type in the bnb.nn.Linear4Bit layers. Options are FP4 and NF4 data types
which are specified by <code>fp4</code> or <code>nf4</code>.`,name:"bnb_4bit_quant_type"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_use_double_quant",description:`<strong>bnb_4bit_use_double_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for nested quantization where the quantization constants from the first quantization are
quantized again.`,name:"bnb_4bit_use_double_quant"},{anchor:"transformers.BitsAndBytesConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L130"}}),Ht=new Kt({props:{name:"is_quantizable",anchor:"transformers.BitsAndBytesConfig.is_quantizable",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L245"}}),It=new Kt({props:{name:"post_init",anchor:"transformers.BitsAndBytesConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L214"}}),At=new Kt({props:{name:"quantization_method",anchor:"transformers.BitsAndBytesConfig.quantization_method",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L251"}}),Pt=new Kt({props:{name:"to_diff_dict",anchor:"transformers.BitsAndBytesConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Et=new b({props:{title:"Quantization with 🤗 optimum",local:"quantization-with--optimum",headingTag:"h2"}}),{c(){h=s("meta"),M=o(),y=s("p"),C=o(),r(X.$$.fragment),mn=o(),r(V.$$.fragment),pn=o(),F=s("p"),F.innerHTML=Ro,un=o(),L=s("p"),L.textContent=No,fn=o(),R=s("ul"),R.innerHTML=Ho,cn=o(),r(N.$$.fragment),hn=o(),H=s("p"),H.textContent=Io,bn=o(),I=s("ul"),I.innerHTML=Ao,gn=o(),A=s("p"),A.textContent=Po,yn=o(),r(P.$$.fragment),$n=o(),E=s("p"),E.innerHTML=Eo,_n=o(),Y=s("p"),Y.textContent=Yo,Mn=o(),r(S.$$.fragment),wn=o(),D=s("p"),D.innerHTML=So,Tn=o(),r(K.$$.fragment),vn=o(),O=s("p"),O.textContent=Do,Cn=o(),r(ee.$$.fragment),Jn=o(),r(te.$$.fragment),kn=o(),ne=s("p"),ne.innerHTML=Ko,zn=o(),r(ae.$$.fragment),qn=o(),oe=s("p"),oe.textContent=Oo,xn=o(),le=s("p"),le.innerHTML=el,Wn=o(),r(se.$$.fragment),Zn=o(),ie=s("p"),ie.innerHTML=tl,Un=o(),r(q.$$.fragment),jn=o(),r(re.$$.fragment),Gn=o(),de=s("p"),de.innerHTML=nl,Bn=o(),r(me.$$.fragment),Qn=o(),pe=s("p"),pe.innerHTML=al,Xn=o(),r(ue.$$.fragment),Vn=o(),fe=s("p"),fe.innerHTML=ol,Fn=o(),r(ce.$$.fragment),Ln=o(),r(he.$$.fragment),Rn=o(),be=s("p"),be.innerHTML=ll,Nn=o(),r(ge.$$.fragment),Hn=o(),ye=s("p"),ye.innerHTML=sl,In=o(),r($e.$$.fragment),An=o(),r(_e.$$.fragment),Pn=o(),Me=s("p"),Me.innerHTML=il,En=o(),r(we.$$.fragment),Yn=o(),Te=s("p"),Te.textContent=rl,Sn=o(),r(ve.$$.fragment),Dn=o(),Ce=s("p"),Ce.innerHTML=dl,Kn=o(),r(Je.$$.fragment),On=o(),ke=s("p"),ke.innerHTML=ml,ea=o(),r(ze.$$.fragment),ta=o(),T=s("div"),r(qe.$$.fragment),ko=o(),Ot=s("p"),Ot.innerHTML=pl,zo=o(),x=s("div"),r(xe.$$.fragment),qo=o(),en=s("p"),en.textContent=ul,na=o(),r(We.$$.fragment),aa=o(),Ze=s("p"),Ze.innerHTML=fl,oa=o(),Ue=s("p"),Ue.innerHTML=cl,la=o(),je=s("p"),je.innerHTML=hl,sa=o(),Ge=s("p"),Ge.innerHTML=bl,ia=o(),Be=s("p"),Be.innerHTML=gl,ra=o(),r(Qe.$$.fragment),da=o(),Xe=s("p"),Xe.innerHTML=yl,ma=o(),r(Ve.$$.fragment),pa=o(),Fe=s("p"),Fe.innerHTML=$l,ua=o(),r(Le.$$.fragment),fa=o(),r(Re.$$.fragment),ca=o(),r(Ne.$$.fragment),ha=o(),He=s("p"),He.textContent=_l,ba=o(),Ie=s("ul"),Ie.innerHTML=Ml,ga=o(),r(Ae.$$.fragment),ya=o(),Pe=s("ul"),Pe.innerHTML=wl,$a=o(),r(Ee.$$.fragment),_a=o(),Ye=s("p"),Ye.innerHTML=Tl,Ma=o(),r(Se.$$.fragment),wa=o(),r(W.$$.fragment),Ta=o(),r(De.$$.fragment),va=o(),Ke=s("p"),Ke.innerHTML=vl,Ca=o(),r(Oe.$$.fragment),Ja=o(),et=s("p"),et.innerHTML=Cl,ka=o(),tt=s("p"),tt.innerHTML=Jl,za=o(),r(nt.$$.fragment),qa=o(),at=s("p"),at.textContent=kl,xa=o(),r(Z.$$.fragment),Wa=o(),r(ot.$$.fragment),Za=o(),lt=s("p"),lt.textContent=zl,Ua=o(),r(st.$$.fragment),ja=o(),it=s("p"),it.innerHTML=ql,Ga=o(),r(rt.$$.fragment),Ba=o(),r(dt.$$.fragment),Qa=o(),mt=s("p"),mt.textContent=xl,Xa=o(),r(pt.$$.fragment),Va=o(),r(ut.$$.fragment),Fa=o(),ft=s("p"),ft.textContent=Wl,La=o(),r(ct.$$.fragment),Ra=o(),r(ht.$$.fragment),Na=o(),bt=s("p"),bt.innerHTML=Zl,Ha=o(),r(gt.$$.fragment),Ia=o(),r(U.$$.fragment),Aa=o(),r(yt.$$.fragment),Pa=o(),$t=s("p"),$t.innerHTML=Ul,Ea=o(),r(_t.$$.fragment),Ya=o(),Mt=s("p"),Mt.innerHTML=jl,Sa=o(),r(wt.$$.fragment),Da=o(),Tt=s("p"),Tt.textContent=Gl,Ka=o(),r(vt.$$.fragment),Oa=o(),Ct=s("p"),Ct.innerHTML=Bl,eo=o(),Jt=s("p"),Jt.innerHTML=Ql,to=o(),r(kt.$$.fragment),no=o(),zt=s("p"),zt.innerHTML=Xl,ao=o(),r(qt.$$.fragment),oo=o(),xt=s("p"),xt.textContent=Vl,lo=o(),r(Wt.$$.fragment),so=o(),Zt=s("p"),Zt.textContent=Fl,io=o(),r(Ut.$$.fragment),ro=o(),jt=s("p"),jt.innerHTML=Ll,mo=o(),r(Gt.$$.fragment),po=o(),r(Bt.$$.fragment),uo=o(),Qt=s("p"),Qt.innerHTML=Rl,fo=o(),r(Xt.$$.fragment),co=o(),r(Vt.$$.fragment),ho=o(),Ft=s("p"),Ft.innerHTML=Nl,bo=o(),Lt=s("p"),Lt.innerHTML=Hl,go=o(),r(Rt.$$.fragment),yo=o(),_=s("div"),r(Nt.$$.fragment),xo=o(),tn=s("p"),tn.innerHTML=Il,Wo=o(),nn=s("p"),nn.innerHTML=Al,Zo=o(),an=s("p"),an.innerHTML=Pl,Uo=o(),j=s("div"),r(Ht.$$.fragment),jo=o(),on=s("p"),on.innerHTML=El,Go=o(),G=s("div"),r(It.$$.fragment),Bo=o(),ln=s("p"),ln.textContent=Yl,Qo=o(),B=s("div"),r(At.$$.fragment),Xo=o(),sn=s("p"),sn.innerHTML=Sl,Vo=o(),Q=s("div"),r(Pt.$$.fragment),Fo=o(),rn=s("p"),rn.textContent=Dl,$o=o(),r(Et.$$.fragment),_o=o(),Yt=s("p"),Yt.innerHTML=Kl,Mo=o(),dn=s("p"),this.h()},l(e){const t=as("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(n),M=l(e),y=i(e,"P",{}),k(y).forEach(n),C=l(e),d(X.$$.fragment,e),mn=l(e),d(V.$$.fragment,e),pn=l(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-wivdz5"&&(F.innerHTML=Ro),un=l(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-v9vpl3"&&(L.textContent=No),fn=l(e),R=i(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-1hsfxwl"&&(R.innerHTML=Ho),cn=l(e),d(N.$$.fragment,e),hn=l(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1nlfwux"&&(H.textContent=Io),bn=l(e),I=i(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1q0tak7"&&(I.innerHTML=Ao),gn=l(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-i9jsug"&&(A.textContent=Po),yn=l(e),d(P.$$.fragment,e),$n=l(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-19mmsrx"&&(E.innerHTML=Eo),_n=l(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1l3vx9e"&&(Y.textContent=Yo),Mn=l(e),d(S.$$.fragment,e),wn=l(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-kadae5"&&(D.innerHTML=So),Tn=l(e),d(K.$$.fragment,e),vn=l(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-qilh1w"&&(O.textContent=Do),Cn=l(e),d(ee.$$.fragment,e),Jn=l(e),d(te.$$.fragment,e),kn=l(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-kas648"&&(ne.innerHTML=Ko),zn=l(e),d(ae.$$.fragment,e),qn=l(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-h9bd62"&&(oe.textContent=Oo),xn=l(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1kt63mp"&&(le.innerHTML=el),Wn=l(e),d(se.$$.fragment,e),Zn=l(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-p700d6"&&(ie.innerHTML=tl),Un=l(e),d(q.$$.fragment,e),jn=l(e),d(re.$$.fragment,e),Gn=l(e),de=i(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-l0e993"&&(de.innerHTML=nl),Bn=l(e),d(me.$$.fragment,e),Qn=l(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1cc82wc"&&(pe.innerHTML=al),Xn=l(e),d(ue.$$.fragment,e),Vn=l(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-14meqc0"&&(fe.innerHTML=ol),Fn=l(e),d(ce.$$.fragment,e),Ln=l(e),d(he.$$.fragment,e),Rn=l(e),be=i(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-gsus0a"&&(be.innerHTML=ll),Nn=l(e),d(ge.$$.fragment,e),Hn=l(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1xfcpge"&&(ye.innerHTML=sl),In=l(e),d($e.$$.fragment,e),An=l(e),d(_e.$$.fragment,e),Pn=l(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-13vcaec"&&(Me.innerHTML=il),En=l(e),d(we.$$.fragment,e),Yn=l(e),Te=i(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-15fps22"&&(Te.textContent=rl),Sn=l(e),d(ve.$$.fragment,e),Dn=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1rghhrt"&&(Ce.innerHTML=dl),Kn=l(e),d(Je.$$.fragment,e),On=l(e),ke=i(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-178d21p"&&(ke.innerHTML=ml),ea=l(e),d(ze.$$.fragment,e),ta=l(e),T=i(e,"DIV",{class:!0});var J=k(T);d(qe.$$.fragment,J),ko=l(J),Ot=i(J,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-i3efvr"&&(Ot.innerHTML=pl),zo=l(J),x=i(J,"DIV",{class:!0});var St=k(x);d(xe.$$.fragment,St),qo=l(St),en=i(St,"P",{"data-svelte-h":!0}),c(en)!=="svelte-1ozftb6"&&(en.textContent=ul),St.forEach(n),J.forEach(n),na=l(e),d(We.$$.fragment,e),aa=l(e),Ze=i(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1w3k2k7"&&(Ze.innerHTML=fl),oa=l(e),Ue=i(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-18yxc3j"&&(Ue.innerHTML=cl),la=l(e),je=i(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-7usn7e"&&(je.innerHTML=hl),sa=l(e),Ge=i(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-181g9sa"&&(Ge.innerHTML=bl),ia=l(e),Be=i(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-1mf5lu3"&&(Be.innerHTML=gl),ra=l(e),d(Qe.$$.fragment,e),da=l(e),Xe=i(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-1j22nc4"&&(Xe.innerHTML=yl),ma=l(e),d(Ve.$$.fragment,e),pa=l(e),Fe=i(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-bhhave"&&(Fe.innerHTML=$l),ua=l(e),d(Le.$$.fragment,e),fa=l(e),d(Re.$$.fragment,e),ca=l(e),d(Ne.$$.fragment,e),ha=l(e),He=i(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-1opqihr"&&(He.textContent=_l),ba=l(e),Ie=i(e,"UL",{"data-svelte-h":!0}),c(Ie)!=="svelte-18dpv7h"&&(Ie.innerHTML=Ml),ga=l(e),d(Ae.$$.fragment,e),ya=l(e),Pe=i(e,"UL",{"data-svelte-h":!0}),c(Pe)!=="svelte-un6hvz"&&(Pe.innerHTML=wl),$a=l(e),d(Ee.$$.fragment,e),_a=l(e),Ye=i(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-raw4uk"&&(Ye.innerHTML=Tl),Ma=l(e),d(Se.$$.fragment,e),wa=l(e),d(W.$$.fragment,e),Ta=l(e),d(De.$$.fragment,e),va=l(e),Ke=i(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-z16dbi"&&(Ke.innerHTML=vl),Ca=l(e),d(Oe.$$.fragment,e),Ja=l(e),et=i(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-14x4n3j"&&(et.innerHTML=Cl),ka=l(e),tt=i(e,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-1mgfmur"&&(tt.innerHTML=Jl),za=l(e),d(nt.$$.fragment,e),qa=l(e),at=i(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-1h0pju"&&(at.textContent=kl),xa=l(e),d(Z.$$.fragment,e),Wa=l(e),d(ot.$$.fragment,e),Za=l(e),lt=i(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-11st5ue"&&(lt.textContent=zl),Ua=l(e),d(st.$$.fragment,e),ja=l(e),it=i(e,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1qt7jnk"&&(it.innerHTML=ql),Ga=l(e),d(rt.$$.fragment,e),Ba=l(e),d(dt.$$.fragment,e),Qa=l(e),mt=i(e,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-ctju2y"&&(mt.textContent=xl),Xa=l(e),d(pt.$$.fragment,e),Va=l(e),d(ut.$$.fragment,e),Fa=l(e),ft=i(e,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-8sil41"&&(ft.textContent=Wl),La=l(e),d(ct.$$.fragment,e),Ra=l(e),d(ht.$$.fragment,e),Na=l(e),bt=i(e,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-12ibgkx"&&(bt.innerHTML=Zl),Ha=l(e),d(gt.$$.fragment,e),Ia=l(e),d(U.$$.fragment,e),Aa=l(e),d(yt.$$.fragment,e),Pa=l(e),$t=i(e,"P",{"data-svelte-h":!0}),c($t)!=="svelte-11o118p"&&($t.innerHTML=Ul),Ea=l(e),d(_t.$$.fragment,e),Ya=l(e),Mt=i(e,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1a6lfeb"&&(Mt.innerHTML=jl),Sa=l(e),d(wt.$$.fragment,e),Da=l(e),Tt=i(e,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-bf8u41"&&(Tt.textContent=Gl),Ka=l(e),d(vt.$$.fragment,e),Oa=l(e),Ct=i(e,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-9xq6i6"&&(Ct.innerHTML=Bl),eo=l(e),Jt=i(e,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-11i6qe3"&&(Jt.innerHTML=Ql),to=l(e),d(kt.$$.fragment,e),no=l(e),zt=i(e,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-fbn7z"&&(zt.innerHTML=Xl),ao=l(e),d(qt.$$.fragment,e),oo=l(e),xt=i(e,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1pv013b"&&(xt.textContent=Vl),lo=l(e),d(Wt.$$.fragment,e),so=l(e),Zt=i(e,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-nsev1w"&&(Zt.textContent=Fl),io=l(e),d(Ut.$$.fragment,e),ro=l(e),jt=i(e,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-2188jb"&&(jt.innerHTML=Ll),mo=l(e),d(Gt.$$.fragment,e),po=l(e),d(Bt.$$.fragment,e),uo=l(e),Qt=i(e,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-1k96tv8"&&(Qt.innerHTML=Rl),fo=l(e),d(Xt.$$.fragment,e),co=l(e),d(Vt.$$.fragment,e),ho=l(e),Ft=i(e,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-11ahrdq"&&(Ft.innerHTML=Nl),bo=l(e),Lt=i(e,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1acgju7"&&(Lt.innerHTML=Hl),go=l(e),d(Rt.$$.fragment,e),yo=l(e),_=i(e,"DIV",{class:!0});var w=k(_);d(Nt.$$.fragment,w),xo=l(w),tn=i(w,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-woamwr"&&(tn.innerHTML=Il),Wo=l(w),nn=i(w,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-ki5gis"&&(nn.innerHTML=Al),Zo=l(w),an=i(w,"P",{"data-svelte-h":!0}),c(an)!=="svelte-8qsk2q"&&(an.innerHTML=Pl),Uo=l(w),j=i(w,"DIV",{class:!0});var Dt=k(j);d(Ht.$$.fragment,Dt),jo=l(Dt),on=i(Dt,"P",{"data-svelte-h":!0}),c(on)!=="svelte-10tvzyv"&&(on.innerHTML=El),Dt.forEach(n),Go=l(w),G=i(w,"DIV",{class:!0});var To=k(G);d(It.$$.fragment,To),Bo=l(To),ln=i(To,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-gy26u4"&&(ln.textContent=Yl),To.forEach(n),Qo=l(w),B=i(w,"DIV",{class:!0});var vo=k(B);d(At.$$.fragment,vo),Xo=l(vo),sn=i(vo,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-19bn0da"&&(sn.innerHTML=Sl),vo.forEach(n),Vo=l(w),Q=i(w,"DIV",{class:!0});var Co=k(Q);d(Pt.$$.fragment,Co),Fo=l(Co),rn=i(Co,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-1p6bdas"&&(rn.textContent=Dl),Co.forEach(n),w.forEach(n),$o=l(e),d(Et.$$.fragment,e),_o=l(e),Yt=i(e,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-pdn3hl"&&(Yt.innerHTML=Kl),Mo=l(e),dn=i(e,"P",{}),k(dn).forEach(n),this.h()},h(){z(h,"name","hf:doc:metadata"),z(h,"content",ps),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,h),a(e,M,t),a(e,y,t),a(e,C,t),m(X,e,t),a(e,mn,t),m(V,e,t),a(e,pn,t),a(e,F,t),a(e,un,t),a(e,L,t),a(e,fn,t),a(e,R,t),a(e,cn,t),m(N,e,t),a(e,hn,t),a(e,H,t),a(e,bn,t),a(e,I,t),a(e,gn,t),a(e,A,t),a(e,yn,t),m(P,e,t),a(e,$n,t),a(e,E,t),a(e,_n,t),a(e,Y,t),a(e,Mn,t),m(S,e,t),a(e,wn,t),a(e,D,t),a(e,Tn,t),m(K,e,t),a(e,vn,t),a(e,O,t),a(e,Cn,t),m(ee,e,t),a(e,Jn,t),m(te,e,t),a(e,kn,t),a(e,ne,t),a(e,zn,t),m(ae,e,t),a(e,qn,t),a(e,oe,t),a(e,xn,t),a(e,le,t),a(e,Wn,t),m(se,e,t),a(e,Zn,t),a(e,ie,t),a(e,Un,t),m(q,e,t),a(e,jn,t),m(re,e,t),a(e,Gn,t),a(e,de,t),a(e,Bn,t),m(me,e,t),a(e,Qn,t),a(e,pe,t),a(e,Xn,t),m(ue,e,t),a(e,Vn,t),a(e,fe,t),a(e,Fn,t),m(ce,e,t),a(e,Ln,t),m(he,e,t),a(e,Rn,t),a(e,be,t),a(e,Nn,t),m(ge,e,t),a(e,Hn,t),a(e,ye,t),a(e,In,t),m($e,e,t),a(e,An,t),m(_e,e,t),a(e,Pn,t),a(e,Me,t),a(e,En,t),m(we,e,t),a(e,Yn,t),a(e,Te,t),a(e,Sn,t),m(ve,e,t),a(e,Dn,t),a(e,Ce,t),a(e,Kn,t),m(Je,e,t),a(e,On,t),a(e,ke,t),a(e,ea,t),m(ze,e,t),a(e,ta,t),a(e,T,t),m(qe,T,null),g(T,ko),g(T,Ot),g(T,zo),g(T,x),m(xe,x,null),g(x,qo),g(x,en),a(e,na,t),m(We,e,t),a(e,aa,t),a(e,Ze,t),a(e,oa,t),a(e,Ue,t),a(e,la,t),a(e,je,t),a(e,sa,t),a(e,Ge,t),a(e,ia,t),a(e,Be,t),a(e,ra,t),m(Qe,e,t),a(e,da,t),a(e,Xe,t),a(e,ma,t),m(Ve,e,t),a(e,pa,t),a(e,Fe,t),a(e,ua,t),m(Le,e,t),a(e,fa,t),m(Re,e,t),a(e,ca,t),m(Ne,e,t),a(e,ha,t),a(e,He,t),a(e,ba,t),a(e,Ie,t),a(e,ga,t),m(Ae,e,t),a(e,ya,t),a(e,Pe,t),a(e,$a,t),m(Ee,e,t),a(e,_a,t),a(e,Ye,t),a(e,Ma,t),m(Se,e,t),a(e,wa,t),m(W,e,t),a(e,Ta,t),m(De,e,t),a(e,va,t),a(e,Ke,t),a(e,Ca,t),m(Oe,e,t),a(e,Ja,t),a(e,et,t),a(e,ka,t),a(e,tt,t),a(e,za,t),m(nt,e,t),a(e,qa,t),a(e,at,t),a(e,xa,t),m(Z,e,t),a(e,Wa,t),m(ot,e,t),a(e,Za,t),a(e,lt,t),a(e,Ua,t),m(st,e,t),a(e,ja,t),a(e,it,t),a(e,Ga,t),m(rt,e,t),a(e,Ba,t),m(dt,e,t),a(e,Qa,t),a(e,mt,t),a(e,Xa,t),m(pt,e,t),a(e,Va,t),m(ut,e,t),a(e,Fa,t),a(e,ft,t),a(e,La,t),m(ct,e,t),a(e,Ra,t),m(ht,e,t),a(e,Na,t),a(e,bt,t),a(e,Ha,t),m(gt,e,t),a(e,Ia,t),m(U,e,t),a(e,Aa,t),m(yt,e,t),a(e,Pa,t),a(e,$t,t),a(e,Ea,t),m(_t,e,t),a(e,Ya,t),a(e,Mt,t),a(e,Sa,t),m(wt,e,t),a(e,Da,t),a(e,Tt,t),a(e,Ka,t),m(vt,e,t),a(e,Oa,t),a(e,Ct,t),a(e,eo,t),a(e,Jt,t),a(e,to,t),m(kt,e,t),a(e,no,t),a(e,zt,t),a(e,ao,t),m(qt,e,t),a(e,oo,t),a(e,xt,t),a(e,lo,t),m(Wt,e,t),a(e,so,t),a(e,Zt,t),a(e,io,t),m(Ut,e,t),a(e,ro,t),a(e,jt,t),a(e,mo,t),m(Gt,e,t),a(e,po,t),m(Bt,e,t),a(e,uo,t),a(e,Qt,t),a(e,fo,t),m(Xt,e,t),a(e,co,t),m(Vt,e,t),a(e,ho,t),a(e,Ft,t),a(e,bo,t),a(e,Lt,t),a(e,go,t),m(Rt,e,t),a(e,yo,t),a(e,_,t),m(Nt,_,null),g(_,xo),g(_,tn),g(_,Wo),g(_,nn),g(_,Zo),g(_,an),g(_,Uo),g(_,j),m(Ht,j,null),g(j,jo),g(j,on),g(_,Go),g(_,G),m(It,G,null),g(G,Bo),g(G,ln),g(_,Qo),g(_,B),m(At,B,null),g(B,Xo),g(B,sn),g(_,Vo),g(_,Q),m(Pt,Q,null),g(Q,Fo),g(Q,rn),a(e,$o,t),m(Et,e,t),a(e,_o,t),a(e,Yt,t),a(e,Mo,t),a(e,dn,t),wo=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),q.$set(J);const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),W.$set(St);const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),Z.$set(w);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),U.$set(Dt)},i(e){wo||(p(X.$$.fragment,e),p(V.$$.fragment,e),p(N.$$.fragment,e),p(P.$$.fragment,e),p(S.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ae.$$.fragment,e),p(se.$$.fragment,e),p(q.$$.fragment,e),p(re.$$.fragment,e),p(me.$$.fragment,e),p(ue.$$.fragment,e),p(ce.$$.fragment,e),p(he.$$.fragment,e),p(ge.$$.fragment,e),p($e.$$.fragment,e),p(_e.$$.fragment,e),p(we.$$.fragment,e),p(ve.$$.fragment,e),p(Je.$$.fragment,e),p(ze.$$.fragment,e),p(qe.$$.fragment,e),p(xe.$$.fragment,e),p(We.$$.fragment,e),p(Qe.$$.fragment,e),p(Ve.$$.fragment,e),p(Le.$$.fragment,e),p(Re.$$.fragment,e),p(Ne.$$.fragment,e),p(Ae.$$.fragment,e),p(Ee.$$.fragment,e),p(Se.$$.fragment,e),p(W.$$.fragment,e),p(De.$$.fragment,e),p(Oe.$$.fragment,e),p(nt.$$.fragment,e),p(Z.$$.fragment,e),p(ot.$$.fragment,e),p(st.$$.fragment,e),p(rt.$$.fragment,e),p(dt.$$.fragment,e),p(pt.$$.fragment,e),p(ut.$$.fragment,e),p(ct.$$.fragment,e),p(ht.$$.fragment,e),p(gt.$$.fragment,e),p(U.$$.fragment,e),p(yt.$$.fragment,e),p(_t.$$.fragment,e),p(wt.$$.fragment,e),p(vt.$$.fragment,e),p(kt.$$.fragment,e),p(qt.$$.fragment,e),p(Wt.$$.fragment,e),p(Ut.$$.fragment,e),p(Gt.$$.fragment,e),p(Bt.$$.fragment,e),p(Xt.$$.fragment,e),p(Vt.$$.fragment,e),p(Rt.$$.fragment,e),p(Nt.$$.fragment,e),p(Ht.$$.fragment,e),p(It.$$.fragment,e),p(At.$$.fragment,e),p(Pt.$$.fragment,e),p(Et.$$.fragment,e),wo=!0)},o(e){u(X.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(P.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(q.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u($e.$$.fragment,e),u(_e.$$.fragment,e),u(we.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(ze.$$.fragment,e),u(qe.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(Qe.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Ae.$$.fragment,e),u(Ee.$$.fragment,e),u(Se.$$.fragment,e),u(W.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(nt.$$.fragment,e),u(Z.$$.fragment,e),u(ot.$$.fragment,e),u(st.$$.fragment,e),u(rt.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ut.$$.fragment,e),u(ct.$$.fragment,e),u(ht.$$.fragment,e),u(gt.$$.fragment,e),u(U.$$.fragment,e),u(yt.$$.fragment,e),u(_t.$$.fragment,e),u(wt.$$.fragment,e),u(vt.$$.fragment,e),u(kt.$$.fragment,e),u(qt.$$.fragment,e),u(Wt.$$.fragment,e),u(Ut.$$.fragment,e),u(Gt.$$.fragment,e),u(Bt.$$.fragment,e),u(Xt.$$.fragment,e),u(Vt.$$.fragment,e),u(Rt.$$.fragment,e),u(Nt.$$.fragment,e),u(Ht.$$.fragment,e),u(It.$$.fragment,e),u(At.$$.fragment,e),u(Pt.$$.fragment,e),u(Et.$$.fragment,e),wo=!1},d(e){e&&(n(M),n(y),n(C),n(mn),n(pn),n(F),n(un),n(L),n(fn),n(R),n(cn),n(hn),n(H),n(bn),n(I),n(gn),n(A),n(yn),n($n),n(E),n(_n),n(Y),n(Mn),n(wn),n(D),n(Tn),n(vn),n(O),n(Cn),n(Jn),n(kn),n(ne),n(zn),n(qn),n(oe),n(xn),n(le),n(Wn),n(Zn),n(ie),n(Un),n(jn),n(Gn),n(de),n(Bn),n(Qn),n(pe),n(Xn),n(Vn),n(fe),n(Fn),n(Ln),n(Rn),n(be),n(Nn),n(Hn),n(ye),n(In),n(An),n(Pn),n(Me),n(En),n(Yn),n(Te),n(Sn),n(Dn),n(Ce),n(Kn),n(On),n(ke),n(ea),n(ta),n(T),n(na),n(aa),n(Ze),n(oa),n(Ue),n(la),n(je),n(sa),n(Ge),n(ia),n(Be),n(ra),n(da),n(Xe),n(ma),n(pa),n(Fe),n(ua),n(fa),n(ca),n(ha),n(He),n(ba),n(Ie),n(ga),n(ya),n(Pe),n($a),n(_a),n(Ye),n(Ma),n(wa),n(Ta),n(va),n(Ke),n(Ca),n(Ja),n(et),n(ka),n(tt),n(za),n(qa),n(at),n(xa),n(Wa),n(Za),n(lt),n(Ua),n(ja),n(it),n(Ga),n(Ba),n(Qa),n(mt),n(Xa),n(Va),n(Fa),n(ft),n(La),n(Ra),n(Na),n(bt),n(Ha),n(Ia),n(Aa),n(Pa),n($t),n(Ea),n(Ya),n(Mt),n(Sa),n(Da),n(Tt),n(Ka),n(Oa),n(Ct),n(eo),n(Jt),n(to),n(no),n(zt),n(ao),n(oo),n(xt),n(lo),n(so),n(Zt),n(io),n(ro),n(jt),n(mo),n(po),n(uo),n(Qt),n(fo),n(co),n(ho),n(Ft),n(bo),n(Lt),n(go),n(yo),n(_),n($o),n(_o),n(Yt),n(Mo),n(dn)),n(h),f(X,e),f(V,e),f(N,e),f(P,e),f(S,e),f(K,e),f(ee,e),f(te,e),f(ae,e),f(se,e),f(q,e),f(re,e),f(me,e),f(ue,e),f(ce,e),f(he,e),f(ge,e),f($e,e),f(_e,e),f(we,e),f(ve,e),f(Je,e),f(ze,e),f(qe),f(xe),f(We,e),f(Qe,e),f(Ve,e),f(Le,e),f(Re,e),f(Ne,e),f(Ae,e),f(Ee,e),f(Se,e),f(W,e),f(De,e),f(Oe,e),f(nt,e),f(Z,e),f(ot,e),f(st,e),f(rt,e),f(dt,e),f(pt,e),f(ut,e),f(ct,e),f(ht,e),f(gt,e),f(U,e),f(yt,e),f(_t,e),f(wt,e),f(vt,e),f(kt,e),f(qt,e),f(Wt,e),f(Ut,e),f(Gt,e),f(Bt,e),f(Xt,e),f(Vt,e),f(Rt,e),f(Nt),f(Ht),f(It),f(At),f(Pt),f(Et,e)}}}const ps='{"title":"Quantize 🤗 Transformers models","local":"quantize--transformers-models","sections":[{"title":"AutoGPTQ Integration","local":"autogptq-integration","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":3},{"title":"Load and quantize a model","local":"load-and-quantize-a-model","sections":[{"title":"GPTQ Configuration","local":"gptq-configuration","sections":[],"depth":4},{"title":"Quantization","local":"quantization","sections":[],"depth":4}],"depth":3},{"title":"Push quantized model to 🤗 Hub","local":"push-quantized-model-to--hub","sections":[],"depth":3},{"title":"Load a quantized model from the 🤗 Hub","local":"load-a-quantized-model-from-the--hub","sections":[],"depth":3},{"title":"Exllama kernels for faster inference","local":"exllama-kernels-for-faster-inference","sections":[{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":4}],"depth":3},{"title":"Example demo","local":"example-demo","sections":[],"depth":3},{"title":"GPTQConfig","local":"transformers.GPTQConfig","sections":[],"depth":3}],"depth":2},{"title":"bitsandbytes Integration","local":"bitsandbytes-integration","sections":[{"title":"General usage","local":"general-usage","sections":[],"depth":3},{"title":"FP4 quantization","local":"fp4-quantization","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":4},{"title":"Tips and best practices","local":"tips-and-best-practices","sections":[],"depth":4},{"title":"Load a large model in 4bit","local":"load-a-large-model-in-4bit","sections":[],"depth":4}],"depth":3},{"title":"Load a large model in 8bit","local":"load-a-large-model-in-8bit","sections":[{"title":"Advanced use cases","local":"advanced-use-cases","sections":[{"title":"Change the compute dtype","local":"change-the-compute-dtype","sections":[],"depth":5},{"title":"Using NF4 (Normal Float 4) data type","local":"using-nf4-normal-float-4-data-type","sections":[],"depth":5},{"title":"Use nested quantization for more memory efficient inference","local":"use-nested-quantization-for-more-memory-efficient-inference","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"Push quantized models on the 🤗 Hub","local":"push-quantized-models-on-the--hub","sections":[],"depth":3},{"title":"Load a quantized model from the 🤗 Hub","local":"load-a-quantized-model-from-the--hub","sections":[],"depth":3},{"title":"Advanced use cases","local":"advanced-use-cases","sections":[{"title":"Offload between cpu and gpu","local":"offload-between-cpu-and-gpu","sections":[],"depth":4},{"title":"Play with llm_int8_threshold","local":"play-with-llmint8threshold","sections":[],"depth":4},{"title":"Skip the conversion of some modules","local":"skip-the-conversion-of-some-modules","sections":[],"depth":4},{"title":"Fine-tune a model that has been loaded in 8-bit","local":"fine-tune-a-model-that-has-been-loaded-in-8-bit","sections":[],"depth":4}],"depth":3},{"title":"BitsAndBytesConfig","local":"transformers.BitsAndBytesConfig","sections":[],"depth":3}],"depth":2},{"title":"Quantization with 🤗 optimum","local":"quantization-with--optimum","sections":[],"depth":2}],"depth":1}';function us(v){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends ts{constructor(h){super(),ns(this,h,us,ms,Ol,{})}}export{$s as component};
