import{s as el,n as tl,o as ll}from"../chunks/scheduler.56730f09.js";import{S as sl,i as nl,g as i,s as n,r as p,A as al,h as m,f as l,c as a,j as St,u as r,x as o,k as Kt,y as il,a as s,v as M,d as g,t as u,w as c}from"../chunks/index.1f144517.js";import{C as J}from"../chunks/CodeBlock.738eeccb.js";import{D as ml}from"../chunks/DocNotebookDropdown.b2e82107.js";import{H as f}from"../chunks/Heading.57d46534.js";function ol(Ut){let d,Te,de,Ue,T,be,U,ye,b,bt=`🤗 Transformers에는 여러 종류의 다국어(multilingual) 모델이 있으며, 단일 언어(monolingual) 모델과 추론 시 사용법이 다릅니다.
그렇다고 해서 <em>모든</em> 다국어 모델의 사용법이 다른 것은 아닙니다.`,he,y,yt=`<a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>와 같은 몇몇 모델은 단일 언어 모델처럼 사용할 수 있습니다.
이번 가이드에서 다국어 모델의 추론 시 사용 방법을 알아볼 것입니다.`,$e,h,je,$,ht=`XLM에는 10가지 체크포인트(checkpoint)가 있는데, 이 중 하나만 단일 언어입니다.
나머지 체크포인트 9개는 언어 임베딩을 사용하는 체크포인트와 그렇지 않은 체크포인트의 두 가지 범주로 나눌 수 있습니다.`,we,j,ke,w,$t="다음 XLM 모델은 추론 시에 언어 임베딩을 사용합니다:",xe,k,jt="<li><code>xlm-mlm-ende-1024</code> (마스킹된 언어 모델링, 영어-독일어)</li> <li><code>xlm-mlm-enfr-1024</code> (마스킹된 언어 모델링, 영어-프랑스어)</li> <li><code>xlm-mlm-enro-1024</code> (마스킹된 언어 모델링, 영어-루마니아어)</li> <li><code>xlm-mlm-xnli15-1024</code> (마스킹된 언어 모델링, XNLI 데이터 세트에서 제공하는 15개 국어)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (마스킹된 언어 모델링 + 번역, XNLI 데이터 세트에서 제공하는 15개 국어)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, 영어-프랑스어)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, 영어-독일어)</li>",Ce,x,wt=`언어 임베딩은 모델에 전달된 <code>input_ids</code>와 동일한 shape의 텐서로 표현됩니다.
이러한 텐서의 값은 사용된 언어에 따라 다르며 토크나이저의 <code>lang2id</code> 및 <code>id2lang</code> 속성에 의해 식별됩니다.`,ve,C,kt="다음 예제에서는 <code>xlm-clm-enfr-1024</code> 체크포인트(코잘 언어 모델링(causal language modeling), 영어-프랑스어)를 가져옵니다:",_e,v,Ze,_,xt="토크나이저의 <code>lang2id</code> 속성은 모델의 언어와 해당 ID를 표시합니다:",Ie,Z,Re,I,Ct="다음으로, 예제 입력을 만듭니다:",Xe,R,Ve,X,vt=`언어 ID를 <code>&quot;en&quot;</code>으로 설정해 언어 임베딩을 정의합니다.
언어 임베딩은 영어의 언어 ID인 <code>0</code>으로 채워진 텐서입니다.
이 텐서는 <code>input_ids</code>와 같은 크기여야 합니다.`,Ge,V,Qe,G,_t="이제 <code>input_ids</code>와 언어 임베딩을 모델로 전달합니다:",We,Q,Le,W,Zt='<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> 스크립트로 <code>xlm-clm</code> 체크포인트를 사용해 텍스트와 언어 임베딩을 생성할 수 있습니다.',Ee,L,Be,E,It="다음 XLM 모델은 추론 시에 언어 임베딩이 필요하지 않습니다:",He,B,Rt="<li><code>xlm-mlm-17-1280</code> (마스킹된 언어 모델링, 17개 국어)</li> <li><code>xlm-mlm-100-1280</code> (마스킹된 언어 모델링, 100개 국어)</li>",Fe,H,Xt="이전의 XLM 체크포인트와 달리 이 모델은 일반 문장 표현에 사용됩니다.",ze,F,qe,z,Vt="다음 BERT 모델은 다국어 태스크에 사용할 수 있습니다:",Ne,q,Gt="<li><code>bert-base-multilingual-uncased</code> (마스킹된 언어 모델링 + 다음 문장 예측, 102개 국어)</li> <li><code>bert-base-multilingual-cased</code> (마스킹된 언어 모델링 + 다음 문장 예측, 104개 국어)</li>",Ye,N,Qt=`이러한 모델은 추론 시에 언어 임베딩이 필요하지 않습니다.
문맥에서 언어를 식별하고, 식별된 언어로 추론합니다.`,De,Y,Ae,D,Wt="다음 XLM-RoBERTa 또한 다국어 다국어 태스크에 사용할 수 있습니다:",Oe,A,Lt="<li><code>xlm-roberta-base</code> (마스킹된 언어 모델링, 100개 국어)</li> <li><code>xlm-roberta-large</code> (마스킹된 언어 모델링, 100개 국어)</li>",Pe,O,Et=`XLM-RoBERTa는 100개 국어에 대해 새로 생성되고 정제된 2.5TB 규모의 CommonCrawl 데이터로 학습되었습니다.
이전에 공개된 mBERT나 XLM과 같은 다국어 모델에 비해 분류, 시퀀스 라벨링, 질의 응답과 같은 다운스트림(downstream) 작업에서 이점이 있습니다.`,Se,P,Ke,S,Bt="다음 M2M100 모델 또한 다국어 다국어 태스크에 사용할 수 있습니다:",et,K,Ht="<li><code>facebook/m2m100_418M</code> (번역)</li> <li><code>facebook/m2m100_1.2B</code> (번역)</li>",tt,ee,Ft=`이 예제에서는 <code>facebook/m2m100_418M</code> 체크포인트를 가져와서 중국어를 영어로 번역합니다.
토크나이저에서 번역 대상 언어(source language)를 설정할 수 있습니다:`,lt,te,st,le,zt="문장을 토큰화합니다:",nt,se,at,ne,qt=`M2M100은 번역을 진행하기 위해 첫 번째로 생성되는 토큰은 번역할 언어(target language) ID로 강제 지정합니다.
영어로 번역하기 위해 <code>generate</code> 메소드에서 <code>forced_bos_token_id</code>를 <code>en</code>으로 설정합니다:`,it,ae,mt,ie,ot,me,Nt="다음 MBart 모델 또한 다국어 태스크에 사용할 수 있습니다:",pt,oe,Yt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (일대다 다국어 번역, 50개 국어)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (다대다 다국어 번역, 50개 국어)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (다대일 다국어 번역, 50개 국어)</li> <li><code>facebook/mbart-large-50</code> (다국어 번역, 50개 국어)</li> <li><code>facebook/mbart-large-cc25</code></li>",rt,pe,Dt=`이 예제에서는 핀란드어를 영어로 번역하기 위해 <code>facebook/mbart-large-50-many-to-many-mmt</code> 체크포인트를 가져옵니다.
토크나이저에서 번역 대상 언어(source language)를 설정할 수 있습니다:`,Mt,re,gt,Me,At="문장을 토큰화합니다:",ut,ge,ct,ue,Ot=`MBart는 번역을 진행하기 위해 첫 번째로 생성되는 토큰은 번역할 언어(target language) ID로 강제 지정합니다.
영어로 번역하기 위해 <code>generate</code> 메소드에서 <code>forced_bos_token_id</code>를 <code>en</code>으로 설정합니다:`,Jt,ce,dt,Je,Pt="<code>facebook/mbart-large-50-many-to-one-mmt</code> 체크포인트를 사용하고 있다면, 첫 번째로 생성되는 토큰을 번역할 언어(target language) ID로 강제 지정할 필요는 없습니다.",ft,fe,Tt;return T=new f({props:{title:"다국어 모델 추론하기",local:"multilingual-models-for-inference",headingTag:"h1"}}),U=new ml({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/multilingual.ipynb"}]}}),h=new f({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),j=new f({props:{title:"언어 임베딩을 사용하는 XLM",local:"xlm-with-language-embeddings",headingTag:"h3"}}),v=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Z=new J({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),R=new J({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjAlRUIlQjAlQjAlRUMlQjklOTglMjAlRUQlODElQUMlRUElQjglQjAlRUIlOEElOTQlMjAxJUVDJTlFJTg1JUVCJThCJTg4JUVCJThCJUE0",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># 배치 크기는 1입니다</span>',wrap:!1}}),V=new J({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTIwc2hhcGUlRUMlOUQlOTglMjAlRUQlODUlOTAlRUMlODQlOUMlRUElQjAlODAlMjAlRUIlOTAlOTglRUIlOEYlODQlRUIlQTElOUQlMjAlRUIlQTclOEMlRUIlOTMlQUQlRUIlOEIlODglRUIlOEIlQTQuJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjAlRUMlOUQlQjQlRUMlQTAlOUMlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwc2hhcGUlRUMlOUQlQjQlMjAlRUIlOTAlOTglRUMlOTclODglRUMlOEElQjUlRUIlOEIlODglRUIlOEIlQTQoJUVCJUIwJUIwJUVDJUI5JTk4JTIwJUVEJTgxJUFDJUVBJUI4JUIwJUVCJThBJTk0JTIwMSVFQyU5RSU4NSVFQiU4QiU4OCVFQiU4QiVBNCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (batch_size, sequence_length) shape의 텐서가 되도록 만듭니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># 이제 [1, sequence_length] shape이 되었습니다(배치 크기는 1입니다)</span>`,wrap:!1}}),Q=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new f({props:{title:"언어 임베딩을 사용하지 않는 XLM",local:"xlm-without-language-embeddings",headingTag:"h3"}}),F=new f({props:{title:"BERT",local:"bert",headingTag:"h2"}}),Y=new f({props:{title:"XLM-RoBERTa",local:"xlmroberta",headingTag:"h2"}}),P=new f({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),te=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),se=new J({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new J({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ie=new f({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),re=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),ge=new J({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ce=new J({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){d=i("meta"),Te=n(),de=i("p"),Ue=n(),p(T.$$.fragment),be=n(),p(U.$$.fragment),ye=n(),b=i("p"),b.innerHTML=bt,he=n(),y=i("p"),y.innerHTML=yt,$e=n(),p(h.$$.fragment),je=n(),$=i("p"),$.textContent=ht,we=n(),p(j.$$.fragment),ke=n(),w=i("p"),w.textContent=$t,xe=n(),k=i("ul"),k.innerHTML=jt,Ce=n(),x=i("p"),x.innerHTML=wt,ve=n(),C=i("p"),C.innerHTML=kt,_e=n(),p(v.$$.fragment),Ze=n(),_=i("p"),_.innerHTML=xt,Ie=n(),p(Z.$$.fragment),Re=n(),I=i("p"),I.textContent=Ct,Xe=n(),p(R.$$.fragment),Ve=n(),X=i("p"),X.innerHTML=vt,Ge=n(),p(V.$$.fragment),Qe=n(),G=i("p"),G.innerHTML=_t,We=n(),p(Q.$$.fragment),Le=n(),W=i("p"),W.innerHTML=Zt,Ee=n(),p(L.$$.fragment),Be=n(),E=i("p"),E.textContent=It,He=n(),B=i("ul"),B.innerHTML=Rt,Fe=n(),H=i("p"),H.textContent=Xt,ze=n(),p(F.$$.fragment),qe=n(),z=i("p"),z.textContent=Vt,Ne=n(),q=i("ul"),q.innerHTML=Gt,Ye=n(),N=i("p"),N.textContent=Qt,De=n(),p(Y.$$.fragment),Ae=n(),D=i("p"),D.textContent=Wt,Oe=n(),A=i("ul"),A.innerHTML=Lt,Pe=n(),O=i("p"),O.textContent=Et,Se=n(),p(P.$$.fragment),Ke=n(),S=i("p"),S.textContent=Bt,et=n(),K=i("ul"),K.innerHTML=Ht,tt=n(),ee=i("p"),ee.innerHTML=Ft,lt=n(),p(te.$$.fragment),st=n(),le=i("p"),le.textContent=zt,nt=n(),p(se.$$.fragment),at=n(),ne=i("p"),ne.innerHTML=qt,it=n(),p(ae.$$.fragment),mt=n(),p(ie.$$.fragment),ot=n(),me=i("p"),me.textContent=Nt,pt=n(),oe=i("ul"),oe.innerHTML=Yt,rt=n(),pe=i("p"),pe.innerHTML=Dt,Mt=n(),p(re.$$.fragment),gt=n(),Me=i("p"),Me.textContent=At,ut=n(),p(ge.$$.fragment),ct=n(),ue=i("p"),ue.innerHTML=Ot,Jt=n(),p(ce.$$.fragment),dt=n(),Je=i("p"),Je.innerHTML=Pt,ft=n(),fe=i("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);d=m(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),de=m(e,"P",{}),St(de).forEach(l),Ue=a(e),r(T.$$.fragment,e),be=a(e),r(U.$$.fragment,e),ye=a(e),b=m(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1qyjud1"&&(b.innerHTML=bt),he=a(e),y=m(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-v17s0a"&&(y.innerHTML=yt),$e=a(e),r(h.$$.fragment,e),je=a(e),$=m(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-d0lwem"&&($.textContent=ht),we=a(e),r(j.$$.fragment,e),ke=a(e),w=m(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1mrvoju"&&(w.textContent=$t),xe=a(e),k=m(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-sili9k"&&(k.innerHTML=jt),Ce=a(e),x=m(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-jhaqr8"&&(x.innerHTML=wt),ve=a(e),C=m(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1othhyi"&&(C.innerHTML=kt),_e=a(e),r(v.$$.fragment,e),Ze=a(e),_=m(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-m3urb"&&(_.innerHTML=xt),Ie=a(e),r(Z.$$.fragment,e),Re=a(e),I=m(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-xaqytr"&&(I.textContent=Ct),Xe=a(e),r(R.$$.fragment,e),Ve=a(e),X=m(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-15t64om"&&(X.innerHTML=vt),Ge=a(e),r(V.$$.fragment,e),Qe=a(e),G=m(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-13hhwrg"&&(G.innerHTML=_t),We=a(e),r(Q.$$.fragment,e),Le=a(e),W=m(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-11on0v7"&&(W.innerHTML=Zt),Ee=a(e),r(L.$$.fragment,e),Be=a(e),E=m(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-ugy4tb"&&(E.textContent=It),He=a(e),B=m(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1byfgvw"&&(B.innerHTML=Rt),Fe=a(e),H=m(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-10uilok"&&(H.textContent=Xt),ze=a(e),r(F.$$.fragment,e),qe=a(e),z=m(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-17m07ks"&&(z.textContent=Vt),Ne=a(e),q=m(e,"UL",{"data-svelte-h":!0}),o(q)!=="svelte-f3wf5p"&&(q.innerHTML=Gt),Ye=a(e),N=m(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1g2xdg6"&&(N.textContent=Qt),De=a(e),r(Y.$$.fragment,e),Ae=a(e),D=m(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1qq64rp"&&(D.textContent=Wt),Oe=a(e),A=m(e,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-1j1vip0"&&(A.innerHTML=Lt),Pe=a(e),O=m(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1k6xl52"&&(O.textContent=Et),Se=a(e),r(P.$$.fragment,e),Ke=a(e),S=m(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-170tekz"&&(S.textContent=Bt),et=a(e),K=m(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-nhn2xp"&&(K.innerHTML=Ht),tt=a(e),ee=m(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1v6yjg7"&&(ee.innerHTML=Ft),lt=a(e),r(te.$$.fragment,e),st=a(e),le=m(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1sem8ou"&&(le.textContent=zt),nt=a(e),r(se.$$.fragment,e),at=a(e),ne=m(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-bfy9qc"&&(ne.innerHTML=qt),it=a(e),r(ae.$$.fragment,e),mt=a(e),r(ie.$$.fragment,e),ot=a(e),me=m(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1qf6ghx"&&(me.textContent=Nt),pt=a(e),oe=m(e,"UL",{"data-svelte-h":!0}),o(oe)!=="svelte-q5sfdy"&&(oe.innerHTML=Yt),rt=a(e),pe=m(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1xo0fvw"&&(pe.innerHTML=Dt),Mt=a(e),r(re.$$.fragment,e),gt=a(e),Me=m(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1sem8ou"&&(Me.textContent=At),ut=a(e),r(ge.$$.fragment,e),ct=a(e),ue=m(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-19syhrh"&&(ue.innerHTML=Ot),Jt=a(e),r(ce.$$.fragment,e),dt=a(e),Je=m(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-jdtdeh"&&(Je.innerHTML=Pt),ft=a(e),fe=m(e,"P",{}),St(fe).forEach(l),this.h()},h(){Kt(d,"name","hf:doc:metadata"),Kt(d,"content",pl)},m(e,t){il(document.head,d),s(e,Te,t),s(e,de,t),s(e,Ue,t),M(T,e,t),s(e,be,t),M(U,e,t),s(e,ye,t),s(e,b,t),s(e,he,t),s(e,y,t),s(e,$e,t),M(h,e,t),s(e,je,t),s(e,$,t),s(e,we,t),M(j,e,t),s(e,ke,t),s(e,w,t),s(e,xe,t),s(e,k,t),s(e,Ce,t),s(e,x,t),s(e,ve,t),s(e,C,t),s(e,_e,t),M(v,e,t),s(e,Ze,t),s(e,_,t),s(e,Ie,t),M(Z,e,t),s(e,Re,t),s(e,I,t),s(e,Xe,t),M(R,e,t),s(e,Ve,t),s(e,X,t),s(e,Ge,t),M(V,e,t),s(e,Qe,t),s(e,G,t),s(e,We,t),M(Q,e,t),s(e,Le,t),s(e,W,t),s(e,Ee,t),M(L,e,t),s(e,Be,t),s(e,E,t),s(e,He,t),s(e,B,t),s(e,Fe,t),s(e,H,t),s(e,ze,t),M(F,e,t),s(e,qe,t),s(e,z,t),s(e,Ne,t),s(e,q,t),s(e,Ye,t),s(e,N,t),s(e,De,t),M(Y,e,t),s(e,Ae,t),s(e,D,t),s(e,Oe,t),s(e,A,t),s(e,Pe,t),s(e,O,t),s(e,Se,t),M(P,e,t),s(e,Ke,t),s(e,S,t),s(e,et,t),s(e,K,t),s(e,tt,t),s(e,ee,t),s(e,lt,t),M(te,e,t),s(e,st,t),s(e,le,t),s(e,nt,t),M(se,e,t),s(e,at,t),s(e,ne,t),s(e,it,t),M(ae,e,t),s(e,mt,t),M(ie,e,t),s(e,ot,t),s(e,me,t),s(e,pt,t),s(e,oe,t),s(e,rt,t),s(e,pe,t),s(e,Mt,t),M(re,e,t),s(e,gt,t),s(e,Me,t),s(e,ut,t),M(ge,e,t),s(e,ct,t),s(e,ue,t),s(e,Jt,t),M(ce,e,t),s(e,dt,t),s(e,Je,t),s(e,ft,t),s(e,fe,t),Tt=!0},p:tl,i(e){Tt||(g(T.$$.fragment,e),g(U.$$.fragment,e),g(h.$$.fragment,e),g(j.$$.fragment,e),g(v.$$.fragment,e),g(Z.$$.fragment,e),g(R.$$.fragment,e),g(V.$$.fragment,e),g(Q.$$.fragment,e),g(L.$$.fragment,e),g(F.$$.fragment,e),g(Y.$$.fragment,e),g(P.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(ge.$$.fragment,e),g(ce.$$.fragment,e),Tt=!0)},o(e){u(T.$$.fragment,e),u(U.$$.fragment,e),u(h.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(Y.$$.fragment,e),u(P.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ge.$$.fragment,e),u(ce.$$.fragment,e),Tt=!1},d(e){e&&(l(Te),l(de),l(Ue),l(be),l(ye),l(b),l(he),l(y),l($e),l(je),l($),l(we),l(ke),l(w),l(xe),l(k),l(Ce),l(x),l(ve),l(C),l(_e),l(Ze),l(_),l(Ie),l(Re),l(I),l(Xe),l(Ve),l(X),l(Ge),l(Qe),l(G),l(We),l(Le),l(W),l(Ee),l(Be),l(E),l(He),l(B),l(Fe),l(H),l(ze),l(qe),l(z),l(Ne),l(q),l(Ye),l(N),l(De),l(Ae),l(D),l(Oe),l(A),l(Pe),l(O),l(Se),l(Ke),l(S),l(et),l(K),l(tt),l(ee),l(lt),l(st),l(le),l(nt),l(at),l(ne),l(it),l(mt),l(ot),l(me),l(pt),l(oe),l(rt),l(pe),l(Mt),l(gt),l(Me),l(ut),l(ct),l(ue),l(Jt),l(dt),l(Je),l(ft),l(fe)),l(d),c(T,e),c(U,e),c(h,e),c(j,e),c(v,e),c(Z,e),c(R,e),c(V,e),c(Q,e),c(L,e),c(F,e),c(Y,e),c(P,e),c(te,e),c(se,e),c(ae,e),c(ie,e),c(re,e),c(ge,e),c(ce,e)}}}const pl='{"title":"다국어 모델 추론하기","local":"multilingual-models-for-inference","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"언어 임베딩을 사용하는 XLM","local":"xlm-with-language-embeddings","sections":[],"depth":3},{"title":"언어 임베딩을 사용하지 않는 XLM","local":"xlm-without-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlmroberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function rl(Ut){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends sl{constructor(d){super(),nl(this,d,rl,ol,el,{})}}export{dl as component};
