import{s as ql,n as Xl,o as Yl}from"../chunks/scheduler.9bc65507.js";import{S as Fl,i as El,g as p,s as a,r,A as Ll,h as i,f as s,c as n,j as Al,u as h,x as o,k as Hl,y as Dl,a as l,v as m,d as M,t as c,w as y}from"../chunks/index.707bf1b6.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{H as J}from"../chunks/Heading.342b1fa6.js";function Pl(Xs){let u,at,st,nt,T,pt,U,it,j,Ys=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,ot,g,Fs=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,rt,w,Es=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,ht,f,mt,I,Ls=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>mistralai/Mistral-7B-Instruct-v0.1</code> model.`,Mt,b,ct,C,Ds=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!). Mistral-instruct was trained with these tokens, but BlenderBot was not.`,yt,x,dt,Z,Ps=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,Jt,N,Ks="Here’s an example of preparing input for <code>model.generate()</code>, using the <code>Zephyr</code> assistant model:",ut,G,Tt,v,Os="This will yield a string in the input format that Zephyr expects.",Ut,k,jt,$,el="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",gt,B,wt,Q,tl="This will yield:",ft,W,It,z,sl="Arr, ‘twas easy after all!",bt,S,Ct,V,ll=`Yes, there is: <a href="/docs/transformers/v4.37.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. This pipeline is designed to make it easy to use chat models. Let’s try
the <code>Zephyr</code> example again, but this time using the pipeline:`,xt,R,Zt,_,Nt,A,al=`<a href="/docs/transformers/v4.37.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Gt,H,vt,q,nl=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,kt,X,$t,Y,pl="Here’s what this will look like without a generation prompt, using the ChatML template we saw in the Zephyr example:",Bt,F,Qt,E,il="And here’s what it looks like <strong>with</strong> a generation prompt:",Wt,L,zt,D,ol=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with the appropriate control tokens so they know what they’re
supposed to be doing.`,St,P,rl=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Vt,K,Rt,O,hl=`Yes! We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,_t,ee,At,te,ml="And we get:",Ht,se,qt,le,Ml="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Xt,ae,Yt,ne,cl=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Ft,pe,Et,ie,yl=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that the first
newline after each block as well as any preceding whitespace before a block are ignored by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. However, be cautious - although leading whitespace on each
line is stripped, spaces between blocks on the same line are not. We strongly recommend checking that your template
isn’t printing extra spaces where it shouldn’t be!`,Lt,oe,Dt,re,dl=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,Pt,he,Kt,me,Jl="Effectively, the template does three things:",Ot,Me,ul="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",es,ce,Tl=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,ts,ye,ss,de,Ul=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,ls,Je,as,ue,ns,Te,jl=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,ps,Ue,is,je,gl=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,os,ge,rs,we,wl=`The method <a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/v4.37.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/v4.37.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>.`,hs,fe,ms,Ie,fl=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>ConversationalPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,Ms,be,Il=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat, and to future-proof in case the default templates are ever altered or deprecated.`,cs,Ce,ys,xe,bl=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,ds,Ze,Cl=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. Our default template for models that don’t have a class-specific template follows the
<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatML format</a>, and this is a good, flexible choice for many use-cases. It looks like this:`,Js,Ne,us,Ge,xl=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Ts,ve,Us,ke,Zl=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,js,$e,gs,Be,Nl=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/v4.37.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,ws,Qe,fs,We,Gl=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/v4.37.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,Is,ze,vl=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>ConversationalPipeline</code>!`,bs,Se,kl=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Cs,Ve,xs,Re,$l=`If you’re unfamiliar with Jinja, we generally find that the easiest way to write a chat template is to first
write a short Python script that formats messages the way you want, and then convert that script into a template.`,Zs,_e,Bl=`Remember that the template handler will receive the conversation history as a variable called <code>messages</code>. Each
message is a dictionary with two keys, <code>role</code> and <code>content</code>. You will be able to access <code>messages</code> in your template
just like you can in Python, which means you can loop over it with <code>{% for message in messages %}</code> or access
individual messages with, for example, <code>{{ messages[0] }}</code>.`,Ns,Ae,Ql="You can also use the following tips to convert your code to Jinja:",Gs,He,vs,qe,Wl="For loops in Jinja look like this:",ks,Xe,$s,Ye,zl=`Note that whatever’s inside the {{ expression block }} will be printed to the output. You can use operators like
<code>+</code> to combine strings inside expression blocks.`,Bs,Fe,Qs,Ee,Sl="If statements in Jinja look like this:",Ws,Le,zs,De,Vl=`Note how where Python uses whitespace to mark the beginnings and ends of <code>for</code> and <code>if</code> blocks, Jinja requires you
to explicitly end them with <code>{% endfor %}</code> and <code>{% endif %}</code>.`,Ss,Pe,Vs,Ke,Rl=`Inside your template, you will have access to the list of <code>messages</code>, but you can also access several other special
variables. These include special tokens like <code>bos_token</code> and <code>eos_token</code>, as well as the <code>add_generation_prompt</code>
variable that we discussed above. You can also use the <code>loop</code> variable to access information about the current loop
iteration, for example  using <code>{% if loop.last %}</code> to check if the current message is the last message in the
conversation. Here’s an example that puts these ideas together to add a generation prompt at the end of the
conversation if add_generation_prompt is <code>True</code>:`,Rs,Oe,_s,et,As,tt,_l=`As much as possible, we’ve tried to get Jinja to ignore whitespace outside of {{ expressions }}. However, be aware
that Jinja is a general-purpose templating engine, and it may treat whitespace between blocks on the same line
as significant and print it to the output. We <strong>strongly</strong> recommend checking that your template isn’t printing extra
spaces where it shouldn’t be before you upload it!`,Hs,lt,qs;return T=new J({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),U=new J({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),f=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),b=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),x=new J({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),G=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),k=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),B=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),W=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),S=new J({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),R=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmNvbnZlcnNhdGlvbmFsJTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBcHJpbnQocGlwZShtZXNzYWdlcykp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;conversational&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages))`,wrap:!1}}),_=new d({props:{code:"Q29udmVyc2F0aW9uJTIwaWQlM0ElMjA3NmQ4ODZhMC03NGJkLTQ1NGUtOTgwNC0wNDY3MDQxYTYzZGMlMEFzeXN0ZW0lM0ElMjBZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTBBdXNlciUzQSUyMEhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUwQWFzc2lzdGFudCUzQSUyME1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`Conversation id: 76d886a0-74bd-454e-9804-0467041a63dc
system: You are a friendly chatbot who always responds in the style of a pirate
user: How many helicopters can a human eat in one sitting?
assistant: Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),H=new J({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),X=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),F=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),L=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new J({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),ee=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),se=new d({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),ae=new J({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),pe=new d({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),oe=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),he=new d({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),ye=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Je=new J({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),ue=new J({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),Ue=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ge=new d({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),fe=new J({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h3"}}),Ce=new J({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),Ne=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ve=new d({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),$e=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),Qe=new J({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),Ve=new J({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),He=new J({props:{title:"For loops",local:"for-loops",headingTag:"h3"}}),Xe=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Fe=new J({props:{title:"If statements",local:"if-statements",headingTag:"h3"}}),Le=new d({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Pe=new J({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),Oe=new d({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),et=new J({props:{title:"Notes on whitespace",local:"notes-on-whitespace",headingTag:"h3"}}),{c(){u=p("meta"),at=a(),st=p("p"),nt=a(),r(T.$$.fragment),pt=a(),r(U.$$.fragment),it=a(),j=p("p"),j.innerHTML=Ys,ot=a(),g=p("p"),g.innerHTML=Fs,rt=a(),w=p("p"),w.innerHTML=Es,ht=a(),r(f.$$.fragment),mt=a(),I=p("p"),I.innerHTML=Ls,Mt=a(),r(b.$$.fragment),ct=a(),C=p("p"),C.textContent=Ds,yt=a(),r(x.$$.fragment),dt=a(),Z=p("p"),Z.innerHTML=Ps,Jt=a(),N=p("p"),N.innerHTML=Ks,ut=a(),r(G.$$.fragment),Tt=a(),v=p("p"),v.textContent=Os,Ut=a(),r(k.$$.fragment),jt=a(),$=p("p"),$.textContent=el,gt=a(),r(B.$$.fragment),wt=a(),Q=p("p"),Q.textContent=tl,ft=a(),r(W.$$.fragment),It=a(),z=p("p"),z.textContent=sl,bt=a(),r(S.$$.fragment),Ct=a(),V=p("p"),V.innerHTML=ll,xt=a(),r(R.$$.fragment),Zt=a(),r(_.$$.fragment),Nt=a(),A=p("p"),A.innerHTML=al,Gt=a(),r(H.$$.fragment),vt=a(),q=p("p"),q.innerHTML=nl,kt=a(),r(X.$$.fragment),$t=a(),Y=p("p"),Y.textContent=pl,Bt=a(),r(F.$$.fragment),Qt=a(),E=p("p"),E.innerHTML=il,Wt=a(),r(L.$$.fragment),zt=a(),D=p("p"),D.textContent=ol,St=a(),P=p("p"),P.innerHTML=rl,Vt=a(),r(K.$$.fragment),Rt=a(),O=p("p"),O.innerHTML=hl,_t=a(),r(ee.$$.fragment),At=a(),te=p("p"),te.textContent=ml,Ht=a(),r(se.$$.fragment),qt=a(),le=p("p"),le.innerHTML=Ml,Xt=a(),r(ae.$$.fragment),Yt=a(),ne=p("p"),ne.innerHTML=cl,Ft=a(),r(pe.$$.fragment),Et=a(),ie=p("p"),ie.innerHTML=yl,Lt=a(),r(oe.$$.fragment),Dt=a(),re=p("p"),re.innerHTML=dl,Pt=a(),r(he.$$.fragment),Kt=a(),me=p("p"),me.textContent=Jl,Ot=a(),Me=p("ol"),Me.innerHTML=ul,es=a(),ce=p("p"),ce.textContent=Tl,ts=a(),r(ye.$$.fragment),ss=a(),de=p("p"),de.textContent=Ul,ls=a(),r(Je.$$.fragment),as=a(),r(ue.$$.fragment),ns=a(),Te=p("p"),Te.innerHTML=jl,ps=a(),r(Ue.$$.fragment),is=a(),je=p("p"),je.innerHTML=gl,os=a(),r(ge.$$.fragment),rs=a(),we=p("p"),we.innerHTML=wl,hs=a(),r(fe.$$.fragment),ms=a(),Ie=p("p"),Ie.innerHTML=fl,Ms=a(),be=p("p"),be.innerHTML=Il,cs=a(),r(Ce.$$.fragment),ys=a(),xe=p("p"),xe.textContent=bl,ds=a(),Ze=p("p"),Ze.innerHTML=Cl,Js=a(),r(Ne.$$.fragment),us=a(),Ge=p("p"),Ge.innerHTML=xl,Ts=a(),r(ve.$$.fragment),Us=a(),ke=p("p"),ke.innerHTML=Zl,js=a(),r($e.$$.fragment),gs=a(),Be=p("p"),Be.innerHTML=Nl,ws=a(),r(Qe.$$.fragment),fs=a(),We=p("p"),We.innerHTML=Gl,Is=a(),ze=p("p"),ze.innerHTML=vl,bs=a(),Se=p("p"),Se.textContent=kl,Cs=a(),r(Ve.$$.fragment),xs=a(),Re=p("p"),Re.textContent=$l,Zs=a(),_e=p("p"),_e.innerHTML=Bl,Ns=a(),Ae=p("p"),Ae.textContent=Ql,Gs=a(),r(He.$$.fragment),vs=a(),qe=p("p"),qe.textContent=Wl,ks=a(),r(Xe.$$.fragment),$s=a(),Ye=p("p"),Ye.innerHTML=zl,Bs=a(),r(Fe.$$.fragment),Qs=a(),Ee=p("p"),Ee.textContent=Sl,Ws=a(),r(Le.$$.fragment),zs=a(),De=p("p"),De.innerHTML=Vl,Ss=a(),r(Pe.$$.fragment),Vs=a(),Ke=p("p"),Ke.innerHTML=Rl,Rs=a(),r(Oe.$$.fragment),_s=a(),r(et.$$.fragment),As=a(),tt=p("p"),tt.innerHTML=_l,Hs=a(),lt=p("p"),this.h()},l(e){const t=Ll("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),at=n(e),st=i(e,"P",{}),Al(st).forEach(s),nt=n(e),h(T.$$.fragment,e),pt=n(e),h(U.$$.fragment,e),it=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-ydi30o"&&(j.innerHTML=Ys),ot=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1p8dq8"&&(g.innerHTML=Fs),rt=n(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1n6wf0k"&&(w.innerHTML=Es),ht=n(e),h(f.$$.fragment,e),mt=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1e3bvfs"&&(I.innerHTML=Ls),Mt=n(e),h(b.$$.fragment,e),ct=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-15k3bj3"&&(C.textContent=Ds),yt=n(e),h(x.$$.fragment,e),dt=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1t9o568"&&(Z.innerHTML=Ps),Jt=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-gmslqw"&&(N.innerHTML=Ks),ut=n(e),h(G.$$.fragment,e),Tt=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1vy7akj"&&(v.textContent=Os),Ut=n(e),h(k.$$.fragment,e),jt=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-hj60o5"&&($.textContent=el),gt=n(e),h(B.$$.fragment,e),wt=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1bfcqd3"&&(Q.textContent=tl),ft=n(e),h(W.$$.fragment,e),It=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-k9m2iy"&&(z.textContent=sl),bt=n(e),h(S.$$.fragment,e),Ct=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-8qtjx1"&&(V.innerHTML=ll),xt=n(e),h(R.$$.fragment,e),Zt=n(e),h(_.$$.fragment,e),Nt=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1hgy4t1"&&(A.innerHTML=al),Gt=n(e),h(H.$$.fragment,e),vt=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-rhnu79"&&(q.innerHTML=nl),kt=n(e),h(X.$$.fragment,e),$t=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1g5nifq"&&(Y.textContent=pl),Bt=n(e),h(F.$$.fragment,e),Qt=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-61bp3d"&&(E.innerHTML=il),Wt=n(e),h(L.$$.fragment,e),zt=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1h8j73s"&&(D.textContent=ol),St=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-76qw2e"&&(P.innerHTML=rl),Vt=n(e),h(K.$$.fragment,e),Rt=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-i6ltb0"&&(O.innerHTML=hl),_t=n(e),h(ee.$$.fragment,e),At=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-13505nn"&&(te.textContent=ml),Ht=n(e),h(se.$$.fragment,e),qt=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-ziuqkt"&&(le.innerHTML=Ml),Xt=n(e),h(ae.$$.fragment,e),Yt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-9hx4bd"&&(ne.innerHTML=cl),Ft=n(e),h(pe.$$.fragment,e),Et=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-gucfz7"&&(ie.innerHTML=yl),Lt=n(e),h(oe.$$.fragment,e),Dt=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-zet1qo"&&(re.innerHTML=dl),Pt=n(e),h(he.$$.fragment,e),Kt=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-9bdwn1"&&(me.textContent=Jl),Ot=n(e),Me=i(e,"OL",{"data-svelte-h":!0}),o(Me)!=="svelte-yy2gop"&&(Me.innerHTML=ul),es=n(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-jxu6rq"&&(ce.textContent=Tl),ts=n(e),h(ye.$$.fragment,e),ss=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-dqaxjt"&&(de.textContent=Ul),ls=n(e),h(Je.$$.fragment,e),as=n(e),h(ue.$$.fragment,e),ns=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1ubxgh9"&&(Te.innerHTML=jl),ps=n(e),h(Ue.$$.fragment,e),is=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1xwzrhr"&&(je.innerHTML=gl),os=n(e),h(ge.$$.fragment,e),rs=n(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1xetwha"&&(we.innerHTML=wl),hs=n(e),h(fe.$$.fragment,e),ms=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-fwloaj"&&(Ie.innerHTML=fl),Ms=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-118w8i2"&&(be.innerHTML=Il),cs=n(e),h(Ce.$$.fragment,e),ys=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-5u6sqi"&&(xe.textContent=bl),ds=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-u7dsj6"&&(Ze.innerHTML=Cl),Js=n(e),h(Ne.$$.fragment,e),us=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1cj1ql7"&&(Ge.innerHTML=xl),Ts=n(e),h(ve.$$.fragment,e),Us=n(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-soh9qu"&&(ke.innerHTML=Zl),js=n(e),h($e.$$.fragment,e),gs=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1ul1iq8"&&(Be.innerHTML=Nl),ws=n(e),h(Qe.$$.fragment,e),fs=n(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1qvxzq1"&&(We.innerHTML=Gl),Is=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1dmaop5"&&(ze.innerHTML=vl),bs=n(e),Se=i(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-197jyne"&&(Se.textContent=kl),Cs=n(e),h(Ve.$$.fragment,e),xs=n(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-64od1c"&&(Re.textContent=$l),Zs=n(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-155y3gc"&&(_e.innerHTML=Bl),Ns=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1hxm0m6"&&(Ae.textContent=Ql),Gs=n(e),h(He.$$.fragment,e),vs=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1mepej5"&&(qe.textContent=Wl),ks=n(e),h(Xe.$$.fragment,e),$s=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-rw0syz"&&(Ye.innerHTML=zl),Bs=n(e),h(Fe.$$.fragment,e),Qs=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-audzqy"&&(Ee.textContent=Sl),Ws=n(e),h(Le.$$.fragment,e),zs=n(e),De=i(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-gc7ich"&&(De.innerHTML=Vl),Ss=n(e),h(Pe.$$.fragment,e),Vs=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1ky9l6m"&&(Ke.innerHTML=Rl),Rs=n(e),h(Oe.$$.fragment,e),_s=n(e),h(et.$$.fragment,e),As=n(e),tt=i(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-qra3hk"&&(tt.innerHTML=_l),Hs=n(e),lt=i(e,"P",{}),Al(lt).forEach(s),this.h()},h(){Hl(u,"name","hf:doc:metadata"),Hl(u,"content",Kl)},m(e,t){Dl(document.head,u),l(e,at,t),l(e,st,t),l(e,nt,t),m(T,e,t),l(e,pt,t),m(U,e,t),l(e,it,t),l(e,j,t),l(e,ot,t),l(e,g,t),l(e,rt,t),l(e,w,t),l(e,ht,t),m(f,e,t),l(e,mt,t),l(e,I,t),l(e,Mt,t),m(b,e,t),l(e,ct,t),l(e,C,t),l(e,yt,t),m(x,e,t),l(e,dt,t),l(e,Z,t),l(e,Jt,t),l(e,N,t),l(e,ut,t),m(G,e,t),l(e,Tt,t),l(e,v,t),l(e,Ut,t),m(k,e,t),l(e,jt,t),l(e,$,t),l(e,gt,t),m(B,e,t),l(e,wt,t),l(e,Q,t),l(e,ft,t),m(W,e,t),l(e,It,t),l(e,z,t),l(e,bt,t),m(S,e,t),l(e,Ct,t),l(e,V,t),l(e,xt,t),m(R,e,t),l(e,Zt,t),m(_,e,t),l(e,Nt,t),l(e,A,t),l(e,Gt,t),m(H,e,t),l(e,vt,t),l(e,q,t),l(e,kt,t),m(X,e,t),l(e,$t,t),l(e,Y,t),l(e,Bt,t),m(F,e,t),l(e,Qt,t),l(e,E,t),l(e,Wt,t),m(L,e,t),l(e,zt,t),l(e,D,t),l(e,St,t),l(e,P,t),l(e,Vt,t),m(K,e,t),l(e,Rt,t),l(e,O,t),l(e,_t,t),m(ee,e,t),l(e,At,t),l(e,te,t),l(e,Ht,t),m(se,e,t),l(e,qt,t),l(e,le,t),l(e,Xt,t),m(ae,e,t),l(e,Yt,t),l(e,ne,t),l(e,Ft,t),m(pe,e,t),l(e,Et,t),l(e,ie,t),l(e,Lt,t),m(oe,e,t),l(e,Dt,t),l(e,re,t),l(e,Pt,t),m(he,e,t),l(e,Kt,t),l(e,me,t),l(e,Ot,t),l(e,Me,t),l(e,es,t),l(e,ce,t),l(e,ts,t),m(ye,e,t),l(e,ss,t),l(e,de,t),l(e,ls,t),m(Je,e,t),l(e,as,t),m(ue,e,t),l(e,ns,t),l(e,Te,t),l(e,ps,t),m(Ue,e,t),l(e,is,t),l(e,je,t),l(e,os,t),m(ge,e,t),l(e,rs,t),l(e,we,t),l(e,hs,t),m(fe,e,t),l(e,ms,t),l(e,Ie,t),l(e,Ms,t),l(e,be,t),l(e,cs,t),m(Ce,e,t),l(e,ys,t),l(e,xe,t),l(e,ds,t),l(e,Ze,t),l(e,Js,t),m(Ne,e,t),l(e,us,t),l(e,Ge,t),l(e,Ts,t),m(ve,e,t),l(e,Us,t),l(e,ke,t),l(e,js,t),m($e,e,t),l(e,gs,t),l(e,Be,t),l(e,ws,t),m(Qe,e,t),l(e,fs,t),l(e,We,t),l(e,Is,t),l(e,ze,t),l(e,bs,t),l(e,Se,t),l(e,Cs,t),m(Ve,e,t),l(e,xs,t),l(e,Re,t),l(e,Zs,t),l(e,_e,t),l(e,Ns,t),l(e,Ae,t),l(e,Gs,t),m(He,e,t),l(e,vs,t),l(e,qe,t),l(e,ks,t),m(Xe,e,t),l(e,$s,t),l(e,Ye,t),l(e,Bs,t),m(Fe,e,t),l(e,Qs,t),l(e,Ee,t),l(e,Ws,t),m(Le,e,t),l(e,zs,t),l(e,De,t),l(e,Ss,t),m(Pe,e,t),l(e,Vs,t),l(e,Ke,t),l(e,Rs,t),m(Oe,e,t),l(e,_s,t),m(et,e,t),l(e,As,t),l(e,tt,t),l(e,Hs,t),l(e,lt,t),qs=!0},p:Xl,i(e){qs||(M(T.$$.fragment,e),M(U.$$.fragment,e),M(f.$$.fragment,e),M(b.$$.fragment,e),M(x.$$.fragment,e),M(G.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(S.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(ue.$$.fragment,e),M(Ue.$$.fragment,e),M(ge.$$.fragment,e),M(fe.$$.fragment,e),M(Ce.$$.fragment,e),M(Ne.$$.fragment,e),M(ve.$$.fragment,e),M($e.$$.fragment,e),M(Qe.$$.fragment,e),M(Ve.$$.fragment,e),M(He.$$.fragment,e),M(Xe.$$.fragment,e),M(Fe.$$.fragment,e),M(Le.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(et.$$.fragment,e),qs=!0)},o(e){c(T.$$.fragment,e),c(U.$$.fragment,e),c(f.$$.fragment,e),c(b.$$.fragment,e),c(x.$$.fragment,e),c(G.$$.fragment,e),c(k.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(S.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(ue.$$.fragment,e),c(Ue.$$.fragment,e),c(ge.$$.fragment,e),c(fe.$$.fragment,e),c(Ce.$$.fragment,e),c(Ne.$$.fragment,e),c(ve.$$.fragment,e),c($e.$$.fragment,e),c(Qe.$$.fragment,e),c(Ve.$$.fragment,e),c(He.$$.fragment,e),c(Xe.$$.fragment,e),c(Fe.$$.fragment,e),c(Le.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(et.$$.fragment,e),qs=!1},d(e){e&&(s(at),s(st),s(nt),s(pt),s(it),s(j),s(ot),s(g),s(rt),s(w),s(ht),s(mt),s(I),s(Mt),s(ct),s(C),s(yt),s(dt),s(Z),s(Jt),s(N),s(ut),s(Tt),s(v),s(Ut),s(jt),s($),s(gt),s(wt),s(Q),s(ft),s(It),s(z),s(bt),s(Ct),s(V),s(xt),s(Zt),s(Nt),s(A),s(Gt),s(vt),s(q),s(kt),s($t),s(Y),s(Bt),s(Qt),s(E),s(Wt),s(zt),s(D),s(St),s(P),s(Vt),s(Rt),s(O),s(_t),s(At),s(te),s(Ht),s(qt),s(le),s(Xt),s(Yt),s(ne),s(Ft),s(Et),s(ie),s(Lt),s(Dt),s(re),s(Pt),s(Kt),s(me),s(Ot),s(Me),s(es),s(ce),s(ts),s(ss),s(de),s(ls),s(as),s(ns),s(Te),s(ps),s(is),s(je),s(os),s(rs),s(we),s(hs),s(ms),s(Ie),s(Ms),s(be),s(cs),s(ys),s(xe),s(ds),s(Ze),s(Js),s(us),s(Ge),s(Ts),s(Us),s(ke),s(js),s(gs),s(Be),s(ws),s(fs),s(We),s(Is),s(ze),s(bs),s(Se),s(Cs),s(xs),s(Re),s(Zs),s(_e),s(Ns),s(Ae),s(Gs),s(vs),s(qe),s(ks),s($s),s(Ye),s(Bs),s(Qs),s(Ee),s(Ws),s(zs),s(De),s(Ss),s(Vs),s(Ke),s(Rs),s(_s),s(As),s(tt),s(Hs),s(lt)),s(u),y(T,e),y(U,e),y(f,e),y(b,e),y(x,e),y(G,e),y(k,e),y(B,e),y(W,e),y(S,e),y(R,e),y(_,e),y(H,e),y(X,e),y(F,e),y(L,e),y(K,e),y(ee,e),y(se,e),y(ae,e),y(pe,e),y(oe,e),y(he,e),y(ye,e),y(Je,e),y(ue,e),y(Ue,e),y(ge,e),y(fe,e),y(Ce,e),y(Ne,e),y(ve,e),y($e,e),y(Qe,e),y(Ve,e),y(He,e),y(Xe,e),y(Fe,e),y(Le,e),y(Pe,e),y(Oe,e),y(et,e)}}}const Kl='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"For loops","local":"for-loops","sections":[],"depth":3},{"title":"If statements","local":"if-statements","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Notes on whitespace","local":"notes-on-whitespace","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ol(Xs){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Fl{constructor(u){super(),El(this,u,Ol,Pl,ql,{})}}export{aa as component};
