import{s as ee,o as se,n as le}from"../chunks/scheduler.9bc65507.js";import{S as ae,i as ne,g as i,s as a,r,A as ie,h as p,f as s,c as n,j as te,u as h,x as o,k as O,y as pe,a as l,v as c,d,t as u,w as g,m as oe,n as me}from"../chunks/index.707bf1b6.js";import{T as re}from"../chunks/Tip.c2ecdbf4.js";import{C as w}from"../chunks/CodeBlock.54a9f38d.js";import{H as Gt,E as he}from"../chunks/EditOnGithub.922df6ba.js";function ce(tt){let m,f,$='<a href="../model_doc/depth_anything">Depth Anything</a>, <a href="../model_doc/dpt">DPT</a>, <a href="../model_doc/glpn">GLPN</a>';return{c(){m=oe(`The task illustrated in this tutorial is supported by the following model architectures:

`),f=i("p"),f.innerHTML=$},l(y){m=me(y,`The task illustrated in this tutorial is supported by the following model architectures:

`),f=p(y,"P",{"data-svelte-h":!0}),o(f)!=="svelte-7k3qdm"&&(f.innerHTML=$)},m(y,M){l(y,m,M),l(y,f,M)},p:le,d(y){y&&(s(m),s(f))}}}function de(tt){let m,f,$,y,M,et,J,Bt=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,st,U,Ht=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,lt,b,at,C,It="In this guide you’ll learn how to:",nt,k,zt="<li>create a depth estimation pipeline</li> <li>run depth estimation inference by hand</li>",it,x,Et="Before you begin, make sure you have all the necessary libraries installed:",pt,Z,ot,W,mt,_,Vt=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/v4.40.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,rt,R,ht,G,Nt="Next, choose an image to analyze:",ct,B,dt,j,Xt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-estimation-example.jpg" alt="Photo of a busy street"/>',ut,H,Qt="Pass the image to the pipeline.",gt,I,ft,z,Ft=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,yt,E,Yt="Let’s take a look at the visualized result:",Mt,V,wt,v,Pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',$t,N,bt,X,St="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",jt,Q,Lt=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,vt,F,Tt,Y,qt=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,Jt,P,Ut,S,At="Pass the prepared inputs through the model:",Ct,L,kt,q,Dt="Visualize the results:",xt,A,Zt,T,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',Wt,D,_t,K,Rt;return M=new Gt({props:{title:"Monocular depth estimation",local:"monocular-depth-estimation",headingTag:"h1"}}),b=new re({props:{$$slots:{default:[ce]},$$scope:{ctx:tt}}}),Z=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),W=new Gt({props:{title:"Depth estimation pipeline",local:"depth-estimation-pipeline",headingTag:"h2"}}),R=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMnZpbnZpbm8wMiUyRmdscG4tbnl1JTIyJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint)`,wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRkh3QkFzU2JQQkRVJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TXpSOGZHTmhjaVV5TUdsdUpUSXdkR2hsSlRJd2MzUnlaV1YwZkdWdWZEQjhNSHg4ZkRFMk56ZzVNREV3T0RnJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/HwBAsSbPBDU/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MzR8fGNhciUyMGluJTIwdGhlJTIwc3RyZWV0fGVufDB8MHx8fDE2Nzg5MDEwODg&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),I=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = depth_estimator(image)',wrap:!1}}),V=new w({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),N=new Gt({props:{title:"Depth estimation inference by hand",local:"depth-estimation-inference-by-hand",headingTag:"h2"}}),F=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJ2aW52aW5vMDIlMkZnbHBuLW55dSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint)`,wrap:!1}}),P=new w({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values',wrap:!1}}),L=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyklMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfZGVwdGglMjAlM0QlMjBvdXRwdXRzLnByZWRpY3RlZF9kZXB0aA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth`,wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpLnNxdWVlemUoKSUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24ubnVtcHkoKSUwQSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQpJTBBZGVwdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth`,wrap:!1}}),D=new he({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/monocular_depth_estimation.md"}}),{c(){m=i("meta"),f=a(),$=i("p"),y=a(),r(M.$$.fragment),et=a(),J=i("p"),J.textContent=Bt,st=a(),U=i("p"),U.textContent=Ht,lt=a(),r(b.$$.fragment),at=a(),C=i("p"),C.textContent=It,nt=a(),k=i("ul"),k.innerHTML=zt,it=a(),x=i("p"),x.textContent=Et,pt=a(),r(Z.$$.fragment),ot=a(),r(W.$$.fragment),mt=a(),_=i("p"),_.innerHTML=Vt,rt=a(),r(R.$$.fragment),ht=a(),G=i("p"),G.textContent=Nt,ct=a(),r(B.$$.fragment),dt=a(),j=i("div"),j.innerHTML=Xt,ut=a(),H=i("p"),H.textContent=Qt,gt=a(),r(I.$$.fragment),ft=a(),z=i("p"),z.innerHTML=Ft,yt=a(),E=i("p"),E.textContent=Yt,Mt=a(),r(V.$$.fragment),wt=a(),v=i("div"),v.innerHTML=Pt,$t=a(),r(N.$$.fragment),bt=a(),X=i("p"),X.textContent=St,jt=a(),Q=i("p"),Q.innerHTML=Lt,vt=a(),r(F.$$.fragment),Tt=a(),Y=i("p"),Y.innerHTML=qt,Jt=a(),r(P.$$.fragment),Ut=a(),S=i("p"),S.textContent=At,Ct=a(),r(L.$$.fragment),kt=a(),q=i("p"),q.textContent=Dt,xt=a(),r(A.$$.fragment),Zt=a(),T=i("div"),T.innerHTML=Kt,Wt=a(),r(D.$$.fragment),_t=a(),K=i("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);m=p(e,"META",{name:!0,content:!0}),e.forEach(s),f=n(t),$=p(t,"P",{}),te($).forEach(s),y=n(t),h(M.$$.fragment,t),et=n(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1elgt0a"&&(J.textContent=Bt),st=n(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1bkqs5v"&&(U.textContent=Ht),lt=n(t),h(b.$$.fragment,t),at=n(t),C=p(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-jr2b5g"&&(C.textContent=It),nt=n(t),k=p(t,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-tj6led"&&(k.innerHTML=zt),it=n(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1c9nexd"&&(x.textContent=Et),pt=n(t),h(Z.$$.fragment,t),ot=n(t),h(W.$$.fragment,t),mt=n(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1q6ghbi"&&(_.innerHTML=Vt),rt=n(t),h(R.$$.fragment,t),ht=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-wuz5lr"&&(G.textContent=Nt),ct=n(t),h(B.$$.fragment,t),dt=n(t),j=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-10bakl"&&(j.innerHTML=Xt),ut=n(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-mcr1tn"&&(H.textContent=Qt),gt=n(t),h(I.$$.fragment,t),ft=n(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1jckqfu"&&(z.innerHTML=Ft),yt=n(t),E=p(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1dzpyfr"&&(E.textContent=Yt),Mt=n(t),h(V.$$.fragment,t),wt=n(t),v=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-43wxxb"&&(v.innerHTML=Pt),$t=n(t),h(N.$$.fragment,t),bt=n(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1u79cc9"&&(X.textContent=St),jt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1r8mctn"&&(Q.innerHTML=Lt),vt=n(t),h(F.$$.fragment,t),Tt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-hhrw3"&&(Y.innerHTML=qt),Jt=n(t),h(P.$$.fragment,t),Ut=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1yk8q0z"&&(S.textContent=At),Ct=n(t),h(L.$$.fragment,t),kt=n(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-6ebm65"&&(q.textContent=Dt),xt=n(t),h(A.$$.fragment,t),Zt=n(t),T=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-43wxxb"&&(T.innerHTML=Kt),Wt=n(t),h(D.$$.fragment,t),_t=n(t),K=p(t,"P",{}),te(K).forEach(s),this.h()},h(){O(m,"name","hf:doc:metadata"),O(m,"content",ue),O(j,"class","flex justify-center"),O(v,"class","flex justify-center"),O(T,"class","flex justify-center")},m(t,e){pe(document.head,m),l(t,f,e),l(t,$,e),l(t,y,e),c(M,t,e),l(t,et,e),l(t,J,e),l(t,st,e),l(t,U,e),l(t,lt,e),c(b,t,e),l(t,at,e),l(t,C,e),l(t,nt,e),l(t,k,e),l(t,it,e),l(t,x,e),l(t,pt,e),c(Z,t,e),l(t,ot,e),c(W,t,e),l(t,mt,e),l(t,_,e),l(t,rt,e),c(R,t,e),l(t,ht,e),l(t,G,e),l(t,ct,e),c(B,t,e),l(t,dt,e),l(t,j,e),l(t,ut,e),l(t,H,e),l(t,gt,e),c(I,t,e),l(t,ft,e),l(t,z,e),l(t,yt,e),l(t,E,e),l(t,Mt,e),c(V,t,e),l(t,wt,e),l(t,v,e),l(t,$t,e),c(N,t,e),l(t,bt,e),l(t,X,e),l(t,jt,e),l(t,Q,e),l(t,vt,e),c(F,t,e),l(t,Tt,e),l(t,Y,e),l(t,Jt,e),c(P,t,e),l(t,Ut,e),l(t,S,e),l(t,Ct,e),c(L,t,e),l(t,kt,e),l(t,q,e),l(t,xt,e),c(A,t,e),l(t,Zt,e),l(t,T,e),l(t,Wt,e),c(D,t,e),l(t,_t,e),l(t,K,e),Rt=!0},p(t,[e]){const Ot={};e&2&&(Ot.$$scope={dirty:e,ctx:t}),b.$set(Ot)},i(t){Rt||(d(M.$$.fragment,t),d(b.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(R.$$.fragment,t),d(B.$$.fragment,t),d(I.$$.fragment,t),d(V.$$.fragment,t),d(N.$$.fragment,t),d(F.$$.fragment,t),d(P.$$.fragment,t),d(L.$$.fragment,t),d(A.$$.fragment,t),d(D.$$.fragment,t),Rt=!0)},o(t){u(M.$$.fragment,t),u(b.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(I.$$.fragment,t),u(V.$$.fragment,t),u(N.$$.fragment,t),u(F.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),u(A.$$.fragment,t),u(D.$$.fragment,t),Rt=!1},d(t){t&&(s(f),s($),s(y),s(et),s(J),s(st),s(U),s(lt),s(at),s(C),s(nt),s(k),s(it),s(x),s(pt),s(ot),s(mt),s(_),s(rt),s(ht),s(G),s(ct),s(dt),s(j),s(ut),s(H),s(gt),s(ft),s(z),s(yt),s(E),s(Mt),s(wt),s(v),s($t),s(bt),s(X),s(jt),s(Q),s(vt),s(Tt),s(Y),s(Jt),s(Ut),s(S),s(Ct),s(kt),s(q),s(xt),s(Zt),s(T),s(Wt),s(_t),s(K)),s(m),g(M,t),g(b,t),g(Z,t),g(W,t),g(R,t),g(B,t),g(I,t),g(V,t),g(N,t),g(F,t),g(P,t),g(L,t),g(A,t),g(D,t)}}}const ue='{"title":"Monocular depth estimation","local":"monocular-depth-estimation","sections":[{"title":"Depth estimation pipeline","local":"depth-estimation-pipeline","sections":[],"depth":2},{"title":"Depth estimation inference by hand","local":"depth-estimation-inference-by-hand","sections":[],"depth":2}],"depth":1}';function ge(tt){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends ae{constructor(m){super(),ne(this,m,ge,de,ee,{})}}export{be as component};
