import{s as it,o as rt,n as Oe}from"../chunks/scheduler.36a0863c.js";import{S as ot,i as pt,g as b,s as i,r as u,A as mt,h as w,f as a,c as r,j as Ze,u as f,x as T,k as Be,y as ve,a as l,v as h,d as g,t as M,w as $}from"../chunks/index.9c13489a.js";import{T as et}from"../chunks/Tip.3b06990e.js";import{Y as Ke}from"../chunks/Youtube.347c76e5.js";import{C as z}from"../chunks/CodeBlock.05d8ec32.js";import{D as ct}from"../chunks/DocNotebookDropdown.653c9eec.js";import{F as nt,M as tt}from"../chunks/Markdown.88297c0b.js";import{H as $e,E as dt}from"../chunks/EditOnGithub.e88f2b7b.js";function ut(te){let o,j="Potresti vedere un warning dato che alcuni dei pesi pre-addestrati non sono stati utilizzati e altri pesi sono stati inizializzati casualmente. Non preoccuparti, è completamente normale! L’head pre-addestrata del modello BERT viene scartata e rimpiazzata da una classification head inizializzata casualmente. Farai il fine-tuning di questa nuova head del modello sul tuo compito di classificazione, trasferendogli la conoscenza del modello pre-addestrato.";return{c(){o=b("p"),o.textContent=j},l(p){o=w(p,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1gl2557"&&(o.textContent=j)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function ft(te){let o,j,p,J="🤗 Transformers mette a disposizione la classe <code>Trainer</code> ottimizzata per addestrare modelli 🤗 Transformers, rendendo semplice iniziare l’addestramento senza scrivere manualmente il tuo ciclo di addestramento. L’API <code>Trainer</code> supporta un’ampia gamma di opzioni e funzionalità di addestramento come logging, gradient accumulation e mixed precision.",v,x,ne='Inizia caricando il tuo modello e specificando il numero di etichette (labels) attese. Nel dataset Yelp Review <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">dataset card</a>, sai che ci sono cinque etichette:',B,Z,q,G,Q,F,C,k,ae='Successivamente, crea una classe <code>TrainingArguments</code> contenente tutti gli iperparametri che si possono regore nonché le variabili per attivare le differenti opzioni di addestramento. Per questa esercitazione puoi iniziare con gli <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">iperparametri</a> di ddestramento predefiniti, ma sentiti libero di sperimentare per trovare la configurazione ottimale per te.',V,se,E="Specifica dove salvare i checkpoints del tuo addestramento:",A,_,H,S,W,L,ce='<code>Trainer</code> non valuta automaticamente le performance del modello durante l’addestramento. Dovrai passare a <code>Trainer</code> una funzione che calcola e restituisce le metriche. La libreria 🤗 Datasets mette a disposizione una semplice funzione <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> che puoi caricare con la funzione <code>load_metric</code> (guarda questa <a href="https://huggingface.co/docs/datasets/metrics" rel="nofollow">esercitazione</a> per maggiori informazioni):',U,X,Y,oe,P="Richiama <code>compute</code> su <code>metric</code> per calcolare l’accuratezza delle tue previsioni. Prima di passare le tue previsioni a <code>compute</code>, hai bisogno di convertirle in logits (ricorda che tutti i modelli 🤗 Transformers restituiscono logits):",I,R,n,y,ie="Se preferisci monitorare le tue metriche di valutazione durante il fine-tuning, specifica il parametro <code>evaluation_strategy</code> nei tuoi training arguments per restituire le metriche di valutazione ad ogni epoca di addestramento:",pe,D,de,K,fe,me,le="Crea un oggetto <code>Trainer</code> col tuo modello, training arguments, dataset di training e test, e funzione di valutazione:",Me,N,be,O,he="Poi metti a punto il modello richiamando <code>train()</code>:",re,ee,ue;return o=new Ke({props:{id:"nvBXf7s7vTI"}}),Z=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),G=new et({props:{$$slots:{default:[ut]},$$scope:{ctx:te}}}),F=new $e({props:{title:"Iperparametri per il training",local:"iperparametri-per-il-training",headingTag:"h3"}}),_=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`,wrap:!1}}),S=new $e({props:{title:"Metriche",local:"metriche",headingTag:"h3"}}),X=new z({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),R=new z({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),D=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhvdXRwdXRfZGlyJTNEJTIydGVzdF90cmFpbmVyJTIyJTJDJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`,wrap:!1}}),K=new $e({props:{title:"Trainer",local:"trainer",headingTag:"h3"}}),N=new z({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ee=new z({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),{c(){u(o.$$.fragment),j=i(),p=b("p"),p.innerHTML=J,v=i(),x=b("p"),x.innerHTML=ne,B=i(),u(Z.$$.fragment),q=i(),u(G.$$.fragment),Q=i(),u(F.$$.fragment),C=i(),k=b("p"),k.innerHTML=ae,V=i(),se=b("p"),se.textContent=E,A=i(),u(_.$$.fragment),H=i(),u(S.$$.fragment),W=i(),L=b("p"),L.innerHTML=ce,U=i(),u(X.$$.fragment),Y=i(),oe=b("p"),oe.innerHTML=P,I=i(),u(R.$$.fragment),n=i(),y=b("p"),y.innerHTML=ie,pe=i(),u(D.$$.fragment),de=i(),u(K.$$.fragment),fe=i(),me=b("p"),me.innerHTML=le,Me=i(),u(N.$$.fragment),be=i(),O=b("p"),O.innerHTML=he,re=i(),u(ee.$$.fragment)},l(s){f(o.$$.fragment,s),j=r(s),p=w(s,"P",{"data-svelte-h":!0}),T(p)!=="svelte-w7p6ip"&&(p.innerHTML=J),v=r(s),x=w(s,"P",{"data-svelte-h":!0}),T(x)!=="svelte-tdx1mf"&&(x.innerHTML=ne),B=r(s),f(Z.$$.fragment,s),q=r(s),f(G.$$.fragment,s),Q=r(s),f(F.$$.fragment,s),C=r(s),k=w(s,"P",{"data-svelte-h":!0}),T(k)!=="svelte-ae6lm"&&(k.innerHTML=ae),V=r(s),se=w(s,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1b2tmkh"&&(se.textContent=E),A=r(s),f(_.$$.fragment,s),H=r(s),f(S.$$.fragment,s),W=r(s),L=w(s,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1kybvc2"&&(L.innerHTML=ce),U=r(s),f(X.$$.fragment,s),Y=r(s),oe=w(s,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1i3t4rh"&&(oe.innerHTML=P),I=r(s),f(R.$$.fragment,s),n=r(s),y=w(s,"P",{"data-svelte-h":!0}),T(y)!=="svelte-ijtp5w"&&(y.innerHTML=ie),pe=r(s),f(D.$$.fragment,s),de=r(s),f(K.$$.fragment,s),fe=r(s),me=w(s,"P",{"data-svelte-h":!0}),T(me)!=="svelte-5ioy4b"&&(me.innerHTML=le),Me=r(s),f(N.$$.fragment,s),be=r(s),O=w(s,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1y3qbve"&&(O.innerHTML=he),re=r(s),f(ee.$$.fragment,s)},m(s,d){h(o,s,d),l(s,j,d),l(s,p,d),l(s,v,d),l(s,x,d),l(s,B,d),h(Z,s,d),l(s,q,d),h(G,s,d),l(s,Q,d),h(F,s,d),l(s,C,d),l(s,k,d),l(s,V,d),l(s,se,d),l(s,A,d),h(_,s,d),l(s,H,d),h(S,s,d),l(s,W,d),l(s,L,d),l(s,U,d),h(X,s,d),l(s,Y,d),l(s,oe,d),l(s,I,d),h(R,s,d),l(s,n,d),l(s,y,d),l(s,pe,d),h(D,s,d),l(s,de,d),h(K,s,d),l(s,fe,d),l(s,me,d),l(s,Me,d),h(N,s,d),l(s,be,d),l(s,O,d),l(s,re,d),h(ee,s,d),ue=!0},p(s,d){const we={};d&2&&(we.$$scope={dirty:d,ctx:s}),G.$set(we)},i(s){ue||(g(o.$$.fragment,s),g(Z.$$.fragment,s),g(G.$$.fragment,s),g(F.$$.fragment,s),g(_.$$.fragment,s),g(S.$$.fragment,s),g(X.$$.fragment,s),g(R.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(N.$$.fragment,s),g(ee.$$.fragment,s),ue=!0)},o(s){M(o.$$.fragment,s),M(Z.$$.fragment,s),M(G.$$.fragment,s),M(F.$$.fragment,s),M(_.$$.fragment,s),M(S.$$.fragment,s),M(X.$$.fragment,s),M(R.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(N.$$.fragment,s),M(ee.$$.fragment,s),ue=!1},d(s){s&&(a(j),a(p),a(v),a(x),a(B),a(q),a(Q),a(C),a(k),a(V),a(se),a(A),a(H),a(W),a(L),a(U),a(Y),a(oe),a(I),a(n),a(y),a(pe),a(de),a(fe),a(me),a(Me),a(be),a(O),a(re)),$(o,s),$(Z,s),$(G,s),$(F,s),$(_,s),$(S,s),$(X,s),$(R,s),$(D,s),$(K,s),$(N,s),$(ee,s)}}}function ht(te){let o,j;return o=new tt({props:{$$slots:{default:[ft]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),j=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){j||(g(o.$$.fragment,p),j=!0)},o(p){M(o.$$.fragment,p),j=!1},d(p){$(o,p)}}}function gt(te){let o,j="<code>Trainer</code> usa <code>DataCollatorWithPadding</code> in maniera predefinita in modo da non dover specificare esplicitamente un collettore di dati.";return{c(){o=b("p"),o.innerHTML=j},l(p){o=w(p,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1qdpgxe"&&(o.innerHTML=j)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function Mt(te){let o,j,p,J,v,x="I modelli 🤗 Transformers supportano anche l’addestramento in TensorFlow usando l’API di Keras.",ne,B,Z,q,G="Il <code>DefaultDataCollator</code> assembla tensori in lotti su cui il modello si addestrerà. Assicurati di specificare di restituire tensori per TensorFlow in <code>return_tensors</code>:",Q,F,C,k,ae,V,se='Successivamente, converti i datasets tokenizzati in TensorFlow datasets con il metodo <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>. Specifica il tuo input in <code>columns</code> e le tue etichette in <code>label_cols</code>:',E,A,_,H,S,W,L="Carica un modello TensorFlow col numero atteso di etichette:",ce,U,X,Y,oe='Poi compila e fai il fine-tuning del tuo modello usando <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> come faresti con qualsiasi altro modello di Keras:',P,I,R;return p=new Ke({props:{id:"rnTGBy2ax1c"}}),B=new $e({props:{title:"Convertire dataset nel formato per TensorFlow",local:"convertire-dataset-nel-formato-per-tensorflow",headingTag:"h3"}}),F=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),k=new et({props:{$$slots:{default:[gt]},$$scope:{ctx:te}}}),A=new z({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new $e({props:{title:"Compilazione e addestramento",local:"compilazione-e-addestramento",headingTag:"h3"}}),U=new z({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),I=new z({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`,wrap:!1}}),{c(){o=b("a"),j=i(),u(p.$$.fragment),J=i(),v=b("p"),v.textContent=x,ne=i(),u(B.$$.fragment),Z=i(),q=b("p"),q.innerHTML=G,Q=i(),u(F.$$.fragment),C=i(),u(k.$$.fragment),ae=i(),V=b("p"),V.innerHTML=se,E=i(),u(A.$$.fragment),_=i(),u(H.$$.fragment),S=i(),W=b("p"),W.textContent=L,ce=i(),u(U.$$.fragment),X=i(),Y=b("p"),Y.innerHTML=oe,P=i(),u(I.$$.fragment),this.h()},l(n){o=w(n,"A",{id:!0}),Ze(o).forEach(a),j=r(n),f(p.$$.fragment,n),J=r(n),v=w(n,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1czjgf4"&&(v.textContent=x),ne=r(n),f(B.$$.fragment,n),Z=r(n),q=w(n,"P",{"data-svelte-h":!0}),T(q)!=="svelte-18ilv9j"&&(q.innerHTML=G),Q=r(n),f(F.$$.fragment,n),C=r(n),f(k.$$.fragment,n),ae=r(n),V=w(n,"P",{"data-svelte-h":!0}),T(V)!=="svelte-10qeq0e"&&(V.innerHTML=se),E=r(n),f(A.$$.fragment,n),_=r(n),f(H.$$.fragment,n),S=r(n),W=w(n,"P",{"data-svelte-h":!0}),T(W)!=="svelte-7tvbf1"&&(W.textContent=L),ce=r(n),f(U.$$.fragment,n),X=r(n),Y=w(n,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-q3nlbx"&&(Y.innerHTML=oe),P=r(n),f(I.$$.fragment,n),this.h()},h(){Be(o,"id","keras")},m(n,y){l(n,o,y),l(n,j,y),h(p,n,y),l(n,J,y),l(n,v,y),l(n,ne,y),h(B,n,y),l(n,Z,y),l(n,q,y),l(n,Q,y),h(F,n,y),l(n,C,y),h(k,n,y),l(n,ae,y),l(n,V,y),l(n,E,y),h(A,n,y),l(n,_,y),h(H,n,y),l(n,S,y),l(n,W,y),l(n,ce,y),h(U,n,y),l(n,X,y),l(n,Y,y),l(n,P,y),h(I,n,y),R=!0},p(n,y){const ie={};y&2&&(ie.$$scope={dirty:y,ctx:n}),k.$set(ie)},i(n){R||(g(p.$$.fragment,n),g(B.$$.fragment,n),g(F.$$.fragment,n),g(k.$$.fragment,n),g(A.$$.fragment,n),g(H.$$.fragment,n),g(U.$$.fragment,n),g(I.$$.fragment,n),R=!0)},o(n){M(p.$$.fragment,n),M(B.$$.fragment,n),M(F.$$.fragment,n),M(k.$$.fragment,n),M(A.$$.fragment,n),M(H.$$.fragment,n),M(U.$$.fragment,n),M(I.$$.fragment,n),R=!1},d(n){n&&(a(o),a(j),a(J),a(v),a(ne),a(Z),a(q),a(Q),a(C),a(ae),a(V),a(E),a(_),a(S),a(W),a(ce),a(X),a(Y),a(P)),$(p,n),$(B,n),$(F,n),$(k,n),$(A,n),$(H,n),$(U,n),$(I,n)}}}function $t(te){let o,j;return o=new tt({props:{$$slots:{default:[Mt]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),j=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){j||(g(o.$$.fragment,p),j=!0)},o(p){M(o.$$.fragment,p),j=!1},d(p){$(o,p)}}}function bt(te){let o,j='Ottieni l’accesso gratuito a una GPU sul cloud se non ne possiedi una usando un notebook sul web come <a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> o <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>.';return{c(){o=b("p"),o.innerHTML=j},l(p){o=w(p,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1uxpyqe"&&(o.innerHTML=j)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function wt(te){let o,j,p,J="<code>Trainer</code> si occupa del ciclo di addestramento e ti consente di mettere a punto un modello con una sola riga di codice. Per chi preferisse scrivere un proprio ciclo di addestramento personale, puoi anche fare il fine-tuning di un modello 🤗 Transformers in PyTorch nativo.",v,x,ne="A questo punto, potresti avere bisogno di riavviare il tuo notebook o eseguire il seguente codice per liberare un po’ di memoria:",B,Z,q,G,Q="Successivamente, postprocessa manualmente il <code>tokenized_dataset</code> per prepararlo ad essere allenato.",F,C,k,ae,V="Rimuovi la colonna <code>text</code> perché il modello non accetta testo grezzo come input:",se,E,A,_,H,S="Rinomina la colonna <code>label</code> in <code>labels</code> perché il modello si aspetta che questo argomento si chiami <code>labels</code>:",W,L,ce,U,X,Y="Imposta il formato del dataset per farti restituire tensori di PyTorch all’interno delle liste:",oe,P,I,R,n="Poi crea un piccolo sottocampione del dataset come visto precedentemente per velocizzare il fine-tuning:",y,ie,pe,D,de,K,fe="Crea un <code>DataLoader</code> per i tuoi datasets di train e test così puoi iterare sui lotti di dati:",me,le,Me,N,be="Carica il tuo modello con il numero atteso di etichette:",O,he,re,ee,ue,s,d='Crea un ottimizzatore e il learning rate scheduler per fare il fine-tuning del modello. Usa l’ottimizzatore <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> di PyTorch:',we,ge,Ce,ye,_e="Crea il learning rate scheduler predefinito da <code>Trainer</code>:",Ie,je,Te,Je,ze="Infine specifica come <code>device</code> da usare una GPU se ne hai una. Altrimenti, l’addestramento su una CPU può richiedere diverse ore invece di un paio di minuti.",Ue,t,m,ke,Re,Ge,at="Ottimo, adesso possiamo addestrare! 🥳",He,We,Ne,Xe,st='Per tenere traccia dei tuoi progressi durante l’addestramento, usa la libreria <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> per aggiungere una progress bar sopra il numero dei passi di addestramento:',Ae,xe,Le,Fe,qe,Ve,lt='Proprio come è necessario aggiungere una funzione di valutazione del <code>Trainer</code>, è necessario fare lo stesso quando si scrive il proprio ciclo di addestramento. Ma invece di calcolare e riportare la metrica alla fine di ogni epoca, questa volta accumulerai tutti i batch con <a href="https://huggingface.co/docs/datasets/package_reference/main_classes?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a> e calcolerai la metrica alla fine.',Qe,Ee,Se;return o=new Ke({props:{id:"Dh9CL8fyG80"}}),Z=new z({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`,wrap:!1}}),E=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])',wrap:!1}}),L=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)',wrap:!1}}),P=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)',wrap:!1}}),ie=new z({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),D=new $e({props:{title:"DataLoader",local:"dataloader",headingTag:"h3"}}),le=new z({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`,wrap:!1}}),he=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),ee=new $e({props:{title:"Ottimizzatore e learning rate scheduler",local:"ottimizzatore-e-learning-rate-scheduler",headingTag:"h3"}}),ge=new z({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),je=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`,wrap:!1}}),t=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),ke=new et({props:{$$slots:{default:[bt]},$$scope:{ctx:te}}}),We=new $e({props:{title:"Training loop",local:"training-loop",headingTag:"h3"}}),xe=new z({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Fe=new $e({props:{title:"Metriche",local:"metriche",headingTag:"h3"}}),Ee=new z({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),{c(){u(o.$$.fragment),j=i(),p=b("p"),p.innerHTML=J,v=i(),x=b("p"),x.textContent=ne,B=i(),u(Z.$$.fragment),q=i(),G=b("p"),G.innerHTML=Q,F=i(),C=b("ol"),k=b("li"),ae=b("p"),ae.innerHTML=V,se=i(),u(E.$$.fragment),A=i(),_=b("li"),H=b("p"),H.innerHTML=S,W=i(),u(L.$$.fragment),ce=i(),U=b("li"),X=b("p"),X.textContent=Y,oe=i(),u(P.$$.fragment),I=i(),R=b("p"),R.textContent=n,y=i(),u(ie.$$.fragment),pe=i(),u(D.$$.fragment),de=i(),K=b("p"),K.innerHTML=fe,me=i(),u(le.$$.fragment),Me=i(),N=b("p"),N.textContent=be,O=i(),u(he.$$.fragment),re=i(),u(ee.$$.fragment),ue=i(),s=b("p"),s.innerHTML=d,we=i(),u(ge.$$.fragment),Ce=i(),ye=b("p"),ye.innerHTML=_e,Ie=i(),u(je.$$.fragment),Te=i(),Je=b("p"),Je.innerHTML=ze,Ue=i(),u(t.$$.fragment),m=i(),u(ke.$$.fragment),Re=i(),Ge=b("p"),Ge.textContent=at,He=i(),u(We.$$.fragment),Ne=i(),Xe=b("p"),Xe.innerHTML=st,Ae=i(),u(xe.$$.fragment),Le=i(),u(Fe.$$.fragment),qe=i(),Ve=b("p"),Ve.innerHTML=lt,Qe=i(),u(Ee.$$.fragment)},l(e){f(o.$$.fragment,e),j=r(e),p=w(e,"P",{"data-svelte-h":!0}),T(p)!=="svelte-1czap62"&&(p.innerHTML=J),v=r(e),x=w(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1jv7qcp"&&(x.textContent=ne),B=r(e),f(Z.$$.fragment,e),q=r(e),G=w(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-p1uyrm"&&(G.innerHTML=Q),F=r(e),C=w(e,"OL",{});var c=Ze(C);k=w(c,"LI",{});var Ye=Ze(k);ae=w(Ye,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-unbmvy"&&(ae.innerHTML=V),se=r(Ye),f(E.$$.fragment,Ye),Ye.forEach(a),A=r(c),_=w(c,"LI",{});var Pe=Ze(_);H=w(Pe,"P",{"data-svelte-h":!0}),T(H)!=="svelte-zdvzgi"&&(H.innerHTML=S),W=r(Pe),f(L.$$.fragment,Pe),Pe.forEach(a),ce=r(c),U=w(c,"LI",{});var De=Ze(U);X=w(De,"P",{"data-svelte-h":!0}),T(X)!=="svelte-ufikes"&&(X.textContent=Y),oe=r(De),f(P.$$.fragment,De),De.forEach(a),c.forEach(a),I=r(e),R=w(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-6j1d26"&&(R.textContent=n),y=r(e),f(ie.$$.fragment,e),pe=r(e),f(D.$$.fragment,e),de=r(e),K=w(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1wjjxmk"&&(K.innerHTML=fe),me=r(e),f(le.$$.fragment,e),Me=r(e),N=w(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-k6va0p"&&(N.textContent=be),O=r(e),f(he.$$.fragment,e),re=r(e),f(ee.$$.fragment,e),ue=r(e),s=w(e,"P",{"data-svelte-h":!0}),T(s)!=="svelte-q4abxx"&&(s.innerHTML=d),we=r(e),f(ge.$$.fragment,e),Ce=r(e),ye=w(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-1o911h5"&&(ye.innerHTML=_e),Ie=r(e),f(je.$$.fragment,e),Te=r(e),Je=w(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-jmyeit"&&(Je.innerHTML=ze),Ue=r(e),f(t.$$.fragment,e),m=r(e),f(ke.$$.fragment,e),Re=r(e),Ge=w(e,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1x4skh5"&&(Ge.textContent=at),He=r(e),f(We.$$.fragment,e),Ne=r(e),Xe=w(e,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-yb503k"&&(Xe.innerHTML=st),Ae=r(e),f(xe.$$.fragment,e),Le=r(e),f(Fe.$$.fragment,e),qe=r(e),Ve=w(e,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-pbidtd"&&(Ve.innerHTML=lt),Qe=r(e),f(Ee.$$.fragment,e)},m(e,c){h(o,e,c),l(e,j,c),l(e,p,c),l(e,v,c),l(e,x,c),l(e,B,c),h(Z,e,c),l(e,q,c),l(e,G,c),l(e,F,c),l(e,C,c),ve(C,k),ve(k,ae),ve(k,se),h(E,k,null),ve(C,A),ve(C,_),ve(_,H),ve(_,W),h(L,_,null),ve(C,ce),ve(C,U),ve(U,X),ve(U,oe),h(P,U,null),l(e,I,c),l(e,R,c),l(e,y,c),h(ie,e,c),l(e,pe,c),h(D,e,c),l(e,de,c),l(e,K,c),l(e,me,c),h(le,e,c),l(e,Me,c),l(e,N,c),l(e,O,c),h(he,e,c),l(e,re,c),h(ee,e,c),l(e,ue,c),l(e,s,c),l(e,we,c),h(ge,e,c),l(e,Ce,c),l(e,ye,c),l(e,Ie,c),h(je,e,c),l(e,Te,c),l(e,Je,c),l(e,Ue,c),h(t,e,c),l(e,m,c),h(ke,e,c),l(e,Re,c),l(e,Ge,c),l(e,He,c),h(We,e,c),l(e,Ne,c),l(e,Xe,c),l(e,Ae,c),h(xe,e,c),l(e,Le,c),h(Fe,e,c),l(e,qe,c),l(e,Ve,c),l(e,Qe,c),h(Ee,e,c),Se=!0},p(e,c){const Ye={};c&2&&(Ye.$$scope={dirty:c,ctx:e}),ke.$set(Ye)},i(e){Se||(g(o.$$.fragment,e),g(Z.$$.fragment,e),g(E.$$.fragment,e),g(L.$$.fragment,e),g(P.$$.fragment,e),g(ie.$$.fragment,e),g(D.$$.fragment,e),g(le.$$.fragment,e),g(he.$$.fragment,e),g(ee.$$.fragment,e),g(ge.$$.fragment,e),g(je.$$.fragment,e),g(t.$$.fragment,e),g(ke.$$.fragment,e),g(We.$$.fragment,e),g(xe.$$.fragment,e),g(Fe.$$.fragment,e),g(Ee.$$.fragment,e),Se=!0)},o(e){M(o.$$.fragment,e),M(Z.$$.fragment,e),M(E.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(ie.$$.fragment,e),M(D.$$.fragment,e),M(le.$$.fragment,e),M(he.$$.fragment,e),M(ee.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(t.$$.fragment,e),M(ke.$$.fragment,e),M(We.$$.fragment,e),M(xe.$$.fragment,e),M(Fe.$$.fragment,e),M(Ee.$$.fragment,e),Se=!1},d(e){e&&(a(j),a(p),a(v),a(x),a(B),a(q),a(G),a(F),a(C),a(I),a(R),a(y),a(pe),a(de),a(K),a(me),a(Me),a(N),a(O),a(re),a(ue),a(s),a(we),a(Ce),a(ye),a(Ie),a(Te),a(Je),a(Ue),a(m),a(Re),a(Ge),a(He),a(Ne),a(Xe),a(Ae),a(Le),a(qe),a(Ve),a(Qe)),$(o,e),$(Z,e),$(E),$(L),$(P),$(ie,e),$(D,e),$(le,e),$(he,e),$(ee,e),$(ge,e),$(je,e),$(t,e),$(ke,e),$(We,e),$(xe,e),$(Fe,e),$(Ee,e)}}}function yt(te){let o,j;return o=new tt({props:{$$slots:{default:[wt]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),j=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){j||(g(o.$$.fragment,p),j=!0)},o(p){M(o.$$.fragment,p),j=!1},d(p){$(o,p)}}}function jt(te){let o,j,p,J,v,x,ne,B,Z,q="Ci sono benefici significativi nell’usare un modello pre-addestrato. Si riducono i costi computazionali, l’impronta di carbonio e ti consente di usare modelli stato dell’arte senza doverli addestrare da zero. 🤗 Transformers consente l’accesso a migliaia di modelli pre-addestrati per un’ampia gamma di compiti. Quando usi un modello pre-addestrato, lo alleni su un dataset specifico per il tuo compito. Questo è conosciuto come fine-tuning, una tecnica di addestramento incredibilmente potente. In questa esercitazione, potrai fare il fine-tuning di un modello pre-addestrato, con un framework di deep learning a tua scelta:",G,Q,F="<li>Fine-tuning di un modello pre-addestrato con 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning di un modello pre-addestrato in TensorFlow con Keras.</li> <li>Fine-tuning di un modello pre-addestrato con PyTorch.</li>",C,k,ae,V,se,E,A,_,H="Prima di poter fare il fine-tuning di un modello pre-addestrato, scarica un dataset e preparalo per l’addestramento. La precedente esercitazione ti ha mostrato come processare i dati per l’addestramento e adesso hai l’opportunità di metterti alla prova!",S,W,L='Inizia caricando il dataset <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',ce,U,X,Y,oe='Come già sai, hai bisogno di un tokenizer per processare il testo e includere una strategia di padding e truncation per gestire sequenze di lunghezza variabile. Per processare il dataset in un unico passo, usa il metodo <a href="https://huggingface.co/docs/datasets/process#map" rel="nofollow"><code>map</code></a> di 🤗 Datasets che applica la funzione di preprocessing all’intero dataset:',P,I,R,n,y="Se vuoi, puoi creare un sottoinsieme più piccolo del dataset per il fine-tuning così da ridurre il tempo necessario:",ie,pe,D,de,K,fe,me,le,Me,N,be,O,he,re,ee,ue,s,d,we,ge,Ce="Per altri esempi sul fine-tuning, fai riferimento a:",ye,_e,Ie='<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> include scripts per addestrare compiti comuni di NLP in PyTorch e TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contiene diversi notebooks su come mettere a punto un modello per compiti specifici in PyTorch e TensorFlow.</p></li>',je,Te,Je,ze,Ue;return v=new $e({props:{title:"Fine-tuning di un modello pre-addestrato",local:"fine-tuning-di-un-modello-pre-addestrato",headingTag:"h1"}}),ne=new ct({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/training.ipynb"}]}}),V=new $e({props:{title:"Preparare un dataset",local:"preparare-un-dataset",headingTag:"h2"}}),E=new Ke({props:{id:"_BZearw7f0w"}}),U=new z({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCU1QjEwMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`,wrap:!1}}),I=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMEFkZWYlMjB0b2tlbml6ZV9mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new z({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),fe=new $e({props:{title:"Addestramento",local:"addestramento",headingTag:"h2"}}),le=new nt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[$t],pytorch:[ht]},$$scope:{ctx:te}}}),O=new $e({props:{title:"Addestramento in PyTorch nativo",local:"addestramento-in-pytorch-nativo",headingTag:"h2"}}),re=new nt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[yt]},$$scope:{ctx:te}}}),d=new $e({props:{title:"Altre risorse",local:"altre-risorse",headingTag:"h2"}}),Te=new dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/training.md"}}),{c(){o=b("meta"),j=i(),p=b("p"),J=i(),u(v.$$.fragment),x=i(),u(ne.$$.fragment),B=i(),Z=b("p"),Z.textContent=q,G=i(),Q=b("ul"),Q.innerHTML=F,C=i(),k=b("a"),ae=i(),u(V.$$.fragment),se=i(),u(E.$$.fragment),A=i(),_=b("p"),_.textContent=H,S=i(),W=b("p"),W.innerHTML=L,ce=i(),u(U.$$.fragment),X=i(),Y=b("p"),Y.innerHTML=oe,P=i(),u(I.$$.fragment),R=i(),n=b("p"),n.textContent=y,ie=i(),u(pe.$$.fragment),D=i(),de=b("a"),K=i(),u(fe.$$.fragment),me=i(),u(le.$$.fragment),Me=i(),N=b("a"),be=i(),u(O.$$.fragment),he=i(),u(re.$$.fragment),ee=i(),ue=b("a"),s=i(),u(d.$$.fragment),we=i(),ge=b("p"),ge.textContent=Ce,ye=i(),_e=b("ul"),_e.innerHTML=Ie,je=i(),u(Te.$$.fragment),Je=i(),ze=b("p"),this.h()},l(t){const m=mt("svelte-u9bgzb",document.head);o=w(m,"META",{name:!0,content:!0}),m.forEach(a),j=r(t),p=w(t,"P",{}),Ze(p).forEach(a),J=r(t),f(v.$$.fragment,t),x=r(t),f(ne.$$.fragment,t),B=r(t),Z=w(t,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-gx4agk"&&(Z.textContent=q),G=r(t),Q=w(t,"UL",{"data-svelte-h":!0}),T(Q)!=="svelte-cwrdoc"&&(Q.innerHTML=F),C=r(t),k=w(t,"A",{id:!0}),Ze(k).forEach(a),ae=r(t),f(V.$$.fragment,t),se=r(t),f(E.$$.fragment,t),A=r(t),_=w(t,"P",{"data-svelte-h":!0}),T(_)!=="svelte-n29iv5"&&(_.textContent=H),S=r(t),W=w(t,"P",{"data-svelte-h":!0}),T(W)!=="svelte-128hpxg"&&(W.innerHTML=L),ce=r(t),f(U.$$.fragment,t),X=r(t),Y=w(t,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-16x5igm"&&(Y.innerHTML=oe),P=r(t),f(I.$$.fragment,t),R=r(t),n=w(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-14sxrz7"&&(n.textContent=y),ie=r(t),f(pe.$$.fragment,t),D=r(t),de=w(t,"A",{id:!0}),Ze(de).forEach(a),K=r(t),f(fe.$$.fragment,t),me=r(t),f(le.$$.fragment,t),Me=r(t),N=w(t,"A",{id:!0}),Ze(N).forEach(a),be=r(t),f(O.$$.fragment,t),he=r(t),f(re.$$.fragment,t),ee=r(t),ue=w(t,"A",{id:!0}),Ze(ue).forEach(a),s=r(t),f(d.$$.fragment,t),we=r(t),ge=w(t,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-1ja6793"&&(ge.textContent=Ce),ye=r(t),_e=w(t,"UL",{"data-svelte-h":!0}),T(_e)!=="svelte-1y57zg6"&&(_e.innerHTML=Ie),je=r(t),f(Te.$$.fragment,t),Je=r(t),ze=w(t,"P",{}),Ze(ze).forEach(a),this.h()},h(){Be(o,"name","hf:doc:metadata"),Be(o,"content",Tt),Be(k,"id","data-processing"),Be(de,"id","trainer"),Be(N,"id","pytorch_native"),Be(ue,"id","additional-resources")},m(t,m){ve(document.head,o),l(t,j,m),l(t,p,m),l(t,J,m),h(v,t,m),l(t,x,m),h(ne,t,m),l(t,B,m),l(t,Z,m),l(t,G,m),l(t,Q,m),l(t,C,m),l(t,k,m),l(t,ae,m),h(V,t,m),l(t,se,m),h(E,t,m),l(t,A,m),l(t,_,m),l(t,S,m),l(t,W,m),l(t,ce,m),h(U,t,m),l(t,X,m),l(t,Y,m),l(t,P,m),h(I,t,m),l(t,R,m),l(t,n,m),l(t,ie,m),h(pe,t,m),l(t,D,m),l(t,de,m),l(t,K,m),h(fe,t,m),l(t,me,m),h(le,t,m),l(t,Me,m),l(t,N,m),l(t,be,m),h(O,t,m),l(t,he,m),h(re,t,m),l(t,ee,m),l(t,ue,m),l(t,s,m),h(d,t,m),l(t,we,m),l(t,ge,m),l(t,ye,m),l(t,_e,m),l(t,je,m),h(Te,t,m),l(t,Je,m),l(t,ze,m),Ue=!0},p(t,[m]){const ke={};m&2&&(ke.$$scope={dirty:m,ctx:t}),le.$set(ke);const Re={};m&2&&(Re.$$scope={dirty:m,ctx:t}),re.$set(Re)},i(t){Ue||(g(v.$$.fragment,t),g(ne.$$.fragment,t),g(V.$$.fragment,t),g(E.$$.fragment,t),g(U.$$.fragment,t),g(I.$$.fragment,t),g(pe.$$.fragment,t),g(fe.$$.fragment,t),g(le.$$.fragment,t),g(O.$$.fragment,t),g(re.$$.fragment,t),g(d.$$.fragment,t),g(Te.$$.fragment,t),Ue=!0)},o(t){M(v.$$.fragment,t),M(ne.$$.fragment,t),M(V.$$.fragment,t),M(E.$$.fragment,t),M(U.$$.fragment,t),M(I.$$.fragment,t),M(pe.$$.fragment,t),M(fe.$$.fragment,t),M(le.$$.fragment,t),M(O.$$.fragment,t),M(re.$$.fragment,t),M(d.$$.fragment,t),M(Te.$$.fragment,t),Ue=!1},d(t){t&&(a(j),a(p),a(J),a(x),a(B),a(Z),a(G),a(Q),a(C),a(k),a(ae),a(se),a(A),a(_),a(S),a(W),a(ce),a(X),a(Y),a(P),a(R),a(n),a(ie),a(D),a(de),a(K),a(me),a(Me),a(N),a(be),a(he),a(ee),a(ue),a(s),a(we),a(ge),a(ye),a(_e),a(je),a(Je),a(ze)),a(o),$(v,t),$(ne,t),$(V,t),$(E,t),$(U,t),$(I,t),$(pe,t),$(fe,t),$(le,t),$(O,t),$(re,t),$(d,t),$(Te,t)}}}const Tt='{"title":"Fine-tuning di un modello pre-addestrato","local":"fine-tuning-di-un-modello-pre-addestrato","sections":[{"title":"Preparare un dataset","local":"preparare-un-dataset","sections":[],"depth":2},{"title":"Addestramento","local":"addestramento","sections":[{"title":"Iperparametri per il training","local":"iperparametri-per-il-training","sections":[],"depth":3},{"title":"Metriche","local":"metriche","sections":[],"depth":3},{"title":"Trainer","local":"trainer","sections":[],"depth":3},{"title":"Convertire dataset nel formato per TensorFlow","local":"convertire-dataset-nel-formato-per-tensorflow","sections":[],"depth":3},{"title":"Compilazione e addestramento","local":"compilazione-e-addestramento","sections":[],"depth":3}],"depth":2},{"title":"Addestramento in PyTorch nativo","local":"addestramento-in-pytorch-nativo","sections":[{"title":"DataLoader","local":"dataloader","sections":[],"depth":3},{"title":"Ottimizzatore e learning rate scheduler","local":"ottimizzatore-e-learning-rate-scheduler","sections":[],"depth":3},{"title":"Training loop","local":"training-loop","sections":[],"depth":3},{"title":"Metriche","local":"metriche","sections":[],"depth":3}],"depth":2},{"title":"Altre risorse","local":"altre-risorse","sections":[],"depth":2}],"depth":1}';function Jt(te){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends ot{constructor(o){super(),pt(this,o,Jt,jt,it,{})}}export{Rt as component};
