import{s as Dn,o as Rn,n as E}from"../chunks/scheduler.6062bdaf.js";import{S as kn,i as En,g as p,s as o,r as m,A as Nn,h as d,f as t,c as r,j as J,u as h,x as C,k as x,y as i,a as c,v as u,d as M,t as f,w as y,m as $n,n as In}from"../chunks/index.4bca734e.js";import{T as An}from"../chunks/Tip.b9ac1f03.js";import{D as w}from"../chunks/Docstring.ed07512f.js";import{C as X}from"../chunks/CodeBlock.fa01571c.js";import{E as B}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as $}from"../chunks/Heading.723dceba.js";function Zn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBdGV4dCUyMCUzRCUyMCcnJyUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTIzJTIwTXklMjByZXBvJTBBJycnJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkKHRleHQpJTBBY2FyZC5kYXRhLnRvX2RpY3QoKSUwQWNhcmQudGV4dCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>language: en
<span class="hljs-meta">... </span>license: mit
<span class="hljs-meta">... </span>---
...
<span class="hljs-meta">... </span># My repo
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard(text)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.to_dict()
{<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>card.text
<span class="hljs-string">&#x27;\\n# My repo\\n&#x27;</span>
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Wn(U){let n,j,_=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
when the content of the repo card metadata is not a dictionary.</li>`;return{c(){n=$n(`Raises the following error:
`),j=p("ul"),j.innerHTML=_},l(s){n=In(s,`Raises the following error:
`),j=d(s,"UL",{"data-svelte-h":!0}),C(j)!=="svelte-1ewksj3"&&(j.innerHTML=_)},m(s,g){c(s,n,g),c(s,j,g)},p:E,d(s){s&&(t(n),t(j))}}}function Gn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkLmxvYWQoJTIybmF0ZXJhdyUyRmZvb2QlMjIpJTBBYXNzZXJ0JTIwY2FyZC5kYXRhLnRhZ3MlMjAlM0QlM0QlMjAlNUIlMjJnZW5lcmF0ZWRfZnJvbV90cmFpbmVyJTIyJTJDJTIwJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJweXRvcmNoJTIyJTVEJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard.load(<span class="hljs-string">&quot;nateraw/food&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> card.data.tags == [<span class="hljs-string">&quot;generated_from_trainer&quot;</span>, <span class="hljs-string">&quot;image-classification&quot;</span>, <span class="hljs-string">&quot;pytorch&quot;</span>]
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Yn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkKCUyMi0tLSU1Q25sYW5ndWFnZSUzQSUyMGVuJTVDbi0tLSU1Q24lMjMlMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMHJlcG8lMjBjYXJkJTIyKSUwQWNhcmQuc2F2ZSglMjIlMkZ0bXAlMkZ0ZXN0Lm1kJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard(<span class="hljs-string">&quot;---\\nlanguage: en\\n---\\n# This is a test repo card&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.save(<span class="hljs-string">&quot;/tmp/test.md&quot;</span>)
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Fn(U){let n,j,_=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if the card fails validation checks.</li> <li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the request to the Hub API fails for any other reason.</li>`;return{c(){n=$n(`Raises the following errors:
`),j=p("ul"),j.innerHTML=_},l(s){n=In(s,`Raises the following errors:
`),j=d(s,"UL",{"data-svelte-h":!0}),C(j)!=="svelte-brxevo"&&(j.innerHTML=_)},m(s,g){c(s,n,g),c(s,j,g)},p:E,d(s){s&&(t(n),t(j))}}}function Qn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData, EvalResult

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using the Default Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>    library_name=<span class="hljs-string">&#x27;timm&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>    datasets=[<span class="hljs-string">&#x27;beans&#x27;</span>],
<span class="hljs-meta">... </span>    metrics=[<span class="hljs-string">&#x27;accuracy&#x27;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(
<span class="hljs-meta">... </span>    card_data,
<span class="hljs-meta">... </span>    model_description=<span class="hljs-string">&#x27;This model does x + y...&#x27;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Including Evaluation Results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>    eval_results=[
<span class="hljs-meta">... </span>        EvalResult(
<span class="hljs-meta">... </span>            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
<span class="hljs-meta">... </span>            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
<span class="hljs-meta">... </span>            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
<span class="hljs-meta">... </span>            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
<span class="hljs-meta">... </span>            metric_value=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(card_data)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using a Custom Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(
<span class="hljs-meta">... </span>    card_data=card_data,
<span class="hljs-meta">... </span>    template_path=<span class="hljs-string">&#x27;./src/huggingface_hub/templates/modelcard_template.md&#x27;</span>,
<span class="hljs-meta">... </span>    custom_template_var=<span class="hljs-string">&#x27;custom value&#x27;</span>,  <span class="hljs-comment"># will be replaced in template if it exists</span>
<span class="hljs-meta">... </span>)
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Sn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZERhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBNb2RlbENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJTIybWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIydGltbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhZ3MlM0QlNUInaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTIwJ3Jlc25ldCclNUQlMkMlMEEpJTBBY2FyZF9kYXRhLnRvX2RpY3QoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCardData
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&quot;en&quot;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&quot;mit&quot;</span>,
<span class="hljs-meta">... </span>    library_name=<span class="hljs-string">&quot;timm&quot;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data.to_dict()
{<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>, <span class="hljs-string">&#x27;library_name&#x27;</span>: <span class="hljs-string">&#x27;timm&#x27;</span>, <span class="hljs-string">&#x27;tags&#x27;</span>: [<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>]}
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Bn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMERhdGFzZXRDYXJkJTJDJTIwRGF0YXNldENhcmREYXRhJTBBJTBBJTIzJTIwVXNpbmclMjB0aGUlMjBEZWZhdWx0JTIwVGVtcGxhdGUlMEFjYXJkX2RhdGElMjAlM0QlMjBEYXRhc2V0Q2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwbGFuZ3VhZ2UlM0QnZW4nJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnNfY3JlYXRvcnMlM0QnY3Jvd2Rzb3VyY2VkJyUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfY2F0ZWdvcmllcyUzRCU1Qid0ZXh0LWNsYXNzaWZpY2F0aW9uJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfaWRzJTNEJTVCJ3NlbnRpbWVudC1jbGFzc2lmaWNhdGlvbiclMkMlMjAndGV4dC1zY29yaW5nJyU1RCUyQyUwQSUyMCUyMCUyMCUyMG11bHRpbGluZ3VhbGl0eSUzRCdtb25vbGluZ3VhbCclMkMlMEElMjAlMjAlMjAlMjBwcmV0dHlfbmFtZSUzRCdNeSUyMFRleHQlMjBDbGFzc2lmaWNhdGlvbiUyMERhdGFzZXQnJTJDJTBBKSUwQWNhcmQlMjAlM0QlMjBEYXRhc2V0Q2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMGNhcmRfZGF0YSUyQyUwQSUyMCUyMCUyMCUyMHByZXR0eV9uYW1lJTNEY2FyZF9kYXRhLnByZXR0eV9uYW1lJTJDJTBBKSUwQSUwQSUyMyUyMFVzaW5nJTIwYSUyMEN1c3RvbSUyMFRlbXBsYXRlJTBBY2FyZF9kYXRhJTIwJTNEJTIwRGF0YXNldENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJ2VuJyUyQyUwQSUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUwQSklMEFjYXJkJTIwJTNEJTIwRGF0YXNldENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElM0RjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjB0ZW1wbGF0ZV9wYXRoJTNEJy4lMkZzcmMlMkZodWdnaW5nZmFjZV9odWIlMkZ0ZW1wbGF0ZXMlMkZkYXRhc2V0Y2FyZF90ZW1wbGF0ZS5tZCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fdGVtcGxhdGVfdmFyJTNEJ2N1c3RvbSUyMHZhbHVlJyUyQyUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMHJlcGxhY2VkJTIwaW4lMjB0ZW1wbGF0ZSUyMGlmJTIwaXQlMjBleGlzdHMlMEEpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> DatasetCard, DatasetCardData

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using the Default Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = DatasetCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>    annotations_creators=<span class="hljs-string">&#x27;crowdsourced&#x27;</span>,
<span class="hljs-meta">... </span>    task_categories=[<span class="hljs-string">&#x27;text-classification&#x27;</span>],
<span class="hljs-meta">... </span>    task_ids=[<span class="hljs-string">&#x27;sentiment-classification&#x27;</span>, <span class="hljs-string">&#x27;text-scoring&#x27;</span>],
<span class="hljs-meta">... </span>    multilinguality=<span class="hljs-string">&#x27;monolingual&#x27;</span>,
<span class="hljs-meta">... </span>    pretty_name=<span class="hljs-string">&#x27;My Text Classification Dataset&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = DatasetCard.from_template(
<span class="hljs-meta">... </span>    card_data,
<span class="hljs-meta">... </span>    pretty_name=card_data.pretty_name,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using a Custom Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = DatasetCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = DatasetCard.from_template(
<span class="hljs-meta">... </span>    card_data=card_data,
<span class="hljs-meta">... </span>    template_path=<span class="hljs-string">&#x27;./src/huggingface_hub/templates/datasetcard_template.md&#x27;</span>,
<span class="hljs-meta">... </span>    custom_template_var=<span class="hljs-string">&#x27;custom value&#x27;</span>,  <span class="hljs-comment"># will be replaced in template if it exists</span>
<span class="hljs-meta">... </span>)
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Xn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlQ2FyZERhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBTcGFjZUNhcmREYXRhKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyRHJlYW1ib290aCUyMFRyYWluaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCUyMm1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNkayUzRCUyMmdyYWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMGR1cGxpY2F0ZWRfZnJvbSUzRCUyMm11bHRpbW9kYWxhcnQlMkZkcmVhbWJvb3RoLXRyYWluaW5nJTIyJTBBKSUwQWNhcmRfZGF0YS50b19kaWN0KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceCardData
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = SpaceCardData(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Dreambooth Training&quot;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&quot;mit&quot;</span>,
<span class="hljs-meta">... </span>    sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    duplicated_from=<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data.to_dict()
{<span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Dreambooth Training&#x27;</span>, <span class="hljs-string">&#x27;sdk&#x27;</span>: <span class="hljs-string">&#x27;gradio&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>, <span class="hljs-string">&#x27;duplicated_from&#x27;</span>: <span class="hljs-string">&#x27;multimodalart/dreambooth-training&#x27;</span>}`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Vn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard_data <span class="hljs-keyword">import</span> model_index_to_eval_results
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define a minimal model index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_index = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;my-cool-model&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;results&quot;</span>: [
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;task&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;dataset&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;beans&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Beans&quot;</span>
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;metrics&quot;</span>: [
<span class="hljs-meta">... </span>                    {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-number">0.9</span>
<span class="hljs-meta">... </span>                    }
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name, eval_results = model_index_to_eval_results(model_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name
<span class="hljs-string">&#x27;my-cool-model&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results[<span class="hljs-number">0</span>].task_type
<span class="hljs-string">&#x27;image-classification&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results[<span class="hljs-number">0</span>].metric_type
<span class="hljs-string">&#x27;accuracy&#x27;</span>
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Ln(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZF9kYXRhJTIwaW1wb3J0JTIwZXZhbF9yZXN1bHRzX3RvX21vZGVsX2luZGV4JTJDJTIwRXZhbFJlc3VsdCUwQSUyMyUyMERlZmluZSUyMG1pbmltYWwlMjBldmFsX3Jlc3VsdHMlMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBFdmFsUmVzdWx0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwJTIwJTIzJTIwUmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X3R5cGUlM0QlMjJiZWFucyUyMiUyQyUyMCUyMCUyMyUyMFJlcXVpcmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyQmVhbnMlMjIlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY190eXBlJTNEJTIyYWNjdXJhY3klMjIlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY192YWx1ZSUzRDAuOSUyQyUyMCUyMCUyMyUyMFJlcXVpcmVkJTBBJTIwJTIwJTIwJTIwKSUwQSU1RCUwQWV2YWxfcmVzdWx0c190b19tb2RlbF9pbmRleCglMjJteS1jb29sLW1vZGVsJTIyJTJDJTIwZXZhbF9yZXN1bHRzKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard_data <span class="hljs-keyword">import</span> eval_results_to_model_index, EvalResult
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define minimal eval_results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results = [
<span class="hljs-meta">... </span>    EvalResult(
<span class="hljs-meta">... </span>        task_type=<span class="hljs-string">&quot;image-classification&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        dataset_type=<span class="hljs-string">&quot;beans&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        dataset_name=<span class="hljs-string">&quot;Beans&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        metric_type=<span class="hljs-string">&quot;accuracy&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        metric_value=<span class="hljs-number">0.9</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results_to_model_index(<span class="hljs-string">&quot;my-cool-model&quot;</span>, eval_results)
[{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;my-cool-model&#x27;</span>, <span class="hljs-string">&#x27;results&#x27;</span>: [{<span class="hljs-string">&#x27;task&#x27;</span>: {<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;image-classification&#x27;</span>}, <span class="hljs-string">&#x27;dataset&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Beans&#x27;</span>, <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;beans&#x27;</span>}, <span class="hljs-string">&#x27;metrics&#x27;</span>: [{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;accuracy&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.9</span>}]}]}]
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function Hn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_eval_result
<span class="hljs-meta">&gt;&gt;&gt; </span>results = metadata_eval_result(
<span class="hljs-meta">... </span>        model_pretty_name=<span class="hljs-string">&quot;RoBERTa fine-tuned on ReactionGIF&quot;</span>,
<span class="hljs-meta">... </span>        task_pretty_name=<span class="hljs-string">&quot;Text Classification&quot;</span>,
<span class="hljs-meta">... </span>        task_id=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>        metrics_pretty_name=<span class="hljs-string">&quot;Accuracy&quot;</span>,
<span class="hljs-meta">... </span>        metrics_id=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>        metrics_value=<span class="hljs-number">0.2662102282047272</span>,
<span class="hljs-meta">... </span>        dataset_pretty_name=<span class="hljs-string">&quot;ReactionJPEG&quot;</span>,
<span class="hljs-meta">... </span>        dataset_id=<span class="hljs-string">&quot;julien-c/reactionjpeg&quot;</span>,
<span class="hljs-meta">... </span>        dataset_config=<span class="hljs-string">&quot;default&quot;</span>,
<span class="hljs-meta">... </span>        dataset_split=<span class="hljs-string">&quot;test&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>results == {
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;model-index&#x27;</span>: [
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;RoBERTa fine-tuned on ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;results&#x27;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;task&#x27;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text-classification&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Text Classification&#x27;</span>
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;dataset&#x27;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;ReactionJPEG&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;julien-c/reactionjpeg&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;config&#x27;</span>: <span class="hljs-string">&#x27;default&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;split&#x27;</span>: <span class="hljs-string">&#x27;test&#x27;</span>
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;metrics&#x27;</span>: [
<span class="hljs-meta">... </span>                        {
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;accuracy&#x27;</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.2662102282047272</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Accuracy&#x27;</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;verified&#x27;</span>: <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>                        }
<span class="hljs-meta">... </span>                    ]
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            ]
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>}
<span class="hljs-literal">True</span>
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function qn(U){let n,j="Example:",_,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhJTIwJTNEJTIwJTdCJ21vZGVsLWluZGV4JyUzQSUyMCU1QiU3QiduYW1lJyUzQSUyMCdSb0JFUlRhJTIwZmluZS10dW5lZCUyMG9uJTIwUmVhY3Rpb25HSUYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Jlc3VsdHMnJTNBJTIwJTVCJTdCJ2RhdGFzZXQnJTNBJTIwJTdCJ25hbWUnJTNBJTIwJ1JlYWN0aW9uR0lGJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd0eXBlJyUzQSUyMCdqdWxpZW4tYyUyRnJlYWN0aW9uZ2lmJyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdtZXRyaWNzJyUzQSUyMCU1QiU3QiduYW1lJyUzQSUyMCdSZWNhbGwnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3R5cGUnJTNBJTIwJ3JlY2FsbCclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAndmFsdWUnJTNBJTIwMC43NzYyMTAyMjgyMDQ3MjcyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Rhc2snJTNBJTIwJTdCJ25hbWUnJTNBJTIwJ1RleHQlMjBDbGFzc2lmaWNhdGlvbiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAndHlwZSclM0ElMjAndGV4dC1jbGFzc2lmaWNhdGlvbiclN0QlN0QlNUQlN0QlNUQlN0QlMEF1cmwlMjAlM0QlMjBtZXRhZGF0YV91cGRhdGUoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnJlYWN0aW9uZ2lmLXJvYmVydGEtY2FyZCUyMiUyQyUyMG1ldGFkYXRhKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = {<span class="hljs-string">&#x27;model-index&#x27;</span>: [{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;RoBERTa fine-tuned on ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;results&#x27;</span>: [{<span class="hljs-string">&#x27;dataset&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>                                     <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;julien-c/reactiongif&#x27;</span>},
<span class="hljs-meta">... </span>                          <span class="hljs-string">&#x27;metrics&#x27;</span>: [{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Recall&#x27;</span>,
<span class="hljs-meta">... </span>                                       <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;recall&#x27;</span>,
<span class="hljs-meta">... </span>                                       <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.7762102282047272</span>}],
<span class="hljs-meta">... </span>                         <span class="hljs-string">&#x27;task&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Text Classification&#x27;</span>,
<span class="hljs-meta">... </span>                                  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text-classification&#x27;</span>}}]}]}
<span class="hljs-meta">&gt;&gt;&gt; </span>url = metadata_update(<span class="hljs-string">&quot;hf-internal-testing/reactiongif-roberta-card&quot;</span>, metadata)
`,wrap:!1}}),{c(){n=p("p"),n.textContent=j,_=o(),m(s.$$.fragment)},l(a){n=d(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=j),_=r(a),h(s.$$.fragment,a)},m(a,b){c(a,n,b),c(a,_,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(_)),y(s,a)}}}function zn(U){let n,j,_,s,g,a,b,Ls=`The huggingface_hub library provides a Python interface to create, share, and update Model/Dataset Cards.
Visit the <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">dedicated documentation page</a> for a deeper view of what
Model Cards on the Hub are, and how they work under the hood. You can also check out our <a href="../how-to-model-cards">Model Cards guide</a> to
get a feel for how you would use these utilities in your own projects.`,rt,Te,it,ve,Hs='The <code>RepoCard</code> object is the parent class of <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.ModelCard">ModelCard</a>, <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.DatasetCard">DatasetCard</a> and <code>SpaceCard</code>.',ct,v,Ae,Xt,N,$e,Vt,wa,qs=`Initialize a RepoCard from string content. The content should be a
Markdown file with a YAML block at the beginning and a Markdown body.`,Lt,se,Ht,ne,qt,V,Ie,zt,Ta,zs="Initialize a RepoCard from a template. By default, it uses the default template.",Pt,va,Ps="Templates are Jinja2 templates that can be customized by passing keyword arguments.",Ot,L,De,Kt,Aa,Os="Initialize a RepoCard from a Hugging Face Hub repo’s README.md or a local filepath.",es,le,as,oe,Re,ts,$a,Ks="Push a RepoCard to a Hugging Face Hub repo.",ss,H,ke,ns,Ia,en="Save a RepoCard to a file.",ls,re,os,q,Ee,rs,Da,an=`Validates card against Hugging Face Hub’s card validation logic.
Using this function requires access to the internet, so it is only called
internally by <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">huggingface_hub.repocard.RepoCard.push_to_hub()</a>.`,is,ie,pt,Ne,dt,Ze,tn='The <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.CardData">CardData</a> object is the parent class of <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> and <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.DatasetCardData">DatasetCardData</a>.',gt,T,We,cs,Ra,sn="Structure containing metadata from a RepoCard.",ps,ka,nn='<a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.CardData">CardData</a> is the parent class of <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> and <a href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.DatasetCardData">DatasetCardData</a>.',ds,Ea,ln=`Metadata can be exported as a dictionary or YAML. Export can be customized to alter the representation of the data
(example: flatten evaluation results). <code>CardData</code> behaves as a dictionary (can get, pop, set values) but do not
inherit from <code>dict</code> to allow this export step.`,gs,ce,Ge,ms,Na,on="Get value for a given metadata key.",hs,pe,Ye,us,Za,rn="Pop value for a given metadata key.",Ms,de,Fe,fs,Wa,cn="Converts CardData to a dict.",ys,ge,Qe,_s,Ga,pn="Dumps CardData to a YAML block for inclusion in a README.md file.",mt,Se,ht,Be,ut,z,Xe,js,Z,Ve,bs,Ya,dn=`Initialize a ModelCard from a template. By default, it uses the default template, which can be found here:
<a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md</a>`,Cs,Fa,gn="Templates are Jinja2 templates that can be customized by passing keyword arguments.",Us,me,Mt,Le,ft,G,He,Js,Qa,mn="Model Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",xs,he,yt,qe,_t,ze,hn="Dataset cards are also known as Data Cards in the ML Community.",jt,Pe,bt,P,Oe,ws,W,Ke,Ts,Sa,un=`Initialize a DatasetCard from a template. By default, it uses the default template, which can be found here:
<a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/datasetcard_template.md" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/datasetcard_template.md</a>`,vs,Ba,Mn="Templates are Jinja2 templates that can be customized by passing keyword arguments.",As,ue,Ct,ea,Ut,O,aa,$s,Xa,fn="Dataset Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",Jt,ta,xt,sa,wt,na,la,Tt,oa,vt,D,ra,Is,Va,yn="Space Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",Ds,La,_n='To get an exhaustive reference of Spaces configuration, please visit <a href="https://huggingface.co/docs/hub/spaces-config-reference#spaces-configuration-reference" rel="nofollow">https://huggingface.co/docs/hub/spaces-config-reference#spaces-configuration-reference</a>.',Rs,Me,At,ia,$t,ca,It,R,pa,ks,Ha,jn="Flattened representation of individual evaluation results found in model-index of Model Cards.",Es,qa,bn='For more information on the model-index spec, see <a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1</a>.',Ns,fe,da,Zs,za,Cn=`Return True if <code>self</code> and <code>other</code> describe exactly the same metric but with a
different value.`,Dt,ga,Rt,k,ma,Ws,Pa,Un="Takes in a model index and returns the model name and a list of <code>huggingface_hub.EvalResult</code> objects.",Gs,Oa,Jn=`A detailed spec of the model index can be found here:
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1</a>`,Ys,ye,kt,ha,Et,Y,ua,Fs,Ka,xn=`Takes in given model name and list of <code>huggingface_hub.EvalResult</code> and returns a
valid model-index that will be compatible with the format expected by the
Hugging Face Hub.`,Qs,_e,Nt,Ma,Zt,F,fa,Ss,et,wn="Creates a metadata dict with the result from a model evaluated on a dataset.",Bs,je,Wt,ya,Gt,Q,_a,Xs,at,Tn=`Updates the metadata in the README.md of a repository on the Hugging Face Hub.
If the README.md file doesn’t exist yet, a new one is created with metadata and an
the default ModelCard or DatasetCard template. For <code>space</code> repo, an error is thrown
as a Space cannot exist without a <code>README.md</code> file.`,Vs,be,Yt,ot,Ft;return g=new $({props:{title:"Repository Cards",local:"repository-cards",headingTag:"h1"}}),Te=new $({props:{title:"Repo Card",local:"huggingface_hub.RepoCard",headingTag:"h2"}}),Ae=new w({props:{name:"class huggingface_hub.RepoCard",anchor:"huggingface_hub.RepoCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L35"}}),$e=new w({props:{name:"__init__",anchor:"huggingface_hub.RepoCard.__init__",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.__init__.content",description:"<strong>content</strong> (<code>str</code>) &#x2014; The content of the Markdown file.",name:"content"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L40"}}),se=new B({props:{anchor:"huggingface_hub.RepoCard.__init__.example",$$slots:{default:[Zn]},$$scope:{ctx:U}}}),ne=new An({props:{$$slots:{default:[Wn]},$$scope:{ctx:U}}}),Ie=new w({props:{name:"from_template",anchor:"huggingface_hub.RepoCard.from_template",parameters:[{name:"card_data",val:": CardData"},{name:"template_path",val:": typing.Optional[str] = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.CardData</code>) &#x2014;
A huggingface_hub.CardData instance containing the metadata you want to include in the YAML
header of the repo card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.RepoCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L290",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A RepoCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.RepoCard"
>huggingface_hub.repocard.RepoCard</a></p>
`}}),De=new w({props:{name:"load",anchor:"huggingface_hub.RepoCard.load",parameters:[{name:"repo_id_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"ignore_metadata_errors",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.load.repo_id_or_path",description:`<strong>repo_id_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
The repo ID associated with a Hugging Face Hub repo or a local filepath.`,name:"repo_id_or_path"},{anchor:"huggingface_hub.RepoCard.load.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of Hugging Face repo to push to. Defaults to None, which will use use &#x201C;model&#x201D;. Other options
are &#x201C;dataset&#x201D; and &#x201C;space&#x201D;. Not used when loading from a local filepath. If this is called from a child
class, the default value will be the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"},{anchor:"huggingface_hub.RepoCard.load.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token, obtained with <code>huggingface_hub.HfApi.login</code> method. Will default to the stored token.`,name:"token"},{anchor:"huggingface_hub.RepoCard.load.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L134",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The RepoCard (or subclass) initialized from the repo’s
README.md file or filepath.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.RepoCard"
>huggingface_hub.repocard.RepoCard</a></p>
`}}),le=new B({props:{anchor:"huggingface_hub.RepoCard.load.example",$$slots:{default:[Gn]},$$scope:{ctx:U}}}),Re=new w({props:{name:"push_to_hub",anchor:"huggingface_hub.RepoCard.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"commit_description",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"parent_commit",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repo ID of the Hugging Face Hub repo to push to. Example: &#x201C;nateraw/food&#x201D;.`,name:"repo_id"},{anchor:"huggingface_hub.RepoCard.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token, obtained with <code>huggingface_hub.HfApi.login</code> method. Will default to
the stored token.`,name:"token"},{anchor:"huggingface_hub.RepoCard.push_to_hub.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;model&#x201D;) &#x2014;
The type of Hugging Face repo to push to. Options are &#x201C;model&#x201D;, &#x201C;dataset&#x201D;, and &#x201C;space&#x201D;. If this
function is called by a child class, it will default to the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"},{anchor:"huggingface_hub.RepoCard.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit.`,name:"commit_message"},{anchor:"huggingface_hub.RepoCard.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.RepoCard.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.RepoCard.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with this commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.RepoCard.push_to_hub.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL of the commit which updated the card metadata.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ke=new w({props:{name:"save",anchor:"huggingface_hub.RepoCard.save",parameters:[{name:"filepath",val:": typing.Union[pathlib.Path, str]"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.save.filepath",description:"<strong>filepath</strong> (<code>Union[Path, str]</code>) &#x2014; Filepath to the markdown file to save.",name:"filepath"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L114"}}),re=new B({props:{anchor:"huggingface_hub.RepoCard.save.example",$$slots:{default:[Yn]},$$scope:{ctx:U}}}),Ee=new w({props:{name:"validate",anchor:"huggingface_hub.RepoCard.validate",parameters:[{name:"repo_type",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.validate.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;model&#x201D;) &#x2014;
The type of Hugging Face repo to push to. Options are &#x201C;model&#x201D;, &#x201C;dataset&#x201D;, and &#x201C;space&#x201D;.
If this function is called from a child class, the default will be the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L188"}}),ie=new An({props:{$$slots:{default:[Fn]},$$scope:{ctx:U}}}),Ne=new $({props:{title:"Card Data",local:"huggingface_hub.CardData",headingTag:"h2"}}),We=new w({props:{name:"class huggingface_hub.CardData",anchor:"huggingface_hub.CardData",parameters:[{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L163"}}),Ge=new w({props:{name:"get",anchor:"huggingface_hub.CardData.get",parameters:[{name:"key",val:": str"},{name:"default",val:": typing.Any = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L214"}}),Ye=new w({props:{name:"pop",anchor:"huggingface_hub.CardData.pop",parameters:[{name:"key",val:": str"},{name:"default",val:": typing.Any = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L218"}}),Fe=new w({props:{name:"to_dict",anchor:"huggingface_hub.CardData.to_dict",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>CardData represented as a dictionary ready to be dumped to a YAML
block for inclusion in a README.md file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict</code></p>
`}}),Qe=new w({props:{name:"to_yaml",anchor:"huggingface_hub.CardData.to_yaml",parameters:[{name:"line_break",val:" = None"}],parametersDescription:[{anchor:"huggingface_hub.CardData.to_yaml.line_break",description:`<strong>line_break</strong> (str, <em>optional</em>) &#x2014;
The line break to use when dumping to yaml.`,name:"line_break"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L196",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>CardData represented as a YAML block.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Se=new $({props:{title:"Model Cards",local:"model-cards",headingTag:"h2"}}),Be=new $({props:{title:"ModelCard",local:"huggingface_hub.ModelCard",headingTag:"h3"}}),Xe=new w({props:{name:"class huggingface_hub.ModelCard",anchor:"huggingface_hub.ModelCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L328"}}),Ve=new w({props:{name:"from_template",anchor:"huggingface_hub.ModelCard.from_template",parameters:[{name:"card_data",val:": ModelCardData"},{name:"template_path",val:": typing.Optional[str] = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.ModelCardData</code>) &#x2014;
A huggingface_hub.ModelCardData instance containing the metadata you want to include in the YAML
header of the model card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.ModelCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L333",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A ModelCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.ModelCard"
>huggingface_hub.ModelCard</a></p>
`}}),me=new B({props:{anchor:"huggingface_hub.ModelCard.from_template.example",$$slots:{default:[Qn]},$$scope:{ctx:U}}}),Le=new $({props:{title:"ModelCardData",local:"huggingface_hub.ModelCardData",headingTag:"h3"}}),He=new w({props:{name:"class huggingface_hub.ModelCardData",anchor:"huggingface_hub.ModelCardData",parameters:[{name:"language",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"license",val:": typing.Optional[str] = None"},{name:"library_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Optional[typing.List[str]] = None"},{name:"datasets",val:": typing.Optional[typing.List[str]] = None"},{name:"metrics",val:": typing.Optional[typing.List[str]] = None"},{name:"eval_results",val:": typing.Optional[typing.List[huggingface_hub.repocard_data.EvalResult]] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelCardData.language",description:`<strong>language</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
Language of model&#x2019;s training data or metadata. It must be an ISO 639-1, 639-2 or
639-3 code (two/three letters), or a special value like &#x201C;code&#x201D;, &#x201C;multilingual&#x201D;. Defaults to <code>None</code>.`,name:"language"},{anchor:"huggingface_hub.ModelCardData.license",description:`<strong>license</strong> (<code>str</code>, <em>optional</em>) &#x2014;
License of this model. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>. Defaults to None.`,name:"license"},{anchor:"huggingface_hub.ModelCardData.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of library used by this model. Example: keras or any library from
<a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts</a>.
Defaults to None.`,name:"library_name"},{anchor:"huggingface_hub.ModelCardData.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to add to your model that can be used when filtering on the Hugging
Face Hub. Defaults to None.`,name:"tags"},{anchor:"huggingface_hub.ModelCardData.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets that were used to train this model. Should be a dataset ID
found on <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>. Defaults to None.`,name:"datasets"},{anchor:"huggingface_hub.ModelCardData.metrics",description:`<strong>metrics</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of metrics used to evaluate this model. Should be a metric name that can be found
at <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>. Example: &#x2018;accuracy&#x2019;. Defaults to None.`,name:"metrics"},{anchor:"huggingface_hub.ModelCardData.eval_results",description:`<strong>eval_results</strong> (<code>Union[List[EvalResult], EvalResult]</code>, <em>optional</em>) &#x2014;
List of <code>huggingface_hub.EvalResult</code> that define evaluation results of the model. If provided,
<code>model_name</code> is used to as a name on PapersWithCode&#x2019;s leaderboards. Defaults to <code>None</code>.`,name:"eval_results"},{anchor:"huggingface_hub.ModelCardData.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A name for this model. It is used along with
<code>eval_results</code> to construct the <code>model-index</code> within the card&#x2019;s metadata. The name
you supply here is what will be used on PapersWithCode&#x2019;s leaderboards. If None is provided
then the repo name is used as a default. Defaults to None.`,name:"model_name"},{anchor:"huggingface_hub.ModelCardData.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"},{anchor:"huggingface_hub.ModelCardData.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional metadata that will be added to the model card. Defaults to None.`,name:"kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L239"}}),he=new B({props:{anchor:"huggingface_hub.ModelCardData.example",$$slots:{default:[Sn]},$$scope:{ctx:U}}}),qe=new $({props:{title:"Dataset Cards",local:"dataset-cards",headingTag:"h2"}}),Pe=new $({props:{title:"DatasetCard",local:"huggingface_hub.DatasetCard",headingTag:"h3"}}),Oe=new w({props:{name:"class huggingface_hub.DatasetCard",anchor:"huggingface_hub.DatasetCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L408"}}),Ke=new w({props:{name:"from_template",anchor:"huggingface_hub.DatasetCard.from_template",parameters:[{name:"card_data",val:": DatasetCardData"},{name:"template_path",val:": typing.Optional[str] = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.DatasetCardData</code>) &#x2014;
A huggingface_hub.DatasetCardData instance containing the metadata you want to include in the YAML
header of the dataset card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.DatasetCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A DatasetCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.20.1/en/package_reference/cards#huggingface_hub.DatasetCard"
>huggingface_hub.DatasetCard</a></p>
`}}),ue=new B({props:{anchor:"huggingface_hub.DatasetCard.from_template.example",$$slots:{default:[Bn]},$$scope:{ctx:U}}}),ea=new $({props:{title:"DatasetCardData",local:"huggingface_hub.DatasetCardData",headingTag:"h3"}}),aa=new w({props:{name:"class huggingface_hub.DatasetCardData",anchor:"huggingface_hub.DatasetCardData",parameters:[{name:"language",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"license",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"annotations_creators",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"language_creators",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"multilinguality",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"size_categories",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"source_datasets",val:": typing.Optional[typing.List[str]] = None"},{name:"task_categories",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"task_ids",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"paperswithcode_id",val:": typing.Optional[str] = None"},{name:"pretty_name",val:": typing.Optional[str] = None"},{name:"train_eval_index",val:": typing.Optional[typing.Dict] = None"},{name:"config_names",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetCardData.language",description:`<strong>language</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Language of dataset&#x2019;s data or metadata. It must be an ISO 639-1, 639-2 or
639-3 code (two/three letters), or a special value like &#x201C;code&#x201D;, &#x201C;multilingual&#x201D;.`,name:"language"},{anchor:"huggingface_hub.DatasetCardData.license",description:`<strong>license</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
License(s) of this dataset. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>.`,name:"license"},{anchor:"huggingface_hub.DatasetCardData.annotations_creators",description:`<strong>annotations_creators</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
How the annotations for the dataset were created.
Options are: &#x2018;found&#x2019;, &#x2018;crowdsourced&#x2019;, &#x2018;expert-generated&#x2019;, &#x2018;machine-generated&#x2019;, &#x2018;no-annotation&#x2019;, &#x2018;other&#x2019;.`,name:"annotations_creators"},{anchor:"huggingface_hub.DatasetCardData.language_creators",description:`<strong>language_creators</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
How the text-based data in the dataset was created.
Options are: &#x2018;found&#x2019;, &#x2018;crowdsourced&#x2019;, &#x2018;expert-generated&#x2019;, &#x2018;machine-generated&#x2019;, &#x2018;other&#x2019;`,name:"language_creators"},{anchor:"huggingface_hub.DatasetCardData.multilinguality",description:`<strong>multilinguality</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
Whether the dataset is multilingual.
Options are: &#x2018;monolingual&#x2019;, &#x2018;multilingual&#x2019;, &#x2018;translation&#x2019;, &#x2018;other&#x2019;.`,name:"multilinguality"},{anchor:"huggingface_hub.DatasetCardData.size_categories",description:`<strong>size_categories</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
The number of examples in the dataset. Options are: &#x2018;n&lt;1K&#x2019;, &#x2018;1K<n<10k’, ‘10k<n<100k’, ‘100k<n<1m’, ‘1m<n<10m’, ‘10m<n<100m’, ‘100m<n<1b’, ‘1b<n<10b’, ‘10b<n<100b’, ‘100b<n<1t’, ‘n>1T&#x2019;, and &#x2018;other&#x2019;.</n<10k’,>`,name:"size_categories"},{anchor:"huggingface_hub.DatasetCardData.source_datasets",description:`<strong>source_datasets</strong> (<code>List[str]]</code>, <em>optional</em>) &#x2014;
Indicates whether the dataset is an original dataset or extended from another existing dataset.
Options are: &#x2018;original&#x2019; and &#x2018;extended&#x2019;.`,name:"source_datasets"},{anchor:"huggingface_hub.DatasetCardData.task_categories",description:`<strong>task_categories</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
What categories of task does the dataset support?`,name:"task_categories"},{anchor:"huggingface_hub.DatasetCardData.task_ids",description:`<strong>task_ids</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
What specific tasks does the dataset support?`,name:"task_ids"},{anchor:"huggingface_hub.DatasetCardData.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset on PapersWithCode.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetCardData.pretty_name",description:`<strong>pretty_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A more human-readable name for the dataset. (ex. &#x201C;Cats vs. Dogs&#x201D;)`,name:"pretty_name"},{anchor:"huggingface_hub.DatasetCardData.train_eval_index",description:`<strong>train_eval_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary that describes the necessary spec for doing evaluation on the Hub.
If not provided, it will be gathered from the &#x2018;train-eval-index&#x2019; key of the kwargs.`,name:"train_eval_index"},{anchor:"huggingface_hub.DatasetCardData.config_names",description:`<strong>config_names</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
A list of the available dataset configs for the dataset.`,name:"config_names"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L345"}}),ta=new $({props:{title:"Space Cards",local:"space-cards",headingTag:"h2"}}),sa=new $({props:{title:"SpaceCard",local:"huggingface_hub.SpaceCard",headingTag:"h3"}}),la=new w({props:{name:"class huggingface_hub.SpaceCard",anchor:"huggingface_hub.SpaceCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L472"}}),oa=new $({props:{title:"SpaceCardData",local:"huggingface_hub.SpaceCardData",headingTag:"h3"}}),ra=new w({props:{name:"class huggingface_hub.SpaceCardData",anchor:"huggingface_hub.SpaceCardData",parameters:[{name:"title",val:": typing.Optional[str] = None"},{name:"sdk",val:": typing.Optional[str] = None"},{name:"sdk_version",val:": typing.Optional[str] = None"},{name:"python_version",val:": typing.Optional[str] = None"},{name:"app_file",val:": typing.Optional[str] = None"},{name:"app_port",val:": typing.Optional[int] = None"},{name:"license",val:": typing.Optional[str] = None"},{name:"duplicated_from",val:": typing.Optional[str] = None"},{name:"models",val:": typing.Optional[typing.List[str]] = None"},{name:"datasets",val:": typing.Optional[typing.List[str]] = None"},{name:"tags",val:": typing.Optional[typing.List[str]] = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceCardData.title",description:`<strong>title</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Title of the Space.`,name:"title"},{anchor:"huggingface_hub.SpaceCardData.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK of the Space (one of <code>gradio</code>, <code>streamlit</code>, <code>docker</code>, or <code>static</code>).`,name:"sdk"},{anchor:"huggingface_hub.SpaceCardData.sdk_version",description:`<strong>sdk_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Version of the used SDK (if Gradio/Streamlit sdk).`,name:"sdk_version"},{anchor:"huggingface_hub.SpaceCardData.python_version",description:`<strong>python_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Python version used in the Space (if Gradio/Streamlit sdk).`,name:"python_version"},{anchor:"huggingface_hub.SpaceCardData.app_file",description:`<strong>app_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to your main application file (which contains either gradio or streamlit Python code, or static html code).
Path is relative to the root of the repository.`,name:"app_file"},{anchor:"huggingface_hub.SpaceCardData.app_port",description:`<strong>app_port</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Port on which your application is running. Used only if sdk is <code>docker</code>.`,name:"app_port"},{anchor:"huggingface_hub.SpaceCardData.license",description:`<strong>license</strong> (<code>str</code>, <em>optional</em>) &#x2014;
License of this model. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>.`,name:"license"},{anchor:"huggingface_hub.SpaceCardData.duplicated_from",description:`<strong>duplicated_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the original Space if this is a duplicated Space.`,name:"duplicated_from"},{anchor:"huggingface_hub.SpaceCardData.models",description:`<strong>models</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of models related to this Space. Should be a dataset ID found on <a href="https://hf.co/models" rel="nofollow">https://hf.co/models</a>.`,name:"models"},{anchor:"huggingface_hub.SpaceCardData.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets related to this Space. Should be a dataset ID found on <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"datasets"},{anchor:"huggingface_hub.SpaceCardData.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to add to your Space that can be used when filtering on the Hub.`,name:"tags"},{anchor:"huggingface_hub.SpaceCardData.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"},{anchor:"huggingface_hub.SpaceCardData.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional metadata that will be added to the space card.`,name:"kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L425"}}),Me=new B({props:{anchor:"huggingface_hub.SpaceCardData.example",$$slots:{default:[Xn]},$$scope:{ctx:U}}}),ia=new $({props:{title:"Utilities",local:"utilities",headingTag:"h2"}}),ca=new $({props:{title:"EvalResult",local:"huggingface_hub.EvalResult",headingTag:"h3"}}),pa=new w({props:{name:"class huggingface_hub.EvalResult",anchor:"huggingface_hub.EvalResult",parameters:[{name:"task_type",val:": str"},{name:"dataset_type",val:": str"},{name:"dataset_name",val:": str"},{name:"metric_type",val:": str"},{name:"metric_value",val:": typing.Any"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"dataset_config",val:": typing.Optional[str] = None"},{name:"dataset_split",val:": typing.Optional[str] = None"},{name:"dataset_revision",val:": typing.Optional[str] = None"},{name:"dataset_args",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"metric_name",val:": typing.Optional[str] = None"},{name:"metric_config",val:": typing.Optional[str] = None"},{name:"metric_args",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"verified",val:": typing.Optional[bool] = None"},{name:"verify_token",val:": typing.Optional[str] = None"},{name:"source_name",val:": typing.Optional[str] = None"},{name:"source_url",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.EvalResult.task_type",description:`<strong>task_type</strong> (<code>str</code>) &#x2014;
The task identifier. Example: &#x201C;image-classification&#x201D;.`,name:"task_type"},{anchor:"huggingface_hub.EvalResult.dataset_type",description:`<strong>dataset_type</strong> (<code>str</code>) &#x2014;
The dataset identifier. Example: &#x201C;common_voice&#x201D;. Use dataset id from <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"dataset_type"},{anchor:"huggingface_hub.EvalResult.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
A pretty name for the dataset. Example: &#x201C;Common Voice (French)&#x201C;.`,name:"dataset_name"},{anchor:"huggingface_hub.EvalResult.metric_type",description:`<strong>metric_type</strong> (<code>str</code>) &#x2014;
The metric identifier. Example: &#x201C;wer&#x201D;. Use metric id from <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>.`,name:"metric_type"},{anchor:"huggingface_hub.EvalResult.metric_value",description:`<strong>metric_value</strong> (<code>Any</code>) &#x2014;
The metric value. Example: 0.9 or &#x201C;20.0 &#xB1; 1.2&#x201D;.`,name:"metric_value"},{anchor:"huggingface_hub.EvalResult.task_name",description:`<strong>task_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A pretty name for the task. Example: &#x201C;Speech Recognition&#x201D;.`,name:"task_name"},{anchor:"huggingface_hub.EvalResult.dataset_config",description:`<strong>dataset_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the dataset configuration used in <code>load_dataset()</code>.
Example: fr in <code>load_dataset(&quot;common_voice&quot;, &quot;fr&quot;)</code>. See the <code>datasets</code> docs for more info:
<a href="https://hf.co/docs/datasets/package_reference/loading_methods#datasets.load_dataset.name" rel="nofollow">https://hf.co/docs/datasets/package_reference/loading_methods#datasets.load_dataset.name</a>`,name:"dataset_config"},{anchor:"huggingface_hub.EvalResult.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The split used in <code>load_dataset()</code>. Example: &#x201C;test&#x201D;.`,name:"dataset_split"},{anchor:"huggingface_hub.EvalResult.dataset_revision",description:`<strong>dataset_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision (AKA Git Sha) of the dataset used in <code>load_dataset()</code>.
Example: 5503434ddd753f426f4b38109466949a1217c2bb`,name:"dataset_revision"},{anchor:"huggingface_hub.EvalResult.dataset_args",description:`<strong>dataset_args</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The arguments passed during <code>Metric.compute()</code>. Example for <code>bleu</code>: <code>{&quot;max_order&quot;: 4}</code>`,name:"dataset_args"},{anchor:"huggingface_hub.EvalResult.metric_name",description:`<strong>metric_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A pretty name for the metric. Example: &#x201C;Test WER&#x201D;.`,name:"metric_name"},{anchor:"huggingface_hub.EvalResult.metric_config",description:`<strong>metric_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the metric configuration used in <code>load_metric()</code>.
Example: bleurt-large-512 in <code>load_metric(&quot;bleurt&quot;, &quot;bleurt-large-512&quot;)</code>.
See the <code>datasets</code> docs for more info: <a href="https://huggingface.co/docs/datasets/v2.1.0/en/loading#load-configurations" rel="nofollow">https://huggingface.co/docs/datasets/v2.1.0/en/loading#load-configurations</a>`,name:"metric_config"},{anchor:"huggingface_hub.EvalResult.metric_args",description:`<strong>metric_args</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The arguments passed during <code>Metric.compute()</code>. Example for <code>bleu</code>: max_order: 4`,name:"metric_args"},{anchor:"huggingface_hub.EvalResult.verified",description:`<strong>verified</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Indicates whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not. Automatically computed by Hugging Face, do not set.`,name:"verified"},{anchor:"huggingface_hub.EvalResult.verify_token",description:`<strong>verify_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A JSON Web Token that is used to verify whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not.`,name:"verify_token"},{anchor:"huggingface_hub.EvalResult.source_name",description:`<strong>source_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the source of the evaluation result. Example: &#x201C;Open LLM Leaderboard&#x201D;.`,name:"source_name"},{anchor:"huggingface_hub.EvalResult.source_url",description:`<strong>source_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the source of the evaluation result. Example: &#x201D;<a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard%22" rel="nofollow">https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard&#x201D;</a>.`,name:"source_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L11"}}),da=new w({props:{name:"is_equal_except_value",anchor:"huggingface_hub.EvalResult.is_equal_except_value",parameters:[{name:"other",val:": EvalResult"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L143"}}),ga=new $({props:{title:"model_index_to_eval_results",local:"huggingface_hub.repocard_data.model_index_to_eval_results",headingTag:"h3"}}),ma=new w({props:{name:"huggingface_hub.repocard_data.model_index_to_eval_results",anchor:"huggingface_hub.repocard_data.model_index_to_eval_results",parameters:[{name:"model_index",val:": typing.List[typing.Dict[str, typing.Any]]"}],parametersDescription:[{anchor:"huggingface_hub.repocard_data.model_index_to_eval_results.model_index",description:`<strong>model_index</strong> (<code>List[Dict[str, Any]]</code>) &#x2014;
A model index data structure, likely coming from a README.md file on the
Hugging Face Hub.`,name:"model_index"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The name of the model as found in the model index. This is used as the
identifier for the model on leaderboards like PapersWithCode.
eval_results (<code>List[EvalResult]</code>):
A list of <code>huggingface_hub.EvalResult</code> objects containing the metrics
reported in the provided model_index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>model_name (<code>str</code>)</p>
`}}),ye=new B({props:{anchor:"huggingface_hub.repocard_data.model_index_to_eval_results.example",$$slots:{default:[Vn]},$$scope:{ctx:U}}}),ha=new $({props:{title:"eval_results_to_model_index",local:"huggingface_hub.repocard_data.eval_results_to_model_index",headingTag:"h3"}}),ua=new w({props:{name:"huggingface_hub.repocard_data.eval_results_to_model_index",anchor:"huggingface_hub.repocard_data.eval_results_to_model_index",parameters:[{name:"model_name",val:": str"},{name:"eval_results",val:": typing.List[huggingface_hub.repocard_data.EvalResult]"}],parametersDescription:[{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.model_name",description:`<strong>model_name</strong> (<code>str</code>) &#x2014;
Name of the model (ex. &#x201C;my-cool-model&#x201D;). This is used as the identifier
for the model on leaderboards like PapersWithCode.`,name:"model_name"},{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.eval_results",description:`<strong>eval_results</strong> (<code>List[EvalResult]</code>) &#x2014;
List of <code>huggingface_hub.EvalResult</code> objects containing the metrics to be
reported in the model-index.`,name:"eval_results"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard_data.py#L622",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The eval_results converted to a model-index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>model_index (<code>List[Dict[str, Any]]</code>)</p>
`}}),_e=new B({props:{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.example",$$slots:{default:[Ln]},$$scope:{ctx:U}}}),Ma=new $({props:{title:"metadata_eval_result",local:"huggingface_hub.metadata_eval_result",headingTag:"h3"}}),fa=new w({props:{name:"huggingface_hub.metadata_eval_result",anchor:"huggingface_hub.metadata_eval_result",parameters:[{name:"model_pretty_name",val:": str"},{name:"task_pretty_name",val:": str"},{name:"task_id",val:": str"},{name:"metrics_pretty_name",val:": str"},{name:"metrics_id",val:": str"},{name:"metrics_value",val:": typing.Any"},{name:"dataset_pretty_name",val:": str"},{name:"dataset_id",val:": str"},{name:"metrics_config",val:": typing.Optional[str] = None"},{name:"metrics_verified",val:": bool = False"},{name:"dataset_config",val:": typing.Optional[str] = None"},{name:"dataset_split",val:": typing.Optional[str] = None"},{name:"dataset_revision",val:": typing.Optional[str] = None"},{name:"metrics_verification_token",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.metadata_eval_result.model_pretty_name",description:`<strong>model_pretty_name</strong> (<code>str</code>) &#x2014;
The name of the model in natural language.`,name:"model_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.task_pretty_name",description:`<strong>task_pretty_name</strong> (<code>str</code>) &#x2014;
The name of a task in natural language.`,name:"task_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.task_id",description:`<strong>task_id</strong> (<code>str</code>) &#x2014;
Example: automatic-speech-recognition. A task id.`,name:"task_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_pretty_name",description:`<strong>metrics_pretty_name</strong> (<code>str</code>) &#x2014;
A name for the metric in natural language. Example: Test WER.`,name:"metrics_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.metrics_id",description:`<strong>metrics_id</strong> (<code>str</code>) &#x2014;
Example: wer. A metric id from <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>.`,name:"metrics_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_value",description:`<strong>metrics_value</strong> (<code>Any</code>) &#x2014;
The value from the metric. Example: 20.0 or &#x201C;20.0 &#xB1; 1.2&#x201D;.`,name:"metrics_value"},{anchor:"huggingface_hub.metadata_eval_result.dataset_pretty_name",description:`<strong>dataset_pretty_name</strong> (<code>str</code>) &#x2014;
The name of the dataset in natural language.`,name:"dataset_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.dataset_id",description:`<strong>dataset_id</strong> (<code>str</code>) &#x2014;
Example: common_voice. A dataset id from <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"dataset_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_config",description:`<strong>metrics_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the metric configuration used in <code>load_metric()</code>.
Example: bleurt-large-512 in <code>load_metric(&quot;bleurt&quot;, &quot;bleurt-large-512&quot;)</code>.`,name:"metrics_config"},{anchor:"huggingface_hub.metadata_eval_result.metrics_verified",description:`<strong>metrics_verified</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Indicates whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not. Automatically computed by Hugging Face, do not set.`,name:"metrics_verified"},{anchor:"huggingface_hub.metadata_eval_result.dataset_config",description:`<strong>dataset_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: fr. The name of the dataset configuration used in <code>load_dataset()</code>.`,name:"dataset_config"},{anchor:"huggingface_hub.metadata_eval_result.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: test. The name of the dataset split used in <code>load_dataset()</code>.`,name:"dataset_split"},{anchor:"huggingface_hub.metadata_eval_result.dataset_revision",description:`<strong>dataset_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: 5503434ddd753f426f4b38109466949a1217c2bb. The name of the dataset dataset revision
used in <code>load_dataset()</code>.`,name:"dataset_revision"},{anchor:"huggingface_hub.metadata_eval_result.metrics_verification_token",description:`<strong>metrics_verification_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A JSON Web Token that is used to verify whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not.`,name:"metrics_verification_token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a metadata dict with the result from a model evaluated on a dataset.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict</code></p>
`}}),je=new B({props:{anchor:"huggingface_hub.metadata_eval_result.example",$$slots:{default:[Hn]},$$scope:{ctx:U}}}),ya=new $({props:{title:"metadata_update",local:"huggingface_hub.metadata_update",headingTag:"h3"}}),_a=new w({props:{name:"huggingface_hub.metadata_update",anchor:"huggingface_hub.metadata_update",parameters:[{name:"repo_id",val:": str"},{name:"metadata",val:": typing.Dict"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"overwrite",val:": bool = False"},{name:"token",val:": typing.Optional[str] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"commit_description",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"parent_commit",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.metadata_update.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository.`,name:"repo_id"},{anchor:"huggingface_hub.metadata_update.metadata",description:`<strong>metadata</strong> (<code>dict</code>) &#x2014;
A dictionary containing the metadata to be updated.`,name:"metadata"},{anchor:"huggingface_hub.metadata_update.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if updating to a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if updating to a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.metadata_update.overwrite",description:`<strong>overwrite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code> an existing field can be overwritten, otherwise
attempting to overwrite an existing field will cause an error.`,name:"overwrite"},{anchor:"huggingface_hub.metadata_update.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The Hugging Face authentication token.`,name:"token"},{anchor:"huggingface_hub.metadata_update.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Update metadata with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.metadata_update.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.metadata_update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the
<code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.metadata_update.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>revision</code> with that commit.
Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.metadata_update.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.20.1/src/huggingface_hub/repocard.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL of the commit which updated the card metadata.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),be=new B({props:{anchor:"huggingface_hub.metadata_update.example",$$slots:{default:[qn]},$$scope:{ctx:U}}}),{c(){n=p("meta"),j=o(),_=p("p"),s=o(),m(g.$$.fragment),a=o(),b=p("p"),b.innerHTML=Ls,rt=o(),m(Te.$$.fragment),it=o(),ve=p("p"),ve.innerHTML=Hs,ct=o(),v=p("div"),m(Ae.$$.fragment),Xt=o(),N=p("div"),m($e.$$.fragment),Vt=o(),wa=p("p"),wa.textContent=qs,Lt=o(),m(se.$$.fragment),Ht=o(),m(ne.$$.fragment),qt=o(),V=p("div"),m(Ie.$$.fragment),zt=o(),Ta=p("p"),Ta.textContent=zs,Pt=o(),va=p("p"),va.textContent=Ps,Ot=o(),L=p("div"),m(De.$$.fragment),Kt=o(),Aa=p("p"),Aa.textContent=Os,es=o(),m(le.$$.fragment),as=o(),oe=p("div"),m(Re.$$.fragment),ts=o(),$a=p("p"),$a.textContent=Ks,ss=o(),H=p("div"),m(ke.$$.fragment),ns=o(),Ia=p("p"),Ia.textContent=en,ls=o(),m(re.$$.fragment),os=o(),q=p("div"),m(Ee.$$.fragment),rs=o(),Da=p("p"),Da.innerHTML=an,is=o(),m(ie.$$.fragment),pt=o(),m(Ne.$$.fragment),dt=o(),Ze=p("p"),Ze.innerHTML=tn,gt=o(),T=p("div"),m(We.$$.fragment),cs=o(),Ra=p("p"),Ra.textContent=sn,ps=o(),ka=p("p"),ka.innerHTML=nn,ds=o(),Ea=p("p"),Ea.innerHTML=ln,gs=o(),ce=p("div"),m(Ge.$$.fragment),ms=o(),Na=p("p"),Na.textContent=on,hs=o(),pe=p("div"),m(Ye.$$.fragment),us=o(),Za=p("p"),Za.textContent=rn,Ms=o(),de=p("div"),m(Fe.$$.fragment),fs=o(),Wa=p("p"),Wa.textContent=cn,ys=o(),ge=p("div"),m(Qe.$$.fragment),_s=o(),Ga=p("p"),Ga.textContent=pn,mt=o(),m(Se.$$.fragment),ht=o(),m(Be.$$.fragment),ut=o(),z=p("div"),m(Xe.$$.fragment),js=o(),Z=p("div"),m(Ve.$$.fragment),bs=o(),Ya=p("p"),Ya.innerHTML=dn,Cs=o(),Fa=p("p"),Fa.textContent=gn,Us=o(),m(me.$$.fragment),Mt=o(),m(Le.$$.fragment),ft=o(),G=p("div"),m(He.$$.fragment),Js=o(),Qa=p("p"),Qa.textContent=mn,xs=o(),m(he.$$.fragment),yt=o(),m(qe.$$.fragment),_t=o(),ze=p("p"),ze.textContent=hn,jt=o(),m(Pe.$$.fragment),bt=o(),P=p("div"),m(Oe.$$.fragment),ws=o(),W=p("div"),m(Ke.$$.fragment),Ts=o(),Sa=p("p"),Sa.innerHTML=un,vs=o(),Ba=p("p"),Ba.textContent=Mn,As=o(),m(ue.$$.fragment),Ct=o(),m(ea.$$.fragment),Ut=o(),O=p("div"),m(aa.$$.fragment),$s=o(),Xa=p("p"),Xa.textContent=fn,Jt=o(),m(ta.$$.fragment),xt=o(),m(sa.$$.fragment),wt=o(),na=p("div"),m(la.$$.fragment),Tt=o(),m(oa.$$.fragment),vt=o(),D=p("div"),m(ra.$$.fragment),Is=o(),Va=p("p"),Va.textContent=yn,Ds=o(),La=p("p"),La.innerHTML=_n,Rs=o(),m(Me.$$.fragment),At=o(),m(ia.$$.fragment),$t=o(),m(ca.$$.fragment),It=o(),R=p("div"),m(pa.$$.fragment),ks=o(),Ha=p("p"),Ha.textContent=jn,Es=o(),qa=p("p"),qa.innerHTML=bn,Ns=o(),fe=p("div"),m(da.$$.fragment),Zs=o(),za=p("p"),za.innerHTML=Cn,Dt=o(),m(ga.$$.fragment),Rt=o(),k=p("div"),m(ma.$$.fragment),Ws=o(),Pa=p("p"),Pa.innerHTML=Un,Gs=o(),Oa=p("p"),Oa.innerHTML=Jn,Ys=o(),m(ye.$$.fragment),kt=o(),m(ha.$$.fragment),Et=o(),Y=p("div"),m(ua.$$.fragment),Fs=o(),Ka=p("p"),Ka.innerHTML=xn,Qs=o(),m(_e.$$.fragment),Nt=o(),m(Ma.$$.fragment),Zt=o(),F=p("div"),m(fa.$$.fragment),Ss=o(),et=p("p"),et.textContent=wn,Bs=o(),m(je.$$.fragment),Wt=o(),m(ya.$$.fragment),Gt=o(),Q=p("div"),m(_a.$$.fragment),Xs=o(),at=p("p"),at.innerHTML=Tn,Vs=o(),m(be.$$.fragment),Yt=o(),ot=p("p"),this.h()},l(e){const l=Nn("svelte-u9bgzb",document.head);n=d(l,"META",{name:!0,content:!0}),l.forEach(t),j=r(e),_=d(e,"P",{}),J(_).forEach(t),s=r(e),h(g.$$.fragment,e),a=r(e),b=d(e,"P",{"data-svelte-h":!0}),C(b)!=="svelte-1iyhjbm"&&(b.innerHTML=Ls),rt=r(e),h(Te.$$.fragment,e),it=r(e),ve=d(e,"P",{"data-svelte-h":!0}),C(ve)!=="svelte-1wug0vl"&&(ve.innerHTML=Hs),ct=r(e),v=d(e,"DIV",{class:!0});var I=J(v);h(Ae.$$.fragment,I),Xt=r(I),N=d(I,"DIV",{class:!0});var S=J(N);h($e.$$.fragment,S),Vt=r(S),wa=d(S,"P",{"data-svelte-h":!0}),C(wa)!=="svelte-161avre"&&(wa.textContent=qs),Lt=r(S),h(se.$$.fragment,S),Ht=r(S),h(ne.$$.fragment,S),S.forEach(t),qt=r(I),V=d(I,"DIV",{class:!0});var K=J(V);h(Ie.$$.fragment,K),zt=r(K),Ta=d(K,"P",{"data-svelte-h":!0}),C(Ta)!=="svelte-18ags6f"&&(Ta.textContent=zs),Pt=r(K),va=d(K,"P",{"data-svelte-h":!0}),C(va)!=="svelte-1lmhx0i"&&(va.textContent=Ps),K.forEach(t),Ot=r(I),L=d(I,"DIV",{class:!0});var ee=J(L);h(De.$$.fragment,ee),Kt=r(ee),Aa=d(ee,"P",{"data-svelte-h":!0}),C(Aa)!=="svelte-b3pfo4"&&(Aa.textContent=Os),es=r(ee),h(le.$$.fragment,ee),ee.forEach(t),as=r(I),oe=d(I,"DIV",{class:!0});var ja=J(oe);h(Re.$$.fragment,ja),ts=r(ja),$a=d(ja,"P",{"data-svelte-h":!0}),C($a)!=="svelte-13tv3j4"&&($a.textContent=Ks),ja.forEach(t),ss=r(I),H=d(I,"DIV",{class:!0});var ae=J(H);h(ke.$$.fragment,ae),ns=r(ae),Ia=d(ae,"P",{"data-svelte-h":!0}),C(Ia)!=="svelte-9cwft2"&&(Ia.textContent=en),ls=r(ae),h(re.$$.fragment,ae),ae.forEach(t),os=r(I),q=d(I,"DIV",{class:!0});var te=J(q);h(Ee.$$.fragment,te),rs=r(te),Da=d(te,"P",{"data-svelte-h":!0}),C(Da)!=="svelte-x5cazf"&&(Da.innerHTML=an),is=r(te),h(ie.$$.fragment,te),te.forEach(t),I.forEach(t),pt=r(e),h(Ne.$$.fragment,e),dt=r(e),Ze=d(e,"P",{"data-svelte-h":!0}),C(Ze)!=="svelte-18mus8f"&&(Ze.innerHTML=tn),gt=r(e),T=d(e,"DIV",{class:!0});var A=J(T);h(We.$$.fragment,A),cs=r(A),Ra=d(A,"P",{"data-svelte-h":!0}),C(Ra)!=="svelte-11gq3a9"&&(Ra.textContent=sn),ps=r(A),ka=d(A,"P",{"data-svelte-h":!0}),C(ka)!=="svelte-1fnzwhv"&&(ka.innerHTML=nn),ds=r(A),Ea=d(A,"P",{"data-svelte-h":!0}),C(Ea)!=="svelte-3994xf"&&(Ea.innerHTML=ln),gs=r(A),ce=d(A,"DIV",{class:!0});var ba=J(ce);h(Ge.$$.fragment,ba),ms=r(ba),Na=d(ba,"P",{"data-svelte-h":!0}),C(Na)!=="svelte-1vt5g5k"&&(Na.textContent=on),ba.forEach(t),hs=r(A),pe=d(A,"DIV",{class:!0});var Ca=J(pe);h(Ye.$$.fragment,Ca),us=r(Ca),Za=d(Ca,"P",{"data-svelte-h":!0}),C(Za)!=="svelte-1tl2a7n"&&(Za.textContent=rn),Ca.forEach(t),Ms=r(A),de=d(A,"DIV",{class:!0});var Ua=J(de);h(Fe.$$.fragment,Ua),fs=r(Ua),Wa=d(Ua,"P",{"data-svelte-h":!0}),C(Wa)!=="svelte-1s2hgf6"&&(Wa.textContent=cn),Ua.forEach(t),ys=r(A),ge=d(A,"DIV",{class:!0});var Ja=J(ge);h(Qe.$$.fragment,Ja),_s=r(Ja),Ga=d(Ja,"P",{"data-svelte-h":!0}),C(Ga)!=="svelte-1wsmx9v"&&(Ga.textContent=pn),Ja.forEach(t),A.forEach(t),mt=r(e),h(Se.$$.fragment,e),ht=r(e),h(Be.$$.fragment,e),ut=r(e),z=d(e,"DIV",{class:!0});var xa=J(z);h(Xe.$$.fragment,xa),js=r(xa),Z=d(xa,"DIV",{class:!0});var Ce=J(Z);h(Ve.$$.fragment,Ce),bs=r(Ce),Ya=d(Ce,"P",{"data-svelte-h":!0}),C(Ya)!=="svelte-1eear21"&&(Ya.innerHTML=dn),Cs=r(Ce),Fa=d(Ce,"P",{"data-svelte-h":!0}),C(Fa)!=="svelte-1lmhx0i"&&(Fa.textContent=gn),Us=r(Ce),h(me.$$.fragment,Ce),Ce.forEach(t),xa.forEach(t),Mt=r(e),h(Le.$$.fragment,e),ft=r(e),G=d(e,"DIV",{class:!0});var tt=J(G);h(He.$$.fragment,tt),Js=r(tt),Qa=d(tt,"P",{"data-svelte-h":!0}),C(Qa)!=="svelte-rhbg82"&&(Qa.textContent=mn),xs=r(tt),h(he.$$.fragment,tt),tt.forEach(t),yt=r(e),h(qe.$$.fragment,e),_t=r(e),ze=d(e,"P",{"data-svelte-h":!0}),C(ze)!=="svelte-1vz0b8q"&&(ze.textContent=hn),jt=r(e),h(Pe.$$.fragment,e),bt=r(e),P=d(e,"DIV",{class:!0});var Qt=J(P);h(Oe.$$.fragment,Qt),ws=r(Qt),W=d(Qt,"DIV",{class:!0});var Ue=J(W);h(Ke.$$.fragment,Ue),Ts=r(Ue),Sa=d(Ue,"P",{"data-svelte-h":!0}),C(Sa)!=="svelte-1stjz9i"&&(Sa.innerHTML=un),vs=r(Ue),Ba=d(Ue,"P",{"data-svelte-h":!0}),C(Ba)!=="svelte-1lmhx0i"&&(Ba.textContent=Mn),As=r(Ue),h(ue.$$.fragment,Ue),Ue.forEach(t),Qt.forEach(t),Ct=r(e),h(ea.$$.fragment,e),Ut=r(e),O=d(e,"DIV",{class:!0});var St=J(O);h(aa.$$.fragment,St),$s=r(St),Xa=d(St,"P",{"data-svelte-h":!0}),C(Xa)!=="svelte-q1o4e7"&&(Xa.textContent=fn),St.forEach(t),Jt=r(e),h(ta.$$.fragment,e),xt=r(e),h(sa.$$.fragment,e),wt=r(e),na=d(e,"DIV",{class:!0});var vn=J(na);h(la.$$.fragment,vn),vn.forEach(t),Tt=r(e),h(oa.$$.fragment,e),vt=r(e),D=d(e,"DIV",{class:!0});var Je=J(D);h(ra.$$.fragment,Je),Is=r(Je),Va=d(Je,"P",{"data-svelte-h":!0}),C(Va)!=="svelte-1j9hyb1"&&(Va.textContent=yn),Ds=r(Je),La=d(Je,"P",{"data-svelte-h":!0}),C(La)!=="svelte-sg51el"&&(La.innerHTML=_n),Rs=r(Je),h(Me.$$.fragment,Je),Je.forEach(t),At=r(e),h(ia.$$.fragment,e),$t=r(e),h(ca.$$.fragment,e),It=r(e),R=d(e,"DIV",{class:!0});var xe=J(R);h(pa.$$.fragment,xe),ks=r(xe),Ha=d(xe,"P",{"data-svelte-h":!0}),C(Ha)!=="svelte-1tnxdck"&&(Ha.textContent=jn),Es=r(xe),qa=d(xe,"P",{"data-svelte-h":!0}),C(qa)!=="svelte-1en2oav"&&(qa.innerHTML=bn),Ns=r(xe),fe=d(xe,"DIV",{class:!0});var Bt=J(fe);h(da.$$.fragment,Bt),Zs=r(Bt),za=d(Bt,"P",{"data-svelte-h":!0}),C(za)!=="svelte-6pr4vq"&&(za.innerHTML=Cn),Bt.forEach(t),xe.forEach(t),Dt=r(e),h(ga.$$.fragment,e),Rt=r(e),k=d(e,"DIV",{class:!0});var we=J(k);h(ma.$$.fragment,we),Ws=r(we),Pa=d(we,"P",{"data-svelte-h":!0}),C(Pa)!=="svelte-18o9q21"&&(Pa.innerHTML=Un),Gs=r(we),Oa=d(we,"P",{"data-svelte-h":!0}),C(Oa)!=="svelte-1nu88lf"&&(Oa.innerHTML=Jn),Ys=r(we),h(ye.$$.fragment,we),we.forEach(t),kt=r(e),h(ha.$$.fragment,e),Et=r(e),Y=d(e,"DIV",{class:!0});var st=J(Y);h(ua.$$.fragment,st),Fs=r(st),Ka=d(st,"P",{"data-svelte-h":!0}),C(Ka)!=="svelte-oll614"&&(Ka.innerHTML=xn),Qs=r(st),h(_e.$$.fragment,st),st.forEach(t),Nt=r(e),h(Ma.$$.fragment,e),Zt=r(e),F=d(e,"DIV",{class:!0});var nt=J(F);h(fa.$$.fragment,nt),Ss=r(nt),et=d(nt,"P",{"data-svelte-h":!0}),C(et)!=="svelte-67svdo"&&(et.textContent=wn),Bs=r(nt),h(je.$$.fragment,nt),nt.forEach(t),Wt=r(e),h(ya.$$.fragment,e),Gt=r(e),Q=d(e,"DIV",{class:!0});var lt=J(Q);h(_a.$$.fragment,lt),Xs=r(lt),at=d(lt,"P",{"data-svelte-h":!0}),C(at)!=="svelte-1v61xs3"&&(at.innerHTML=Tn),Vs=r(lt),h(be.$$.fragment,lt),lt.forEach(t),Yt=r(e),ot=d(e,"P",{}),J(ot).forEach(t),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",Pn),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){i(document.head,n),c(e,j,l),c(e,_,l),c(e,s,l),u(g,e,l),c(e,a,l),c(e,b,l),c(e,rt,l),u(Te,e,l),c(e,it,l),c(e,ve,l),c(e,ct,l),c(e,v,l),u(Ae,v,null),i(v,Xt),i(v,N),u($e,N,null),i(N,Vt),i(N,wa),i(N,Lt),u(se,N,null),i(N,Ht),u(ne,N,null),i(v,qt),i(v,V),u(Ie,V,null),i(V,zt),i(V,Ta),i(V,Pt),i(V,va),i(v,Ot),i(v,L),u(De,L,null),i(L,Kt),i(L,Aa),i(L,es),u(le,L,null),i(v,as),i(v,oe),u(Re,oe,null),i(oe,ts),i(oe,$a),i(v,ss),i(v,H),u(ke,H,null),i(H,ns),i(H,Ia),i(H,ls),u(re,H,null),i(v,os),i(v,q),u(Ee,q,null),i(q,rs),i(q,Da),i(q,is),u(ie,q,null),c(e,pt,l),u(Ne,e,l),c(e,dt,l),c(e,Ze,l),c(e,gt,l),c(e,T,l),u(We,T,null),i(T,cs),i(T,Ra),i(T,ps),i(T,ka),i(T,ds),i(T,Ea),i(T,gs),i(T,ce),u(Ge,ce,null),i(ce,ms),i(ce,Na),i(T,hs),i(T,pe),u(Ye,pe,null),i(pe,us),i(pe,Za),i(T,Ms),i(T,de),u(Fe,de,null),i(de,fs),i(de,Wa),i(T,ys),i(T,ge),u(Qe,ge,null),i(ge,_s),i(ge,Ga),c(e,mt,l),u(Se,e,l),c(e,ht,l),u(Be,e,l),c(e,ut,l),c(e,z,l),u(Xe,z,null),i(z,js),i(z,Z),u(Ve,Z,null),i(Z,bs),i(Z,Ya),i(Z,Cs),i(Z,Fa),i(Z,Us),u(me,Z,null),c(e,Mt,l),u(Le,e,l),c(e,ft,l),c(e,G,l),u(He,G,null),i(G,Js),i(G,Qa),i(G,xs),u(he,G,null),c(e,yt,l),u(qe,e,l),c(e,_t,l),c(e,ze,l),c(e,jt,l),u(Pe,e,l),c(e,bt,l),c(e,P,l),u(Oe,P,null),i(P,ws),i(P,W),u(Ke,W,null),i(W,Ts),i(W,Sa),i(W,vs),i(W,Ba),i(W,As),u(ue,W,null),c(e,Ct,l),u(ea,e,l),c(e,Ut,l),c(e,O,l),u(aa,O,null),i(O,$s),i(O,Xa),c(e,Jt,l),u(ta,e,l),c(e,xt,l),u(sa,e,l),c(e,wt,l),c(e,na,l),u(la,na,null),c(e,Tt,l),u(oa,e,l),c(e,vt,l),c(e,D,l),u(ra,D,null),i(D,Is),i(D,Va),i(D,Ds),i(D,La),i(D,Rs),u(Me,D,null),c(e,At,l),u(ia,e,l),c(e,$t,l),u(ca,e,l),c(e,It,l),c(e,R,l),u(pa,R,null),i(R,ks),i(R,Ha),i(R,Es),i(R,qa),i(R,Ns),i(R,fe),u(da,fe,null),i(fe,Zs),i(fe,za),c(e,Dt,l),u(ga,e,l),c(e,Rt,l),c(e,k,l),u(ma,k,null),i(k,Ws),i(k,Pa),i(k,Gs),i(k,Oa),i(k,Ys),u(ye,k,null),c(e,kt,l),u(ha,e,l),c(e,Et,l),c(e,Y,l),u(ua,Y,null),i(Y,Fs),i(Y,Ka),i(Y,Qs),u(_e,Y,null),c(e,Nt,l),u(Ma,e,l),c(e,Zt,l),c(e,F,l),u(fa,F,null),i(F,Ss),i(F,et),i(F,Bs),u(je,F,null),c(e,Wt,l),u(ya,e,l),c(e,Gt,l),c(e,Q,l),u(_a,Q,null),i(Q,Xs),i(Q,at),i(Q,Vs),u(be,Q,null),c(e,Yt,l),c(e,ot,l),Ft=!0},p(e,[l]){const I={};l&2&&(I.$$scope={dirty:l,ctx:e}),se.$set(I);const S={};l&2&&(S.$$scope={dirty:l,ctx:e}),ne.$set(S);const K={};l&2&&(K.$$scope={dirty:l,ctx:e}),le.$set(K);const ee={};l&2&&(ee.$$scope={dirty:l,ctx:e}),re.$set(ee);const ja={};l&2&&(ja.$$scope={dirty:l,ctx:e}),ie.$set(ja);const ae={};l&2&&(ae.$$scope={dirty:l,ctx:e}),me.$set(ae);const te={};l&2&&(te.$$scope={dirty:l,ctx:e}),he.$set(te);const A={};l&2&&(A.$$scope={dirty:l,ctx:e}),ue.$set(A);const ba={};l&2&&(ba.$$scope={dirty:l,ctx:e}),Me.$set(ba);const Ca={};l&2&&(Ca.$$scope={dirty:l,ctx:e}),ye.$set(Ca);const Ua={};l&2&&(Ua.$$scope={dirty:l,ctx:e}),_e.$set(Ua);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:e}),je.$set(Ja);const xa={};l&2&&(xa.$$scope={dirty:l,ctx:e}),be.$set(xa)},i(e){Ft||(M(g.$$.fragment,e),M(Te.$$.fragment,e),M(Ae.$$.fragment,e),M($e.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(Ie.$$.fragment,e),M(De.$$.fragment,e),M(le.$$.fragment,e),M(Re.$$.fragment,e),M(ke.$$.fragment,e),M(re.$$.fragment,e),M(Ee.$$.fragment,e),M(ie.$$.fragment,e),M(Ne.$$.fragment,e),M(We.$$.fragment,e),M(Ge.$$.fragment,e),M(Ye.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(Se.$$.fragment,e),M(Be.$$.fragment,e),M(Xe.$$.fragment,e),M(Ve.$$.fragment,e),M(me.$$.fragment,e),M(Le.$$.fragment,e),M(He.$$.fragment,e),M(he.$$.fragment,e),M(qe.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(Ke.$$.fragment,e),M(ue.$$.fragment,e),M(ea.$$.fragment,e),M(aa.$$.fragment,e),M(ta.$$.fragment,e),M(sa.$$.fragment,e),M(la.$$.fragment,e),M(oa.$$.fragment,e),M(ra.$$.fragment,e),M(Me.$$.fragment,e),M(ia.$$.fragment,e),M(ca.$$.fragment,e),M(pa.$$.fragment,e),M(da.$$.fragment,e),M(ga.$$.fragment,e),M(ma.$$.fragment,e),M(ye.$$.fragment,e),M(ha.$$.fragment,e),M(ua.$$.fragment,e),M(_e.$$.fragment,e),M(Ma.$$.fragment,e),M(fa.$$.fragment,e),M(je.$$.fragment,e),M(ya.$$.fragment,e),M(_a.$$.fragment,e),M(be.$$.fragment,e),Ft=!0)},o(e){f(g.$$.fragment,e),f(Te.$$.fragment,e),f(Ae.$$.fragment,e),f($e.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(Ie.$$.fragment,e),f(De.$$.fragment,e),f(le.$$.fragment,e),f(Re.$$.fragment,e),f(ke.$$.fragment,e),f(re.$$.fragment,e),f(Ee.$$.fragment,e),f(ie.$$.fragment,e),f(Ne.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ye.$$.fragment,e),f(Fe.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Be.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(me.$$.fragment,e),f(Le.$$.fragment,e),f(He.$$.fragment,e),f(he.$$.fragment,e),f(qe.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(ue.$$.fragment,e),f(ea.$$.fragment,e),f(aa.$$.fragment,e),f(ta.$$.fragment,e),f(sa.$$.fragment,e),f(la.$$.fragment,e),f(oa.$$.fragment,e),f(ra.$$.fragment,e),f(Me.$$.fragment,e),f(ia.$$.fragment,e),f(ca.$$.fragment,e),f(pa.$$.fragment,e),f(da.$$.fragment,e),f(ga.$$.fragment,e),f(ma.$$.fragment,e),f(ye.$$.fragment,e),f(ha.$$.fragment,e),f(ua.$$.fragment,e),f(_e.$$.fragment,e),f(Ma.$$.fragment,e),f(fa.$$.fragment,e),f(je.$$.fragment,e),f(ya.$$.fragment,e),f(_a.$$.fragment,e),f(be.$$.fragment,e),Ft=!1},d(e){e&&(t(j),t(_),t(s),t(a),t(b),t(rt),t(it),t(ve),t(ct),t(v),t(pt),t(dt),t(Ze),t(gt),t(T),t(mt),t(ht),t(ut),t(z),t(Mt),t(ft),t(G),t(yt),t(_t),t(ze),t(jt),t(bt),t(P),t(Ct),t(Ut),t(O),t(Jt),t(xt),t(wt),t(na),t(Tt),t(vt),t(D),t(At),t($t),t(It),t(R),t(Dt),t(Rt),t(k),t(kt),t(Et),t(Y),t(Nt),t(Zt),t(F),t(Wt),t(Gt),t(Q),t(Yt),t(ot)),t(n),y(g,e),y(Te,e),y(Ae),y($e),y(se),y(ne),y(Ie),y(De),y(le),y(Re),y(ke),y(re),y(Ee),y(ie),y(Ne,e),y(We),y(Ge),y(Ye),y(Fe),y(Qe),y(Se,e),y(Be,e),y(Xe),y(Ve),y(me),y(Le,e),y(He),y(he),y(qe,e),y(Pe,e),y(Oe),y(Ke),y(ue),y(ea,e),y(aa),y(ta,e),y(sa,e),y(la),y(oa,e),y(ra),y(Me),y(ia,e),y(ca,e),y(pa),y(da),y(ga,e),y(ma),y(ye),y(ha,e),y(ua),y(_e),y(Ma,e),y(fa),y(je),y(ya,e),y(_a),y(be)}}}const Pn='{"title":"Repository Cards","local":"repository-cards","sections":[{"title":"Repo Card","local":"huggingface_hub.RepoCard","sections":[],"depth":2},{"title":"Card Data","local":"huggingface_hub.CardData","sections":[],"depth":2},{"title":"Model Cards","local":"model-cards","sections":[{"title":"ModelCard","local":"huggingface_hub.ModelCard","sections":[],"depth":3},{"title":"ModelCardData","local":"huggingface_hub.ModelCardData","sections":[],"depth":3}],"depth":2},{"title":"Dataset Cards","local":"dataset-cards","sections":[{"title":"DatasetCard","local":"huggingface_hub.DatasetCard","sections":[],"depth":3},{"title":"DatasetCardData","local":"huggingface_hub.DatasetCardData","sections":[],"depth":3}],"depth":2},{"title":"Space Cards","local":"space-cards","sections":[{"title":"SpaceCard","local":"huggingface_hub.SpaceCard","sections":[],"depth":3},{"title":"SpaceCardData","local":"huggingface_hub.SpaceCardData","sections":[],"depth":3}],"depth":2},{"title":"Utilities","local":"utilities","sections":[{"title":"EvalResult","local":"huggingface_hub.EvalResult","sections":[],"depth":3},{"title":"model_index_to_eval_results","local":"huggingface_hub.repocard_data.model_index_to_eval_results","sections":[],"depth":3},{"title":"eval_results_to_model_index","local":"huggingface_hub.repocard_data.eval_results_to_model_index","sections":[],"depth":3},{"title":"metadata_eval_result","local":"huggingface_hub.metadata_eval_result","sections":[],"depth":3},{"title":"metadata_update","local":"huggingface_hub.metadata_update","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(U){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends kn{constructor(n){super(),En(this,n,On,zn,Dn,{})}}export{ol as component};
