import{s as xe,n as We,o as Se}from"../chunks/scheduler.7da89386.js";import{S as ze,i as Be,g as o,s as a,r as c,A as He,h as i,f as s,c as n,j as V,u as M,x as r,k as Ge,y as h,a as l,v as f,d as y,t as w,w as u}from"../chunks/index.0b7befd3.js";import{C as ce}from"../chunks/CodeBlock.ce33a881.js";import{H as Y}from"../chunks/Heading.8a936589.js";function Le(Ue){let m,X,A,q,U,F,T,K,b,Te=`Using specific functions, which should work in most cases for you.
This is not without side effects.`,P,j,D,g,O,v,be=`Pytorch uses shared tensors for some computation.
This is extremely interesting to reduce memory usage in general.`,ee,J,je=`One very classic use case is in transformers the <code>embeddings</code> are shared with
<code>lm_head</code>. By using the same matrix, the model uses less parameters, and gradients
flow much better to the <code>embeddings</code> (which is the start of the model, so they don’t
flow easily there, whereas <code>lm_head</code> is at the tail of the model, so gradients are
extremely good over there, since they are the same tensors, they both benefit)`,te,k,se,C,le,I,ge="Multiple reasons for that:",ae,d,B,ve=`<p><em>Not all frameworks support them</em> for instance <code>tensorflow</code> does not.
So if someone saves shared tensors in torch, there is no way to
load them in a similar fashion so we could not keep the same <code>Dict[str, Tensor]</code>
API.</p>`,Me,p,H,Je=`<em>It makes lazy loading very quickly.</em>
Lazy loading is the ability to load only some tensors, or part of tensors for
a given file. This is trivial to do without sharing tensors but with tensor sharing`,fe,Z,ye,L,ke=`Now it’s impossible with this given code to “reshare” buffers after the fact.
Once we give the <code>a</code> tensor we have no way to give back the same memory when
you ask for <code>b</code>. (In this particular example we could keep track of given buffers
but this is not the case in general, since you could do arbitrary work with <code>a</code>
like sending it to another device before asking for <code>b</code>)`,we,$,Q,Ce=`<em>It can lead to much larger file than necessary</em>.
If you are saving a shared tensor which is only a fraction of a larger tensor,
then saving it with pytorch leads to saving the entire buffer instead of saving
just what is needed.`,ue,_,ne,G,Ie=`Now with all those reasons being mentioned, nothing is set in stone in there.
Shared tensors do not cause unsafety, or denial of service potential, so this
decision could be revisited if current workarounds are not satisfactory.`,oe,x,ie,W,Ze=`The design is rather simple.
We’re going to look for all shared tensors, then looking for all tensors
covering the entire buffer (there can be multiple such tensors).
That gives us multiple names which can be saved, we simply choose the first one`,re,S,$e=`During <code>load_model</code>, we are loading a bit like <code>load_state_dict</code> does, except
we’re looking into the model itself, to check for shared buffers, and ignoring
the “missed keys” which were actually covered by virtue of buffer sharing (they
were properly loaded since there was a buffer that loaded under the hood).
Every other error is raised as-is`,he,z,_e=`<strong>Caveat</strong>: This means we’re dropping some keys within the file. meaning if you’re
checking for the keys saved on disk, you will see some “missing tensors” or if you’re
using <code>load_state_dict</code>. Unless we start supporting shared tensors directly in
the format there’s no real way around it.`,de,N,me;return U=new Y({props:{title:"Torch shared tensors",local:"torch-shared-tensors",headingTag:"h1"}}),T=new Y({props:{title:"TL;DR",local:"tldr",headingTag:"h2"}}),j=new ce({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9tb2RlbCUyQyUyMHNhdmVfbW9kZWwlMEElMEFzYXZlX21vZGVsKG1vZGVsJTJDJTIwJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBJTIzJTIwSW5zdGVhZCUyMG9mJTIwc2F2ZV9maWxlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSUwQSUwQWxvYWRfbW9kZWwobW9kZWwlMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMjMlMjBJbnN0ZWFkJTIwb2YlMjBtb2RlbC5sb2FkX3N0YXRlX2RpY3QobG9hZF9maWxlKCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSk=",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_model, save_model

save_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of save_file(model.state_dict(), &quot;model.safetensors&quot;)</span>

load_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of model.load_state_dict(load_file(&quot;model.safetensors&quot;))</span>`,wrap:!1}}),g=new Y({props:{title:"What are shared tensors ?",local:"what-are-shared-tensors-",headingTag:"h2"}}),k=new ce({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEFjbGFzcyUyME1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYSUyMCUzRCUyMG5uLkxpbmVhcigxMDAlMkMlMjAxMDApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iJTIwJTNEJTIwc2VsZi5hJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmIoc2VsZi5hKHgpKSUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwTW9kZWwoKSUwQXByaW50KG1vZGVsLnN0YXRlX2RpY3QoKSklMEElMjMlMjBvZGljdF9rZXlzKCU1QidhLndlaWdodCclMkMlMjAnYS5iaWFzJyUyQyUyMCdiLndlaWdodCclMkMlMjAnYi5iaWFzJyU1RCklMEF0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLmJpbiUyMiklMEElMjMlMjBUaGlzJTIwZmlsZSUyMGlzJTIwbm93JTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwfjgwayUyQyUyMGJlY2F1c2UlMjBBJTIwYW5kJTIwQiUyMGFyZSUyMHRoZSUyMHNhbWUlMjB3ZWlnaHQlMjBoZW5jZSUyMG9ubHklMjAxJTIwaXMlMjBzYXZlZCUyMG9uJTIwZGlzayUyMHdpdGglMjBib3RoJTIwJTYwYSU2MCUyMGFuZCUyMCU2MGIlNjAlMjBwb2ludGluZyUyMHRvJTIwdGhlJTIwc2FtZSUyMGJ1ZmZlcg==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Model</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.a = nn.Linear(<span class="hljs-number">100</span>, <span class="hljs-number">100</span>)
        self.b = self.a

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.b(self.a(x))


model = Model()
<span class="hljs-built_in">print</span>(model.state_dict())
<span class="hljs-comment"># odict_keys([&#x27;a.weight&#x27;, &#x27;a.bias&#x27;, &#x27;b.weight&#x27;, &#x27;b.bias&#x27;])</span>
torch.save(model.state_dict(), <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># This file is now 41k instead of ~80k, because A and B are the same weight hence only 1 is saved on disk with both \`a\` and \`b\` pointing to the same buffer</span>`,wrap:!1}}),C=new Y({props:{title:"Why are shared tensors not saved in safetensors ?",local:"why-are-shared-tensors-not-saved-in-safetensors-",headingTag:"h2"}}),Z=new ce({props:{code:"d2l0aCUyMHNhZmVfb3BlbiglMjJtb2RlbC5zYWZldGVuc29ycyUyMiUyQyUyMGZyYW1ld29yayUzRCUyMnB0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGElMjAlM0QlMjBmLmdldF90ZW5zb3IoJTIyYSUyMiklMEElMjAlMjAlMjAlMjBiJTIwJTNEJTIwZi5nZXRfdGVuc29yKCUyMmIlMjIp",highlighted:`<span class="hljs-keyword">with</span> safe_open(<span class="hljs-string">&quot;model.safetensors&quot;</span>, framework=<span class="hljs-string">&quot;pt&quot;</span>) <span class="hljs-keyword">as</span> f:
    a = f.get_tensor(<span class="hljs-string">&quot;a&quot;</span>)
    b = f.get_tensor(<span class="hljs-string">&quot;b&quot;</span>)`,wrap:!1}}),_=new ce({props:{code:"YSUyMCUzRCUyMHRvcmNoLnplcm9zKCgxMDAlMkMlMjAxMDApKSUwQWIlMjAlM0QlMjBhJTVCJTNBMSUyQyUyMCUzQSU1RCUwQXRvcmNoLnNhdmUoJTdCJTIyYiUyMiUzQSUyMGIlN0QlMkMlMjAlMjJtb2RlbC5iaW4lMjIpJTBBJTIzJTIwRmlsZSUyMGlzJTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwdGhlJTIwZXhwZWN0ZWQlMjA0MDAlMjBieXRlcyUwQSUyMyUyMEluJTIwcHJhY3RpY2UlMjBpdCUyMGNvdWxkJTIwaGFwcGVuJTIwdGhhdCUyMHlvdSUyMHNhdmUlMjBzZXZlcmFsJTIwMTBHQiUyMGluc3RlYWQlMjBvZiUyMDFHQi4=",highlighted:`a = torch.zeros((<span class="hljs-number">100</span>, <span class="hljs-number">100</span>))
b = a[:<span class="hljs-number">1</span>, :]
torch.save({<span class="hljs-string">&quot;b&quot;</span>: b}, <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># File is 41k instead of the expected 400 bytes</span>
<span class="hljs-comment"># In practice it could happen that you save several 10GB instead of 1GB.</span>`,wrap:!1}}),x=new Y({props:{title:"How does it work ?",local:"how-does-it-work-",headingTag:"h2"}}),{c(){m=o("meta"),X=a(),A=o("p"),q=a(),c(U.$$.fragment),F=a(),c(T.$$.fragment),K=a(),b=o("p"),b.textContent=Te,P=a(),c(j.$$.fragment),D=a(),c(g.$$.fragment),O=a(),v=o("p"),v.textContent=be,ee=a(),J=o("p"),J.innerHTML=je,te=a(),c(k.$$.fragment),se=a(),c(C.$$.fragment),le=a(),I=o("p"),I.textContent=ge,ae=a(),d=o("ul"),B=o("li"),B.innerHTML=ve,Me=a(),p=o("li"),H=o("p"),H.innerHTML=Je,fe=a(),c(Z.$$.fragment),ye=a(),L=o("p"),L.innerHTML=ke,we=a(),$=o("li"),Q=o("p"),Q.innerHTML=Ce,ue=a(),c(_.$$.fragment),ne=a(),G=o("p"),G.textContent=Ie,oe=a(),c(x.$$.fragment),ie=a(),W=o("p"),W.textContent=Ze,re=a(),S=o("p"),S.innerHTML=$e,he=a(),z=o("p"),z.innerHTML=_e,de=a(),N=o("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(s),X=n(e),A=i(e,"P",{}),V(A).forEach(s),q=n(e),M(U.$$.fragment,e),F=n(e),M(T.$$.fragment,e),K=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1njntk5"&&(b.textContent=Te),P=n(e),M(j.$$.fragment,e),D=n(e),M(g.$$.fragment,e),O=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8wiat7"&&(v.textContent=be),ee=n(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-bbm4tq"&&(J.innerHTML=je),te=n(e),M(k.$$.fragment,e),se=n(e),M(C.$$.fragment,e),le=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-10c7yzp"&&(I.textContent=ge),ae=n(e),d=i(e,"UL",{});var R=V(d);B=i(R,"LI",{"data-svelte-h":!0}),r(B)!=="svelte-1screu0"&&(B.innerHTML=ve),Me=n(R),p=i(R,"LI",{});var E=V(p);H=i(E,"P",{"data-svelte-h":!0}),r(H)!=="svelte-p4qc76"&&(H.innerHTML=Je),fe=n(E),M(Z.$$.fragment,E),ye=n(E),L=i(E,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16k2rhu"&&(L.innerHTML=ke),E.forEach(s),we=n(R),$=i(R,"LI",{});var pe=V($);Q=i(pe,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hcigh9"&&(Q.innerHTML=Ce),ue=n(pe),M(_.$$.fragment,pe),pe.forEach(s),R.forEach(s),ne=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1kbj28l"&&(G.textContent=Ie),oe=n(e),M(x.$$.fragment,e),ie=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vyibui"&&(W.textContent=Ze),re=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-t5lt8b"&&(S.innerHTML=$e),he=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1c5k75d"&&(z.innerHTML=_e),de=n(e),N=i(e,"P",{}),V(N).forEach(s),this.h()},h(){Ge(m,"name","hf:doc:metadata"),Ge(m,"content",Qe)},m(e,t){h(document.head,m),l(e,X,t),l(e,A,t),l(e,q,t),f(U,e,t),l(e,F,t),f(T,e,t),l(e,K,t),l(e,b,t),l(e,P,t),f(j,e,t),l(e,D,t),f(g,e,t),l(e,O,t),l(e,v,t),l(e,ee,t),l(e,J,t),l(e,te,t),f(k,e,t),l(e,se,t),f(C,e,t),l(e,le,t),l(e,I,t),l(e,ae,t),l(e,d,t),h(d,B),h(d,Me),h(d,p),h(p,H),h(p,fe),f(Z,p,null),h(p,ye),h(p,L),h(d,we),h(d,$),h($,Q),h($,ue),f(_,$,null),l(e,ne,t),l(e,G,t),l(e,oe,t),f(x,e,t),l(e,ie,t),l(e,W,t),l(e,re,t),l(e,S,t),l(e,he,t),l(e,z,t),l(e,de,t),l(e,N,t),me=!0},p:We,i(e){me||(y(U.$$.fragment,e),y(T.$$.fragment,e),y(j.$$.fragment,e),y(g.$$.fragment,e),y(k.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(x.$$.fragment,e),me=!0)},o(e){w(U.$$.fragment,e),w(T.$$.fragment,e),w(j.$$.fragment,e),w(g.$$.fragment,e),w(k.$$.fragment,e),w(C.$$.fragment,e),w(Z.$$.fragment,e),w(_.$$.fragment,e),w(x.$$.fragment,e),me=!1},d(e){e&&(s(X),s(A),s(q),s(F),s(K),s(b),s(P),s(D),s(O),s(v),s(ee),s(J),s(te),s(se),s(le),s(I),s(ae),s(d),s(ne),s(G),s(oe),s(ie),s(W),s(re),s(S),s(he),s(z),s(de),s(N)),s(m),u(U,e),u(T,e),u(j,e),u(g,e),u(k,e),u(C,e),u(Z),u(_),u(x,e)}}}const Qe='{"title":"Torch shared tensors","local":"torch-shared-tensors","sections":[{"title":"TL;DR","local":"tldr","sections":[],"depth":2},{"title":"What are shared tensors ?","local":"what-are-shared-tensors-","sections":[],"depth":2},{"title":"Why are shared tensors not saved in safetensors ?","local":"why-are-shared-tensors-not-saved-in-safetensors-","sections":[],"depth":2},{"title":"How does it work ?","local":"how-does-it-work-","sections":[],"depth":2}],"depth":1}';function Re(Ue){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends ze{constructor(m){super(),Be(this,m,Re,Le,xe,{})}}export{Ye as component};
