import{s as Se,n as ze,o as Be}from"../chunks/scheduler.9f522b10.js";import{S as He,i as Le,g as o,s as n,r as m,A as Ee,h as i,f as s,c as a,j as Y,u as p,x as r,k as We,y as h,a as l,v as c,d as f,t as M,w as y}from"../chunks/index.4a68349c.js";import{C as Me}from"../chunks/CodeBlock.46fa3bb1.js";import{H as X,E as Qe}from"../chunks/getInferenceSnippets.61fe67e9.js";function Re(Te){let w,q,N,F,b,K,U,P,T,ge=`Using specific functions, which should work in most cases for you.
This is not without side effects.`,D,g,O,j,ee,v,je=`Pytorch uses shared tensors for some computation.
This is extremely interesting to reduce memory usage in general.`,te,J,ve=`One very classic use case is in transformers the <code>embeddings</code> are shared with
<code>lm_head</code>. By using the same matrix, the model uses less parameters, and gradients
flow much better to the <code>embeddings</code> (which is the start of the model, so they don’t
flow easily there, whereas <code>lm_head</code> is at the tail of the model, so gradients are
extremely good over there, since they are the same tensors, they both benefit)`,se,$,le,k,ne,C,Je="Multiple reasons for that:",ae,d,H,$e=`<p><em>Not all frameworks support them</em> for instance <code>tensorflow</code> does not.
So if someone saves shared tensors in torch, there is no way to
load them in a similar fashion so we could not keep the same <code>Dict[str, Tensor]</code>
API.</p>`,ye,u,L,ke=`<em>It makes lazy loading very quickly.</em>
Lazy loading is the ability to load only some tensors, or part of tensors for
a given file. This is trivial to do without sharing tensors but with tensor sharing`,we,I,ue,E,Ce=`Now it’s impossible with this given code to “reshare” buffers after the fact.
Once we give the <code>a</code> tensor we have no way to give back the same memory when
you ask for <code>b</code>. (In this particular example we could keep track of given buffers
but this is not the case in general, since you could do arbitrary work with <code>a</code>
like sending it to another device before asking for <code>b</code>)`,be,Z,Q,Ie=`<em>It can lead to much larger file than necessary</em>.
If you are saving a shared tensor which is only a fraction of a larger tensor,
then saving it with pytorch leads to saving the entire buffer instead of saving
just what is needed.`,Ue,_,oe,G,Ze=`Now with all those reasons being mentioned, nothing is set in stone in there.
Shared tensors do not cause unsafety, or denial of service potential, so this
decision could be revisited if current workarounds are not satisfactory.`,ie,x,re,W,_e=`The design is rather simple.
We’re going to look for all shared tensors, then looking for all tensors
covering the entire buffer (there can be multiple such tensors).
That gives us multiple names which can be saved, we simply choose the first one`,he,S,Ge=`During <code>load_model</code>, we are loading a bit like <code>load_state_dict</code> does, except
we’re looking into the model itself, to check for shared buffers, and ignoring
the “missed keys” which were actually covered by virtue of buffer sharing (they
were properly loaded since there was a buffer that loaded under the hood).
Every other error is raised as-is`,de,z,xe=`<strong>Caveat</strong>: This means we’re dropping some keys within the file. meaning if you’re
checking for the keys saved on disk, you will see some “missing tensors” or if you’re
using <code>load_state_dict</code>. Unless we start supporting shared tensors directly in
the format there’s no real way around it.`,me,B,pe,V,ce;return b=new X({props:{title:"Torch shared tensors",local:"torch-shared-tensors",headingTag:"h1"}}),U=new X({props:{title:"TL;DR",local:"tldr",headingTag:"h2"}}),g=new Me({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9tb2RlbCUyQyUyMHNhdmVfbW9kZWwlMEElMEFzYXZlX21vZGVsKG1vZGVsJTJDJTIwJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBJTIzJTIwSW5zdGVhZCUyMG9mJTIwc2F2ZV9maWxlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSUwQSUwQWxvYWRfbW9kZWwobW9kZWwlMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMjMlMjBJbnN0ZWFkJTIwb2YlMjBtb2RlbC5sb2FkX3N0YXRlX2RpY3QobG9hZF9maWxlKCUyMm1vZGVsLnNhZmV0ZW5zb3JzJTIyKSk=",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_model, save_model

save_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of save_file(model.state_dict(), &quot;model.safetensors&quot;)</span>

load_model(model, <span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-comment"># Instead of model.load_state_dict(load_file(&quot;model.safetensors&quot;))</span>`,wrap:!1}}),j=new X({props:{title:"What are shared tensors ?",local:"what-are-shared-tensors-",headingTag:"h2"}}),$=new Me({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEFjbGFzcyUyME1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYSUyMCUzRCUyMG5uLkxpbmVhcigxMDAlMkMlMjAxMDApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iJTIwJTNEJTIwc2VsZi5hJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmIoc2VsZi5hKHgpKSUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwTW9kZWwoKSUwQXByaW50KG1vZGVsLnN0YXRlX2RpY3QoKSklMEElMjMlMjBvZGljdF9rZXlzKCU1QidhLndlaWdodCclMkMlMjAnYS5iaWFzJyUyQyUyMCdiLndlaWdodCclMkMlMjAnYi5iaWFzJyU1RCklMEF0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLmJpbiUyMiklMEElMjMlMjBUaGlzJTIwZmlsZSUyMGlzJTIwbm93JTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwfjgwayUyQyUyMGJlY2F1c2UlMjBBJTIwYW5kJTIwQiUyMGFyZSUyMHRoZSUyMHNhbWUlMjB3ZWlnaHQlMjBoZW5jZSUyMG9ubHklMjAxJTIwaXMlMjBzYXZlZCUyMG9uJTIwZGlzayUyMHdpdGglMjBib3RoJTIwJTYwYSU2MCUyMGFuZCUyMCU2MGIlNjAlMjBwb2ludGluZyUyMHRvJTIwdGhlJTIwc2FtZSUyMGJ1ZmZlcg==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Model</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.a = nn.Linear(<span class="hljs-number">100</span>, <span class="hljs-number">100</span>)
        self.b = self.a

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.b(self.a(x))


model = Model()
<span class="hljs-built_in">print</span>(model.state_dict())
<span class="hljs-comment"># odict_keys([&#x27;a.weight&#x27;, &#x27;a.bias&#x27;, &#x27;b.weight&#x27;, &#x27;b.bias&#x27;])</span>
torch.save(model.state_dict(), <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># This file is now 41k instead of ~80k, because A and B are the same weight hence only 1 is saved on disk with both \`a\` and \`b\` pointing to the same buffer</span>`,wrap:!1}}),k=new X({props:{title:"Why are shared tensors not saved in safetensors ?",local:"why-are-shared-tensors-not-saved-in-safetensors-",headingTag:"h2"}}),I=new Me({props:{code:"d2l0aCUyMHNhZmVfb3BlbiglMjJtb2RlbC5zYWZldGVuc29ycyUyMiUyQyUyMGZyYW1ld29yayUzRCUyMnB0JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGElMjAlM0QlMjBmLmdldF90ZW5zb3IoJTIyYSUyMiklMEElMjAlMjAlMjAlMjBiJTIwJTNEJTIwZi5nZXRfdGVuc29yKCUyMmIlMjIp",highlighted:`<span class="hljs-keyword">with</span> safe_open(<span class="hljs-string">&quot;model.safetensors&quot;</span>, framework=<span class="hljs-string">&quot;pt&quot;</span>) <span class="hljs-keyword">as</span> f:
    a = f.get_tensor(<span class="hljs-string">&quot;a&quot;</span>)
    b = f.get_tensor(<span class="hljs-string">&quot;b&quot;</span>)`,wrap:!1}}),_=new Me({props:{code:"YSUyMCUzRCUyMHRvcmNoLnplcm9zKCgxMDAlMkMlMjAxMDApKSUwQWIlMjAlM0QlMjBhJTVCJTNBMSUyQyUyMCUzQSU1RCUwQXRvcmNoLnNhdmUoJTdCJTIyYiUyMiUzQSUyMGIlN0QlMkMlMjAlMjJtb2RlbC5iaW4lMjIpJTBBJTIzJTIwRmlsZSUyMGlzJTIwNDFrJTIwaW5zdGVhZCUyMG9mJTIwdGhlJTIwZXhwZWN0ZWQlMjA0MDAlMjBieXRlcyUwQSUyMyUyMEluJTIwcHJhY3RpY2UlMjBpdCUyMGNvdWxkJTIwaGFwcGVuJTIwdGhhdCUyMHlvdSUyMHNhdmUlMjBzZXZlcmFsJTIwMTBHQiUyMGluc3RlYWQlMjBvZiUyMDFHQi4=",highlighted:`a = torch.zeros((<span class="hljs-number">100</span>, <span class="hljs-number">100</span>))
b = a[:<span class="hljs-number">1</span>, :]
torch.save({<span class="hljs-string">&quot;b&quot;</span>: b}, <span class="hljs-string">&quot;model.bin&quot;</span>)
<span class="hljs-comment"># File is 41k instead of the expected 400 bytes</span>
<span class="hljs-comment"># In practice it could happen that you save several 10GB instead of 1GB.</span>`,wrap:!1}}),x=new X({props:{title:"How does it work ?",local:"how-does-it-work-",headingTag:"h2"}}),B=new Qe({props:{source:"https://github.com/huggingface/safetensors/blob/main/docs/source/torch_shared_tensors.mdx"}}),{c(){w=o("meta"),q=n(),N=o("p"),F=n(),m(b.$$.fragment),K=n(),m(U.$$.fragment),P=n(),T=o("p"),T.textContent=ge,D=n(),m(g.$$.fragment),O=n(),m(j.$$.fragment),ee=n(),v=o("p"),v.textContent=je,te=n(),J=o("p"),J.innerHTML=ve,se=n(),m($.$$.fragment),le=n(),m(k.$$.fragment),ne=n(),C=o("p"),C.textContent=Je,ae=n(),d=o("ul"),H=o("li"),H.innerHTML=$e,ye=n(),u=o("li"),L=o("p"),L.innerHTML=ke,we=n(),m(I.$$.fragment),ue=n(),E=o("p"),E.innerHTML=Ce,be=n(),Z=o("li"),Q=o("p"),Q.innerHTML=Ie,Ue=n(),m(_.$$.fragment),oe=n(),G=o("p"),G.textContent=Ze,ie=n(),m(x.$$.fragment),re=n(),W=o("p"),W.textContent=_e,he=n(),S=o("p"),S.innerHTML=Ge,de=n(),z=o("p"),z.innerHTML=xe,me=n(),m(B.$$.fragment),pe=n(),V=o("p"),this.h()},l(e){const t=Ee("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),q=a(e),N=i(e,"P",{}),Y(N).forEach(s),F=a(e),p(b.$$.fragment,e),K=a(e),p(U.$$.fragment,e),P=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1njntk5"&&(T.textContent=ge),D=a(e),p(g.$$.fragment,e),O=a(e),p(j.$$.fragment,e),ee=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8wiat7"&&(v.textContent=je),te=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-bbm4tq"&&(J.innerHTML=ve),se=a(e),p($.$$.fragment,e),le=a(e),p(k.$$.fragment,e),ne=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10c7yzp"&&(C.textContent=Je),ae=a(e),d=i(e,"UL",{});var R=Y(d);H=i(R,"LI",{"data-svelte-h":!0}),r(H)!=="svelte-1screu0"&&(H.innerHTML=$e),ye=a(R),u=i(R,"LI",{});var A=Y(u);L=i(A,"P",{"data-svelte-h":!0}),r(L)!=="svelte-p4qc76"&&(L.innerHTML=ke),we=a(A),p(I.$$.fragment,A),ue=a(A),E=i(A,"P",{"data-svelte-h":!0}),r(E)!=="svelte-16k2rhu"&&(E.innerHTML=Ce),A.forEach(s),be=a(R),Z=i(R,"LI",{});var fe=Y(Z);Q=i(fe,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hcigh9"&&(Q.innerHTML=Ie),Ue=a(fe),p(_.$$.fragment,fe),fe.forEach(s),R.forEach(s),oe=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1kbj28l"&&(G.textContent=Ze),ie=a(e),p(x.$$.fragment,e),re=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vyibui"&&(W.textContent=_e),he=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-t5lt8b"&&(S.innerHTML=Ge),de=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1c5k75d"&&(z.innerHTML=xe),me=a(e),p(B.$$.fragment,e),pe=a(e),V=i(e,"P",{}),Y(V).forEach(s),this.h()},h(){We(w,"name","hf:doc:metadata"),We(w,"content",Ae)},m(e,t){h(document.head,w),l(e,q,t),l(e,N,t),l(e,F,t),c(b,e,t),l(e,K,t),c(U,e,t),l(e,P,t),l(e,T,t),l(e,D,t),c(g,e,t),l(e,O,t),c(j,e,t),l(e,ee,t),l(e,v,t),l(e,te,t),l(e,J,t),l(e,se,t),c($,e,t),l(e,le,t),c(k,e,t),l(e,ne,t),l(e,C,t),l(e,ae,t),l(e,d,t),h(d,H),h(d,ye),h(d,u),h(u,L),h(u,we),c(I,u,null),h(u,ue),h(u,E),h(d,be),h(d,Z),h(Z,Q),h(Z,Ue),c(_,Z,null),l(e,oe,t),l(e,G,t),l(e,ie,t),c(x,e,t),l(e,re,t),l(e,W,t),l(e,he,t),l(e,S,t),l(e,de,t),l(e,z,t),l(e,me,t),c(B,e,t),l(e,pe,t),l(e,V,t),ce=!0},p:ze,i(e){ce||(f(b.$$.fragment,e),f(U.$$.fragment,e),f(g.$$.fragment,e),f(j.$$.fragment,e),f($.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(_.$$.fragment,e),f(x.$$.fragment,e),f(B.$$.fragment,e),ce=!0)},o(e){M(b.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(j.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M(x.$$.fragment,e),M(B.$$.fragment,e),ce=!1},d(e){e&&(s(q),s(N),s(F),s(K),s(P),s(T),s(D),s(O),s(ee),s(v),s(te),s(J),s(se),s(le),s(ne),s(C),s(ae),s(d),s(oe),s(G),s(ie),s(re),s(W),s(he),s(S),s(de),s(z),s(me),s(pe),s(V)),s(w),y(b,e),y(U,e),y(g,e),y(j,e),y($,e),y(k,e),y(I),y(_),y(x,e),y(B,e)}}}const Ae='{"title":"Torch shared tensors","local":"torch-shared-tensors","sections":[{"title":"TL;DR","local":"tldr","sections":[],"depth":2},{"title":"What are shared tensors ?","local":"what-are-shared-tensors-","sections":[],"depth":2},{"title":"Why are shared tensors not saved in safetensors ?","local":"why-are-shared-tensors-not-saved-in-safetensors-","sections":[],"depth":2},{"title":"How does it work ?","local":"how-does-it-work-","sections":[],"depth":2}],"depth":1}';function Ne(Te){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fe extends He{constructor(w){super(),Le(this,w,Ne,Re,Se,{})}}export{Fe as component};
