import{s as Gt,o as xt,n as Se}from"../chunks/scheduler.9bc65507.js";import{S as Vt,i as Yt,g as M,s as n,r as y,A as Qt,h as i,f as t,c as a,j as Rt,u as m,x as p,k as Xt,y as Et,a as s,v as r,d as c,t as d,w as J}from"../chunks/index.707bf1b6.js";import{T as Fe}from"../chunks/Tip.c2ecdbf4.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as Nl}from"../chunks/Heading.342b1fa6.js";function Ht(f){let o,j="モデルがライブラリ内のモデルと非常に似ている場合、このモデルと同じ構成を再利用できます。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ezhjpv"&&(o.textContent=j)},m(w,U){s(w,o,U)},p:Se,d(w){w&&t(o)}}}function zt(f){let o,j="このAPIは実験的であり、次のリリースでわずかな変更があるかもしれません。";return{c(){o=M("p"),o.textContent=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-x2rm6d"&&(o.textContent=j)},m(w,U){s(w,o,U)},p:Se,d(w){w&&t(o)}}}function Ft(f){let o,j="ライブラリからモデリングファイルをコピーする場合、ファイルの先頭にあるすべての相対インポートを<code>transformers</code>パッケージからインポートに置き換える必要があります。";return{c(){o=M("p"),o.innerHTML=j},l(w){o=i(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18u9vuk"&&(o.innerHTML=j)},m(w,U){s(w,o,U)},p:Se,d(w){w&&t(o)}}}function St(f){let o,j,w,U,I,Bl,_,Le="🤗 Transformersライブラリは、簡単に拡張できるように設計されています。すべてのモデルはリポジトリの特定のサブフォルダに完全にコード化されており、抽象化はありません。したがって、モデリングファイルをコピーして調整することが簡単です。",Wl,Z,Pe="新しいモデルを書いている場合、ゼロから始める方が簡単かもしれません。このチュートリアルでは、カスタムモデルとその設定をどのように書き、Transformers内で使用できるようにし、コードに依存する共同体と共有する方法を説明します。ライブラリに存在しない場合でも、誰でも使用できるようにします。",Rl,h,qe='これを実証するために、<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timmライブラリ</a>のResNetクラスを<a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>にラップすることによって、ResNetモデルを使用します。',Xl,g,Gl,A,De="モデルに取り組む前に、まずその設定を書きましょう。モデルの設定は、モデルを構築するために必要なすべての情報を含むオブジェクトです。次のセクションで見るように、モデルは初期化するために<code>config</code>しか受け取ることができないため、そのオブジェクトができるだけ完全である必要があります。",xl,$,Ke="この例では、ResNetクラスのいくつかの引数を取得し、調整したいかもしれないとします。異なる設定は、異なるタイプのResNetを提供します。その後、これらの引数を確認した後、それらの引数を単に格納します。",Vl,k,Yl,N,Oe="重要なことを3つ覚えておくべきポイントは次のとおりです：",Ql,v,lt="<li><code>PretrainedConfig</code> を継承する必要があります。</li> <li>あなたの <code>PretrainedConfig</code> の <code>__init__</code> は任意の kwargs を受け入れる必要があります。</li> <li>これらの <code>kwargs</code> は親クラスの <code>__init__</code> に渡す必要があります。</li>",El,B,et=`継承は、🤗 Transformers ライブラリのすべての機能を取得できるようにするためです。他の2つの制約は、
<code>PretrainedConfig</code> が設定しているフィールド以外にも多くのフィールドを持っていることから来ています。
<code>from_pretrained</code> メソッドで設定を再ロードする場合、これらのフィールドはあなたの設定に受け入れられ、
その後、親クラスに送信される必要があります。`,Hl,W,tt=`設定の <code>model_type</code> を定義すること（ここでは <code>model_type=&quot;resnet&quot;</code>）は、
自動クラスにモデルを登録したい場合を除いては必須ではありません（最後のセクションを参照）。`,zl,R,st=`これで、ライブラリの他のモデル設定と同様に、設定を簡単に作成して保存できます。
以下は、resnet50d 設定を作成して保存する方法の例です：`,Fl,X,Sl,G,nt="これにより、<code>custom-resnet</code> フォルダ内に <code>config.json</code> という名前のファイルが保存されます。その後、<code>from_pretrained</code> メソッドを使用して構成を再ロードできます。",Ll,x,Pl,V,at='また、<a href="/docs/transformers/v4.35.0/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> クラスの他のメソッドを使用することもできます。たとえば、<a href="/docs/transformers/v4.35.0/ja/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> を使用して、設定を直接 Hub にアップロードできます。',ql,Y,Dl,Q,Mt="ResNet の設定ができたので、モデルを書き始めることができます。実際には2つのモデルを書きます。1つはバッチの画像から隠れた特徴を抽出するモデル（<code>BertModel</code> のようなもの）で、もう1つは画像分類に適したモデル（<code>BertForSequenceClassification</code> のようなもの）です。",Kl,E,it="前述したように、この例をシンプルに保つために、モデルの緩いラッパーのみを書きます。このクラスを書く前に行う必要がある唯一のことは、ブロックタイプと実際のブロッククラスの間のマップです。その後、すべてを <code>ResNet</code> クラスに渡して設定からモデルを定義します：",Ol,H,le,z,pt="画像を分類するモデルの場合、forwardメソッドを変更するだけです：",ee,F,te,S,ot=`両方の場合、<code>PreTrainedModel</code>から継承し、<code>config</code>を使用してスーパークラスの初期化を呼び出します（通常の<code>torch.nn.Module</code>を書くときのような感じです）。
<code>config_class</code>を設定する行は必須ではありませんが、（最後のセクションを参照）、モデルを自動クラスに登録したい場合に使用できます。`,se,u,ne,L,yt=`モデルが返す内容は何でも構いませんが、ラベルが渡されるときに損失を含む辞書を返す（<code>ResnetModelForImageClassification</code>のように行ったもの）と、
モデルを<a href="/docs/transformers/v4.35.0/ja/main_classes/trainer#transformers.Trainer">Trainer</a>クラス内で直接使用できるようになります。独自のトレーニングループまたは他のライブラリを使用する予定である限り、
別の出力形式を使用することも問題ありません。`,ae,P,mt="さて、モデルクラスができたので、1つ作成しましょう：",Me,q,ie,D,rt=`再度、<a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>のいずれかのメソッド、例えば<a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>や
<a href="/docs/transformers/v4.35.0/ja/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>などを使用できます。次のセクションでは、モデルの重みをコードと一緒に
Hugging Face Hub にプッシュする方法を見てみます。
しかし、まずはモデル内に事前学習済みの重みをロードしましょう。`,pe,K,ct=`独自のユースケースでは、おそらく独自のデータでカスタムモデルをトレーニングすることになるでしょう。
このチュートリアルではスピードアップのために、resnet50dの事前学習済みバージョンを使用します。
私たちのモデルはそれをラップするだけなので、これらの重みを転送するのは簡単です：`,oe,O,ye,ll,dt=`さて、<a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>または<a href="/docs/transformers/v4.35.0/ja/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a>を実行したときに、
モデルのコードが保存されるようにする方法を見てみましょう。`,me,el,re,C,ce,tl,Jt=`まず、モデルが<code>.py</code>ファイルに完全に定義されていることを確認してください。
ファイルは相対インポートを他のファイルに依存できますが、すべてのファイルが同じディレクトリにある限り（まだこの機能ではサブモジュールはサポートしていません）、問題ありません。
この例では、現在の作業ディレクトリ内に名前が「resnet_model」のフォルダを作成し、その中に<code>modeling_resnet.py</code>ファイルと<code>configuration_resnet.py</code>ファイルを定義します。
構成ファイルには<code>ResnetConfig</code>のコードが含まれ、モデリングファイルには<code>ResnetModel</code>と<code>ResnetModelForImageClassification</code>のコードが含まれています。`,de,sl,Je,nl,wt="<code>__init__.py</code>は空であっても問題ありません。Pythonが<code>resnet_model</code>をモジュールとして検出できるようにするために存在します。",we,b,Te,al,Tt="既存の設定やモデルを再利用（またはサブクラス化）できることに注意してください。",je,Ml,jt="コミュニティとモデルを共有するために、次の手順に従ってください：まず、新しく作成したファイルからResNetモデルと設定をインポートします：",Ue,il,fe,pl,Ut="次に、<code>save_pretrained</code>メソッドを使用してこれらのオブジェクトのコードファイルをコピーし、特定のAutoクラス（特にモデルの場合）に正しく登録するようライブラリに指示する必要があります。次のように実行します：",ue,ol,Ce,yl,ft=`注意: 設定については自動クラスを指定する必要はありません（設定用の自動クラスは1つしかなく、<code>AutoConfig</code>です）が、
モデルについては異なります。カスタムモデルは多くの異なるタスクに適している可能性があるため、
モデルが正確な自動クラスのうちどれに適しているかを指定する必要があります。`,be,ml,ut="次に、前述のように設定とモデルを作成しましょう：",Ie,rl,_e,cl,Ct="モデルをHubに送信するには、ログインしていることを確認してください。ターミナルで次のコマンドを実行します：",Ze,dl,he,Jl,bt="またはノートブックから：",ge,wl,Ae,Tl,It="次に、次のようにして、独自の名前空間にプッシュできます（または、メンバーである組織にプッシュできます）：",$e,jl,ke,Ul,_t='モデリングの重みとJSON形式の構成に加えて、このフォルダー「custom-resnet50d」内のモデリングおよび構成「.py」ファイルもコピーされ、結果はHubにアップロードされました。結果はこの<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>で確認できます。',Ne,fl,Zt='詳細については、<a href="model_sharing">Hubへのプッシュ方法</a>を参照してください。',ve,ul,Be,Cl,ht=`自動クラスと <code>from_pretrained</code> メソッドを使用して、リポジトリ内のカスタムコードファイルと共に任意の構成、モデル、またはトークナイザを使用できます。 Hubにアップロードされるすべてのファイルとコードはマルウェアのスキャンが実施されます（詳細は<a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hubセキュリティ</a>ドキュメンテーションを参照してください）、しかし、依然として悪意のあるコードを実行しないために、モデルコードと作者を確認する必要があります。
<code>trust_remote_code=True</code> を設定してカスタムコードを持つモデルを使用できます：`,We,bl,Re,Il,gt="コミットハッシュを「revision」として渡すことも強く推奨されています。これにより、モデルの作者がコードを悪意のある新しい行で更新しなかったことを確認できます（モデルの作者を完全に信頼している場合を除きます）。",Xe,_l,Ge,Zl,At="モデルリポジトリのコミット履歴をブラウジングする際には、任意のコミットのコミットハッシュを簡単にコピーできるボタンがあります。",xe,hl,Ve,gl,$t=`🤗 Transformersを拡張するライブラリを作成している場合、独自のモデルを含めるために自動クラスを拡張したい場合があります。
これはコードをHubにプッシュすることとは異なり、ユーザーはカスタムモデルを取得するためにあなたのライブラリをインポートする必要があります
（Hubからモデルコードを自動的にダウンロードするのとは対照的です）。`,Ye,Al,kt=`構成に既存のモデルタイプと異なる <code>model_type</code> 属性がある限り、またあなたのモデルクラスが適切な <code>config_class</code> 属性を持っている限り、
次のようにそれらを自動クラスに追加できます：`,Qe,$l,Ee,kl,Nt=`注意: <code>AutoConfig</code> にカスタム設定を登録する際の最初の引数は、カスタム設定の <code>model_type</code> と一致する必要があります。
また、任意の自動モデルクラスにカスタムモデルを登録する際の最初の引数は、それらのモデルの <code>config_class</code> と一致する必要があります。`,He,vl,ze;return I=new Nl({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),g=new Nl({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),x=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Y=new Nl({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Fe({props:{$$slots:{default:[Ht]},$$scope:{ctx:f}}}),q=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Fe({props:{warning:!0,$$slots:{default:[zt]},$$scope:{ctx:f}}}),sl=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Fe({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:f}}}),il=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ol=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),rl=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),dl=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),wl=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),jl=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ul=new Nl({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),bl=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_l=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),$l=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){o=M("meta"),j=n(),w=M("p"),U=n(),y(I.$$.fragment),Bl=n(),_=M("p"),_.textContent=Le,Wl=n(),Z=M("p"),Z.textContent=Pe,Rl=n(),h=M("p"),h.innerHTML=qe,Xl=n(),y(g.$$.fragment),Gl=n(),A=M("p"),A.innerHTML=De,xl=n(),$=M("p"),$.textContent=Ke,Vl=n(),y(k.$$.fragment),Yl=n(),N=M("p"),N.textContent=Oe,Ql=n(),v=M("ul"),v.innerHTML=lt,El=n(),B=M("p"),B.innerHTML=et,Hl=n(),W=M("p"),W.innerHTML=tt,zl=n(),R=M("p"),R.textContent=st,Fl=n(),y(X.$$.fragment),Sl=n(),G=M("p"),G.innerHTML=nt,Ll=n(),y(x.$$.fragment),Pl=n(),V=M("p"),V.innerHTML=at,ql=n(),y(Y.$$.fragment),Dl=n(),Q=M("p"),Q.innerHTML=Mt,Kl=n(),E=M("p"),E.innerHTML=it,Ol=n(),y(H.$$.fragment),le=n(),z=M("p"),z.textContent=pt,ee=n(),y(F.$$.fragment),te=n(),S=M("p"),S.innerHTML=ot,se=n(),y(u.$$.fragment),ne=n(),L=M("p"),L.innerHTML=yt,ae=n(),P=M("p"),P.textContent=mt,Me=n(),y(q.$$.fragment),ie=n(),D=M("p"),D.innerHTML=rt,pe=n(),K=M("p"),K.textContent=ct,oe=n(),y(O.$$.fragment),ye=n(),ll=M("p"),ll.innerHTML=dt,me=n(),y(el.$$.fragment),re=n(),y(C.$$.fragment),ce=n(),tl=M("p"),tl.innerHTML=Jt,de=n(),y(sl.$$.fragment),Je=n(),nl=M("p"),nl.innerHTML=wt,we=n(),y(b.$$.fragment),Te=n(),al=M("p"),al.textContent=Tt,je=n(),Ml=M("p"),Ml.textContent=jt,Ue=n(),y(il.$$.fragment),fe=n(),pl=M("p"),pl.innerHTML=Ut,ue=n(),y(ol.$$.fragment),Ce=n(),yl=M("p"),yl.innerHTML=ft,be=n(),ml=M("p"),ml.textContent=ut,Ie=n(),y(rl.$$.fragment),_e=n(),cl=M("p"),cl.textContent=Ct,Ze=n(),y(dl.$$.fragment),he=n(),Jl=M("p"),Jl.textContent=bt,ge=n(),y(wl.$$.fragment),Ae=n(),Tl=M("p"),Tl.textContent=It,$e=n(),y(jl.$$.fragment),ke=n(),Ul=M("p"),Ul.innerHTML=_t,Ne=n(),fl=M("p"),fl.innerHTML=Zt,ve=n(),y(ul.$$.fragment),Be=n(),Cl=M("p"),Cl.innerHTML=ht,We=n(),y(bl.$$.fragment),Re=n(),Il=M("p"),Il.textContent=gt,Xe=n(),y(_l.$$.fragment),Ge=n(),Zl=M("p"),Zl.textContent=At,xe=n(),y(hl.$$.fragment),Ve=n(),gl=M("p"),gl.textContent=$t,Ye=n(),Al=M("p"),Al.innerHTML=kt,Qe=n(),y($l.$$.fragment),Ee=n(),kl=M("p"),kl.innerHTML=Nt,He=n(),vl=M("p"),this.h()},l(l){const e=Qt("svelte-u9bgzb",document.head);o=i(e,"META",{name:!0,content:!0}),e.forEach(t),j=a(l),w=i(l,"P",{}),Rt(w).forEach(t),U=a(l),m(I.$$.fragment,l),Bl=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-gxna3m"&&(_.textContent=Le),Wl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1nn0sjo"&&(Z.textContent=Pe),Rl=a(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-16k8f51"&&(h.innerHTML=qe),Xl=a(l),m(g.$$.fragment,l),Gl=a(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bwvin"&&(A.innerHTML=De),xl=a(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1q4nzi3"&&($.textContent=Ke),Vl=a(l),m(k.$$.fragment,l),Yl=a(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1xagbsn"&&(N.textContent=Oe),Ql=a(l),v=i(l,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-18ieeo"&&(v.innerHTML=lt),El=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1hhagdn"&&(B.innerHTML=et),Hl=a(l),W=i(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-u1g66p"&&(W.innerHTML=tt),zl=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1cqw2yw"&&(R.textContent=st),Fl=a(l),m(X.$$.fragment,l),Sl=a(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-j8wp82"&&(G.innerHTML=nt),Ll=a(l),m(x.$$.fragment,l),Pl=a(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1c3fy0p"&&(V.innerHTML=at),ql=a(l),m(Y.$$.fragment,l),Dl=a(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-83t4gv"&&(Q.innerHTML=Mt),Kl=a(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-rnqflg"&&(E.innerHTML=it),Ol=a(l),m(H.$$.fragment,l),le=a(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xqb496"&&(z.textContent=pt),ee=a(l),m(F.$$.fragment,l),te=a(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1gy8gfa"&&(S.innerHTML=ot),se=a(l),m(u.$$.fragment,l),ne=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1dsipd7"&&(L.innerHTML=yt),ae=a(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-c12zx8"&&(P.textContent=mt),Me=a(l),m(q.$$.fragment,l),ie=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-cv9gkh"&&(D.innerHTML=rt),pe=a(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ysoenl"&&(K.textContent=ct),oe=a(l),m(O.$$.fragment,l),ye=a(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-jchtss"&&(ll.innerHTML=dt),me=a(l),m(el.$$.fragment,l),re=a(l),m(C.$$.fragment,l),ce=a(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-12w8qw2"&&(tl.innerHTML=Jt),de=a(l),m(sl.$$.fragment,l),Je=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-161l0tk"&&(nl.innerHTML=wt),we=a(l),m(b.$$.fragment,l),Te=a(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1sofoh7"&&(al.textContent=Tt),je=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-10ja7ra"&&(Ml.textContent=jt),Ue=a(l),m(il.$$.fragment,l),fe=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-14w73fp"&&(pl.innerHTML=Ut),ue=a(l),m(ol.$$.fragment,l),Ce=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1gzi3ms"&&(yl.innerHTML=ft),be=a(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-x4hehz"&&(ml.textContent=ut),Ie=a(l),m(rl.$$.fragment,l),_e=a(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-4gjqmb"&&(cl.textContent=Ct),Ze=a(l),m(dl.$$.fragment,l),he=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-170hls0"&&(Jl.textContent=bt),ge=a(l),m(wl.$$.fragment,l),Ae=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-j85q6g"&&(Tl.textContent=It),$e=a(l),m(jl.$$.fragment,l),ke=a(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-1v5wui"&&(Ul.innerHTML=_t),Ne=a(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-1r595oo"&&(fl.innerHTML=Zt),ve=a(l),m(ul.$$.fragment,l),Be=a(l),Cl=i(l,"P",{"data-svelte-h":!0}),p(Cl)!=="svelte-1rhh9p5"&&(Cl.innerHTML=ht),We=a(l),m(bl.$$.fragment,l),Re=a(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-6ln3mo"&&(Il.textContent=gt),Xe=a(l),m(_l.$$.fragment,l),Ge=a(l),Zl=i(l,"P",{"data-svelte-h":!0}),p(Zl)!=="svelte-1mlo6re"&&(Zl.textContent=At),xe=a(l),m(hl.$$.fragment,l),Ve=a(l),gl=i(l,"P",{"data-svelte-h":!0}),p(gl)!=="svelte-1dtzfm7"&&(gl.textContent=$t),Ye=a(l),Al=i(l,"P",{"data-svelte-h":!0}),p(Al)!=="svelte-1xrka00"&&(Al.innerHTML=kt),Qe=a(l),m($l.$$.fragment,l),Ee=a(l),kl=i(l,"P",{"data-svelte-h":!0}),p(kl)!=="svelte-1eri869"&&(kl.innerHTML=Nt),He=a(l),vl=i(l,"P",{}),Rt(vl).forEach(t),this.h()},h(){Xt(o,"name","hf:doc:metadata"),Xt(o,"content",Lt)},m(l,e){Et(document.head,o),s(l,j,e),s(l,w,e),s(l,U,e),r(I,l,e),s(l,Bl,e),s(l,_,e),s(l,Wl,e),s(l,Z,e),s(l,Rl,e),s(l,h,e),s(l,Xl,e),r(g,l,e),s(l,Gl,e),s(l,A,e),s(l,xl,e),s(l,$,e),s(l,Vl,e),r(k,l,e),s(l,Yl,e),s(l,N,e),s(l,Ql,e),s(l,v,e),s(l,El,e),s(l,B,e),s(l,Hl,e),s(l,W,e),s(l,zl,e),s(l,R,e),s(l,Fl,e),r(X,l,e),s(l,Sl,e),s(l,G,e),s(l,Ll,e),r(x,l,e),s(l,Pl,e),s(l,V,e),s(l,ql,e),r(Y,l,e),s(l,Dl,e),s(l,Q,e),s(l,Kl,e),s(l,E,e),s(l,Ol,e),r(H,l,e),s(l,le,e),s(l,z,e),s(l,ee,e),r(F,l,e),s(l,te,e),s(l,S,e),s(l,se,e),r(u,l,e),s(l,ne,e),s(l,L,e),s(l,ae,e),s(l,P,e),s(l,Me,e),r(q,l,e),s(l,ie,e),s(l,D,e),s(l,pe,e),s(l,K,e),s(l,oe,e),r(O,l,e),s(l,ye,e),s(l,ll,e),s(l,me,e),r(el,l,e),s(l,re,e),r(C,l,e),s(l,ce,e),s(l,tl,e),s(l,de,e),r(sl,l,e),s(l,Je,e),s(l,nl,e),s(l,we,e),r(b,l,e),s(l,Te,e),s(l,al,e),s(l,je,e),s(l,Ml,e),s(l,Ue,e),r(il,l,e),s(l,fe,e),s(l,pl,e),s(l,ue,e),r(ol,l,e),s(l,Ce,e),s(l,yl,e),s(l,be,e),s(l,ml,e),s(l,Ie,e),r(rl,l,e),s(l,_e,e),s(l,cl,e),s(l,Ze,e),r(dl,l,e),s(l,he,e),s(l,Jl,e),s(l,ge,e),r(wl,l,e),s(l,Ae,e),s(l,Tl,e),s(l,$e,e),r(jl,l,e),s(l,ke,e),s(l,Ul,e),s(l,Ne,e),s(l,fl,e),s(l,ve,e),r(ul,l,e),s(l,Be,e),s(l,Cl,e),s(l,We,e),r(bl,l,e),s(l,Re,e),s(l,Il,e),s(l,Xe,e),r(_l,l,e),s(l,Ge,e),s(l,Zl,e),s(l,xe,e),r(hl,l,e),s(l,Ve,e),s(l,gl,e),s(l,Ye,e),s(l,Al,e),s(l,Qe,e),r($l,l,e),s(l,Ee,e),s(l,kl,e),s(l,He,e),s(l,vl,e),ze=!0},p(l,[e]){const vt={};e&2&&(vt.$$scope={dirty:e,ctx:l}),u.$set(vt);const Bt={};e&2&&(Bt.$$scope={dirty:e,ctx:l}),C.$set(Bt);const Wt={};e&2&&(Wt.$$scope={dirty:e,ctx:l}),b.$set(Wt)},i(l){ze||(c(I.$$.fragment,l),c(g.$$.fragment,l),c(k.$$.fragment,l),c(X.$$.fragment,l),c(x.$$.fragment,l),c(Y.$$.fragment,l),c(H.$$.fragment,l),c(F.$$.fragment,l),c(u.$$.fragment,l),c(q.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(C.$$.fragment,l),c(sl.$$.fragment,l),c(b.$$.fragment,l),c(il.$$.fragment,l),c(ol.$$.fragment,l),c(rl.$$.fragment,l),c(dl.$$.fragment,l),c(wl.$$.fragment,l),c(jl.$$.fragment,l),c(ul.$$.fragment,l),c(bl.$$.fragment,l),c(_l.$$.fragment,l),c(hl.$$.fragment,l),c($l.$$.fragment,l),ze=!0)},o(l){d(I.$$.fragment,l),d(g.$$.fragment,l),d(k.$$.fragment,l),d(X.$$.fragment,l),d(x.$$.fragment,l),d(Y.$$.fragment,l),d(H.$$.fragment,l),d(F.$$.fragment,l),d(u.$$.fragment,l),d(q.$$.fragment,l),d(O.$$.fragment,l),d(el.$$.fragment,l),d(C.$$.fragment,l),d(sl.$$.fragment,l),d(b.$$.fragment,l),d(il.$$.fragment,l),d(ol.$$.fragment,l),d(rl.$$.fragment,l),d(dl.$$.fragment,l),d(wl.$$.fragment,l),d(jl.$$.fragment,l),d(ul.$$.fragment,l),d(bl.$$.fragment,l),d(_l.$$.fragment,l),d(hl.$$.fragment,l),d($l.$$.fragment,l),ze=!1},d(l){l&&(t(j),t(w),t(U),t(Bl),t(_),t(Wl),t(Z),t(Rl),t(h),t(Xl),t(Gl),t(A),t(xl),t($),t(Vl),t(Yl),t(N),t(Ql),t(v),t(El),t(B),t(Hl),t(W),t(zl),t(R),t(Fl),t(Sl),t(G),t(Ll),t(Pl),t(V),t(ql),t(Dl),t(Q),t(Kl),t(E),t(Ol),t(le),t(z),t(ee),t(te),t(S),t(se),t(ne),t(L),t(ae),t(P),t(Me),t(ie),t(D),t(pe),t(K),t(oe),t(ye),t(ll),t(me),t(re),t(ce),t(tl),t(de),t(Je),t(nl),t(we),t(Te),t(al),t(je),t(Ml),t(Ue),t(fe),t(pl),t(ue),t(Ce),t(yl),t(be),t(ml),t(Ie),t(_e),t(cl),t(Ze),t(he),t(Jl),t(ge),t(Ae),t(Tl),t($e),t(ke),t(Ul),t(Ne),t(fl),t(ve),t(Be),t(Cl),t(We),t(Re),t(Il),t(Xe),t(Ge),t(Zl),t(xe),t(Ve),t(gl),t(Ye),t(Al),t(Qe),t(Ee),t(kl),t(He),t(vl)),t(o),J(I,l),J(g,l),J(k,l),J(X,l),J(x,l),J(Y,l),J(H,l),J(F,l),J(u,l),J(q,l),J(O,l),J(el,l),J(C,l),J(sl,l),J(b,l),J(il,l),J(ol,l),J(rl,l),J(dl,l),J(wl,l),J(jl,l),J(ul,l),J(bl,l),J(_l,l),J(hl,l),J($l,l)}}}const Lt='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Pt(f){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Vt{constructor(o){super(),Yt(this,o,Pt,St,Gt,{})}}export{es as component};
