import{s as ml,o as pl,n as Ml}from"../chunks/scheduler.cc52f4b9.js";import{S as dl,i as yl,e as i,s,c as r,h as ul,a as o,d as l,b as a,f as ol,g as m,j as u,k as rl,l as hl,m as n,n as p,t as M,o as d,p as y}from"../chunks/index.5b747fde.js";import{T as cl}from"../chunks/Tip.f0925d57.js";import{C as wl,H as c,E as fl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{C as w}from"../chunks/CodeBlock.665bfc37.js";import{C as Jl}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Tl(Ie){let h,T='This exercise was written by LLM fine-tuning expert <a href="https://huggingface.co/mlabonne" rel="nofollow">@mlabonne</a>.';return{c(){h=i("p"),h.innerHTML=T},l(f){h=o(f,"P",{"data-svelte-h":!0}),u(h)!=="svelte-1hjy8dv"&&(h.innerHTML=T)},m(f,je){n(f,h,je)},p:Ml,d(f){f&&l(h)}}}function gl(Ie){let h,T,f,je,g,Ce,b,Ge,U,Be,j,Wt="Now that you’ve seen the theory, let’s put it into practice! In this exercise, you’ll fine-tune a model with GRPO.",Ze,J,ve,$,We,I,xt="First, let’s install the dependencies for this exercise.",xe,C,Re,G,Rt="Now we’ll import the necessary libraries.",Xe,B,Fe,Z,ke,v,Xt="Weights & Biases is a tool for logging and monitoring your experiments. We’ll use it to log our fine-tuning process.",_e,W,Qe,x,Ft="You can do this exercise without logging in to Weights & Biases, but it’s recommended to do so to track your experiments and interpret the results.",Ve,R,Ye,X,kt='Now, let’s load the dataset. In this case, we’ll use the <a href="https://huggingface.co/datasets/mlabonne/smoltldr" rel="nofollow"><code>mlabonne/smoltldr</code></a> dataset, which contains a list of short stories.',ze,F,Ee,k,Ne,_,_t="Now, let’s load the model.",He,Q,Qt='For this exercise, we’ll use the <a href="https://huggingface.co/HuggingFaceTB/SmolLM2-135M" rel="nofollow"><code>SmolLM2-135M</code></a> model.',Se,V,Vt='This is a small 135M parameter model that runs on limited hardware. This makes the model ideal for learning, but it’s not the most powerful model out there. If you have access to more powerful hardware, you can try to fine-tune a larger model like <a href="https://huggingface.co/HuggingFaceTB/SmolLM2-1.7B" rel="nofollow"><code>SmolLM2-1.7B</code></a>.',Ae,Y,qe,z,Le,E,Yt="Now, let’s load the LoRA configuration. We’ll take advantage of LoRA to reduce the number of trainable parameters, and in turn the memory footprint we need to fine-tune the model.",Pe,N,zt='If you’re not familiar with LoRA, you can read more about it in <a href="https://huggingface.co/learn/course/en/chapter11/3" rel="nofollow">Chapter 11</a>.',De,H,Oe,S,Ke,A,et,q,Et="As mentioned in the previous section, GRPO can use any reward function to improve the model. In this case, we’ll use a simple reward function that encourages the model to generate text that is 50 tokens long.",tt,L,lt,P,nt,D,Nt="Now, let’s define the training arguments. We’ll use the <code>GRPOConfig</code> class to define the training arguments in a typical <code>transformers</code> style.",st,O,Ht='If this is the first time you’re defining training arguments, you can check the <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#trainingarguments" rel="nofollow">TrainingArguments</a> class for more information, or <a href="https://huggingface.co/learn/course/en/chapter2/1" rel="nofollow">Chapter 2</a> for a detailed introduction.',at,K,it,ee,St="Now, we can initialize the trainer with model, dataset, and training arguments and start training.",ot,te,rt,le,At="Training takes around 1 hour on a single A10G GPU which is available on Google Colab or via Hugging Face Spaces.",mt,ne,pt,se,qt="If we set the <code>push_to_hub</code> argument to <code>True</code> and the <code>model_id</code> argument to a valid model name, the model will be pushed to the Hugging Face Hub whilst we’re training. This is useful if you want to start vibe testing the model straight away!",Mt,ae,dt,ie,Lt="<code>GRPOTrainer</code> logs the reward from your reward function, the loss, and a range of other metrics.",yt,oe,Pt="We will focus on the reward from the reward function and the loss.",ut,re,Dt="As you can see, the reward from the reward function moves closer to 0 as the model learns. This is a good sign that the model is learning to generate text of the correct length.",ht,me,Ot='<img src="https://huggingface.co/reasoning-course/images/resolve/main/grpo/13.png" alt="Reward from reward function"/>',ct,pe,Kt="You might notice that the loss starts at zero and then increases during training, which may seem counterintuitive. This behavior is expected in GRPO and is directly related to the mathematical formulation of the algorithm. The loss in GRPO is proportional to the KL divergence (the cap relative to original policy) . As training progresses, the model learns to generate text that better matches the reward function, causing it to diverge more from its initial policy. This increasing divergence is reflected in the rising loss value, which actually indicates that the model is successfully adapting to optimize for the reward function.",wt,Me,el='<img src="https://huggingface.co/reasoning-course/images/resolve/main/grpo/14.png" alt="Loss"/>',ft,de,Jt,ye,tl="Let’s share the model with the community!",Tt,ue,gt,he,bt,ce,ll="🎉 You’ve successfully fine-tuned a model with GRPO! Now, let’s generate some text with the model.",Ut,we,nl="First, we’ll define a really long document!",jt,fe,$t,Je,sl="Now, we can generate text with the model.",It,Te,Ct,ge,Gt,be,al="In this chapter, we’ve seen how to fine-tune a model with GRPO. We’ve also seen how to interpret the training results and generate text with the model.",Bt,Ue,Zt,$e,vt;return g=new Jl({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/course/en/chapter12/grpo_finetune.ipynb"}]}}),b=new wl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new c({props:{title:"Practical Exercise: Fine-tune a model with GRPO",local:"practical-exercise-fine-tune-a-model-with-grpo",headingTag:"h1"}}),J=new cl({props:{$$slots:{default:[Tl]},$$scope:{ctx:Ie}}}),$=new c({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),C=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcXFxJTIwZGF0YXNldHMlM0QlM0QzLjIuMCUyMHRyYW5zZm9ybWVycyUzRCUzRDQuNDcuMSUyMHRybCUzRCUzRDAuMTQuMCUyMHBlZnQlM0QlM0QwLjE0LjAlMjBhY2NlbGVyYXRlJTNEJTNEMS4yLjElMjBiaXRzYW5kYnl0ZXMlM0QlM0QwLjQ1LjIlMjB3YW5kYiUzRCUzRDAuMTkuNyUyMC0tcHJvZ3Jlc3MtYmFyJTIwb2ZmJTBBIXBpcCUyMGluc3RhbGwlMjAtcXFxJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9uJTIwLS1wcm9ncmVzcy1iYXIlMjBvZmY=",highlighted:`!pip install -qqq datasets==3.2.0 transformers==4.47.1 trl==0.14.0 peft==0.14.0 accelerate==1.2.1 bitsandbytes==0.45.2 wandb==0.19.7 --progress-bar off
!pip install -qqq flash-attn --no-build-isolation --progress-bar off`,wrap:!1}}),B=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwR1JQT0NvbmZpZyUyQyUyMEdSUE9UcmFpbmVy",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig, GRPOTrainer`,wrap:!1}}),Z=new c({props:{title:"Import and log in to Weights & Biases",local:"import-and-log-in-to-weights--biases",headingTag:"h2"}}),W=new w({props:{code:"aW1wb3J0JTIwd2FuZGIlMEElMEF3YW5kYi5sb2dpbigp",highlighted:`<span class="hljs-keyword">import</span> wandb

wandb.login()`,wrap:!1}}),R=new c({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),F=new w({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJtbGFib25uZSUyRnNtb2x0bGRyJTIyKSUwQXByaW50KGRhdGFzZXQp",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;mlabonne/smoltldr&quot;</span>)
<span class="hljs-built_in">print</span>(dataset)`,wrap:!1}}),k=new c({props:{title:"Load model",local:"load-model",headingTag:"h2"}}),Y=new w({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNLTEzNU0tSW5zdHJ1Y3QlMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKQ==",highlighted:`model_id = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)
tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),z=new c({props:{title:"Load LoRA",local:"load-lora",headingTag:"h2"}}),H=new w({props:{code:"JTIzJTIwTG9hZCUyMExvUkElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlMjJhbGwtbGluZWFyJTIyJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFwcmludChtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-comment"># Load LoRA</span>
lora_config = LoraConfig(
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
)
model = get_peft_model(model, lora_config)
<span class="hljs-built_in">print</span>(model.print_trainable_parameters())`,wrap:!1}}),S=new w({props:{code:"VG90YWwlMjB0cmFpbmFibGUlMjBwYXJhbWV0ZXJzJTNBJTIwMTM1TQ==",highlighted:"Total trainable parameters: 135M",wrap:!1}}),A=new c({props:{title:"Define the reward function",local:"define-the-reward-function",headingTag:"h2"}}),L=new w({props:{code:"JTIzJTIwUmV3YXJkJTIwZnVuY3Rpb24lMEFpZGVhbF9sZW5ndGglMjAlM0QlMjA1MCUwQSUwQSUwQWRlZiUyMHJld2FyZF9sZW4oY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUItYWJzKGlkZWFsX2xlbmd0aCUyMC0lMjBsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQ=",highlighted:`<span class="hljs-comment"># Reward function</span>
ideal_length = <span class="hljs-number">50</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_len</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [-<span class="hljs-built_in">abs</span>(ideal_length - <span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),P=new c({props:{title:"Define the training arguments",local:"define-the-training-arguments",headingTag:"h2"}}),K=new w({props:{code:"JTIzJTIwVHJhaW5pbmclMjBhcmd1bWVudHMlMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwR1JQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyR1JQTyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBtYXhfcHJvbXB0X2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9jb21wbGV0aW9uX2xlbmd0aCUzRDk2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2dlbmVyYXRpb25zJTNEOCUyQyUwQSUyMCUyMCUyMCUyMG9wdGltJTNEJTIyYWRhbXdfOGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QxJTJDJTBBJTIwJTIwJTIwJTIwYmYxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ3YW5kYiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDElMkMlMEEp",highlighted:`<span class="hljs-comment"># Training arguments</span>
training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;GRPO&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    max_prompt_length=<span class="hljs-number">512</span>,
    max_completion_length=<span class="hljs-number">96</span>,
    num_generations=<span class="hljs-number">8</span>,
    optim=<span class="hljs-string">&quot;adamw_8bit&quot;</span>,
    num_train_epochs=<span class="hljs-number">1</span>,
    bf16=<span class="hljs-literal">True</span>,
    report_to=[<span class="hljs-string">&quot;wandb&quot;</span>],
    remove_unused_columns=<span class="hljs-literal">False</span>,
    logging_steps=<span class="hljs-number">1</span>,
)`,wrap:!1}}),te=new w({props:{code:"JTIzJTIwVHJhaW5lciUwQXRyYWluZXIlMjAlM0QlMjBHUlBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcmV3YXJkX2Z1bmNzJTNEJTVCcmV3YXJkX2xlbiU1RCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSklMEElMEElMjMlMjBUcmFpbiUyMG1vZGVsJTBBd2FuZGIuaW5pdChwcm9qZWN0JTNEJTIyR1JQTyUyMiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># Trainer</span>
trainer = GRPOTrainer(
    model=model,
    reward_funcs=[reward_len],
    args=training_args,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
)

<span class="hljs-comment"># Train model</span>
wandb.init(project=<span class="hljs-string">&quot;GRPO&quot;</span>)
trainer.train()`,wrap:!1}}),ne=new c({props:{title:"Push the model to the Hub during training",local:"push-the-model-to-the-hub-during-training",headingTag:"h2"}}),ae=new c({props:{title:"Interpret training results",local:"interpret-training-results",headingTag:"h2"}}),de=new c({props:{title:"Save and publish the model",local:"save-and-publish-the-model",headingTag:"h2"}}),ue=new w({props:{code:"bWVyZ2VkX21vZGVsJTIwJTNEJTIwdHJhaW5lci5tb2RlbC5tZXJnZV9hbmRfdW5sb2FkKCklMEFtZXJnZWRfbW9kZWwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwJTIyU21vbEdSUE8tMTM1TSUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSUyQyUyMHRhZ3MlM0QlNUIlMjJHUlBPJTIyJTJDJTIwJTIyUmVhc29uaW5nLUNvdXJzZSUyMiU1RCUwQSk=",highlighted:`merged_model = trainer.model.merge_and_unload()
merged_model.push_to_hub(
    <span class="hljs-string">&quot;SmolGRPO-135M&quot;</span>, private=<span class="hljs-literal">False</span>, tags=[<span class="hljs-string">&quot;GRPO&quot;</span>, <span class="hljs-string">&quot;Reasoning-Course&quot;</span>]
)`,wrap:!1}}),he=new c({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),fe=new w({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;
# A long document about the Cat

The cat (Felis catus), also referred to as the domestic cat or house cat, is a small 
domesticated carnivorous mammal. It is the only domesticated species of the family Felidae.
Advances in archaeology and genetics have shown that the domestication of the cat occurred
in the Near East around 7500 BC. It is commonly kept as a pet and farm cat, but also ranges
freely as a feral cat avoiding human contact. It is valued by humans for companionship and
its ability to kill vermin. Its retractable claws are adapted to killing small prey species
such as mice and rats. It has a strong, flexible body, quick reflexes, and sharp teeth,
and its night vision and sense of smell are well developed. It is a social species,
but a solitary hunter and a crepuscular predator. Cat communication includes
vocalizations—including meowing, purring, trilling, hissing, growling, and grunting—as
well as body language. It can hear sounds too faint or too high in frequency for human ears,
such as those made by small mammals. It secretes and perceives pheromones.
&quot;&quot;&quot;</span>

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
]`,wrap:!1}}),Te=new w({props:{code:"JTIzJTIwR2VuZXJhdGUlMjB0ZXh0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJTbW9sR1JQTy0xMzVNJTIyKSUwQSUwQSUyMyUyMyUyME9yJTIwdXNlJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMjB3ZSUyMGRlZmluZWQlMjBlYXJsaWVyJTBBJTIzJTIwZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDI1NiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbl9wJTIyJTNBJTIwMC4xJTJDJTBBJTdEJTBBJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBnZW5lcmF0b3IobWVzc2FnZXMlMkMlMjBnZW5lcmF0ZV9rd2FyZ3MlM0RnZW5lcmF0ZV9rd2FyZ3MpJTBBJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQp",highlighted:`<span class="hljs-comment"># Generate text</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;SmolGRPO-135M&quot;</span>)

<span class="hljs-comment">## Or use the model and tokenizer we defined earlier</span>
<span class="hljs-comment"># generator = pipeline(&quot;text-generation&quot;, model=model, tokenizer=tokenizer)</span>

generate_kwargs = {
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.5</span>,
    <span class="hljs-string">&quot;min_p&quot;</span>: <span class="hljs-number">0.1</span>,
}

generated_text = generator(messages, generate_kwargs=generate_kwargs)

<span class="hljs-built_in">print</span>(generated_text)`,wrap:!1}}),ge=new c({props:{title:"Conclusion",local:"conclusion",headingTag:"h1"}}),Ue=new fl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/5.mdx"}}),{c(){h=i("meta"),T=s(),f=i("p"),je=s(),r(g.$$.fragment),Ce=s(),r(b.$$.fragment),Ge=s(),r(U.$$.fragment),Be=s(),j=i("p"),j.textContent=Wt,Ze=s(),r(J.$$.fragment),ve=s(),r($.$$.fragment),We=s(),I=i("p"),I.textContent=xt,xe=s(),r(C.$$.fragment),Re=s(),G=i("p"),G.textContent=Rt,Xe=s(),r(B.$$.fragment),Fe=s(),r(Z.$$.fragment),ke=s(),v=i("p"),v.textContent=Xt,_e=s(),r(W.$$.fragment),Qe=s(),x=i("p"),x.textContent=Ft,Ve=s(),r(R.$$.fragment),Ye=s(),X=i("p"),X.innerHTML=kt,ze=s(),r(F.$$.fragment),Ee=s(),r(k.$$.fragment),Ne=s(),_=i("p"),_.textContent=_t,He=s(),Q=i("p"),Q.innerHTML=Qt,Se=s(),V=i("p"),V.innerHTML=Vt,Ae=s(),r(Y.$$.fragment),qe=s(),r(z.$$.fragment),Le=s(),E=i("p"),E.textContent=Yt,Pe=s(),N=i("p"),N.innerHTML=zt,De=s(),r(H.$$.fragment),Oe=s(),r(S.$$.fragment),Ke=s(),r(A.$$.fragment),et=s(),q=i("p"),q.textContent=Et,tt=s(),r(L.$$.fragment),lt=s(),r(P.$$.fragment),nt=s(),D=i("p"),D.innerHTML=Nt,st=s(),O=i("p"),O.innerHTML=Ht,at=s(),r(K.$$.fragment),it=s(),ee=i("p"),ee.textContent=St,ot=s(),r(te.$$.fragment),rt=s(),le=i("p"),le.textContent=At,mt=s(),r(ne.$$.fragment),pt=s(),se=i("p"),se.innerHTML=qt,Mt=s(),r(ae.$$.fragment),dt=s(),ie=i("p"),ie.innerHTML=Lt,yt=s(),oe=i("p"),oe.textContent=Pt,ut=s(),re=i("p"),re.textContent=Dt,ht=s(),me=i("p"),me.innerHTML=Ot,ct=s(),pe=i("p"),pe.textContent=Kt,wt=s(),Me=i("p"),Me.innerHTML=el,ft=s(),r(de.$$.fragment),Jt=s(),ye=i("p"),ye.textContent=tl,Tt=s(),r(ue.$$.fragment),gt=s(),r(he.$$.fragment),bt=s(),ce=i("p"),ce.textContent=ll,Ut=s(),we=i("p"),we.textContent=nl,jt=s(),r(fe.$$.fragment),$t=s(),Je=i("p"),Je.textContent=sl,It=s(),r(Te.$$.fragment),Ct=s(),r(ge.$$.fragment),Gt=s(),be=i("p"),be.textContent=al,Bt=s(),r(Ue.$$.fragment),Zt=s(),$e=i("p"),this.h()},l(e){const t=ul("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),f=o(e,"P",{}),ol(f).forEach(l),je=a(e),m(g.$$.fragment,e),Ce=a(e),m(b.$$.fragment,e),Ge=a(e),m(U.$$.fragment,e),Be=a(e),j=o(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-cm5jhs"&&(j.textContent=Wt),Ze=a(e),m(J.$$.fragment,e),ve=a(e),m($.$$.fragment,e),We=a(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-ptnxo3"&&(I.textContent=xt),xe=a(e),m(C.$$.fragment,e),Re=a(e),G=o(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-12snwaz"&&(G.textContent=Rt),Xe=a(e),m(B.$$.fragment,e),Fe=a(e),m(Z.$$.fragment,e),ke=a(e),v=o(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1n1a8k6"&&(v.textContent=Xt),_e=a(e),m(W.$$.fragment,e),Qe=a(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1ew5fxu"&&(x.textContent=Ft),Ve=a(e),m(R.$$.fragment,e),Ye=a(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-26gya7"&&(X.innerHTML=kt),ze=a(e),m(F.$$.fragment,e),Ee=a(e),m(k.$$.fragment,e),Ne=a(e),_=o(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-121fjkj"&&(_.textContent=_t),He=a(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-12w23k"&&(Q.innerHTML=Qt),Se=a(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-31m4si"&&(V.innerHTML=Vt),Ae=a(e),m(Y.$$.fragment,e),qe=a(e),m(z.$$.fragment,e),Le=a(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1d01rwe"&&(E.textContent=Yt),Pe=a(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-zej957"&&(N.innerHTML=zt),De=a(e),m(H.$$.fragment,e),Oe=a(e),m(S.$$.fragment,e),Ke=a(e),m(A.$$.fragment,e),et=a(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-19qfksx"&&(q.textContent=Et),tt=a(e),m(L.$$.fragment,e),lt=a(e),m(P.$$.fragment,e),nt=a(e),D=o(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-yvl12o"&&(D.innerHTML=Nt),st=a(e),O=o(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1a9j2u8"&&(O.innerHTML=Ht),at=a(e),m(K.$$.fragment,e),it=a(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-djcfcf"&&(ee.textContent=St),ot=a(e),m(te.$$.fragment,e),rt=a(e),le=o(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1de2igi"&&(le.textContent=At),mt=a(e),m(ne.$$.fragment,e),pt=a(e),se=o(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1xii7zd"&&(se.innerHTML=qt),Mt=a(e),m(ae.$$.fragment,e),dt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-87il9y"&&(ie.innerHTML=Lt),yt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-eocx64"&&(oe.textContent=Pt),ut=a(e),re=o(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1qdyttt"&&(re.textContent=Dt),ht=a(e),me=o(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-nb9yq5"&&(me.innerHTML=Ot),ct=a(e),pe=o(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-10noxip"&&(pe.textContent=Kt),wt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1bbe9id"&&(Me.innerHTML=el),ft=a(e),m(de.$$.fragment,e),Jt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-wu0gyd"&&(ye.textContent=tl),Tt=a(e),m(ue.$$.fragment,e),gt=a(e),m(he.$$.fragment,e),bt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-u9gu30"&&(ce.textContent=ll),Ut=a(e),we=o(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1bqln8"&&(we.textContent=nl),jt=a(e),m(fe.$$.fragment,e),$t=a(e),Je=o(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-4yybog"&&(Je.textContent=sl),It=a(e),m(Te.$$.fragment,e),Ct=a(e),m(ge.$$.fragment,e),Gt=a(e),be=o(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1y8m2ev"&&(be.textContent=al),Bt=a(e),m(Ue.$$.fragment,e),Zt=a(e),$e=o(e,"P",{}),ol($e).forEach(l),this.h()},h(){rl(h,"name","hf:doc:metadata"),rl(h,"content",bl)},m(e,t){hl(document.head,h),n(e,T,t),n(e,f,t),n(e,je,t),p(g,e,t),n(e,Ce,t),p(b,e,t),n(e,Ge,t),p(U,e,t),n(e,Be,t),n(e,j,t),n(e,Ze,t),p(J,e,t),n(e,ve,t),p($,e,t),n(e,We,t),n(e,I,t),n(e,xe,t),p(C,e,t),n(e,Re,t),n(e,G,t),n(e,Xe,t),p(B,e,t),n(e,Fe,t),p(Z,e,t),n(e,ke,t),n(e,v,t),n(e,_e,t),p(W,e,t),n(e,Qe,t),n(e,x,t),n(e,Ve,t),p(R,e,t),n(e,Ye,t),n(e,X,t),n(e,ze,t),p(F,e,t),n(e,Ee,t),p(k,e,t),n(e,Ne,t),n(e,_,t),n(e,He,t),n(e,Q,t),n(e,Se,t),n(e,V,t),n(e,Ae,t),p(Y,e,t),n(e,qe,t),p(z,e,t),n(e,Le,t),n(e,E,t),n(e,Pe,t),n(e,N,t),n(e,De,t),p(H,e,t),n(e,Oe,t),p(S,e,t),n(e,Ke,t),p(A,e,t),n(e,et,t),n(e,q,t),n(e,tt,t),p(L,e,t),n(e,lt,t),p(P,e,t),n(e,nt,t),n(e,D,t),n(e,st,t),n(e,O,t),n(e,at,t),p(K,e,t),n(e,it,t),n(e,ee,t),n(e,ot,t),p(te,e,t),n(e,rt,t),n(e,le,t),n(e,mt,t),p(ne,e,t),n(e,pt,t),n(e,se,t),n(e,Mt,t),p(ae,e,t),n(e,dt,t),n(e,ie,t),n(e,yt,t),n(e,oe,t),n(e,ut,t),n(e,re,t),n(e,ht,t),n(e,me,t),n(e,ct,t),n(e,pe,t),n(e,wt,t),n(e,Me,t),n(e,ft,t),p(de,e,t),n(e,Jt,t),n(e,ye,t),n(e,Tt,t),p(ue,e,t),n(e,gt,t),p(he,e,t),n(e,bt,t),n(e,ce,t),n(e,Ut,t),n(e,we,t),n(e,jt,t),p(fe,e,t),n(e,$t,t),n(e,Je,t),n(e,It,t),p(Te,e,t),n(e,Ct,t),p(ge,e,t),n(e,Gt,t),n(e,be,t),n(e,Bt,t),p(Ue,e,t),n(e,Zt,t),n(e,$e,t),vt=!0},p(e,[t]){const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),J.$set(il)},i(e){vt||(M(g.$$.fragment,e),M(b.$$.fragment,e),M(U.$$.fragment,e),M(J.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(B.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(F.$$.fragment,e),M(k.$$.fragment,e),M(Y.$$.fragment,e),M(z.$$.fragment,e),M(H.$$.fragment,e),M(S.$$.fragment,e),M(A.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(Te.$$.fragment,e),M(ge.$$.fragment,e),M(Ue.$$.fragment,e),vt=!0)},o(e){d(g.$$.fragment,e),d(b.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d($.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(k.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),d(ge.$$.fragment,e),d(Ue.$$.fragment,e),vt=!1},d(e){e&&(l(T),l(f),l(je),l(Ce),l(Ge),l(Be),l(j),l(Ze),l(ve),l(We),l(I),l(xe),l(Re),l(G),l(Xe),l(Fe),l(ke),l(v),l(_e),l(Qe),l(x),l(Ve),l(Ye),l(X),l(ze),l(Ee),l(Ne),l(_),l(He),l(Q),l(Se),l(V),l(Ae),l(qe),l(Le),l(E),l(Pe),l(N),l(De),l(Oe),l(Ke),l(et),l(q),l(tt),l(lt),l(nt),l(D),l(st),l(O),l(at),l(it),l(ee),l(ot),l(rt),l(le),l(mt),l(pt),l(se),l(Mt),l(dt),l(ie),l(yt),l(oe),l(ut),l(re),l(ht),l(me),l(ct),l(pe),l(wt),l(Me),l(ft),l(Jt),l(ye),l(Tt),l(gt),l(bt),l(ce),l(Ut),l(we),l(jt),l($t),l(Je),l(It),l(Ct),l(Gt),l(be),l(Bt),l(Zt),l($e)),l(h),y(g,e),y(b,e),y(U,e),y(J,e),y($,e),y(C,e),y(B,e),y(Z,e),y(W,e),y(R,e),y(F,e),y(k,e),y(Y,e),y(z,e),y(H,e),y(S,e),y(A,e),y(L,e),y(P,e),y(K,e),y(te,e),y(ne,e),y(ae,e),y(de,e),y(ue,e),y(he,e),y(fe,e),y(Te,e),y(ge,e),y(Ue,e)}}}const bl='{"title":"Practical Exercise: Fine-tune a model with GRPO","local":"practical-exercise-fine-tune-a-model-with-grpo","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Import and log in to Weights & Biases","local":"import-and-log-in-to-weights--biases","sections":[],"depth":2},{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Load model","local":"load-model","sections":[],"depth":2},{"title":"Load LoRA","local":"load-lora","sections":[],"depth":2},{"title":"Define the reward function","local":"define-the-reward-function","sections":[],"depth":2},{"title":"Define the training arguments","local":"define-the-training-arguments","sections":[],"depth":2},{"title":"Push the model to the Hub during training","local":"push-the-model-to-the-hub-during-training","sections":[],"depth":2},{"title":"Interpret training results","local":"interpret-training-results","sections":[],"depth":2},{"title":"Save and publish the model","local":"save-and-publish-the-model","sections":[],"depth":2},{"title":"Generate text","local":"generate-text","sections":[],"depth":2}],"depth":1}';function Ul(Ie){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends dl{constructor(h){super(),yl(this,h,Ul,gl,ml,{})}}export{Zl as component};
