import{s as Ln,o as Nn,n as Qe}from"../chunks/scheduler.cc52f4b9.js";import{S as Pn,i as Sn,e as h,s as i,c as o,h as Dn,a as f,d as n,b as s,f as Vn,g as p,j as g,k as qn,l as Kn,m as a,n as c,t as d,o as u,p as m}from"../chunks/index.5b747fde.js";import{T as Ee}from"../chunks/Tip.f0925d57.js";import{C as On,H as J,E as ea}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as ta}from"../chunks/Youtube.8bb4154e.js";import{C as y}from"../chunks/CodeBlock.665bfc37.js";import{C as na}from"../chunks/CourseFloatingBanner.b33fcd79.js";import{Q as Ae}from"../chunks/Question.58d62cc7.js";import{F as aa}from"../chunks/FrameworkSwitchCourse.b3b657b3.js";function ia(M){let l,$='📚 <strong>Training Resources</strong>: Before diving into training, familiarize yourself with the comprehensive <a href="https://huggingface.co/docs/transformers/main/en/training" rel="nofollow">🤗 Transformers training guide</a> and explore practical examples in the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">fine-tuning cookbook</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-vqxqic"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function sa(M){let l,$='🚀 <strong>Advanced Configuration</strong>: For detailed information on all available training arguments and optimization strategies, check out the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments documentation</a> and the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">training configuration cookbook</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1ygyaam"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function la(M){let l,$='📖 <strong>Learn More</strong>: For comprehensive details on the Trainer class and its parameters, visit the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">Trainer API documentation</a> and explore advanced usage patterns in the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu" rel="nofollow">training cookbook recipes</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-9voy91"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function ra(M){let l,$='Learn about different evaluation metrics and strategies in the <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate documentation</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-q6q1ak"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function oa(M){let l,$='🎯 <strong>Performance Optimization</strong>: For more advanced training techniques including distributed training, memory optimization, and hardware-specific optimizations, explore the <a href="https://huggingface.co/docs/transformers/main/en/performance" rel="nofollow">🤗 Transformers performance guide</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-lxa5df"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function pa(M){let l,$='📝 <strong>More Examples</strong>: Check out the comprehensive collection of <a href="https://huggingface.co/docs/transformers/main/en/notebooks" rel="nofollow">🤗 Transformers notebooks</a>.';return{c(){l=h("p"),l.innerHTML=$},l(r){l=f(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1i8p502"&&(l.innerHTML=$)},m(r,w){a(r,l,w)},p:Qe,d(r){r&&n(l)}}}function ca(M){let l,$="💡 <strong>Key Takeaways:</strong>",r,w,b="<li>The <code>Trainer</code> API provides a high-level interface that handles most training complexity</li> <li>Use <code>processing_class</code> to specify your tokenizer for proper data handling</li> <li><code>TrainingArguments</code> controls all aspects of training: learning rate, batch size, evaluation strategy, and optimizations</li> <li><code>compute_metrics</code> enables custom evaluation metrics beyond just training loss</li> <li>Modern features like mixed precision (<code>fp16=True</code>) and gradient accumulation can significantly improve training efficiency</li>";return{c(){l=h("p"),l.innerHTML=$,r=i(),w=h("ul"),w.innerHTML=b},l(T){l=f(T,"P",{"data-svelte-h":!0}),g(l)!=="svelte-l314m0"&&(l.innerHTML=$),r=s(T),w=f(T,"UL",{"data-svelte-h":!0}),g(w)!=="svelte-1pp57h2"&&(w.innerHTML=b)},m(T,v){a(T,l,v),a(T,r,v),a(T,w,v)},p:Qe,d(T){T&&(n(l),n(r),n(w))}}}function da(M){let l,$,r,w,b,T,v,Ve,H,qe,R,Le,Z,Ne,G,cn='🤗 Transformers provides a <code>Trainer</code> class to help you fine-tune any of the pretrained models it provides on your dataset with modern best practices. Once you’ve done all the data preprocessing work in the last section, you have just a few steps left to define the <code>Trainer</code>. The hardest part is likely to be preparing the environment to run <code>Trainer.train()</code>, as it will run very slowly on a CPU. If you don’t have a GPU set up, you can get access to free GPUs or TPUs on <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',Pe,j,Se,I,dn="The code examples below assume you have already executed the examples in the previous section. Here is a short summary recapping what you need:",De,z,Ke,X,Oe,F,un="The first step before we can define our <code>Trainer</code> is to define a <code>TrainingArguments</code> class that will contain all the hyperparameters the <code>Trainer</code> will use for training and evaluation. The only argument you have to provide is a directory where the trained model will be saved, as well as the checkpoints along the way. For all the rest, you can leave the defaults, which should work pretty well for a basic fine-tuning.",et,Y,tt,E,mn='If you want to automatically upload your model to the Hub during training, pass along <code>push_to_hub=True</code> in the <code>TrainingArguments</code>. We will learn more about this in <a href="/course/chapter4/3">Chapter 4</a>',nt,_,at,Q,hn='The second step is to define our model. As in the <a href="/course/chapter2">previous chapter</a>, we will use the <code>AutoModelForSequenceClassification</code> class, with two labels:',it,A,st,B,fn='You will notice that unlike in <a href="/course/chapter2">Chapter 2</a>, you get a warning after instantiating this pretrained model. This is because BERT has not been pretrained on classifying pairs of sentences, so the head of the pretrained model has been discarded and a new head suitable for sequence classification has been added instead. The warnings indicate that some weights were not used (the ones corresponding to the dropped pretraining head) and that some others were randomly initialized (the ones for the new head). It concludes by encouraging you to train the model, which is exactly what we are going to do now.',lt,V,gn="Once we have our model, we can define a <code>Trainer</code> by passing it all the objects constructed up to now — the <code>model</code>, the <code>training_args</code>, the training and validation datasets, our <code>data_collator</code>, and our <code>processing_class</code>. The <code>processing_class</code> parameter is a newer addition that tells the Trainer which tokenizer to use for processing:",rt,q,ot,L,$n="When you pass a tokenizer as the <code>processing_class</code>, the default <code>data_collator</code> used by the <code>Trainer</code> will be a <code>DataCollatorWithPadding</code>. You can skip the <code>data_collator=data_collator</code> line in this case, but we included it here to show you this important part of the processing pipeline.",pt,U,ct,N,wn="To fine-tune the model on our dataset, we just have to call the <code>train()</code> method of our <code>Trainer</code>:",dt,P,ut,S,Mn="This will start the fine-tuning (which should take a couple of minutes on a GPU) and report the training loss every 500 steps. It won’t, however, tell you how well (or badly) your model is performing. This is because:",mt,D,yn="<li>We didn’t tell the <code>Trainer</code> to evaluate during training by setting <code>eval_strategy</code> in <code>TrainingArguments</code> to either <code>&quot;steps&quot;</code> (evaluate every <code>eval_steps</code>) or <code>&quot;epoch&quot;</code> (evaluate at the end of each epoch).</li> <li>We didn’t provide the <code>Trainer</code> with a <code>compute_metrics()</code> function to calculate a metric during said evaluation (otherwise the evaluation would just have printed the loss, which is not a very intuitive number).</li>",ht,K,ft,O,Tn="Let’s see how we can build a useful <code>compute_metrics()</code> function and use it the next time we train. The function must take an <code>EvalPrediction</code> object (which is a named tuple with a <code>predictions</code> field and a <code>label_ids</code> field) and will return a dictionary mapping strings to floats (the strings being the names of the metrics returned, and the floats their values). To get some predictions from our model, we can use the <code>Trainer.predict()</code> command:",gt,ee,$t,te,wt,ne,bn="The output of the <code>predict()</code> method is another named tuple with three fields: <code>predictions</code>, <code>label_ids</code>, and <code>metrics</code>. The <code>metrics</code> field will just contain the loss on the dataset passed, as well as some time metrics (how long it took to predict, in total and on average). Once we complete our <code>compute_metrics()</code> function and pass it to the <code>Trainer</code>, that field will also contain the metrics returned by <code>compute_metrics()</code>.",Mt,ae,vn='As you can see, <code>predictions</code> is a two-dimensional array with shape 408 x 2 (408 being the number of elements in the dataset we used). Those are the logits for each element of the dataset we passed to <code>predict()</code> (as you saw in the <a href="/course/chapter2">previous chapter</a>, all Transformer models return logits). To transform them into predictions that we can compare to our labels, we need to take the index with the maximum value on the second axis:',yt,ie,Tt,se,Jn='We can now compare those <code>preds</code> to the labels. To build our <code>compute_metric()</code> function, we will rely on the metrics from the 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> library. We can load the metrics associated with the MRPC dataset as easily as we loaded the dataset, this time with the <code>evaluate.load()</code> function. The object returned has a <code>compute()</code> method we can use to do the metric calculation:',bt,le,vt,re,Jt,k,jt,oe,jn='The exact results you get may vary, as the random initialization of the model head might change the metrics it achieved. Here, we can see our model has an accuracy of 85.78% on the validation set and an F1 score of 89.97. Those are the two metrics used to evaluate results on the MRPC dataset for the GLUE benchmark. The table in the <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> reported an F1 score of 88.9 for the base model. That was the <code>uncased</code> model while we are currently using the <code>cased</code> model, which explains the better result.',_t,pe,_n="Wrapping everything together, we get our <code>compute_metrics()</code> function:",Ut,ce,kt,de,Un="And to see it used in action to report metrics at the end of each epoch, here is how we define a new <code>Trainer</code> with this <code>compute_metrics()</code> function:",Ct,ue,xt,me,kn="Note that we create a new <code>TrainingArguments</code> with its <code>eval_strategy</code> set to <code>&quot;epoch&quot;</code> and a new model — otherwise, we would just be continuing the training of the model we have already trained. To launch a new training run, we execute:",Wt,he,Ht,fe,Cn="This time, it will report the validation loss and metrics at the end of each epoch on top of the training loss. Again, the exact accuracy/F1 score you reach might be a bit different from what we found, because of the random head initialization of the model, but it should be in the same ballpark.",Rt,ge,Zt,$e,xn="The <code>Trainer</code> comes with many built-in features that make modern deep learning best practices accessible:",Gt,we,Wn="<strong>Mixed Precision Training</strong>: Use <code>fp16=True</code> in your training arguments for faster training and reduced memory usage:",It,Me,zt,ye,Hn="<strong>Gradient Accumulation</strong>: For effective larger batch sizes when GPU memory is limited:",Xt,Te,Ft,be,Rn="<strong>Learning Rate Scheduling</strong>: The Trainer uses linear decay by default, but you can customize this:",Yt,ve,Et,C,Qt,Je,Zn="The <code>Trainer</code> will work out of the box on multiple GPUs or TPUs and provides lots of options for distributed training. We will go over everything it supports in Chapter 10.",At,je,Gn='This concludes the introduction to fine-tuning using the <code>Trainer</code> API. An example of doing this for most common NLP tasks will be given in <a href="/course/chapter7">Chapter 7</a>, but for now let’s look at how to do the same thing with a pure PyTorch training loop.',Bt,x,Vt,_e,qt,Ue,In="Test your understanding of the Trainer API and fine-tuning concepts:",Lt,ke,Nt,Ce,Pt,xe,St,We,Dt,He,Kt,Re,Ot,Ze,en,Ge,tn,Ie,nn,ze,an,Xe,sn,Fe,ln,W,rn,Ye,on,Be,pn;return b=new aa({props:{fw:M[0]}}),v=new On({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),H=new J({props:{title:"Fine-tuning a model with the Trainer API",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),R=new na({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),Z=new ta({props:{id:"nvBXf7s7vTI"}}),j=new Ee({props:{$$slots:{default:[ia]},$$scope:{ctx:M}}}),z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),X=new J({props:{title:"Training",local:"training",headingTag:"h3"}}),Y=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),_=new Ee({props:{$$slots:{default:[sa]},$$scope:{ctx:M}}}),A=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
)`,wrap:!1}}),U=new Ee({props:{$$slots:{default:[la]},$$scope:{ctx:M}}}),P=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),K=new J({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),ee=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),te=new y({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),ie=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),le=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),re=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),k=new Ee({props:{$$slots:{default:[ra]},$$scope:{ctx:M}}}),ce=new y({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),ue=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),he=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ge=new J({props:{title:"Advanced Training Features",local:"advanced-training-features",headingTag:"h3"}}),Me=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTIwJTIwJTIzJTIwRW5hYmxlJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    fp16=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable mixed precision</span>
)`,wrap:!1}}),Te=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwRWZmZWN0aXZlJTIwYmF0Y2glMjBzaXplJTIwJTNEJTIwNCUyMColMjA0JTIwJTNEJTIwMTYlMEEp",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Effective batch size = 4 * 4 = 16</span>
)`,wrap:!1}}),ve=new y({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMnRlc3QtdHJhaW5lciUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QyZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb3NpbmUlMjIlMkMlMjAlMjAlMjMlMjBUcnklMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXJzJTBBKQ==",highlighted:`training_args = TrainingArguments(
    <span class="hljs-string">&quot;test-trainer&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,  <span class="hljs-comment"># Try different schedulers</span>
)`,wrap:!1}}),C=new Ee({props:{$$slots:{default:[oa]},$$scope:{ctx:M}}}),x=new Ee({props:{$$slots:{default:[pa]},$$scope:{ctx:M}}}),_e=new J({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),ke=new J({props:{title:"1. What is the purpose of the <code> processing_class </code> parameter in the Trainer?",local:"1-what-is-the-purpose-of-the-code-processingclass-code-parameter-in-the-trainer",headingTag:"h3"}}),Ce=new Ae({props:{choices:[{text:"It specifies which model architecture to use.",explain:"Model architecture is specified when loading the model, not in the Trainer."},{text:"It tells the Trainer which tokenizer to use for processing data.",explain:"The processing_class parameter is a modern addition that helps the Trainer know which tokenizer to use.",correct:!0},{text:"It determines the batch size for training.",explain:"Batch size is set in TrainingArguments, not through processing_class."},{text:"It controls the evaluation frequency.",explain:"Evaluation frequency is controlled by eval_strategy in TrainingArguments."}]}}),xe=new J({props:{title:"2. Which TrainingArguments parameter controls how often evaluation occurs during training?",local:"2-which-trainingarguments-parameter-controls-how-often-evaluation-occurs-during-training",headingTag:"h3"}}),We=new Ae({props:{choices:[{text:"eval_frequency",explain:"There's no eval_frequency parameter in TrainingArguments."},{text:"eval_strategy",explain:"eval_strategy can be set to 'epoch', 'steps', or 'no' to control evaluation timing.",correct:!0},{text:"evaluation_steps",explain:"eval_steps sets the number of steps between evaluations, but eval_strategy determines if/when evaluation happens."},{text:"do_eval",explain:"There's no do_eval parameter in modern TrainingArguments."}]}}),He=new J({props:{title:"3. What does <code> fp16=True </code> in TrainingArguments enable?",local:"3-what-does-code-fp16true-code-in-trainingarguments-enable",headingTag:"h3"}}),Re=new Ae({props:{choices:[{text:"16-bit integer precision for faster training.",explain:"fp16 refers to floating-point precision, not integer precision."},{text:"Mixed precision training with 16-bit floating-point numbers for faster training and reduced memory usage.",explain:"Mixed precision training uses 16-bit floats for forward pass and 32-bit for gradients, improving speed and reducing memory usage.",correct:!0},{text:"Training for exactly 16 epochs.",explain:"fp16 has nothing to do with the number of epochs."},{text:"Using 16 GPUs for distributed training.",explain:"The number of GPUs is not controlled by the fp16 parameter."}]}}),Ze=new J({props:{title:"4. What is the role of the <code> compute_metrics </code> function in the Trainer?",local:"4-what-is-the-role-of-the-code-computemetrics-code-function-in-the-trainer",headingTag:"h3"}}),Ge=new Ae({props:{choices:[{text:"It calculates the loss during training.",explain:"Loss calculation is handled automatically by the model, not by compute_metrics."},{text:"It converts logits to predictions and calculates evaluation metrics like accuracy and F1.",explain:"compute_metrics takes predictions and labels, then returns metrics for evaluation.",correct:!0},{text:"It determines which optimizer to use.",explain:"Optimizer selection is not handled by compute_metrics."},{text:"It preprocesses the training data.",explain:"Data preprocessing is done before training, not by compute_metrics during evaluation."}]}}),Ie=new J({props:{title:"5. What happens when you don’t provide an <code> eval_dataset </code> to the Trainer?",local:"5-what-happens-when-you-dont-provide-an-code-evaldataset-code-to-the-trainer",headingTag:"h3"}}),ze=new Ae({props:{choices:[{text:"Training will fail with an error.",explain:"Training can proceed without an eval_dataset, though you won't get evaluation metrics."},{text:"The Trainer will automatically split the training data for evaluation.",explain:"The Trainer doesn't automatically create validation splits."},{text:"You won't get evaluation metrics during training, but training will still work.",explain:"Evaluation is optional - you can train without it, but you won't see validation metrics.",correct:!0},{text:"The model will use the training data for evaluation.",explain:"The Trainer won't automatically use training data for evaluation - it simply won't evaluate."}]}}),Xe=new J({props:{title:"6. What is gradient accumulation and how do you enable it?",local:"6-what-is-gradient-accumulation-and-how-do-you-enable-it",headingTag:"h3"}}),Fe=new Ae({props:{choices:[{text:"It saves gradients to disk, enabled with save_gradients=True.",explain:"Gradient accumulation doesn't involve saving gradients to disk."},{text:"It accumulates gradients over multiple batches before updating, enabled with gradient_accumulation_steps.",explain:"This allows you to simulate larger batch sizes by accumulating gradients over multiple forward passes.",correct:!0},{text:"It speeds up gradient computation, enabled automatically with fp16.",explain:"While fp16 can speed up training, gradient accumulation is a separate technique."},{text:"It prevents gradient overflow, enabled with gradient_clipping=True.",explain:"That describes gradient clipping, not gradient accumulation."}]}}),W=new Ee({props:{$$slots:{default:[ca]},$$scope:{ctx:M}}}),Ye=new ea({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/3.mdx"}}),{c(){l=h("meta"),$=i(),r=h("p"),w=i(),o(b.$$.fragment),T=i(),o(v.$$.fragment),Ve=i(),o(H.$$.fragment),qe=i(),o(R.$$.fragment),Le=i(),o(Z.$$.fragment),Ne=i(),G=h("p"),G.innerHTML=cn,Pe=i(),o(j.$$.fragment),Se=i(),I=h("p"),I.textContent=dn,De=i(),o(z.$$.fragment),Ke=i(),o(X.$$.fragment),Oe=i(),F=h("p"),F.innerHTML=un,et=i(),o(Y.$$.fragment),tt=i(),E=h("p"),E.innerHTML=mn,nt=i(),o(_.$$.fragment),at=i(),Q=h("p"),Q.innerHTML=hn,it=i(),o(A.$$.fragment),st=i(),B=h("p"),B.innerHTML=fn,lt=i(),V=h("p"),V.innerHTML=gn,rt=i(),o(q.$$.fragment),ot=i(),L=h("p"),L.innerHTML=$n,pt=i(),o(U.$$.fragment),ct=i(),N=h("p"),N.innerHTML=wn,dt=i(),o(P.$$.fragment),ut=i(),S=h("p"),S.textContent=Mn,mt=i(),D=h("ol"),D.innerHTML=yn,ht=i(),o(K.$$.fragment),ft=i(),O=h("p"),O.innerHTML=Tn,gt=i(),o(ee.$$.fragment),$t=i(),o(te.$$.fragment),wt=i(),ne=h("p"),ne.innerHTML=bn,Mt=i(),ae=h("p"),ae.innerHTML=vn,yt=i(),o(ie.$$.fragment),Tt=i(),se=h("p"),se.innerHTML=Jn,bt=i(),o(le.$$.fragment),vt=i(),o(re.$$.fragment),Jt=i(),o(k.$$.fragment),jt=i(),oe=h("p"),oe.innerHTML=jn,_t=i(),pe=h("p"),pe.innerHTML=_n,Ut=i(),o(ce.$$.fragment),kt=i(),de=h("p"),de.innerHTML=Un,Ct=i(),o(ue.$$.fragment),xt=i(),me=h("p"),me.innerHTML=kn,Wt=i(),o(he.$$.fragment),Ht=i(),fe=h("p"),fe.textContent=Cn,Rt=i(),o(ge.$$.fragment),Zt=i(),$e=h("p"),$e.innerHTML=xn,Gt=i(),we=h("p"),we.innerHTML=Wn,It=i(),o(Me.$$.fragment),zt=i(),ye=h("p"),ye.innerHTML=Hn,Xt=i(),o(Te.$$.fragment),Ft=i(),be=h("p"),be.innerHTML=Rn,Yt=i(),o(ve.$$.fragment),Et=i(),o(C.$$.fragment),Qt=i(),Je=h("p"),Je.innerHTML=Zn,At=i(),je=h("p"),je.innerHTML=Gn,Bt=i(),o(x.$$.fragment),Vt=i(),o(_e.$$.fragment),qt=i(),Ue=h("p"),Ue.textContent=In,Lt=i(),o(ke.$$.fragment),Nt=i(),o(Ce.$$.fragment),Pt=i(),o(xe.$$.fragment),St=i(),o(We.$$.fragment),Dt=i(),o(He.$$.fragment),Kt=i(),o(Re.$$.fragment),Ot=i(),o(Ze.$$.fragment),en=i(),o(Ge.$$.fragment),tn=i(),o(Ie.$$.fragment),nn=i(),o(ze.$$.fragment),an=i(),o(Xe.$$.fragment),sn=i(),o(Fe.$$.fragment),ln=i(),o(W.$$.fragment),rn=i(),o(Ye.$$.fragment),on=i(),Be=h("p"),this.h()},l(e){const t=Dn("svelte-u9bgzb",document.head);l=f(t,"META",{name:!0,content:!0}),t.forEach(n),$=s(e),r=f(e,"P",{}),Vn(r).forEach(n),w=s(e),p(b.$$.fragment,e),T=s(e),p(v.$$.fragment,e),Ve=s(e),p(H.$$.fragment,e),qe=s(e),p(R.$$.fragment,e),Le=s(e),p(Z.$$.fragment,e),Ne=s(e),G=f(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-u2oltp"&&(G.innerHTML=cn),Pe=s(e),p(j.$$.fragment,e),Se=s(e),I=f(e,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1r8y7hl"&&(I.textContent=dn),De=s(e),p(z.$$.fragment,e),Ke=s(e),p(X.$$.fragment,e),Oe=s(e),F=f(e,"P",{"data-svelte-h":!0}),g(F)!=="svelte-bcd3tt"&&(F.innerHTML=un),et=s(e),p(Y.$$.fragment,e),tt=s(e),E=f(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-ttdfe5"&&(E.innerHTML=mn),nt=s(e),p(_.$$.fragment,e),at=s(e),Q=f(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-14s2mi5"&&(Q.innerHTML=hn),it=s(e),p(A.$$.fragment,e),st=s(e),B=f(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1q6lkxd"&&(B.innerHTML=fn),lt=s(e),V=f(e,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1qyk6v2"&&(V.innerHTML=gn),rt=s(e),p(q.$$.fragment,e),ot=s(e),L=f(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-10qhbiy"&&(L.innerHTML=$n),pt=s(e),p(U.$$.fragment,e),ct=s(e),N=f(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-2dkplj"&&(N.innerHTML=wn),dt=s(e),p(P.$$.fragment,e),ut=s(e),S=f(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1u04gyz"&&(S.textContent=Mn),mt=s(e),D=f(e,"OL",{"data-svelte-h":!0}),g(D)!=="svelte-18ht4gg"&&(D.innerHTML=yn),ht=s(e),p(K.$$.fragment,e),ft=s(e),O=f(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-h6pdaj"&&(O.innerHTML=Tn),gt=s(e),p(ee.$$.fragment,e),$t=s(e),p(te.$$.fragment,e),wt=s(e),ne=f(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-1jbqb9m"&&(ne.innerHTML=bn),Mt=s(e),ae=f(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-w5buv0"&&(ae.innerHTML=vn),yt=s(e),p(ie.$$.fragment,e),Tt=s(e),se=f(e,"P",{"data-svelte-h":!0}),g(se)!=="svelte-1xta58a"&&(se.innerHTML=Jn),bt=s(e),p(le.$$.fragment,e),vt=s(e),p(re.$$.fragment,e),Jt=s(e),p(k.$$.fragment,e),jt=s(e),oe=f(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-59ywn7"&&(oe.innerHTML=jn),_t=s(e),pe=f(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1ti0nhg"&&(pe.innerHTML=_n),Ut=s(e),p(ce.$$.fragment,e),kt=s(e),de=f(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-yza6x"&&(de.innerHTML=Un),Ct=s(e),p(ue.$$.fragment,e),xt=s(e),me=f(e,"P",{"data-svelte-h":!0}),g(me)!=="svelte-pb8m1o"&&(me.innerHTML=kn),Wt=s(e),p(he.$$.fragment,e),Ht=s(e),fe=f(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-18ebo35"&&(fe.textContent=Cn),Rt=s(e),p(ge.$$.fragment,e),Zt=s(e),$e=f(e,"P",{"data-svelte-h":!0}),g($e)!=="svelte-90oj6s"&&($e.innerHTML=xn),Gt=s(e),we=f(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-11y4jet"&&(we.innerHTML=Wn),It=s(e),p(Me.$$.fragment,e),zt=s(e),ye=f(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-1c925vq"&&(ye.innerHTML=Hn),Xt=s(e),p(Te.$$.fragment,e),Ft=s(e),be=f(e,"P",{"data-svelte-h":!0}),g(be)!=="svelte-1fryuer"&&(be.innerHTML=Rn),Yt=s(e),p(ve.$$.fragment,e),Et=s(e),p(C.$$.fragment,e),Qt=s(e),Je=f(e,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-kdn0bx"&&(Je.innerHTML=Zn),At=s(e),je=f(e,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1vddj28"&&(je.innerHTML=Gn),Bt=s(e),p(x.$$.fragment,e),Vt=s(e),p(_e.$$.fragment,e),qt=s(e),Ue=f(e,"P",{"data-svelte-h":!0}),g(Ue)!=="svelte-kgoru6"&&(Ue.textContent=In),Lt=s(e),p(ke.$$.fragment,e),Nt=s(e),p(Ce.$$.fragment,e),Pt=s(e),p(xe.$$.fragment,e),St=s(e),p(We.$$.fragment,e),Dt=s(e),p(He.$$.fragment,e),Kt=s(e),p(Re.$$.fragment,e),Ot=s(e),p(Ze.$$.fragment,e),en=s(e),p(Ge.$$.fragment,e),tn=s(e),p(Ie.$$.fragment,e),nn=s(e),p(ze.$$.fragment,e),an=s(e),p(Xe.$$.fragment,e),sn=s(e),p(Fe.$$.fragment,e),ln=s(e),p(W.$$.fragment,e),rn=s(e),p(Ye.$$.fragment,e),on=s(e),Be=f(e,"P",{}),Vn(Be).forEach(n),this.h()},h(){qn(l,"name","hf:doc:metadata"),qn(l,"content",ua)},m(e,t){Kn(document.head,l),a(e,$,t),a(e,r,t),a(e,w,t),c(b,e,t),a(e,T,t),c(v,e,t),a(e,Ve,t),c(H,e,t),a(e,qe,t),c(R,e,t),a(e,Le,t),c(Z,e,t),a(e,Ne,t),a(e,G,t),a(e,Pe,t),c(j,e,t),a(e,Se,t),a(e,I,t),a(e,De,t),c(z,e,t),a(e,Ke,t),c(X,e,t),a(e,Oe,t),a(e,F,t),a(e,et,t),c(Y,e,t),a(e,tt,t),a(e,E,t),a(e,nt,t),c(_,e,t),a(e,at,t),a(e,Q,t),a(e,it,t),c(A,e,t),a(e,st,t),a(e,B,t),a(e,lt,t),a(e,V,t),a(e,rt,t),c(q,e,t),a(e,ot,t),a(e,L,t),a(e,pt,t),c(U,e,t),a(e,ct,t),a(e,N,t),a(e,dt,t),c(P,e,t),a(e,ut,t),a(e,S,t),a(e,mt,t),a(e,D,t),a(e,ht,t),c(K,e,t),a(e,ft,t),a(e,O,t),a(e,gt,t),c(ee,e,t),a(e,$t,t),c(te,e,t),a(e,wt,t),a(e,ne,t),a(e,Mt,t),a(e,ae,t),a(e,yt,t),c(ie,e,t),a(e,Tt,t),a(e,se,t),a(e,bt,t),c(le,e,t),a(e,vt,t),c(re,e,t),a(e,Jt,t),c(k,e,t),a(e,jt,t),a(e,oe,t),a(e,_t,t),a(e,pe,t),a(e,Ut,t),c(ce,e,t),a(e,kt,t),a(e,de,t),a(e,Ct,t),c(ue,e,t),a(e,xt,t),a(e,me,t),a(e,Wt,t),c(he,e,t),a(e,Ht,t),a(e,fe,t),a(e,Rt,t),c(ge,e,t),a(e,Zt,t),a(e,$e,t),a(e,Gt,t),a(e,we,t),a(e,It,t),c(Me,e,t),a(e,zt,t),a(e,ye,t),a(e,Xt,t),c(Te,e,t),a(e,Ft,t),a(e,be,t),a(e,Yt,t),c(ve,e,t),a(e,Et,t),c(C,e,t),a(e,Qt,t),a(e,Je,t),a(e,At,t),a(e,je,t),a(e,Bt,t),c(x,e,t),a(e,Vt,t),c(_e,e,t),a(e,qt,t),a(e,Ue,t),a(e,Lt,t),c(ke,e,t),a(e,Nt,t),c(Ce,e,t),a(e,Pt,t),c(xe,e,t),a(e,St,t),c(We,e,t),a(e,Dt,t),c(He,e,t),a(e,Kt,t),c(Re,e,t),a(e,Ot,t),c(Ze,e,t),a(e,en,t),c(Ge,e,t),a(e,tn,t),c(Ie,e,t),a(e,nn,t),c(ze,e,t),a(e,an,t),c(Xe,e,t),a(e,sn,t),c(Fe,e,t),a(e,ln,t),c(W,e,t),a(e,rn,t),c(Ye,e,t),a(e,on,t),a(e,Be,t),pn=!0},p(e,[t]){const zn={};t&1&&(zn.fw=e[0]),b.$set(zn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),j.$set(Xn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),_.$set(Fn);const Yn={};t&2&&(Yn.$$scope={dirty:t,ctx:e}),U.$set(Yn);const En={};t&2&&(En.$$scope={dirty:t,ctx:e}),k.$set(En);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),C.$set(Qn);const An={};t&2&&(An.$$scope={dirty:t,ctx:e}),x.$set(An);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),W.$set(Bn)},i(e){pn||(d(b.$$.fragment,e),d(v.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(Z.$$.fragment,e),d(j.$$.fragment,e),d(z.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),d(U.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(le.$$.fragment,e),d(re.$$.fragment,e),d(k.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(Te.$$.fragment,e),d(ve.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(_e.$$.fragment,e),d(ke.$$.fragment,e),d(Ce.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),d(He.$$.fragment,e),d(Re.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(Ie.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(W.$$.fragment,e),d(Ye.$$.fragment,e),pn=!0)},o(e){u(b.$$.fragment,e),u(v.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(Z.$$.fragment,e),u(j.$$.fragment,e),u(z.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(_.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(U.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(k.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(_e.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Fe.$$.fragment,e),u(W.$$.fragment,e),u(Ye.$$.fragment,e),pn=!1},d(e){e&&(n($),n(r),n(w),n(T),n(Ve),n(qe),n(Le),n(Ne),n(G),n(Pe),n(Se),n(I),n(De),n(Ke),n(Oe),n(F),n(et),n(tt),n(E),n(nt),n(at),n(Q),n(it),n(st),n(B),n(lt),n(V),n(rt),n(ot),n(L),n(pt),n(ct),n(N),n(dt),n(ut),n(S),n(mt),n(D),n(ht),n(ft),n(O),n(gt),n($t),n(wt),n(ne),n(Mt),n(ae),n(yt),n(Tt),n(se),n(bt),n(vt),n(Jt),n(jt),n(oe),n(_t),n(pe),n(Ut),n(kt),n(de),n(Ct),n(xt),n(me),n(Wt),n(Ht),n(fe),n(Rt),n(Zt),n($e),n(Gt),n(we),n(It),n(zt),n(ye),n(Xt),n(Ft),n(be),n(Yt),n(Et),n(Qt),n(Je),n(At),n(je),n(Bt),n(Vt),n(qt),n(Ue),n(Lt),n(Nt),n(Pt),n(St),n(Dt),n(Kt),n(Ot),n(en),n(tn),n(nn),n(an),n(sn),n(ln),n(rn),n(on),n(Be)),n(l),m(b,e),m(v,e),m(H,e),m(R,e),m(Z,e),m(j,e),m(z,e),m(X,e),m(Y,e),m(_,e),m(A,e),m(q,e),m(U,e),m(P,e),m(K,e),m(ee,e),m(te,e),m(ie,e),m(le,e),m(re,e),m(k,e),m(ce,e),m(ue,e),m(he,e),m(ge,e),m(Me,e),m(Te,e),m(ve,e),m(C,e),m(x,e),m(_e,e),m(ke,e),m(Ce,e),m(xe,e),m(We,e),m(He,e),m(Re,e),m(Ze,e),m(Ge,e),m(Ie,e),m(ze,e),m(Xe,e),m(Fe,e),m(W,e),m(Ye,e)}}}const ua='{"title":"Fine-tuning a model with the Trainer API","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3},{"title":"Advanced Training Features","local":"advanced-training-features","sections":[],"depth":3},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What is the purpose of the <code> processing_class </code> parameter in the Trainer?","local":"1-what-is-the-purpose-of-the-code-processingclass-code-parameter-in-the-trainer","sections":[],"depth":3},{"title":"2. Which TrainingArguments parameter controls how often evaluation occurs during training?","local":"2-which-trainingarguments-parameter-controls-how-often-evaluation-occurs-during-training","sections":[],"depth":3},{"title":"3. What does <code> fp16=True </code> in TrainingArguments enable?","local":"3-what-does-code-fp16true-code-in-trainingarguments-enable","sections":[],"depth":3},{"title":"4. What is the role of the <code> compute_metrics </code> function in the Trainer?","local":"4-what-is-the-role-of-the-code-computemetrics-code-function-in-the-trainer","sections":[],"depth":3},{"title":"5. What happens when you don’t provide an <code> eval_dataset </code> to the Trainer?","local":"5-what-happens-when-you-dont-provide-an-code-evaldataset-code-to-the-trainer","sections":[],"depth":3},{"title":"6. What is gradient accumulation and how do you enable it?","local":"6-what-is-gradient-accumulation-and-how-do-you-enable-it","sections":[],"depth":3}],"depth":2}],"depth":1}';function ma(M,l,$){let r="pt";return Nn(()=>{const w=new URLSearchParams(window.location.search);$(0,r=w.get("fw")||"pt")}),[r]}class va extends Pn{constructor(l){super(),Sn(this,l,ma,da,Ln,{})}}export{va as component};
