import{s as vt,o as At,n as Bt}from"../chunks/scheduler.cc52f4b9.js";import{S as Zt,i as Xt,e as i,s as l,c as r,h as Wt,a as o,d as t,b as a,f as _t,g as p,j as J,k as Vt,l as Nt,m as n,n as c,t as h,o as y,p as M}from"../chunks/index.5b747fde.js";import{T as Gt}from"../chunks/Tip.f0925d57.js";import{C as Et,H as Pe,E as Dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as Ht}from"../chunks/Youtube.8bb4154e.js";import{C as u}from"../chunks/CodeBlock.665bfc37.js";import{C as Rt}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Yt(As){let w,f="⚠️ Training a tokenizer is not the same as training a model! Model training uses stochastic gradient descent to make the loss a little bit smaller for each batch. It’s randomized by nature (meaning you have to set some seeds to get the same results when doing the same training twice). Training a tokenizer is a statistical process that tries to identify which subwords are the best to pick for a given corpus, and the exact rules used to pick them depend on the tokenization algorithm. It’s deterministic, meaning you always get the same results when training with the same algorithm on the same corpus.";return{c(){w=i("p"),w.textContent=f},l(m){w=o(m,"P",{"data-svelte-h":!0}),J(w)!=="svelte-1w10tsl"&&(w.textContent=f)},m(m,Vs){n(m,w,Vs)},p:Bt,d(m){m&&t(w)}}}function St(As){let w,f,m,Vs,g,Bs,T,Zs,j,Xs,x,Ke='If a language model is not available in the language you are interested in, or if your corpus is very different from the one your language model was trained on, you will most likely want to retrain the model from scratch using a tokenizer adapted to your data. That will require training a new tokenizer on your dataset. But what exactly does that mean? When we first looked at tokenizers in <a href="/course/chapter2">Chapter 2</a>, we saw that most Transformer models use a <em>subword tokenization algorithm</em>. To identify which subwords are of interest and occur most frequently in the corpus at hand, the tokenizer needs to take a hard look at all the texts in the corpus — a process we call <em>training</em>. The exact rules that govern this training depend on the type of tokenizer used, and we’ll go over the three main algorithms later in this chapter.',Ws,U,Ns,d,Gs,b,Es,k,Oe="There’s a very simple API in 🤗 Transformers that you can use to train a new tokenizer with the same characteristics as an existing one: <code>AutoTokenizer.train_new_from_iterator()</code>. To see this in action, let’s say we want to train GPT-2 from scratch, but in a language other than English. Our first task will be to gather lots of data in that language in a training corpus. To provide examples everyone will be able to understand, we won’t use a language like Russian or Chinese here, but rather a specialized English language: Python code.",Ds,C,st='The <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 Datasets</a> library can help us assemble a corpus of Python source code. We’ll use the usual <code>load_dataset()</code> function to download and cache the <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a> dataset. This dataset was created for the <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> and contains millions of functions from open source libraries on GitHub in several programming languages. Here, we will load the Python part of this dataset:',Hs,$,Rs,Q,et="We can have a look at the training split to see which columns we have access to:",Ys,I,Ss,z,qs,_,tt="We can see the dataset separates docstrings from code and suggests a tokenization of both. Here. we’ll just use the <code>whole_func_string</code> column to train our tokenizer. We can look at an example of one these functions by indexing into the <code>train</code> split:",Fs,V,Ls,v,nt="which should print the following:",Ps,A,Ks,B,lt="The first thing we need to do is transform the dataset into an <em>iterator</em> of lists of texts — for instance, a list of list of texts. Using lists of texts will enable our tokenizer to go faster (training on batches of texts instead of processing individual texts one by one), and it should be an iterator if we want to avoid having everything in memory at once. If your corpus is huge, you will want to take advantage of the fact that 🤗 Datasets does not load everything into RAM but stores the elements of the dataset on disk.",Os,Z,at="Doing the following would create a list of lists of 1,000 texts each, but would load everything in memory:",se,X,ee,W,it="Using a Python generator, we can avoid Python loading anything into memory until it’s actually necessary. To create such a generator, you just to need to replace the brackets with parentheses:",te,N,ne,G,ot="This line of code doesn’t fetch any elements of the dataset; it just creates an object you can use in a Python <code>for</code> loop. The texts will only be loaded when you need them (that is, when you’re at the step of the <code>for</code> loop that requires them), and only 1,000 texts at a time will be loaded. This way you won’t exhaust all your memory even if you are processing a huge dataset.",le,E,rt="The problem with a generator object is that it can only be used once. So, instead of this giving us the list of the first 10 digits twice:",ae,D,ie,H,pt="we get them once and then an empty list:",oe,R,re,Y,ct="That’s why we define a function that returns a generator instead:",pe,S,ce,q,ht="You can also define your generator inside a <code>for</code> loop by using the <code>yield</code> statement:",he,F,ye,L,yt="which will produce the exact same generator as before, but allows you to use more complex logic than you can in a list comprehension.",Me,P,Je,K,Mt="Now that we have our corpus in the form of an iterator of batches of texts, we are ready to train a new tokenizer. To do this, we first need to load the tokenizer we want to pair with our model (here, GPT-2):",ue,O,we,ss,Jt="Even though we are going to train a new tokenizer, it’s a good idea to do this to avoid starting entirely from scratch. This way, we won’t have to specify anything about the tokenization algorithm or the special tokens we want to use; our new tokenizer will be exactly the same as GPT-2, and the only thing that will change is the vocabulary, which will be determined by the training on our corpus.",me,es,ut="First let’s have a look at how this tokenizer would treat an example function:",de,ts,fe,ns,ge,ls,wt="This tokenizer has a few special symbols, like <code>Ġ</code> and <code>Ċ</code>, which denote spaces and newlines, respectively. As we can see, this is not too efficient: the tokenizer returns individual tokens for each space, when it could group together indentation levels (since having sets of four or eight spaces is going to be very common in code). It also split the function name a bit weirdly, not being used to seeing words with the <code>_</code> character.",Te,as,mt="Let’s train a new tokenizer and see if it solves those issues. For this, we’ll use the method <code>train_new_from_iterator()</code>:",je,is,xe,os,dt="This command might take a bit of time if your corpus is very large, but for this dataset of 1.6 GB of texts it’s  blazing fast (1 minute 16 seconds on an AMD Ryzen 9 3900X CPU with 12 cores).",Ue,rs,ft='Note that <code>AutoTokenizer.train_new_from_iterator()</code> only works if the tokenizer you are using is a “fast” tokenizer. As you’ll see in the next section, the 🤗 Transformers library contains two types of tokenizers: some are written purely in Python and others (the fast ones) are backed by the 🤗 Tokenizers library, which is written in the <a href="https://www.rust-lang.org" rel="nofollow">Rust</a> programming language. Python is the language most often used for data science and deep learning applications, but when anything needs to be parallelized to be fast, it has to be written in another language. For instance, the matrix multiplications that are at the core of the model computation are written in CUDA, an optimized C library for GPUs.',be,ps,gt='Training a brand new tokenizer in pure Python would be excruciatingly slow, which is why we developed the 🤗 Tokenizers library. Note that just as you didn’t have to learn the CUDA language to be able to execute your model on a batch of inputs on a GPU, you won’t need to learn Rust to use a fast tokenizer. The 🤗 Tokenizers library provides Python bindings for many methods that internally call some piece of code in Rust; for example, to parallelize the training of your new tokenizer or, as we saw in <a href="/course/chapter3">Chapter 3</a>, the tokenization of a batch of inputs.',ke,cs,Tt='Most of the Transformer models have a fast tokenizer available (there are some exceptions that you can check <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">here</a>), and the <code>AutoTokenizer</code> API always selects the fast tokenizer for you if it’s available. In the next section we’ll take a look at some of the other special features fast tokenizers have, which will be really useful for tasks like token classification and question answering. Before diving into that, however, let’s try our brand new tokenizer on the previous example:',Ce,hs,$e,ys,Qe,Ms,jt="Here we again see the special symbols <code>Ġ</code> and <code>Ċ</code> that denote spaces and newlines, but we can also see that our tokenizer learned some tokens that are highly specific to a corpus of Python functions: for example, there is a <code>ĊĠĠĠ</code> token that represents an indentation, and a <code>Ġ&quot;&quot;&quot;</code> token that represents the three quotes that start a docstring. The tokenizer also correctly split the function name on <code>_</code>. This is quite a compact representation; comparatively, using the plain English tokenizer on the same example will give us a longer sentence:",Ie,Js,ze,us,_e,ws,xt="Let’s look at another example:",Ve,ms,ve,ds,Ae,fs,Ut="In addition to the token corresponding to an indentation, here we can also see a token for a double indentation: <code>ĊĠĠĠĠĠĠĠ</code>. The special Python words like <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, and <code>return</code> are each tokenized as one token, and we can see that as well as splitting on <code>_</code> and <code>.</code> the tokenizer correctly splits even camel-cased names: <code>LinearLayer</code> is tokenized as <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>.",Be,gs,Ze,Ts,bt="To make sure we can use it later, we need to save our new tokenizer. Like for models, this is done with the <code>save_pretrained()</code> method:",Xe,js,We,xs,kt="This will create a new folder named <em>code-search-net-tokenizer</em>, which will contain all the files the tokenizer needs to be reloaded. If you want to share this tokenizer with your colleagues and friends, you can upload it to the Hub by logging into your account. If you’re working in a notebook, there’s a convenience function to help you with this:",Ne,Us,Ge,bs,Ct="This will display a widget where you can enter your Hugging Face login credentials. If you aren’t working in a notebook, just type the following line in your terminal:",Ee,ks,De,Cs,$t="Once you’ve logged in, you can push your tokenizer by executing the following command:",He,$s,Re,Qs,Qt="This will create a new repository in your namespace with the name <code>code-search-net-tokenizer</code>, containing the tokenizer file. You can then load the tokenizer from anywhere with the <code>from_pretrained()</code> method:",Ye,Is,Se,zs,It='You’re now all set for training a language model from scratch and fine-tuning it on your task at hand! We’ll get to that in <a href="/course/chapter7">Chapter 7</a>, but first, in the rest of this chapter we’ll take a closer look at fast tokenizers and explore in detail what actually happens when we call the method <code>train_new_from_iterator()</code>.',qe,_s,Fe,vs,Le;return g=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new Pe({props:{title:"Training a new tokenizer from an old one",local:"training-a-new-tokenizer-from-an-old-one",headingTag:"h1"}}),j=new Rt({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section2.ipynb"}]}}),U=new Ht({props:{id:"DJimQynXZsQ"}}),d=new Gt({props:{warning:!0,$$slots:{default:[Yt]},$$scope:{ctx:As}}}),b=new Pe({props:{title:"Assembling a corpus",local:"assembling-a-corpus",headingTag:"h2"}}),$=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVGhpcyUyMGNhbiUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcyUyMHRvJTIwbG9hZCUyQyUyMHNvJTIwZ3JhYiUyMGElMjBjb2ZmZWUlMjBvciUyMHRlYSUyMHdoaWxlJTIweW91JTIwd2FpdCElMEFyYXdfZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY29kZV9zZWFyY2hfbmV0JTIyJTJDJTIwJTIycHl0aG9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># This can take a few minutes to load, so grab a coffee or tea while you wait!</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),I=new u({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),z=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),V=new u({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),A=new u({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),X=new u({props:{code:"JTIzJTIwRG9uJ3QlMjB1bmNvbW1lbnQlMjB0aGUlMjBmb2xsb3dpbmclMjBsaW5lJTIwdW5sZXNzJTIweW91ciUyMGRhdGFzZXQlMjBpcyUyMHNtYWxsISUwQSUyMyUyMHRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMCU1QnJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTVE",highlighted:`<span class="hljs-comment"># Don&#x27;t uncomment the following line unless your dataset is small!</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),N=new u({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),D=new u({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),R=new u({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),S=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),F=new u({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),P=new Pe({props:{title:"Training a new tokenizer",local:"training-a-new-tokenizer",headingTag:"h2"}}),O=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ts=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),ns=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),is=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),hs=new u({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),ys=new u({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),Js=new u({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),us=new u({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ms=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),ds=new u({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),gs=new Pe({props:{title:"Saving the tokenizer",local:"saving-the-tokenizer",headingTag:"h2"}}),js=new u({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),Us=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ks=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$s=new u({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),Is=new u({props:{code:"JTIzJTIwUmVwbGFjZSUyMCUyMmh1Z2dpbmdmYWNlLWNvdXJzZSUyMiUyMGJlbG93JTIwd2l0aCUyMHlvdXIlMjBhY3R1YWwlMjBuYW1lc3BhY2UlMjB0byUyMHVzZSUyMHlvdXIlMjBvd24lMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJodWdnaW5nZmFjZS1jb3Vyc2UlMkZjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:`<span class="hljs-comment"># Replace &quot;huggingface-course&quot; below with your actual namespace to use your own tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),_s=new Dt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/2.mdx"}}),{c(){w=i("meta"),f=l(),m=i("p"),Vs=l(),r(g.$$.fragment),Bs=l(),r(T.$$.fragment),Zs=l(),r(j.$$.fragment),Xs=l(),x=i("p"),x.innerHTML=Ke,Ws=l(),r(U.$$.fragment),Ns=l(),r(d.$$.fragment),Gs=l(),r(b.$$.fragment),Es=l(),k=i("p"),k.innerHTML=Oe,Ds=l(),C=i("p"),C.innerHTML=st,Hs=l(),r($.$$.fragment),Rs=l(),Q=i("p"),Q.textContent=et,Ys=l(),r(I.$$.fragment),Ss=l(),r(z.$$.fragment),qs=l(),_=i("p"),_.innerHTML=tt,Fs=l(),r(V.$$.fragment),Ls=l(),v=i("p"),v.textContent=nt,Ps=l(),r(A.$$.fragment),Ks=l(),B=i("p"),B.innerHTML=lt,Os=l(),Z=i("p"),Z.textContent=at,se=l(),r(X.$$.fragment),ee=l(),W=i("p"),W.textContent=it,te=l(),r(N.$$.fragment),ne=l(),G=i("p"),G.innerHTML=ot,le=l(),E=i("p"),E.textContent=rt,ae=l(),r(D.$$.fragment),ie=l(),H=i("p"),H.textContent=pt,oe=l(),r(R.$$.fragment),re=l(),Y=i("p"),Y.textContent=ct,pe=l(),r(S.$$.fragment),ce=l(),q=i("p"),q.innerHTML=ht,he=l(),r(F.$$.fragment),ye=l(),L=i("p"),L.textContent=yt,Me=l(),r(P.$$.fragment),Je=l(),K=i("p"),K.textContent=Mt,ue=l(),r(O.$$.fragment),we=l(),ss=i("p"),ss.textContent=Jt,me=l(),es=i("p"),es.textContent=ut,de=l(),r(ts.$$.fragment),fe=l(),r(ns.$$.fragment),ge=l(),ls=i("p"),ls.innerHTML=wt,Te=l(),as=i("p"),as.innerHTML=mt,je=l(),r(is.$$.fragment),xe=l(),os=i("p"),os.textContent=dt,Ue=l(),rs=i("p"),rs.innerHTML=ft,be=l(),ps=i("p"),ps.innerHTML=gt,ke=l(),cs=i("p"),cs.innerHTML=Tt,Ce=l(),r(hs.$$.fragment),$e=l(),r(ys.$$.fragment),Qe=l(),Ms=i("p"),Ms.innerHTML=jt,Ie=l(),r(Js.$$.fragment),ze=l(),r(us.$$.fragment),_e=l(),ws=i("p"),ws.textContent=xt,Ve=l(),r(ms.$$.fragment),ve=l(),r(ds.$$.fragment),Ae=l(),fs=i("p"),fs.innerHTML=Ut,Be=l(),r(gs.$$.fragment),Ze=l(),Ts=i("p"),Ts.innerHTML=bt,Xe=l(),r(js.$$.fragment),We=l(),xs=i("p"),xs.innerHTML=kt,Ne=l(),r(Us.$$.fragment),Ge=l(),bs=i("p"),bs.textContent=Ct,Ee=l(),r(ks.$$.fragment),De=l(),Cs=i("p"),Cs.textContent=$t,He=l(),r($s.$$.fragment),Re=l(),Qs=i("p"),Qs.innerHTML=Qt,Ye=l(),r(Is.$$.fragment),Se=l(),zs=i("p"),zs.innerHTML=It,qe=l(),r(_s.$$.fragment),Fe=l(),vs=i("p"),this.h()},l(s){const e=Wt("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(t),f=a(s),m=o(s,"P",{}),_t(m).forEach(t),Vs=a(s),p(g.$$.fragment,s),Bs=a(s),p(T.$$.fragment,s),Zs=a(s),p(j.$$.fragment,s),Xs=a(s),x=o(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-ge9o4k"&&(x.innerHTML=Ke),Ws=a(s),p(U.$$.fragment,s),Ns=a(s),p(d.$$.fragment,s),Gs=a(s),p(b.$$.fragment,s),Es=a(s),k=o(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1h1d1jb"&&(k.innerHTML=Oe),Ds=a(s),C=o(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-d4p7ba"&&(C.innerHTML=st),Hs=a(s),p($.$$.fragment,s),Rs=a(s),Q=o(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-12bpn2p"&&(Q.textContent=et),Ys=a(s),p(I.$$.fragment,s),Ss=a(s),p(z.$$.fragment,s),qs=a(s),_=o(s,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1ttcdha"&&(_.innerHTML=tt),Fs=a(s),p(V.$$.fragment,s),Ls=a(s),v=o(s,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1go55zn"&&(v.textContent=nt),Ps=a(s),p(A.$$.fragment,s),Ks=a(s),B=o(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1w4rq2j"&&(B.innerHTML=lt),Os=a(s),Z=o(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-n3iewp"&&(Z.textContent=at),se=a(s),p(X.$$.fragment,s),ee=a(s),W=o(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-z3gyd6"&&(W.textContent=it),te=a(s),p(N.$$.fragment,s),ne=a(s),G=o(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1m62zsw"&&(G.innerHTML=ot),le=a(s),E=o(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-y43dl1"&&(E.textContent=rt),ae=a(s),p(D.$$.fragment,s),ie=a(s),H=o(s,"P",{"data-svelte-h":!0}),J(H)!=="svelte-nyttr1"&&(H.textContent=pt),oe=a(s),p(R.$$.fragment,s),re=a(s),Y=o(s,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-1ja5i79"&&(Y.textContent=ct),pe=a(s),p(S.$$.fragment,s),ce=a(s),q=o(s,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1ujnh8r"&&(q.innerHTML=ht),he=a(s),p(F.$$.fragment,s),ye=a(s),L=o(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-15t5zhk"&&(L.textContent=yt),Me=a(s),p(P.$$.fragment,s),Je=a(s),K=o(s,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1if3zzd"&&(K.textContent=Mt),ue=a(s),p(O.$$.fragment,s),we=a(s),ss=o(s,"P",{"data-svelte-h":!0}),J(ss)!=="svelte-gfsdsz"&&(ss.textContent=Jt),me=a(s),es=o(s,"P",{"data-svelte-h":!0}),J(es)!=="svelte-1whi783"&&(es.textContent=ut),de=a(s),p(ts.$$.fragment,s),fe=a(s),p(ns.$$.fragment,s),ge=a(s),ls=o(s,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-1n6ojb6"&&(ls.innerHTML=wt),Te=a(s),as=o(s,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1wg3w1a"&&(as.innerHTML=mt),je=a(s),p(is.$$.fragment,s),xe=a(s),os=o(s,"P",{"data-svelte-h":!0}),J(os)!=="svelte-1s55tci"&&(os.textContent=dt),Ue=a(s),rs=o(s,"P",{"data-svelte-h":!0}),J(rs)!=="svelte-1cil686"&&(rs.innerHTML=ft),be=a(s),ps=o(s,"P",{"data-svelte-h":!0}),J(ps)!=="svelte-9eiphm"&&(ps.innerHTML=gt),ke=a(s),cs=o(s,"P",{"data-svelte-h":!0}),J(cs)!=="svelte-kzj4vn"&&(cs.innerHTML=Tt),Ce=a(s),p(hs.$$.fragment,s),$e=a(s),p(ys.$$.fragment,s),Qe=a(s),Ms=o(s,"P",{"data-svelte-h":!0}),J(Ms)!=="svelte-1si8jb2"&&(Ms.innerHTML=jt),Ie=a(s),p(Js.$$.fragment,s),ze=a(s),p(us.$$.fragment,s),_e=a(s),ws=o(s,"P",{"data-svelte-h":!0}),J(ws)!=="svelte-1hvz582"&&(ws.textContent=xt),Ve=a(s),p(ms.$$.fragment,s),ve=a(s),p(ds.$$.fragment,s),Ae=a(s),fs=o(s,"P",{"data-svelte-h":!0}),J(fs)!=="svelte-1anhj7k"&&(fs.innerHTML=Ut),Be=a(s),p(gs.$$.fragment,s),Ze=a(s),Ts=o(s,"P",{"data-svelte-h":!0}),J(Ts)!=="svelte-ot264x"&&(Ts.innerHTML=bt),Xe=a(s),p(js.$$.fragment,s),We=a(s),xs=o(s,"P",{"data-svelte-h":!0}),J(xs)!=="svelte-1oaabmx"&&(xs.innerHTML=kt),Ne=a(s),p(Us.$$.fragment,s),Ge=a(s),bs=o(s,"P",{"data-svelte-h":!0}),J(bs)!=="svelte-mgkzhm"&&(bs.textContent=Ct),Ee=a(s),p(ks.$$.fragment,s),De=a(s),Cs=o(s,"P",{"data-svelte-h":!0}),J(Cs)!=="svelte-gbhb1u"&&(Cs.textContent=$t),He=a(s),p($s.$$.fragment,s),Re=a(s),Qs=o(s,"P",{"data-svelte-h":!0}),J(Qs)!=="svelte-eipxyz"&&(Qs.innerHTML=Qt),Ye=a(s),p(Is.$$.fragment,s),Se=a(s),zs=o(s,"P",{"data-svelte-h":!0}),J(zs)!=="svelte-1r3xq8e"&&(zs.innerHTML=It),qe=a(s),p(_s.$$.fragment,s),Fe=a(s),vs=o(s,"P",{}),_t(vs).forEach(t),this.h()},h(){Vt(w,"name","hf:doc:metadata"),Vt(w,"content",qt)},m(s,e){Nt(document.head,w),n(s,f,e),n(s,m,e),n(s,Vs,e),c(g,s,e),n(s,Bs,e),c(T,s,e),n(s,Zs,e),c(j,s,e),n(s,Xs,e),n(s,x,e),n(s,Ws,e),c(U,s,e),n(s,Ns,e),c(d,s,e),n(s,Gs,e),c(b,s,e),n(s,Es,e),n(s,k,e),n(s,Ds,e),n(s,C,e),n(s,Hs,e),c($,s,e),n(s,Rs,e),n(s,Q,e),n(s,Ys,e),c(I,s,e),n(s,Ss,e),c(z,s,e),n(s,qs,e),n(s,_,e),n(s,Fs,e),c(V,s,e),n(s,Ls,e),n(s,v,e),n(s,Ps,e),c(A,s,e),n(s,Ks,e),n(s,B,e),n(s,Os,e),n(s,Z,e),n(s,se,e),c(X,s,e),n(s,ee,e),n(s,W,e),n(s,te,e),c(N,s,e),n(s,ne,e),n(s,G,e),n(s,le,e),n(s,E,e),n(s,ae,e),c(D,s,e),n(s,ie,e),n(s,H,e),n(s,oe,e),c(R,s,e),n(s,re,e),n(s,Y,e),n(s,pe,e),c(S,s,e),n(s,ce,e),n(s,q,e),n(s,he,e),c(F,s,e),n(s,ye,e),n(s,L,e),n(s,Me,e),c(P,s,e),n(s,Je,e),n(s,K,e),n(s,ue,e),c(O,s,e),n(s,we,e),n(s,ss,e),n(s,me,e),n(s,es,e),n(s,de,e),c(ts,s,e),n(s,fe,e),c(ns,s,e),n(s,ge,e),n(s,ls,e),n(s,Te,e),n(s,as,e),n(s,je,e),c(is,s,e),n(s,xe,e),n(s,os,e),n(s,Ue,e),n(s,rs,e),n(s,be,e),n(s,ps,e),n(s,ke,e),n(s,cs,e),n(s,Ce,e),c(hs,s,e),n(s,$e,e),c(ys,s,e),n(s,Qe,e),n(s,Ms,e),n(s,Ie,e),c(Js,s,e),n(s,ze,e),c(us,s,e),n(s,_e,e),n(s,ws,e),n(s,Ve,e),c(ms,s,e),n(s,ve,e),c(ds,s,e),n(s,Ae,e),n(s,fs,e),n(s,Be,e),c(gs,s,e),n(s,Ze,e),n(s,Ts,e),n(s,Xe,e),c(js,s,e),n(s,We,e),n(s,xs,e),n(s,Ne,e),c(Us,s,e),n(s,Ge,e),n(s,bs,e),n(s,Ee,e),c(ks,s,e),n(s,De,e),n(s,Cs,e),n(s,He,e),c($s,s,e),n(s,Re,e),n(s,Qs,e),n(s,Ye,e),c(Is,s,e),n(s,Se,e),n(s,zs,e),n(s,qe,e),c(_s,s,e),n(s,Fe,e),n(s,vs,e),Le=!0},p(s,[e]){const zt={};e&2&&(zt.$$scope={dirty:e,ctx:s}),d.$set(zt)},i(s){Le||(h(g.$$.fragment,s),h(T.$$.fragment,s),h(j.$$.fragment,s),h(U.$$.fragment,s),h(d.$$.fragment,s),h(b.$$.fragment,s),h($.$$.fragment,s),h(I.$$.fragment,s),h(z.$$.fragment,s),h(V.$$.fragment,s),h(A.$$.fragment,s),h(X.$$.fragment,s),h(N.$$.fragment,s),h(D.$$.fragment,s),h(R.$$.fragment,s),h(S.$$.fragment,s),h(F.$$.fragment,s),h(P.$$.fragment,s),h(O.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(Js.$$.fragment,s),h(us.$$.fragment,s),h(ms.$$.fragment,s),h(ds.$$.fragment,s),h(gs.$$.fragment,s),h(js.$$.fragment,s),h(Us.$$.fragment,s),h(ks.$$.fragment,s),h($s.$$.fragment,s),h(Is.$$.fragment,s),h(_s.$$.fragment,s),Le=!0)},o(s){y(g.$$.fragment,s),y(T.$$.fragment,s),y(j.$$.fragment,s),y(U.$$.fragment,s),y(d.$$.fragment,s),y(b.$$.fragment,s),y($.$$.fragment,s),y(I.$$.fragment,s),y(z.$$.fragment,s),y(V.$$.fragment,s),y(A.$$.fragment,s),y(X.$$.fragment,s),y(N.$$.fragment,s),y(D.$$.fragment,s),y(R.$$.fragment,s),y(S.$$.fragment,s),y(F.$$.fragment,s),y(P.$$.fragment,s),y(O.$$.fragment,s),y(ts.$$.fragment,s),y(ns.$$.fragment,s),y(is.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(Js.$$.fragment,s),y(us.$$.fragment,s),y(ms.$$.fragment,s),y(ds.$$.fragment,s),y(gs.$$.fragment,s),y(js.$$.fragment,s),y(Us.$$.fragment,s),y(ks.$$.fragment,s),y($s.$$.fragment,s),y(Is.$$.fragment,s),y(_s.$$.fragment,s),Le=!1},d(s){s&&(t(f),t(m),t(Vs),t(Bs),t(Zs),t(Xs),t(x),t(Ws),t(Ns),t(Gs),t(Es),t(k),t(Ds),t(C),t(Hs),t(Rs),t(Q),t(Ys),t(Ss),t(qs),t(_),t(Fs),t(Ls),t(v),t(Ps),t(Ks),t(B),t(Os),t(Z),t(se),t(ee),t(W),t(te),t(ne),t(G),t(le),t(E),t(ae),t(ie),t(H),t(oe),t(re),t(Y),t(pe),t(ce),t(q),t(he),t(ye),t(L),t(Me),t(Je),t(K),t(ue),t(we),t(ss),t(me),t(es),t(de),t(fe),t(ge),t(ls),t(Te),t(as),t(je),t(xe),t(os),t(Ue),t(rs),t(be),t(ps),t(ke),t(cs),t(Ce),t($e),t(Qe),t(Ms),t(Ie),t(ze),t(_e),t(ws),t(Ve),t(ve),t(Ae),t(fs),t(Be),t(Ze),t(Ts),t(Xe),t(We),t(xs),t(Ne),t(Ge),t(bs),t(Ee),t(De),t(Cs),t(He),t(Re),t(Qs),t(Ye),t(Se),t(zs),t(qe),t(Fe),t(vs)),t(w),M(g,s),M(T,s),M(j,s),M(U,s),M(d,s),M(b,s),M($,s),M(I,s),M(z,s),M(V,s),M(A,s),M(X,s),M(N,s),M(D,s),M(R,s),M(S,s),M(F,s),M(P,s),M(O,s),M(ts,s),M(ns,s),M(is,s),M(hs,s),M(ys,s),M(Js,s),M(us,s),M(ms,s),M(ds,s),M(gs,s),M(js,s),M(Us,s),M(ks,s),M($s,s),M(Is,s),M(_s,s)}}}const qt='{"title":"Training a new tokenizer from an old one","local":"training-a-new-tokenizer-from-an-old-one","sections":[{"title":"Assembling a corpus","local":"assembling-a-corpus","sections":[],"depth":2},{"title":"Training a new tokenizer","local":"training-a-new-tokenizer","sections":[],"depth":2},{"title":"Saving the tokenizer","local":"saving-the-tokenizer","sections":[],"depth":2}],"depth":1}';function Ft(As){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends Zt{constructor(w){super(),Xt(this,w,Ft,St,vt,{})}}export{nn as component};
