import{s as dn,o as gn,n as Ks}from"../chunks/scheduler.cc52f4b9.js";import{S as fn,i as xn,e as j,s as t,c as M,q as bn,H as Cn,h as qn,a as h,d as a,b as e,f as Aa,g as i,j as J,r as kn,u as $n,k as Tn,l as wn,m as n,n as r,t as y,o,p as c}from"../chunks/index.5b747fde.js";import{T as Ls}from"../chunks/Tip.f0925d57.js";import{C as An,H as ka,E as zn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as vn}from"../chunks/Youtube.8bb4154e.js";import{C as m}from"../chunks/CodeBlock.665bfc37.js";import{C as Qn}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Bn(w){let p,U="💡 This section covers WordPiece in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){p=j("p"),p.textContent=U},l(u){p=h(u,"P",{"data-svelte-h":!0}),J(p)!=="svelte-7v3wq0"&&(p.textContent=U)},m(u,T){n(u,p,T)},p:Ks,d(u){u&&a(p)}}}function Nn(w){let p,U="⚠️ Google never open-sourced its implementation of the training algorithm of WordPiece, so what follows is our best guess based on the published literature. It may not be 100% accurate.";return{c(){p=j("p"),p.textContent=U},l(u){p=h(u,"P",{"data-svelte-h":!0}),J(p)!=="svelte-rd0zod"&&(p.textContent=U)},m(u,T){n(u,p,T)},p:Ks,d(u){u&&a(p)}}}function Zn(w){let p,U="✏️ <strong>Now your turn!</strong> What will the next merge rule be?";return{c(){p=j("p"),p.innerHTML=U},l(u){p=h(u,"P",{"data-svelte-h":!0}),J(p)!=="svelte-4fg9cy"&&(p.innerHTML=U)},m(u,T){n(u,p,T)},p:Ks,d(u){u&&a(p)}}}function _n(w){let p,U="✏️ <strong>Now your turn!</strong> How will the word <code>&quot;pugs&quot;</code> be tokenized?";return{c(){p=j("p"),p.innerHTML=U},l(u){p=h(u,"P",{"data-svelte-h":!0}),J(p)!=="svelte-1r124bw"&&(p.innerHTML=U)},m(u,T){n(u,p,T)},p:Ks,d(u){u&&a(p)}}}function En(w){let p,U="💡 Using <code>train_new_from_iterator()</code> on the same corpus won’t result in the exact same vocabulary. This is because the 🤗 Tokenizers library does not implement WordPiece for the training (since we are not completely sure of its internals), but uses BPE instead.";return{c(){p=j("p"),p.innerHTML=U},l(u){p=h(u,"P",{"data-svelte-h":!0}),J(p)!=="svelte-166hjxq"&&(p.innerHTML=U)},m(u,T){n(u,p,T)},p:Ks,d(u){u&&a(p)}}}function Sn(w){let p,U,u,T,b,Os,C,sl,q,ll,k,za="WordPiece is the tokenization algorithm Google developed to pretrain BERT. It has since been reused in quite a few Transformer models based on BERT, such as DistilBERT, MobileBERT, Funnel Transformers, and MPNET. It’s very similar to BPE in terms of the training, but the actual tokenization is done differently.",al,$,nl,I,tl,A,el,d,pl,z,va="Like BPE, WordPiece starts from a small vocabulary including the special tokens used by the model and the initial alphabet. Since it identifies subwords by adding a prefix (like <code>##</code> for BERT), each word is initially split by adding that prefix to all the characters inside the word. So, for instance, <code>&quot;word&quot;</code> gets split like this:",Ml,v,il,Q,Qa="Thus, the initial alphabet contains all the characters present at the beginning of a word and the characters present inside a word preceded by the WordPiece prefix.",rl,B,$a,yl,In='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mrow><mi mathvariant="normal">s</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi></mrow><mo>=</mo><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">p</mi><mi mathvariant="normal">a</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi></mrow><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">t</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo>×</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">d</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathrm{score} = (\\mathrm{freq\\_of\\_pair}) / (\\mathrm{freq\\_of\\_first\\_element} \\times \\mathrm{freq\\_of\\_second\\_element})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord"><span class="mord mathrm">score</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_pair</span></span><span class="mclose">)</span><span class="mord">/</span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_first_element</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mord"><span class="mord mathrm">freq_of_second_element</span></span><span class="mclose">)</span></span></span></span></span>',ol,N,Ba="By dividing the frequency of the pair by the product of the frequencies of each of its parts, the algorithm prioritizes the merging of pairs where the individual parts are less frequent in the vocabulary. For instance, it won’t necessarily merge <code>(&quot;un&quot;, &quot;##able&quot;)</code> even if that pair occurs very frequently in the vocabulary, because the two pairs <code>&quot;un&quot;</code> and <code>&quot;##able&quot;</code> will likely each appear in a lot of other words and have a high frequency. In contrast, a pair like <code>(&quot;hu&quot;, &quot;##gging&quot;)</code> will probably be merged faster (assuming the word “hugging” appears often in the vocabulary) since <code>&quot;hu&quot;</code> and <code>&quot;##gging&quot;</code> are likely to be less frequent individually.",cl,Z,Na="Let’s look at the same vocabulary we used in the BPE training example:",jl,_,hl,E,Za="The splits here will be:",Jl,S,ul,G,_a="so the initial vocabulary will be <code>[&quot;b&quot;, &quot;h&quot;, &quot;p&quot;, &quot;##g&quot;, &quot;##n&quot;, &quot;##s&quot;, &quot;##u&quot;]</code> (if we forget about special tokens for now). The most frequent pair is <code>(&quot;##u&quot;, &quot;##g&quot;)</code> (present 20 times), but the individual frequency of <code>&quot;##u&quot;</code> is very high, so its score is not the highest (it’s 1 / 36). All pairs with a <code>&quot;##u&quot;</code> actually have that same score (1 / 36), so the best score goes to the pair <code>(&quot;##g&quot;, &quot;##s&quot;)</code> — the only one without a <code>&quot;##u&quot;</code> — at 1 / 20, and the first merge learned is <code>(&quot;##g&quot;, &quot;##s&quot;) -&gt; (&quot;##gs&quot;)</code>.",ml,V,Ea="Note that when we merge, we remove the <code>##</code> between the two tokens, so we add <code>&quot;##gs&quot;</code> to the vocabulary and apply the merge in the words of the corpus:",Ul,W,Tl,X,Sa="At this point, <code>&quot;##u&quot;</code> is in all the possible pairs, so they all end up with the same score. Let’s say that in this case, the first pair is merged, so <code>(&quot;h&quot;, &quot;##u&quot;) -&gt; &quot;hu&quot;</code>. This takes us to:",wl,H,Il,R,Ga="Then the next best score is shared by <code>(&quot;hu&quot;, &quot;##g&quot;)</code> and <code>(&quot;hu&quot;, &quot;##gs&quot;)</code> (with 1/15, compared to 1/21 for all the other pairs), so the first pair with the biggest score is merged:",dl,Y,gl,D,Va="and we continue like this until we reach the desired vocabulary size.",fl,g,xl,F,bl,P,Wa="Tokenization differs in WordPiece and BPE in that WordPiece only saves the final vocabulary, not the merge rules learned. Starting from the word to tokenize, WordPiece finds the longest subword that is in the vocabulary, then splits on it. For instance, if we use the vocabulary learned in the example above, for the word <code>&quot;hugs&quot;</code> the longest subword starting from the beginning that is inside the vocabulary is <code>&quot;hug&quot;</code>, so we split there and get <code>[&quot;hug&quot;, &quot;##s&quot;]</code>. We then continue with <code>&quot;##s&quot;</code>, which is in the vocabulary, so the tokenization of <code>&quot;hugs&quot;</code> is <code>[&quot;hug&quot;, &quot;##s&quot;]</code>.",Cl,L,Xa="With BPE, we would have applied the merges learned in order and tokenized this as <code>[&quot;hu&quot;, &quot;##gs&quot;]</code>, so the encoding is different.",ql,K,Ha="As another example, let’s see how the word <code>&quot;bugs&quot;</code> would be tokenized. <code>&quot;b&quot;</code> is the longest subword starting at the beginning of the word that is in the vocabulary, so we split there and get <code>[&quot;b&quot;, &quot;##ugs&quot;]</code>. Then <code>&quot;##u&quot;</code> is the longest subword starting at the beginning of <code>&quot;##ugs&quot;</code> that is in the vocabulary, so we split there and get <code>[&quot;b&quot;, &quot;##u, &quot;##gs&quot;]</code>. Finally, <code>&quot;##gs&quot;</code> is in the vocabulary, so this last list is the tokenization of <code>&quot;bugs&quot;</code>.",kl,O,Ra="When the tokenization gets to a stage where it’s not possible to find a subword in the vocabulary, the whole word is tokenized as unknown — so, for instance, <code>&quot;mug&quot;</code> would be tokenized as <code>[&quot;[UNK]&quot;]</code>, as would <code>&quot;bum&quot;</code> (even if we can begin with <code>&quot;b&quot;</code> and <code>&quot;##u&quot;</code>, <code>&quot;##m&quot;</code> is not the vocabulary, and the resulting tokenization will just be <code>[&quot;[UNK]&quot;]</code>, not <code>[&quot;b&quot;, &quot;##u&quot;, &quot;[UNK]&quot;]</code>). This is another difference from BPE, which would only classify the individual characters not in the vocabulary as unknown.",$l,f,Al,ss,zl,ls,Ya="Now let’s take a look at an implementation of the WordPiece algorithm. Like with BPE, this is just pedagogical, and you won’t able to use this on a big corpus.",vl,as,Da="We will use the same corpus as in the BPE example:",Ql,ns,Bl,ts,Fa="First, we need to pre-tokenize the corpus into words. Since we are replicating a WordPiece tokenizer (like BERT), we will use the <code>bert-base-cased</code> tokenizer for the pre-tokenization:",Nl,es,Zl,ps,Pa="Then we compute the frequencies of each word in the corpus as we do the pre-tokenization:",_l,Ms,El,is,Sl,rs,La="As we saw before, the alphabet is the unique set composed of all the first letters of words, and all the other letters that appear in words prefixed by <code>##</code>:",Gl,ys,Vl,os,Wl,cs,Ka="We also add the special tokens used by the model at the beginning of that vocabulary. In the case of BERT, it’s the list <code>[&quot;[PAD]&quot;, &quot;[UNK]&quot;, &quot;[CLS]&quot;, &quot;[SEP]&quot;, &quot;[MASK]&quot;]</code>:",Xl,js,Hl,hs,Oa="Next we need to split each word, with all the letters that are not the first prefixed by <code>##</code>:",Rl,Js,Yl,us,sn="Now that we are ready for training, let’s write a function that computes the score of each pair. We’ll need to use this at each step of the training:",Dl,ms,Fl,Us,ln="Let’s have a look at a part of this dictionary after the initial splits:",Pl,Ts,Ll,ws,Kl,Is,an="Now, finding the pair with the best score only takes a quick loop:",Ol,ds,sa,gs,la,fs,nn="So the first merge to learn is <code>(&#39;a&#39;, &#39;##b&#39;) -&gt; &#39;ab&#39;</code>, and we add <code>&#39;ab&#39;</code> to the vocabulary:",aa,xs,na,bs,tn="To continue, we need to apply that merge in our <code>splits</code> dictionary. Let’s write another function for this:",ta,Cs,ea,qs,en="And we can have a look at the result of the first merge:",pa,ks,Ma,$s,ia,As,pn="Now we have everything we need to loop until we have learned all the merges we want. Let’s aim for a vocab size of 70:",ra,zs,ya,vs,Mn="We can then look at the generated vocabulary:",oa,Qs,ca,Bs,ja,Ns,rn="As we can see, compared to BPE, this tokenizer learns parts of words as tokens a bit faster.",ha,x,Ja,Zs,yn="To tokenize a new text, we pre-tokenize it, split it, then apply the tokenization algorithm on each word. That is, we look for the biggest subword starting at the beginning of the first word and split it, then we repeat the process on the second part, and so on for the rest of that word and the following words in the text:",ua,_s,ma,Es,on="Let’s test it on one word that’s in the vocabulary, and another that isn’t:",Ua,Ss,Ta,Gs,wa,Vs,cn="Now, let’s write a function that tokenizes a text:",Ia,Ws,da,Xs,jn="We can try it on any text:",ga,Hs,fa,Rs,xa,Ys,hn="That’s it for the WordPiece algorithm! Now let’s take a look at Unigram.",ba,Ds,Ca,Ps,qa;return b=new An({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new ka({props:{title:"WordPiece tokenization",local:"wordpiece-tokenization",headingTag:"h1"}}),q=new Qn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section6.ipynb"}]}}),$=new vn({props:{id:"qpv6ms_t_1A"}}),I=new Ls({props:{$$slots:{default:[Bn]},$$scope:{ctx:w}}}),A=new ka({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),d=new Ls({props:{warning:!0,$$slots:{default:[Nn]},$$scope:{ctx:w}}}),v=new m({props:{code:"dyUyMCUyMyUyM28lMjAlMjMlMjNyJTIwJTIzJTIzZA==",highlighted:"w ##o ##r ##d",wrap:!1}}),_=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),S=new m({props:{code:"KCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTIwJTIyJTIzJTIzcyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-number">5</span>)',wrap:!1}}),W=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzbiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZ3MlMjIlMkMlMjA1KQ==",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>]
Corpus: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),H=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),g=new Ls({props:{$$slots:{default:[Zn]},$$scope:{ctx:w}}}),F=new ka({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),f=new Ls({props:{$$slots:{default:[_n]},$$scope:{ctx:w}}}),ss=new ka({props:{title:"Implementing WordPiece",local:"implementing-wordpiece",headingTag:"h2"}}),ns=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),es=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),Ms=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),is=new m({props:{code:"ZGVmYXVsdGRpY3QoJTBBJTIwJTIwJTIwJTIwaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCdpcyclM0ElMjAyJTJDJTIwJ3RoZSclM0ElMjAxJTJDJTIwJ0h1Z2dpbmcnJTNBJTIwMSUyQyUyMCdGYWNlJyUzQSUyMDElMkMlMjAnQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJ2NoYXB0ZXInJTNBJTIwMSUyQyUyMCdhYm91dCclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJ3Rva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJ3NlY3Rpb24nJTNBJTIwMSUyQyUyMCdzaG93cyclM0ElMjAxJTJDJTIwJ3NldmVyYWwnJTNBJTIwMSUyQyUyMCd0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCdhbGdvcml0aG1zJyUzQSUyMDElMkMlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnJTJDJyUzQSUyMDElMkMlMjAneW91JyUzQSUyMDElMkMlMjAnd2lsbCclM0ElMjAxJTJDJTIwJ2JlJyUzQSUyMDElMkMlMjAnYWJsZSclM0ElMjAxJTJDJTIwJ3RvJyUzQSUyMDElMkMlMjAndW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJ2hvdyclM0ElMjAxJTJDJTIwJ3RoZXknJTNBJTIwMSUyQyUyMCdhcmUnJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCd0cmFpbmVkJyUzQSUyMDElMkMlMjAnYW5kJyUzQSUyMDElMkMlMjAnZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCd0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(
    <span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;is&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;the&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Face&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Course&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;chapter&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;about&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;tokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;section&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;shows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;several&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;algorithms&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;you&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;will&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;be&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;able&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;to&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;understand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;how&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;they&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;are&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;trained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;and&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;generate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),ys=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwd29yZCU1QjAlNUQlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKHdvcmQlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCU1QjElM0ElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIpJTBBJTBBYWxwaGFiZXQuc29ydCgpJTBBYWxwaGFiZXQlMEElMEFwcmludChhbHBoYWJldCk=",highlighted:`alphabet = []
<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">if</span> word[<span class="hljs-number">0</span>] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
        alphabet.append(word[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word[<span class="hljs-number">1</span>:]:
        <span class="hljs-keyword">if</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(<span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span>)

alphabet.sort()
alphabet

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),os=new m({props:{code:"JTVCJyUyMyUyM2EnJTJDJTIwJyUyMyUyM2InJTJDJTIwJyUyMyUyM2MnJTJDJTIwJyUyMyUyM2QnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJyUyMyUyM2YnJTJDJTIwJyUyMyUyM2cnJTJDJTIwJyUyMyUyM2gnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM2snJTJDJTIwJyUyMyUyM2wnJTJDJTIwJyUyMyUyM20nJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM28nJTJDJTIwJyUyMyUyM3AnJTJDJTIwJyUyMyUyM3InJTJDJTIwJyUyMyUyM3MnJTJDJTBBJTIwJyUyMyUyM3QnJTJDJTIwJyUyMyUyM3UnJTJDJTIwJyUyMyUyM3YnJTJDJTIwJyUyMyUyM3cnJTJDJTIwJyUyMyUyM3knJTJDJTIwJyUyMyUyM3onJTJDJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAncyclMkMlMjAndCclMkMlMjAndSclMkMlMEElMjAndyclMkMlMjAneSclNUQ=",highlighted:`[<span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>, <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>,
 <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>]`,wrap:!1}}),js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTIwJTJCJTIwYWxwaGFiZXQuY29weSgp",highlighted:'vocab = [<span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>] + alphabet.copy()',wrap:!1}}),Js=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwd29yZCUzQSUyMCU1QmMlMjBpZiUyMGklMjAlM0QlM0QlMjAwJTIwZWxzZSUyMGYlMjIlMjMlMjMlN0JjJTdEJTIyJTIwZm9yJTIwaSUyQyUyMGMlMjBpbiUyMGVudW1lcmF0ZSh3b3JkKSU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRfZnJlcXMua2V5cygpJTBBJTdE",highlighted:`splits = {
    word: [c <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{c}</span>&quot;</span> <span class="hljs-keyword">for</span> i, c <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(word)]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()
}`,wrap:!1}}),ms=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX3Njb3JlcyhzcGxpdHMpJTNBJTBBJTIwJTIwJTIwJTIwbGV0dGVyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBkZWZhdWx0ZGljdChpbnQpJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXRzJTVCd29yZCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNwbGl0KSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1QjAlNUQlNUQlMjAlMkIlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxldHRlcl9mcmVxcyU1QnNwbGl0JTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTVCcGFpciU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1Qi0xJTVEJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXIlM0ElMjBmcmVxJTIwJTJGJTIwKGxldHRlcl9mcmVxcyU1QnBhaXIlNUIwJTVEJTVEJTIwKiUyMGxldHRlcl9mcmVxcyU1QnBhaXIlNUIxJTVEJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_scores</span>(<span class="hljs-params">splits</span>):
    letter_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            letter_freqs[split[<span class="hljs-number">0</span>]] += freq
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            letter_freqs[split[i]] += freq
            pair_freqs[pair] += freq
        letter_freqs[split[-<span class="hljs-number">1</span>]] += freq

    scores = {
        pair: freq / (letter_freqs[pair[<span class="hljs-number">0</span>]] * letter_freqs[pair[<span class="hljs-number">1</span>]])
        <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items()
    }
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),Ts=new m({props:{code:"cGFpcl9zY29yZXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfc2NvcmVzKHNwbGl0cyklMEFmb3IlMjBpJTJDJTIwa2V5JTIwaW4lMjBlbnVtZXJhdGUocGFpcl9zY29yZXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX3Njb3JlcyU1QmtleSU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBpZiUyMGklMjAlM0UlM0QlMjA1JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`pair_scores = compute_pair_scores(splits)
<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_scores.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_scores[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ws=new m({props:{code:"KCdUJyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjEyNSUwQSgnJTIzJTIzaCclMkMlMjAnJTIzJTIzaScpJTNBJTIwMC4wMzQwOTA5MDkwOTA5MDkwOSUwQSgnJTIzJTIzaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4wMjcyNzI3MjcyNzI3MjcyNyUwQSgnaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4xJTBBKCd0JyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjAzNTcxNDI4NTcxNDI4NTcxJTBBKCclMjMlMjNoJyUyQyUyMCclMjMlMjNlJyklM0ElMjAwLjAxMTkwNDc2MTkwNDc2MTkwNA==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.125</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>): <span class="hljs-number">0.03409090909090909</span>
(<span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.02727272727272727</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.1</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.03571428571428571</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>): <span class="hljs-number">0.011904761904761904</span>`,wrap:!1}}),ds=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X3Njb3JlJTIwJTNEJTIwTm9uZSUwQWZvciUyMHBhaXIlMkMlMjBzY29yZSUyMGluJTIwcGFpcl9zY29yZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X3Njb3JlJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfc2NvcmUlMjAlM0MlMjBzY29yZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfc2NvcmUlMjAlM0QlMjBzY29yZSUwQSUwQXByaW50KGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_score = <span class="hljs-literal">None</span>
<span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> pair_scores.items():
    <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
        best_pair = pair
        max_score = score

<span class="hljs-built_in">print</span>(best_pair, max_score)`,wrap:!1}}),gs=new m({props:{code:"KCdhJyUyQyUyMCclMjMlMjNiJyklMjAwLjI=",highlighted:'(<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>) <span class="hljs-number">0.2</span>',wrap:!1}}),xs=new m({props:{code:"dm9jYWIuYXBwZW5kKCUyMmFiJTIyKQ==",highlighted:'vocab.append(<span class="hljs-string">&quot;ab&quot;</span>)',wrap:!1}}),Cs=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lcmdlJTIwJTNEJTIwYSUyMCUyQiUyMGIlNUIyJTNBJTVEJTIwaWYlMjBiLnN0YXJ0c3dpdGgoJTIyJTIzJTIzJTIyKSUyMGVsc2UlMjBhJTIwJTJCJTIwYiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCbWVyZ2UlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                merge = a + b[<span class="hljs-number">2</span>:] <span class="hljs-keyword">if</span> b.startswith(<span class="hljs-string">&quot;##&quot;</span>) <span class="hljs-keyword">else</span> a + b
                split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),ks=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjJhJTIyJTJDJTIwJTIyJTIzJTIzYiUyMiUyQyUyMHNwbGl0cyklMEFzcGxpdHMlNUIlMjJhYm91dCUyMiU1RA==",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;##b&quot;</span>, splits)
splits[<span class="hljs-string">&quot;about&quot;</span>]`,wrap:!1}}),$s=new m({props:{code:"JTVCJ2FiJyUyQyUyMCclMjMlMjNvJyUyQyUyMCclMjMlMjN1JyUyQyUyMCclMjMlMjN0JyU1RA==",highlighted:'[<span class="hljs-string">&#x27;ab&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>]',wrap:!1}}),zs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDcwJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9zY29yZXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSUyMCUzRCUyMCUyMiUyMiUyQyUyME5vbmUlMEElMjAlMjAlMjAlMjBmb3IlMjBwYWlyJTJDJTIwc2NvcmUlMjBpbiUyMHNjb3Jlcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtYXhfc2NvcmUlMjBpcyUyME5vbmUlMjBvciUyMG1heF9zY29yZSUyMCUzQyUyMHNjb3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9wYWlyJTIwJTNEJTIwcGFpciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9zY29yZSUyMCUzRCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG5ld190b2tlbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlNUIwJTVEJTIwJTJCJTIwYmVzdF9wYWlyJTVCMSU1RCU1QjIlM0ElNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGJlc3RfcGFpciU1QjElNUQuc3RhcnRzd2l0aCglMjIlMjMlMjMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHZvY2FiLmFwcGVuZChuZXdfdG9rZW4p",highlighted:`vocab_size = <span class="hljs-number">70</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    scores = compute_pair_scores(splits)
    best_pair, max_score = <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> scores.items():
        <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
            best_pair = pair
            max_score = score
    splits = merge_pair(*best_pair, splits)
    new_token = (
        best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>][<span class="hljs-number">2</span>:]
        <span class="hljs-keyword">if</span> best_pair[<span class="hljs-number">1</span>].startswith(<span class="hljs-string">&quot;##&quot;</span>)
        <span class="hljs-keyword">else</span> best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    )
    vocab.append(new_token)`,wrap:!1}}),Qs=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Bs=new m({props:{code:"JTVCJyU1QlBBRCU1RCclMkMlMjAnJTVCVU5LJTVEJyUyQyUyMCclNUJDTFMlNUQnJTJDJTIwJyU1QlNFUCU1RCclMkMlMjAnJTVCTUFTSyU1RCclMkMlMjAnJTIzJTIzYSclMkMlMjAnJTIzJTIzYiclMkMlMjAnJTIzJTIzYyclMkMlMjAnJTIzJTIzZCclMkMlMjAnJTIzJTIzZSclMkMlMjAnJTIzJTIzZiclMkMlMjAnJTIzJTIzZyclMkMlMjAnJTIzJTIzaCclMkMlMjAnJTIzJTIzaSclMkMlMjAnJTIzJTIzayclMkMlMEElMjAnJTIzJTIzbCclMkMlMjAnJTIzJTIzbSclMkMlMjAnJTIzJTIzbiclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzcCclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMjAnJTIzJTIzdCclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzdiclMkMlMjAnJTIzJTIzdyclMkMlMjAnJTIzJTIzeSclMkMlMjAnJTIzJTIzeiclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUwQSUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCdhYiclMkMlMjAnJTIzJTIzZnUnJTJDJTIwJ0ZhJyUyQyUyMCdGYWMnJTJDJTIwJyUyMyUyM2N0JyUyQyUyMCclMjMlMjNmdWwnJTJDJTIwJyUyMyUyM2Z1bGwnJTJDJTIwJyUyMyUyM2Z1bGx5JyUyQyUwQSUyMCdUaCclMkMlMjAnY2gnJTJDJTIwJyUyMyUyM2htJyUyQyUyMCdjaGEnJTJDJTIwJ2NoYXAnJTJDJTIwJ2NoYXB0JyUyQyUyMCclMjMlMjN0aG0nJTJDJTIwJ0h1JyUyQyUyMCdIdWcnJTJDJTIwJ0h1Z2cnJTJDJTIwJ3NoJyUyQyUyMCd0aCclMkMlMjAnaXMnJTJDJTIwJyUyMyUyM3RobXMnJTJDJTIwJyUyMyUyM3phJyUyQyUyMCclMjMlMjN6YXQnJTJDJTBBJTIwJyUyMyUyM3V0JyU1RA==",highlighted:`[<span class="hljs-string">&#x27;[PAD]&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>, <span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;[MASK]&#x27;</span>, <span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>,
 <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>,
 <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;ab&#x27;</span>, <span class="hljs-string">&#x27;##fu&#x27;</span>, <span class="hljs-string">&#x27;Fa&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##ct&#x27;</span>, <span class="hljs-string">&#x27;##ful&#x27;</span>, <span class="hljs-string">&#x27;##full&#x27;</span>, <span class="hljs-string">&#x27;##fully&#x27;</span>,
 <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;ch&#x27;</span>, <span class="hljs-string">&#x27;##hm&#x27;</span>, <span class="hljs-string">&#x27;cha&#x27;</span>, <span class="hljs-string">&#x27;chap&#x27;</span>, <span class="hljs-string">&#x27;chapt&#x27;</span>, <span class="hljs-string">&#x27;##thm&#x27;</span>, <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;Hug&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;sh&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;##thms&#x27;</span>, <span class="hljs-string">&#x27;##za&#x27;</span>, <span class="hljs-string">&#x27;##zat&#x27;</span>,
 <span class="hljs-string">&#x27;##ut&#x27;</span>]`,wrap:!1}}),x=new Ls({props:{$$slots:{default:[En]},$$scope:{ctx:w}}}),_s=new m({props:{code:"ZGVmJTIwZW5jb2RlX3dvcmQod29yZCklM0ElMEElMjAlMjAlMjAlMjB0b2tlbnMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjB3aGlsZSUyMGxlbih3b3JkKSUyMCUzRSUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwbGVuKHdvcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBpJTIwJTNFJTIwMCUyMGFuZCUyMHdvcmQlNUIlM0FpJTVEJTIwbm90JTIwaW4lMjB2b2NhYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAtJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMjIlNUJVTkslNUQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbnMuYXBwZW5kKHdvcmQlNUIlM0FpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjB3b3JkJTVCaSUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHdvcmQpJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjBmJTIyJTIzJTIzJTdCd29yZCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vucw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word</span>):
    tokens = []
    <span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
        i = <span class="hljs-built_in">len</span>(word)
        <span class="hljs-keyword">while</span> i &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> word[:i] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> vocab:
            i -= <span class="hljs-number">1</span>
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;[UNK]&quot;</span>]
        tokens.append(word[:i])
        word = word[i:]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
            word = <span class="hljs-string">f&quot;##<span class="hljs-subst">{word}</span>&quot;</span>
    <span class="hljs-keyword">return</span> tokens`,wrap:!1}}),Ss=new m({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySHVnZ2luZyUyMikpJTBBcHJpbnQoZW5jb2RlX3dvcmQoJTIySE9nZ2luZyUyMikp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hugging&quot;</span>))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;HOgging&quot;</span>))`,wrap:!1}}),Gs=new m({props:{code:"JTVCJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTVEJTBBJTVCJyU1QlVOSyU1RCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>]
[<span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),Ws=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBlbmNvZGVkX3dvcmRzJTIwJTNEJTIwJTVCZW5jb2RlX3dvcmQod29yZCklMjBmb3IlMjB3b3JkJTIwaW4lMjBwcmVfdG9rZW5pemVkX3RleHQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzdW0oZW5jb2RlZF93b3JkcyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    encoded_words = [encode_word(word) <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])`,wrap:!1}}),Hs=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UhJTIyKQ==",highlighted:'tokenize(<span class="hljs-string">&quot;This is the Hugging Face course!&quot;</span>)',wrap:!1}}),Rs=new m({props:{code:"JTVCJ1RoJyUyQyUyMCclMjMlMjNpJyUyQyUyMCclMjMlMjNzJyUyQyUyMCdpcyclMkMlMjAndGgnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTJDJTIwJ0ZhYyclMkMlMjAnJTIzJTIzZSclMkMlMjAnYyclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMEElMjAnJTIzJTIzZSclMkMlMjAnJTVCVU5LJTVEJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),Ds=new zn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/6.mdx"}}),{c(){p=j("meta"),U=t(),u=j("p"),T=t(),M(b.$$.fragment),Os=t(),M(C.$$.fragment),sl=t(),M(q.$$.fragment),ll=t(),k=j("p"),k.textContent=za,al=t(),M($.$$.fragment),nl=t(),M(I.$$.fragment),tl=t(),M(A.$$.fragment),el=t(),M(d.$$.fragment),pl=t(),z=j("p"),z.innerHTML=va,Ml=t(),M(v.$$.fragment),il=t(),Q=j("p"),Q.textContent=Qa,rl=t(),B=j("p"),$a=bn(`Then, again like BPE, WordPiece learns merge rules. The main difference is the way the pair to be merged is selected. Instead of selecting the most frequent pair, WordPiece computes a score for each pair, using the following formula:
`),yl=new Cn(!1),ol=t(),N=j("p"),N.innerHTML=Ba,cl=t(),Z=j("p"),Z.textContent=Na,jl=t(),M(_.$$.fragment),hl=t(),E=j("p"),E.textContent=Za,Jl=t(),M(S.$$.fragment),ul=t(),G=j("p"),G.innerHTML=_a,ml=t(),V=j("p"),V.innerHTML=Ea,Ul=t(),M(W.$$.fragment),Tl=t(),X=j("p"),X.innerHTML=Sa,wl=t(),M(H.$$.fragment),Il=t(),R=j("p"),R.innerHTML=Ga,dl=t(),M(Y.$$.fragment),gl=t(),D=j("p"),D.textContent=Va,fl=t(),M(g.$$.fragment),xl=t(),M(F.$$.fragment),bl=t(),P=j("p"),P.innerHTML=Wa,Cl=t(),L=j("p"),L.innerHTML=Xa,ql=t(),K=j("p"),K.innerHTML=Ha,kl=t(),O=j("p"),O.innerHTML=Ra,$l=t(),M(f.$$.fragment),Al=t(),M(ss.$$.fragment),zl=t(),ls=j("p"),ls.textContent=Ya,vl=t(),as=j("p"),as.textContent=Da,Ql=t(),M(ns.$$.fragment),Bl=t(),ts=j("p"),ts.innerHTML=Fa,Nl=t(),M(es.$$.fragment),Zl=t(),ps=j("p"),ps.textContent=Pa,_l=t(),M(Ms.$$.fragment),El=t(),M(is.$$.fragment),Sl=t(),rs=j("p"),rs.innerHTML=La,Gl=t(),M(ys.$$.fragment),Vl=t(),M(os.$$.fragment),Wl=t(),cs=j("p"),cs.innerHTML=Ka,Xl=t(),M(js.$$.fragment),Hl=t(),hs=j("p"),hs.innerHTML=Oa,Rl=t(),M(Js.$$.fragment),Yl=t(),us=j("p"),us.textContent=sn,Dl=t(),M(ms.$$.fragment),Fl=t(),Us=j("p"),Us.textContent=ln,Pl=t(),M(Ts.$$.fragment),Ll=t(),M(ws.$$.fragment),Kl=t(),Is=j("p"),Is.textContent=an,Ol=t(),M(ds.$$.fragment),sa=t(),M(gs.$$.fragment),la=t(),fs=j("p"),fs.innerHTML=nn,aa=t(),M(xs.$$.fragment),na=t(),bs=j("p"),bs.innerHTML=tn,ta=t(),M(Cs.$$.fragment),ea=t(),qs=j("p"),qs.textContent=en,pa=t(),M(ks.$$.fragment),Ma=t(),M($s.$$.fragment),ia=t(),As=j("p"),As.textContent=pn,ra=t(),M(zs.$$.fragment),ya=t(),vs=j("p"),vs.textContent=Mn,oa=t(),M(Qs.$$.fragment),ca=t(),M(Bs.$$.fragment),ja=t(),Ns=j("p"),Ns.textContent=rn,ha=t(),M(x.$$.fragment),Ja=t(),Zs=j("p"),Zs.textContent=yn,ua=t(),M(_s.$$.fragment),ma=t(),Es=j("p"),Es.textContent=on,Ua=t(),M(Ss.$$.fragment),Ta=t(),M(Gs.$$.fragment),wa=t(),Vs=j("p"),Vs.textContent=cn,Ia=t(),M(Ws.$$.fragment),da=t(),Xs=j("p"),Xs.textContent=jn,ga=t(),M(Hs.$$.fragment),fa=t(),M(Rs.$$.fragment),xa=t(),Ys=j("p"),Ys.textContent=hn,ba=t(),M(Ds.$$.fragment),Ca=t(),Ps=j("p"),this.h()},l(s){const l=qn("svelte-u9bgzb",document.head);p=h(l,"META",{name:!0,content:!0}),l.forEach(a),U=e(s),u=h(s,"P",{}),Aa(u).forEach(a),T=e(s),i(b.$$.fragment,s),Os=e(s),i(C.$$.fragment,s),sl=e(s),i(q.$$.fragment,s),ll=e(s),k=h(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1qentm6"&&(k.textContent=za),al=e(s),i($.$$.fragment,s),nl=e(s),i(I.$$.fragment,s),tl=e(s),i(A.$$.fragment,s),el=e(s),i(d.$$.fragment,s),pl=e(s),z=h(s,"P",{"data-svelte-h":!0}),J(z)!=="svelte-103h849"&&(z.innerHTML=va),Ml=e(s),i(v.$$.fragment,s),il=e(s),Q=h(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-pvxu6x"&&(Q.textContent=Qa),rl=e(s),B=h(s,"P",{});var Fs=Aa(B);$a=kn(Fs,`Then, again like BPE, WordPiece learns merge rules. The main difference is the way the pair to be merged is selected. Instead of selecting the most frequent pair, WordPiece computes a score for each pair, using the following formula:
`),yl=$n(Fs,!1),Fs.forEach(a),ol=e(s),N=h(s,"P",{"data-svelte-h":!0}),J(N)!=="svelte-7xl8bf"&&(N.innerHTML=Ba),cl=e(s),Z=h(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-1reb4z4"&&(Z.textContent=Na),jl=e(s),i(_.$$.fragment,s),hl=e(s),E=h(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-pb62xd"&&(E.textContent=Za),Jl=e(s),i(S.$$.fragment,s),ul=e(s),G=h(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-q0haar"&&(G.innerHTML=_a),ml=e(s),V=h(s,"P",{"data-svelte-h":!0}),J(V)!=="svelte-12rhmr5"&&(V.innerHTML=Ea),Ul=e(s),i(W.$$.fragment,s),Tl=e(s),X=h(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-151eli3"&&(X.innerHTML=Sa),wl=e(s),i(H.$$.fragment,s),Il=e(s),R=h(s,"P",{"data-svelte-h":!0}),J(R)!=="svelte-svusn0"&&(R.innerHTML=Ga),dl=e(s),i(Y.$$.fragment,s),gl=e(s),D=h(s,"P",{"data-svelte-h":!0}),J(D)!=="svelte-1vaqaxm"&&(D.textContent=Va),fl=e(s),i(g.$$.fragment,s),xl=e(s),i(F.$$.fragment,s),bl=e(s),P=h(s,"P",{"data-svelte-h":!0}),J(P)!=="svelte-v4c1z1"&&(P.innerHTML=Wa),Cl=e(s),L=h(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-x3syme"&&(L.innerHTML=Xa),ql=e(s),K=h(s,"P",{"data-svelte-h":!0}),J(K)!=="svelte-gkhun5"&&(K.innerHTML=Ha),kl=e(s),O=h(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-19tvv0p"&&(O.innerHTML=Ra),$l=e(s),i(f.$$.fragment,s),Al=e(s),i(ss.$$.fragment,s),zl=e(s),ls=h(s,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-148jv4w"&&(ls.textContent=Ya),vl=e(s),as=h(s,"P",{"data-svelte-h":!0}),J(as)!=="svelte-j22yiv"&&(as.textContent=Da),Ql=e(s),i(ns.$$.fragment,s),Bl=e(s),ts=h(s,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-1kypsn8"&&(ts.innerHTML=Fa),Nl=e(s),i(es.$$.fragment,s),Zl=e(s),ps=h(s,"P",{"data-svelte-h":!0}),J(ps)!=="svelte-1piuede"&&(ps.textContent=Pa),_l=e(s),i(Ms.$$.fragment,s),El=e(s),i(is.$$.fragment,s),Sl=e(s),rs=h(s,"P",{"data-svelte-h":!0}),J(rs)!=="svelte-g6680z"&&(rs.innerHTML=La),Gl=e(s),i(ys.$$.fragment,s),Vl=e(s),i(os.$$.fragment,s),Wl=e(s),cs=h(s,"P",{"data-svelte-h":!0}),J(cs)!=="svelte-9qkygh"&&(cs.innerHTML=Ka),Xl=e(s),i(js.$$.fragment,s),Hl=e(s),hs=h(s,"P",{"data-svelte-h":!0}),J(hs)!=="svelte-1k9a5j8"&&(hs.innerHTML=Oa),Rl=e(s),i(Js.$$.fragment,s),Yl=e(s),us=h(s,"P",{"data-svelte-h":!0}),J(us)!=="svelte-1mtlptv"&&(us.textContent=sn),Dl=e(s),i(ms.$$.fragment,s),Fl=e(s),Us=h(s,"P",{"data-svelte-h":!0}),J(Us)!=="svelte-h8brnl"&&(Us.textContent=ln),Pl=e(s),i(Ts.$$.fragment,s),Ll=e(s),i(ws.$$.fragment,s),Kl=e(s),Is=h(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-drj1oh"&&(Is.textContent=an),Ol=e(s),i(ds.$$.fragment,s),sa=e(s),i(gs.$$.fragment,s),la=e(s),fs=h(s,"P",{"data-svelte-h":!0}),J(fs)!=="svelte-1mufquv"&&(fs.innerHTML=nn),aa=e(s),i(xs.$$.fragment,s),na=e(s),bs=h(s,"P",{"data-svelte-h":!0}),J(bs)!=="svelte-1pmzgqr"&&(bs.innerHTML=tn),ta=e(s),i(Cs.$$.fragment,s),ea=e(s),qs=h(s,"P",{"data-svelte-h":!0}),J(qs)!=="svelte-d7zdjw"&&(qs.textContent=en),pa=e(s),i(ks.$$.fragment,s),Ma=e(s),i($s.$$.fragment,s),ia=e(s),As=h(s,"P",{"data-svelte-h":!0}),J(As)!=="svelte-vl065q"&&(As.textContent=pn),ra=e(s),i(zs.$$.fragment,s),ya=e(s),vs=h(s,"P",{"data-svelte-h":!0}),J(vs)!=="svelte-15nhah9"&&(vs.textContent=Mn),oa=e(s),i(Qs.$$.fragment,s),ca=e(s),i(Bs.$$.fragment,s),ja=e(s),Ns=h(s,"P",{"data-svelte-h":!0}),J(Ns)!=="svelte-15fyq8b"&&(Ns.textContent=rn),ha=e(s),i(x.$$.fragment,s),Ja=e(s),Zs=h(s,"P",{"data-svelte-h":!0}),J(Zs)!=="svelte-1pemxmn"&&(Zs.textContent=yn),ua=e(s),i(_s.$$.fragment,s),ma=e(s),Es=h(s,"P",{"data-svelte-h":!0}),J(Es)!=="svelte-1hqbv66"&&(Es.textContent=on),Ua=e(s),i(Ss.$$.fragment,s),Ta=e(s),i(Gs.$$.fragment,s),wa=e(s),Vs=h(s,"P",{"data-svelte-h":!0}),J(Vs)!=="svelte-1euf4wm"&&(Vs.textContent=cn),Ia=e(s),i(Ws.$$.fragment,s),da=e(s),Xs=h(s,"P",{"data-svelte-h":!0}),J(Xs)!=="svelte-mvn7u4"&&(Xs.textContent=jn),ga=e(s),i(Hs.$$.fragment,s),fa=e(s),i(Rs.$$.fragment,s),xa=e(s),Ys=h(s,"P",{"data-svelte-h":!0}),J(Ys)!=="svelte-1acligk"&&(Ys.textContent=hn),ba=e(s),i(Ds.$$.fragment,s),Ca=e(s),Ps=h(s,"P",{}),Aa(Ps).forEach(a),this.h()},h(){Tn(p,"name","hf:doc:metadata"),Tn(p,"content",Gn),yl.a=null},m(s,l){wn(document.head,p),n(s,U,l),n(s,u,l),n(s,T,l),r(b,s,l),n(s,Os,l),r(C,s,l),n(s,sl,l),r(q,s,l),n(s,ll,l),n(s,k,l),n(s,al,l),r($,s,l),n(s,nl,l),r(I,s,l),n(s,tl,l),r(A,s,l),n(s,el,l),r(d,s,l),n(s,pl,l),n(s,z,l),n(s,Ml,l),r(v,s,l),n(s,il,l),n(s,Q,l),n(s,rl,l),n(s,B,l),wn(B,$a),yl.m(In,B),n(s,ol,l),n(s,N,l),n(s,cl,l),n(s,Z,l),n(s,jl,l),r(_,s,l),n(s,hl,l),n(s,E,l),n(s,Jl,l),r(S,s,l),n(s,ul,l),n(s,G,l),n(s,ml,l),n(s,V,l),n(s,Ul,l),r(W,s,l),n(s,Tl,l),n(s,X,l),n(s,wl,l),r(H,s,l),n(s,Il,l),n(s,R,l),n(s,dl,l),r(Y,s,l),n(s,gl,l),n(s,D,l),n(s,fl,l),r(g,s,l),n(s,xl,l),r(F,s,l),n(s,bl,l),n(s,P,l),n(s,Cl,l),n(s,L,l),n(s,ql,l),n(s,K,l),n(s,kl,l),n(s,O,l),n(s,$l,l),r(f,s,l),n(s,Al,l),r(ss,s,l),n(s,zl,l),n(s,ls,l),n(s,vl,l),n(s,as,l),n(s,Ql,l),r(ns,s,l),n(s,Bl,l),n(s,ts,l),n(s,Nl,l),r(es,s,l),n(s,Zl,l),n(s,ps,l),n(s,_l,l),r(Ms,s,l),n(s,El,l),r(is,s,l),n(s,Sl,l),n(s,rs,l),n(s,Gl,l),r(ys,s,l),n(s,Vl,l),r(os,s,l),n(s,Wl,l),n(s,cs,l),n(s,Xl,l),r(js,s,l),n(s,Hl,l),n(s,hs,l),n(s,Rl,l),r(Js,s,l),n(s,Yl,l),n(s,us,l),n(s,Dl,l),r(ms,s,l),n(s,Fl,l),n(s,Us,l),n(s,Pl,l),r(Ts,s,l),n(s,Ll,l),r(ws,s,l),n(s,Kl,l),n(s,Is,l),n(s,Ol,l),r(ds,s,l),n(s,sa,l),r(gs,s,l),n(s,la,l),n(s,fs,l),n(s,aa,l),r(xs,s,l),n(s,na,l),n(s,bs,l),n(s,ta,l),r(Cs,s,l),n(s,ea,l),n(s,qs,l),n(s,pa,l),r(ks,s,l),n(s,Ma,l),r($s,s,l),n(s,ia,l),n(s,As,l),n(s,ra,l),r(zs,s,l),n(s,ya,l),n(s,vs,l),n(s,oa,l),r(Qs,s,l),n(s,ca,l),r(Bs,s,l),n(s,ja,l),n(s,Ns,l),n(s,ha,l),r(x,s,l),n(s,Ja,l),n(s,Zs,l),n(s,ua,l),r(_s,s,l),n(s,ma,l),n(s,Es,l),n(s,Ua,l),r(Ss,s,l),n(s,Ta,l),r(Gs,s,l),n(s,wa,l),n(s,Vs,l),n(s,Ia,l),r(Ws,s,l),n(s,da,l),n(s,Xs,l),n(s,ga,l),r(Hs,s,l),n(s,fa,l),r(Rs,s,l),n(s,xa,l),n(s,Ys,l),n(s,ba,l),r(Ds,s,l),n(s,Ca,l),n(s,Ps,l),qa=!0},p(s,[l]){const Fs={};l&2&&(Fs.$$scope={dirty:l,ctx:s}),I.$set(Fs);const Jn={};l&2&&(Jn.$$scope={dirty:l,ctx:s}),d.$set(Jn);const un={};l&2&&(un.$$scope={dirty:l,ctx:s}),g.$set(un);const mn={};l&2&&(mn.$$scope={dirty:l,ctx:s}),f.$set(mn);const Un={};l&2&&(Un.$$scope={dirty:l,ctx:s}),x.$set(Un)},i(s){qa||(y(b.$$.fragment,s),y(C.$$.fragment,s),y(q.$$.fragment,s),y($.$$.fragment,s),y(I.$$.fragment,s),y(A.$$.fragment,s),y(d.$$.fragment,s),y(v.$$.fragment,s),y(_.$$.fragment,s),y(S.$$.fragment,s),y(W.$$.fragment,s),y(H.$$.fragment,s),y(Y.$$.fragment,s),y(g.$$.fragment,s),y(F.$$.fragment,s),y(f.$$.fragment,s),y(ss.$$.fragment,s),y(ns.$$.fragment,s),y(es.$$.fragment,s),y(Ms.$$.fragment,s),y(is.$$.fragment,s),y(ys.$$.fragment,s),y(os.$$.fragment,s),y(js.$$.fragment,s),y(Js.$$.fragment,s),y(ms.$$.fragment,s),y(Ts.$$.fragment,s),y(ws.$$.fragment,s),y(ds.$$.fragment,s),y(gs.$$.fragment,s),y(xs.$$.fragment,s),y(Cs.$$.fragment,s),y(ks.$$.fragment,s),y($s.$$.fragment,s),y(zs.$$.fragment,s),y(Qs.$$.fragment,s),y(Bs.$$.fragment,s),y(x.$$.fragment,s),y(_s.$$.fragment,s),y(Ss.$$.fragment,s),y(Gs.$$.fragment,s),y(Ws.$$.fragment,s),y(Hs.$$.fragment,s),y(Rs.$$.fragment,s),y(Ds.$$.fragment,s),qa=!0)},o(s){o(b.$$.fragment,s),o(C.$$.fragment,s),o(q.$$.fragment,s),o($.$$.fragment,s),o(I.$$.fragment,s),o(A.$$.fragment,s),o(d.$$.fragment,s),o(v.$$.fragment,s),o(_.$$.fragment,s),o(S.$$.fragment,s),o(W.$$.fragment,s),o(H.$$.fragment,s),o(Y.$$.fragment,s),o(g.$$.fragment,s),o(F.$$.fragment,s),o(f.$$.fragment,s),o(ss.$$.fragment,s),o(ns.$$.fragment,s),o(es.$$.fragment,s),o(Ms.$$.fragment,s),o(is.$$.fragment,s),o(ys.$$.fragment,s),o(os.$$.fragment,s),o(js.$$.fragment,s),o(Js.$$.fragment,s),o(ms.$$.fragment,s),o(Ts.$$.fragment,s),o(ws.$$.fragment,s),o(ds.$$.fragment,s),o(gs.$$.fragment,s),o(xs.$$.fragment,s),o(Cs.$$.fragment,s),o(ks.$$.fragment,s),o($s.$$.fragment,s),o(zs.$$.fragment,s),o(Qs.$$.fragment,s),o(Bs.$$.fragment,s),o(x.$$.fragment,s),o(_s.$$.fragment,s),o(Ss.$$.fragment,s),o(Gs.$$.fragment,s),o(Ws.$$.fragment,s),o(Hs.$$.fragment,s),o(Rs.$$.fragment,s),o(Ds.$$.fragment,s),qa=!1},d(s){s&&(a(U),a(u),a(T),a(Os),a(sl),a(ll),a(k),a(al),a(nl),a(tl),a(el),a(pl),a(z),a(Ml),a(il),a(Q),a(rl),a(B),a(ol),a(N),a(cl),a(Z),a(jl),a(hl),a(E),a(Jl),a(ul),a(G),a(ml),a(V),a(Ul),a(Tl),a(X),a(wl),a(Il),a(R),a(dl),a(gl),a(D),a(fl),a(xl),a(bl),a(P),a(Cl),a(L),a(ql),a(K),a(kl),a(O),a($l),a(Al),a(zl),a(ls),a(vl),a(as),a(Ql),a(Bl),a(ts),a(Nl),a(Zl),a(ps),a(_l),a(El),a(Sl),a(rs),a(Gl),a(Vl),a(Wl),a(cs),a(Xl),a(Hl),a(hs),a(Rl),a(Yl),a(us),a(Dl),a(Fl),a(Us),a(Pl),a(Ll),a(Kl),a(Is),a(Ol),a(sa),a(la),a(fs),a(aa),a(na),a(bs),a(ta),a(ea),a(qs),a(pa),a(Ma),a(ia),a(As),a(ra),a(ya),a(vs),a(oa),a(ca),a(ja),a(Ns),a(ha),a(Ja),a(Zs),a(ua),a(ma),a(Es),a(Ua),a(Ta),a(wa),a(Vs),a(Ia),a(da),a(Xs),a(ga),a(fa),a(xa),a(Ys),a(ba),a(Ca),a(Ps)),a(p),c(b,s),c(C,s),c(q,s),c($,s),c(I,s),c(A,s),c(d,s),c(v,s),c(_,s),c(S,s),c(W,s),c(H,s),c(Y,s),c(g,s),c(F,s),c(f,s),c(ss,s),c(ns,s),c(es,s),c(Ms,s),c(is,s),c(ys,s),c(os,s),c(js,s),c(Js,s),c(ms,s),c(Ts,s),c(ws,s),c(ds,s),c(gs,s),c(xs,s),c(Cs,s),c(ks,s),c($s,s),c(zs,s),c(Qs,s),c(Bs,s),c(x,s),c(_s,s),c(Ss,s),c(Gs,s),c(Ws,s),c(Hs,s),c(Rs,s),c(Ds,s)}}}const Gn='{"title":"WordPiece tokenization","local":"wordpiece-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementing WordPiece","local":"implementing-wordpiece","sections":[],"depth":2}],"depth":1}';function Vn(w){return gn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends fn{constructor(p){super(),xn(this,p,Vn,Sn,dn,{})}}export{Pn as component};
