import{s as gn,o as Cn,n as jt}from"../chunks/scheduler.cc52f4b9.js";import{S as In,i as kn,e as p,s as n,c as m,q as ct,H as Ua,h as vn,a as o,d as e,b as l,f as dt,g as c,j as r,r as ht,u as da,k as Jn,l as T,m as a,n as h,t as M,o as u,p as y}from"../chunks/index.5b747fde.js";import{T as wt}from"../chunks/Tip.f0925d57.js";import{C as $n,H as Jt,E as qn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as xn}from"../chunks/Youtube.8bb4154e.js";import{C as j}from"../chunks/CodeBlock.665bfc37.js";import{C as An}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Zn(J){let i,U="💡 This section covers Unigram in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){i=p("p"),i.textContent=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-11nzsd1"&&(i.textContent=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function _n(J){let i,U="✏️ <strong>Now your turn!</strong> Write the code to compute the frequencies above and double-check that the results shown are correct, as well as the total sum.";return{c(){i=p("p"),i.innerHTML=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-kyc6dp"&&(i.innerHTML=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function zn(J){let i,U="✏️ <strong>Now your turn!</strong> Determine the tokenization of the word <code>&quot;huggun&quot;</code>, and its score.";return{c(){i=p("p"),i.innerHTML=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-zwh8th"&&(i.innerHTML=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function Nn(J){let i,U="💡 SentencePiece uses a more efficient algorithm called Enhanced Suffix Array (ESA) to create the initial vocabulary.";return{c(){i=p("p"),i.textContent=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1s00c64"&&(i.textContent=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function Vn(J){let i,U="💡 This approach is very inefficient, so SentencePiece uses an approximation of the loss of the model without token X: instead of starting from scratch, it just replaces token X by its segmentation in the vocabulary that is left. This way, all the scores can be computed at once at the same time as the model loss.";return{c(){i=p("p"),i.textContent=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-p8xm7n"&&(i.textContent=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function Qn(J){let i,U="The XLNetTokenizer uses SentencePiece which is why the <code>&quot;_&quot;</code> character is included. To decode with SentencePiece, concatenate all the tokens and replace <code>&quot;_&quot;</code> with a space.";return{c(){i=p("p"),i.innerHTML=U},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-nohclw"&&(i.innerHTML=U)},m(w,d){a(w,i,d)},p:jt,d(w){w&&e(i)}}}function Bn(J){let i,U,w,d,Z,bt,_,Tt,z,ft,N,Ja='The Unigram algorithm is used in combination with <a href="https://huggingface.co/papers/1808.06226" rel="nofollow">SentencePiece</a>, which is the tokenization algorithm used by models like AlBERT, T5, mBART, Big Bird, and XLNet.',gt,V,ba="SentencePiece addresses the fact that not all languages use spaces to separate words. Instead, SentencePiece treats the input as a raw input stream which includes the space in the set of characters to use. Then it can use the Unigram algorithm to construct the appropriate vocabulary.",Ct,Q,It,C,kt,B,vt,G,Ta="Compared to BPE and WordPiece, Unigram works in the other direction: it starts from a big vocabulary and removes tokens from it until it reaches the desired vocabulary size. There are several options to use to build that base vocabulary: we can take the most common substrings in pre-tokenized words, for instance, or apply BPE on the initial corpus with a large vocabulary size.",$t,S,fa="At each step of the training, the Unigram algorithm computes a loss over the corpus given the current vocabulary. Then, for each symbol in the vocabulary, the algorithm computes how much the overall loss would increase if the symbol was removed, and looks for the symbols that would increase it the least. Those symbols have a lower effect on the overall loss over the corpus, so in a sense they are “less needed” and are the best candidates for removal.",qt,I,ha,xt,bn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi></mrow><annotation encoding="application/x-tex">p</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">p</span></span></span></span>',At,Zt,R,ga="Note that we never remove the base characters, to make sure any word can be tokenized.",_t,H,Ca="Now, this is still a bit vague: the main part of the algorithm is to compute a loss over the corpus and see how it changes when we remove some tokens from the vocabulary, but we haven’t explained how to do this yet. This step relies on the tokenization algorithm of a Unigram model, so we’ll dive into this next.",zt,E,Ia="We’ll reuse the corpus from the previous examples:",Nt,X,Vt,W,ka="and for this example, we will take all strict substrings for the initial vocabulary :",Qt,K,Bt,Y,Gt,P,va="A Unigram model is a type of language model that considers each token to be independent of the tokens before it. It’s the simplest language model, in the sense that the probability of token X given the previous context is just the probability of token X. So, if we used a Unigram language model to generate text, we would always predict the most common token.",St,D,$a="The probability of a given token is its frequency (the number of times we find it) in the original corpus, divided by the sum of all frequencies of all tokens in the vocabulary (to make sure the probabilities sum up to 1). For instance, <code>&quot;ug&quot;</code> is present in <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, and <code>&quot;hugs&quot;</code>, so it has a frequency of 20 in our corpus.",Rt,F,qa="Here are the frequencies of all the possible subwords in the vocabulary:",Ht,L,Et,O,xa="So, the sum of all frequencies is 210, and the probability of the subword <code>&quot;ug&quot;</code> is thus 20/210.",Xt,k,Wt,b,Ma,Mt,Aa='["p", "u", "g"]',ua,ut,Za='"pug"',ya,Kt,Tn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>36</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.000389</mn></mrow><annotation encoding="application/x-tex">P([``p&quot;, ``u&quot;, ``g&quot;]) = P(``p&quot;) \\times P(``u&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{36}{210} \\times \\frac{20}{210} = 0.000389</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">36</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.000389</span></span></span></span></span>',Yt,g,wa,yt,_a='["pu", "g"]',ja,Pt,fn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.0022676</mn></mrow><annotation encoding="application/x-tex">P([``pu&quot;, ``g&quot;]) = P(``pu&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{20}{210} = 0.0022676</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.0022676</span></span></span></span></span>',Dt,ss,za="so that one is way more likely. In general, tokenizations with the least tokens possible will have the highest probability (because of that division by 210 repeated for each token), which corresponds to what we want intuitively: to split a word into the least number of tokens possible.",Ft,ts,Na="The tokenization of a word with the Unigram model is then the tokenization with the highest probability. In the example of <code>&quot;pug&quot;</code>, here are the probabilities we would get for each possible segmentation:",Lt,es,Ot,as,Va="So, <code>&quot;pug&quot;</code> would be tokenized as <code>[&quot;p&quot;, &quot;ug&quot;]</code> or <code>[&quot;pu&quot;, &quot;g&quot;]</code>, depending on which of those segmentations is encountered first (note that in a larger corpus, equality cases like this will be rare).",se,ns,Qa="In this case, it was easy to find all the possible segmentations and compute their probabilities, but in general it’s going to be a bit harder. There is a classic algorithm used for this, called the <em>Viterbi algorithm</em>. Essentially, we can build a graph to detect the possible segmentations of a given word by saying there is a branch from character <em>a</em> to character <em>b</em> if the subword from <em>a</em> to <em>b</em> is in the vocabulary, and attribute to that branch the probability of the subword.",te,ls,Ba="To find the path in that graph that is going to have the best score the Viterbi algorithm determines, for each position in the word, the segmentation with the best score that ends at that position. Since we go from the beginning to the end, that best score can be found by looping through all subwords ending at the current position and then using the best tokenization score from the position this subword begins at. Then, we just have to unroll the path taken to arrive at the end.",ee,ps,Ga="Let’s take a look at an example using our vocabulary and the word <code>&quot;unhug&quot;</code>. For each position, the subwords with the best scores ending there are the following:",ae,os,ne,is,Sa="Thus <code>&quot;unhug&quot;</code> would be tokenized as <code>[&quot;un&quot;, &quot;hug&quot;]</code>.",le,v,pe,rs,oe,ms,Ra="Now that we have seen how the tokenization works, we can dive a little more deeply into the loss used during training. At any given stage, this loss is computed by tokenizing every word in the corpus, using the current vocabulary and the Unigram model determined by the frequencies of each token in the corpus (as seen before).",ie,cs,Ha="Each word in the corpus has a score, and the loss is the negative log likelihood of those scores — that is, the sum for all the words in the corpus of all the <code>-log(P(word))</code>.",re,hs,Ea="Let’s go back to our example with the following corpus:",me,Ms,ce,us,Xa="The tokenization of each word with their respective scores is:",he,ys,Me,ws,Wa="So the loss is:",ue,js,ye,Us,Ka="Now we need to compute how removing each token affects the loss. This is rather tedious, so we’ll just do it for two tokens here and save the whole process for when we have code to help us. In this (very) particular case, we had two equivalent tokenizations of all the words: as we saw earlier, for example, <code>&quot;pug&quot;</code> could be tokenized <code>[&quot;p&quot;, &quot;ug&quot;]</code> with the same score. Thus, removing the <code>&quot;pu&quot;</code> token from the vocabulary will give the exact same loss.",we,ds,Ya="On the other hand, removing <code>&quot;hug&quot;</code> will make the loss worse, because the tokenization of <code>&quot;hug&quot;</code> and <code>&quot;hugs&quot;</code> will become:",je,Js,Ue,bs,Pa="These changes will cause the loss to rise by:",de,Ts,Je,fs,Da="Therefore, the token <code>&quot;pu&quot;</code> will probably be removed from the vocabulary, but not <code>&quot;hug&quot;</code>.",be,gs,Te,Cs,Fa="Now let’s implement everything we’ve seen so far in code. Like with BPE and WordPiece, this is not an efficient implementation of the Unigram algorithm (quite the opposite), but it should help you understand it a bit better.",fe,Is,La="We will use the same corpus as before as an example:",ge,ks,Ce,vs,Oa="This time, we will use <code>xlnet-base-cased</code> as our model:",Ie,$s,ke,qs,sn="Like for BPE and WordPiece, we begin by counting the number of occurrences of each word in the corpus:",ve,xs,$e,As,tn="Then, we need to initialize our vocabulary to something larger than the vocab size we will want at the end. We have to include all the basic characters (otherwise we won’t be able to tokenize every word), but for the bigger substrings we’ll only keep the most common ones, so we sort them by frequency:",qe,Zs,xe,_s,Ae,zs,en="We group the characters with the best subwords to arrive at an initial vocabulary of size 300:",Ze,Ns,_e,$,ze,Vs,an="Next, we compute the sum of all frequencies, to convert the frequencies into probabilities. For our model we will store the logarithms of the probabilities, because it’s more numerically stable to add logarithms than to multiply small numbers, and this will simplify the computation of the loss of the model:",Ne,Qs,Ve,Bs,nn="Now the main function is the one that tokenizes words using the Viterbi algorithm. As we saw before, that algorithm computes the best segmentation of each substring of the word, which we will store in a variable named <code>best_segmentations</code>. We will store one dictionary per position in the word (from 0 to its total length), with two keys: the index of the start of the last token in the best segmentation, and the score of the best segmentation. With the index of the start of the last token, we will be able to retrieve the full segmentation once the list is completely populated.",Qe,Gs,ln="Populating the list is done with just two loops: the main loop goes over each start position, and the second loop tries all substrings beginning at that start position. If the substring is in the vocabulary, we have a new segmentation of the word up until that end position, which we compare to what is in <code>best_segmentations</code>.",Be,Ss,pn="Once the main loop is finished, we just start from the end and hop from one start position to the next, recording the tokens as we go, until we reach the start of the word:",Ge,Rs,Se,Hs,on="We can already try our initial model on some words:",Re,Es,He,Xs,Ee,Ws,rn="Now it’s easy to compute the loss of the model on the corpus!",Xe,Ks,We,Ys,mn="We can check it works on the model we have:",Ke,Ps,Ye,Ds,Pe,Fs,cn="Computing the scores for each token is not very hard either; we just have to compute the loss for the models obtained by deleting each token:",De,Ls,Fe,Os,hn="We can try it on a given token:",Le,st,Oe,tt,Mn="Since <code>&quot;ll&quot;</code> is used in the tokenization of <code>&quot;Hopefully&quot;</code>, and removing it will probably make us use the token <code>&quot;l&quot;</code> twice instead, we expect it will have a positive loss. <code>&quot;his&quot;</code> is only used inside the word <code>&quot;This&quot;</code>, which is tokenized as itself, so we expect it to have a zero loss. Here are the results:",sa,et,ta,q,ea,at,un="With all of this in place, the last thing we need to do is add the special tokens used by the model to the vocabulary, then loop until we have pruned enough tokens from the vocabulary to reach our desired size:",aa,nt,na,lt,yn="Then, to tokenize some text, we just need to apply the pre-tokenization and then use our <code>encode_word()</code> function:",la,pt,pa,ot,oa,x,ia,it,wn="That’s it for Unigram! Hopefully by now you’re feeling like an expert in all things tokenizer. In the next section, we will delve into the building blocks of the 🤗 Tokenizers library, and show you how you can use them to build your own tokenizer.",ra,rt,ma,Ut,ca;return Z=new $n({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new Jt({props:{title:"Unigram tokenization",local:"unigram-tokenization",headingTag:"h1"}}),z=new An({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"}]}}),Q=new xn({props:{id:"TGZfZVuF9Yc"}}),C=new wt({props:{$$slots:{default:[Zn]},$$scope:{ctx:J}}}),B=new Jt({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),X=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),K=new j({props:{code:"JTVCJTIyaCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaHUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJwdSUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJ1biUyMiUyQyUyMCUyMmIlMjIlMkMlMjAlMjJidSUyMiUyQyUyMCUyMnMlMjIlMkMlMjAlMjJodWclMjIlMkMlMjAlMjJncyUyMiUyQyUyMCUyMnVncyUyMiU1RA==",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>, <span class="hljs-string">&quot;ugs&quot;</span>]</span>',wrap:!1}}),Y=new Jt({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),L=new j({props:{code:"KCUyMmglMjIlMkMlMjAxNSklMjAoJTIydSUyMiUyQyUyMDM2KSUyMCglMjJnJTIyJTJDJTIwMjApJTIwKCUyMmh1JTIyJTJDJTIwMTUpJTIwKCUyMnVnJTIyJTJDJTIwMjApJTIwKCUyMnAlMjIlMkMlMjAxNyklMjAoJTIycHUlMjIlMkMlMjAxNyklMjAoJTIybiUyMiUyQyUyMDE2KSUwQSglMjJ1biUyMiUyQyUyMDE2KSUyMCglMjJiJTIyJTJDJTIwNCklMjAoJTIyYnUlMjIlMkMlMjA0KSUyMCglMjJzJTIyJTJDJTIwNSklMjAoJTIyaHVnJTIyJTJDJTIwMTUpJTIwKCUyMmdzJTIyJTJDJTIwNSklMjAoJTIydWdzJTIyJTJDJTIwNSk=",highlighted:`(<span class="hljs-string">&quot;h&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;u&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">36</span>) (<span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;hu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;p&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;pu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>)
(<span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>) (<span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;bu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;gs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;ugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)`,wrap:!1}}),k=new wt({props:{$$slots:{default:[_n]},$$scope:{ctx:J}}}),es=new j({props:{code:"JTVCJTIycCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwJTNBJTIwMC4wMDAzODklMEElNUIlMjJwJTIyJTJDJTIwJTIydWclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzYlMEElNUIlMjJwdSUyMiUyQyUyMCUyMmclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzY=",highlighted:`[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.000389
[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>] : 0.0022676
[<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.0022676`,wrap:!1}}),os=new j({props:{code:"Q2hhcmFjdGVyJTIwMCUyMCh1KSUzQSUyMCUyMnUlMjIlMjAoc2NvcmUlMjAwLjE3MTQyOSklMEFDaGFyYWN0ZXIlMjAxJTIwKG4pJTNBJTIwJTIydW4lMjIlMjAoc2NvcmUlMjAwLjA3NjE5MSklMEFDaGFyYWN0ZXIlMjAyJTIwKGgpJTNBJTIwJTIydW4lMjIlMjAlMjJoJTIyJTIwKHNjb3JlJTIwMC4wMDU0NDIpJTBBQ2hhcmFjdGVyJTIwMyUyMCh1KSUzQSUyMCUyMnVuJTIyJTIwJTIyaHUlMjIlMjAoc2NvcmUlMjAwLjAwNTQ0MiklMEFDaGFyYWN0ZXIlMjA0JTIwKGcpJTNBJTIwJTIydW4lMjIlMjAlMjJodWclMjIlMjAoc2NvcmUlMjAwLjAwNTQ0Mik=",highlighted:`<span class="hljs-attribute">Character</span> <span class="hljs-number">0</span> (u): <span class="hljs-string">&quot;u&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">171429</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">1</span> (n): <span class="hljs-string">&quot;un&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">076191</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">2</span> (h): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;h&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">3</span> (u): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hu&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">4</span> (g): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hug&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)`,wrap:!1}}),v=new wt({props:{$$slots:{default:[zn]},$$scope:{ctx:J}}}),rs=new Jt({props:{title:"Back to training",local:"back-to-training",headingTag:"h2"}}),Ms=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),ys=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHVnJTIyJTVEJTIwKHNjb3JlJTIwMC4wNzE0MjgpJTBBJTIycHVnJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDc3MTApJTBBJTIycHVuJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDYxNjgpJTBBJTIyYnVuJTIyJTNBJTIwJTVCJTIyYnUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDE0NTEpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1ZyUyMiUyQyUyMCUyMnMlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>] <span class="hljs-comment">(score 0.071428)</span>
<span class="hljs-string">&quot;pug&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.007710)</span>
<span class="hljs-string">&quot;pun&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.006168)</span>
<span class="hljs-string">&quot;bun&quot;</span>: [<span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.001451)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),js=new j({props:{code:"MTAlMjAqJTIwKC1sb2coMC4wNzE0MjgpKSUyMCUyQiUyMDUlMjAqJTIwKC1sb2coMC4wMDc3MTApKSUyMCUyQiUyMDEyJTIwKiUyMCgtbG9nKDAuMDA2MTY4KSklMjAlMkIlMjA0JTIwKiUyMCgtbG9nKDAuMDAxNDUxKSklMjAlMkIlMjA1JTIwKiUyMCgtbG9nKDAuMDAxNzAxKSklMjAlM0QlMjAxNjkuOA==",highlighted:'<span class="hljs-attribute">10</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">071428</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">007710</span>)) + <span class="hljs-number">12</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">006168</span>)) + <span class="hljs-number">4</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001451</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001701</span>)) = <span class="hljs-number">169</span>.<span class="hljs-number">8</span>',wrap:!1}}),Js=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDY4MDIpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1JTIyJTJDJTIwJTIyZ3MlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.006802)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),Ts=new j({props:{code:"LSUyMDEwJTIwKiUyMCgtbG9nKDAuMDcxNDI4KSklMjAlMkIlMjAxMCUyMColMjAoLWxvZygwLjAwNjgwMikpJTIwJTNEJTIwMjMuNQ==",highlighted:'- <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.071428</span>)) + <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.006802</span>)) = <span class="hljs-number">23.5</span>',wrap:!1}}),gs=new Jt({props:{title:"Implementing Unigram",local:"implementing-unigram",headingTag:"h2"}}),ks=new j({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),$s=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG5ldC1iYXNlLWNhc2VkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet-base-cased&quot;</span>)`,wrap:!1}}),xs=new j({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),Zs=new j({props:{code:"Y2hhcl9mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFzdWJ3b3Jkc19mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFmb3IlMjB3b3JkJTJDJTIwZnJlcSUyMGluJTIwd29yZF9mcmVxcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKHdvcmQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNoYXJfZnJlcXMlNUJ3b3JkJTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMb29wJTIwdGhyb3VnaCUyMHRoZSUyMHN1YndvcmRzJTIwb2YlMjBsZW5ndGglMjBhdCUyMGxlYXN0JTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGolMjBpbiUyMHJhbmdlKGklMjAlMkIlMjAyJTJDJTIwbGVuKHdvcmQpJTIwJTJCJTIwMSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdWJ3b3Jkc19mcmVxcyU1QndvcmQlNUJpJTNBaiU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMEElMjMlMjBTb3J0JTIwc3Vid29yZHMlMjBieSUyMGZyZXF1ZW5jeSUwQXNvcnRlZF9zdWJ3b3JkcyUyMCUzRCUyMHNvcnRlZChzdWJ3b3Jkc19mcmVxcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc29ydGVkX3N1YndvcmRzJTVCJTNBMTAlNUQ=",highlighted:`char_freqs = defaultdict(<span class="hljs-built_in">int</span>)
subwords_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        char_freqs[word[i]] += freq
        <span class="hljs-comment"># Loop through the subwords of length at least 2</span>
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(i + <span class="hljs-number">2</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            subwords_freqs[word[i:j]] += freq

<span class="hljs-comment"># Sort subwords by frequency</span>
sorted_subwords = <span class="hljs-built_in">sorted</span>(subwords_freqs.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>], reverse=<span class="hljs-literal">True</span>)
sorted_subwords[:<span class="hljs-number">10</span>]`,wrap:!1}}),_s=new j({props:{code:"JTVCKCclRTIlOTYlODF0JyUyQyUyMDcpJTJDJTIwKCdpcyclMkMlMjA1KSUyQyUyMCgnZXInJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MWEnJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MXRvJyUyQyUyMDQpJTJDJTIwKCd0byclMkMlMjA0KSUyQyUyMCgnZW4nJTJDJTIwNCklMkMlMjAoJyVFMiU5NiU4MVQnJTJDJTIwMyklMkMlMjAoJyVFMiU5NiU4MVRoJyUyQyUyMDMpJTJDJTIwKCclRTIlOTYlODFUaGknJTJDJTIwMyklNUQ=",highlighted:'[(<span class="hljs-string">&#x27;▁t&#x27;</span>, <span class="hljs-number">7</span>), (<span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁a&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;▁T&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Th&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Thi&#x27;</span>, <span class="hljs-number">3</span>)]',wrap:!1}}),Ns=new j({props:{code:"dG9rZW5fZnJlcXMlMjAlM0QlMjBsaXN0KGNoYXJfZnJlcXMuaXRlbXMoKSklMjAlMkIlMjBzb3J0ZWRfc3Vid29yZHMlNUIlM0ElMjAzMDAlMjAtJTIwbGVuKGNoYXJfZnJlcXMpJTVEJTBBdG9rZW5fZnJlcXMlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMGZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzJTdE",highlighted:`token_freqs = <span class="hljs-built_in">list</span>(char_freqs.items()) + sorted_subwords[: <span class="hljs-number">300</span> - <span class="hljs-built_in">len</span>(char_freqs)]
token_freqs = {token: freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs}`,wrap:!1}}),$=new wt({props:{$$slots:{default:[Nn]},$$scope:{ctx:J}}}),Qs=new j({props:{code:"ZnJvbSUyMG1hdGglMjBpbXBvcnQlMjBsb2clMEElMEF0b3RhbF9zdW0lMjAlM0QlMjBzdW0oJTVCZnJlcSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU1RCklMEFtb2RlbCUyMCUzRCUyMCU3QnRva2VuJTNBJTIwLWxvZyhmcmVxJTIwJTJGJTIwdG90YWxfc3VtKSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU3RA==",highlighted:`<span class="hljs-keyword">from</span> math <span class="hljs-keyword">import</span> log

total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),Rs=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word, model</span>):
    best_segmentations = [{<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}] + [
        {<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-literal">None</span>} <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word))
    ]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        <span class="hljs-comment"># This should be properly filled by the previous steps of the loop</span>
        best_score_at_start = best_segmentations[start_idx][<span class="hljs-string">&quot;score&quot;</span>]
        <span class="hljs-keyword">for</span> end_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(start_idx + <span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            token = word[start_idx:end_idx]
            <span class="hljs-keyword">if</span> token <span class="hljs-keyword">in</span> model <span class="hljs-keyword">and</span> best_score_at_start <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                score = model[token] + best_score_at_start
                <span class="hljs-comment"># If we have found a better segmentation ending at end_idx, we update</span>
                <span class="hljs-keyword">if</span> (
                    best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
                    <span class="hljs-keyword">or</span> best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] &gt; score
                ):
                    best_segmentations[end_idx] = {<span class="hljs-string">&quot;start&quot;</span>: start_idx, <span class="hljs-string">&quot;score&quot;</span>: score}

    segmentation = best_segmentations[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">if</span> segmentation[<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-comment"># We did not find a tokenization of the word -&gt; unknown</span>
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>], <span class="hljs-literal">None</span>

    score = segmentation[<span class="hljs-string">&quot;score&quot;</span>]
    start = segmentation[<span class="hljs-string">&quot;start&quot;</span>]
    end = <span class="hljs-built_in">len</span>(word)
    tokens = []
    <span class="hljs-keyword">while</span> start != <span class="hljs-number">0</span>:
        tokens.insert(<span class="hljs-number">0</span>, word[start:end])
        next_start = best_segmentations[start][<span class="hljs-string">&quot;start&quot;</span>]
        end = start
        start = next_start
    tokens.insert(<span class="hljs-number">0</span>, word[start:end])
    <span class="hljs-keyword">return</span> tokens, score`,wrap:!1}}),Es=new j({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySG9wZWZ1bGx5JTIyJTJDJTIwbW9kZWwpKSUwQXByaW50KGVuY29kZV93b3JkKCUyMlRoaXMlMjIlMkMlMjBtb2RlbCkp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hopefully&quot;</span>, model))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;This&quot;</span>, model))`,wrap:!1}}),Xs=new j({props:{code:"KCU1QidIJyUyQyUyMCdvJyUyQyUyMCdwJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCd1JyUyQyUyMCdsbCclMkMlMjAneSclNUQlMkMlMjA0MS41MTU3NDk0NjAxNDAyKSUwQSglNUInVGhpcyclNUQlMkMlMjA2LjI4ODI2NzAzMDY5NDUzNSk=",highlighted:`([<span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;ll&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>], <span class="hljs-number">41.5157494601402</span>)
([<span class="hljs-string">&#x27;This&#x27;</span>], <span class="hljs-number">6.288267030694535</span>)`,wrap:!1}}),Ks=new j({props:{code:"ZGVmJTIwY29tcHV0ZV9sb3NzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMkMlMjB3b3JkX2xvc3MlMjAlM0QlMjBlbmNvZGVfd29yZCh3b3JkJTJDJTIwbW9kZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUyQiUzRCUyMGZyZXElMjAqJTIwd29yZF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">model</span>):
    loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        _, word_loss = encode_word(word, model)
        loss += freq * word_loss
    <span class="hljs-keyword">return</span> loss`,wrap:!1}}),Ps=new j({props:{code:"Y29tcHV0ZV9sb3NzKG1vZGVsKQ==",highlighted:"compute_loss(model)",wrap:!1}}),Ds=new j({props:{code:"NDEzLjEwMzc3NjQyOTQwODc1",highlighted:'<span class="hljs-number">413.10377642940875</span>',wrap:!1}}),Ls=new j({props:{code:"aW1wb3J0JTIwY29weSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfc2NvcmVzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2xvc3MlMjAlM0QlMjBjb21wdXRlX2xvc3MobW9kZWwpJTBBJTIwJTIwJTIwJTIwZm9yJTIwdG9rZW4lMkMlMjBzY29yZSUyMGluJTIwbW9kZWwuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwYWx3YXlzJTIwa2VlcCUyMHRva2VucyUyMG9mJTIwbGVuZ3RoJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHRva2VuKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3dpdGhvdXRfdG9rZW4lMjAlM0QlMjBjb3B5LmRlZXBjb3B5KG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbF93aXRob3V0X3Rva2VuLnBvcCh0b2tlbiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY29yZXMlNUJ0b2tlbiU1RCUyMCUzRCUyMGNvbXB1dGVfbG9zcyhtb2RlbF93aXRob3V0X3Rva2VuKSUyMC0lMjBtb2RlbF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-keyword">import</span> copy


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_scores</span>(<span class="hljs-params">model</span>):
    scores = {}
    model_loss = compute_loss(model)
    <span class="hljs-keyword">for</span> token, score <span class="hljs-keyword">in</span> model.items():
        <span class="hljs-comment"># We always keep tokens of length 1</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(token) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        model_without_token = copy.deepcopy(model)
        _ = model_without_token.pop(token)
        scores[token] = compute_loss(model_without_token) - model_loss
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),st=new j({props:{code:"c2NvcmVzJTIwJTNEJTIwY29tcHV0ZV9zY29yZXMobW9kZWwpJTBBcHJpbnQoc2NvcmVzJTVCJTIybGwlMjIlNUQpJTBBcHJpbnQoc2NvcmVzJTVCJTIyaGlzJTIyJTVEKQ==",highlighted:`scores = compute_scores(model)
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;ll&quot;</span>])
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;his&quot;</span>])`,wrap:!1}}),et=new j({props:{code:"Ni4zNzY0MTI0MDM2MjM4NzQlMEEwLjA=",highlighted:`<span class="hljs-number">6.376412403623874</span>
<span class="hljs-number">0.0</span>`,wrap:!1}}),q=new wt({props:{$$slots:{default:[Vn]},$$scope:{ctx:J}}}),nt=new j({props:{code:"cGVyY2VudF90b19yZW1vdmUlMjAlM0QlMjAwLjElMEF3aGlsZSUyMGxlbihtb2RlbCklMjAlM0UlMjAxMDAlM0ElMEElMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjBjb21wdXRlX3Njb3Jlcyhtb2RlbCklMEElMjAlMjAlMjAlMjBzb3J0ZWRfc2NvcmVzJTIwJTNEJTIwc29ydGVkKHNjb3Jlcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlbW92ZSUyMHBlcmNlbnRfdG9fcmVtb3ZlJTIwdG9rZW5zJTIwd2l0aCUyMHRoZSUyMGxvd2VzdCUyMHNjb3Jlcy4lMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShpbnQobGVuKG1vZGVsKSUyMColMjBwZXJjZW50X3RvX3JlbW92ZSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyUyMCUzRCUyMHRva2VuX2ZyZXFzLnBvcChzb3J0ZWRfc2NvcmVzJTVCaSU1RCU1QjAlNUQpJTBBJTBBJTIwJTIwJTIwJTIwdG90YWxfc3VtJTIwJTNEJTIwc3VtKCU1QmZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklNUQpJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMC1sb2coZnJlcSUyMCUyRiUyMHRvdGFsX3N1bSklMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklN0Q=",highlighted:`percent_to_remove = <span class="hljs-number">0.1</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(model) &gt; <span class="hljs-number">100</span>:
    scores = compute_scores(model)
    sorted_scores = <span class="hljs-built_in">sorted</span>(scores.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>])
    <span class="hljs-comment"># Remove percent_to_remove tokens with the lowest scores.</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">int</span>(<span class="hljs-built_in">len</span>(model) * percent_to_remove)):
        _ = token_freqs.pop(sorted_scores[i][<span class="hljs-number">0</span>])

    total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
    model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),pt=new j({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVkX3RleHQlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZW5jb2RlZF93b3JkcyUyMCUzRCUyMCU1QmVuY29kZV93b3JkKHdvcmQlMkMlMjBtb2RlbCklNUIwJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwcHJlX3Rva2VuaXplZF90ZXh0JTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKGVuY29kZWRfd29yZHMlMkMlMjAlNUIlNUQpJTBBJTBBJTBBdG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTIwbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text, model</span>):
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    encoded_words = [encode_word(word, model)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])


tokenize(<span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>, model)`,wrap:!1}}),ot=new j({props:{code:"JTVCJyVFMiU5NiU4MVRoaXMnJTJDJTIwJyVFMiU5NiU4MWlzJyUyQyUyMCclRTIlOTYlODF0aGUnJTJDJTIwJyVFMiU5NiU4MUh1Z2dpbmcnJTJDJTIwJyVFMiU5NiU4MUZhY2UnJTJDJTIwJyVFMiU5NiU4MSclMkMlMjAnYyclMkMlMjAnb3UnJTJDJTIwJ3InJTJDJTIwJ3MnJTJDJTIwJ2UnJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁This&#x27;</span>, <span class="hljs-string">&#x27;▁is&#x27;</span>, <span class="hljs-string">&#x27;▁the&#x27;</span>, <span class="hljs-string">&#x27;▁Hugging&#x27;</span>, <span class="hljs-string">&#x27;▁Face&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),x=new wt({props:{$$slots:{default:[Qn]},$$scope:{ctx:J}}}),rt=new qn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/7.mdx"}}),{c(){i=p("meta"),U=n(),w=p("p"),d=n(),m(Z.$$.fragment),bt=n(),m(_.$$.fragment),Tt=n(),m(z.$$.fragment),ft=n(),N=p("p"),N.innerHTML=Ja,gt=n(),V=p("p"),V.textContent=ba,Ct=n(),m(Q.$$.fragment),It=n(),m(C.$$.fragment),kt=n(),m(B.$$.fragment),vt=n(),G=p("p"),G.textContent=Ta,$t=n(),S=p("p"),S.textContent=fa,qt=n(),I=p("p"),ha=ct("This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),xt=new Ua(!1),At=ct(" (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),Zt=n(),R=p("p"),R.textContent=ga,_t=n(),H=p("p"),H.textContent=Ca,zt=n(),E=p("p"),E.textContent=Ia,Nt=n(),m(X.$$.fragment),Vt=n(),W=p("p"),W.textContent=ka,Qt=n(),m(K.$$.fragment),Bt=n(),m(Y.$$.fragment),Gt=n(),P=p("p"),P.textContent=va,St=n(),D=p("p"),D.innerHTML=$a,Rt=n(),F=p("p"),F.textContent=qa,Ht=n(),m(L.$$.fragment),Et=n(),O=p("p"),O.innerHTML=xa,Xt=n(),m(k.$$.fragment),Wt=n(),b=p("p"),Ma=ct("Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),Mt=p("code"),Mt.textContent=Aa,ua=ct(" of "),ut=p("code"),ut.textContent=Za,ya=ct(` has the probability:
`),Kt=new Ua(!1),Yt=n(),g=p("p"),wa=ct("Comparatively, the tokenization "),yt=p("code"),yt.textContent=_a,ja=ct(` has the probability:
`),Pt=new Ua(!1),Dt=n(),ss=p("p"),ss.textContent=za,Ft=n(),ts=p("p"),ts.innerHTML=Na,Lt=n(),m(es.$$.fragment),Ot=n(),as=p("p"),as.innerHTML=Va,se=n(),ns=p("p"),ns.innerHTML=Qa,te=n(),ls=p("p"),ls.textContent=Ba,ee=n(),ps=p("p"),ps.innerHTML=Ga,ae=n(),m(os.$$.fragment),ne=n(),is=p("p"),is.innerHTML=Sa,le=n(),m(v.$$.fragment),pe=n(),m(rs.$$.fragment),oe=n(),ms=p("p"),ms.textContent=Ra,ie=n(),cs=p("p"),cs.innerHTML=Ha,re=n(),hs=p("p"),hs.textContent=Ea,me=n(),m(Ms.$$.fragment),ce=n(),us=p("p"),us.textContent=Xa,he=n(),m(ys.$$.fragment),Me=n(),ws=p("p"),ws.textContent=Wa,ue=n(),m(js.$$.fragment),ye=n(),Us=p("p"),Us.innerHTML=Ka,we=n(),ds=p("p"),ds.innerHTML=Ya,je=n(),m(Js.$$.fragment),Ue=n(),bs=p("p"),bs.textContent=Pa,de=n(),m(Ts.$$.fragment),Je=n(),fs=p("p"),fs.innerHTML=Da,be=n(),m(gs.$$.fragment),Te=n(),Cs=p("p"),Cs.textContent=Fa,fe=n(),Is=p("p"),Is.textContent=La,ge=n(),m(ks.$$.fragment),Ce=n(),vs=p("p"),vs.innerHTML=Oa,Ie=n(),m($s.$$.fragment),ke=n(),qs=p("p"),qs.textContent=sn,ve=n(),m(xs.$$.fragment),$e=n(),As=p("p"),As.textContent=tn,qe=n(),m(Zs.$$.fragment),xe=n(),m(_s.$$.fragment),Ae=n(),zs=p("p"),zs.textContent=en,Ze=n(),m(Ns.$$.fragment),_e=n(),m($.$$.fragment),ze=n(),Vs=p("p"),Vs.textContent=an,Ne=n(),m(Qs.$$.fragment),Ve=n(),Bs=p("p"),Bs.innerHTML=nn,Qe=n(),Gs=p("p"),Gs.innerHTML=ln,Be=n(),Ss=p("p"),Ss.textContent=pn,Ge=n(),m(Rs.$$.fragment),Se=n(),Hs=p("p"),Hs.textContent=on,Re=n(),m(Es.$$.fragment),He=n(),m(Xs.$$.fragment),Ee=n(),Ws=p("p"),Ws.textContent=rn,Xe=n(),m(Ks.$$.fragment),We=n(),Ys=p("p"),Ys.textContent=mn,Ke=n(),m(Ps.$$.fragment),Ye=n(),m(Ds.$$.fragment),Pe=n(),Fs=p("p"),Fs.textContent=cn,De=n(),m(Ls.$$.fragment),Fe=n(),Os=p("p"),Os.textContent=hn,Le=n(),m(st.$$.fragment),Oe=n(),tt=p("p"),tt.innerHTML=Mn,sa=n(),m(et.$$.fragment),ta=n(),m(q.$$.fragment),ea=n(),at=p("p"),at.textContent=un,aa=n(),m(nt.$$.fragment),na=n(),lt=p("p"),lt.innerHTML=yn,la=n(),m(pt.$$.fragment),pa=n(),m(ot.$$.fragment),oa=n(),m(x.$$.fragment),ia=n(),it=p("p"),it.textContent=wn,ra=n(),m(rt.$$.fragment),ma=n(),Ut=p("p"),this.h()},l(s){const t=vn("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=l(s),w=o(s,"P",{}),dt(w).forEach(e),d=l(s),c(Z.$$.fragment,s),bt=l(s),c(_.$$.fragment,s),Tt=l(s),c(z.$$.fragment,s),ft=l(s),N=o(s,"P",{"data-svelte-h":!0}),r(N)!=="svelte-oo0thc"&&(N.innerHTML=Ja),gt=l(s),V=o(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vloklr"&&(V.textContent=ba),Ct=l(s),c(Q.$$.fragment,s),It=l(s),c(C.$$.fragment,s),kt=l(s),c(B.$$.fragment,s),vt=l(s),G=o(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-16vv0fb"&&(G.textContent=Ta),$t=l(s),S=o(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1yvt99t"&&(S.textContent=fa),qt=l(s),I=o(s,"P",{});var mt=dt(I);ha=ht(mt,"This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),xt=da(mt,!1),At=ht(mt," (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),mt.forEach(e),Zt=l(s),R=o(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bd68el"&&(R.textContent=ga),_t=l(s),H=o(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18sgwt4"&&(H.textContent=Ca),zt=l(s),E=o(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1rnxwlp"&&(E.textContent=Ia),Nt=l(s),c(X.$$.fragment,s),Vt=l(s),W=o(s,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sp8vuv"&&(W.textContent=ka),Qt=l(s),c(K.$$.fragment,s),Bt=l(s),c(Y.$$.fragment,s),Gt=l(s),P=o(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-17i13c1"&&(P.textContent=va),St=l(s),D=o(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ywxof8"&&(D.innerHTML=$a),Rt=l(s),F=o(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1im6u9i"&&(F.textContent=qa),Ht=l(s),c(L.$$.fragment,s),Et=l(s),O=o(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-16cln8v"&&(O.innerHTML=xa),Xt=l(s),c(k.$$.fragment,s),Wt=l(s),b=o(s,"P",{});var f=dt(b);Ma=ht(f,"Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),Mt=o(f,"CODE",{"data-svelte-h":!0}),r(Mt)!=="svelte-1n2m4po"&&(Mt.textContent=Aa),ua=ht(f," of "),ut=o(f,"CODE",{"data-svelte-h":!0}),r(ut)!=="svelte-1gjdq76"&&(ut.textContent=Za),ya=ht(f,` has the probability:
`),Kt=da(f,!1),f.forEach(e),Yt=l(s),g=o(s,"P",{});var A=dt(g);wa=ht(A,"Comparatively, the tokenization "),yt=o(A,"CODE",{"data-svelte-h":!0}),r(yt)!=="svelte-42m5r0"&&(yt.textContent=_a),ja=ht(A,` has the probability:
`),Pt=da(A,!1),A.forEach(e),Dt=l(s),ss=o(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-g2doa3"&&(ss.textContent=za),Ft=l(s),ts=o(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-9ovu4k"&&(ts.innerHTML=Na),Lt=l(s),c(es.$$.fragment,s),Ot=l(s),as=o(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-by7atq"&&(as.innerHTML=Va),se=l(s),ns=o(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1re84pi"&&(ns.innerHTML=Qa),te=l(s),ls=o(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-4w9cp8"&&(ls.textContent=Ba),ee=l(s),ps=o(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1v3e60i"&&(ps.innerHTML=Ga),ae=l(s),c(os.$$.fragment,s),ne=l(s),is=o(s,"P",{"data-svelte-h":!0}),r(is)!=="svelte-17ww2xx"&&(is.innerHTML=Sa),le=l(s),c(v.$$.fragment,s),pe=l(s),c(rs.$$.fragment,s),oe=l(s),ms=o(s,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-1mxwvxi"&&(ms.textContent=Ra),ie=l(s),cs=o(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-r1ko6w"&&(cs.innerHTML=Ha),re=l(s),hs=o(s,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-1y2guu9"&&(hs.textContent=Ea),me=l(s),c(Ms.$$.fragment,s),ce=l(s),us=o(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-smnwx3"&&(us.textContent=Xa),he=l(s),c(ys.$$.fragment,s),Me=l(s),ws=o(s,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-14jcfwu"&&(ws.textContent=Wa),ue=l(s),c(js.$$.fragment,s),ye=l(s),Us=o(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-1rsqmv"&&(Us.innerHTML=Ka),we=l(s),ds=o(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1e3tr4j"&&(ds.innerHTML=Ya),je=l(s),c(Js.$$.fragment,s),Ue=l(s),bs=o(s,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-15gzb9u"&&(bs.textContent=Pa),de=l(s),c(Ts.$$.fragment,s),Je=l(s),fs=o(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1gwabz2"&&(fs.innerHTML=Da),be=l(s),c(gs.$$.fragment,s),Te=l(s),Cs=o(s,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-1p0q4mo"&&(Cs.textContent=Fa),fe=l(s),Is=o(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-160kau6"&&(Is.textContent=La),ge=l(s),c(ks.$$.fragment,s),Ce=l(s),vs=o(s,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-5hfan0"&&(vs.innerHTML=Oa),Ie=l(s),c($s.$$.fragment,s),ke=l(s),qs=o(s,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-1p0ikvu"&&(qs.textContent=sn),ve=l(s),c(xs.$$.fragment,s),$e=l(s),As=o(s,"P",{"data-svelte-h":!0}),r(As)!=="svelte-1njxouy"&&(As.textContent=tn),qe=l(s),c(Zs.$$.fragment,s),xe=l(s),c(_s.$$.fragment,s),Ae=l(s),zs=o(s,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-1rbeurr"&&(zs.textContent=en),Ze=l(s),c(Ns.$$.fragment,s),_e=l(s),c($.$$.fragment,s),ze=l(s),Vs=o(s,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-kpz2jw"&&(Vs.textContent=an),Ne=l(s),c(Qs.$$.fragment,s),Ve=l(s),Bs=o(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-1vp6twv"&&(Bs.innerHTML=nn),Qe=l(s),Gs=o(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-8o0mkc"&&(Gs.innerHTML=ln),Be=l(s),Ss=o(s,"P",{"data-svelte-h":!0}),r(Ss)!=="svelte-76z975"&&(Ss.textContent=pn),Ge=l(s),c(Rs.$$.fragment,s),Se=l(s),Hs=o(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-1riuhoo"&&(Hs.textContent=on),Re=l(s),c(Es.$$.fragment,s),He=l(s),c(Xs.$$.fragment,s),Ee=l(s),Ws=o(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-ncpc2j"&&(Ws.textContent=rn),Xe=l(s),c(Ks.$$.fragment,s),We=l(s),Ys=o(s,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-p7t1po"&&(Ys.textContent=mn),Ke=l(s),c(Ps.$$.fragment,s),Ye=l(s),c(Ds.$$.fragment,s),Pe=l(s),Fs=o(s,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-emtee"&&(Fs.textContent=cn),De=l(s),c(Ls.$$.fragment,s),Fe=l(s),Os=o(s,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-qxfbyo"&&(Os.textContent=hn),Le=l(s),c(st.$$.fragment,s),Oe=l(s),tt=o(s,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-zu2ggv"&&(tt.innerHTML=Mn),sa=l(s),c(et.$$.fragment,s),ta=l(s),c(q.$$.fragment,s),ea=l(s),at=o(s,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1vz3e3j"&&(at.textContent=un),aa=l(s),c(nt.$$.fragment,s),na=l(s),lt=o(s,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-m3sdwl"&&(lt.innerHTML=yn),la=l(s),c(pt.$$.fragment,s),pa=l(s),c(ot.$$.fragment,s),oa=l(s),c(x.$$.fragment,s),ia=l(s),it=o(s,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1hk3m3g"&&(it.textContent=wn),ra=l(s),c(rt.$$.fragment,s),ma=l(s),Ut=o(s,"P",{}),dt(Ut).forEach(e),this.h()},h(){Jn(i,"name","hf:doc:metadata"),Jn(i,"content",Gn),xt.a=At,Kt.a=null,Pt.a=null},m(s,t){T(document.head,i),a(s,U,t),a(s,w,t),a(s,d,t),h(Z,s,t),a(s,bt,t),h(_,s,t),a(s,Tt,t),h(z,s,t),a(s,ft,t),a(s,N,t),a(s,gt,t),a(s,V,t),a(s,Ct,t),h(Q,s,t),a(s,It,t),h(C,s,t),a(s,kt,t),h(B,s,t),a(s,vt,t),a(s,G,t),a(s,$t,t),a(s,S,t),a(s,qt,t),a(s,I,t),T(I,ha),xt.m(bn,I),T(I,At),a(s,Zt,t),a(s,R,t),a(s,_t,t),a(s,H,t),a(s,zt,t),a(s,E,t),a(s,Nt,t),h(X,s,t),a(s,Vt,t),a(s,W,t),a(s,Qt,t),h(K,s,t),a(s,Bt,t),h(Y,s,t),a(s,Gt,t),a(s,P,t),a(s,St,t),a(s,D,t),a(s,Rt,t),a(s,F,t),a(s,Ht,t),h(L,s,t),a(s,Et,t),a(s,O,t),a(s,Xt,t),h(k,s,t),a(s,Wt,t),a(s,b,t),T(b,Ma),T(b,Mt),T(b,ua),T(b,ut),T(b,ya),Kt.m(Tn,b),a(s,Yt,t),a(s,g,t),T(g,wa),T(g,yt),T(g,ja),Pt.m(fn,g),a(s,Dt,t),a(s,ss,t),a(s,Ft,t),a(s,ts,t),a(s,Lt,t),h(es,s,t),a(s,Ot,t),a(s,as,t),a(s,se,t),a(s,ns,t),a(s,te,t),a(s,ls,t),a(s,ee,t),a(s,ps,t),a(s,ae,t),h(os,s,t),a(s,ne,t),a(s,is,t),a(s,le,t),h(v,s,t),a(s,pe,t),h(rs,s,t),a(s,oe,t),a(s,ms,t),a(s,ie,t),a(s,cs,t),a(s,re,t),a(s,hs,t),a(s,me,t),h(Ms,s,t),a(s,ce,t),a(s,us,t),a(s,he,t),h(ys,s,t),a(s,Me,t),a(s,ws,t),a(s,ue,t),h(js,s,t),a(s,ye,t),a(s,Us,t),a(s,we,t),a(s,ds,t),a(s,je,t),h(Js,s,t),a(s,Ue,t),a(s,bs,t),a(s,de,t),h(Ts,s,t),a(s,Je,t),a(s,fs,t),a(s,be,t),h(gs,s,t),a(s,Te,t),a(s,Cs,t),a(s,fe,t),a(s,Is,t),a(s,ge,t),h(ks,s,t),a(s,Ce,t),a(s,vs,t),a(s,Ie,t),h($s,s,t),a(s,ke,t),a(s,qs,t),a(s,ve,t),h(xs,s,t),a(s,$e,t),a(s,As,t),a(s,qe,t),h(Zs,s,t),a(s,xe,t),h(_s,s,t),a(s,Ae,t),a(s,zs,t),a(s,Ze,t),h(Ns,s,t),a(s,_e,t),h($,s,t),a(s,ze,t),a(s,Vs,t),a(s,Ne,t),h(Qs,s,t),a(s,Ve,t),a(s,Bs,t),a(s,Qe,t),a(s,Gs,t),a(s,Be,t),a(s,Ss,t),a(s,Ge,t),h(Rs,s,t),a(s,Se,t),a(s,Hs,t),a(s,Re,t),h(Es,s,t),a(s,He,t),h(Xs,s,t),a(s,Ee,t),a(s,Ws,t),a(s,Xe,t),h(Ks,s,t),a(s,We,t),a(s,Ys,t),a(s,Ke,t),h(Ps,s,t),a(s,Ye,t),h(Ds,s,t),a(s,Pe,t),a(s,Fs,t),a(s,De,t),h(Ls,s,t),a(s,Fe,t),a(s,Os,t),a(s,Le,t),h(st,s,t),a(s,Oe,t),a(s,tt,t),a(s,sa,t),h(et,s,t),a(s,ta,t),h(q,s,t),a(s,ea,t),a(s,at,t),a(s,aa,t),h(nt,s,t),a(s,na,t),a(s,lt,t),a(s,la,t),h(pt,s,t),a(s,pa,t),h(ot,s,t),a(s,oa,t),h(x,s,t),a(s,ia,t),a(s,it,t),a(s,ra,t),h(rt,s,t),a(s,ma,t),a(s,Ut,t),ca=!0},p(s,[t]){const mt={};t&2&&(mt.$$scope={dirty:t,ctx:s}),C.$set(mt);const f={};t&2&&(f.$$scope={dirty:t,ctx:s}),k.$set(f);const A={};t&2&&(A.$$scope={dirty:t,ctx:s}),v.$set(A);const jn={};t&2&&(jn.$$scope={dirty:t,ctx:s}),$.$set(jn);const Un={};t&2&&(Un.$$scope={dirty:t,ctx:s}),q.$set(Un);const dn={};t&2&&(dn.$$scope={dirty:t,ctx:s}),x.$set(dn)},i(s){ca||(M(Z.$$.fragment,s),M(_.$$.fragment,s),M(z.$$.fragment,s),M(Q.$$.fragment,s),M(C.$$.fragment,s),M(B.$$.fragment,s),M(X.$$.fragment,s),M(K.$$.fragment,s),M(Y.$$.fragment,s),M(L.$$.fragment,s),M(k.$$.fragment,s),M(es.$$.fragment,s),M(os.$$.fragment,s),M(v.$$.fragment,s),M(rs.$$.fragment,s),M(Ms.$$.fragment,s),M(ys.$$.fragment,s),M(js.$$.fragment,s),M(Js.$$.fragment,s),M(Ts.$$.fragment,s),M(gs.$$.fragment,s),M(ks.$$.fragment,s),M($s.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M(_s.$$.fragment,s),M(Ns.$$.fragment,s),M($.$$.fragment,s),M(Qs.$$.fragment,s),M(Rs.$$.fragment,s),M(Es.$$.fragment,s),M(Xs.$$.fragment,s),M(Ks.$$.fragment,s),M(Ps.$$.fragment,s),M(Ds.$$.fragment,s),M(Ls.$$.fragment,s),M(st.$$.fragment,s),M(et.$$.fragment,s),M(q.$$.fragment,s),M(nt.$$.fragment,s),M(pt.$$.fragment,s),M(ot.$$.fragment,s),M(x.$$.fragment,s),M(rt.$$.fragment,s),ca=!0)},o(s){u(Z.$$.fragment,s),u(_.$$.fragment,s),u(z.$$.fragment,s),u(Q.$$.fragment,s),u(C.$$.fragment,s),u(B.$$.fragment,s),u(X.$$.fragment,s),u(K.$$.fragment,s),u(Y.$$.fragment,s),u(L.$$.fragment,s),u(k.$$.fragment,s),u(es.$$.fragment,s),u(os.$$.fragment,s),u(v.$$.fragment,s),u(rs.$$.fragment,s),u(Ms.$$.fragment,s),u(ys.$$.fragment,s),u(js.$$.fragment,s),u(Js.$$.fragment,s),u(Ts.$$.fragment,s),u(gs.$$.fragment,s),u(ks.$$.fragment,s),u($s.$$.fragment,s),u(xs.$$.fragment,s),u(Zs.$$.fragment,s),u(_s.$$.fragment,s),u(Ns.$$.fragment,s),u($.$$.fragment,s),u(Qs.$$.fragment,s),u(Rs.$$.fragment,s),u(Es.$$.fragment,s),u(Xs.$$.fragment,s),u(Ks.$$.fragment,s),u(Ps.$$.fragment,s),u(Ds.$$.fragment,s),u(Ls.$$.fragment,s),u(st.$$.fragment,s),u(et.$$.fragment,s),u(q.$$.fragment,s),u(nt.$$.fragment,s),u(pt.$$.fragment,s),u(ot.$$.fragment,s),u(x.$$.fragment,s),u(rt.$$.fragment,s),ca=!1},d(s){s&&(e(U),e(w),e(d),e(bt),e(Tt),e(ft),e(N),e(gt),e(V),e(Ct),e(It),e(kt),e(vt),e(G),e($t),e(S),e(qt),e(I),e(Zt),e(R),e(_t),e(H),e(zt),e(E),e(Nt),e(Vt),e(W),e(Qt),e(Bt),e(Gt),e(P),e(St),e(D),e(Rt),e(F),e(Ht),e(Et),e(O),e(Xt),e(Wt),e(b),e(Yt),e(g),e(Dt),e(ss),e(Ft),e(ts),e(Lt),e(Ot),e(as),e(se),e(ns),e(te),e(ls),e(ee),e(ps),e(ae),e(ne),e(is),e(le),e(pe),e(oe),e(ms),e(ie),e(cs),e(re),e(hs),e(me),e(ce),e(us),e(he),e(Me),e(ws),e(ue),e(ye),e(Us),e(we),e(ds),e(je),e(Ue),e(bs),e(de),e(Je),e(fs),e(be),e(Te),e(Cs),e(fe),e(Is),e(ge),e(Ce),e(vs),e(Ie),e(ke),e(qs),e(ve),e($e),e(As),e(qe),e(xe),e(Ae),e(zs),e(Ze),e(_e),e(ze),e(Vs),e(Ne),e(Ve),e(Bs),e(Qe),e(Gs),e(Be),e(Ss),e(Ge),e(Se),e(Hs),e(Re),e(He),e(Ee),e(Ws),e(Xe),e(We),e(Ys),e(Ke),e(Ye),e(Pe),e(Fs),e(De),e(Fe),e(Os),e(Le),e(Oe),e(tt),e(sa),e(ta),e(ea),e(at),e(aa),e(na),e(lt),e(la),e(pa),e(oa),e(ia),e(it),e(ra),e(ma),e(Ut)),e(i),y(Z,s),y(_,s),y(z,s),y(Q,s),y(C,s),y(B,s),y(X,s),y(K,s),y(Y,s),y(L,s),y(k,s),y(es,s),y(os,s),y(v,s),y(rs,s),y(Ms,s),y(ys,s),y(js,s),y(Js,s),y(Ts,s),y(gs,s),y(ks,s),y($s,s),y(xs,s),y(Zs,s),y(_s,s),y(Ns,s),y($,s),y(Qs,s),y(Rs,s),y(Es,s),y(Xs,s),y(Ks,s),y(Ps,s),y(Ds,s),y(Ls,s),y(st,s),y(et,s),y(q,s),y(nt,s),y(pt,s),y(ot,s),y(x,s),y(rt,s)}}}const Gn='{"title":"Unigram tokenization","local":"unigram-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Back to training","local":"back-to-training","sections":[],"depth":2},{"title":"Implementing Unigram","local":"implementing-unigram","sections":[],"depth":2}],"depth":1}';function Sn(J){return Cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends In{constructor(i){super(),kn(this,i,Sn,Bn,gn,{})}}export{Pn as component};
