# End-of-chapter quiz[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={10}
    classNames="absolute z-10 right-0 top-0"
/>

Let's test what you learned in this chapter!

### 1. What can you use Argilla for?

<Question
	choices={[
		{
			text: "Turn unstructured data into structured data for NLP tasks",
			explain: "You can use Argilla to add annotations to a dataset and use it for NLP tasks.",
            correct: true
		},
		{
			text: "Scrap a public website to build a dataset",
			explain: "This is not a feature in Argilla, but you can scrap a public website and turn it into an Argilla dataset for annotations using the Python SDK."
		},
		{
			text: "Improve the quality of an existing dataset",
			explain: "You can use previous annotations as suggestions and correct them to improve the quality of a dataset.",
			correct: true
		},
		{
			text: "Adapt an existing dataset to your own use case",
			explain: "You can use different question types in Argilla to adapt an existing dataset to your own use case.",
			correct: true
		},
		{
			text: "Train your model",
			explain: "You cannot train a model directly in Argilla, but you can use the data you curate in Argilla to train your own model",
		},
		{
			text: "Generate synthetic datasets",
			explain: "To generate synthetic datasets, you can use the distilabel package and then use Argilla to review and curate the generated data.",
		}
	]}
/>

### 2. Argilla ONLY works in the Hugging Face Spaces and with Hugging Face Datasets.

<Question
	choices={[
        {
			text: "True",
			explain: "You can also deploy Argilla locally using Docker and you can use the Python SDK to upload any type of data, including Hugging Face Datasets."
        },
        {
			text: "False",
			explain: "You can also deploy Argilla locally using Docker and you can use the Python SDK to upload any type of data, including Hugging Face Datasets.",
			correct: true
        }
	]}
/>

### 3. You need a Hugging Face token to connect the Python SDK to your Argilla server.

<Question
	choices={[
        {
			text: "True",
			explain: "This is only needed if your Argilla Space is private!",
        },
        {
			text: "False",
			explain: "You don't need a token if you are using a public Argilla Space or a local deployment with Docker.",
			correct: true
        }
	]}
/>

### 4. What are **fields** in Argilla? How many fields can you use?

<Question
	choices={[
        {
			text: "Fields show the data that we are annotating. All this information needs to be collected in a single field.",
			explain: "You can spread the information across multiple fields, if you need to."
        },
		{
			text: "Fields show the data that we are annotating. All this information can be spread across multiple fields.",
			explain: "Yes, you can have multiple fields and also fields of different types (text, chat, image...) depending on the type of data you're annotating.",
			correct: true
        },
        {
			text: "Fields contain the metadata of the records. You can use as many as you need.",
			explain: "You can have both fields and metadata in your dataset, but they serve separate purposes. Metadata are used for filtering and sorting purposes as extra information, while fields show the data that we are annotating."
        }
	]}
/>

### 5. What's the best type of question for a token classification task?

<Question
	choices={[
        {
			text: "A SpanQuestion",
			explain: "SpanQuestions let you highlight bits of text and apply a label to them. This is the best type for a token classification task.",
            correct: true
        },
        {
			text: "A LabelQuestion",
			explain: "This type of question allows you to select a label that applies to the whole record. This type is best for a text classification task."
        },
        {
			text: "A TextQuestion",
			explain: "This type of question allows you to write text. This is not suitable for a token classfication task."
        },
        {
			text: "None of the above",
			explain: "SpanQuestions let you highlight bits of text and apply a label to them. This is the best type for a token classification task."
        }
	]}
/>

### 6. What is the purpose of the "Save as draft" button?

<Question
	choices={[
        {
			text: "Submit your responses",
			explain: "This button saves your responses, but doesn't submit them",
        },
        {
			text: "Save your responses without submitting them",
			explain: "This is a valid method of loading a Hugging Face model from the Hub",
			correct: true
        },
        {
			text: "Discard a record",
			explain: "Try again -- you cannot load a model by using the 'demos' prefix."
        }
	]}
/>

### 7. Argilla does not offer suggested labels automatically, you need to provide that data yourself.

<Question
	choices={[
        {
			text: "True",
			explain: "You can add suggestions to your records (or update them) at any point of the project.",
            correct: true
        },
        {
			text: "False",
			explain: "If you want to see suggested labels, you need to log them yourself when you create the records or at a later point."
        }
	]}
/>

### 8. Select all the necessary steps to export an Argilla dataset in full to the Hub:

<Question
	choices={[
        {
			text: "You need to be connected to your Argilla server: <code>client= rg.Argilla(api_url='...', api_key='...')</code>",
			explain: "Yes, to interact with your server you'll need to instantiate it first.",
            correct: true
        },
		{
			text: "Import the dataset from the hub: <code>dataset = rg.Dataset.from_hub(repo_id='argilla/ag_news_annotated')</code>",
			explain: "No. This is to import a dataset from the Hub into your Argilla instance.",
        },
        {
			text: "Load the dataset: <code>dataset = client.datasets(name='my_dataset')</code>",
			explain: "Yes, you'll need this for further operations",
			correct: true
        },
        {
			text: "Convert the Argilla dataset into a Datasets dataset: <code>dataset = dataset.to_datasets()</code>",
			explain: "This is not needed if you export the full dataset. Argilla will take care of this for you. However, you might need it if you're working with a subset of records."
        },
        {
			text: "Use the </code>to_hub</code> method to export the dataset: <code>dataset.to_hub(repo_id='my_username/dataset_name')</code>",
			explain: "This will push the dataset to the indicated repo id, and create a new repo if it doesn't exist.",
            correct: true
        },
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter10/7.mdx" />