# Open R1 for Students

Welcome to an exciting journey into the world of open-source AI with reinforcement learning! This chapter is designed to help students understand reinforcement learning and its role in LLMs.

We will also explore [Open R1](https://github.com/huggingface/open-r1), a groundbreaking community project that's making advanced AI accessible to everyone. Specifically, this course is to help students and learners to use and contribute to [Open R1](https://github.com/huggingface/open-r1).

## What You'll Learn

In this chapter, we'll break down complex concepts into easy-to-understand pieces and show you how you can be part of this exciting project to make LLMs reason on complex problems. 

LLMs have shown excellent performance on many generative tasks. However, up until recently they have struggled on complex problems that require reasoning. For example, they struggle to deal with puzzles or math problems that require multiple steps of reasoning. 

Open R1 is a project that aims to make LLMs reason on complex problems. It does this by using reinforcement learning to encourage LLMs to 'think' and reason. 

In simple terms, the model is train to generate thoughts as well as outputs, and to structure these thoughts and outputs so that they can be handled separately by the user. 

Let's take a look at an example. A we gave ourself the task of solving the following problem, we might think like this:

```sh
Problem: "I have 3 apples and 2 oranges. How many pieces of fruit do I have in total?"

Thought: "I need to add the number of apples and oranges to get the total number of pieces of fruit."

Answer: "5"
```

We can then structure this thought and answer so that they can be handled separately by the user. For reasoning tasks, LLMs can be trained to generate thoughts and answers in the following format:

```sh
<think>I need to add the number of apples and oranges to get the total number of pieces of fruit.</think>
5
```

As a user, we can then extract the thought and answer from the model's output and use them to solve the problem.

## Why This Matters for Students

As a student, understanding Open R1 and the role of reinforcement learning in LLMs is valuable because:
- It shows you how cutting-edge AI is developed
- It gives you hands-on opportunities to learn and contribute
- It helps you understand where AI technology is heading
- It opens doors to future career opportunities in AI

## Chapter Overview

This chapter is divided into four sections, each focusing on a different aspect of Open R1:

### 1️⃣ Introduction to Reinforcement Learning and its Role in LLMs
We'll explore the basics of Reinforcement Learning (RL) and its role in training LLMs.
- What is RL?
- How is RL used in LLMs?
- What is DeepSeek R1?
- What are the key innovations of DeepSeek R1?

### 2️⃣ Understanding the DeepSeek R1 Paper
We'll break down the research paper that inspired [Open R1](https://huggingface.co/open-r1):
- Key innovations and breakthroughs
- The training process and architecture
- Results and their significance

### 3️⃣ Implementing GRPO in TRL
We'll get practical with code examples:
- How to use the Transformer Reinforcement Learning (TRL) library
- Setting up GRPO training

### 4️⃣ Practical use case to align a model
We'll look at a practical use case to align a model using Open R1.
- How to train a model using GRPO in TRL
- Share your model on the [Hugging Face Hub](https://huggingface.co/models)

## Prerequisites

To get the most out of this chapter, it's helpful to have:
- Solid understanding of Python programming
- Familiarity with machine learning concepts
- Interest in AI and language models

Don't worry if you're missing some of these – we'll explain key concepts as we go along! 🚀

<Tip>

If you don't have all the prerequisites, check out this [course](/course/chapter1/1) from units 1 to 11

</Tip>

## How to Use This Chapter

1. **Read Sequentially**: The sections build on each other, so it's best to read them in order
2. **Share Notes**: Write down key concepts and questions and discuss them with in the community in [Discord](https://discord.gg/F3vZujJH)
3. **Try the Code**: When we get to practical examples, try them yourself
4. **Join the Community**: Use the resources we provide to connect with other learners

Let's begin our exploration of Open R1 and discover how you can be part of making AI more accessible to everyone! 🚀


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter12/1.mdx" />