import{s as Va,o as Wa,n as Ee}from"../chunks/scheduler.cc52f4b9.js";import{S as ka,i as Ra,e as u,s as t,c as p,h as Ca,a as J,d as a,b as n,f as Ga,g as r,j as y,k as Za,l as Ea,m as l,n as o,t as d,o as m,p as c}from"../chunks/index.f7fb5439.js";import{T as Ce}from"../chunks/Tip.c708fc3b.js";import{C as Xa,E as va}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4aef24b6.js";import{Y as Na}from"../chunks/Youtube.5391c1b7.js";import{C as T}from"../chunks/CodeBlock.c4d86f9a.js";import{C as _a}from"../chunks/CourseFloatingBanner.9c415528.js";import{H as Ps}from"../chunks/Heading.b75cdeb1.js";function za(b){let i,j='✎ Por defecto, 🤗 Datasets va a descomprimir los archivos necesarios para cargar un dataset. Si quieres ahorrar espacio de almacenamiento, puedes usar <code>DownloadConfig(delete_extracted=True)</code> al argumento <code>download_config</code> de <code>load_dataset()</code>. Revisa la <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentación</a> para más detalles.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1vcz8if"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Ee,d(M){M&&a(i)}}}function Qa(b){let i,j='✏️ <strong>¡Inténtalo!</strong> Escoge alguno de los <a href="https://mystic.the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">subconjuntos</a> del <em>Pile</em> que sea más grande que la RAM de tu computador portátil o de escritorio, cárgalo con 🤗 Datasets y mide la cantidad de RAM utilizada. Recuerda que para tener una medición precisa, tienes que hacerlo en un nuevo proceso. Puedes encontrar los tamaños de cada uno de los subconjuntos sin comprimir en la Tabla 1 del <a href="https://arxiv.org/abs/2101.00027" rel="nofollow">paper de <em>Pile</em></a>.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1udxpjd"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Ee,d(M){M&&a(i)}}}function Ya(b){let i,j='💡 En los cuadernos de Jupyter también puedes medir el tiempo de ejecución de las celdas usando <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code></a>.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1pb1ytq"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Ee,d(M){M&&a(i)}}}function Ha(b){let i,j="💡 Para acelerar la tokenización con <em>streaming</em> puedes definir <code>batched=True</code>, como lo vimos en la sección anterior. Esto va a procesar los ejemplos lote por lote. Recuerda que el tamaño por defecto de los lotes es 1.000 y puede ser especificado con el argumento <code>batch_size</code>.";return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-e5qad3"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Ee,d(M){M&&a(i)}}}function Fa(b){let i,j='✏️ <strong>¡Inténtalo!</strong> Usa alguno de los corpus grandes de Common Crawl como <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> u <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> para crear un dataset <em>streaming</em> multilenguaje que represente las proporciones de lenguajes hablados en un país de tu elección. Por ejemplo, los 4 lenguajes nacionales en Suiza son alemán, francés, italiano y romanche, así que podrías crear un corpus suizo al hacer un muestreo de Oscar de acuerdo con su proporción de lenguaje.';return{c(){i=u("p"),i.innerHTML=j},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-19fsbe0"&&(i.innerHTML=j)},m(M,h){l(M,i,h)},p:Ee,d(M){M&&a(i)}}}function Aa(b){let i,j,M,h,I,Xe,B,ve,x,Ne,G,Os="Hoy en día es común que tengas que trabajar con dataset de varios GB, especialmente si planeas pre-entrenar un transformador como BERT o GPT-2 desde ceros. En estos casos, <em>solamente cargar</em> los datos puede ser un desafío. Por ejemplo, el corpus de WebText utilizado para preentrenar GPT-2 consiste de más de 8 millones de documentos y 40 GB de texto. ¡Cargarlo en la RAM de tu computador portátil le va a causar un paro cardíaco!",_e,Z,Ks="Afortunadamente, 🤗 Datasets está diseñado para superar estas limitaciones: te libera de problemas de manejo de memoria al tratar los datasets como archivos <em>proyectados en memoria</em> (<em>memory-mapped</em>) y de límites de almacenamiento al hacer <em>streaming</em> de las entradas en un corpus.",ze,V,Qe,W,ea='En esta sección vamos a explorar estas funcionalidades de 🤗 Datasets con un corpus enorme de 825 GB conocido como el <a href="https://pile.eleuther.ai" rel="nofollow">Pile</a>. ¡Comencemos!',Ye,k,He,R,sa='El <em>Pile</em> es un corpus de textos en inglés creado por <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> para entrenar modelos de lenguaje de gran escala. Incluye una selección diversa de datasets que abarca artículos científicos, repositorios de código de Github y texto filtrado de la web. El corpus de entrenamiento está disponible en <a href="https://mystic.the-eye.eu/public/AI/pile/" rel="nofollow">partes de 14 GB</a> y también puedes descargar varios de los <a href="https://mystic.the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">componentes individuales</a>. Arranquemos viendo el dataset de los abstracts de PubMed, un corpus de abstracts de 15 millones de publicaciones biomédicas en <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. Este dataset está en formato <a href="https://jsonlines.org" rel="nofollow">JSON Lines</a> y está comprimido con la librería <code>zstandard</code>, así que primero tenemos que instalarla:',Fe,C,Ae,E,aa='A continuación, podemos cargar el dataset usando el método para archivos remotos que aprendimos en la <a href="/course/chapter5/2">sección 2</a>:',Se,X,De,v,Le,N,la="Como podemos ver, hay 15.518.009 filas y dos columnas en el dataset, ¡un montón!",qe,f,Pe,_,ta="Veamos el contenido del primer ejemplo:",Oe,z,Ke,Q,es,Y,na="Ok, esto parece el abstract de un artículo médico. Ahora miremos cuánta RAM hemos usado para cargar el dataset.",ss,H,as,F,ia='Una forma simple de medir el uso de memoria en Python es con la librería <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a>, que se puede instalar con <code>pip</code> así:',ls,A,ts,S,pa="Esta librería contiene una clase <code>Process</code> que nos permite revisar el uso de memoria del proceso actual:",ns,D,is,L,ps,q,ra="El atributo <code>rss</code> se refiere al <em>resident set size</em>, que es la fracción de memoria que un proceso ocupa en RAM. Esta medición también incluye la memoria usada por el intérprete de Python y las librerías que hemos cargado, así que la cantidad real de memoria usada para cargar el dataset es un poco más pequeña. A modo de comparación, veamos qué tan grande es el dataset en disco, usando el atributo <code>dataset_size</code>. Dado que el resultado está expresado en bytes, tenemos que convertirlo manualmente en gigabytes:",rs,P,os,O,ds,K,oa="Bien, a pesar de que el archivo es de casi 20 GB, ¡podemos cargarlo y acceder a su contenido con mucha menos RAM!",ms,w,cs,ee,da='Si estás familiarizado con Pandas, este resultado puede ser sorprendente por la famosa <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">regla de Wes Kinney</a> que indica que típicamente necesitas de 5 a 10 veces la RAM que el tamaño del archivo de tu dataset. ¿Cómo resuelve entonces 🤗 Datasets este problema de manejo de memoria? 🤗 Datasets trata cada dataset como un <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">archivo proyectado en memoria</a>, lo que permite un mapeo entre la RAM y el sistema de almacenamiento de archivos, que le permite a la librería acceder y operar los elementos del dataset sin necesidad de tenerlos cargados completamente en memoria.',Ms,se,ma='Los archivos proyectados en memoria también pueden ser compartidos por múltiples procesos, lo que habilita la paralelización de métodos como <code>Dataset.map()</code> sin que sea obligatorio mover o copiar el dataset. Internamente, estas capacidades se logran gracias al formato de memoria <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> y la librería <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a>, que permiten la carga y procesamiento de datos a gran velocidad. (Para ahondar más en Apache Arrow y algunas comparaciones con Pandas, revisa el <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">blog de Dejan Simic</a>). Para verlo en acción, ejecutemos un test de velocidad iterando sobre todos los elementos del dataset de abstracts de PubMed:',us,ae,Js,le,ys,te,ca="Aquí usamos el módulo <code>timeit</code> de Python para medir el tiempo de ejecución que se toma <code>code_snippet</code>. Típicamemente, puedes iterar a lo largo de un dataset a una velocidad de unas cuantas décimas de un GB por segundo. Esto funciona muy bien para la gran mayoría de aplicaciones, pero algunas veces tendrás que trabajar con un dataset que es tan grande para incluso almacenarse en el disco de tu computador. Por ejemplo, si quisieramos descargar el <em>Pile</em> completo ¡necesitaríamos 825 GB de almacenamiento libre! Para trabajar con esos casos, 🤗 Datasets puede trabajar haciendo <em>streaming</em>, lo que permite la descarga y acceso a los elementos sobre la marcha, sin necesidad de descargar todo el dataset. Veamos cómo funciona:",Ts,U,js,ne,hs,ie,Ma="Para habilitar el <em>streaming</em> basta con pasar el argumento <code>streaming=True</code> a la función <code>load_dataset()</code>. Por ejemplo, carguemos el dataset de abstracts de PubMed de nuevo, pero en modo <em>streaming</em>.",bs,pe,fs,re,ua="En vez del <code>Dataset</code> común y corriente que nos hemos encontrado en el resto del capítulo, el objeto devuelto con <code>streaming=True</code> es un <code>IterableDataset</code>. Como su nombre lo indica, para acceder a los elementos de un <code>IterableDataset</code> tenemos que iterar sobre él. Podemos acceder al primer elemento de nuestro dataset de la siguiente manera:",ws,oe,Us,de,gs,me,Ja='Los elementos de un dataset <em>streamed</em> pueden ser procesados sobre la marcha usando <code>IterableDataset.map()</code>, lo que puede servirte si tienes que tokenizar los inputs. El proceso es exactamente el mismo que el que usamos para tokenizar nuestro dataset en el <a href="/course/chapter3">Capítulo 3</a>, con la única diferencia de que los outputs se devuelven uno por uno.',$s,ce,Is,Me,Bs,g,xs,ue,ya="También puedes aleatorizar el orden de un dataset <em>streamed</em> usando <code>IterableDataset.shuffle()</code>, pero a diferencia de <code>Dataset.shuffle()</code> esto sólo afecta a los elementos en un <code>buffer_size</code> determinado:",Gs,Je,Zs,ye,Vs,Te,Ta="En este ejemplo, seleccionamos un ejemplo aleatorio de los primeros 10.000 ejemplos en el buffer. Apenas se accede a un ejemplo, su lugar en el buffer se llena con el siguiente ejemplo en el corpus (i.e., el ejemplo número 10.001). También puedes seleccionar elementos de un dataset <em>streamed</em> usando las funciones <code>IterableDataset.take()</code> y <code>IterableDataset.skip()</code>, que funcionan de manera similar a <code>Dataset.select()</code>. Por ejemplo, para seleccionar los 5 primeros ejemplos en el dataset de abstracts de PubMed podemos hacer lo siguiente:",Ws,je,ks,he,Rs,be,ja="También podemos usar la función <code>IterableDataset.skip()</code> para crear conjuntos de entrenamiento y validación de un dataset ordenado aleatoriamente así:",Cs,fe,Es,we,ha="Vamos a repasar la exploración del <em>streaming</em> de datasets con una aplicación común: combinar múltiples datasets para crear un solo corpus. 🤗 Datasets provee una función <code>interleave_datasets()</code> que convierte una lista de objetos <code>IterableDataset</code> en un solo <code>IterableDataset</code>, donde la lista de elementos del nuevo dataset se obtiene al alternar entre los ejemplos originales. Esta función es particularmente útil cuando quieres combinar datasets grandes, así que como ejemplo hagamos <em>streaming</em> del conjunto FreeLaw del <em>Pile</em>, que es un dataset de 51 GB con opiniones legales de las cortes en Estados Unidos.",Xs,Ue,vs,ge,Ns,$e,ba="Este dataset es lo suficientemente grande como para llevar al límite la RAM de la mayoría de computadores portátiles. Sin embargo, ¡podemos cargarla y acceder a el sin esfuerzo! Ahora combinemos los ejemplos de FreeLaw y PubMed usando la función <code>interleave_datasets()</code>:",_s,Ie,zs,Be,Qs,xe,fa="Usamos la función <code>islice()</code> del módulo <code>itertools</code> de Python para seleccionar los primeros dos ejemplos del dataset combinado y podemos ver que corresponden con los primeros dos ejemplos de cada uno de los dos datasets de origen.",Ys,Ge,wa="Finalmente, si quieres hacer <em>streaming</em> del <em>Pile</em> de 825 GB en su totalidad, puedes usar todos los archivos preparados de la siguiente manera:",Hs,Ze,Fs,Ve,As,$,Ss,We,Ua="Ya tienes todas las herramientas para cargar y procesar datasets de todas las formas y tamaños, pero a menos que seas muy afortunado, llegará un punto en tu camino de PLN en el que tendrás que crear el dataset tu mismo para resolver tu problema particular. De esto hablaremos en la siguiente sección.",Ds,ke,Ls,Re,qs;return I=new Xa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new Ps({props:{title:"¿Big data? 🤗 ¡Datasets al rescate!",local:"big-data--datasets-al-rescate",headingTag:"h1"}}),x=new _a({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"}]}}),V=new Na({props:{id:"JwISwTCPPWo"}}),k=new Ps({props:{title:"¿Qué es el Pile?",local:"qué-es-el-pile",headingTag:"h2"}}),C=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwRXN0byUyMHRvbWElMjBhbGd1bm9zJTIwbWludXRvcyUyMHBhcmElMjBlamVjdXRhcnNlJTJDJTIwYXMlQzMlQUQlMjBxdWUlMjB2ZSUyMHBvciUyMHVuJTIwdGUlMjBvJTIwdW4lMjBjYWYlQzMlQTklMjBtaWVudHJhcyUyMGVzcGVyYXMlMjAlM0EpJTBBZGF0YV9maWxlcyUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGbXlzdGljLnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRlBVQk1FRF90aXRsZV9hYnN0cmFjdHNfMjAxOV9iYXNlbGluZS5qc29ubC56c3QlMjIlMEFwdWJtZWRfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXB1Ym1lZF9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Esto toma algunos minutos para ejecutarse, así que ve por un te o un café mientras esperas :)</span>
data_files = <span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile_preliminary_components/PUBMED_title_abstracts_2019_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),v=new T({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),f=new Ce({props:{$$slots:{default:[za]},$$scope:{ctx:b}}}),z=new T({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Q=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),H=new Ps({props:{title:"La magia de la proyección en memoria",local:"la-magia-de-la-proyección-en-memoria",headingTag:"h2"}}),A=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),D=new T({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGVzdCVDMyVBMSUyMGV4cHJlc2FkbyUyMGVuJTIwYnl0ZXMlMkMlMjBhcyVDMyVBRCUyMHF1ZSUyMGxvJTIwY29udmVydGltb3MlMjBlbiUyMG1lZ2FieXRlcyUwQXByaW50KGYlMjJSQU0lMjB1c2VkJTNBJTIwJTdCcHN1dGlsLlByb2Nlc3MoKS5tZW1vcnlfaW5mbygpLnJzcyUyMCUyRiUyMCgxMDI0JTIwKiUyMDEwMjQpJTNBLjJmJTdEJTIwTUIlMjIp",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info está expresado en bytes, así que lo convertimos en megabytes</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),L=new T({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),P=new T({props:{code:"cHJpbnQoZiUyMk51bWJlciUyMG9mJTIwZmlsZXMlMjBpbiUyMGRhdGFzZXQlMjAlM0ElMjAlN0JwdWJtZWRfZGF0YXNldC5kYXRhc2V0X3NpemUlN0QlMjIpJTBBc2l6ZV9nYiUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSUyMCUyRiUyMCgxMDI0KiozKSUwQXByaW50KGYlMjJEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwJTdCc2l6ZV9nYiUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of files in dataset : <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),O=new T({props:{code:"TnVtYmVyJTIwb2YlMjBmaWxlcyUyMGluJTIwZGF0YXNldCUyMCUzQSUyMDIwOTc5NDM3MDUxJTBBRGF0YXNldCUyMHNpemUlMjAoY2FjaGUlMjBmaWxlKSUyMCUzQSUyMDE5LjU0JTIwR0I=",highlighted:`Number of files <span class="hljs-keyword">in</span> dataset : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),w=new Ce({props:{$$slots:{default:[Qa]},$$scope:{ctx:b}}}),ae=new T({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),le=new T({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),U=new Ce({props:{$$slots:{default:[Ya]},$$scope:{ctx:b}}}),ne=new Ps({props:{title:"Haciendo streaming de datasets",local:"haciendo-streaming-de-datasets",headingTag:"h2"}}),pe=new T({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),oe=new T({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),de=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),Me=new T({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new Ce({props:{$$slots:{default:[Ha]},$$scope:{ctx:b}}}),Je=new T({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),ye=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>}`,wrap:!1}}),je=new T({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),he=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzUlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnQ2xpbmljYWwlMjBzaWducyUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjB3aXRoJTIwYWN1dGUlMjBsb3dlciUyMHJlc3BpcmF0b3J5JTIwaW5mZWN0aW9uJTNBJTIwaW5kaWNhdG9ycyUyMG9mJTIwb3h5Z2VuJTIwdGhlcmFweSUyMC4uLiclN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NiUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCUyMkh5cG94YWVtaWElMjBpbiUyMGNoaWxkcmVuJTIwd2l0aCUyMHNldmVyZSUyMHBuZXVtb25pYSUyMGluJTIwUGFwdWElMjBOZXclMjBHdWluZWElMjAuLi4lMjIlN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NyUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCdPeHlnZW4lMjBjb25jZW50cmF0b3JzJTIwYW5kJTIwY3lsaW5kZXJzJTIwLi4uJyU3RCUyQyUwQSUyMCU3QidtZXRhJyUzQSUyMCU3QidwbWlkJyUzQSUyMDExNDA5NTc4JTJDJTIwJ2xhbmd1YWdlJyUzQSUyMCdlbmcnJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJ094eWdlbiUyMHN1cHBseSUyMGluJTIwcnVyYWwlMjBhZnJpY2ElM0ElMjBhJTIwcGVyc29uYWwlMjBleHBlcmllbmNlJTIwLi4uJyU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>}]`,wrap:!1}}),fe=new T({props:{code:"JTIzJTIwU2FsdGElMjBsYXMlMjBwcmltZXJhcyUyMDEwMDAlMjBtdWVzdHJhcyUyMGUlMjBpbmNsdXllJTIwZWwlMjByZXN0byUyMGVuJTIwZWwlMjBjb25qdW50byUyMGRlJTIwZW50cmVuYW1pZW50byUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnNraXAoMTAwMCklMEElMjMlMjBUb21hJTIwbGFzJTIwcHJpbWVyYXMlMjAxMDAwJTIwbXVlc3RyYXMlMjBwYXJhJTIwZWwlMjBjb25qdW50byUyMGRlJTIwdmFsaWRhY2klQzMlQjNuJTBBdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc2h1ZmZsZWRfZGF0YXNldC50YWtlKDEwMDAp",highlighted:`<span class="hljs-comment"># Salta las primeras 1000 muestras e incluye el resto en el conjunto de entrenamiento</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Toma las primeras 1000 muestras para el conjunto de validación</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),Ue=new T({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRm15c3RpYy50aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlX3ByZWxpbWluYXJ5X2NvbXBvbmVudHMlMkZGcmVlTGF3X09waW5pb25zLmpzb25sLnpzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTBBKSUwQW5leHQoaXRlcihsYXdfZGF0YXNldF9zdHJlYW1lZCkp",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),ge=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),Ie=new T({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),Be=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),Ze=new T({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRm15c3RpYy50aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlJTJGJTIyJTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYWluJTIyJTNBJTIwJTVCYmFzZV91cmwlMjAlMkIlMjAlMjJ0cmFpbiUyRiUyMiUyMCUyQiUyMGYlMjIlN0JpZHglM0EwMmQlN0QuanNvbmwuenN0JTIyJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZSgzMCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2YWxpZGF0aW9uJTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ2YWwuanNvbmwuenN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUzQSUyMGJhc2VfdXJsJTIwJTJCJTIwJTIydGVzdC5qc29ubC56c3QlMjIlMkMlMEElN0QlMEFwaWxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFuZXh0KGl0ZXIocGlsZV9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpKQ==",highlighted:`base_url = <span class="hljs-string">&quot;https://mystic.the-eye.eu/public/AI/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),Ve=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),$=new Ce({props:{$$slots:{default:[Fa]},$$scope:{ctx:b}}}),ke=new va({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter5/4.mdx"}}),{c(){i=u("meta"),j=t(),M=u("p"),h=t(),p(I.$$.fragment),Xe=t(),p(B.$$.fragment),ve=t(),p(x.$$.fragment),Ne=t(),G=u("p"),G.innerHTML=Os,_e=t(),Z=u("p"),Z.innerHTML=Ks,ze=t(),p(V.$$.fragment),Qe=t(),W=u("p"),W.innerHTML=ea,Ye=t(),p(k.$$.fragment),He=t(),R=u("p"),R.innerHTML=sa,Fe=t(),p(C.$$.fragment),Ae=t(),E=u("p"),E.innerHTML=aa,Se=t(),p(X.$$.fragment),De=t(),p(v.$$.fragment),Le=t(),N=u("p"),N.textContent=la,qe=t(),p(f.$$.fragment),Pe=t(),_=u("p"),_.textContent=ta,Oe=t(),p(z.$$.fragment),Ke=t(),p(Q.$$.fragment),es=t(),Y=u("p"),Y.textContent=na,ss=t(),p(H.$$.fragment),as=t(),F=u("p"),F.innerHTML=ia,ls=t(),p(A.$$.fragment),ts=t(),S=u("p"),S.innerHTML=pa,ns=t(),p(D.$$.fragment),is=t(),p(L.$$.fragment),ps=t(),q=u("p"),q.innerHTML=ra,rs=t(),p(P.$$.fragment),os=t(),p(O.$$.fragment),ds=t(),K=u("p"),K.textContent=oa,ms=t(),p(w.$$.fragment),cs=t(),ee=u("p"),ee.innerHTML=da,Ms=t(),se=u("p"),se.innerHTML=ma,us=t(),p(ae.$$.fragment),Js=t(),p(le.$$.fragment),ys=t(),te=u("p"),te.innerHTML=ca,Ts=t(),p(U.$$.fragment),js=t(),p(ne.$$.fragment),hs=t(),ie=u("p"),ie.innerHTML=Ma,bs=t(),p(pe.$$.fragment),fs=t(),re=u("p"),re.innerHTML=ua,ws=t(),p(oe.$$.fragment),Us=t(),p(de.$$.fragment),gs=t(),me=u("p"),me.innerHTML=Ja,$s=t(),p(ce.$$.fragment),Is=t(),p(Me.$$.fragment),Bs=t(),p(g.$$.fragment),xs=t(),ue=u("p"),ue.innerHTML=ya,Gs=t(),p(Je.$$.fragment),Zs=t(),p(ye.$$.fragment),Vs=t(),Te=u("p"),Te.innerHTML=Ta,Ws=t(),p(je.$$.fragment),ks=t(),p(he.$$.fragment),Rs=t(),be=u("p"),be.innerHTML=ja,Cs=t(),p(fe.$$.fragment),Es=t(),we=u("p"),we.innerHTML=ha,Xs=t(),p(Ue.$$.fragment),vs=t(),p(ge.$$.fragment),Ns=t(),$e=u("p"),$e.innerHTML=ba,_s=t(),p(Ie.$$.fragment),zs=t(),p(Be.$$.fragment),Qs=t(),xe=u("p"),xe.innerHTML=fa,Ys=t(),Ge=u("p"),Ge.innerHTML=wa,Hs=t(),p(Ze.$$.fragment),Fs=t(),p(Ve.$$.fragment),As=t(),p($.$$.fragment),Ss=t(),We=u("p"),We.textContent=Ua,Ds=t(),p(ke.$$.fragment),Ls=t(),Re=u("p"),this.h()},l(e){const s=Ca("svelte-u9bgzb",document.head);i=J(s,"META",{name:!0,content:!0}),s.forEach(a),j=n(e),M=J(e,"P",{}),Ga(M).forEach(a),h=n(e),r(I.$$.fragment,e),Xe=n(e),r(B.$$.fragment,e),ve=n(e),r(x.$$.fragment,e),Ne=n(e),G=J(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1f54zhv"&&(G.innerHTML=Os),_e=n(e),Z=J(e,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-d2mhm9"&&(Z.innerHTML=Ks),ze=n(e),r(V.$$.fragment,e),Qe=n(e),W=J(e,"P",{"data-svelte-h":!0}),y(W)!=="svelte-i1zyge"&&(W.innerHTML=ea),Ye=n(e),r(k.$$.fragment,e),He=n(e),R=J(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-11cis2"&&(R.innerHTML=sa),Fe=n(e),r(C.$$.fragment,e),Ae=n(e),E=J(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1dwk9ms"&&(E.innerHTML=aa),Se=n(e),r(X.$$.fragment,e),De=n(e),r(v.$$.fragment,e),Le=n(e),N=J(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-jezns1"&&(N.textContent=la),qe=n(e),r(f.$$.fragment,e),Pe=n(e),_=J(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1yptpo5"&&(_.textContent=ta),Oe=n(e),r(z.$$.fragment,e),Ke=n(e),r(Q.$$.fragment,e),es=n(e),Y=J(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-19647cu"&&(Y.textContent=na),ss=n(e),r(H.$$.fragment,e),as=n(e),F=J(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-1hggqvf"&&(F.innerHTML=ia),ls=n(e),r(A.$$.fragment,e),ts=n(e),S=J(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-q3e312"&&(S.innerHTML=pa),ns=n(e),r(D.$$.fragment,e),is=n(e),r(L.$$.fragment,e),ps=n(e),q=J(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1yzomxf"&&(q.innerHTML=ra),rs=n(e),r(P.$$.fragment,e),os=n(e),r(O.$$.fragment,e),ds=n(e),K=J(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-gbjr33"&&(K.textContent=oa),ms=n(e),r(w.$$.fragment,e),cs=n(e),ee=J(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-1caqt7j"&&(ee.innerHTML=da),Ms=n(e),se=J(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-lono31"&&(se.innerHTML=ma),us=n(e),r(ae.$$.fragment,e),Js=n(e),r(le.$$.fragment,e),ys=n(e),te=J(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-1bm8p1s"&&(te.innerHTML=ca),Ts=n(e),r(U.$$.fragment,e),js=n(e),r(ne.$$.fragment,e),hs=n(e),ie=J(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-1q944vj"&&(ie.innerHTML=Ma),bs=n(e),r(pe.$$.fragment,e),fs=n(e),re=J(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-1g710sv"&&(re.innerHTML=ua),ws=n(e),r(oe.$$.fragment,e),Us=n(e),r(de.$$.fragment,e),gs=n(e),me=J(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-13wilwe"&&(me.innerHTML=Ja),$s=n(e),r(ce.$$.fragment,e),Is=n(e),r(Me.$$.fragment,e),Bs=n(e),r(g.$$.fragment,e),xs=n(e),ue=J(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1xcnytx"&&(ue.innerHTML=ya),Gs=n(e),r(Je.$$.fragment,e),Zs=n(e),r(ye.$$.fragment,e),Vs=n(e),Te=J(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-11axkfp"&&(Te.innerHTML=Ta),Ws=n(e),r(je.$$.fragment,e),ks=n(e),r(he.$$.fragment,e),Rs=n(e),be=J(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-8b249"&&(be.innerHTML=ja),Cs=n(e),r(fe.$$.fragment,e),Es=n(e),we=J(e,"P",{"data-svelte-h":!0}),y(we)!=="svelte-air9qn"&&(we.innerHTML=ha),Xs=n(e),r(Ue.$$.fragment,e),vs=n(e),r(ge.$$.fragment,e),Ns=n(e),$e=J(e,"P",{"data-svelte-h":!0}),y($e)!=="svelte-1pb4ctq"&&($e.innerHTML=ba),_s=n(e),r(Ie.$$.fragment,e),zs=n(e),r(Be.$$.fragment,e),Qs=n(e),xe=J(e,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-v77nbg"&&(xe.innerHTML=fa),Ys=n(e),Ge=J(e,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1yvx41e"&&(Ge.innerHTML=wa),Hs=n(e),r(Ze.$$.fragment,e),Fs=n(e),r(Ve.$$.fragment,e),As=n(e),r($.$$.fragment,e),Ss=n(e),We=J(e,"P",{"data-svelte-h":!0}),y(We)!=="svelte-clgpvd"&&(We.textContent=Ua),Ds=n(e),r(ke.$$.fragment,e),Ls=n(e),Re=J(e,"P",{}),Ga(Re).forEach(a),this.h()},h(){Za(i,"name","hf:doc:metadata"),Za(i,"content",Sa)},m(e,s){Ea(document.head,i),l(e,j,s),l(e,M,s),l(e,h,s),o(I,e,s),l(e,Xe,s),o(B,e,s),l(e,ve,s),o(x,e,s),l(e,Ne,s),l(e,G,s),l(e,_e,s),l(e,Z,s),l(e,ze,s),o(V,e,s),l(e,Qe,s),l(e,W,s),l(e,Ye,s),o(k,e,s),l(e,He,s),l(e,R,s),l(e,Fe,s),o(C,e,s),l(e,Ae,s),l(e,E,s),l(e,Se,s),o(X,e,s),l(e,De,s),o(v,e,s),l(e,Le,s),l(e,N,s),l(e,qe,s),o(f,e,s),l(e,Pe,s),l(e,_,s),l(e,Oe,s),o(z,e,s),l(e,Ke,s),o(Q,e,s),l(e,es,s),l(e,Y,s),l(e,ss,s),o(H,e,s),l(e,as,s),l(e,F,s),l(e,ls,s),o(A,e,s),l(e,ts,s),l(e,S,s),l(e,ns,s),o(D,e,s),l(e,is,s),o(L,e,s),l(e,ps,s),l(e,q,s),l(e,rs,s),o(P,e,s),l(e,os,s),o(O,e,s),l(e,ds,s),l(e,K,s),l(e,ms,s),o(w,e,s),l(e,cs,s),l(e,ee,s),l(e,Ms,s),l(e,se,s),l(e,us,s),o(ae,e,s),l(e,Js,s),o(le,e,s),l(e,ys,s),l(e,te,s),l(e,Ts,s),o(U,e,s),l(e,js,s),o(ne,e,s),l(e,hs,s),l(e,ie,s),l(e,bs,s),o(pe,e,s),l(e,fs,s),l(e,re,s),l(e,ws,s),o(oe,e,s),l(e,Us,s),o(de,e,s),l(e,gs,s),l(e,me,s),l(e,$s,s),o(ce,e,s),l(e,Is,s),o(Me,e,s),l(e,Bs,s),o(g,e,s),l(e,xs,s),l(e,ue,s),l(e,Gs,s),o(Je,e,s),l(e,Zs,s),o(ye,e,s),l(e,Vs,s),l(e,Te,s),l(e,Ws,s),o(je,e,s),l(e,ks,s),o(he,e,s),l(e,Rs,s),l(e,be,s),l(e,Cs,s),o(fe,e,s),l(e,Es,s),l(e,we,s),l(e,Xs,s),o(Ue,e,s),l(e,vs,s),o(ge,e,s),l(e,Ns,s),l(e,$e,s),l(e,_s,s),o(Ie,e,s),l(e,zs,s),o(Be,e,s),l(e,Qs,s),l(e,xe,s),l(e,Ys,s),l(e,Ge,s),l(e,Hs,s),o(Ze,e,s),l(e,Fs,s),o(Ve,e,s),l(e,As,s),o($,e,s),l(e,Ss,s),l(e,We,s),l(e,Ds,s),o(ke,e,s),l(e,Ls,s),l(e,Re,s),qs=!0},p(e,[s]){const ga={};s&2&&(ga.$$scope={dirty:s,ctx:e}),f.$set(ga);const $a={};s&2&&($a.$$scope={dirty:s,ctx:e}),w.$set($a);const Ia={};s&2&&(Ia.$$scope={dirty:s,ctx:e}),U.$set(Ia);const Ba={};s&2&&(Ba.$$scope={dirty:s,ctx:e}),g.$set(Ba);const xa={};s&2&&(xa.$$scope={dirty:s,ctx:e}),$.$set(xa)},i(e){qs||(d(I.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(V.$$.fragment,e),d(k.$$.fragment,e),d(C.$$.fragment,e),d(X.$$.fragment,e),d(v.$$.fragment,e),d(f.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(w.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(U.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(g.$$.fragment,e),d(Je.$$.fragment,e),d(ye.$$.fragment,e),d(je.$$.fragment,e),d(he.$$.fragment,e),d(fe.$$.fragment,e),d(Ue.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(Ze.$$.fragment,e),d(Ve.$$.fragment,e),d($.$$.fragment,e),d(ke.$$.fragment,e),qs=!0)},o(e){m(I.$$.fragment,e),m(B.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m(X.$$.fragment,e),m(v.$$.fragment,e),m(f.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(w.$$.fragment,e),m(ae.$$.fragment,e),m(le.$$.fragment,e),m(U.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(g.$$.fragment,e),m(Je.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(Ue.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(Ve.$$.fragment,e),m($.$$.fragment,e),m(ke.$$.fragment,e),qs=!1},d(e){e&&(a(j),a(M),a(h),a(Xe),a(ve),a(Ne),a(G),a(_e),a(Z),a(ze),a(Qe),a(W),a(Ye),a(He),a(R),a(Fe),a(Ae),a(E),a(Se),a(De),a(Le),a(N),a(qe),a(Pe),a(_),a(Oe),a(Ke),a(es),a(Y),a(ss),a(as),a(F),a(ls),a(ts),a(S),a(ns),a(is),a(ps),a(q),a(rs),a(os),a(ds),a(K),a(ms),a(cs),a(ee),a(Ms),a(se),a(us),a(Js),a(ys),a(te),a(Ts),a(js),a(hs),a(ie),a(bs),a(fs),a(re),a(ws),a(Us),a(gs),a(me),a($s),a(Is),a(Bs),a(xs),a(ue),a(Gs),a(Zs),a(Vs),a(Te),a(Ws),a(ks),a(Rs),a(be),a(Cs),a(Es),a(we),a(Xs),a(vs),a(Ns),a($e),a(_s),a(zs),a(Qs),a(xe),a(Ys),a(Ge),a(Hs),a(Fs),a(As),a(Ss),a(We),a(Ds),a(Ls),a(Re)),a(i),c(I,e),c(B,e),c(x,e),c(V,e),c(k,e),c(C,e),c(X,e),c(v,e),c(f,e),c(z,e),c(Q,e),c(H,e),c(A,e),c(D,e),c(L,e),c(P,e),c(O,e),c(w,e),c(ae,e),c(le,e),c(U,e),c(ne,e),c(pe,e),c(oe,e),c(de,e),c(ce,e),c(Me,e),c(g,e),c(Je,e),c(ye,e),c(je,e),c(he,e),c(fe,e),c(Ue,e),c(ge,e),c(Ie,e),c(Be,e),c(Ze,e),c(Ve,e),c($,e),c(ke,e)}}}const Sa='{"title":"¿Big data? 🤗 ¡Datasets al rescate!","local":"big-data--datasets-al-rescate","sections":[{"title":"¿Qué es el Pile?","local":"qué-es-el-pile","sections":[],"depth":2},{"title":"La magia de la proyección en memoria","local":"la-magia-de-la-proyección-en-memoria","sections":[],"depth":2},{"title":"Haciendo streaming de datasets","local":"haciendo-streaming-de-datasets","sections":[],"depth":2}],"depth":1}';function Da(b){return Wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ll extends ka{constructor(i){super(),Ra(this,i,Da,Aa,Va,{})}}export{ll as component};
