import{s as _o,o as Qo,n as Wo}from"../chunks/scheduler.cc52f4b9.js";import{S as Ao,i as Ro,e as o,s as n,c as i,h as No,a as p,d as l,b as a,f as Bo,g as c,j as r,k as ia,l as Xo,m as t,n as m,t as M,o as u,p as d}from"../chunks/index.f7fb5439.js";import{T as Go}from"../chunks/Tip.c708fc3b.js";import{C as Lo,E as Ho}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4aef24b6.js";import{Y as Eo}from"../chunks/Youtube.5391c1b7.js";import{C as y}from"../chunks/CodeBlock.c4d86f9a.js";import{C as Do}from"../chunks/CourseFloatingBanner.9c415528.js";import{H as ul}from"../chunks/Heading.b75cdeb1.js";function So(dl){let J,f=`<strong>Para ir más allá</strong> Si pruebas las dos versiones de los normalizadores previos en un string conteniendo un caracter unicode <code>u&quot;\\u0085&quot;</code>
de seguro notarás que los dos normalizadores no son exactamente equivalentes.
Para no sobre-complicar demasiado la version con <code>normalizers.Sequence</code>, no hemos incluido los reemplazos usando Expresiones Regulares (Regex) que el <code>BertNormalizer</code> requiere cuando el argumento <code>clean_text</code> se fija como <code>True</code> - lo cual es el comportamiento por defecto. Pero no te preocupes, es posible obtener la misma normalización sin usar el útil <code>BertNormalizer</code> agregando dos <code>normalizers.Replace</code> a la secuencia de normalizadores.`;return{c(){J=o("p"),J.innerHTML=f},l(j){J=p(j,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18c2t8f"&&(J.innerHTML=f)},m(j,ml){t(j,J,ml)},p:Wo,d(j){j&&l(J)}}}function Po(dl){let J,f,j,ml,b,yl,U,Jl,$,jl,g,ca="Como hemos visto en las secciones previas, la tokenización está compuesta de varias etapas:",Tl,w,ma="<li>Normalización (cualquier limpieza del texto que se considere necesaria, tales como remover espacios o acentos, normalización Unicode, etc.)</li> <li>Pre-tokenización (separar la entrada en palabras)</li> <li>Pasar las entradas (inputs) por el modelo (usar las palabras pre-tokenizadas para producir una secuencia de tokens)</li> <li>Post-procesamiento (agregar tokens especiales del tokenizador, generando la máscara de atención (attention mask) y los IDs de tipo de token)</li>",kl,h,Ma="Como recordatorio, acá hay otro vistazo al proceso en totalidad:",fl,T,ua='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',bl,x,da='La librería 🤗 Tokenizers ha sido construida para proveer varias opciones para cada una de esas etapas, las cuales se pueden mezclar y combinar. En esta sección veremos cómo podemos construir un tokenizador desde cero, opuesto al entrenamiento de un nuevo tokenizador a partir de uno existente como hicimos en la <a href="/course/chapter6/2">Sección 2</a>. Después de esto, serás capaz de construir cualquier tipo de tokenizador que puedas imaginar!',Ul,z,$l,I,ya="De manera más precisa, la librería está construida a partir de una clase central <code>Tokenizer</code> con las unidades más básica reagrupadas en susbmódulos:",gl,C,Ja='<li><code>normalizers</code> contiene todos los posibles tipos de <code>Normalizer</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">aquí</a>).</li> <li><code>pre_tokenizers</code> contiene todos los posibles tipos de <code>PreTokenizer</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">aquí</a>).</li> <li><code>models</code> contiene los distintos tipos de <code>Model</code> que puedes usar, como <code>BPE</code>, <code>WordPiece</code>, and <code>Unigram</code> (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">aquí</a>).</li> <li><code>trainers</code> contiene todos los distintos tipos de <code>Trainer</code> que puedes usar para entrenar tu modelo en un corpus (uno por cada tipo de modelo; la lista completa <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">aquí</a>).</li> <li><code>post_processors</code> contiene varios tipos de <code>PostProcessor</code> que puedes usar (la lista completa <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">aquí</a>).</li> <li><code>decoders</code> contiene varios tipos de <code>Decoder</code> que puedes usar para decodificar las salidas de la tokenización (la lista completa <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">aquí</a>).</li>',wl,v,ja='Puedes encontrar la lista completas de las unidades más básicas <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">aquí</a>.',hl,Z,xl,q,Ta='Para entrenar nuestro nuevo tokenizador, usaremos un pequeño corpus de texto (para que los ejemplos se ejecuten rápido). Los pasos para adquirir el corpus son similares a los que tomamos al <a href="/course/chapter6/2">beginning of this chapter</a>, pero esta vez usaremos el conjunto de datos <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>:',zl,V,Il,B,ka="La función <code>get_training_corpus()</code> es un generador que entregará lotes de 1.000 textos, los cuales usaremos para entrenar el tokenizador.",Cl,_,fa="🤗 Tokenizers puedes también ser entrenada en archivos de textos directamente. Así es como podemos generar un archivo de texto conteniendo todos los textos/entradas de WikiText-2 que podemos usar localmente:",vl,Q,Zl,W,ba="A continuación mostraremos como construir tu propios propios tokenizadores BERT, GPT-2 y XLNet, bloque por bloque. Esto nos dará un ejemplo de cada una de los tres principales algoritmos de tokenización: WordPiece, BPE y Unigram. Empecemos con BERT!",ql,A,Vl,R,Ua="Para construir un tokenizador con la librería 🤗 Tokenizers, empezamos instanciando un objeto <code>Tokenizer</code> con un <code>model</code>, luego fijamos sus atributos <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code>, y <code>decoder</code> a los valores que queremos.",Bl,N,$a="Para este ejemplo, crearemos un <code>Tokenizer</code> con modelo WordPiece:",_l,X,Ql,G,ga="Tenemos que especificar el <code>unk_token</code> para que el modelo sepa que retornar si encuentra caracteres que no ha visto antes. Otros argumentos que podemos fijar acá incluyen el <code>vocab</code> de nuestro modelo (vamos a entrenar el modelo, por lo que no necesitamos fijar esto) y <code>max_input_chars_per_word</code>, el cual especifica el largo máximo para cada palabra (palabras más largas que el valor pasado se serpararán).",Wl,L,wa="El primer paso de la tokenización es la normalizacion, así que empecemos con eso. Dado que BERT es ampliamente usado, hay un <code>BertNormalizer</code> con opciones clásicas que podemos fijar para BERT: <code>lowercase</code> (transformar a minúsculas) y <code>strip_accents</code> (eliminar acentos); <code>clean_text</code> para remover todos los caracteres de control y reemplazar espacios repetidos en uno solo; y <code>handle_chinese_chars</code> el cual coloca espacios alrededor de los caracteres en Chino. Para replicar el tokenizador <code>bert-base-uncased</code>, basta con fijar este normalizador:",Al,H,Rl,E,ha="Sin embargo, en términos generales, cuando se construye un nuevo tokenizador no tendrás acceso a tan útil normalizador ya implementado en la librería 🤗 Tokenizers — por lo que veamos como crear el normalizador BERT a mano. La librería provee un normalizador <code>Lowercase</code> y un normalizador <code>StripAccents</code>, y puedes componer varios normalizadores usando un <code>Sequence</code> (secuencia):",Nl,D,Xl,S,xa="También estamos usando un normalizador Unicode <code>NFD</code>, ya que de otra manera el normalizador <code>StripAccents</code> no reconocerá apropiadamente los caracteres acentuados y por lo tanto, no los eliminará.",Gl,P,za="Como hemos visto antes, podemos usar el método <code>normalize_str()</code> del <code>normalizer</code> para chequear los efectos que tiene en un texto dado:",Ll,Y,Hl,F,El,k,Dl,K,Ia="A continuación está la etapa de pre-tokenización. De nuevo, hay un <code>BertPreTokenizer</code> pre-hecho que podemos usar:",Sl,O,Pl,ee,Ca="O podemos constuirlo desde cero:",Yl,se,Fl,le,va="Nota que el pre-tokenizador <code>Whitespace</code> separa en espacios en blando y todos los caracteres que no son letras, dígitos o el guión bajo/guión al piso (_), por lo que técnicamente separa en espacios en blanco y puntuación:",Kl,te,Ol,ne,et,ae,Za="Si sólo quieres separar en espacios en blanco, deberías usar el pre-tokenizador <code>WhitespaceSplit</code>:",st,oe,lt,pe,tt,re,qa="Al igual que con los normalizadores, puedes un <code>Sequence</code> para componer varios pre-tokenizadores:",nt,ie,at,ce,ot,me,Va="El siguiente paso en el pipeline de tokenización es pasar las entradas a través del modelo. Ya especificamos nuestro modelo en la inicialización, pero todavía necesitamos entrenarlo, lo cual requerirá un <code>WordPieceTrainer</code>. El aspecto principal a recordar cuando se instancia un entrenador (trainer) en 🤗 Tokenizers es que necesitas pasarle todos los tokens especiales que tiene la intención de usar — de otra manera no los agregará al vocabulario, dado que que no están en el corpus de entrenamiento:",pt,Me,rt,ue,Ba="Al igual que especificar <code>vocab_size</code> y <code>special_tokens</code>, podemos fijar <code>min_frequency</code> (el número de veces que un token debe aparecer para ser incluido en el vocabulario) o cambiar <code>continuing_subword_prefix</code> (si queremos usar algo diferente a <code>##</code>).",it,de,_a="Para entrenar nuestro modelo usando el iterador que definimos antes, tenemos que ejecutar el siguiente comando:",ct,ye,mt,Je,Qa="También podemos usar archivos de texto para entrenar nuestro tokenizador, lo cual se vería así (reinicializamos el modelo con un <code>WordPiece</code> vacío de antemano):",Mt,je,ut,Te,Wa="En ambos casos, podemos probar el tokenizador en un texto llamando al método `encode:",dt,ke,yt,fe,Jt,be,Aa="El <code>encoding</code> (codificación) obtenido es un objeto <code>Encoding</code>, el cual contiene todas las salidas necesarias del tokenizador y sus distintos atributos: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code>, y <code>overflowing</code>.",jt,Ue,Ra="El último paso en el pipeline de tokenización es el post-procesamiento. Necesitamos agregar el token <code>[CLS]</code> al inicio y el token <code>[SEP]</code> al final (o después de cada oración, si tenemos un par de oraciones). Usaremos un <code>TemplateProcessor</code> para esto, pero primero necesitamos conocer los IDs de los tokens <code>[CLS]</code> y <code>[SEP]</code> en el vocabulario:",Tt,$e,kt,ge,ft,we,Na="Para escribir la plantilla (template) para un <code>TemplateProcessor</code>, tenemos que especificar como tratar una sóla oración y un par de oraciones. Para ambos, escribimos los tokens especiales que queremos usar; la primera oración se representa por <code>$A</code>, mientras que la segunda oración (si se está codificando un par) se representa por <code>$B</code>. Para cada uno de estos (tokens especiales y oraciones), también especificamos el ID del tipo de token correspondiente después de un dos puntos (:).",bt,he,Xa="La clásica plantilla para BERT se define como sigue:",Ut,xe,$t,ze,Ga="Nota que necesitamos pasar los IDs de los tokens especiales, para que el tokenizador pueda convertirlos apropiadamente a sus IDs.",gt,Ie,La="Una vez que se agrega esto, volviendo a nuestro ejemplo anterior nos dará:",wt,Ce,ht,ve,xt,Ze,Ha="Y en un par de oraciones, obtenemos el resultado apropiado:",zt,qe,It,Ve,Ct,Be,Ea="Ya casi finalizamos de construir este tokenizador desde cero — el último paso es incluir un decodificador:",vt,_e,Zt,Qe,Da="Probemoslo en nuestro <code>encoding</code> previo:",qt,We,Vt,Ae,Bt,Re,Sa="Genial! Ahora podemos guardar nuestro tokenizador en un archivo JSON así:",_t,Ne,Qt,Xe,Pa="Podemos cargar ese archivo en un objeto <code>Tokenizer</code> con el método <code>from_file()</code>:",Wt,Ge,At,Le,Ya="Para usar este tokenizador en 🤗 Transformers, tenemos que envolverlo en un <code>PreTrainedTokenizerFast</code>. Podemos usar una clase generica o, si nuestro tokenizador corresponde un modelo existente, usar esa clase (en este caso, <code>BertTokenizerFast</code>). Si aplicas esta lección para construir un tokenizador nuevo de paquete, tendrás que usar la primera opción.",Rt,He,Fa="Para envolver el tokenizador en un <code>PreTrainedTokenizerFast</code>, podemos pasar el tokenizador que construimos como un <code>tokenizer_object</code> o pasar el archivo del tokenizador que guardarmos como <code>tokenizer_file</code>. El aspecto clave a recordar es que tenemos que manualmente fijar los tokens especiales, dado que la clase no puede inferir del objeto <code>tokenizer</code> qué token es el el token de enmascaramiento (mask token), el token <code>[CLS]</code>, etc.:",Nt,Ee,Xt,De,Ka="Si estás usando una clase de tokenizador específico (como <code>BertTokenizerFast</code>), sólo necesitarás especificar los tokens especiales diferentes a los que están por defecto (en este caso, ninguno):",Gt,Se,Lt,Pe,Oa="Luego puedes usar este tokenizador como cualquier otro tokenizador de 🤗 Transformers. Puedes guardarlo con el método <code>save_pretrained()</code>, o subirlo al Hub con el método <code>push_to_hub()</code>.",Ht,Ye,eo="Ahora que hemos visto como construir el tokenizador WordPiece, hagamos lo mismo para un tokenizador BPE.  Iremos un poco más rápido dato que conoces todos los pasos, y sólo destacaremos las diferencias.",Et,Fe,Dt,Ke,so="Ahora construyamos un tokenizador GPT-2. Al igual que el tokenizador BERT, empezamos inicializando un <code>Tokenizer</code> con un modelo BPE:",St,Oe,Pt,es,lo="También al igual que BERT, podríamos inicializar este modelo con un vocabulario si tuviéramos uno (necesitaríamos pasar el <code>vocab</code> y <code>merges</code>, en este caso), pero dado que entrenaremos desde cero, no necesitaremos hacer eso. Tampoco necesitamos especificar <code>unk_token</code> porque GPT-2 utiliza un byte-level BPE, que no lo requiere.",Yt,ss,to="GPT-2 no usa un normalizador, por lo que nos saltamos este paso y vamos directo a la pre-tokenización:",Ft,ls,Kt,ts,no="La opción que agregada acá <code>ByteLevel</code> es para no agregar un espacio al inicio de una oración (el cuál es el valor por defecto). Podemos echar un vistazo a la pre-tokenización de un texto de ejemplo como antes:",Ot,ns,en,as,sn,os,ao="A continuación está el modelo, el cual necesita entrenamiento. Para GPT-2, el único token especial es el token de final de texto (end-of-text):",ln,ps,tn,rs,oo="Al igual que con el <code>WordPieceTrainer</code>, junto con <code>vocab_size</code> y <code>special_tokens</code>,  podemos especificar el <code>min_frequency</code> si queremos, o si tenemos un sufijo de fín de palabra (end-of-word suffix) (como <code>&lt;/w&gt;</code>), podemos fijarlo con <code>end_of_word_suffix</code>.",nn,is,po="Este tokenizador también se puede entrenar en archivos de textos:",an,cs,on,ms,ro="Echemos un vistazo a la tokenización de un texto de muestra:",pn,Ms,rn,us,cn,ds,io="Aplicaremos el post-procesamiento byte-level para el tokenizador GPT-2 como sigue:",mn,ys,Mn,Js,co="La opción <code>trim_offsets = False</code> indica al post-procesador que deberíamos dejar los offsets de los tokens que comiencen con ‘Ġ’ sin modificar: De esta manera el inicio de los offsets apuntarán al espacio antes de la palabra, no el primer caracter de la palabra (dado que el espacio es técnicamente parte del token). Miremos el resultado con el texto que acabamos de codificar, donde <code>&#39;Ġtest&#39;</code> el token en el índice 4:",un,js,dn,Ts,yn,ks,mo="Finalmente, agregamos un decodificador byte-level:",Jn,fs,jn,bs,Mo="y podemos chequear si funciona de manera apropiada:",Tn,Us,kn,$s,fn,gs,uo="Genial! Ahora que estamos listos, podemos guardar el tokenizador como antes, y envolverlo en un <code>PreTrainedTokenizerFast</code> o <code>GPT2TokenizerFast</code> si queremos usarlo en 🤗 Transformers:",bn,ws,Un,hs,yo="o:",$n,xs,gn,zs,Jo="Como en el último ejemplo, mostraremos cómo construir un tokenizador Unigram desde cero.",wn,Is,hn,Cs,jo="Construyamos un tokenizador XLNet. Al igual que los tokenizadores previos, empezamos inicializando un <code>Tokenizer</code> con un modelo Unigram:",xn,vs,zn,Zs,To="De nuevo, podríamos inicializar este modelo con un vocabulario si tuvieramos uno.",In,qs,ko="Para la normalización, XLNet utiliza unos pocos reemplazos (los cuales vienen de SentencePiece):",Cn,Vs,vn,Bs,fo="Esto reemplaza <code>“</code> y <code>”</code> con <code>”</code> y cualquier secuencia de dos o más espacios con un espacio simple, además remueve los acentos en el texto a tokenizar.",Zn,_s,bo="El pre-tokenizador a usar para cualquier tokenizador SentencePiece es <code>Metaspace</code>:",qn,Qs,Vn,Ws,Uo="Podemos echar un vistazo a la pre-tokenización de un texto de ejemplo como antes:",Bn,As,_n,Rs,Qn,Ns,$o="A continuación está el modelo, el cuál necesita entrenamiento. XLNet tiene varios tokens especiales:",Wn,Xs,An,Gs,go="Un argumento muy importante a no olvidar para el <code>UnigramTrainer</code> es el <code>unk_token</code>. También podemos pasarle otros argumentos específicos al algoritmo Unigram, tales como el <code>shrinking_factor</code> para cada paso donde removemos tokens (su valor por defecto es 0.75) o el <code>max_piece_length</code> para especificar el largo máximo de un token dado (su valor por defecto es 16).",Rn,Ls,wo="Este tokenizador también se puede entrenar en archivos de texto:",Nn,Hs,Xn,Es,ho="Ahora miremos la tokenización de un texto de muestra:",Gn,Ds,Ln,Ss,Hn,Ps,xo="Una peculiariodad de XLNet es que coloca el token <code>&lt;cls&gt;</code> al final de la oración, con un ID de tipo de 2 (para distinguirlo de los otros tokens). Como el resultado el resultado se rellena a la izquierda (left padding). Podemos lidiar con todos los tokens especiales y el token de ID de tipo con una plantilla, al igual que BERT, pero primero tenemos que obtener los IDs de los tokens <code>&lt;cls&gt;</code> y <code>&lt;sep&gt;</code>:",En,Ys,Dn,Fs,Sn,Ks,zo="La plantilla se ve así:",Pn,Os,Yn,el,Io="Y podemos probar si funciona codificando un par de oraciones:",Fn,sl,Kn,ll,On,tl,Co="Finalmente, agregamos el decodificador <code>Metaspace</code>:",ea,nl,sa,al,vo="y estamos listos con este tokenizador! Podemos guardar el tokenizador como antes, y envolverlo en un <code>PreTrainedTokenizerFast</code> o <code>XLNetTokenizerFast</code> si queremos usarlo en 🤗 Transformers. Una cosa a notar al usar <code>PreTrainedTokenizerFast</code> es que además de los tokens especiales, necesitamos decirle a la librería 🤗 Transformers que rellene a la izquierda (agregar left padding):",la,ol,ta,pl,Zo="O de manera alternativa:",na,rl,aa,il,qo="Ahora que has visto como varias de nuestras unidades más básicas se usan para construir tokenizadores existentes, deberías ser capaz de escribir cualquier tokenizador que quieras con la librería 🤗 Tokenizers y ser capaz de usarlo en la librería 🤗 Transformers.",oa,cl,pa,Ml,ra;return b=new Lo({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ul({props:{title:"Construir un tokenizador, bloque por bloque",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),$=new Do({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),z=new Eo({props:{id:"MR8tZm5ViWU"}}),Z=new ul({props:{title:"Adquirir un corpus",local:"acquiring-a-corpus",headingTag:"h2"}}),V=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),Q=new y({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),A=new ul({props:{title:"Construyendo un tokenizador WordPiece desde cero",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),H=new y({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new y({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),Y=new y({props:{code:"JTIzJTIwcHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-comment"># print(tokenizer.normalizer.normalize_str(&quot;Héllò hôw are ü?&quot;))</span>',wrap:!1}}),F=new y({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),k=new Go({props:{$$slots:{default:[So]},$$scope:{ctx:dl}}}),O=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),se=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),te=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),ne=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),oe=new y({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),pe=new y({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),ie=new y({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ce=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Me=new y({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),ye=new y({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),je=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),ke=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),fe=new y({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$e=new y({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQSUyMyUyMHByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-comment"># print(cls_token_id, sep_token_id)</span>`,wrap:!1}}),ge=new y({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),xe=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ce=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),ve=new y({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),qe=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2VucyklMEElMjMlMjBwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>
<span class="hljs-comment"># print(encoding.type_ids)</span>`,wrap:!1}}),Ve=new y({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),_e=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),We=new y({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Ae=new y({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Ne=new y({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new y({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ee=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFlvdSUyMGNhbiUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwdG9rZW5pemVyJTIwZmlsZSUyQyUyMGFsdGVybmF0aXZlbHklMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # You can load from the tokenizer file, alternatively</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new ul({props:{title:"Construyendo un tokenizador BPE desde cero",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Oe=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ls=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ns=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),as=new y({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ps=new y({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),cs=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ms=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),us=new y({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ys=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),js=new y({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),Ts=new y({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),fs=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),Us=new y({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),$s=new y({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),ws=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),xs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Is=new ul({props:{title:"Construyendo un tokenizador Unigran desde cero",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),vs=new y({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Vs=new y({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Qs=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),As=new y({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Rs=new y({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Xs=new y({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Hs=new y({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ds=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>`,wrap:!1}}),Ss=new y({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ys=new y({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQSUyMyUyMHByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-comment"># print(cls_token_id, sep_token_id)</span>`,wrap:!1}}),Fs=new y({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Os=new y({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),sl=new y({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQSUyMyUyMHByaW50KGVuY29kaW5nLnRva2VucyklMEElMjMlMjBwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-comment"># print(encoding.tokens)</span>
<span class="hljs-comment"># print(encoding.type_ids)</span>`,wrap:!1}}),ll=new y({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),nl=new y({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),ol=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),rl=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),cl=new Ho({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter6/8.mdx"}}),{c(){J=o("meta"),f=n(),j=o("p"),ml=n(),i(b.$$.fragment),yl=n(),i(U.$$.fragment),Jl=n(),i($.$$.fragment),jl=n(),g=o("p"),g.textContent=ca,Tl=n(),w=o("ul"),w.innerHTML=ma,kl=n(),h=o("p"),h.textContent=Ma,fl=n(),T=o("div"),T.innerHTML=ua,bl=n(),x=o("p"),x.innerHTML=da,Ul=n(),i(z.$$.fragment),$l=n(),I=o("p"),I.innerHTML=ya,gl=n(),C=o("ul"),C.innerHTML=Ja,wl=n(),v=o("p"),v.innerHTML=ja,hl=n(),i(Z.$$.fragment),xl=n(),q=o("p"),q.innerHTML=Ta,zl=n(),i(V.$$.fragment),Il=n(),B=o("p"),B.innerHTML=ka,Cl=n(),_=o("p"),_.textContent=fa,vl=n(),i(Q.$$.fragment),Zl=n(),W=o("p"),W.textContent=ba,ql=n(),i(A.$$.fragment),Vl=n(),R=o("p"),R.innerHTML=Ua,Bl=n(),N=o("p"),N.innerHTML=$a,_l=n(),i(X.$$.fragment),Ql=n(),G=o("p"),G.innerHTML=ga,Wl=n(),L=o("p"),L.innerHTML=wa,Al=n(),i(H.$$.fragment),Rl=n(),E=o("p"),E.innerHTML=ha,Nl=n(),i(D.$$.fragment),Xl=n(),S=o("p"),S.innerHTML=xa,Gl=n(),P=o("p"),P.innerHTML=za,Ll=n(),i(Y.$$.fragment),Hl=n(),i(F.$$.fragment),El=n(),i(k.$$.fragment),Dl=n(),K=o("p"),K.innerHTML=Ia,Sl=n(),i(O.$$.fragment),Pl=n(),ee=o("p"),ee.textContent=Ca,Yl=n(),i(se.$$.fragment),Fl=n(),le=o("p"),le.innerHTML=va,Kl=n(),i(te.$$.fragment),Ol=n(),i(ne.$$.fragment),et=n(),ae=o("p"),ae.innerHTML=Za,st=n(),i(oe.$$.fragment),lt=n(),i(pe.$$.fragment),tt=n(),re=o("p"),re.innerHTML=qa,nt=n(),i(ie.$$.fragment),at=n(),i(ce.$$.fragment),ot=n(),me=o("p"),me.innerHTML=Va,pt=n(),i(Me.$$.fragment),rt=n(),ue=o("p"),ue.innerHTML=Ba,it=n(),de=o("p"),de.textContent=_a,ct=n(),i(ye.$$.fragment),mt=n(),Je=o("p"),Je.innerHTML=Qa,Mt=n(),i(je.$$.fragment),ut=n(),Te=o("p"),Te.textContent=Wa,dt=n(),i(ke.$$.fragment),yt=n(),i(fe.$$.fragment),Jt=n(),be=o("p"),be.innerHTML=Aa,jt=n(),Ue=o("p"),Ue.innerHTML=Ra,Tt=n(),i($e.$$.fragment),kt=n(),i(ge.$$.fragment),ft=n(),we=o("p"),we.innerHTML=Na,bt=n(),he=o("p"),he.textContent=Xa,Ut=n(),i(xe.$$.fragment),$t=n(),ze=o("p"),ze.textContent=Ga,gt=n(),Ie=o("p"),Ie.textContent=La,wt=n(),i(Ce.$$.fragment),ht=n(),i(ve.$$.fragment),xt=n(),Ze=o("p"),Ze.textContent=Ha,zt=n(),i(qe.$$.fragment),It=n(),i(Ve.$$.fragment),Ct=n(),Be=o("p"),Be.textContent=Ea,vt=n(),i(_e.$$.fragment),Zt=n(),Qe=o("p"),Qe.innerHTML=Da,qt=n(),i(We.$$.fragment),Vt=n(),i(Ae.$$.fragment),Bt=n(),Re=o("p"),Re.textContent=Sa,_t=n(),i(Ne.$$.fragment),Qt=n(),Xe=o("p"),Xe.innerHTML=Pa,Wt=n(),i(Ge.$$.fragment),At=n(),Le=o("p"),Le.innerHTML=Ya,Rt=n(),He=o("p"),He.innerHTML=Fa,Nt=n(),i(Ee.$$.fragment),Xt=n(),De=o("p"),De.innerHTML=Ka,Gt=n(),i(Se.$$.fragment),Lt=n(),Pe=o("p"),Pe.innerHTML=Oa,Ht=n(),Ye=o("p"),Ye.textContent=eo,Et=n(),i(Fe.$$.fragment),Dt=n(),Ke=o("p"),Ke.innerHTML=so,St=n(),i(Oe.$$.fragment),Pt=n(),es=o("p"),es.innerHTML=lo,Yt=n(),ss=o("p"),ss.textContent=to,Ft=n(),i(ls.$$.fragment),Kt=n(),ts=o("p"),ts.innerHTML=no,Ot=n(),i(ns.$$.fragment),en=n(),i(as.$$.fragment),sn=n(),os=o("p"),os.textContent=ao,ln=n(),i(ps.$$.fragment),tn=n(),rs=o("p"),rs.innerHTML=oo,nn=n(),is=o("p"),is.textContent=po,an=n(),i(cs.$$.fragment),on=n(),ms=o("p"),ms.textContent=ro,pn=n(),i(Ms.$$.fragment),rn=n(),i(us.$$.fragment),cn=n(),ds=o("p"),ds.textContent=io,mn=n(),i(ys.$$.fragment),Mn=n(),Js=o("p"),Js.innerHTML=co,un=n(),i(js.$$.fragment),dn=n(),i(Ts.$$.fragment),yn=n(),ks=o("p"),ks.textContent=mo,Jn=n(),i(fs.$$.fragment),jn=n(),bs=o("p"),bs.textContent=Mo,Tn=n(),i(Us.$$.fragment),kn=n(),i($s.$$.fragment),fn=n(),gs=o("p"),gs.innerHTML=uo,bn=n(),i(ws.$$.fragment),Un=n(),hs=o("p"),hs.textContent=yo,$n=n(),i(xs.$$.fragment),gn=n(),zs=o("p"),zs.textContent=Jo,wn=n(),i(Is.$$.fragment),hn=n(),Cs=o("p"),Cs.innerHTML=jo,xn=n(),i(vs.$$.fragment),zn=n(),Zs=o("p"),Zs.textContent=To,In=n(),qs=o("p"),qs.textContent=ko,Cn=n(),i(Vs.$$.fragment),vn=n(),Bs=o("p"),Bs.innerHTML=fo,Zn=n(),_s=o("p"),_s.innerHTML=bo,qn=n(),i(Qs.$$.fragment),Vn=n(),Ws=o("p"),Ws.textContent=Uo,Bn=n(),i(As.$$.fragment),_n=n(),i(Rs.$$.fragment),Qn=n(),Ns=o("p"),Ns.textContent=$o,Wn=n(),i(Xs.$$.fragment),An=n(),Gs=o("p"),Gs.innerHTML=go,Rn=n(),Ls=o("p"),Ls.textContent=wo,Nn=n(),i(Hs.$$.fragment),Xn=n(),Es=o("p"),Es.textContent=ho,Gn=n(),i(Ds.$$.fragment),Ln=n(),i(Ss.$$.fragment),Hn=n(),Ps=o("p"),Ps.innerHTML=xo,En=n(),i(Ys.$$.fragment),Dn=n(),i(Fs.$$.fragment),Sn=n(),Ks=o("p"),Ks.textContent=zo,Pn=n(),i(Os.$$.fragment),Yn=n(),el=o("p"),el.textContent=Io,Fn=n(),i(sl.$$.fragment),Kn=n(),i(ll.$$.fragment),On=n(),tl=o("p"),tl.innerHTML=Co,ea=n(),i(nl.$$.fragment),sa=n(),al=o("p"),al.innerHTML=vo,la=n(),i(ol.$$.fragment),ta=n(),pl=o("p"),pl.textContent=Zo,na=n(),i(rl.$$.fragment),aa=n(),il=o("p"),il.textContent=qo,oa=n(),i(cl.$$.fragment),pa=n(),Ml=o("p"),this.h()},l(e){const s=No("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(l),f=a(e),j=p(e,"P",{}),Bo(j).forEach(l),ml=a(e),c(b.$$.fragment,e),yl=a(e),c(U.$$.fragment,e),Jl=a(e),c($.$$.fragment,e),jl=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-c4sn0m"&&(g.textContent=ca),Tl=a(e),w=p(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-1l4zgfg"&&(w.innerHTML=ma),kl=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1hd1nud"&&(h.textContent=Ma),fl=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-oxfng3"&&(T.innerHTML=ua),bl=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-3rersg"&&(x.innerHTML=da),Ul=a(e),c(z.$$.fragment,e),$l=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-9m97yz"&&(I.innerHTML=ya),gl=a(e),C=p(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-17qyz9s"&&(C.innerHTML=Ja),wl=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-tcxtnv"&&(v.innerHTML=ja),hl=a(e),c(Z.$$.fragment,e),xl=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-3ymujh"&&(q.innerHTML=Ta),zl=a(e),c(V.$$.fragment,e),Il=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-17hqre7"&&(B.innerHTML=ka),Cl=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-4mbep7"&&(_.textContent=fa),vl=a(e),c(Q.$$.fragment,e),Zl=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-uc5c5n"&&(W.textContent=ba),ql=a(e),c(A.$$.fragment,e),Vl=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-uoxffv"&&(R.innerHTML=Ua),Bl=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-151zz03"&&(N.innerHTML=$a),_l=a(e),c(X.$$.fragment,e),Ql=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1h6kbn6"&&(G.innerHTML=ga),Wl=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ohnr1y"&&(L.innerHTML=wa),Al=a(e),c(H.$$.fragment,e),Rl=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-6x22b2"&&(E.innerHTML=ha),Nl=a(e),c(D.$$.fragment,e),Xl=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1bulh92"&&(S.innerHTML=xa),Gl=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-4usyfw"&&(P.innerHTML=za),Ll=a(e),c(Y.$$.fragment,e),Hl=a(e),c(F.$$.fragment,e),El=a(e),c(k.$$.fragment,e),Dl=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-zkwbvk"&&(K.innerHTML=Ia),Sl=a(e),c(O.$$.fragment,e),Pl=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1bykxva"&&(ee.textContent=Ca),Yl=a(e),c(se.$$.fragment,e),Fl=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1k6p1d5"&&(le.innerHTML=va),Kl=a(e),c(te.$$.fragment,e),Ol=a(e),c(ne.$$.fragment,e),et=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1hcqn6e"&&(ae.innerHTML=Za),st=a(e),c(oe.$$.fragment,e),lt=a(e),c(pe.$$.fragment,e),tt=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1kd2nwi"&&(re.innerHTML=qa),nt=a(e),c(ie.$$.fragment,e),at=a(e),c(ce.$$.fragment,e),ot=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1xv6o2w"&&(me.innerHTML=Va),pt=a(e),c(Me.$$.fragment,e),rt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1yfizye"&&(ue.innerHTML=Ba),it=a(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-4p4c5w"&&(de.textContent=_a),ct=a(e),c(ye.$$.fragment,e),mt=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1rsjop4"&&(Je.innerHTML=Qa),Mt=a(e),c(je.$$.fragment,e),ut=a(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1fg2k9v"&&(Te.textContent=Wa),dt=a(e),c(ke.$$.fragment,e),yt=a(e),c(fe.$$.fragment,e),Jt=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1prwuyc"&&(be.innerHTML=Aa),jt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1t1my0l"&&(Ue.innerHTML=Ra),Tt=a(e),c($e.$$.fragment,e),kt=a(e),c(ge.$$.fragment,e),ft=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1eny8n0"&&(we.innerHTML=Na),bt=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-9qx9f3"&&(he.textContent=Xa),Ut=a(e),c(xe.$$.fragment,e),$t=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1dwaoft"&&(ze.textContent=Ga),gt=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1qrqbvr"&&(Ie.textContent=La),wt=a(e),c(Ce.$$.fragment,e),ht=a(e),c(ve.$$.fragment,e),xt=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-11qnfdl"&&(Ze.textContent=Ha),zt=a(e),c(qe.$$.fragment,e),It=a(e),c(Ve.$$.fragment,e),Ct=a(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1si3276"&&(Be.textContent=Ea),vt=a(e),c(_e.$$.fragment,e),Zt=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1nwzuqq"&&(Qe.innerHTML=Da),qt=a(e),c(We.$$.fragment,e),Vt=a(e),c(Ae.$$.fragment,e),Bt=a(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1976hlk"&&(Re.textContent=Sa),_t=a(e),c(Ne.$$.fragment,e),Qt=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1pwwmrj"&&(Xe.innerHTML=Pa),Wt=a(e),c(Ge.$$.fragment,e),At=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-u403ul"&&(Le.innerHTML=Ya),Rt=a(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-yt7pq9"&&(He.innerHTML=Fa),Nt=a(e),c(Ee.$$.fragment,e),Xt=a(e),De=p(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-160nqc8"&&(De.innerHTML=Ka),Gt=a(e),c(Se.$$.fragment,e),Lt=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1lt7h7v"&&(Pe.innerHTML=Oa),Ht=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-p6wmxa"&&(Ye.textContent=eo),Et=a(e),c(Fe.$$.fragment,e),Dt=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-17bt26b"&&(Ke.innerHTML=so),St=a(e),c(Oe.$$.fragment,e),Pt=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-vexupx"&&(es.innerHTML=lo),Yt=a(e),ss=p(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1lx47fv"&&(ss.textContent=to),Ft=a(e),c(ls.$$.fragment,e),Kt=a(e),ts=p(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1b5szat"&&(ts.innerHTML=no),Ot=a(e),c(ns.$$.fragment,e),en=a(e),c(as.$$.fragment,e),sn=a(e),os=p(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-871h2v"&&(os.textContent=ao),ln=a(e),c(ps.$$.fragment,e),tn=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-15d27yh"&&(rs.innerHTML=oo),nn=a(e),is=p(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-zcpxbz"&&(is.textContent=po),an=a(e),c(cs.$$.fragment,e),on=a(e),ms=p(e,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-cly4t1"&&(ms.textContent=ro),pn=a(e),c(Ms.$$.fragment,e),rn=a(e),c(us.$$.fragment,e),cn=a(e),ds=p(e,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-4t57mm"&&(ds.textContent=io),mn=a(e),c(ys.$$.fragment,e),Mn=a(e),Js=p(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-1czzrf0"&&(Js.innerHTML=co),un=a(e),c(js.$$.fragment,e),dn=a(e),c(Ts.$$.fragment,e),yn=a(e),ks=p(e,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-liq0jx"&&(ks.textContent=mo),Jn=a(e),c(fs.$$.fragment,e),jn=a(e),bs=p(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-19w2n2j"&&(bs.textContent=Mo),Tn=a(e),c(Us.$$.fragment,e),kn=a(e),c($s.$$.fragment,e),fn=a(e),gs=p(e,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-1w7p86u"&&(gs.innerHTML=uo),bn=a(e),c(ws.$$.fragment,e),Un=a(e),hs=p(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-a9xxjb"&&(hs.textContent=yo),$n=a(e),c(xs.$$.fragment,e),gn=a(e),zs=p(e,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-o3khi"&&(zs.textContent=Jo),wn=a(e),c(Is.$$.fragment,e),hn=a(e),Cs=p(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-ln1mp9"&&(Cs.innerHTML=jo),xn=a(e),c(vs.$$.fragment,e),zn=a(e),Zs=p(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-1jmvbhx"&&(Zs.textContent=To),In=a(e),qs=p(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-160opgk"&&(qs.textContent=ko),Cn=a(e),c(Vs.$$.fragment,e),vn=a(e),Bs=p(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-1hs9eo0"&&(Bs.innerHTML=fo),Zn=a(e),_s=p(e,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-tu4mvx"&&(_s.innerHTML=bo),qn=a(e),c(Qs.$$.fragment,e),Vn=a(e),Ws=p(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1mxfwt5"&&(Ws.textContent=Uo),Bn=a(e),c(As.$$.fragment,e),_n=a(e),c(Rs.$$.fragment,e),Qn=a(e),Ns=p(e,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-zahnm2"&&(Ns.textContent=$o),Wn=a(e),c(Xs.$$.fragment,e),An=a(e),Gs=p(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-mhtwbj"&&(Gs.innerHTML=go),Rn=a(e),Ls=p(e,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-1qn663c"&&(Ls.textContent=wo),Nn=a(e),c(Hs.$$.fragment,e),Xn=a(e),Es=p(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-11n48oa"&&(Es.textContent=ho),Gn=a(e),c(Ds.$$.fragment,e),Ln=a(e),c(Ss.$$.fragment,e),Hn=a(e),Ps=p(e,"P",{"data-svelte-h":!0}),r(Ps)!=="svelte-16wn66q"&&(Ps.innerHTML=xo),En=a(e),c(Ys.$$.fragment,e),Dn=a(e),c(Fs.$$.fragment,e),Sn=a(e),Ks=p(e,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-k790qk"&&(Ks.textContent=zo),Pn=a(e),c(Os.$$.fragment,e),Yn=a(e),el=p(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-t673wg"&&(el.textContent=Io),Fn=a(e),c(sl.$$.fragment,e),Kn=a(e),c(ll.$$.fragment,e),On=a(e),tl=p(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1h1y1uq"&&(tl.innerHTML=Co),ea=a(e),c(nl.$$.fragment,e),sa=a(e),al=p(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-i4yxg4"&&(al.innerHTML=vo),la=a(e),c(ol.$$.fragment,e),ta=a(e),pl=p(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-fa4903"&&(pl.textContent=Zo),na=a(e),c(rl.$$.fragment,e),aa=a(e),il=p(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-yoxjt1"&&(il.textContent=qo),oa=a(e),c(cl.$$.fragment,e),pa=a(e),Ml=p(e,"P",{}),Bo(Ml).forEach(l),this.h()},h(){ia(J,"name","hf:doc:metadata"),ia(J,"content",Yo),ia(T,"class","flex justify-center")},m(e,s){Xo(document.head,J),t(e,f,s),t(e,j,s),t(e,ml,s),m(b,e,s),t(e,yl,s),m(U,e,s),t(e,Jl,s),m($,e,s),t(e,jl,s),t(e,g,s),t(e,Tl,s),t(e,w,s),t(e,kl,s),t(e,h,s),t(e,fl,s),t(e,T,s),t(e,bl,s),t(e,x,s),t(e,Ul,s),m(z,e,s),t(e,$l,s),t(e,I,s),t(e,gl,s),t(e,C,s),t(e,wl,s),t(e,v,s),t(e,hl,s),m(Z,e,s),t(e,xl,s),t(e,q,s),t(e,zl,s),m(V,e,s),t(e,Il,s),t(e,B,s),t(e,Cl,s),t(e,_,s),t(e,vl,s),m(Q,e,s),t(e,Zl,s),t(e,W,s),t(e,ql,s),m(A,e,s),t(e,Vl,s),t(e,R,s),t(e,Bl,s),t(e,N,s),t(e,_l,s),m(X,e,s),t(e,Ql,s),t(e,G,s),t(e,Wl,s),t(e,L,s),t(e,Al,s),m(H,e,s),t(e,Rl,s),t(e,E,s),t(e,Nl,s),m(D,e,s),t(e,Xl,s),t(e,S,s),t(e,Gl,s),t(e,P,s),t(e,Ll,s),m(Y,e,s),t(e,Hl,s),m(F,e,s),t(e,El,s),m(k,e,s),t(e,Dl,s),t(e,K,s),t(e,Sl,s),m(O,e,s),t(e,Pl,s),t(e,ee,s),t(e,Yl,s),m(se,e,s),t(e,Fl,s),t(e,le,s),t(e,Kl,s),m(te,e,s),t(e,Ol,s),m(ne,e,s),t(e,et,s),t(e,ae,s),t(e,st,s),m(oe,e,s),t(e,lt,s),m(pe,e,s),t(e,tt,s),t(e,re,s),t(e,nt,s),m(ie,e,s),t(e,at,s),m(ce,e,s),t(e,ot,s),t(e,me,s),t(e,pt,s),m(Me,e,s),t(e,rt,s),t(e,ue,s),t(e,it,s),t(e,de,s),t(e,ct,s),m(ye,e,s),t(e,mt,s),t(e,Je,s),t(e,Mt,s),m(je,e,s),t(e,ut,s),t(e,Te,s),t(e,dt,s),m(ke,e,s),t(e,yt,s),m(fe,e,s),t(e,Jt,s),t(e,be,s),t(e,jt,s),t(e,Ue,s),t(e,Tt,s),m($e,e,s),t(e,kt,s),m(ge,e,s),t(e,ft,s),t(e,we,s),t(e,bt,s),t(e,he,s),t(e,Ut,s),m(xe,e,s),t(e,$t,s),t(e,ze,s),t(e,gt,s),t(e,Ie,s),t(e,wt,s),m(Ce,e,s),t(e,ht,s),m(ve,e,s),t(e,xt,s),t(e,Ze,s),t(e,zt,s),m(qe,e,s),t(e,It,s),m(Ve,e,s),t(e,Ct,s),t(e,Be,s),t(e,vt,s),m(_e,e,s),t(e,Zt,s),t(e,Qe,s),t(e,qt,s),m(We,e,s),t(e,Vt,s),m(Ae,e,s),t(e,Bt,s),t(e,Re,s),t(e,_t,s),m(Ne,e,s),t(e,Qt,s),t(e,Xe,s),t(e,Wt,s),m(Ge,e,s),t(e,At,s),t(e,Le,s),t(e,Rt,s),t(e,He,s),t(e,Nt,s),m(Ee,e,s),t(e,Xt,s),t(e,De,s),t(e,Gt,s),m(Se,e,s),t(e,Lt,s),t(e,Pe,s),t(e,Ht,s),t(e,Ye,s),t(e,Et,s),m(Fe,e,s),t(e,Dt,s),t(e,Ke,s),t(e,St,s),m(Oe,e,s),t(e,Pt,s),t(e,es,s),t(e,Yt,s),t(e,ss,s),t(e,Ft,s),m(ls,e,s),t(e,Kt,s),t(e,ts,s),t(e,Ot,s),m(ns,e,s),t(e,en,s),m(as,e,s),t(e,sn,s),t(e,os,s),t(e,ln,s),m(ps,e,s),t(e,tn,s),t(e,rs,s),t(e,nn,s),t(e,is,s),t(e,an,s),m(cs,e,s),t(e,on,s),t(e,ms,s),t(e,pn,s),m(Ms,e,s),t(e,rn,s),m(us,e,s),t(e,cn,s),t(e,ds,s),t(e,mn,s),m(ys,e,s),t(e,Mn,s),t(e,Js,s),t(e,un,s),m(js,e,s),t(e,dn,s),m(Ts,e,s),t(e,yn,s),t(e,ks,s),t(e,Jn,s),m(fs,e,s),t(e,jn,s),t(e,bs,s),t(e,Tn,s),m(Us,e,s),t(e,kn,s),m($s,e,s),t(e,fn,s),t(e,gs,s),t(e,bn,s),m(ws,e,s),t(e,Un,s),t(e,hs,s),t(e,$n,s),m(xs,e,s),t(e,gn,s),t(e,zs,s),t(e,wn,s),m(Is,e,s),t(e,hn,s),t(e,Cs,s),t(e,xn,s),m(vs,e,s),t(e,zn,s),t(e,Zs,s),t(e,In,s),t(e,qs,s),t(e,Cn,s),m(Vs,e,s),t(e,vn,s),t(e,Bs,s),t(e,Zn,s),t(e,_s,s),t(e,qn,s),m(Qs,e,s),t(e,Vn,s),t(e,Ws,s),t(e,Bn,s),m(As,e,s),t(e,_n,s),m(Rs,e,s),t(e,Qn,s),t(e,Ns,s),t(e,Wn,s),m(Xs,e,s),t(e,An,s),t(e,Gs,s),t(e,Rn,s),t(e,Ls,s),t(e,Nn,s),m(Hs,e,s),t(e,Xn,s),t(e,Es,s),t(e,Gn,s),m(Ds,e,s),t(e,Ln,s),m(Ss,e,s),t(e,Hn,s),t(e,Ps,s),t(e,En,s),m(Ys,e,s),t(e,Dn,s),m(Fs,e,s),t(e,Sn,s),t(e,Ks,s),t(e,Pn,s),m(Os,e,s),t(e,Yn,s),t(e,el,s),t(e,Fn,s),m(sl,e,s),t(e,Kn,s),m(ll,e,s),t(e,On,s),t(e,tl,s),t(e,ea,s),m(nl,e,s),t(e,sa,s),t(e,al,s),t(e,la,s),m(ol,e,s),t(e,ta,s),t(e,pl,s),t(e,na,s),m(rl,e,s),t(e,aa,s),t(e,il,s),t(e,oa,s),m(cl,e,s),t(e,pa,s),t(e,Ml,s),ra=!0},p(e,[s]){const Vo={};s&2&&(Vo.$$scope={dirty:s,ctx:e}),k.$set(Vo)},i(e){ra||(M(b.$$.fragment,e),M(U.$$.fragment,e),M($.$$.fragment,e),M(z.$$.fragment,e),M(Z.$$.fragment,e),M(V.$$.fragment,e),M(Q.$$.fragment,e),M(A.$$.fragment,e),M(X.$$.fragment,e),M(H.$$.fragment,e),M(D.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(k.$$.fragment,e),M(O.$$.fragment,e),M(se.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(ye.$$.fragment,e),M(je.$$.fragment,e),M(ke.$$.fragment,e),M(fe.$$.fragment,e),M($e.$$.fragment,e),M(ge.$$.fragment,e),M(xe.$$.fragment,e),M(Ce.$$.fragment,e),M(ve.$$.fragment,e),M(qe.$$.fragment,e),M(Ve.$$.fragment,e),M(_e.$$.fragment,e),M(We.$$.fragment,e),M(Ae.$$.fragment,e),M(Ne.$$.fragment,e),M(Ge.$$.fragment,e),M(Ee.$$.fragment,e),M(Se.$$.fragment,e),M(Fe.$$.fragment,e),M(Oe.$$.fragment,e),M(ls.$$.fragment,e),M(ns.$$.fragment,e),M(as.$$.fragment,e),M(ps.$$.fragment,e),M(cs.$$.fragment,e),M(Ms.$$.fragment,e),M(us.$$.fragment,e),M(ys.$$.fragment,e),M(js.$$.fragment,e),M(Ts.$$.fragment,e),M(fs.$$.fragment,e),M(Us.$$.fragment,e),M($s.$$.fragment,e),M(ws.$$.fragment,e),M(xs.$$.fragment,e),M(Is.$$.fragment,e),M(vs.$$.fragment,e),M(Vs.$$.fragment,e),M(Qs.$$.fragment,e),M(As.$$.fragment,e),M(Rs.$$.fragment,e),M(Xs.$$.fragment,e),M(Hs.$$.fragment,e),M(Ds.$$.fragment,e),M(Ss.$$.fragment,e),M(Ys.$$.fragment,e),M(Fs.$$.fragment,e),M(Os.$$.fragment,e),M(sl.$$.fragment,e),M(ll.$$.fragment,e),M(nl.$$.fragment,e),M(ol.$$.fragment,e),M(rl.$$.fragment,e),M(cl.$$.fragment,e),ra=!0)},o(e){u(b.$$.fragment,e),u(U.$$.fragment,e),u($.$$.fragment,e),u(z.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(D.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(k.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(je.$$.fragment,e),u(ke.$$.fragment,e),u(fe.$$.fragment,e),u($e.$$.fragment,e),u(ge.$$.fragment,e),u(xe.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(qe.$$.fragment,e),u(Ve.$$.fragment,e),u(_e.$$.fragment,e),u(We.$$.fragment,e),u(Ae.$$.fragment,e),u(Ne.$$.fragment,e),u(Ge.$$.fragment,e),u(Ee.$$.fragment,e),u(Se.$$.fragment,e),u(Fe.$$.fragment,e),u(Oe.$$.fragment,e),u(ls.$$.fragment,e),u(ns.$$.fragment,e),u(as.$$.fragment,e),u(ps.$$.fragment,e),u(cs.$$.fragment,e),u(Ms.$$.fragment,e),u(us.$$.fragment,e),u(ys.$$.fragment,e),u(js.$$.fragment,e),u(Ts.$$.fragment,e),u(fs.$$.fragment,e),u(Us.$$.fragment,e),u($s.$$.fragment,e),u(ws.$$.fragment,e),u(xs.$$.fragment,e),u(Is.$$.fragment,e),u(vs.$$.fragment,e),u(Vs.$$.fragment,e),u(Qs.$$.fragment,e),u(As.$$.fragment,e),u(Rs.$$.fragment,e),u(Xs.$$.fragment,e),u(Hs.$$.fragment,e),u(Ds.$$.fragment,e),u(Ss.$$.fragment,e),u(Ys.$$.fragment,e),u(Fs.$$.fragment,e),u(Os.$$.fragment,e),u(sl.$$.fragment,e),u(ll.$$.fragment,e),u(nl.$$.fragment,e),u(ol.$$.fragment,e),u(rl.$$.fragment,e),u(cl.$$.fragment,e),ra=!1},d(e){e&&(l(f),l(j),l(ml),l(yl),l(Jl),l(jl),l(g),l(Tl),l(w),l(kl),l(h),l(fl),l(T),l(bl),l(x),l(Ul),l($l),l(I),l(gl),l(C),l(wl),l(v),l(hl),l(xl),l(q),l(zl),l(Il),l(B),l(Cl),l(_),l(vl),l(Zl),l(W),l(ql),l(Vl),l(R),l(Bl),l(N),l(_l),l(Ql),l(G),l(Wl),l(L),l(Al),l(Rl),l(E),l(Nl),l(Xl),l(S),l(Gl),l(P),l(Ll),l(Hl),l(El),l(Dl),l(K),l(Sl),l(Pl),l(ee),l(Yl),l(Fl),l(le),l(Kl),l(Ol),l(et),l(ae),l(st),l(lt),l(tt),l(re),l(nt),l(at),l(ot),l(me),l(pt),l(rt),l(ue),l(it),l(de),l(ct),l(mt),l(Je),l(Mt),l(ut),l(Te),l(dt),l(yt),l(Jt),l(be),l(jt),l(Ue),l(Tt),l(kt),l(ft),l(we),l(bt),l(he),l(Ut),l($t),l(ze),l(gt),l(Ie),l(wt),l(ht),l(xt),l(Ze),l(zt),l(It),l(Ct),l(Be),l(vt),l(Zt),l(Qe),l(qt),l(Vt),l(Bt),l(Re),l(_t),l(Qt),l(Xe),l(Wt),l(At),l(Le),l(Rt),l(He),l(Nt),l(Xt),l(De),l(Gt),l(Lt),l(Pe),l(Ht),l(Ye),l(Et),l(Dt),l(Ke),l(St),l(Pt),l(es),l(Yt),l(ss),l(Ft),l(Kt),l(ts),l(Ot),l(en),l(sn),l(os),l(ln),l(tn),l(rs),l(nn),l(is),l(an),l(on),l(ms),l(pn),l(rn),l(cn),l(ds),l(mn),l(Mn),l(Js),l(un),l(dn),l(yn),l(ks),l(Jn),l(jn),l(bs),l(Tn),l(kn),l(fn),l(gs),l(bn),l(Un),l(hs),l($n),l(gn),l(zs),l(wn),l(hn),l(Cs),l(xn),l(zn),l(Zs),l(In),l(qs),l(Cn),l(vn),l(Bs),l(Zn),l(_s),l(qn),l(Vn),l(Ws),l(Bn),l(_n),l(Qn),l(Ns),l(Wn),l(An),l(Gs),l(Rn),l(Ls),l(Nn),l(Xn),l(Es),l(Gn),l(Ln),l(Hn),l(Ps),l(En),l(Dn),l(Sn),l(Ks),l(Pn),l(Yn),l(el),l(Fn),l(Kn),l(On),l(tl),l(ea),l(sa),l(al),l(la),l(ta),l(pl),l(na),l(aa),l(il),l(oa),l(pa),l(Ml)),l(J),d(b,e),d(U,e),d($,e),d(z,e),d(Z,e),d(V,e),d(Q,e),d(A,e),d(X,e),d(H,e),d(D,e),d(Y,e),d(F,e),d(k,e),d(O,e),d(se,e),d(te,e),d(ne,e),d(oe,e),d(pe,e),d(ie,e),d(ce,e),d(Me,e),d(ye,e),d(je,e),d(ke,e),d(fe,e),d($e,e),d(ge,e),d(xe,e),d(Ce,e),d(ve,e),d(qe,e),d(Ve,e),d(_e,e),d(We,e),d(Ae,e),d(Ne,e),d(Ge,e),d(Ee,e),d(Se,e),d(Fe,e),d(Oe,e),d(ls,e),d(ns,e),d(as,e),d(ps,e),d(cs,e),d(Ms,e),d(us,e),d(ys,e),d(js,e),d(Ts,e),d(fs,e),d(Us,e),d($s,e),d(ws,e),d(xs,e),d(Is,e),d(vs,e),d(Vs,e),d(Qs,e),d(As,e),d(Rs,e),d(Xs,e),d(Hs,e),d(Ds,e),d(Ss,e),d(Ys,e),d(Fs,e),d(Os,e),d(sl,e),d(ll,e),d(nl,e),d(ol,e),d(rl,e),d(cl,e)}}}const Yo='{"title":"Construir un tokenizador, bloque por bloque","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Adquirir un corpus","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Construyendo un tokenizador WordPiece desde cero","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Construyendo un tokenizador BPE desde cero","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Construyendo un tokenizador Unigran desde cero","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function Fo(dl){return Qo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class op extends Ao{constructor(J){super(),Ro(this,J,Fo,Po,_o,{})}}export{op as component};
