# Procesamiento de Lenguaje Natural

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Antes de ver los Transformadores, hagamos una revisión rápida de qué es el procesamiento de lenguaje natural y por qué nos interesa.

## ¿Qué es PLN?

El PLN es un campo de la lingüística y el machine learning enfocado en entender todo lo relacionado con el lenguaje humano. El objetivo de las tareas de PLN no sólo es entender palabras de manera individual, sino también entender su contexto.

Esta es una lista de tareas comunes de PLN, con algunos ejemplos:

- **Clasificar oraciones enteras**: Obtener el sentimiento de una reseña, detectar si un correo electrónico es spam, determinar si una oración es gramaticalmente correcta o si dos oraciones están lógicamente relacionadas entre si
- **Clasificar cada palabra en una oración**: Identificar los componentes gramaticales de una oración (sustantivo, verbo, adjetivo) o las entidades nombradas (persona, ubicación, organización)
- **Generar texto**: Completar una indicación con texto generado automáticamente, completar los espacios en blanco en un texto con palabras ocultas
- **Extraer una respuesta de un texto**: Dada una pregunta y un contexto, extraer la respuesta a la pregunta en función de la información proporcionada en el contexto
- **Generar una nueva oración de un texto de entrada**: Traducir un texto a otro idioma, resumir un texto

No obstante, el PLN no se limita a texto escrito. También aborda desafíos complejos en reconocimiento del habla y visión por computador, como generar la transcripción de una muestra de audio o la descripción de una imagen.

## ¿Por qué es retador?

Los computadores no procesan la información en la misma forma que los humanos. Por ejemplo, cuando leemos la oración "tengo hambre", podemos identificar fácilmente su significado. De manera similar, dadas dos oraciones como "tengo hambre" y "estoy triste", podemos determinar fácilmente qué tan parecidas son. Para los modelos de Machine Learning (ML) estas tareas son más difíciles. El texto necesita ser procesado de tal forma que le permita al modelo aprender de él. Y como el lenguaje es complejo, necesitamos pensar con cuidado cómo debe ser este procesamiento. Hay gran cantidad de investigación sobre cómo representar texto y vamos a ver algunos métodos en el siguiente capítulo.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter1/2.mdx" />