# مقدمه


به دوره‌ی آموزشی هاگینگ‌فیس خوش آمدید! این مقدمه شما را در طی مراحل راه‌اندازی محیط کار راهنمایی می‌کند. اگر تازه این دوره را شروع کرده‌اید، پیشنهاد می‌کنیم ابتدا نگاهی به [فصل اول](/course/chapter1) بیاندازید و سپس به این بخش بازگشته تا محیط کاری را راه‌اندازی کنید و بتوانید خودتان کد را اجرا کنید.

همه کتابخانه‌هایی که در این دوره‌ی آموزشی استفاده خواهیم کرد، پکیج‌های پایتون هستند. در این بخش می‌بینیم که چگونه باید محیط کار پایتون را راه‌اندازی نموده و کتابخانه‌های مورد نیاز را نصب کنید.

ما دو شیوه راه‌اندازی محیط کار، یکی استفاده از نوت‌بوک کولَب و دیگری استفاده از محیط مجازی پایتون را نشان خواهیم داد. می‌توانید هرکدام را که می‌خواهید انتخاب کنید. اگر تازه‌کارها هستید، توصیه مؤکد داریم که از نوت‌بوک کولَب استفاده کنید.

توجه کنید که به محیط ویندوز نخواهیم پرداخت. اگر از ویندوز استفاده می‌کنید توصیه می‌کنیم از نوت‌بوک‌های کولَب استفاده کنید. اگر از سیستم‌عامل مک یا یکی از توزیع‌های لینوکس استفاده می‌کنید می‌توانید هر‌کدام از روش‌هایی که در اینجا ارائه می‌کنیم را دنبال کنید.

برای طی بخش زیادی از این دوره نیاز به حساب کاربری ‌هاگینگ‌فیس‌ دارید. پیشنهاد می‌کنیم همین الان [حساب خود را بسازید](https://huggingface.co/join).

<h2>استفاده از نوت‌بوک‌ کولَب گوگل</h2>

استفاده از نوت‌بوک کولَب ساده‌ترین راه شروع است. در مرورگر خود نوت‌بوکی جدید باز کرده و بلافاصله شروع به کد زدن کنید!

اگر با کولَب آشنایی ندارید پیشنهاد می‌کنیم از این [راهنما](https://colab.research.google.com/notebooks/intro.ipynb) استفاده کنید. کولَب به شما امکان استفاده از سخت‌افزار‌‌‌های شتاب‌دهنده مانند GPU یا TPU می‌‌دهد و استفاده از آن برای محاسبات سبک رایگان است.

وقتی که با محیط کاربری کولَب آشنا شدید، نوت‌بوکی جدید بسازید و مراحل راه‌اندازی را شروع کنید.
<br/>

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>
<br/>

قدم اول نصب کتابخانه‌هایی است که در این دوره استفاده خواهیم کرد. برای نصب کتابخانه‌ها از `pip` استفاده می‌کنیم که پکیج‌منیجر پایتون است. در فضای نوت‌بوک، برای اجرای دستورهای سیستمی، کافی است علامت `!` را به ابتدای خط اضافه کنید. برای نصب کتابخانه ترنسفورمرهای هاگینگ‌فیس این دستور را اجرا کنید:

<div dir="ltr">

  ```
  !pip install transformers
  ```

</div>

برای اطمینان از نصب صحیح این پکیج، آن را ایمپورت کنید:

<div dir="ltr">

  ```
  import transformers
  ```

</div>

<br/>
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>
<br/>

این دستور نسخه‌ای بسیار کم حجم از ترنسفورمرهای هاگینگ‌فیس را نصب می‌کند بدون آنکه فریمورک‌ یادگیری ماشین مشخصی مانند پایتورچ یا تنسورفلو را اضافه کند. با توجه به اینکه ما از بسیاری از قابلیت‌های مختلف این کتابخانه استفاده خواهیم کرد، پیشنهاد می‌کنیم نسخه توسعه‌ی این کتابخانه، که حاوی تمام پکیج‌های وابسته برای تقریبا همه مسائل قابل تصور است، را نصب کنید:

<div dir="ltr">

  ```
  !pip install transformers[sentencepiece]
  ```

</div>

اجرای این فرمان کمی بیشتر طول می‌کشد ولی برای طی بقیه دوره نیازی به نصب پکیج دیگری نخواهید داشت!

<h2>استفاده از محیط مجازی پایتون</h2>

اگر ترجیح می‌دهید از یکی از محیط‌های مجازی پایتون استفاده کنید، اولین مرحله نصب پایتون روی سیستم‌تان است. پیشنهاد می‌کنیم از این [راهنما](https://realpython.com/installing-python/) استفاده کنید.
اگر پایتون را نصب کردید، می‌توانید فرمان‌های پایتون را در ترمینال اجرا کنید. قبل از اینکه به سراغ مراحل بعدی بروید، با اجرای دستور `python --version` از نصب صحیح پایتون مطمئن شوید. این دستور، نسخه‌ی پایتون نصب شده روی سیستم‌تان را نمایش می‌دهد.


زمانی که فرمان‌های پایتون را در ترمینال اجرا می کنید، نسخه "اصلی” پایتون روی سیستم خود را درگیر می کنید. توصیه می کنیم این نسخه‌ را تمیز نگه دارید و هیچ پکیج اضافه‌ای روی آن نصب نکنید، بلکه از آن صرفا برای ایجاد محیط‌های مجازی دیگر و برای پروژه‌های مختلف استفاده کنید. با این روش هر پروژه می‌تواند وابستگی‌های مخصوص به خود را داشته‌باشد و دیگر نیازی نیست نگران ناسازگاری‌‌‌های احتمالی میان پکیج‌های نصب شده برای پروژه‌های مختلف باشید.

این کار در پایتون با استفاده از [<b>محیط‌های مجازی</b>](https://docs.python.org/3/tutorial/venv.html) انجام می‌شود. محیط مجازی، پوشه ای قائم به خود روی فایل‌سیستم است که محتوی نسخه‌ای مشخص از پایتون به همراه تمام پکیج‌های مورد استفاده در پروژه‌ای خاص است. ساخت این پوشه با ابزارهای مختلفی امکان‌پذیر است. ما در اینجا از ابزار رسمی پایتون به نام [`venv`](https://docs.python.org/3/library/venv.html#module-venv) استفاده می‌کنیم.

ابتدا پوشه‌ای جدید برای پروژه خود ایجاد کنید. برای مثال پوشه‌ای به نام <b>transformers-course</b> زیر پوشه‌ی خانه خودتان در فایل‌سیستم بسازید:

<div dir="ltr">

  ```
  mkdir ~/transformers-course
  cd ~/transformers-course
  ```

</div>

درون این پوشه، با استفاده از ماژول `venv` پایتون، محیط مجازی خود را بسازید:

<div dir="ltr">

  ```
  python -m venv .env
  ```

</div>

حالا می‌بایست زیر پوشه پروژه شما تنها یک پوشه دیگر به نام <b>.env</b> وجود داشته باشد.

<div dir="ltr">

  ```
  ls -a
  .      ..    .env
  ```

</div>

برای ورود و خروج از محیط مجازی پروژه خود از اسکریپت‌های activate و deactivate استفاده کنید:

<div dir="ltr">

  ```
  \# Activate the virtual environment
  source .env/bin/activate

  \# Deactivate the virtual environment
  deactivate
  ```

</div>


‌با اجرای دستور `which python` از فعال شدن محیط مجازی خود اطمینان حاصل کنید. اگر این دستور به آدرس محیط مجازی جدید اشاره کند، با موفقیت این محیط را فعال کرده‌اید.

<div dir="ltr">

  ```
  which python
  /home/&lt;user&gt;/transformers-course/.env/bin/python
  ```

</div>

<h3>نصب وابستگی‌ها</h3>

مانند آنچه در بخش استفاده از گوگل کولَب گفتیم، اکنون باید پکیج‌های موردنیاز برای ادامه دوره را نصب کنید. می‌توانید نسخه توسعه‌ی پکیج ترنسفورمرهای هاگینگ‌فیس را با استفاده از پکیج‌منیجر `pip` نصب کنید:

<div dir="ltr">

  ```
  pip install "transformers[sentencepiece]"
  ```

</div>

شما تمام مراحل راه‌اندازی را طی کرده و آماده شروع دوره هستید!

</div>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fa/chapter0/1.mdx" />