import{s as pi,o as ui,n as ht}from"../chunks/scheduler.cc52f4b9.js";import{S as oi,i as mi,e as r,s as n,c as u,h as di,a as i,d as t,b as a,f as ri,g as o,j as p,k as ii,l as ci,m as l,n as m,t as d,o as c,p as M}from"../chunks/index.9480bb2b.js";import{T as wt}from"../chunks/Tip.f7b80743.js";import{C as Mi,H as w,E as yi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as Ji}from"../chunks/Youtube.7b12d9e8.js";import{C as J}from"../chunks/CodeBlock.f4148b32.js";import{C as bi}from"../chunks/CourseFloatingBanner.cdc38ef1.js";import{F as ji}from"../chunks/FrameworkSwitchCourse.42d12053.js";function fi(T){let y,j="✏️ <em>A votre tour !</em> Vérifiez que tout semble correct avec le deuxième élément du jeu de données d’entraînement.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-a5jmf7"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function Ti(T){let y,j="Dans la prochaine partie du cours, nous examinerons des techniques plus avancées qui peuvent vous aider à réduire votre empreinte mémoire et vous permettre de <i>finetuner</i> les plus grands modèles.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1fy93ej"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function wi(T){let y,j="💡 Vous devriez toujours vous assurer que vous pouvez exécuter <code>trainer.evaluate()</code> avant de lancer <code>trainer.train()</code>, pour éviter de gaspiller beaucoup de ressources de calcul avant de tomber sur une erreur.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-m749no"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function hi(T){let y,j="💡 Si vous utilisez une boucle d’entraînement manuelle, les mêmes étapes s’appliquent pour déboguer votre pipeline d’entraînement, mais il est plus facile de les séparer. Assurez-vous cependant de ne pas avoir oublié le <code>model.eval()</code> ou le <code>model.train()</code> aux bons endroits, ou le <code>zero_grad()</code> à chaque étape !";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-5w1gdq"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function Ui(T){let y,j="⚠️ Si vous effectuez un entraînement distribué, imprimez des échantillons de votre ensemble de données dans chaque processus et vérifiez par trois fois que vous obtenez la même chose. Un bug courant consiste à avoir une source d’aléa dans la création des données qui fait que chaque processus a une version différente du jeu de données.";return{c(){y=r("p"),y.textContent=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-hopuap"&&(y.textContent=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function vi(T){let y,j="💡 Si vos données d’entraînement ne sont pas équilibrées, veillez à créer un batch de données d’entraînement contenant toutes les étiquettes.";return{c(){y=r("p"),y.textContent=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-3aiowm"&&(y.textContent=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function $i(T){let y,j="⚠️ Vous devrez recréer votre modèle et votre <code>Trainer</code> après ce test, car le modèle obtenu ne sera probablement pas capable de récupérer et d’apprendre quelque chose d’utile sur votre jeu de données complet.";return{c(){y=r("p"),y.innerHTML=j},l(b){y=i(b,"P",{"data-svelte-h":!0}),p(y)!=="svelte-u1whl2"&&(y.innerHTML=j)},m(b,f){l(b,y,f)},p:ht,d(b){b&&t(y)}}}function Ci(T){let y,j,b,f,h,vt,g,$t,B,Ct,X,Zt,W,$a='Vous avez écrit un magnifique script pour entraîner ou <em>finetuner</em> un modèle sur une tâche donnée en suivant consciencieusement les conseils du <a href="/course/fr/chapter7">chapitre 7</a>. Mais lorsque vous lancez la commande <code>model.fit()</code>, quelque chose d’horrible se produit : vous obtenez une erreur 😱 ! Ou pire, tout semble aller bien et l’entraînement se déroule sans erreur mais le modèle résultant est mauvais. Dans cette section, nous allons vous montrer ce que vous pouvez faire pour déboguer ce genre de problèmes.',It,R,kt,G,gt,V,Ca="Le problème lorsque vous rencontrez une erreur dans <code>trainer.train()</code> est qu’elle peut provenir de plusieurs sources, car la fonction <code>Trainer</code> assemble généralement des batchs de choses. Elle convertit les jeux de données en chargeurs de données donc le problème pourrait être quelque chose d’erroné dans votre jeu de données, ou un problème en essayant de regrouper les éléments des jeux de données ensemble. Ensuite, elle prend un batch de données et le transmet au modèle, le problème peut donc se situer dans le code du modèle. Après cela, elle calcule les gradients et effectue l’étape d’optimisation, le problème peut donc également se situer dans votre optimiseur. Et même si tout se passe bien pendant l’entraînement, quelque chose peut encore mal tourner pendant l’évaluation si votre métrique pose problème.",Bt,z,Za="La meilleure façon de déboguer une erreur qui survient dans <code>trainer.train()</code> est de passer manuellement en revue tout le pipeline pour voir où les choses se sont mal passées. L’erreur est alors souvent très facile à résoudre.",Xt,q,Ia='Pour le démontrer, nous utiliserons le script suivant qui tente de <em>finetuner</em> un modèle DistilBERT sur le <a href="https://huggingface.co/datasets/glue" rel="nofollow">jeu de données MNLI</a> :',Wt,x,Rt,_,ka="Si vous essayez de l’exécuter, vous serez confronté à une erreur plutôt cryptique :",Gt,Y,Vt,A,zt,F,ga="Cela va sans dire, mais si vos données sont corrompues, le <code>Trainer</code> ne sera pas capable de former des batchs et encore moins d’entraîner votre modèle. Donc, tout d’abord, vous devez jeter un coup d’oeil à ce qui se trouve dans votre jeu d’entraînement.",qt,H,Ba="Pour éviter d’innombrables heures passées à essayer de corriger quelque chose qui n’est pas la source du bug, nous vous recommandons d’utiliser <code>trainer.train_dataset</code> pour vos vérifications et rien d’autre. Faisons donc cela ici :",xt,N,_t,E,Yt,Q,Xa="Vous remarquez quelque chose d’anormal ? Ceci, en conjonction avec le message d’erreur sur les <code>input_ids</code> manquants, devrait vous faire réaliser que ce sont des textes et non des nombres que le modèle peut comprendre. Ici, l’erreur originale est très trompeuse parce que le <code>Trainer</code> enlève automatiquement les colonnes qui ne correspondent pas à la signature du modèle (c’est-à-dire, les arguments attendus par le modèle). Cela signifie qu’ici, tout, sauf les étiquettes, a été éliminé. Il n’y avait donc aucun problème à créer des batchs et à les envoyer ensuite au modèle, qui s’est plaint à son tour de ne pas avoir reçu les bons arguments.",At,S,Wa="Pourquoi les données n’ont-elles pas été traitées ? Nous avons utilisé la méthode <code>Dataset.map()</code> sur les jeux de données pour appliquer le <em>tokenizer</em> sur chaque échantillon. Mais si vous regardez attentivement le code, vous verrez que nous avons fait une erreur en passant les ensembles d’entraînement et d’évaluation au <code>Trainer</code>. Au lieu d’utiliser <code>tokenized_datasets</code> ici, nous avons utilisé <code>raw_datasets</code> 🤦. Alors corrigeons ça !",Ft,L,Ht,D,Ra="Ce nouveau code donnera maintenant une erreur différente (c’est un progrès !) :",Nt,P,Et,K,Ga="En regardant le <em>traceback</em>, nous pouvons voir que l’erreur se produit dans l’étape de collationnement des données :",Qt,O,St,ee,Va="Donc, nous devrions passer à cela. Mais avant finissons d’inspecter nos données, pour être sûrs à 100% qu’elles sont correctes.",Lt,se,za="Une chose que vous devriez toujours faire lorsque vous déboguez une session d’entraînement est de jeter un coup d’oeil aux entrées décodées de votre modèle. Nous ne pouvons pas donner un sens aux chiffres que nous lui fournissons directement, nous devons donc examiner ce que ces chiffres représentent. Dans le domaine de la vision par ordinateur cela signifie regarder les images décodées des pixels que vous passez, dans le domaine de la parole cela signifie écouter les échantillons audio décodés, et pour notre exemple de NLP cela signifie utiliser notre <em>tokenizer</em> pour décoder les entrées :",Dt,te,Pt,le,Kt,ne,qa="Cela semble correct. Vous devriez faire cela pour toutes les clés dans les entrées :",Ot,ae,el,re,sl,ie,xa="Notez que les clés qui ne correspondent pas à des entrées acceptées par le modèle seront automatiquement écartées, donc ici nous ne garderons que <code>input_ids</code>, <code>attention_mask</code>, et <code>label</code> (qui sera renommé <code>labels</code>). Pour revérifier la signature du modèle, vous pouvez imprimer la classe de votre modèle, puis aller consulter sa documentation :",tl,pe,ll,ue,nl,oe,_a='Donc dans notre cas, nous pouvons vérifier les paramètres acceptés sur <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">cette page</a>. Le <code>Trainer</code> va également enregistrer les colonnes qu’il rejette.',al,me,Ya="Nous avons vérifié que les identifiants d’entrée sont corrects en les décodant. Ensuite, il y a le <code>attention_mask</code> :",rl,de,il,ce,pl,Me,Aa="Comme nous n’avons pas appliqué de <em>padding</em> dans notre prétraitement, cela semble parfaitement naturel. Pour être sûr qu’il n’y a pas de problème avec ce masque d’attention, vérifions qu’il est de la même longueur que nos identifiants d’entrée :",ul,ye,ol,Je,ml,be,Fa="C’est bien ! Enfin, vérifions notre étiquette :",dl,je,cl,fe,Ml,Te,Ha="Comme les identifiants d’entrée, c’est un nombre qui n’a pas vraiment de sens en soi. Comme nous l’avons vu précédemment, la correspondance entre les entiers et les noms d’étiquettes est stockée dans l’attribut <code>names</code> de la <em>caractéristique</em> correspondante du jeu de données :",yl,we,Jl,he,bl,Ue,Na="Donc <code>1</code> signifie <code>neutral</code>, ce qui signifie que les deux phrases que nous avons vues ci-dessus ne sont pas en contradiction : la première n’implique pas la seconde. Cela semble correct !",jl,ve,Ea="Nous n’avons pas de <em>token</em> de type identifiant ici puisque DistilBERT ne les attend pas. Si vous en avez dans votre modèle, vous devriez également vous assurer qu’ils correspondent correctement à l’endroit où se trouvent la première et la deuxième phrase dans l’entrée.",fl,U,Tl,$e,Qa="Ici nous ne vérifions que le jeu d’entraînement. Vous devez bien sûr vérifier de la même façon les jeux de validation et de test.",wl,Ce,Sa="Maintenant que nous savons que nos jeux de données sont bons, il est temps de vérifier l’étape suivante du pipeline d’entraînement.",hl,Ze,Ul,Ie,La="La prochaine chose qui peut mal tourner dans le pipeline d’entraînement est lorsque le <code>Trainer</code> essaie de former des batchs à partir du jeu d’entraînement ou de validation. Une fois que vous êtes sûr que les jeux de données du <code>Trainer</code> sont corrects, vous pouvez essayer de former manuellement un batch en exécutant ce qui suit (remplacez <code>train</code> par <code>eval</code> pour le <em>dataloader</em> de validation) :",vl,ke,$l,ge,Da="Ce code crée le <em>dataloader</em> d’entraînement puis le parcourt en s’arrêtant à la première itération. Si le code s’exécute sans erreur, vous avez le premier batch d’entraînement que vous pouvez inspecter, et si le code se trompe, vous êtes sûr que le problème se situe dans le <em>dataloader</em>, comme c’est le cas ici :",Cl,Be,Zl,Xe,Pa="L’inspection de la dernière image du <em>traceback</em> devrait suffire à vous donner un indice mais creusons un peu plus. La plupart des problèmes lors de la création d’un batch sont dus à l’assemblage des exemples en un seul batch. La première chose à vérifier en cas de doute est le <code>collate_fn</code> utilisé par votre <code>DataLoader</code> :",Il,We,kl,Re,gl,Ge,Ka="C’est donc <code>default_data_collator</code>, mais ce n’est pas ce que nous voulons dans ce cas. Nous voulons rembourrer nos exemples à la phrase la plus longue du batch, ce qui est fait par <code>DataCollatorWithPadding</code>. Et cette assembleur de données est censé être utilisé par défaut par le <code>Trainer</code>, alors pourquoi n’est-il pas utilisé ici ?",Bl,Ve,Oa="La réponse est que nous n’avons pas passé le <code>tokenizer</code> au <code>Trainer</code>, donc il ne pouvait pas créer le <code>DataCollatorWithPadding</code> que nous voulons. En pratique, il ne faut jamais hésiter à transmettre explicitement l’assembleur de données que l’on veut utiliser pour être sûr d’éviter ce genre d’erreurs. Adaptons notre code pour faire exactement cela :",Xl,ze,Wl,qe,er="La bonne nouvelle ? Nous n’avons plus la même erreur qu’avant, ce qui est un progrès certain. La mauvaise nouvelle ? Nous obtenons une erreur CUDA infâme à la place :",Rl,xe,Gl,_e,sr="C’est une mauvaise chose car les erreurs CUDA sont extrêmement difficiles à déboguer en général. Nous verrons dans une minute comment résoudre ce problème mais terminons d’abord notre analyse de la création de batchs.",Vl,Ye,tr="Si vous êtes sûr que votre collecteur de données est le bon, vous devriez essayer de l’appliquer sur quelques échantillons de votre jeu de données :",zl,Ae,ql,Fe,lr="Ce code échouera parce que le <code>train_dataset</code> contient des colonnes de type <em>string</em> que le <code>Trainer</code> supprime habituellement. Vous pouvez les supprimer manuellement ou si vous voulez reproduire exactement ce que le <code>Trainer</code> fait en coulisse, vous pouvez appeler la méthode <code>Trainer._remove_unused_columns()</code> qui fait cela :",xl,He,_l,Ne,nr="Vous devriez alors être en mesure de déboguer manuellement ce qui se passe dans le collecteur de données si l’erreur persiste.",Yl,Ee,ar="Maintenant que nous avons débogué le processus de création de batch, il est temps d’en passer un dans le modèle !",Al,Qe,Fl,Se,rr="Vous devriez être en mesure d’obtenir un batch en exécutant la commande suivante :",Hl,Le,Nl,De,ir="Si vous exécutez ce code dans un <em>notebook</em>, vous risquez d’obtenir une erreur CUDA similaire à celle que nous avons vue précédemment, auquel cas vous devrez redémarrer votre <em>notebook</em> et réexécuter le dernier extrait sans la ligne <code>trainer.train()</code>. C’est la deuxième chose la plus ennuyeuse à propos des erreurs CUDA : elles cassent irrémédiablement votre noyau. La première plus ennuyeuse est le fait qu’elles sont difficiles à déboguer.",El,Pe,pr="Comment cela se fait-il ? Cela tient à la façon dont les GPUs fonctionnent. Ils sont extrêmement efficaces pour exécuter un batch d’opérations en parallèle, mais l’inconvénient est que lorsque l’une de ces instructions entraîne une erreur, vous ne le savez pas immédiatement. Ce n’est que lorsque le programme appelle une synchronisation des multiples processus sur le GPU qu’il réalise que quelque chose s’est mal passé, de sorte que l’erreur est en fait mentionnée à un endroit qui n’a rien à voir avec ce qui l’a créée. Par exemple, si nous regardons notre <em>traceback</em> précédent, l’erreur a été soulevée pendant la passe arrière, mais nous verrons dans une minute qu’elle provient en fait de quelque chose dans la passe avant.",Ql,Ke,ur="Alors comment déboguer ces erreurs ? La réponse est simple : nous ne le faisons pas. À moins que votre erreur CUDA ne soit une erreur <em>out-of-memory</em> (ce qui signifie qu’il n’y a pas assez de mémoire dans votre GPU), vous devez toujours revenir au CPU pour la déboguer.",Sl,Oe,or="Pour faire cela dans notre cas, nous devons juste remettre le modèle sur le CPU et l’appeler sur notre batch. Le batch retourné par le <code>DataLoader</code> n’a pas encore été déplacé sur le GPU :",Ll,es,Dl,ss,Pl,ts,mr="L’image devient plus claire. Au lieu d’avoir une erreur CUDA, nous avons maintenant une <code>IndexError</code> dans le calcul de la perte (donc rien à voir avec la passe arrière comme nous l’avons dit plus tôt). Plus précisément, nous pouvons voir que c’est la cible 2 qui crée l’erreur, donc c’est un bon moment pour vérifier le nombre de labels de notre modèle :",Kl,ls,Ol,ns,en,as,dr="Avec deux étiquettes, seuls les 0 et les 1 sont autorisés comme cibles, mais d’après le message d’erreur, nous avons obtenu un 2. Obtenir un 2 est en fait normal : si nous nous souvenons des noms des étiquettes que nous avons extraits plus tôt, il y en avait trois, donc nous avons les indices 0, 1 et 2 dans notre jeu de données. Le problème est que nous n’avons pas indiqué cela à notre modèle, qui aurait dû être créé avec trois étiquettes. Alors, corrigeons cela !",sn,rs,tn,is,cr="Nous n’incluons pas encore la ligne <code>trainer.train()</code> pour prendre le temps de vérifier que tout se passe bien. Si nous passons un batch à notre modèle, il fonctionne maintenant sans erreur !",ln,ps,nn,us,Mr="L’étape suivante consiste alors à revenir au GPU et à vérifier que tout fonctionne encore :",an,os,rn,ms,yr="Si vous obtenez toujours une erreur, assurez-vous de redémarrer votre <em>notebook</em> et d’exécuter uniquement la dernière version du script.",pn,ds,un,cs,Jr="Maintenant que nous savons que nous pouvons construire des batchs qui passent réellement par le modèle, nous sommes prêts pour l’étape suivante du pipeline d’entraînement : calculer les gradients et effectuer une étape d’optimisation.",on,Ms,br="La première partie est juste une question d’appel de la méthode <code>backward()</code> sur la perte :",mn,ys,dn,Js,jr="Il est plutôt rare d’obtenir une erreur à ce stade, mais si vous en obtenez une, assurez-vous de retourner au CPU pour obtenir un message d’erreur utile.",cn,bs,fr="Pour effectuer l’étape d’optimisation, il suffit de créer le <code>optimizer</code> et d’appeler sa méthode <code>step()</code> :",Mn,js,yn,fs,Tr="Encore une fois, si vous utilisez l’optimiseur par défaut dans le <code>Trainer</code>, vous ne devriez pas avoir d’erreur à ce stade, mais si vous avez un optimiseur personnalisé, il pourrait y avoir quelques problèmes à déboguer ici. N’oubliez pas de revenir au CPU si vous obtenez une erreur CUDA bizarre à ce stade. En parlant d’erreurs CUDA, nous avons mentionné précédemment un cas particulier. Voyons cela maintenant.",Jn,Ts,bn,ws,wr="Chaque fois que vous obtenez un message d’erreur qui commence par <code>RuntimeError : CUDA out of memory</code>, cela indique que vous êtes à court de mémoire GPU. Cela n’est pas directement lié à votre code et peut arriver avec un script qui fonctionne parfaitement bien. Cette erreur signifie que vous avez essayé de mettre trop de choses dans la mémoire interne de votre GPU et que cela a entraîné une erreur. Comme pour d’autres erreurs CUDA, vous devrez redémarrer votre noyau pour être en mesure d’exécuter à nouveau votre entraînement.",jn,hs,hr="Pour résoudre ce problème, il suffit d’utiliser moins d’espace GPU, ce qui est souvent plus facile à dire qu’à faire. Tout d’abord, assurez-vous que vous n’avez pas deux modèles sur le GPU en même temps (sauf si cela est nécessaire pour votre problème, bien sûr). Ensuite, vous devriez probablement réduire la taille de votre batch car elle affecte directement les tailles de toutes les sorties intermédiaires du modèle et leurs gradients. Si le problème persiste, envisagez d’utiliser une version plus petite de votre modèle.",fn,v,Tn,Us,wn,vs,Ur="Maintenant que nous avons résolu tous les problèmes liés à notre code, tout est parfait et l’entraînement devrait se dérouler sans problème, n’est-ce pas ? Pas si vite ! Si vous exécutez la commande <code>trainer.train()</code>, tout aura l’air bien au début, mais après un moment vous obtiendrez ce qui suit :",hn,$s,Un,Cs,vn,Zs,vr="Vous réaliserez que cette erreur apparaît pendant la phase d’évaluation, donc c’est la dernière chose que nous aurons besoin de déboguer.",$n,Is,$r="Vous pouvez exécuter la boucle d’évaluation du <code>Trainer</code> indépendamment de l’entraînement comme ceci :",Cn,ks,Zn,gs,In,$,kn,Bs,Cr="Avant de tenter de déboguer un problème dans la boucle d’évaluation, vous devez d’abord vous assurer que vous avez examiné les données, que vous êtes en mesure de former un batch correctement et que vous pouvez exécuter votre modèle sur ces données. Nous avons effectué toutes ces étapes, et le code suivant peut donc être exécuté sans erreur :",gn,Xs,Bn,Ws,Zr="L’erreur survient plus tard, à la fin de la phase d’évaluation, et si nous regardons le <em>traceback</em>, nous voyons ceci :",Xn,Rs,Wn,Gs,Ir="Cela nous indique que l’erreur provient du module <code>datasets/metric.py</code> donc c’est un problème avec notre fonction <code>compute_metrics()</code>. Elle prend un <em>tuple</em> avec les logits et les labels sous forme de tableaux NumPy, alors essayons de lui fournir cela :",Rn,Vs,Gn,zs,Vn,qs,kr="Nous obtenons la même erreur, donc le problème vient bien de cette fonction. Si on regarde son code, on voit qu’elle transmet simplement les <code>predictions</code> et les <code>labels</code> à <code>metric.compute()</code>. Y a-t-il donc un problème avec cette méthode ? Pas vraiment. Jetons un coup d’oeil rapide aux formes :",zn,xs,qn,_s,xn,Ys,gr="Nos prédictions sont toujours des logits et non les prédictions réelles, c’est pourquoi la métrique retourne cette erreur (quelque peu obscure). La correction est assez simple, il suffit d’ajouter un argmax dans la fonction <code>compute_metrics()</code> :",_n,As,Yn,Fs,An,Hs,Br="Maintenant notre erreur est corrigée ! C’était la dernière, donc notre script va maintenant entraîner un modèle correctement.",Fn,Ns,Xr="Pour référence, voici le script complètement corrigé :",Hn,Es,Nn,Qs,Wr="Dans ce cas, il n’y a plus de problème, et notre script va <em>finetuner</em> un modèle qui devrait donner des résultats raisonnables. Mais que faire lorsque l’entraînement se déroule sans erreur et que le modèle entraîné n’est pas du tout performant ? C’est la partie la plus difficile de l’apprentissage automatique et nous allons vous montrer quelques techniques qui peuvent vous aider.",En,C,Qn,Ss,Sn,Ls,Rr="Que peut-on faire pour déboguer un entraînement qui se termine sans erreur mais qui ne donne pas de bons résultats ? Nous allons vous donner quelques pistes ici, mais sachez que ce type de débogage est la partie la plus difficile de l’apprentissage automatique et qu’il n’y a pas de réponse magique.",Ln,Ds,Dn,Ps,Gr="Votre modèle n’apprendra quelque chose que s’il est réellement possible d’apprendre quelque chose de vos données. Si un <em>bug</em> corrompt les données ou si les étiquettes sont attribuées de manière aléatoire, il est très probable que vous n’obtiendrez aucun entraînement de modèle sur votre jeu de données. Commencez donc toujours par revérifier vos entrées et étiquettes décodées, et posez-vous les questions suivantes :",Pn,Ks,Vr="<li>les données décodées sont-elles compréhensibles ?</li> <li>êtes-vous d’accord avec les étiquettes ?</li> <li>y a-t-il une étiquette qui est plus courante que les autres ?</li> <li>quelle devrait être la perte/métrique si le modèle prédisait une réponse aléatoire/toujours la même réponse ?</li>",Kn,Z,On,Os,zr="Après avoir examiné vos données, examinez quelques-unes des prédictions du modèle. Si votre modèle produit des <em>tokens</em>, essayez aussi de les décoder ! Si le modèle prédit toujours la même chose, cela peut être dû au fait que votre jeu de données est biaisé en faveur d’une catégorie (pour les problèmes de classification). Des techniques telles que le suréchantillonnage des classes rares peuvent aider. D’autre part, cela peut également être dû à des problèmes d’entraînement tels que de mauvais réglages des hyperparamètres.",ea,et,qr="Si la perte/la métrique que vous obtenez sur votre modèle initial avant entraînement est très différente de la perte/la métrique à laquelle vous vous attendez pour des prédictions aléatoires, vérifiez la façon dont votre perte ou votre métrique est calculée. Il y a probablement un bug. Si vous utilisez plusieurs pertes que vous ajoutez à la fin, assurez-vous qu’elles sont de la même échelle.",sa,st,xr="Lorsque vous êtes sûr que vos données sont parfaites, vous pouvez voir si le modèle est capable de s’entraîner sur elles grâce à un test simple.",ta,tt,la,lt,_r="Le surentraînement est généralement une chose que nous essayons d’éviter lors de l’entraînement car cela signifie que le modèle n’apprend pas à reconnaître les caractéristiques générales que nous voulons qu’il reconnaisse et se contente de mémoriser les échantillons d’entraînement. Cependant, essayer d’entraîner votre modèle sur un batch encore et encore est un bon test pour vérifier si le problème tel que vous l’avez formulé peut être résolu par le modèle que vous essayez d’entraîner. Cela vous aidera également à voir si votre taux d’apprentissage initial est trop élevé.",na,nt,Yr="Une fois que vous avez défini votre <code>modèle</code>, c’est très facile. Il suffit de prendre un batch de données d’entraînement, puis de le traiter comme votre jeu de données entier que vous <em>finetunez</em> sur un grand nombre d’époques :",aa,at,ra,I,ia,rt,Ar="Le modèle résultant devrait avoir des résultats proches de la perfection sur le même <code>batch</code>. Calculons la métrique sur les prédictions résultantes :",pa,it,ua,pt,oa,ut,Fr="100% de précision, voilà un bel exemple de surentraînement (ce qui signifie que si vous essayez votre modèle sur n’importe quelle autre phrase, il vous donnera très probablement une mauvaise réponse) !",ma,ot,Hr="Si vous ne parvenez pas à ce que votre modèle obtienne des résultats parfaits comme celui-ci, cela signifie qu’il y a quelque chose qui ne va pas dans la façon dont vous avez formulé le problème ou dans vos données. Vous devez donc y remédier. Ce n’est que lorsque vous parviendrez à passer le test de surentraînement que vous pourrez être sûr que votre modèle peut réellement apprendre quelque chose.",da,k,ca,mt,Ma,dt,Nr="Le réglage des hyperparamètres est toujours considéré comme la partie la plus difficile de l’apprentissage automatique mais c’est juste la dernière étape pour vous aider à gagner un peu sur la métrique. La plupart du temps, les hyperparamètres par défaut du <code>Trainer</code> fonctionneront très bien pour vous donner de bons résultats. Donc ne vous lancez pas dans une recherche d’hyperparamètres longue et coûteuse jusqu’à ce que vous ayez quelque chose qui batte la ligne de base que vous avez sur votre jeu de données.",ya,ct,Er="Une fois que vous avez un modèle suffisamment bon, vous pouvez commencer à le <em>finetuner</em> un peu. N’essayez pas de lancer un millier d’exécutions avec différents hyperparamètres mais comparez quelques exécutions avec différentes valeurs pour un hyperparamètre afin de vous faire une idée de celui qui a le plus d’impact.",Ja,Mt,Qr="Si vous modifiez le modèle lui-même, restez simple et n’essayez rien que vous ne puissiez raisonnablement justifier. Veillez toujours à revenir au test de surentraînement pour vérifier que votre modification n’a pas eu de conséquences inattendues.",ba,yt,ja,Jt,Sr='Nous espérons que vous avez trouvé dans cette section des conseils qui vous ont aidé à résoudre votre problème. Si ce n’est pas le cas, n’oubliez pas que vous pouvez toujours demander de l’aide à la communauté sur le <a href="https://discuss.huggingface.co/" rel="nofollow">forum</a>.',fa,bt,Lr="Voici quelques ressources (en anglais) supplémentaires qui peuvent s’avérer utiles :",Ta,jt,Dr='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">La reproductibilité comme vecteur des meilleures pratiques d’ingénierie</a> par Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">Liste de contrôle pour le débogage des réseaux de neurones</a> par Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">Comment tester unitairement le code d’apprentissage automatique</a> par Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">Une recette pour entraîner les réseaux de neurones</a> par Andrej Karpathy</li>',wa,ft,Pr="Bien sûr, tous les problèmes rencontrés lors de l’entraînement ne sont pas forcément de votre faute ! Si vous rencontrez quelque chose dans la bibliothèque 🤗 <em>Transformers</em> ou 🤗 <em>Datasets</em> qui ne semble pas correct, vous avez peut-être trouver un <em>bug</em>. Vous devez absolument nous en parler pour qu’on puisse le corriger. Dans la section suivante, nous allons vous expliquer exactement comment faire.",ha,Tt,Ua,Ut,va;return h=new ji({props:{fw:T[0]}}),g=new Mi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new w({props:{title:"Débogage du pipeline d’entraînement",local:"débogage-du-pipeline-dentraînement",headingTag:"h1"}}),X=new bi({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter8/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter8/section4.ipynb"}]}}),R=new w({props:{title:"Déboguer le pipeline d’entraînement",local:"déboguer-le-pipeline-dentraînement",headingTag:"h2"}}),G=new Ji({props:{id:"L-WSwUWde1U"}}),x=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),Y=new J({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),A=new w({props:{title:"Vérifiez vos données",local:"vérifiez-vos-données",headingTag:"h3"}}),N=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),E=new J({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),L=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),P=new J({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),O=new J({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),te=new J({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),le=new J({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ae=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),re=new J({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),pe=new J({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),ue=new J({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),de=new J({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQp",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>])',wrap:!1}}),ce=new J({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),ye=new J({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),Je=new J({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),je=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),fe=new J({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),we=new J({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),he=new J({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new wt({props:{$$slots:{default:[fi]},$$scope:{ctx:T}}}),Ze=new w({props:{title:"Des jeux de données aux chargeurs de données",local:"des-jeux-de-données-aux-chargeurs-de-données",headingTag:"h3"}}),ke=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Be=new J({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),We=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Re=new J({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),ze=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),xe=new J({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),Ae=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),He=new J({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Qe=new w({props:{title:"Passage par le modèle",local:"passage-par-le-modèle",headingTag:"h3"}}),Le=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),es=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),ss=new J({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),ls=new J({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),ns=new J({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),rs=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),ps=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),os=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),ds=new w({props:{title:"Exécution d’une étape d’optimisation",local:"exécution-dune-étape-doptimisation",headingTag:"h3"}}),ys=new J({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),js=new J({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),Ts=new w({props:{title:"Gérer les erreurs <i> CUDA out of memory </i>",local:"gérer-les-erreurs-i-cuda-out-of-memory-i",headingTag:"h3"}}),v=new wt({props:{$$slots:{default:[Ti]},$$scope:{ctx:T}}}),Us=new w({props:{title:"Évaluation du modèle",local:"évaluation-du-modèle",headingTag:"h3"}}),$s=new J({props:{code:"JTIzJTIwQ2VsYSUyMHByZW5kcmElMjBiZWF1Y291cCUyMGRlJTIwdGVtcHMlMjBldCUyMHNlJTIwc29sZGVyYSUyMHBhciUyMHVuZSUyMGVycmV1ciUyQyUyMHZvdXMlMjBuZSUyMGRldnJpZXolMjBkb25jJTIwcGFzJTIwdXRpbGlzZXIlMjBjZXR0ZSUyMGNlbGx1bGUuJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># Cela prendra beaucoup de temps et se soldera par une erreur, vous ne devriez donc pas utiliser cette cellule.</span>
trainer.train()`,wrap:!1}}),Cs=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),ks=new J({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),gs=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),$=new wt({props:{$$slots:{default:[wi]},$$scope:{ctx:T}}}),Xs=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Rs=new J({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),Vs=new J({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),zs=new J({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),xs=new J({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),_s=new J({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),As=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Fs=new J({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Es=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),C=new wt({props:{$$slots:{default:[hi]},$$scope:{ctx:T}}}),Ss=new w({props:{title:"Déboguer les erreurs silencieuses pendant l’entraînement",local:"déboguer-les-erreurs-silencieuses-pendant-lentraînement",headingTag:"h2"}}),Ds=new w({props:{title:"Vérifiez vos données (encore !)",local:"vérifiez-vos-données-encore-",headingTag:"h3"}}),Z=new wt({props:{warning:!0,$$slots:{default:[Ui]},$$scope:{ctx:T}}}),tt=new w({props:{title:"Surentraînement du modèle sur un seul batch",local:"surentraînement-du-modèle-sur-un-seul-batch",headingTag:"h3"}}),at=new J({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),I=new wt({props:{$$slots:{default:[vi]},$$scope:{ctx:T}}}),it=new J({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),pt=new J({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),k=new wt({props:{warning:!0,$$slots:{default:[$i]},$$scope:{ctx:T}}}),mt=new w({props:{title:"Ne réglez rien tant que vous n’avez pas une première ligne de base",local:"ne-réglez-rien-tant-que-vous-navez-pas-une-première-ligne-de-base",headingTag:"h3"}}),yt=new w({props:{title:"Demander de l’aide",local:"demander-de-laide",headingTag:"h3"}}),Tt=new yi({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter8/4.mdx"}}),{c(){y=r("meta"),j=n(),b=r("p"),f=n(),u(h.$$.fragment),vt=n(),u(g.$$.fragment),$t=n(),u(B.$$.fragment),Ct=n(),u(X.$$.fragment),Zt=n(),W=r("p"),W.innerHTML=$a,It=n(),u(R.$$.fragment),kt=n(),u(G.$$.fragment),gt=n(),V=r("p"),V.innerHTML=Ca,Bt=n(),z=r("p"),z.innerHTML=Za,Xt=n(),q=r("p"),q.innerHTML=Ia,Wt=n(),u(x.$$.fragment),Rt=n(),_=r("p"),_.textContent=ka,Gt=n(),u(Y.$$.fragment),Vt=n(),u(A.$$.fragment),zt=n(),F=r("p"),F.innerHTML=ga,qt=n(),H=r("p"),H.innerHTML=Ba,xt=n(),u(N.$$.fragment),_t=n(),u(E.$$.fragment),Yt=n(),Q=r("p"),Q.innerHTML=Xa,At=n(),S=r("p"),S.innerHTML=Wa,Ft=n(),u(L.$$.fragment),Ht=n(),D=r("p"),D.textContent=Ra,Nt=n(),u(P.$$.fragment),Et=n(),K=r("p"),K.innerHTML=Ga,Qt=n(),u(O.$$.fragment),St=n(),ee=r("p"),ee.textContent=Va,Lt=n(),se=r("p"),se.innerHTML=za,Dt=n(),u(te.$$.fragment),Pt=n(),u(le.$$.fragment),Kt=n(),ne=r("p"),ne.textContent=qa,Ot=n(),u(ae.$$.fragment),el=n(),u(re.$$.fragment),sl=n(),ie=r("p"),ie.innerHTML=xa,tl=n(),u(pe.$$.fragment),ll=n(),u(ue.$$.fragment),nl=n(),oe=r("p"),oe.innerHTML=_a,al=n(),me=r("p"),me.innerHTML=Ya,rl=n(),u(de.$$.fragment),il=n(),u(ce.$$.fragment),pl=n(),Me=r("p"),Me.innerHTML=Aa,ul=n(),u(ye.$$.fragment),ol=n(),u(Je.$$.fragment),ml=n(),be=r("p"),be.textContent=Fa,dl=n(),u(je.$$.fragment),cl=n(),u(fe.$$.fragment),Ml=n(),Te=r("p"),Te.innerHTML=Ha,yl=n(),u(we.$$.fragment),Jl=n(),u(he.$$.fragment),bl=n(),Ue=r("p"),Ue.innerHTML=Na,jl=n(),ve=r("p"),ve.innerHTML=Ea,fl=n(),u(U.$$.fragment),Tl=n(),$e=r("p"),$e.textContent=Qa,wl=n(),Ce=r("p"),Ce.textContent=Sa,hl=n(),u(Ze.$$.fragment),Ul=n(),Ie=r("p"),Ie.innerHTML=La,vl=n(),u(ke.$$.fragment),$l=n(),ge=r("p"),ge.innerHTML=Da,Cl=n(),u(Be.$$.fragment),Zl=n(),Xe=r("p"),Xe.innerHTML=Pa,Il=n(),u(We.$$.fragment),kl=n(),u(Re.$$.fragment),gl=n(),Ge=r("p"),Ge.innerHTML=Ka,Bl=n(),Ve=r("p"),Ve.innerHTML=Oa,Xl=n(),u(ze.$$.fragment),Wl=n(),qe=r("p"),qe.textContent=er,Rl=n(),u(xe.$$.fragment),Gl=n(),_e=r("p"),_e.textContent=sr,Vl=n(),Ye=r("p"),Ye.textContent=tr,zl=n(),u(Ae.$$.fragment),ql=n(),Fe=r("p"),Fe.innerHTML=lr,xl=n(),u(He.$$.fragment),_l=n(),Ne=r("p"),Ne.textContent=nr,Yl=n(),Ee=r("p"),Ee.textContent=ar,Al=n(),u(Qe.$$.fragment),Fl=n(),Se=r("p"),Se.textContent=rr,Hl=n(),u(Le.$$.fragment),Nl=n(),De=r("p"),De.innerHTML=ir,El=n(),Pe=r("p"),Pe.innerHTML=pr,Ql=n(),Ke=r("p"),Ke.innerHTML=ur,Sl=n(),Oe=r("p"),Oe.innerHTML=or,Ll=n(),u(es.$$.fragment),Dl=n(),u(ss.$$.fragment),Pl=n(),ts=r("p"),ts.innerHTML=mr,Kl=n(),u(ls.$$.fragment),Ol=n(),u(ns.$$.fragment),en=n(),as=r("p"),as.textContent=dr,sn=n(),u(rs.$$.fragment),tn=n(),is=r("p"),is.innerHTML=cr,ln=n(),u(ps.$$.fragment),nn=n(),us=r("p"),us.textContent=Mr,an=n(),u(os.$$.fragment),rn=n(),ms=r("p"),ms.innerHTML=yr,pn=n(),u(ds.$$.fragment),un=n(),cs=r("p"),cs.textContent=Jr,on=n(),Ms=r("p"),Ms.innerHTML=br,mn=n(),u(ys.$$.fragment),dn=n(),Js=r("p"),Js.textContent=jr,cn=n(),bs=r("p"),bs.innerHTML=fr,Mn=n(),u(js.$$.fragment),yn=n(),fs=r("p"),fs.innerHTML=Tr,Jn=n(),u(Ts.$$.fragment),bn=n(),ws=r("p"),ws.innerHTML=wr,jn=n(),hs=r("p"),hs.textContent=hr,fn=n(),u(v.$$.fragment),Tn=n(),u(Us.$$.fragment),wn=n(),vs=r("p"),vs.innerHTML=Ur,hn=n(),u($s.$$.fragment),Un=n(),u(Cs.$$.fragment),vn=n(),Zs=r("p"),Zs.textContent=vr,$n=n(),Is=r("p"),Is.innerHTML=$r,Cn=n(),u(ks.$$.fragment),Zn=n(),u(gs.$$.fragment),In=n(),u($.$$.fragment),kn=n(),Bs=r("p"),Bs.textContent=Cr,gn=n(),u(Xs.$$.fragment),Bn=n(),Ws=r("p"),Ws.innerHTML=Zr,Xn=n(),u(Rs.$$.fragment),Wn=n(),Gs=r("p"),Gs.innerHTML=Ir,Rn=n(),u(Vs.$$.fragment),Gn=n(),u(zs.$$.fragment),Vn=n(),qs=r("p"),qs.innerHTML=kr,zn=n(),u(xs.$$.fragment),qn=n(),u(_s.$$.fragment),xn=n(),Ys=r("p"),Ys.innerHTML=gr,_n=n(),u(As.$$.fragment),Yn=n(),u(Fs.$$.fragment),An=n(),Hs=r("p"),Hs.textContent=Br,Fn=n(),Ns=r("p"),Ns.textContent=Xr,Hn=n(),u(Es.$$.fragment),Nn=n(),Qs=r("p"),Qs.innerHTML=Wr,En=n(),u(C.$$.fragment),Qn=n(),u(Ss.$$.fragment),Sn=n(),Ls=r("p"),Ls.textContent=Rr,Ln=n(),u(Ds.$$.fragment),Dn=n(),Ps=r("p"),Ps.innerHTML=Gr,Pn=n(),Ks=r("ul"),Ks.innerHTML=Vr,Kn=n(),u(Z.$$.fragment),On=n(),Os=r("p"),Os.innerHTML=zr,ea=n(),et=r("p"),et.textContent=qr,sa=n(),st=r("p"),st.textContent=xr,ta=n(),u(tt.$$.fragment),la=n(),lt=r("p"),lt.textContent=_r,na=n(),nt=r("p"),nt.innerHTML=Yr,aa=n(),u(at.$$.fragment),ra=n(),u(I.$$.fragment),ia=n(),rt=r("p"),rt.innerHTML=Ar,pa=n(),u(it.$$.fragment),ua=n(),u(pt.$$.fragment),oa=n(),ut=r("p"),ut.textContent=Fr,ma=n(),ot=r("p"),ot.textContent=Hr,da=n(),u(k.$$.fragment),ca=n(),u(mt.$$.fragment),Ma=n(),dt=r("p"),dt.innerHTML=Nr,ya=n(),ct=r("p"),ct.innerHTML=Er,Ja=n(),Mt=r("p"),Mt.textContent=Qr,ba=n(),u(yt.$$.fragment),ja=n(),Jt=r("p"),Jt.innerHTML=Sr,fa=n(),bt=r("p"),bt.textContent=Lr,Ta=n(),jt=r("ul"),jt.innerHTML=Dr,wa=n(),ft=r("p"),ft.innerHTML=Pr,ha=n(),u(Tt.$$.fragment),Ua=n(),Ut=r("p"),this.h()},l(e){const s=di("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(t),j=a(e),b=i(e,"P",{}),ri(b).forEach(t),f=a(e),o(h.$$.fragment,e),vt=a(e),o(g.$$.fragment,e),$t=a(e),o(B.$$.fragment,e),Ct=a(e),o(X.$$.fragment,e),Zt=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1mau680"&&(W.innerHTML=$a),It=a(e),o(R.$$.fragment,e),kt=a(e),o(G.$$.fragment,e),gt=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1wti6n9"&&(V.innerHTML=Ca),Bt=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-12hq778"&&(z.innerHTML=Za),Xt=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-uhthe0"&&(q.innerHTML=Ia),Wt=a(e),o(x.$$.fragment,e),Rt=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-9ibmas"&&(_.textContent=ka),Gt=a(e),o(Y.$$.fragment,e),Vt=a(e),o(A.$$.fragment,e),zt=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-oi18eq"&&(F.innerHTML=ga),qt=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-46r3cm"&&(H.innerHTML=Ba),xt=a(e),o(N.$$.fragment,e),_t=a(e),o(E.$$.fragment,e),Yt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-sjsxpf"&&(Q.innerHTML=Xa),At=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-b15f21"&&(S.innerHTML=Wa),Ft=a(e),o(L.$$.fragment,e),Ht=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vu0r5b"&&(D.textContent=Ra),Nt=a(e),o(P.$$.fragment,e),Et=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-o8enin"&&(K.innerHTML=Ga),Qt=a(e),o(O.$$.fragment,e),St=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-114xf28"&&(ee.textContent=Va),Lt=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-3bqdic"&&(se.innerHTML=za),Dt=a(e),o(te.$$.fragment,e),Pt=a(e),o(le.$$.fragment,e),Kt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ilu6no"&&(ne.textContent=qa),Ot=a(e),o(ae.$$.fragment,e),el=a(e),o(re.$$.fragment,e),sl=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-29fifm"&&(ie.innerHTML=xa),tl=a(e),o(pe.$$.fragment,e),ll=a(e),o(ue.$$.fragment,e),nl=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-6x2ske"&&(oe.innerHTML=_a),al=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-cshwr2"&&(me.innerHTML=Ya),rl=a(e),o(de.$$.fragment,e),il=a(e),o(ce.$$.fragment,e),pl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-13m88xy"&&(Me.innerHTML=Aa),ul=a(e),o(ye.$$.fragment,e),ol=a(e),o(Je.$$.fragment,e),ml=a(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-rg6vo0"&&(be.textContent=Fa),dl=a(e),o(je.$$.fragment,e),cl=a(e),o(fe.$$.fragment,e),Ml=a(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-8bectx"&&(Te.innerHTML=Ha),yl=a(e),o(we.$$.fragment,e),Jl=a(e),o(he.$$.fragment,e),bl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-ta3je7"&&(Ue.innerHTML=Na),jl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1xp357l"&&(ve.innerHTML=Ea),fl=a(e),o(U.$$.fragment,e),Tl=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-z6tupj"&&($e.textContent=Qa),wl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-10me0ea"&&(Ce.textContent=Sa),hl=a(e),o(Ze.$$.fragment,e),Ul=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-9nhifg"&&(Ie.innerHTML=La),vl=a(e),o(ke.$$.fragment,e),$l=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-ctw32m"&&(ge.innerHTML=Da),Cl=a(e),o(Be.$$.fragment,e),Zl=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1809u5i"&&(Xe.innerHTML=Pa),Il=a(e),o(We.$$.fragment,e),kl=a(e),o(Re.$$.fragment,e),gl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-hcqtmu"&&(Ge.innerHTML=Ka),Bl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1uspi9s"&&(Ve.innerHTML=Oa),Xl=a(e),o(ze.$$.fragment,e),Wl=a(e),qe=i(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-iaknwn"&&(qe.textContent=er),Rl=a(e),o(xe.$$.fragment,e),Gl=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-qjorjg"&&(_e.textContent=sr),Vl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1vv48a3"&&(Ye.textContent=tr),zl=a(e),o(Ae.$$.fragment,e),ql=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1khajlq"&&(Fe.innerHTML=lr),xl=a(e),o(He.$$.fragment,e),_l=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1b50lld"&&(Ne.textContent=nr),Yl=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1xenmq2"&&(Ee.textContent=ar),Al=a(e),o(Qe.$$.fragment,e),Fl=a(e),Se=i(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1pmcz88"&&(Se.textContent=rr),Hl=a(e),o(Le.$$.fragment,e),Nl=a(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-gz9b75"&&(De.innerHTML=ir),El=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1oan8k6"&&(Pe.innerHTML=pr),Ql=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-sv8dgy"&&(Ke.innerHTML=ur),Sl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-rc8lae"&&(Oe.innerHTML=or),Ll=a(e),o(es.$$.fragment,e),Dl=a(e),o(ss.$$.fragment,e),Pl=a(e),ts=i(e,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-1t4pvd5"&&(ts.innerHTML=mr),Kl=a(e),o(ls.$$.fragment,e),Ol=a(e),o(ns.$$.fragment,e),en=a(e),as=i(e,"P",{"data-svelte-h":!0}),p(as)!=="svelte-7wz3hh"&&(as.textContent=dr),sn=a(e),o(rs.$$.fragment,e),tn=a(e),is=i(e,"P",{"data-svelte-h":!0}),p(is)!=="svelte-1lb6fke"&&(is.innerHTML=cr),ln=a(e),o(ps.$$.fragment,e),nn=a(e),us=i(e,"P",{"data-svelte-h":!0}),p(us)!=="svelte-1b3mtla"&&(us.textContent=Mr),an=a(e),o(os.$$.fragment,e),rn=a(e),ms=i(e,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-185tg89"&&(ms.innerHTML=yr),pn=a(e),o(ds.$$.fragment,e),un=a(e),cs=i(e,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-x8sg8f"&&(cs.textContent=Jr),on=a(e),Ms=i(e,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-7qfszy"&&(Ms.innerHTML=br),mn=a(e),o(ys.$$.fragment,e),dn=a(e),Js=i(e,"P",{"data-svelte-h":!0}),p(Js)!=="svelte-du8k11"&&(Js.textContent=jr),cn=a(e),bs=i(e,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-6dm9x0"&&(bs.innerHTML=fr),Mn=a(e),o(js.$$.fragment,e),yn=a(e),fs=i(e,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-o5dcv1"&&(fs.innerHTML=Tr),Jn=a(e),o(Ts.$$.fragment,e),bn=a(e),ws=i(e,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-epc4wu"&&(ws.innerHTML=wr),jn=a(e),hs=i(e,"P",{"data-svelte-h":!0}),p(hs)!=="svelte-vju543"&&(hs.textContent=hr),fn=a(e),o(v.$$.fragment,e),Tn=a(e),o(Us.$$.fragment,e),wn=a(e),vs=i(e,"P",{"data-svelte-h":!0}),p(vs)!=="svelte-1bun12"&&(vs.innerHTML=Ur),hn=a(e),o($s.$$.fragment,e),Un=a(e),o(Cs.$$.fragment,e),vn=a(e),Zs=i(e,"P",{"data-svelte-h":!0}),p(Zs)!=="svelte-1vlknu0"&&(Zs.textContent=vr),$n=a(e),Is=i(e,"P",{"data-svelte-h":!0}),p(Is)!=="svelte-zojrsj"&&(Is.innerHTML=$r),Cn=a(e),o(ks.$$.fragment,e),Zn=a(e),o(gs.$$.fragment,e),In=a(e),o($.$$.fragment,e),kn=a(e),Bs=i(e,"P",{"data-svelte-h":!0}),p(Bs)!=="svelte-1qybf2m"&&(Bs.textContent=Cr),gn=a(e),o(Xs.$$.fragment,e),Bn=a(e),Ws=i(e,"P",{"data-svelte-h":!0}),p(Ws)!=="svelte-uqezsf"&&(Ws.innerHTML=Zr),Xn=a(e),o(Rs.$$.fragment,e),Wn=a(e),Gs=i(e,"P",{"data-svelte-h":!0}),p(Gs)!=="svelte-1ww5yfm"&&(Gs.innerHTML=Ir),Rn=a(e),o(Vs.$$.fragment,e),Gn=a(e),o(zs.$$.fragment,e),Vn=a(e),qs=i(e,"P",{"data-svelte-h":!0}),p(qs)!=="svelte-1r96wcf"&&(qs.innerHTML=kr),zn=a(e),o(xs.$$.fragment,e),qn=a(e),o(_s.$$.fragment,e),xn=a(e),Ys=i(e,"P",{"data-svelte-h":!0}),p(Ys)!=="svelte-1bjjyjz"&&(Ys.innerHTML=gr),_n=a(e),o(As.$$.fragment,e),Yn=a(e),o(Fs.$$.fragment,e),An=a(e),Hs=i(e,"P",{"data-svelte-h":!0}),p(Hs)!=="svelte-1nw2iup"&&(Hs.textContent=Br),Fn=a(e),Ns=i(e,"P",{"data-svelte-h":!0}),p(Ns)!=="svelte-14xtsxo"&&(Ns.textContent=Xr),Hn=a(e),o(Es.$$.fragment,e),Nn=a(e),Qs=i(e,"P",{"data-svelte-h":!0}),p(Qs)!=="svelte-rk8392"&&(Qs.innerHTML=Wr),En=a(e),o(C.$$.fragment,e),Qn=a(e),o(Ss.$$.fragment,e),Sn=a(e),Ls=i(e,"P",{"data-svelte-h":!0}),p(Ls)!=="svelte-84a3qr"&&(Ls.textContent=Rr),Ln=a(e),o(Ds.$$.fragment,e),Dn=a(e),Ps=i(e,"P",{"data-svelte-h":!0}),p(Ps)!=="svelte-1hg9m7"&&(Ps.innerHTML=Gr),Pn=a(e),Ks=i(e,"UL",{"data-svelte-h":!0}),p(Ks)!=="svelte-13wjueb"&&(Ks.innerHTML=Vr),Kn=a(e),o(Z.$$.fragment,e),On=a(e),Os=i(e,"P",{"data-svelte-h":!0}),p(Os)!=="svelte-1y5bokj"&&(Os.innerHTML=zr),ea=a(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1l0bmht"&&(et.textContent=qr),sa=a(e),st=i(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-zy23ex"&&(st.textContent=xr),ta=a(e),o(tt.$$.fragment,e),la=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-17ha5bs"&&(lt.textContent=_r),na=a(e),nt=i(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-6gk117"&&(nt.innerHTML=Yr),aa=a(e),o(at.$$.fragment,e),ra=a(e),o(I.$$.fragment,e),ia=a(e),rt=i(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1cl2cti"&&(rt.innerHTML=Ar),pa=a(e),o(it.$$.fragment,e),ua=a(e),o(pt.$$.fragment,e),oa=a(e),ut=i(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-8w843y"&&(ut.textContent=Fr),ma=a(e),ot=i(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1i6p5e8"&&(ot.textContent=Hr),da=a(e),o(k.$$.fragment,e),ca=a(e),o(mt.$$.fragment,e),Ma=a(e),dt=i(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1rugqlt"&&(dt.innerHTML=Nr),ya=a(e),ct=i(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1wbne1l"&&(ct.innerHTML=Er),Ja=a(e),Mt=i(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1a5bda8"&&(Mt.textContent=Qr),ba=a(e),o(yt.$$.fragment,e),ja=a(e),Jt=i(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-wtra40"&&(Jt.innerHTML=Sr),fa=a(e),bt=i(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-n3ix2i"&&(bt.textContent=Lr),Ta=a(e),jt=i(e,"UL",{"data-svelte-h":!0}),p(jt)!=="svelte-18a5uom"&&(jt.innerHTML=Dr),wa=a(e),ft=i(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-9x6bwk"&&(ft.innerHTML=Pr),ha=a(e),o(Tt.$$.fragment,e),Ua=a(e),Ut=i(e,"P",{}),ri(Ut).forEach(t),this.h()},h(){ii(y,"name","hf:doc:metadata"),ii(y,"content",Zi)},m(e,s){ci(document.head,y),l(e,j,s),l(e,b,s),l(e,f,s),m(h,e,s),l(e,vt,s),m(g,e,s),l(e,$t,s),m(B,e,s),l(e,Ct,s),m(X,e,s),l(e,Zt,s),l(e,W,s),l(e,It,s),m(R,e,s),l(e,kt,s),m(G,e,s),l(e,gt,s),l(e,V,s),l(e,Bt,s),l(e,z,s),l(e,Xt,s),l(e,q,s),l(e,Wt,s),m(x,e,s),l(e,Rt,s),l(e,_,s),l(e,Gt,s),m(Y,e,s),l(e,Vt,s),m(A,e,s),l(e,zt,s),l(e,F,s),l(e,qt,s),l(e,H,s),l(e,xt,s),m(N,e,s),l(e,_t,s),m(E,e,s),l(e,Yt,s),l(e,Q,s),l(e,At,s),l(e,S,s),l(e,Ft,s),m(L,e,s),l(e,Ht,s),l(e,D,s),l(e,Nt,s),m(P,e,s),l(e,Et,s),l(e,K,s),l(e,Qt,s),m(O,e,s),l(e,St,s),l(e,ee,s),l(e,Lt,s),l(e,se,s),l(e,Dt,s),m(te,e,s),l(e,Pt,s),m(le,e,s),l(e,Kt,s),l(e,ne,s),l(e,Ot,s),m(ae,e,s),l(e,el,s),m(re,e,s),l(e,sl,s),l(e,ie,s),l(e,tl,s),m(pe,e,s),l(e,ll,s),m(ue,e,s),l(e,nl,s),l(e,oe,s),l(e,al,s),l(e,me,s),l(e,rl,s),m(de,e,s),l(e,il,s),m(ce,e,s),l(e,pl,s),l(e,Me,s),l(e,ul,s),m(ye,e,s),l(e,ol,s),m(Je,e,s),l(e,ml,s),l(e,be,s),l(e,dl,s),m(je,e,s),l(e,cl,s),m(fe,e,s),l(e,Ml,s),l(e,Te,s),l(e,yl,s),m(we,e,s),l(e,Jl,s),m(he,e,s),l(e,bl,s),l(e,Ue,s),l(e,jl,s),l(e,ve,s),l(e,fl,s),m(U,e,s),l(e,Tl,s),l(e,$e,s),l(e,wl,s),l(e,Ce,s),l(e,hl,s),m(Ze,e,s),l(e,Ul,s),l(e,Ie,s),l(e,vl,s),m(ke,e,s),l(e,$l,s),l(e,ge,s),l(e,Cl,s),m(Be,e,s),l(e,Zl,s),l(e,Xe,s),l(e,Il,s),m(We,e,s),l(e,kl,s),m(Re,e,s),l(e,gl,s),l(e,Ge,s),l(e,Bl,s),l(e,Ve,s),l(e,Xl,s),m(ze,e,s),l(e,Wl,s),l(e,qe,s),l(e,Rl,s),m(xe,e,s),l(e,Gl,s),l(e,_e,s),l(e,Vl,s),l(e,Ye,s),l(e,zl,s),m(Ae,e,s),l(e,ql,s),l(e,Fe,s),l(e,xl,s),m(He,e,s),l(e,_l,s),l(e,Ne,s),l(e,Yl,s),l(e,Ee,s),l(e,Al,s),m(Qe,e,s),l(e,Fl,s),l(e,Se,s),l(e,Hl,s),m(Le,e,s),l(e,Nl,s),l(e,De,s),l(e,El,s),l(e,Pe,s),l(e,Ql,s),l(e,Ke,s),l(e,Sl,s),l(e,Oe,s),l(e,Ll,s),m(es,e,s),l(e,Dl,s),m(ss,e,s),l(e,Pl,s),l(e,ts,s),l(e,Kl,s),m(ls,e,s),l(e,Ol,s),m(ns,e,s),l(e,en,s),l(e,as,s),l(e,sn,s),m(rs,e,s),l(e,tn,s),l(e,is,s),l(e,ln,s),m(ps,e,s),l(e,nn,s),l(e,us,s),l(e,an,s),m(os,e,s),l(e,rn,s),l(e,ms,s),l(e,pn,s),m(ds,e,s),l(e,un,s),l(e,cs,s),l(e,on,s),l(e,Ms,s),l(e,mn,s),m(ys,e,s),l(e,dn,s),l(e,Js,s),l(e,cn,s),l(e,bs,s),l(e,Mn,s),m(js,e,s),l(e,yn,s),l(e,fs,s),l(e,Jn,s),m(Ts,e,s),l(e,bn,s),l(e,ws,s),l(e,jn,s),l(e,hs,s),l(e,fn,s),m(v,e,s),l(e,Tn,s),m(Us,e,s),l(e,wn,s),l(e,vs,s),l(e,hn,s),m($s,e,s),l(e,Un,s),m(Cs,e,s),l(e,vn,s),l(e,Zs,s),l(e,$n,s),l(e,Is,s),l(e,Cn,s),m(ks,e,s),l(e,Zn,s),m(gs,e,s),l(e,In,s),m($,e,s),l(e,kn,s),l(e,Bs,s),l(e,gn,s),m(Xs,e,s),l(e,Bn,s),l(e,Ws,s),l(e,Xn,s),m(Rs,e,s),l(e,Wn,s),l(e,Gs,s),l(e,Rn,s),m(Vs,e,s),l(e,Gn,s),m(zs,e,s),l(e,Vn,s),l(e,qs,s),l(e,zn,s),m(xs,e,s),l(e,qn,s),m(_s,e,s),l(e,xn,s),l(e,Ys,s),l(e,_n,s),m(As,e,s),l(e,Yn,s),m(Fs,e,s),l(e,An,s),l(e,Hs,s),l(e,Fn,s),l(e,Ns,s),l(e,Hn,s),m(Es,e,s),l(e,Nn,s),l(e,Qs,s),l(e,En,s),m(C,e,s),l(e,Qn,s),m(Ss,e,s),l(e,Sn,s),l(e,Ls,s),l(e,Ln,s),m(Ds,e,s),l(e,Dn,s),l(e,Ps,s),l(e,Pn,s),l(e,Ks,s),l(e,Kn,s),m(Z,e,s),l(e,On,s),l(e,Os,s),l(e,ea,s),l(e,et,s),l(e,sa,s),l(e,st,s),l(e,ta,s),m(tt,e,s),l(e,la,s),l(e,lt,s),l(e,na,s),l(e,nt,s),l(e,aa,s),m(at,e,s),l(e,ra,s),m(I,e,s),l(e,ia,s),l(e,rt,s),l(e,pa,s),m(it,e,s),l(e,ua,s),m(pt,e,s),l(e,oa,s),l(e,ut,s),l(e,ma,s),l(e,ot,s),l(e,da,s),m(k,e,s),l(e,ca,s),m(mt,e,s),l(e,Ma,s),l(e,dt,s),l(e,ya,s),l(e,ct,s),l(e,Ja,s),l(e,Mt,s),l(e,ba,s),m(yt,e,s),l(e,ja,s),l(e,Jt,s),l(e,fa,s),l(e,bt,s),l(e,Ta,s),l(e,jt,s),l(e,wa,s),l(e,ft,s),l(e,ha,s),m(Tt,e,s),l(e,Ua,s),l(e,Ut,s),va=!0},p(e,[s]){const Kr={};s&1&&(Kr.fw=e[0]),h.$set(Kr);const Or={};s&2&&(Or.$$scope={dirty:s,ctx:e}),U.$set(Or);const ei={};s&2&&(ei.$$scope={dirty:s,ctx:e}),v.$set(ei);const si={};s&2&&(si.$$scope={dirty:s,ctx:e}),$.$set(si);const ti={};s&2&&(ti.$$scope={dirty:s,ctx:e}),C.$set(ti);const li={};s&2&&(li.$$scope={dirty:s,ctx:e}),Z.$set(li);const ni={};s&2&&(ni.$$scope={dirty:s,ctx:e}),I.$set(ni);const ai={};s&2&&(ai.$$scope={dirty:s,ctx:e}),k.$set(ai)},i(e){va||(d(h.$$.fragment,e),d(g.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(Y.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(we.$$.fragment,e),d(he.$$.fragment,e),d(U.$$.fragment,e),d(Ze.$$.fragment,e),d(ke.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(Re.$$.fragment,e),d(ze.$$.fragment,e),d(xe.$$.fragment,e),d(Ae.$$.fragment,e),d(He.$$.fragment,e),d(Qe.$$.fragment,e),d(Le.$$.fragment,e),d(es.$$.fragment,e),d(ss.$$.fragment,e),d(ls.$$.fragment,e),d(ns.$$.fragment,e),d(rs.$$.fragment,e),d(ps.$$.fragment,e),d(os.$$.fragment,e),d(ds.$$.fragment,e),d(ys.$$.fragment,e),d(js.$$.fragment,e),d(Ts.$$.fragment,e),d(v.$$.fragment,e),d(Us.$$.fragment,e),d($s.$$.fragment,e),d(Cs.$$.fragment,e),d(ks.$$.fragment,e),d(gs.$$.fragment,e),d($.$$.fragment,e),d(Xs.$$.fragment,e),d(Rs.$$.fragment,e),d(Vs.$$.fragment,e),d(zs.$$.fragment,e),d(xs.$$.fragment,e),d(_s.$$.fragment,e),d(As.$$.fragment,e),d(Fs.$$.fragment,e),d(Es.$$.fragment,e),d(C.$$.fragment,e),d(Ss.$$.fragment,e),d(Ds.$$.fragment,e),d(Z.$$.fragment,e),d(tt.$$.fragment,e),d(at.$$.fragment,e),d(I.$$.fragment,e),d(it.$$.fragment,e),d(pt.$$.fragment,e),d(k.$$.fragment,e),d(mt.$$.fragment,e),d(yt.$$.fragment,e),d(Tt.$$.fragment,e),va=!0)},o(e){c(h.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(A.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(we.$$.fragment,e),c(he.$$.fragment,e),c(U.$$.fragment,e),c(Ze.$$.fragment,e),c(ke.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Re.$$.fragment,e),c(ze.$$.fragment,e),c(xe.$$.fragment,e),c(Ae.$$.fragment,e),c(He.$$.fragment,e),c(Qe.$$.fragment,e),c(Le.$$.fragment,e),c(es.$$.fragment,e),c(ss.$$.fragment,e),c(ls.$$.fragment,e),c(ns.$$.fragment,e),c(rs.$$.fragment,e),c(ps.$$.fragment,e),c(os.$$.fragment,e),c(ds.$$.fragment,e),c(ys.$$.fragment,e),c(js.$$.fragment,e),c(Ts.$$.fragment,e),c(v.$$.fragment,e),c(Us.$$.fragment,e),c($s.$$.fragment,e),c(Cs.$$.fragment,e),c(ks.$$.fragment,e),c(gs.$$.fragment,e),c($.$$.fragment,e),c(Xs.$$.fragment,e),c(Rs.$$.fragment,e),c(Vs.$$.fragment,e),c(zs.$$.fragment,e),c(xs.$$.fragment,e),c(_s.$$.fragment,e),c(As.$$.fragment,e),c(Fs.$$.fragment,e),c(Es.$$.fragment,e),c(C.$$.fragment,e),c(Ss.$$.fragment,e),c(Ds.$$.fragment,e),c(Z.$$.fragment,e),c(tt.$$.fragment,e),c(at.$$.fragment,e),c(I.$$.fragment,e),c(it.$$.fragment,e),c(pt.$$.fragment,e),c(k.$$.fragment,e),c(mt.$$.fragment,e),c(yt.$$.fragment,e),c(Tt.$$.fragment,e),va=!1},d(e){e&&(t(j),t(b),t(f),t(vt),t($t),t(Ct),t(Zt),t(W),t(It),t(kt),t(gt),t(V),t(Bt),t(z),t(Xt),t(q),t(Wt),t(Rt),t(_),t(Gt),t(Vt),t(zt),t(F),t(qt),t(H),t(xt),t(_t),t(Yt),t(Q),t(At),t(S),t(Ft),t(Ht),t(D),t(Nt),t(Et),t(K),t(Qt),t(St),t(ee),t(Lt),t(se),t(Dt),t(Pt),t(Kt),t(ne),t(Ot),t(el),t(sl),t(ie),t(tl),t(ll),t(nl),t(oe),t(al),t(me),t(rl),t(il),t(pl),t(Me),t(ul),t(ol),t(ml),t(be),t(dl),t(cl),t(Ml),t(Te),t(yl),t(Jl),t(bl),t(Ue),t(jl),t(ve),t(fl),t(Tl),t($e),t(wl),t(Ce),t(hl),t(Ul),t(Ie),t(vl),t($l),t(ge),t(Cl),t(Zl),t(Xe),t(Il),t(kl),t(gl),t(Ge),t(Bl),t(Ve),t(Xl),t(Wl),t(qe),t(Rl),t(Gl),t(_e),t(Vl),t(Ye),t(zl),t(ql),t(Fe),t(xl),t(_l),t(Ne),t(Yl),t(Ee),t(Al),t(Fl),t(Se),t(Hl),t(Nl),t(De),t(El),t(Pe),t(Ql),t(Ke),t(Sl),t(Oe),t(Ll),t(Dl),t(Pl),t(ts),t(Kl),t(Ol),t(en),t(as),t(sn),t(tn),t(is),t(ln),t(nn),t(us),t(an),t(rn),t(ms),t(pn),t(un),t(cs),t(on),t(Ms),t(mn),t(dn),t(Js),t(cn),t(bs),t(Mn),t(yn),t(fs),t(Jn),t(bn),t(ws),t(jn),t(hs),t(fn),t(Tn),t(wn),t(vs),t(hn),t(Un),t(vn),t(Zs),t($n),t(Is),t(Cn),t(Zn),t(In),t(kn),t(Bs),t(gn),t(Bn),t(Ws),t(Xn),t(Wn),t(Gs),t(Rn),t(Gn),t(Vn),t(qs),t(zn),t(qn),t(xn),t(Ys),t(_n),t(Yn),t(An),t(Hs),t(Fn),t(Ns),t(Hn),t(Nn),t(Qs),t(En),t(Qn),t(Sn),t(Ls),t(Ln),t(Dn),t(Ps),t(Pn),t(Ks),t(Kn),t(On),t(Os),t(ea),t(et),t(sa),t(st),t(ta),t(la),t(lt),t(na),t(nt),t(aa),t(ra),t(ia),t(rt),t(pa),t(ua),t(oa),t(ut),t(ma),t(ot),t(da),t(ca),t(Ma),t(dt),t(ya),t(ct),t(Ja),t(Mt),t(ba),t(ja),t(Jt),t(fa),t(bt),t(Ta),t(jt),t(wa),t(ft),t(ha),t(Ua),t(Ut)),t(y),M(h,e),M(g,e),M(B,e),M(X,e),M(R,e),M(G,e),M(x,e),M(Y,e),M(A,e),M(N,e),M(E,e),M(L,e),M(P,e),M(O,e),M(te,e),M(le,e),M(ae,e),M(re,e),M(pe,e),M(ue,e),M(de,e),M(ce,e),M(ye,e),M(Je,e),M(je,e),M(fe,e),M(we,e),M(he,e),M(U,e),M(Ze,e),M(ke,e),M(Be,e),M(We,e),M(Re,e),M(ze,e),M(xe,e),M(Ae,e),M(He,e),M(Qe,e),M(Le,e),M(es,e),M(ss,e),M(ls,e),M(ns,e),M(rs,e),M(ps,e),M(os,e),M(ds,e),M(ys,e),M(js,e),M(Ts,e),M(v,e),M(Us,e),M($s,e),M(Cs,e),M(ks,e),M(gs,e),M($,e),M(Xs,e),M(Rs,e),M(Vs,e),M(zs,e),M(xs,e),M(_s,e),M(As,e),M(Fs,e),M(Es,e),M(C,e),M(Ss,e),M(Ds,e),M(Z,e),M(tt,e),M(at,e),M(I,e),M(it,e),M(pt,e),M(k,e),M(mt,e),M(yt,e),M(Tt,e)}}}const Zi='{"title":"Débogage du pipeline d’entraînement","local":"débogage-du-pipeline-dentraînement","sections":[{"title":"Déboguer le pipeline d’entraînement","local":"déboguer-le-pipeline-dentraînement","sections":[{"title":"Vérifiez vos données","local":"vérifiez-vos-données","sections":[],"depth":3},{"title":"Des jeux de données aux chargeurs de données","local":"des-jeux-de-données-aux-chargeurs-de-données","sections":[],"depth":3},{"title":"Passage par le modèle","local":"passage-par-le-modèle","sections":[],"depth":3},{"title":"Exécution d’une étape d’optimisation","local":"exécution-dune-étape-doptimisation","sections":[],"depth":3},{"title":"Gérer les erreurs <i> CUDA out of memory </i>","local":"gérer-les-erreurs-i-cuda-out-of-memory-i","sections":[],"depth":3},{"title":"Évaluation du modèle","local":"évaluation-du-modèle","sections":[],"depth":3}],"depth":2},{"title":"Déboguer les erreurs silencieuses pendant l’entraînement","local":"déboguer-les-erreurs-silencieuses-pendant-lentraînement","sections":[{"title":"Vérifiez vos données (encore !)","local":"vérifiez-vos-données-encore-","sections":[],"depth":3},{"title":"Surentraînement du modèle sur un seul batch","local":"surentraînement-du-modèle-sur-un-seul-batch","sections":[],"depth":3},{"title":"Ne réglez rien tant que vous n’avez pas une première ligne de base","local":"ne-réglez-rien-tant-que-vous-navez-pas-une-première-ligne-de-base","sections":[],"depth":3},{"title":"Demander de l’aide","local":"demander-de-laide","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ii(T,y,j){let b="pt";return ui(()=>{const f=new URLSearchParams(window.location.search);j(0,b=f.get("fw")||"pt")}),[b]}class zi extends oi{constructor(y){super(),mi(this,y,Ii,Ci,pi,{})}}export{zi as component};
