# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Ce chapitre a couvert un grand nombre de notions ! Ne vous inquiétez pas si vous n'avez pas compris tous les détails, les chapitres suivants vous aideront à comprendre comment les choses fonctionnent concrètement.

Mais avant d'aller plus loin, prenons un instant pour voir ce que vous avez appris dans ce chapitre !


### 1. Explorez le *Hub* et cherchez le modèle `roberta-large-mnli`. Quelle tâche accomplit-il ?


<Question
	choices={[
		{
			text: "Résumé de texte",
			explain: "Regardez à nouveau sur la <a href=\"https://huggingface.co/roberta-large-mnli\">page roberta-large-mnli</a>."
		},
		{
			text: "Classification de texte",
			explain: "Pour être plus précis, il classifie si deux phrases sont logiquement liées entre elles parmis trois possibilités (contradiction, neutre, lien). Il s'agit d'une tâche aussi appelée <em>inference de langage naturel</em>.",
			correct: true
		},
		{
			text: "Génération de texte",
			explain: "Regardez à nouveau sur la <a href=\"https://huggingface.co/roberta-large-mnli\">page roberta-large-mnli</a>."
		}
	]}
/>

### 2. Que renvoie le code suivant ?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner(
    "My name is Sylvain and I work at Hugging Face in Brooklyn."
)  # Je m'appelle Sylvain et je travaille à Hugging Face à Brooklyn.
```

<Question
	choices={[
		{
			text: "Il renvoie les scores de classification pour cette phrase, avec les labels \"positive\" ou \"negative\".",
			explain: "Cela correspondrait au pipeline <code>d'analyse de sentiment</code> (<i>sentiment-analysis</i> dans la documentation d'Hugging-Face)."
		},
		{
			text: "Il renvoie un texte généré qui complète cette phrase.",
			explain: "Cela correspondrait au pipeline de <code>génération de texte</code> (<i>text-generation</i> dans la documentation d'Hugging-Face)."
		},
		{
			text: "Il renvoie les entités nommées dans cette phrase, telles que les personnes, les organisations ou lieux.",
			explain: "De plus, avec <code>grouped_entities=True</code>, cela regroupe les mots appartenant à la même entité, comme par exemple \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. Que remplace « ... » dans ce code ?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you. # Ce &#60;mask> vous attend.",
			explain: "Regardez la description du modèle <code>bert-base-cased</code> et essayez de trouver votre erreur."
		},
		{
			text: "This [MASK] has been waiting for you. # Ce [MASK] vous attend.",
			explain: "Le modèle utilise [MASK] comme mot-masque.",
			correct: true
		},
		{
			text: "This man has been waiting for you. # Cet homme vous attend.",
			explain: "Ce pipeline permet de remplacer les mot manquants donc il a besoin d'un mot-masque."
		}
	]}
/>

### 4. Pourquoi ce code ne fonctionne-t-il pas ?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier(
    "This is a course about the Transformers library"
)  # C'est un cours sur la bibliothèque Transformers
```

<Question
	choices={[
		{
			text: "Ce pipeline nécessite que des étiquettes soient données pour classifier ce texte.",
			explain: "Le code doit inclure <code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "Ce pipeline nécessite que des phrases soient données, pas juste une phrase.",
			explain: "Bien que ce pipeline puisse prendre une liste de phrases à traiter (comme tous les autres pipelines)."
		},
		{
			text: "La bibliothèque 🤗 <i>Transformers</i> est cassée, comme d'habitude.",
			explain: "Nous n'avons aucun commentaire pour cette réponse !",
		},
		{
			text: "Ce pipeline nécessite des phrases plus longues, celle-ci est trop courte.",
			explain: "Notez que si un texte est très long, il est tronqué par le pipeline."
		}
	]}
/>

### 5. Que signifie « apprentissage par transfert » ?

<Question
	choices={[
		{
			text: "Transférer les connaissances d'un modèle pré-entraîné vers un nouveau modèle en entraînant ce second modèle sur le même jeu de données.",
			explain: "Non, cela donnerait deux versions du même modèle."
		},
		{
			text: "Transférer les connaissances d'un modèle pré-entraîné vers un nouveau modèle en initialisant ce second modèle avec les poids du premier.",
			explain: "Quand le second modèle est entraîné sur une nouvelle tâche, il transfère les connaissances du premier modèle.",
			correct: true
		},
		{
			text: "Transférer les connaissances d'un modèle pré-entraîné vers un nouveau modèle en construisant le second modèle avec la même architecture que le premier.",
			explain: "L'architecture correspond uniquement à la structure du modèle, pas à ses connaissances. Il n'y a donc pas de connaissances à transférer dans ce cas.",
		}
	]}
/>

### 6. Vrai ou faux ? Un modèle de langage n'a généralement pas besoin d'étiquettes pour son pré-entraînement.


<Question
	choices={[
		{
			text: "Vrai",
			explain: "Le pré-entraînement est <em>autosupervisé</em>, ce qui signifie que les étiquettes sont créées automatiquement à partir des données d'entrée (comme prédire le mot suivant ou remplacer des mots masqués).",
			correct: true
		},
		{
			text: "Faux",
			explain: "Ce n'est pas la bonne réponse."
		}
	]}
/>

### 7. Sélectionnez la phrase qui décrit le mieux les termes « modèle », « architecture » et « poids ».

<Question
	choices={[
		{
			text: "Si un modèle est un bâtiment, son architecture est le plan de construction et les poids représentent les personnes qui vivent dedans.",
			explain: "Si on suit cette métaphore, les poids seraient plutôt les briques et les matériaux utilisés pour construire le bâtiment."
		},
		{
			text: "Une architecture est une carte pour construire un modèle et les poids sont les villes représentées sur la carte.",
			explain: "Le problème avec cette métaphore est que la carte représente une réalité existante (il n'y a qu'une seule ville nommée Paris en France). Pour une architecture donnée, plusieurs poids sont possibles."
		},
		{
			text: "Une architecture est une succession de fonctions mathématiques permettant de construire un modèle et les poids sont les paramètres de ces fonctions.",
			explain: "Le même ensemble de fonctions mathématiques peut être utilisé pour construire plusieurs modèles avec différents paramètres (poids).",
			correct: true
		}
	]}
/>


### 8. Parmi ces types de modèles, quel est le plus approprié pour générer du texte à partir d'une instruction (*prompt*) ?

<Question
	choices={[
		{
			text: "Un modèle basé sur l'encodeur",
			explain: "Un modèle basé sur l'encodeur génère une représentation de la phrase entière qui est plus adaptée à des tâches de classification."
		},
		{
			text: "Un modèle basé sur le décodeur",
			explain: "Les modèles basés sur le décodeur sont bien pour générer du texte à partir d'une instruction.",
			correct: true
		},
		{
			text: "Un modèle de séquence-à-séquence",
			explain: "Les modèles de séquence-à-séquence sont davantage adaptés aux tâches qui nécessitent de générer des phrases à partir d'un texte donné en entrée, pas un texte généré à partir d'une instruction."
		}
	]}
/>

### 9. Parmi ces types de modèles, quel est le plus approprié pour le résumé de texte ?

<Question
	choices={[
		{
			text: "Un modèle basé sur l'encodeur",
			explain: "Un modèle basé sur l'encodeur génère une représentation de la phrase entière qui est plus adaptée à des tâches de classification.",
		},
		{
			text: "Un modèle basé sur le décodeur",
			explain: "Les modèles basés sur le décodeur sont bien pour générer du texte (comme les résumés) mais ils n'ont pas la capacité d'exploiter un contexte comme un texte entier pour en faire un résumé.",
		},
		{
			text: "Un modèle de séquence-à-séquence",
			explain: "Les modèles de séquence-à-séquence sont parfaitement adaptés à une tâche de résumé.",
			correct: true
		}
	]}
/>

### 10. Quel type de modèle utiliseriez-vous pour classifier des entrées de texte en fonction de certains labels ?

<Question
	choices={[
		{
			text: "Un modèle basé sur l'encodeur",
			explain: "Un modèle basé sur un encodeur génère une représentation de la phrase entière et est donc parfaitement adapté à des tâches de classification.",
			correct: true
		},
		{
			text: "Un modèle basé sur le décodeur",
			explain: "Les modèles basés sur le décodeur sont bons pour générer des textes et non pour extraire une étiquette d'une phrase.",
		},
		{
			text: "Un modèle de séquence-à-séquence",
			explain: "Les modèles de séquence-à-séquence sont davantage adaptés pour des tâches qui nécessitent de générer des phrases à partir d'un texte donné en entrée, non pour extraire une étiquette à partir d'une phrase.",
		}
	]}
/>

### 11. De quelle source possible peut être le biais observé dans un modèle ?

<Question
	choices={[
		{
			text: "Le modèle est une version <i>finetunée</i> d'un modèle pré-entraîné et il a conservé ses biais.",
			explain: "Avec l'apprentissage par transfert, les biais du modèle pré-entraîné perdurent dans le modèle <i>finetuné</i>.",
			correct: true
		},
		{
			text: "Le modèle a été entraîné sur des données qui sont biaisées.",
			explain: "Ceci représente la source de biais la plus évidente mais n'est pas la seule possible.",
			correct: true
		},
		{
			text: "La métrique optimisée lors de l'entraînement du modèle est biaisée.",
			explain: "Une source moins évidente est la façon dont le modèle est entraîné. Votre modèle va de façon aveugle optimiser la métrique que vous avez sélectionnée, sans prendre aucun recul.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter1/10.mdx" />