# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

Testons ce que vous avez appris dans ce chapitre !

### 1. Laquelle des tâches suivantes peut être considérée comme un problème de classification de <i>tokens</i> ?

<Question
	choices={[
		{
			text: "Trouvez les composants grammaticaux d'une phrase.",
			explain: "Nous pouvons alors étiqueter chaque mot comme étant un nom, un verbe, etc.",
			correct: true
		},
		{
			text: "Trouvez si une phrase est grammaticalement correcte ou non.",
			explain: "C'est un problème de classification des séquences."
		},
		{
			text: "Trouvez les personnes mentionnées dans une phrase.",
			explain: "Nous pouvons étiqueter chaque mot comme personne ou non personne.",
            correct: true
		},
        {
			text: "Trouvez le groupe de mots dans une phrase qui répond à une question.",
			explain: "C'est un problème de réponse aux questions."
		}
	]}
/>

### 2. Quelle partie du prétraitement pour la classification de <i>tokens</i> diffère des autres pipelines de prétraitement ?

<Question
	choices={[
		{
			text: "Il n'y a rien à faire, les textes sont déjà tokenisés.",
			explain: "Les textes sont en effet donnés sous la forme de mots séparés mais nous devons encore appliquer le modèle de tokenisation en sous-mots."
		},
		{
			text: "Les textes sont donnés sous forme de mots, il suffit donc d'appliquer la tokénisation en sous-mots.",
			explain: "C'est différent du prétraitement habituel, où nous devons appliquer le pipeline complet de tokénisation. Pouvez-vous penser à une autre différence ?",
			correct: true
		},
		{
			text: "Nous utilisons <code>-100</code> pour étiqueter les <i>tokens</i> spéciaux.",
			explain: "Ce n'est pas spécifique à la classification de <i>tokens</i>. Nous utilisons toujours <code>-100</code> comme étiquette pour les <i>tokens</i> que nous voulons ignorer dans la perte."
		},
		{
			text: "Nous devons nous assurer que les étiquettes sont tronquées ou rembourrées à la même taille que les entrées, lorsque nous appliquons la troncature/le <i>padding</i>.",
			explain: "En effet mais ce n'est pas la seule différence.",
			correct: true
		}
	]}
/>

### 3. Quel problème se pose lorsque nous tokenisons les mots dans un problème de classification de <i>tokens</i> et que nous voulons étiqueter les <i>tokens</i> ?

<Question
	choices={[
		{
			text: "Le <i>tokenizer</i> ajoute des <i>tokens</i> spéciaux et nous n'avons pas d'étiquettes pour eux.",
			explain: "Nous les étiquetons par <code>-100</code> ils sont donc ignorés dans la perte."
		},
		{
			text: "Chaque mot peut produire plusieurs <i>tokens</i>, ce qui fait que nous nous retrouvons avec plus de <i>tokens</i> que d'étiquettes.",
			explain: "C'est le problème principal et nous devons aligner les étiquettes originales avec les <i>tokens</i>.",
			correct: true
		},
		{
			text: "Les <i>tokens</i> ajoutés n'ont pas d'étiquettes, il n'y a donc pas de problème.",
			explain: "Nous avons besoin d'autant d'étiquettes que de <i>tokens</i>, sinon nos modèles se tromperont."
		}
	]}
/>

### 4. Que signifie « adaptation au domaine » ?

<Question
	choices={[
		{
			text: "C'est lorsque nous exécutons un modèle sur un jeu de données et que nous obtenons les prédictions pour chaque échantillon de ce jeu de données.",
			explain: "C'est juste une inférence."
		},
		{
			text: "C'est quand on entraîne un modèle sur un jeu de données.",
			explain: "Il s'agit d'entraîner un modèle. Il n'y a pas d'adaptation ici."
		},
		{
			text: "C'est lorsque nous <i>finetunons</i> un modèle pré-entraîné sur un nouveau jeu de données et qu'il donne des prédictions qui sont plus adaptées à ce nouveau jeu de données.",
			explain: "Le modèle a adapté ses connaissances au nouveau jeu de données.",
            correct: true
		},
        {
			text: "C'est lorsque nous ajoutons des échantillons mal classés à un jeu de données pour rendre notre modèle plus robuste.",
			explain: "C'est certainement quelque chose que vous devriez faire si vous réentraînez votre modèle régulièrement, mais ce n'est pas une adaptation au domaine."
		}
	]}
/>

### 5. Quelles sont les étiquettes dans un problème de modélisation du langage masqué ?

<Question
	choices={[
		{
			text: "Certains des <i>tokens</i> de la phrase d'entrée sont masqués de manière aléatoire et les étiquettes sont les <i>tokens</i> d'entrée originaux.",
			explain: "C'est ça !",
            correct: true
		},
		{
			text: "Certains des <i>tokens</i> de la phrase d'entrée sont masqués de manière aléatoire et les étiquettes sont les <i>tokens</i> d'entrée originaux, décalés vers la gauche.",
			explain: "Non, le déplacement des étiquettes vers la gauche correspond à la prédiction du mot suivant, ce qui est une modélisation causale du langage."
		},
		{
			text: "Certains des <i>tokens</i> de la phrase d'entrée sont masqués de manière aléatoire et l'étiquette indique si la phrase est positive ou négative.",
			explain: "Il s'agit d'un problème de classification de séquences avec une certaine augmentation de données et non d'une modélisation du langage masqué."
		},
        {
			text: "Certains des <i>tokens</i> des deux phrases d'entrée sont masqués de manière aléatoire et l'étiquette indique si les deux phrases sont similaires ou non.",
			explain: "Il s'agit d'un problème de classification de séquences avec une certaine augmentation de données et non d'une modélisation du langage masqué."
		}
	]}
/>

### 6. Laquelle de ces tâches peut être considérée comme un problème de séquence à séquence ?

<Question
	choices={[
		{
			text: "Rédiger de courtes critiques de longs documents.",
			explain: "C'est un problème de résumé. Essayez une autre réponse !",
            correct: true
		},
		{
			text: "Répondre à des questions sur un document.",
			explain: "Cela peut être formulé comme un problème de séquence à séquence. Ce n'est cependant pas la seule bonne réponse.",
            correct: true
		},
		{
			text: "Traduire un texte en chinois en anglais.",
			explain: "C'est définitivement un problème de séquence à séquence. Pouvez-vous en trouver un autre ?",
            correct: true
		},
        {
			text: "Corriger les messages envoyés par mon neveu/ami pour qu'ils soient en anglais correct.",
			explain: "Il s'agit d'un problème de traduction donc d'une tâche de séquence à séquence. Mais ce n'est pas la seule bonne réponse !",
			correct: true
		}
	]}
/>

### 7. Quelle est la bonne façon de prétraiter les données pour un problème de séquence à séquence ?

<Question
	choices={[
		{
			text: "Les entrées et les cibles doivent être envoyées ensemble au <i>tokenizer</i> avec les éléments suivants <code>inputs=...</code> et <code>targets=...</code>.",
			explain: "Nous pourrions ajouter cette API à l'avenir mais ce n'est pas possible pour le moment."
		},
		{
			text: "Les entrées et les cibles doivent être prétraitées, en deux appels séparés au <i>tokenizer</i>.",
			explain: "C'est vrai, mais incomplet. Il y a quelque chose que vous devez faire pour vous assurer que le <i>tokenizer</i> traite les deux correctement."
		},
		{
			text: "Comme d'habitude, nous devons simplement tokeniser les entrées.",
			explain: "Pas dans un problème de classification de séquences. Les cibles sont aussi des textes que nous devons convertir en chiffres !"
		},
        {
			text: "Les entrées doivent être envoyées au <i>tokenizer</i>, et les cibles aussi, mais sous un gestionnaire de contexte spécial.",
			explain: "C'est exact, le <i>tokenizer</i> doit être mis en mode cible par ce gestionnaire de contexte.",
			correct: true
		}
	]}
/>

{#if fw === 'pt'}

### 8. Pourquoi existe-t-il une sous-classe spécifique de <code>Trainer</code> pour les problèmes de séquence à séquence ?

<Question
	choices={[
		{
			text: "Parce que les problèmes de séquence-à-séquence utilisent une perte personnalisée, pour ignorer les étiquettes définies à <code>-100</code>.",
			explain: "Ce n'est pas du tout une perte personnalisée mais la façon dont la perte est toujours calculée."
		},
		{
			text: "Parce que les problèmes de séquence à séquence nécessitent une boucle d'évaluation spéciale.",
			explain: "Les prédictions des modèles de séquence à séquence sont souvent exécutées en utilisant la méthode <code>generate()</code>.",
			correct: true
		},
		{
			text: "Parce que les cibles sont des textes dans des problèmes de séquence à séquence.",
			explain: "<code>Trainer</code> ne se soucie pas vraiment de cela puisqu'elles ont été prétraités auparavant."
		},
        {
			text: "Parce que nous utilisons deux modèles dans les problèmes de séquence à séquence.",
			explain: "Nous utilisons en quelque sorte deux modèles, un encodeur et un décodeur, mais ils sont regroupés dans un seul modèle."
		}
	]}
/>

{:else}

### 9. Pourquoi est-il souvent inutile de spécifier une perte quand on appelle <code>compile()</code> sur un <i>transformer</i> ?

<Question
	choices={[
		{
			text: "Parce que les <i>tranformers</i> sont entraînés avec un apprentissage autosupervisé.",
			explain: "Pas tout à fait. Même l'apprentissage autosupervisé a besoin d'une fonction de perte !"
		},
		{
			text: "Parce que la sortie de perte interne du modèle est utilisée par défaut.",
			explain: " ",
			correct: true
		},
		{
			text: "Parce que nous calculons les mesures après l'entraînement au lieu de le faire.",
			explain: "Nous le faisons souvent mais cela n'explique pas d'où vient la valeur de perte que nous optimisons dans l'entraînement."
		},
        {
			text: "Parce que la perte est spécifiée dans <code>model.fit()</code>.",
			explain: "La fonction de perte est toujours fixée une fois que vous exécutez <code>model.compile()</code> et ne peut pas être modifiée dans <code>model.fit()</code>."
		}
	]}
/>

{/if}

### 10. Quand devez-vous pré-entraîner un nouveau modèle ?

<Question
	choices={[
		{
			text: "Lorsqu'il n'y a pas de modèle pré-entraîné disponible pour votre langue spécifique.",
			explain: " ",
			correct: true
		},
		{
			text: "Lorsque vous disposez d'un grand nombre de données, même s'il existe un modèle pré-entraîné qui pourrait fonctionner sur ces données.",
			explain: "Dans ce cas, vous devriez probablement utiliser le modèle pré-entraîné et le <i>finetuner</i> sur vos données afin d'éviter d'énormes coûts de calcul."
		},
		{
			text: "Lorsque vous avez des doutes sur le biais du modèle pré-entraîné que vous utilisez.",
			explain: "C'est vrai mais vous devez vous assurer que les données que vous utiliserez pour l'entraînement sont vraiment meilleures.",
			correct: true
		},
        {
			text: "Lorsque les modèles pré-entraînés disponibles ne sont tout simplement pas assez bons.",
			explain: "Vous êtes sûr d'avoir bien débogué votre entraînement ?"
		}
	]}
/>

### 11. Pourquoi est-il facile de prétraîner un modèle de langage sur des batchs de textes ?

<Question
	choices={[
		{
			text: "Parce qu'il y a beaucoup de textes disponibles sur internet.",
			explain: "Bien que vrai, cela ne répond pas vraiment à la question. Essayez encore !"
		},
		{
			text: "Parce que l'objectif de pré-entraînement ne nécessite pas que les humains étiquettent les données.",
			explain: "La modélisation du langage est un problème autosupervisé.",
			correct: true
		},
		{
			text: "Parce que la bibliothèque 🤗 <i>Transformers</i> ne nécessite que quelques lignes de code pour démarrer l'entraînement.",
			explain: "Bien que vrai, cela ne répond pas vraiment à la question posée. Essayez une autre réponse !"
		}
	]}
/>

### 12. Quels sont les principaux défis lors du prétraitement des données pour une tâche de réponse à des questions ?

<Question
	choices={[
		{
			text: "Vous devez tokeniser les entrées.",
			explain: "Mais est-ce vraiment un défi majeur ?"
		},
		{
			text: "Vous devez faire face à des contextes très longs, qui donnent plusieurs caractéristiques d'entraînement qui peuvent ou non contenir la réponse.",
			explain: "C'est certainement l'un des défis à relever.",
			correct: true
		},
		{
			text: "Vous devez tokeniser les réponses à la question ainsi que les entrées.",
			explain: "Non, à moins que vous ne formuliez votre problème de réponse aux questions comme une tâche de séquence à séquence."
		},
       {
			text: "À partir de l'intervalle de réponse dans le texte, vous devez trouver le token de début et de fin dans l'entrée tokenisée.",
			explain: "C'est une des parties les plus difficiles, oui !",
			correct: true
		}
	]}
/>

### 13. Comment le post-traitement est-il généralement effectué dans les réponses aux questions ?

<Question
	choices={[
		{
			text: "Le modèle vous donne les positions de début et de fin de la réponse, et vous n'avez plus qu'à décoder la plage de <i>tokens</i> correspondant.",
			explain: "Ce pourrait être une façon de faire mais c'est un peu trop simpliste."
		},
		{
			text: "Le modèle vous donne les positions de début et de fin de la réponse pour chaque caractéristique créée par un exemple et il vous suffit de décoder la plage de <i>tokens</i> correspondant dans celui qui a le meilleur score.",
			explain: "C'est proche du post-traitement que nous avons étudié, mais ce n'est pas tout à fait exact."
		},
		{
			text: "Le modèle vous donne les positions de début et de fin de la réponse pour chaque caractéristique créée par un exemple et vous n'avez plus qu'à les faire correspondre à la portée dans le contexte de celui qui a le meilleur score.",
			explain: "C'est ça en résumé !",
			correct: true
		},
        {
			text: "Le modèle génère une réponse et il vous suffit de la décoder.",
			explain: "A moins que vous ne formuliez votre problème de réponse aux questions comme une tâche de séquence à séquence."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter7/9.mdx" />