# Quiz di fine capitolo

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>


In questo capitolo abbiamo parlato di molti argomenti! Non preoccuparti se non hai capito tutto nel dettaglio: i prossimi capitoli ti aiuteranno a capire come molte di queste cose funzionano dietro le quinte.

Prima di procedere, però, verifichiamo cos'hai imparato in questo capitolo!


### 1. Esplora l'Hub e cerca il checkpoint `roberta-large-mnli`. Quale compito svolge?


<Question
	choices={[
		{
			text: "Riassunto testuale",
			explain: "Rivisita il link e prova di nuovo: <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli page</a>."
		},
		{
			text: "Classificazione testuale",
			explain: "Più precisamente, determina se due frasi sono connesse logicamente su tre livelli associati alle etichette 'contradiction', 'neutral' e 'entailment'. Questo compito viene detto anche <em>natural language inference</em>.",
			correct: true
		},
		{
			text: "Generazione testuale",
			explain: "Rivisita il link e prova di nuovo: <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli page</a>."
		}
	]}
/>

### 2. Cosa restituisce il codice seguente?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Restituisce un punteggio associato alla frase, con etichette del tipo \"positive\" o \"negative\".",
			explain: "Sbagliato! Se così fosse, si tratterebbe di una pipeline di tipo <code>sentiment-analysis</code>."
		},
		{
			text: "Genera e restituisce testo che completa la frase di partenza.",
			explain: "Sbagliato! Se così fosse, si tratterebbe di una pipeline di tipo <code>text-generation</code>.",
		},
		{
			text: "Restituisce i termini che rappresentano persone, organizzazioni o luoghi.",
			explain: "Inoltre, grazie a <code>grouped_entities=True</code>, la pipeline è in grado di raggruppare le parole che appartengono alla stessa entità, come \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. Cosa dovrebbe rimpiazzare "..." in questo estratto di codice?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "Questo &#60;mask> aspetta te.",
			explain: "Sbagliato. Controlla la card del modello <code>bert-base-cased</code> e cerca di capire il tuo errore."
		},
		{
			text: "Questo [MASK] aspetta te.",
			explain: "Corretto! Il mask token utilizzato dal modello è [MASK].",
			correct: true
		},
		{
			text: "Questo signore aspetta te.",
			explain: "Sbagliato. Questa pipeline completa parole nascoste, quindi necessita di un mask token nell'input."
		}
	]}
/>

### 4. Perché questo codice non funziona?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "Questa pipeline richiede che le etichette siano fornite per poter classificare il testo.",
			explain: "Esatto! Per essere corretto, il codice deve includere <code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "Questa pipeline richiede diverse frasi, non solo una.",
			explain: "Sbagliato, anche se quando usata correttamente, questa pipeline può tranquillamente processare una lista di frasi (come tutte le altre pipeline)."
		},
		{
			text: "Come al solito, la libreria Transformer di 🤗 non funziona.",
			explain: "Ci rifiutiamo di commentare la tua risposta!"
		},
		{
			text: "Questa pipeline richiede un input più lungo. Quello fornito è troppo corto.",
			explain: "Sbagliato. Sappi che per processare testi molto lunghi, questa pipeline li deve troncare."
		}
	]}
/>

### 5. Cosa significa "transfer learning"?

<Question
	choices={[
		{
			text: "Trasferire la conoscenza di un modello pre-addestrato a un nuovo modello, addestrando quest'ultimo sulla stessa banca dati.",
			explain: "No, in quel caso avremmo a che fare con due versioni dello stesso modello."
		},
		{
			text: "Trasferire la conoscenza di un modello pre-addestrato a un nuovo modello addestrando il secondo con i pesi del primo.",
			explain: "Corretto. Quando il secondo modello viene addestrato ad un nuovo compito, *trasferisce* la conoscenza del primo modello.",
			correct: true
		},
		{
			text: "Trasferire la conoscenza di un modello pre-addestrato a un nuovo modello costruendo il secondo con la stessa architettura del primo.",
			explain: "L'architettuta è semplicemente il modo in cui il modello è costruito. In questo caso, la conoscenza non è né condivisa né trasmessa."
		}
	]}
/>

### 6. Vero o falso? Solitamente un modello linguistico non richiede etichette in fase di pre-addestramento.


<Question
	choices={[
		{
			text: "Vero",
			explain: "Solitamente, il pre-addestramento è <em>self-supervised</em>, il che significa che le etichette sono create direttamente a partire dall'input (come quando una pipeline predice la parola seguente o indovina parole nascoste).",
			correct: true
		},
		{
			text: "Falso",
			explain: "La risposta non è corretta."
		}
	]}
/>

### 7. Seleziona la frase che meglio descrive i termini "modello," "architettura," e "pesi."

<Question
	choices={[
		{
			text: "Se un modello fosse un palazzo, l'architettura ne sarebbe il progetto e i pesi le persone che ci vivono.",
			explain: "In un caso del genere, i pesi sarebbero piuttosto i mattoni e i materiali utilizzati per costruire il palazzo."
		},
		{
			text: "L'architettura è una cartina per costruire un dato modello, i cui pesi sono le città rappresentate sulla mappa.",
			explain: "Il problema di questa metafora è che, solitamente, una cartina rappresenta un'unica realtà (c'è una sola città in Francia di nome Parigi). Per una data architettura, possono esistere numerosi pesi."
		},
		{
			text: "Un'architettura è una successione di funzioni matematiche usate per costruire un modello; i suoi pesi sono i parametri delle funzioni.",
			explain: "Lo stesso insieme di funzioni matematiche (architettura) può essere utilizzato per costruire modelli diversi utilizzando parametri diversi (pesi).",
			correct: true
		}
	]}
/>


### 8. Quale dei seguenti modelli utilizzeresti per completare dei prompt con testo generato?

<Question
	choices={[
		{
			text: "Un modello encoder",
			explain: "Un modello encoder genera una rappresentazione della frase intera che è più adatta a compiti come la classificazione."
		},
		{
			text: "Un modello decoder",
			explain: "I modelli decoder sono perfetti per generare testo a partire da un prompt.",
			correct: true
		},
		{
			text: "Un modello sequence-to-sequence",
			explain: "I modelli sequence-to-sequence sono più adatti a compiti di generazione di frasi a partire da frasi input, non da un prompt."
		}
	]}
/>

### 9. Quale dei seguenti modelli utilizzeresti per riassumere testi?

<Question
	choices={[
		{
			text: "Un modello encoder",
			explain: "Un modello encoder genera una rappresentazione della frase intera che è più adatta a compiti come la classificazione."
		},
		{
			text: "Un modello decoder",
			explain: "I modelli decoder sono capaci di generare un testo di output (come un riassunto), ma non sono in grado di estrarre conoscenze da un contesto, come ad esempio da un testo da riassumere."
		},
		{
			text: "Un modello sequence-to-sequence",
			explain: "I modelli sequence-to-sequence sono perfetti per compiti di riassunto.",
			correct: true
		}
	]}
/>

### 10. Quale dei seguenti modelli utilizzeresti per classificare input testuali sulla base di determinate etichette?

<Question
	choices={[
		{
			text: "Un modello encoder",
			explain: "Un modello encoder genera una rappresentazione della frase intera che è più adatta a compiti come la classificazione.",
			correct: true
		},
		{
			text: "Un modello decoder",
			explain: "I modelli decoder sono capaci di generare un testo di output, non di estrarre etichette da frasi."
		},
		{
			text: "Un modello sequence-to-sequence",
			explain: "I modelli sequence-to-sequence sono più adatti a compiti in cui si genera testo sulla base di una frase input, non di un'etichetta.",
		}
	]}
/>

### 11. Qual è la possibile origine di un bias osservato in un modello?

<Question
	choices={[
		{
			text: "Il modello è una versione affinata di un modello pre-addestrato, dal quale eredita il bias.",
			explain: "Nel Transfer Learning, i bias di un modello pre-addestrato si osservano anche nel modello affinato.",
			correct: true
		},
		{
			text: "I dati sui quali il modello è stato addetsrato contengono errori.",
			explain: "Questa è la fonte di errori più comune, ma non la sola.",
			correct: true
		},
		{
			text: "La misura ottimizzata dal modello è errata.",
			explain: "Il modo in cui il modello viene addestrato è una causa di errori meno ovvia. Un modello ottimizza ciecamente qualsiasi metrica tu scelga, senza ripensamenti.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter1/10.mdx" />