# イントロダクション

Hugging Faceコースへようこそ！このページでは、実行環境のセットアップ方法についてご案内します。もし、このコースを始めたばかりでしたら、ますは[第１章](/course/chapter1)を見てからここに戻ってきて、コードをご自身で試せるように環境をセットアップすることをお勧めします。

このコースで使用するライブラリは全てPythonパッケージとして提供されているため、ここではPython環境の構築と必要なライブラリのインストール方法について説明します。

実行環境をセットアップする方法として、Colabノートブックを使用する方法とPythonの仮想環境を使用する方法の2つを取り上げます。ご自身で好みの方法をご自由にお選びください。初心者の方には、Colabノートブックを使う方法から始めることを強くお勧めします。

なお、Windowsシステムは取り扱わない点についてご了承ください。もしWindowsで実行される場合は、Colabノートブックを使用することをお勧めします。LinuxやmacOSで実行される場合は、ここで説明するどちらの方法をお選びいただいても構いません。

このコースの大半の場面では、Hugging Faceアカウントをお持ちであることが前提となっています。お持ちでない場合、今すぐ作成することをお勧めします: [アカウント作成](https://huggingface.co/join).

## Google Colabノートブックを使用する場合

Colabノートブックを使用してセットアップを行うのが、一番シンプルな方法です。ブラウザでノートブックを起動し、すぐにコーディングを始めることができます！ 

Colabに馴染みのない方は、まず[Colabのイントロダクション](https://colab.research.google.com/notebooks/intro.ipynb)をご覧いただくことをお勧めします。Colabでは、GPUやTPUのようなアクセラレーターを使用することができ、小規模な作業であれば無料で使用することができます。

Colabでの操作に慣れたら、新しいノートブックを作成してセットアップを始めましょう。

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

次のステップとして、このコースで使用するライブラリのインストールを行います。インストールには、Pythonのパッケージマネージャーである`pip`を使用します。ノートブック内では、システムコマンドの前に`!`をつけることで実行が可能となるため、次のようにして🤗 Transformersライブラリをインストールすることができます。

```
!pip install transformers
```

パッケージが正常にインストールされたかどうかは、Pythonランタイム内でインポートすることで確認できます。

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

上記の方法では、非常に軽量なバージョンの🤗 Transformersをインストールしています。特に、特定の機械学習フレームワーク（PyTorchやTensorFlowなど）はインストールしていません。このコースでは、transformersの多くの機能を使うことになるため、想定しているユースケースで必要な依存関係が全て含まれている開発バージョンをインストールすることをお勧めします。

```
!pip install transformers[sentencepiece]
```

このインストールには少し時間がかかりますが、これで残りのコースを問題なく進めることができます！

## Pythonの仮想環境を使用する場合

Pythonの仮想環境を使用したい場合は、まず手元のシステムにPythonをインストールしておく必要があります。このコースでは、[このガイド](https://realpython.com/installing-python/)に従って始めることをお勧めします.

Pythonのインストールが完了すると、ターミナルでPythonコマンドが実行できるようになるはずです。まずは`python --version`を実行して、正常にインストールされていることを確認してから次のステップに進んでください。このコマンドを実行すると、システムで現在利用可能なPythonのバージョンが出力されます。

ターミナルで`python --version`のようなPythonコマンドを実行する場合、コマンドを実行するプログラムはシステムのメインのPythonと考えるべきです。このメインのPythonにはパッケージが存在しない状態を維持し、取り組むそれぞれの内容ごとに個別の環境を作成するのに使用することをお勧めします。この方法では、それぞれの環境が依存関係とパッケージを独立して持つことができ、他の取り組みとの互換性の問題を気にする必要がなくなります。

これはPythonでは、[仮想環境](https://docs.python.org/3/tutorial/venv.html)によって行われます。仮想環境とは、必要な全てのパッケージとともに特定のバージョンのPythonをインストールした自己完結型のディレクトリツリーのことです。仮想環境の作成は多くのツールで行うことが可能ですが、このコースでは[`venv`](https://docs.python.org/3/library/venv.html#module-venv)と呼ばれるPythonの公式パッケージを使用します。

まずは、作業を行うディレクトリを作成します。例として、ホームディレクトリのルートに*transformers-course*という新しいディレクトリを作成するとよいでしょう。

```
mkdir ~/transformers-course
cd ~/transformers-course
```

このディレクトリの中で、Pythonの`venv`モジュールを用いて仮想環境を作成します。

```
python -m venv .env
```

これで、何も入っていなかったディレクトリに*.env*というディレクトリができたはずです。

```
ls -a
```

```out
.      ..    .env
```

仮想環境は、`activate`と`deactivate`というスクリプトで有効化したり、無効化することが可能です。

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

仮想環境が有効になっているかどうかは、`which python`というコマンドを実行することで確認することができます。もし以下のように仮想環境であることを示していれば、正常に有効化できています！

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### 依存関係のインストール

前のセクションで扱ったGoogle Colabのインスタンスを使用する場合と同様に、この先で必要となるパッケージをインストールする必要があります。ここでも、`pip`というパッケージマネージャーを使用して🤗 Transformersの開発バージョンをインストールすることが可能です。

```
pip install "transformers[sentencepiece]"
```

これでセットアップは完了です！


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter0/1.mdx" />