# 章末クイズ

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

この章では多くの物事を学びました！詳細を把握できなくても安心してください。次の章はどのようにこれらのツールが動いているか理解する上で役に立ちます。

まずは、この章で学んだことを確かめましょう！


### 1.Hubを探索して`roberta-large-mnli`チェックポイントを見つけましょう。 このモデルはどのタスクに適していますか?

<Question
	choices={[
		{
			text: "文章要約",
			explain: "もう一度roberta-large-mnliの<a href=\"https://huggingface.co/roberta-large-mnli\">ページ</a>を見てみましょう。"
		},
		{
			text: "文章分類",
			explain: "より正確には2つの文が論理的にどのような関係を持つか、３つのラベル（矛盾、中立、含意）について分類します。このタスクは<em>自然言語推論</em>とも呼ばれます。",
			correct: true
		},
		{
			text: "文章生成",
			explain: "もう一度roberta-large-mnliの<a href=\"https://huggingface.co/roberta-large-mnli\">ページ</a>を見てみましょう。"
		}
	]}
/>

### 2.次のコードは何を返しますか?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
            text: "この文章の分類スコアを\"positive\"または\"negative\"のラベルとともに返します。",
            explain: "間違いです。それは<code>sentiment-analysis</code> パイプラインを用いたときの動作です。"
		},
		{
            text: "この文章を完結させるための生成された文を返します。",
            explain: "間違いです。それは <code>text-generation</code> パイプラインを用いたときの動作です。"
		},
		{
            text: "この文中の人物、団体、場所を表す単語を返します。",
            explain: "さらに、<code>grouped_entities=True</code>を用いると、同じエンティティに属する単語をグループ化します。",
			correct: true
		}
	]}
/>

### 3. このサンプルコードでは...をどのように置き換えればよいでしょうか?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This \<mask\> has been waiting for you.",
			explain: "間違いです。<code>bert-base-cased</code>のモデルカードをチェックして、あなたの間違いを見つけましょう。"
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "正解！このモデルのマスクトークンは[MASK]です。",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "間違いです。このパイプラインはマスクされた単語を埋めるので、どこかにマスクトークンが必要です。"
		}
	]}
/>

### 4. なぜこのコードは動かないのでしょうか？

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
            text: "このパイプラインには、テキストを分類するためのラベルを与える必要があります。",
            explain: "正解です。正しいコードには<code>candidate_labels=[...]</code>を含める必要があります。",
			correct: true
		},
		{
			text: "このパイプラインには、一つの文だけでなく複数の文が必要です。",
            explain: "これは間違いです。しかし、適切に使用すれば、このパイプラインは処理する文のリストを受け取ることができます（他のパイプラインも同様です）。"
		},
		{
			text: "いつもどおり、この🤗Transformersライブラリは壊れています。",
            explain: "ノーコメント！"
		},
		{
            text: "このパイプラインはもっと長い入力が必要です。この入力は短すぎます。",
            explain: "これは間違いです。ただし、とても長い文をこのパイプラインで処理すると、切り捨てられることに注意してください。"
		}
	]}
/>

### 5. 転移学習とはどのような意味ですか？


<Question
	choices={[
		{
			text: "同じデータセットで学習することで、事前学習モデルが持つ知識を新しいモデルに転移させること。",
			explain: "間違いです。それは、2つのバージョンの同じモデルになります。"
		},
		{
			text: "事前学習モデルの重みを用いて、2つ目の新しいモデルを初期化することで、事前学習モデルの知識を転移させること。",
            explain: "正解です。2つ目のモデルを新しいタスクで学習する場合、それは最初のモデルが知識を*転移*したことになります。",
			correct: true
		},
		{
            text: "事前学習モデルと同じアーキテクチャを持つ新しいモデルを構築することで、事前学習モデルの知識を転移させること。",
			explain: "アーキテクチャはあくまでもモデルの作り方であるため、この場合には知識の共有、転移は行われません。"
		}
	]}
/>

### 6. マルバツクイズ、言語モデルの事前学習にラベルは通常は必要ない？


<Question
	choices={[
		{
			text: "マル",
            explain: "事前学習は通常、<em>自己教師あり学習</em>で行われます。つまり、ラベルは入力から自動的に作成されます（例えば、次の単語を予測したり、マスクされた単語を埋めたりといったように）。",
			correct: true
		},
		{
			text: "バツ",
			explain: "これは正しい回答ではありません。"
		}
	]}
/>

### 7.「モデル」、「アーキテクチャ」、「重み」という用語を最も適切に説明している文を選んでください。

<Question
	choices={[
		{
			text: "モデルが建物であるとすれば、アーキテクチャはその設計図で、重みは中に住んでいる人です。",
			explain: "このたとえに従うなら、重みはレンガなどビルを構成する材料になります。"
		},
		{
			text: "アーキテクチャはモデルを構築するための地図であり、その重みは地図上に表される都市です。",
			explain: "このたとえの問題は、通常地図は一つの実在する現実を表していることにあります（フランスにはパリという都市は一つしかない）。一方で、あるアーキテクチャに対して複数の重みを考えることができます。"
		},
		{
			text: "アーキテクチャはモデルを構築する一連の数学的な関数であり、重みはそれらの関数のパラメータです。",
			explain: "同じ数学的な関数の集合（アーキテクチャ）に対して、異なるパラメーター（重み）を用いることで、異なるモデルを作ることができます。",
			correct: true
		}
	]}
/>


### 8. 生成された文でプロンプトを完成させるために使うモデルはどれでしょうか？


<Question
	choices={[
		{
			text: "エンコーダーモデル",
			explain: "エンコーダーモデルは文章全体の埋め込み表現を生成するので、文章分類のようなタスクにより適しています。"
		},
		{
			text: "デコーダーモデル",
			explain: "デコーダーモデルはプロンプトから文章を生成するために、完璧に適したモデルです。",
			correct: true
		},
		{
			text: "sequence-to-sequenceモデル",
			explain: "Sequence-to-sequenceモデルは、与えられたプロンプトではなく入力文と関連のある文章を生成したいときにより適したモデルです。"
		}
	]}
/>

### 9. 文章要約タスクに使うモデルはどれでしょうか?

<Question
	choices={[
		{
			text: "エンコーダーモデル",
			explain: "エンコーダーモデルは文章全体の埋め込み表現を生成するので、文章分類のようなタスクにより適しています。"
		},
		{
			text: "デコーダーモデル",
			explain: "デコーダーモデルは出力文を生成する上で良いモデルです（たとえば要約のように）。しかし、要約対象の文章全体のような文脈を利用する能力はありません。"
		},
		{
			text: "sequence-to-sequenceモデル",
			explain: "Sequence-to-sequenceモデルは要約タスクに完璧に適したモデルです。",
			correct: true
		}
	]}
/>

### 10. 入力された文を特定のラベルに分類したいときに使うモデルはどれでしょうか？


<Question
	choices={[
		{
			text: "エンコーダーモデル",
			explain: "エンコーダーモデルは文章全体の埋め込み表現を生成するので、文章分類のようなタスクに完璧に適しています。",
			correct: true
		},
		{
			text: "デコーダーモデル",
			explain: "デコーダーモデルは出力文を生成する上で良いモデルですが、文からラベルを抽出するモデルではありません。"
		},
		{
			text: "sequence-to-sequenceモデル",
			explain: "Sequence-to-sequenceモデルは、入力文に基づいて文を生成するときにより適したモデルで、ラベルを出力するモデルではありません。",
		}
	]}
/>

### 11. モデルが持つバイアスはどのような要因で生じますか?


<Question
	choices={[
		{
			text: "モデルが事前学習モデルをファインチューニングしたバージョンであり、そのモデルが元のモデルよりバイアスを受け継いだとき。",
			explain: "転移学習が適用されるとき、事前学習モデルのバイアスがファインチューニングされたモデルに発現します。",
			correct: true
		},
		{
			text: "モデルを訓練するデータに偏りがある時。",
			explain: "これは最も顕著なバイアスの要因です。しかし、要因はこれだけではありません。",
			correct: true
		},
		{
			text: "モデルを最適化するための指標に偏りがある時",
            explain: "バイアスの要因としてあまり知られていないのはモデルの学習方法です。モデルはあなたが選んだどんな指標に対しても、やみくもに最適化します。",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/10.mdx" />