# 自然言語処理 / NLP(Natural Language Processing)

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Transformerモデルの詳細に飛び込んでいく前に、自然言語処理とはどんなもので、かつ、なぜ我々が注目する必要があるのかの大まかな概要を知っていきましょう。

## 自然言語処理とはどんなもの？

自然言語処理とは、人の言語に関連した全てのことへの理解に焦点を当てた、言語学と機械学習の分野です。自然言語処理タスクの目標は、文章を個別に一単語ずつ理解するだけでなく、それらの単語で構成された文章の文脈を理解することです。

以下のリストで、具体例付きで一般的な自然言語処理タスクを紹介します。

- **文章の分類**：レビューの評価、スパムメールの検出、文法的に正しいかどうかの判断、2つの文が論理的に関連しているかどうかの判断
- **文の中の単語分類**：品詞（名詞、動詞、形容詞）や、固有表現（人、場所、組織）の識別
- **文章内容の生成**：自動生成されたテキストによる入力テキストの補完、文章の穴埋め
- **文章からの情報抽出**：質問と文脈が与えられたときの、文脈からの情報に基づいた質問に対する答えの抽出
- **文章の変換**：ある文章の他の言語への翻訳、文章の要約

さらに、自然言語処理は文章に限ったものではありません。音声認識やコンピュータビジョンの分野でも、音声サンプルの書き起こしや画像の説明文の生成など、複雑な課題に取り組んでいます。

## なぜ自然言語処理は困難なのか？

コンピュータは人間と同じように情報を処理するわけではありません。例えば、「私はお腹が空いています。」という文章を読むと、人間はその意味を簡単に理解することができます。同様に、「私はお腹が空いています。」と「私は悲しいです。」という2つの文章があれば、その類似性を人間は簡単に判断することができます。しかし、機械学習(ML)モデルにおいては、このようなタスクはより困難です。機械学習モデルが学習できるように、テキストを処理する必要があります。また、言語は複雑なため、どのように処理すべきかを慎重に考える必要があります。テキストをどのように表現するかについては多くの研究がなされており、次の章ではいくつかの方法について見ていきます。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/2.mdx" />