# イントロダクション

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

[第1章](/course/chapter1)で見たように、Transformerのモデルは通常、非常に大きなものです。数百万から数百億のパラメータを持つこれらのモデルをトレーニングし、デプロイすることは複雑な仕事です。さらに、ほぼ毎日新しいモデルがリリースされ、それぞれが独自の実装を持っているため、それらをすべて試すことは簡単なことではありません。

🤗 Transformersライブラリはこの問題を解決するために作成されました。その目的は、どんなTransformerモデルでもロード、学習、保存ができる単一のAPIを提供することです。このライブラリの主な機能は以下の通りです。

- **使いやすさ**: 推論のためには、2行のコードで最先端のNLPモデルをダウンロードして使用できます！
- **柔軟さ**: 実装のコアでは、すべてのモデルが単純なPyTorchの`nn.Module`またはTensorFlowの`tf.keras.Model`クラスであり、それぞれの機械学習（ML）フレームワークの他のモデルと同様に扱うことができます！
- **単純さ**: ライブラリ全体でほとんど抽象化は行われていません。"All in one file"がコアコンセプトです。例えば、モデルの順伝播は1つのファイルで完全に定義されているため、コードそのものが理解しやすく、変更しやすいです！

この最後の特徴が🤗 Transformersを他のMLライブラリとは全く違うものにしています。モデルはファイル間で共有されるモジュールで構築されるのではなく、その代わり、各モデルはそれ自身のレイヤーを持っています。モデルをより親しみやすく理解しやすくすることに加えて、これにより、他のモデルに影響を与えることなく、一つのモデルで簡単に実験することができます。

この章ではまず、[第１章](/course/chapter1) で紹介した `pipeline()` 関数を再現するために、モデルとトークナイザを一緒に使ったエンドツーエンドの例を紹介します。次に、モデルAPIについて説明します。モデルとコンフィギュレーションについて詳しく説明し、モデルをロードする方法と、モデルがどのように数値入力を処理して予測を出力するかを説明します。

次に、`pipeline()`関数のもう一つの主要な構成要素であるトークナイザーAPIについて見ていきます。トークナイザは、テキストからニューラルネットワークの数値入力への変換を処理し、必要に応じてテキストに戻す、最初と最後の処理ステップを担います。最後に、複数の文章をバッチ処理でモデルに送る方法を紹介し、`tokenizer()` 関数を詳しく見て、まとめに移ります。

<Tip>
⚠️ Model Hubと🤗 Transformersで利用可能なすべての機能を活用するには、<a href="https://huggingface.co/join">アカウントを作成する</a>ことをお勧めします。
</Tip>



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter2/1.mdx" />