# モデルカードを作成する

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

モデルカードは、モデルリポジトリにおいて、モデルファイルやトークナイザーファイルと同じくらい重要なファイルです。モデルの主要な定義であり、コミュニティメンバーによる再利用と結果の再現性を保証し、さらには他のメンバーが成果物を構築するためのプラットフォームを提供します。

また、使用したデータや前処理・後処理に関する十分な情報を提供することで、モデルの限界、バイアス、有用となる場面の特定及び理解が可能になります。

そのため、モデルを明確に定義したモデルカードを作成することは、非常に重要なステップとなります。ここでは、これに役立ついくつかのヒントを提供します。モデルカードの作成は、先ほど見た*README.md*ファイル、つまりMarkdownファイルを通して行います。

「モデルカード」のコンセプトは、Googleの研究方針に端を発し、Margaret Mitchellらの論文["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993)で初めて公開されました。ここに含まれる多くの情報は、その論文に基づいており、再現性、再利用性、公平性を重視する世界において、なぜモデルカードが重要であるかを理解するには、この論文をご覧になることをお勧めします。

モデルカードは通常、何のためのモデルなのかという非常に簡潔でハイレベルな概要から始まり、これらの追加の詳細が説明されます：

- モデル概要
- 使用目的・制限
- 使用方法
- 制限とバイアス
- 学習データ
- 学習手順
- 評価結果

それでは、それぞれのセクションの内容について見ていきましょう。

### モデル概要

モデルの概要では、モデルに関する基本的な詳細を説明します。これには、アーキテクチャ、バージョン、論文で紹介されたかどうか、オリジナルの実装があるかどうか、作者、モデルに関する一般的な情報などが含まれます。著作権についてはここに記載すべきです。学習方法、パラメータ、重要な免責事項に関する一般的な情報もこのセクションに記載することができます。

### 使用目的・制限

ここでは、モデルが適用される言語、フィールド、ドメインなど、そのモデルが想定するユースケースを記述します。モデルカードのこのセクションは、モデルの適用範囲外であることが分かっている領域や、最適でない性能を発揮する可能性がある領域も記述することができます。

### 使用方法

このセクションでは、モデルの使い方の例をいくつか紹介します。これは`pipeline()`関数の使い方、モデルクラスとトークナイザークラスの使い方、そしてその他に役立つコードを紹介することができます。

### 学習データ

この部分は、モデルがどのデータセットで学習されたかを示す必要があります。データセットの簡単な説明でも大丈夫です。

### 学習手順

このセクションでは、再現性の観点から有用となる、学習に関する全てを記述する必要があります。これには、データに対して行われた前処理や後処理、モデルの学習エポック数、バッチサイズ、学習レートなどの詳細が含まれます。

### 変数とメトリクス

ここでは、評価のために使用したメトリクスと、測定しているさまざまな要因を記述します。どのデータセットで、どのデータセットを分割して、どのメトリクスを使用したかを記述することで、他のモデルの性能と比較することが容易になります。これらの情報は、前のセクション（想定されるユーザーやユースケースなど）から得たものであるべきです。

### 評価結果

最後に、評価用データセットにおいて、モデルがどの程度うまく機能するかの指標を提供します。モデルが閾値を使用する場合、評価に使用した閾値を提供するか、または想定する用途に応じた異なる閾値での評価に関する詳細を提供します。

## 例

よくできたモデルカードの例として、これらをご覧ください：

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

さまざまな組織や企業によるその他の事例は、[こちら](https://github.com/huggingface/model_card/blob/master/examples.md)からご覧いただけます。

## 注釈

モデルカードはモデルを公開する際の必須条件ではありませんし、モデルを作成する際に上記のセクションをすべて含める必要はありません。しかし、モデルを明確に文書化することは、必ず将来のユーザーのためになるので、できるだけ多くのセクションを埋めることをお勧めします。

## モデルカードメタデータ

ハギングフェイスハブを少しみてみると、いくつかのモデルが特定のカテゴリに属していることがわかるはずです：タスク、言語、ライブラリなどでフィルタリングすることができます。モデルが属するカテゴリーは、モデルカードのヘッダーに追加されたメタデータによって識別されます。

例えば、[`camembert-base`モデルカード](https://huggingface.co/camembert-base/blob/main/README.md)を見てみると、モデルカードのヘッダに以下のような行があるはずです：

```
---
language: fr
license: mit
datasets:
- oscar
---
```

このメタデータはハギングフェイスハブによって解析され、このモデルがOscarデータセットで学習されたMITライセンスのフランス語のモデルであることが特定されます。

[モデルカード全仕様](https://github.com/huggingface/hub-docs/blame/main/modelcard.md)では、言語、ライセンス、タグ、データセット、メトリクス、および学習時にモデルが得た評価結果を記述することができます。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter4/4.mdx" />