# 단원 소개

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 🤗 강의 수강생 여러분 환영합니다!

<Youtube id="00GKzGyWFEs" />

이번 강의에서는 [Hugging Face](https://huggingface.co/) 환경의 라이브러리([🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), [🤗 Accelerate](https://github.com/huggingface/accelerate))와 [Hugging Face Hub](https://huggingface.co/models) 를 이용해 자연어 처리(NLP)에 대해 배워보겠습니다. (무료 강의에 광고도 없는건 비밀입니다!)

## 무엇을 배우나요?

강의 개요 훑어보기:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- 챕터 1~4에서는 🤗 Transformers 라이브러리의 핵심 개념에 대해 소개합니다. 이 부분을 마치면 트랜스포머 모델의 동작 원리를 이해하실 수 있고, [Hugging Face Hub](https://huggingface.co/models)에서 모델을 사용하여 데이터셋으로 미세 조정(fine-tune)한 후 Hub에 모델을 공유하는 방법까지 터득하게 될 것입니다!
- 챕터 5~8은 본격적으로 고전 NLP 업무를 수행하기 앞서, 🤗 Datasets와 🤗 Tokenizers의 기초에 대해 알아봅니다. 이 부분을 모두 학습하시면 일반적인 NLP 문제를 스스로 해낼 수 있게 됩니다.
- 챕터 9~12에서는 트랜스포머 모델이 NLP 문제를 넘어, 음성 처리 및 컴퓨터 비전에 어떻게 활용되는지 탐구합니다. 이 과정에서 모델 데모를 구축하고 공유하는 방법과 이를 프로덕션 환경에 최적화하는 방법을 공부합니다. 이러한 과정을 거쳐서, 여러분들은 거의 모든 기계 학습(머신 러닝) 문제에 🤗 Transformers를 적용할 준비를 갖추게 됩니다!

이번 강의는:

* 파이썬에 대한 기초 지식이 필요합니다
* [DeepLearning.AI](https://www.deeplearning.ai/) 의 프로그램이나  [fast.ai's](https://www.fast.ai/) [Practical Deep Learning for Coders](https://course.fast.ai/) 와 같은 딥러닝에 대한 기초 강의를 듣고 수강하면 더욱 효과적입니다
* [PyTorch](https://pytorch.org/) , [TensorFlow](https://www.tensorflow.org/) 에 대한 선수 지식이 필요하지는 않지만, 이에 익숙하시다면 도움이 될 것입니다

본 강의를 모두 수강한 후, DeepLearning.AI의 [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh)을 학습하시길 권장드립니다. 해당 과정에서는 Naive Bayes, LSTM과 같은 알아두면 너무나 유용한 더 넓은 범위의 전통 NLP 모델에 대해 학습할 수 있습니다!

## 우리가 누구일까요?

저자 소개:

**Matthew Carrigan**은 Hugging Face의 머신 러닝 엔지니어입니다. 현재 아일랜드 더블린에 살고 있으며, 이전에는 [Parse.ly](http://parse.ly/) 에서 ML 엔지니어로, 그 전에는 Trinity Collge Dublin에서 박사 과정 이후 연구원으로 근무했습니다. 사람이 기존 인공지능 아키텍쳐를 확장하여 사람 수준에는 도달하지 못할거라고 생각하지만, 그럼에도 불멸 로봇(immortality robot)에 대해 큰 기대를 갖고 있습니다.

**Lysandre Debut**는 Hugging Face의 머신 러닝 엔지니어이며 초창기부터 🤗 Transformers 라이브러리 작업을 함께 했습니다. 아주 사용하기 쉬운 API를 개발하여 모두가 NLP를 쉽게 사용할 수 있도록 하는 목표를 갖고 있습니다.

**Sylvain Gugger**는 Hugging Face의 리서치 엔지니어로 🤗 Transformers 라이브러리의 주요 관리자 중 한명입니다. 이전에 [fast.ai](http://fast.ai/) 에서 리서치 사이언티스트로 있었으며 Jeremy Howard와 함께  *[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)* 를 저술했습니다. 적은 리소스에서도 모델이 빠르게 학습되도록 기술을 디자인하고 개선하여 딥러닝에 보다 쉽게 접근할 수 있도록 하는 것을 리서치의 가장 큰 목표로 삼고 있습니다.

**Merve Noyan**은 Hugging Face의 개발자 애드보케이트로, 모두에게 평등한 민주적인 머신 러닝 생태계를 만드는 목표를 갖고 있으며, 개발툴 작업 및 주변 컨텐츠 구축 작업을 담당하고 있습니다.

**Lucile Saulnier**은 Hugging Face의 ML 엔지니어로 오픈 소스 툴 사용에 대한 개발 및 지원을 담당합니다. 자연어 처리 분야에서 협업 학습, BigScience등과 같은 다양한 리서치 프로젝트에도 활발히 참여하고 있습니다.

**Lewis Tunstall**는 Hugging Face의 ML 엔지니어로 오픈 소스 툴을 개발하여 더 많은 커뮤니티에 상용화되도록 하는 데에 초점을 맞추고 있습니다. 곧 출간되는 [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)의 공저자이기도 합니다.

**Leandro von Werra**는 Hugging Face 오픈소스 팀의 머신 러닝 엔지니어이자 곧 출간될 [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)의 공동 저자입니다.  모든 머신 러닝 스택에서의 작업을 통해 수 년간 NLP 프로젝트를 프로덕션으로 들여온 경력자입니다.

시작할 준비가 되셨나요? 이번 챕터에서 다룰 내용은 다음과 같습니다:

- 텍스트 생성 및 분류와 같은 NLP 문제를 푸는 `pipeline()` 함수 사용법
- 트랜스포머 모델 구조
- 인코더(encoder), 디코더(decoder), 인코더-디코더(encoder-decoder)의 구조와 용례

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter1/1.mdx" />