# 편향과 한계

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ko/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ko/chapter1/section8.ipynb"},
]} />

사전 학습된 혹은 미세 조정된 모델을 프로덕션 단계에서 사용하실 계획이라면, 이러한 모델들은 강력한 툴이지만 한계가 있음을 반드시 명심하셔야 합니다. 가장 큰 한계점은 리서처들이 무수히 많은 양의 데이터를 사전 학습에 사용하기 위해, 인터넷상에서 모을 수 있는 양질의 데이터와 함께 그렇지 않은 데이터까지 수집했을 가능성이 있다는 것입니다.

이를 빠르게 보여드리기 위해 `fill-mask` 파이프라인에 BERT 모델을 연결한 예제를 다시 살펴보겠습니다:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

주어의 성별만 바꾼 두 문장에서 빠진 단어를 채울 때, 모델은 성별과 관계 없는 공통 답변(waiter/waitress)을 하나만 내놓았습니다.  다른 답변들은 일반적으로 특정 성별에 편향된 답변이었습니다. 이를테면, 모델은 매춘이라는 단어와 연관된 상위 5개의 단어에 “여성”과 “일”을 포함시켰습니다. BERT가 전체 인터넷 상의 텍스트를 이용하여 사전 학습된 것이 아니라 [English Wikipedia](https://huggingface.co/datasets/wikipedia) 와 [BookCorpus](https://huggingface.co/datasets/bookcorpus) 같이 상당히 중립적인 데이터를 이용해 사전 학습 되었음에도 불구하고 이러한 현상이 일어납니다.

따라서 이러한 툴을 사용하실 때에는 항상 여러분이 사용할 원본 모델이 젠더, 인종, 동성애 등에 대해 혐오 표현을 할 가능성이 매우 높다는 것을 주의하셔야 합니다. 이러한 모델은 미세 조정을 거쳐도 내제된 편향성을 없애지 못합니다.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter1/8.mdx" />