# 포럼에서 도움 요청하기

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

[HuggingFace 포럼](https://discuss.huggingface.co)은 오픈 소스 팀과 더 거대한 Hugging Face 커뮤니티의 도움을 받을 수 있는 좋은 공간입니다. 특정 날짜의 메인 페이지는 다음과 같습니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

왼쪽에는 그룹화된 다양한 주제의 카테고리가 ​있으며 오른쪽에는 가장 최근 주제가 표시됩니다. 주제는 제목, 카테고리 및 설명이 포함된 게시물입니다. 이는 [단원 5](/course/chapter5)에서 자체 데이터 세트를 생성할 때 본 GitHub 문제 형식과 매우 유사합니다. 이름에서 알 수 있듯이 [초보자](https://discuss.huggingface.co/c/beginners/5) 카테고리는 주로 HuggingFace 라이브러리 및 에코시스템을 처음 시작하는 사람들을 대상으로 합니다. 라이브러리에 대한 모든 질문은 환영하는 곳이며 일부 코드를 디버그하거나 무언가를 수행하는 방법에 대한 도움을 요청하는 곳 입니다. (즉, 질문이 특히 한 라이브러리에 관한 것이라면 포럼에서 해당 라이브러리 카테고리로 이동해야 할 것입니다.)

마찬가지로 [중급](https://discuss.huggingface.co/c/intermediate/6) 및 [연구](https://discuss.huggingface.co/c/research/7) 카테고리는 어려운 질문용입니다. 멋진 새 NLP 연구나 라이브러리들에 대해 토론하고 싶을 때의 내용을 예로 들 수 있습니다.

이어서 허깅페이스 코스와 관련된 질문을 할 수 있는 [코스](https://discuss.huggingface.co/c/course/20) 카테고리도 언급 안할 수가 없네요!!

카테고리를 선택하고나면 첫 번째 주제를 작성할 준비가 되었습니다. 이 포스트를 작성하는 방법은 포럼의 [가이드라인](https://discuss.huggingface.co/t/how-to-request-support/3128)에서 찾을 수 있으며 이 장에서는 좋은 주제를 작성하는 몇 가지 방법을 알아보겠습니다. 

## 포럼에 포스팅 잘쓰는 법

실습 예제로 Wikipedia 기사에서 임베딩을 생성하여 커스텀 검색 엔진을 만든다고 가정해 보겠습니다. 평소처럼 토크나이저와 모델을 다음과 같이 로드합니다:

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

이제 [Wikipedia 기사](https://en.wikipedia.org/wiki/Transformers)의 전체 섹션을 Transformers(라이브러리가 아니라 프랜차이즈!)에 임베딩 한다고 가정합니다:

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

에고, 문제가 발생했습니다. 오류 메시지는 [2장](/course/chapter8/section2)에서 본 것보다 훨씬 더 어렵네요! 우리는 전체 traceback을 이해할 수 없으므로 HuggingFace 포럼에 도움을 요청하기로 결정합니다. 주제를 어떻게 만들 수 있을까요?

주제를 작성하려면 오른쪽 상단 모서리에 있는 "새 주제" 버튼을 클릭해야 합니다(주제를 만들려면 로그인해야 함):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

그러면 주제의 제목과 카테고리, 콘텐츠를 입력할 수 있는 화면이 나타나게 됩니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

에러는 🤗 Transformers에 대한 것이므로 Transformers 카테고리로 선택하겠습니다. 문제를 설명하는 우리의 첫 시도는 아마 아래와 같을 겁니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

이 주제는 도움에 필요한 오류 메시지가 포함되어 있지만 작성 방식에 몇 가지 문제가 있습니다:

1. 제목이 그다지 기술적이지 않으므로 포럼을 탐색하는 사람은 본문을 읽지 않고는 주제가 무엇인지 알 수 없습니다.
2. 본문이 오류가 _어디에서_ 발생하고 _어떻게_ 에러를 재현하는지에 대한 충분한 정보를 제공하지 않습니다.
3. 주제는 다소 요구하는 어조로 몇몇 사람들을 직접적으로 태그합니다.

이와 같은 주제는 빠른 답변을 얻지 못할 것이므로(적어도 하나라도 받을 경우) 이를 개선할 수 있는 방법을 살펴보겠습니다. 좋은 타이틀을 선택하기 위해 첫번째 이슈글 부터 보겠습니다.

### 기술적인 제목 선택하기

코드의 버그에 대한 도움을 받으려는 경우 다른 사람들이 질문에 답할 수 있는지 여부를 빠르게 결정할 수 있도록 제목에 충분한 정보를 포함하는 것이 좋습니다. 실습 예제에서 발생하는 예외의 이름을 알고 있으며 `model(**inputs)`을 호출하는 모델의 forward 과정에서 발생한다는 힌트를 얻었습니다. 이를 소통하기 위해 다음과 같은 제목이 가능하겠네요:

> Source of IndexError in the AutoModel forward pass?

이 제목은 읽는 사람에게 _어디에서_ 버그가 발생했다고 생각하는지 알려주고, 이전에 'IndexError'를 본 적이 있다면 디버그 방법을 알고 있을 가능성이 큽니다. 물론 제목은 원하는 대로 지정할 수 있으며 다음과 같은 변형도 가능합니다:

> Why does my model produce an IndexError?

와 같은 제목도 괜찮을 수 있습니다. 기술적인 제목을 만들었으니 본문 개선 방법을 살펴보겠습니다.

### 코드 스니펫 형식 지정하기

IDE에서 소스 코드를 읽는 것은 충분히 어렵지만 코드를 일반 텍스트로 복사하여 붙여넣으면 훨씬 더 어렵습니다! 다행히 HuggingFace 포럼은 Markdown 사용을 지원하므로 코드 블록을 항상 세 개의 백틱(```)으로 묶어서 더 쉽게 읽을 수 있도록 해야 합니다. 에러 메시지를 보기 좋게 만들기 위해 백틱안에 코드를 넣으면서 원본 보다 본문을 좀 더 정중하게 만들어 보겠습니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

스크린샷에서 볼 수 있듯이 코드 블록을 백틱으로 묶으면 일반 텍스트가 코드로 변환되고 컬러 스타일링이 완성됩니다! 또한 `distilbert-base-uncased`에 했던 것처럼 하나의 백틱을 사용해 인라인 변수의 형식을 지정할 수 있습니다. 이 주제는 훨씬 나아지고 있으며 운이 좋으면 커뮤니티에서 에러가 무엇인지 추측할 수 있는 사람을 찾을 수 있습니다. 그러나 운에 맡기기 보단 traceback을 철저하고 세부적으로 포함해서 삶을 더 쉽게 만들도록 하죠!

### 전체 traceback 포함하기

traceback의 마지막 줄은 종종 코드를 디버그하기에 충분하기 때문에 주제에 "공간 절약"을 하고 싶을 수도 있습니다. 의도는 좋지만 traceback에서 상위에 있는 정보도 정말 유용할 수 있기 때문에 때론 다른 사람들이 문제를 디버그하는 것을 실제로 _더 어렵게_ 합니다. 따라서 좋은 방법은 _전체_ traceback을 복사하여 붙여넣으면서 형식이 제대로 지정되었는지 확인하는 것입니다. 이러한 traceback은 다소 길어질 수 있으므로 일부 사람들은 소스 코드를 설명한 후에 표시하는 것을 선호합니다. 이제 작성해봅시다. 포럼 주제는 다음과 같습니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

이게 훨씬 더 많은 정보를 제공하며, 섬세한 독자는 traceback에 있는 특정 행을 보고 긴 입력을 전달하기 때문에 문제가 있는 것으로 보인다는 점을 지적할 수 있습니다:

> Token indices sequence length is longer than the specified maximum sequence length for this model (583 > 512).

하지만 에러를 발생한 실제 코드를 제공해 문제를 훨씬 더 쉽게 만들 수 있습니다. 같이 방법을 알아보죠.

### 재현 가능한 예제코드 제공

다른 사람의 코드를 디버그하려고 시도한 적이 있다면 아마 그 사람이 보고한 문제를 먼저 재현해서 traceback을 통해 오류를 정확하게 찾아내는 작업을 할 수 있습니다. 포럼에서 도움을 받는(또는 제공하는) 경우에도 다르지 않으므로 오류를 재현하는 작은 예시를 제공할 수 있다면 정말 도움이 됩니다. 절반은 이 연습을 진행하는 것만으로도 무엇이 문제인지 파악하는 데 도움이 될 것입니다. 어쨌든 우리 예제에서 누락된 부분은 모델에 입력한 _inputs_를 표시하는 것입니다. 그러면 다음과 같은 완성된 예가 나타납니다:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

이 주제는 이제 상당히 많은 정보가 포함되어 있으며 커뮤니티의 관심을 끌고 유용한 답변을 얻을 가능성이 훨씬 높은 방식으로 작성되었습니다. 이 기본 가이드라인을 통해 이제 멋진 주제를 포스팅해서 🤗 Transformers 질문에 대한 답변을 찾을 수 있습니다!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter8/3.mdx" />