# परिचय                                                                                                                                                                                                    

नमस्कार! Hugging Face कोर्समा स्वागत छ! यो परिचयले तपाईंलाई काम गर्ने वातावरण सेट गर्न सिकाउँछ। यदि तपाईं भर्खरै कोर्स सुरु गर्दै हुनुहुन्छ भने, हामी सुझाव दिन्छौं कि पहिले [अध्याय १](/course/chapter1) हेर्नुहोस्, अनि फर्केर आफ्नो वातावरण सेट गर्नुहोस् ताकि तपाईं आफैं कोड गर्न सक्नुहुनेछ।     

यो कोर्समा हामीले प्रयोग गर्ने सबै लाइब्रेरीहरू Python प्याकेजको रूपमा पाइन्छ। यहाँ हामी तपाईंलाई Python वातावरण कसरी सेट गर्ने र चाहिने लाइब्रेरीहरू कसरी इन्स्टल गर्ने भनेर देखाउँछौं।                                                                                   

तपाईंको काम गर्ने वातावरण सेट गर्न दुईवटा तरिका छन् - Colab नोटबुक वा Python भर्चुअल इन्भाइरोमेन्ट। जुन तरिका तपाईंलाई ठिक लाग्छ त्यही रोज्न सक्नुहुन्छ। नयाँ सिकारुहरूलाई चाहिँ Colab नोटबुकबाट सुरु गर्न सल्लाह दिन्छौं।                                                        

याद गर्नुहोस्, हामी Windows सिस्टमको बारेमा केही बताउँदैनौं। Windows चलाइरहनुभएको छ भने Colab नोटबुक प्रयोग गर्नुहोस्। Linux वा macOS चलाइरहनुभएको छ भने माथिका दुवै तरिका प्रयोग गर्न सक्नुहुन्छ।                                                                   

यो कोर्सको धेरैजसो भागमा Hugging Face अकाउन्ट चाहिन्छ। अहिले नै एउटा बनाउनुहोस्: [अकाउन्ट बनाउनुहोस्](https://huggingface.co/join)।                                                                                                           

## Google Colab नोटबुक प्रयोग गर्ने तरिका                                                                                                                                                

Colab नोटबुक प्रयोग गर्नु सबैभन्दा सजिलो तरिका हो। ब्राउजरमा नोटबुक खोल्नुहोस् र सिधै कोडिङ सुरु गर्नुहोस्!                                                                                                                                         

Colab बारे थाहा छैन भने, [परिचय](https://colab.research.google.com/notebooks/intro.ipynb) हेरेर सुरु गर्नुहोस्। Colab मा GPUs वा TPUs जस्ता छिटो चल्ने हार्डवेयर पनि प्रयोग गर्न पाइन्छ, र साना कामहरूका लागि सित्तैमा पाइन्छ।                                 

Colab मा काम गर्न सजिलो लाग्यो भने, नयाँ नोटबुक बनाएर सेटअप सुरु गर्नुहोस्।                                                                                                                                                            

<div class="flex justify-center">                                                                                                                                                                                 
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="खाली Colab नोटबुक" width="80%"/>                                                       
</div>                                                                                                                                                                                                            

अब हामीलाई चाहिने लाइब्रेरीहरू इन्स्टल गर्नुपर्छ। यसको लागि हामी Python को प्याकेज म्यानेजर `pip` प्रयोग गर्छौं। नोटबुकमा सिस्टम कमाण्डहरू चलाउन `!` चिन्ह लगाउनुपर्छ। त्यसैले 🤗 Transformers लाइब्रेरी यसरी इन्स्टल गर्न सकिन्छ:                                            
```                                                                                                                                                                                              
!pip install transformers                                                                                                                                                                                          
```


लाइब्रेरी राम्रोसँग इन्स्टल भयो कि भएन जाँच गर्न Python मा import गरेर हेर्न सक्नुहुन्छ:                                                                                                                                                 

```python                                                                                                                                                                                                         
import transformers
```                                                                                                                                                                                                                   

<div class="flex justify-center">                                                                                                                                                                                 
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="माथिका दुई कमाण्डको नतिजा देखाउने GIF: installation र import" width="80%"/>                      
</div>                                                                                                                                                                                                            

यसले 🤗 Transformers को सबैभन्दा हल्का भर्जन इन्स्टल गर्छ। यसमा PyTorch वा TensorFlow जस्ता मेशिन लर्निङ फ्रेमवर्कहरू समावेश हुँदैनन्। किनभने हामी लाइब्रेरीका धेरै फिचरहरू प्रयोग गर्नेछौं, हामी डेभलपमेन्ट भर्जन इन्स्टल गर्न सुझाव दिन्छौं, जसमा सबै आवश्यक डिपेन्डेन्सीहरू समावेश छन्:    

```
!pip install transformers[sentencepiece]                                                                                                                                                                           
```


यसले केही समय लिन्छ, तर त्यसपछि तपाईं कोर्सको बाँकी भागको लागि तयार हुनुहुनेछ!                                                                                                                                                            

## Python भर्चुअल इन्भाइरोमेन्ट प्रयोग                                                                                                                                              

यदि तपाईं Python भर्चुअल इन्भाइरोमेन्ट प्रयोग गर्न चाहनुहुन्छ भने, पहिलो चरणमा आफ्नो सिस्टममा Python इन्स्टल गर्नुपर्छ। सुरु गर्नको लागि [यो गाइड](https://realpython.com/installing-python/) हेर्न सुझाव दिन्छौं।                                               

Python इन्स्टल गरिसकेपछि, तपाईंले टर्मिनलमा Python कमाण्डहरू चलाउन सक्नुहुनेछ। सुरुमा यो कमाण्ड चलाएर Python ठीकसँग इन्स्टल भएको छ कि छैन जाँच गर्न सक्नुहुन्छ: `python --version`। यसले तपाईंको सिस्टममा भएको Python को भर्जन देखाउनुपर्छ।                             

जब तपाईं `python --version` जस्तो कमाण्ड चलाउनुहुन्छ, त्यो तपाईंको सिस्टमको "मुख्य" Python ले चलाएको हो भन्ने बुझ्नुपर्छ। हामी सुझाव दिन्छौं कि यो मुख्य इन्स्टलेसनलाई खाली राख्नुहोस्, र हरेक एप्लिकेसनको लागि छुट्टै इन्भाइरोमेन्ट बनाउनुहोस् - यसरी हरेक एप्लिकेसनको आफ्नै डिपेन्डेन्सी र प्याकेजहरू हुन्छ  र अरु एप्लिकेसनहरूसँग कम्प्याटिबिलिटी समस्या आउँदैन।                                                                                                                                                                               

Python मा यो [*भर्चुअल इन्भाइरोमेन्ट*](https://docs.python.org/3/tutorial/venv.html) को माध्यमबाट गरिन्छ, जुन एउटा छुट्टै डाइरेक्टरी हो जसमा निश्चित Python भर्जन र एप्लिकेसनलाई चाहिने सबै प्याकेजहरू हुन्छन्। यस्तो भर्चुअल इन्भाइरोमेन्ट धेरै टूलहरूले बनाउन सक्छन्, तर हामी   
अफिसियल Python प्याकेज [`venv`](https://docs.python.org/3/library/venv.html#module-venv) प्रयोग गर्छौं।                                                                                                                     

पहिले, आफ्नो एप्लिकेसन राख्ने डाइरेक्टरी बनाउनुहोस् - उदाहरणको लागि, होम डाइरेक्टरीमा *transformers-course* नामको नयाँ फोल्डर:                                                                                                                      

```
mkdir ~/transformers-course
cd ~/transformers-course                                                                                                                                                               
```


यो डाइरेक्टरीभित्र, Python को `venv` मोड्युल प्रयोग गरेर भर्चुअल इन्भाइरोमेन्ट बनाउनुहोस्:                                                                                                                                                 

```
python -m venv .env                                                                                                                                                                                                
```


अब तपाईंको खाली फोल्डरमा *.env* नामको डाइरेक्टरी हुनुपर्छ:                                                                                                                                                                         

```
ls -a                                                                                                                                                                                                              
```


```out                                                                                                                                                                                                           
.      ..    .env                                                                                                                                                                                                 
```                                                                                                                                                                                                                 

तपाईं activate र deactivate स्क्रिप्टहरू प्रयोग गरेर भर्चुअल इन्भाइरोमेन्टमा प्रवेश र बाहिर निस्कन सक्नुहुन्छ:                                                                                                                                 


```                                                                                                                                                                                    
# भर्चुअल इन्भाइरोमेन्ट सक्रिय गर्न     
source .env/bin/activate  

# भर्चुअल इन्भाइरोमेन्ट निष्क्रिय गर्न  
deactivate
```                                                                                                                                                                                                                  
                                                                                                                                                                                                              

इन्भाइरोमेन्ट सक्रिय भएको छ कि छैन जाँच गर्न `which python` कमाण्ड चलाउन सक्नुहुन्छ: यदि यसले भर्चुअल इन्भाइरोमेन्टतर्फ इंगित गर्छ भने, तपाईंले सफलतापूर्वक सक्रिय गर्नुभएको छ!                                                                                   

```                                                                                                                                                                                                                  
which python                                                                                                                                                                                                      
```                                                                                                                                                                                                                 

```out                                                                                                                                                                                                                  
/home/<user>/transformers-course/.env/bin/python                                                                                                                                                                  
```                                                                                                                                                                                                                   

### डिपेन्डेन्सीहरू इन्स्टल गर्ने                                                                                  

अघिल्लो Google Colab खण्डमा जस्तै, अब तपाईंले आवश्यक प्याकेजहरू इन्स्टल गर्नुपर्छ। फेरि पनि, pip प्याकेज म्यानेजर प्रयोग गरेर 🤗 Transformers को डेभलपमेन्ट भर्जन इन्स्टल गर्न सक्नुहुन्छ:                                                                     
```                                                                                                                                                                                  
pip install "transformers[sentencepiece]"                                                                                                                                                                         
```                                                                                                                                                                                                                 
अब तपाईंको सेटअप पूरा भयो र तपाईं अगाडि बढ्न तयार हुनुहुन्छ!  


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ne/chapter0/1.mdx" />