# Usando modelos pré-treinados

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter4/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter4/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter4/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter4/section2_tf.ipynb"},
]} />

{/if}

O Model Hub torna simples a seleção do modelo apropriado, de modo que o uso em qualquer biblioteca pode ser feito em algumas linhas de código. Vamos dar uma olhada em como realmente usar um desses modelos, e como contribuir de volta à comunidade.

Digamos que estamos à procura de um modelo baseado na língua francesa que possa realizar o enchimento de máscara.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif" alt="Selecting the Camembert model." width="80%"/>
</div>

Selecionamos o checkpoint `camembert-base` para experimentá-lo. O identificador `camembert-base` é tudo o que precisamos para começar a utilizá-lo! Como você já viu nos capítulos anteriores, podemos instanciá-lo utilizando a função `pipeline()`:

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'}, 
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'}, 
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'}, 
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'}, 
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

Como você pode ver, carregar um modelo dentro de um pipeline é extremamente simples. A única coisa que você precisa estar atento é que o checkpoint escolhido é adequado para a tarefa para a qual ele será utilizado. Por exemplo, aqui estamos carregando o checkpoint `camembert-base` no pipeline `fill-mask`, o que é completamente bom. Mas se carregássemos este checkpoint no pipeline de `text-classification`, os resultados não fariam sentido porque a head da `camembert-base` não é adequado para esta tarefa! Recomendamos a utilização do seletor de tarefas na interface do Hub de abraço facial a fim de selecionar os checkpoints apropriados:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png" alt="The task selector on the web interface." width="80%"/>
</div>

Você também pode instanciar o checkpoint usando diretamente a arquitetura modelo:

{#if fw === 'pt'}
```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

No entanto, recomendamos a utilização das classes [`Auto*`](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes), pois estas são por arquitetura de projeto - agnóstica. Enquanto a amostra de código anterior limita os usuários a checkpoint carregáveis na arquitetura CamemBERT, a utilização das classes `Auto*` torna a troca de checkpoint simples:

```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```
{:else}
```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

No entanto, recomendamos a utilização das classes [`TFAuto*`](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes), pois estas são por arquitetura de projeto - agnóstica. Enquanto a amostra de código anterior limita os usuários a checkpoint carregáveis na arquitetura CamemBERT, a utilização das classes `TFAuto*` torna a troca de checkpoint simples:


```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```
{/if}

<Tip>
Ao utilizar um modelo pré-treinado, certifique-se de verificar como ele foi treinado, em quais datasets, seus limites e seus enviesamentos. Todas estas informações devem ser indicadas em seu modelo de cartão.
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter4/2.mdx" />