# E se o meu dataset não estiver no Hub?

<CourseFloatingBanner chapter={5}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter5/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter5/section2.ipynb"},
]} />

Você sabe como usar o [Hugging Face Hub](https://huggingface.co/datasets) para baixar conjuntos de dados (**datasets**), mas muitas vezes você se encontrará trabalhando com dados que são armazenados em seu laptop ou em um servidor remoto. Nesta seção mostraremos como 🤗 Datasets podem ser usados para carregar conjuntos de dados que não estão disponíveis no Hugging Face Hub.

<Youtube id="HyQgpJTkRdE"/>

## Trabalhando com datasets locais e remotos


🤗 Datasets fornece scripts de carregamento para lidar com o carregamento de conjuntos de dados locais e remotos. Ele suporta vários formatos de dados comuns, como por exemplo:

|    Formato do dato  | script de carregamento |                         Exemplo                         |
| :----------------: | :------------: | :-----------------------------------------------------: |
|     CSV & TSV      |     `csv`      |     `load_dataset("csv", data_files="my_file.csv")`     |
|     Text files     |     `text`     |    `load_dataset("text", data_files="my_file.txt")`     |
| JSON & JSON Lines  |     `json`     |   `load_dataset("json", data_files="my_file.jsonl")`    |
| Pickled DataFrames |    `pandas`    | `load_dataset("pandas", data_files="my_dataframe.pkl")` |

Como mostrado na tabela, para cada formato de dados só precisamos especificar o tipo de script de carregamento na função `load_dataset()`, junto com um argumento `data_files` que especifica o caminho para um ou mais arquivos. Vamos começar carregando um conjunto de dados de arquivos locais; mais tarde veremos como fazer o mesmo com arquivos remotos.

## Carregando um conjunto de dados local

Para este exemplo usaremos o [SQuAD-it dataset] (https://github.com/crux82/squad-it/), que é um conjunto de dados em grande escala para resposta a perguntas em italiano.

As divisões de treinamento e testes são hospedadas no GitHub, para que possamos baixá-las com um simples comando `wget`:

```python
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-train.json.gz
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-test.json.gz
```

Isto irá baixar dois arquivos compactados chamados *SQuAD_it-train.json.gz* e *SQuAD_it-test.json.gz*, que podemos descomprimir com o comando Linux `gzip`:

```python
!gzip -dkv SQuAD_it-*.json.gz
```

```bash
SQuAD_it-test.json.gz:	   87.4% -- replaced with SQuAD_it-test.json
SQuAD_it-train.json.gz:	   82.2% -- replaced with SQuAD_it-train.json
```

Podemos ver que os arquivos compactados foram substituídos por _SQuAD_it-train.json_ e _SQuAD_it-text.json_, e que os dados são armazenados no formato JSON.

<Tip>

✎ Se você está se perguntando por que há um `!` nos comandos shell acima, é porque estamos executando-os dentro de um Jupyter notebook. Basta remover o prefixo se você quiser baixar e descompactar o conjunto de dados dentro de um terminal.
</Tip>

Para carregar um arquivo JSON com a função `load_dataset()`, só precisamos saber se estamos lidando com o JSON comum (semelhante a um dicionário aninhado) ou Linhas JSON (JSON line-separated JSON). Como muitos conjuntos de dados que respondem a perguntas, o SQuAD utiliza o formato aninhado, com todo o texto armazenado em um campo `data`. Isto significa que podemos carregar o conjunto de dados especificando o argumento  `field` da seguinte forma:

```py
from datasets import load_dataset

squad_it_dataset = load_dataset("json", data_files="SQuAD_it-train.json", field="data")
```

Por padrão, o carregamento de arquivos locais cria um objeto `DatasetDict` com uma divisão de treino (train). Podemos ver isso inspecionando o objeto `squad_it_dataset`:

```py
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
})
```

Isto nos mostra o número de linhas e os nomes das colunas associadas ao conjunto de treinamento. Podemos ver um dos exemplos, indexando na divisão de treino da seguinte forma:

```py
squad_it_dataset["train"][0]
```

```python out
{
    "title": "Terremoto del Sichuan del 2008",
    "paragraphs": [
        {
            "context": "Il terremoto del Sichuan del 2008 o il terremoto...",
            "qas": [
                {
                    "answers": [{"answer_start": 29, "text": "2008"}],
                    "id": "56cdca7862d2951400fa6826",
                    "question": "In quale anno si è verificato il terremoto nel Sichuan?",
                },
                ...
            ],
        },
        ...
    ],
}
```

Ótimo, nós carregamos nosso primeiro conjunto de dados local! Mas enquanto isso funcionou para o conjunto de treinamento, o que realmente queremos é incluir tanto o conjunto de `treino` quanto o de `teste` divididos em um único objeto `DatasetDict` para que possamos aplicar as funções `Dataset.map()` em ambas as divisões de uma só vez. Para fazer isso, podemos fornecer um dicionário para o argumento `data_files` que mapeia cada nome de divisão para um arquivo associado a essa divisão:


```py
data_files = {"train": "SQuAD_it-train.json", "test": "SQuAD_it-test.json"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
    test: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 48
    })
})
```

Isto é exatamente o que queríamos. Agora, podemos aplicar várias técnicas de pré-processamento para limpar os dados, assinalar as revisões, e assim por diante.


<Tip>

O argumento `data_files` da função `load_dataset()` é bastante flexível e pode ser um único caminho de arquivo ou uma lista de caminhos de arquivo, ou um dicionário que mapeia nomes divididos para caminhos de arquivo. Você também pode incluir arquivos que correspondam a um padrão especificado de acordo com as regras utilizadas pela Unix shell (por exemplo, você pode adicionar todos os arquivos JSON em um diretório como uma única divisão, definindo `data_files="*.json"`). Consulte a [documentação](https://huggingface.co/docs/datasets/loading#local-and-remote-files) do 🤗 Datasets para obter mais detalhes.

</Tip>

Os scripts de carregamento em 🤗 Datasets realmente suportam a descompressão automática dos arquivos de entrada, então poderíamos ter pulado o uso do `gzip` ao apontar o argumento `data_files` diretamente para os arquivos compactados:

```py
data_files = {"train": "SQuAD_it-train.json.gz", "test": "SQuAD_it-test.json.gz"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Isto pode ser útil se você não quiser descomprimir manualmente muitos arquivos GZIP. A descompressão automática também se aplica a outros formatos comuns como ZIP e TAR, então você só precisa apontar `data_files` para os arquivos compactados e está pronto para seguir em frente!

Agora que você sabe como carregar arquivos locais em seu laptop ou desktop, vamos dar uma olhada no carregamento de arquivos remotos.

## Carregando um dataset remoto

Se você estiver trabalhando como cientista de dados ou programador em uma empresa, há uma boa chance de que os conjuntos de dados que você deseja analisar estejam armazenados em algum servidor remoto. Felizmente, o carregamento de arquivos remotos é tão simples quanto o carregamento de arquivos locais! Em vez de fornecer um caminho para arquivos locais, apontamos o argumento `data_files` de `load_dataset()` para uma ou mais URLs onde os arquivos remotos são armazenados. Por exemplo, para o conjunto de dados SQuAD-it hospedado no GitHub, podemos apenas apontar `data_files` para as URLs _SQuAD_it-*.json.gz_ da seguinte maneira:

```py
url = "https://github.com/crux82/squad-it/raw/master/"
data_files = {
    "train": url + "SQuAD_it-train.json.gz",
    "test": url + "SQuAD_it-test.json.gz",
}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Isto retorna o mesmo objeto `DatasetDict` obtido anteriormente, mas nos poupa o passo de baixar e descomprimir manualmente os arquivos _SQuAD_it-*.json.gz_. Isto envolve nas várias formas de carregar conjuntos de dados que não estão hospedados no Hugging Face Hub. Agora que temos um conjunto de dados para brincar, vamos sujar as mãos com várias técnicas de manipulação de dados!

<Tip>
✏️ **Tente fazer isso!** Escolha outro conjunto de dados hospedado no GitHub ou no [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/index.php) e tente carregá-lo tanto local como remotamente usando as técnicas introduzidas acima. Para pontos bônus, tente carregar um conjunto de dados que esteja armazenado em formato CSV ou texto (veja a [documentação](https://huggingface.co/docs/datasets/loading#local-and-remote-files) para mais informações sobre estes formatos).
</Tip>




<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter5/2.mdx" />