import{s as Rl,a as il,o as Zl,n as Vl}from"../chunks/scheduler.893fe8c9.js";import{S as Ql,i as kl,e as i,s as n,c as M,h as vl,a as p,d as t,b as s,f as oe,g as m,j as r,k as c,l as Wl,m as a,n as u,t as o,o as y,p as w}from"../chunks/index.6ee278c6.js";import{T as Xl}from"../chunks/Tip.eab0255c.js";import{C as _l,H as C,E as xl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea3ad860.js";import{C as ce}from"../chunks/CodeBlock.8bdd5f33.js";function Sl(ye){let J,b='Acest capitol este destinat începătorilor TRL. Dacă ești deja familiar cu TRL, ai putea de asemenea să consulți <a href="https://github.com/huggingface/open-r1/blob/main/src/open_r1/grpo.py" rel="nofollow">implementarea Open R1</a> a GRPO.';return{c(){J=i("p"),J.innerHTML=b},l(T){J=p(T,"P",{"data-svelte-h":!0}),r(J)!=="svelte-4m2s3v"&&(J.innerHTML=b)},m(T,me){a(T,J,me)},p:Vl,d(T){T&&t(J)}}}function Nl(ye){let J,b,T,me,I,we,h,Je,B,pl="În această pagină, vom învăța cum să implementăm Optimizarea Relativă a Politicii de Grup (GRPO) folosind biblioteca Transformer Reinforcement Learning (TRL). Ne vom concentra pe implementarea practică cu cod minimal.",Ue,g,rl="Vom explora conceptele centrale ale GRPO așa cum sunt întruchipate în GRPOTrainer din TRL, folosind fragmente din documentația oficială TRL pentru a ne ghida.",je,f,de,G,Ml="În primul rând, să ne reamintim unele dintre conceptele importante ale algoritmului GRPO:",Te,z,ml="<li>Formarea Grupului: Modelul generează multiple completări pentru fiecare prompt.</li> <li>Învățarea Preferințelor: Modelul învață dintr-o funcție de recompensă care compară grupuri de completări.</li> <li>Configurația Antrenamentului: Modelul folosește o configurație pentru a controla procesul de antrenare.</li>",Ce,A,cl="Ce trebuie să facem pentru a implementa GRPO?",fe,$,ul="<li>Să definim un set de date de prompt-uri.</li> <li>Să definim o funcție de recompensă care ia o listă de completări și returnează o listă de recompense.</li> <li>Să configurăm procesul de antrenare cu un GRPOConfig.</li> <li>Să antrenăm modelul folosind GRPOTrainer.</li>",be,R,ol="Iată un exemplu minimal pentru a începe antrenamentul GRPO:",Ie,Z,he,V,Be,Q,ge,k,yl="Setul tău de date ar trebui să conțină prompt-uri la care modelul va răspunde. Antrenorul GRPO va genera multiple completări pentru fiecare prompt și va folosi funcția de recompensă pentru a le compara.",Ge,v,ze,W,wl="Funcția de recompensă este crucială - determină cum învață modelul. Iată două exemple practice:",Ae,X,$e,_,Re,x,Jl="Parametrii cheie de considerat în <code>GRPOConfig</code>:",Ze,S,Ve,N,Ul="Parametrul <code>num_generation</code> este deosebit de important pentru GRPO deoarece definește dimensiunea grupului - câte completări diferite va genera modelul pentru fiecare prompt. Acesta este un diferențiator cheie de alte metode RL:",Qe,E,jl="<li>Prea mic (de exemplu, 2-3): S-ar putea să nu ofere suficientă diversitate pentru comparații semnificative</li> <li>Recomandat (4-16): Oferă un echilibru bun între diversitate și eficiența computațională</li> <li>Valori mai mari: Pot îmbunătăți învățarea dar cresc semnificativ costul computațional</li>",ke,F,dl="Dimensiunea grupului ar trebui aleasă în funcție de resursele tale computaționale și complexitatea sarcinii tale. Pentru sarcini simple, grupuri mai mici (4-8) pot fi suficiente, în timp ce sarcinile de raționament mai complexe ar putea beneficia de grupuri mai mari (8-16).",ve,Y,We,H,Tl="<li><strong>Gestionarea Memoriei</strong>: Ajustează <code>per_device_train_batch_size</code> și <code>gradient_accumulation_steps</code> în funcție de memoria GPU-ului tău.</li> <li><strong>Viteza</strong>: Activează <code>use_vllm=True</code> pentru generare mai rapidă dacă modelul tău este suportat.</li> <li><strong>Monitorizarea</strong>: Urmărește metricile înregistrate în timpul antrenamentului:<ul><li><code>reward</code>: Recompensa medie pe completări</li> <li><code>reward_std</code>: Deviația standard în cadrul grupurilor de recompense</li> <li><code>kl</code>: Divergența KL de la modelul de referință</li></ul></li>",Xe,D,_e,O,Cl="Lucrarea DeepSeek R1 demonstrează mai multe abordări eficiente pentru designul funcției de recompensă pe care le poți adapta pentru propria ta implementare GRPO:",xe,P,Se,L,fl="Una dintre cele mai ușoare recompense de implementat este o recompensă bazată pe lungime. Poți recompensa completări mai lungi:",Ne,q,Ee,K,bl="Această funcție de recompensă penalizează completările care sunt prea scurte sau prea lungi, încurajând modelul să genereze completări care sunt aproape de lungimea ideală de 20 de token-uri.",Fe,U,Il,Ye,ee,He,le,hl="Pentru sarcini cu răspunsuri obiectiv corecte (cum ar fi matematica sau codarea), poți implementa funcții de recompensă bazate pe reguli:",De,te,Oe,j,Bl,Pe,ae,Le,ne,gl="Poți de asemenea să recompensezi formatarea corespunzătoare, care a fost importantă în antrenamentul DeepSeek R1:",qe,se,Ke,d,Gl,el,ie,zl="Aceste exemple demonstrează cum poți implementa funcții de recompensă inspirate din procesul de antrenare DeepSeek R1, concentrându-se pe corectitudine, formatare și semnale combinate.",ll,pe,tl,re,Al="În următoarea secțiune, vei urma un exercițiu pentru a implementa GRPO în TRL.",al,Me,nl,ue,sl;return I=new _l({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new C({props:{title:"Implementarea GRPO în TRL",local:"implementarea-grpo-în-trl",headingTag:"h1"}}),f=new Xl({props:{$$slots:{default:[Sl]},$$scope:{ctx:ye}}}),Z=new ce({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9UcmFpbmVyJTJDJTIwR1JQT0NvbmZpZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMDEuJTIwJUMzJThFbmNhcmMlQzQlODMlMjBzZXR1bCUyMHQlQzQlODN1JTIwZGUlMjBkYXRlJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzZXR1bF90YXVfZGVfZGF0ZSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBJTIzJTIwMi4lMjBEZWZpbmUlQzglOTl0ZSUyMG8lMjBmdW5jJUM4JTlCaWUlMjBkZSUyMHJlY29tcGVucyVDNCU4MyUyMHNpbXBsJUM0JTgzJTBBZGVmJTIwcmV3YXJkX2Z1bmMoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJFeGVtcGx1JTNBJTIwUmVjb21wZW5zZWF6JUM0JTgzJTIwY29tcGxldCVDNCU4M3JpbGUlMjBtYWklMjBsdW5naSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QmZsb2F0KGxlbihjb21wbGV0aW9uKSklMjBmb3IlMjBjb21wbGV0aW9uJTIwaW4lMjBjb21wbGV0aW9ucyU1RCUwQSUwQSUwQSUyMyUyMDMuJTIwQ29uZmlndXJlYXolQzQlODMlMjBhbnRyZW5hbWVudHVsJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEEpJTBBJTBBJTIzJTIwNC4lMjBJbmklQzglOUJpYWxpemVheiVDNCU4MyUyMCVDOCU5OWklMjBhbnRyZW5lYXolQzQlODMlMEF0cmFpbmVyJTIwJTNEJTIwR1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJtb2RlbHVsX3RhdSUyMiUyQyUyMCUyMCUyMyUyMGRlJTIwZXhlbXBsdSUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mdW5jcyUzRHJld2FyZF9mdW5jJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOTrainer, GRPOConfig
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 1. Încarcă setul tău de date</span>
dataset = load_dataset(<span class="hljs-string">&quot;setul_tau_de_date&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-comment"># 2. Definește o funcție de recompensă simplă</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_func</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Exemplu: Recompensează completările mai lungi&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># 3. Configurează antrenamentul</span>
training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    logging_steps=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># 4. Inițializează și antrenează</span>
trainer = GRPOTrainer(
    model=<span class="hljs-string">&quot;modelul_tau&quot;</span>,  <span class="hljs-comment"># de exemplu &quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>
    args=training_args,
    train_dataset=dataset,
    reward_funcs=reward_func,
)
trainer.train()`,wrap:!1}}),V=new C({props:{title:"Componentele Cheie",local:"componentele-cheie",headingTag:"h2"}}),Q=new C({props:{title:"1. Formatul Setului de Date",local:"1-formatul-setului-de-date",headingTag:"h3"}}),v=new C({props:{title:"2. Funcția de Recompensă",local:"2-funcția-de-recompensă",headingTag:"h3"}}),X=new ce({props:{code:"JTIzJTIwRXhlbXBsdWwlMjAxJTNBJTIwUmVjb21wZW5zJUM0JTgzJTIwYmF6YXQlQzQlODMlMjBwZSUyMGx1bmdpbWVhJTIwY29tcGxldCVDNCU4M3JpaSUwQWRlZiUyMHJld2FyZF9sZW5ndGgoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjBFeGVtcGx1bCUyMDIlM0ElMjBSZWNvbXBlbnMlQzQlODMlMjBiYXphdCVDNCU4MyUyMHBlJTIwcG90cml2aXJlYSUyMHVudWklMjBtb2RlbCUwQWltcG9ydCUyMHJlJTBBJTBBJTBBZGVmJTIwcmV3YXJkX2Zvcm1hdChjb21wbGV0aW9ucyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHBhdHRlcm4lMjAlM0QlMjByJTIyJTVFJTNDdGhpbmslM0UuKiUzRiUzQyUyRnRoaW5rJTNFJTNDYW5zd2VyJTNFLiolM0YlM0MlMkZhbnN3ZXIlM0UlMjQlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIxLjAlMjBpZiUyMHJlLm1hdGNoKHBhdHRlcm4lMkMlMjBjKSUyMGVsc2UlMjAwLjAlMjBmb3IlMjBjJTIwaW4lMjBjb21wbGV0aW9ucyU1RA==",highlighted:`<span class="hljs-comment"># Exemplul 1: Recompensă bazată pe lungimea completării</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_length</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># Exemplul 2: Recompensă bazată pe potrivirea unui model</span>
<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_format</span>(<span class="hljs-params">completions, **kwargs</span>):
    pattern = <span class="hljs-string">r&quot;^&lt;think&gt;.*?&lt;/think&gt;&lt;answer&gt;.*?&lt;/answer&gt;$&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> re.<span class="hljs-keyword">match</span>(pattern, c) <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),_=new C({props:{title:"3. Configurația Antrenamentului",local:"3-configurația-antrenamentului",headingTag:"h3"}}),S=new ce({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGFyYW1ldHJpaSUyMGVzZW4lQzglOUJpYWxpJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2dlbmVyYXRpb24lM0Q0JTJDJTIwJTIwJTIzJTIwTnVtJUM0JTgzcnVsJTIwZGUlMjBjb21wbGV0JUM0JTgzcmklMjBkZSUyMGdlbmVyYXQlMjBwZW50cnUlMjBmaWVjYXJlJTIwcHJvbXB0JTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUyMCUyMCUyMyUyMFZyZW0lMjBzJUM0JTgzJTIwb2IlQzglOUJpbmVtJTIwdG9hdGUlMjBnZW5lciVDNCU4M3JpbGUlMjAlQzMlQUVudHItdW4lMjBsb3QlMjBkZSUyMGRpc3Bveml0aXYlMEElMjAlMjAlMjAlMjAlMjMlMjBPcCVDOCU5QmlvbmFsJTIwZGFyJTIwdXRpbCUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFNwZWNpZmljJTIwR1JQTyUyMChvcCVDOCU5QmlvbmFsKSUwQSUyMCUyMCUyMCUyMHVzZV92bGxtJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMEFjY2VsZXJlYXolQzQlODMlMjBnZW5lcmFyZWElMEEp",highlighted:`training_args = GRPOConfig(
    <span class="hljs-comment"># Parametrii esențiali</span>
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    num_generation=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Numărul de completări de generat pentru fiecare prompt</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Vrem să obținem toate generările într-un lot de dispozitiv</span>
    <span class="hljs-comment"># Opțional dar util</span>
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    <span class="hljs-comment"># Specific GRPO (opțional)</span>
    use_vllm=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Accelerează generarea</span>
)`,wrap:!1}}),Y=new C({props:{title:"Sfaturi pentru Succes",local:"sfaturi-pentru-succes",headingTag:"h2"}}),D=new C({props:{title:"Designul Funcției de Recompensă",local:"designul-funcției-de-recompensă",headingTag:"h2"}}),P=new C({props:{title:"1. Recompense Bazate pe Lungime",local:"1-recompense-bazate-pe-lungime",headingTag:"h3"}}),q=new ce({props:{code:"ZGVmJTIwcmV3YXJkX2xlbihjb21wbGV0aW9ucyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMGlkZWFsX2xlbmd0aCUyMCUzRCUyMDIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCLWFicyhpZGVhbF9sZW5ndGglMjAtJTIwbGVuKGNvbXBsZXRpb24pKSUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_len</span>(<span class="hljs-params">completions, **kwargs</span>):
    ideal_length = <span class="hljs-number">20</span>
    <span class="hljs-keyword">return</span> [-<span class="hljs-built_in">abs</span>(ideal_length - <span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),ee=new C({props:{title:"2. Recompense Bazate pe Reguli pentru Sarcini Verificabile",local:"2-recompense-bazate-pe-reguli-pentru-sarcini-verificabile",headingTag:"h2"}}),te=new ce({props:{code:"ZGVmJTIwcHJvYmxlbV9yZXdhcmQoY29tcGxldGlvbnMlMkMlMjBhbnN3ZXJzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRnVuYyVDOCU5QmllJTIwZGUlMjByZWNvbXBlbnMlQzQlODMlMjBwZW50cnUlMjBwcm9ibGVtZSUyMGRlJTIwbWF0ZW1hdGljJUM0JTgzJTIwY3UlMjByJUM0JTgzc3B1bnN1cmklMjB2ZXJpZmljYWJpbGUlMEElMjAlMjAlMjAlMjBjb21wbGV0aW9ucyUzQSUyMGxpc3RhJTIwZGUlMjBjb21wbGV0JUM0JTgzcmklMjBkZSUyMGV2YWx1YXQlMEElMjAlMjAlMjAlMjBhbnN3ZXJzJTNBJTIwbGlzdGElMjBkZSUyMHIlQzQlODNzcHVuc3VyaSUyMGxhJTIwcHJvYmxlbWVsZSUyMGRpbiUyMHNldHVsJTIwZGUlMjBkYXRlJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwcmV3YXJkcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGNvbXBsZXRpb24lMkMlMjBjb3JyZWN0X2Fuc3dlciUyMGluJTIwemlwKGNvbXBsZXRpb25zJTJDJTIwYW5zd2VycyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWdlJTIwciVDNCU4M3NwdW5zdWwlMjBkaW4lMjBjb21wbGV0YXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWNlc3RhJTIwZXN0ZSUyMHVuJTIwZXhlbXBsdSUyMHNpbXBsaWZpY2F0JTIwLSUyMGFpJTIwYXZlYSUyMG5ldm9pZSUyMGRlJTIwcGFyc2luZyUyMGNvcmVzcHVueiVDNCU4M3RvciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlciUyMCUzRCUyMGV4dHJhY3RfZmluYWxfYW5zd2VyKGNvbXBsZXRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVjb21wZW5zJUM0JTgzJTIwYmluYXIlQzQlODMlM0ElMjAxJTIwcGVudHJ1JTIwY29yZWN0JTJDJTIwMCUyMHBlbnRydSUyMGluY29yZWN0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkJTIwJTNEJTIwMS4wJTIwaWYlMjBhbnN3ZXIlMjAlM0QlM0QlMjBjb3JyZWN0X2Fuc3dlciUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXdhcmRzLmFwcGVuZChyZXdhcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGFjJUM0JTgzJTIwbnUlMjBwdXRlbSUyMHBhcnNhJTIwdW4lMjByJUM0JTgzc3B1bnMlMkMlMjBkJUM0JTgzbSUyMG8lMjByZWNvbXBlbnMlQzQlODMlMjBtaWMlQzQlODMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXdhcmRzLmFwcGVuZCgwLjApJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmV3YXJkcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">problem_reward</span>(<span class="hljs-params">completions, answers, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Funcție de recompensă pentru probleme de matematică cu răspunsuri verificabile
    completions: lista de completări de evaluat
    answers: lista de răspunsuri la problemele din setul de date
    &quot;&quot;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion, correct_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(completions, answers):
        <span class="hljs-comment"># Extrage răspunsul din completare</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># Acesta este un exemplu simplificat - ai avea nevoie de parsing corespunzător</span>
            answer = extract_final_answer(completion)
            <span class="hljs-comment"># Recompensă binară: 1 pentru corect, 0 pentru incorect</span>
            reward = <span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> answer == correct_answer <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>
            rewards.append(reward)
        <span class="hljs-keyword">except</span>:
            <span class="hljs-comment"># Dacă nu putem parsa un răspuns, dăm o recompensă mică</span>
            rewards.append(<span class="hljs-number">0.0</span>)

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),ae=new C({props:{title:"3. Recompense Bazate pe Format",local:"3-recompense-bazate-pe-format",headingTag:"h2"}}),se=new ce({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_reward</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Recompensează completările care urmează formatul dorit&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Exemplu: Verifică dacă completarea urmează un format gândește-apoi-răspunde</span>
    pattern = <span class="hljs-string">r&quot;&lt;think&gt;(.*?)&lt;/think&gt;\\s*&lt;answer&gt;(.*?)&lt;/answer&gt;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        <span class="hljs-keyword">match</span> = re.search(pattern, completion, re.DOTALL)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span>:
            <span class="hljs-comment"># Verifică dacă există conținut substanțial în ambele secțiuni</span>
            think_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">1</span>).strip()
            answer_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">2</span>).strip()

            <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(think_content) &gt; <span class="hljs-number">20</span> <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(answer_content) &gt; <span class="hljs-number">0</span>:
                rewards.append(<span class="hljs-number">1.0</span>)
            <span class="hljs-keyword">else</span>:
                rewards.append(
                    <span class="hljs-number">0.5</span>
                )  <span class="hljs-comment"># Recompensă parțială pentru format corect dar conținut limitat</span>
        <span class="hljs-keyword">else</span>:
            rewards.append(<span class="hljs-number">0.0</span>)  <span class="hljs-comment"># Nicio recompensă pentru format incorect</span>

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),pe=new C({props:{title:"Asta e tot!",local:"asta-e-tot",headingTag:"h2"}}),Me=new xl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ro/chapter12/4.mdx"}}),{c(){J=i("meta"),b=n(),T=i("p"),me=n(),M(I.$$.fragment),we=n(),M(h.$$.fragment),Je=n(),B=i("p"),B.textContent=pl,Ue=n(),g=i("p"),g.textContent=rl,je=n(),M(f.$$.fragment),de=n(),G=i("p"),G.textContent=Ml,Te=n(),z=i("ul"),z.innerHTML=ml,Ce=n(),A=i("p"),A.textContent=cl,fe=n(),$=i("ul"),$.innerHTML=ul,be=n(),R=i("p"),R.textContent=ol,Ie=n(),M(Z.$$.fragment),he=n(),M(V.$$.fragment),Be=n(),M(Q.$$.fragment),ge=n(),k=i("p"),k.textContent=yl,Ge=n(),M(v.$$.fragment),ze=n(),W=i("p"),W.textContent=wl,Ae=n(),M(X.$$.fragment),$e=n(),M(_.$$.fragment),Re=n(),x=i("p"),x.innerHTML=Jl,Ze=n(),M(S.$$.fragment),Ve=n(),N=i("p"),N.innerHTML=Ul,Qe=n(),E=i("ul"),E.innerHTML=jl,ke=n(),F=i("p"),F.textContent=dl,ve=n(),M(Y.$$.fragment),We=n(),H=i("ol"),H.innerHTML=Tl,Xe=n(),M(D.$$.fragment),_e=n(),O=i("p"),O.textContent=Cl,xe=n(),M(P.$$.fragment),Se=n(),L=i("p"),L.textContent=fl,Ne=n(),M(q.$$.fragment),Ee=n(),K=i("p"),K.textContent=bl,Fe=n(),U=i("iframe"),Ye=n(),M(ee.$$.fragment),He=n(),le=i("p"),le.textContent=hl,De=n(),M(te.$$.fragment),Oe=n(),j=i("iframe"),Pe=n(),M(ae.$$.fragment),Le=n(),ne=i("p"),ne.textContent=gl,qe=n(),M(se.$$.fragment),Ke=n(),d=i("iframe"),el=n(),ie=i("p"),ie.textContent=zl,ll=n(),M(pe.$$.fragment),tl=n(),re=i("p"),re.textContent=Al,al=n(),M(Me.$$.fragment),nl=n(),ue=i("p"),this.h()},l(e){const l=vl("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(t),b=s(e),T=p(e,"P",{}),oe(T).forEach(t),me=s(e),m(I.$$.fragment,e),we=s(e),m(h.$$.fragment,e),Je=s(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1293vxv"&&(B.textContent=pl),Ue=s(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-na6ewk"&&(g.textContent=rl),je=s(e),m(f.$$.fragment,e),de=s(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1kpbqds"&&(G.textContent=Ml),Te=s(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-ez6ot5"&&(z.innerHTML=ml),Ce=s(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1a3xk8g"&&(A.textContent=cl),fe=s(e),$=p(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-xpn84y"&&($.innerHTML=ul),be=s(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-f204iz"&&(R.textContent=ol),Ie=s(e),m(Z.$$.fragment,e),he=s(e),m(V.$$.fragment,e),Be=s(e),m(Q.$$.fragment,e),ge=s(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-j8bpdm"&&(k.textContent=yl),Ge=s(e),m(v.$$.fragment,e),ze=s(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-iw81bf"&&(W.textContent=wl),Ae=s(e),m(X.$$.fragment,e),$e=s(e),m(_.$$.fragment,e),Re=s(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1cxbitg"&&(x.innerHTML=Jl),Ze=s(e),m(S.$$.fragment,e),Ve=s(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-zu7ra"&&(N.innerHTML=Ul),Qe=s(e),E=p(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1al5l6o"&&(E.innerHTML=jl),ke=s(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1rh1v9n"&&(F.textContent=dl),ve=s(e),m(Y.$$.fragment,e),We=s(e),H=p(e,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-db4915"&&(H.innerHTML=Tl),Xe=s(e),m(D.$$.fragment,e),_e=s(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6gbmmo"&&(O.textContent=Cl),xe=s(e),m(P.$$.fragment,e),Se=s(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-18bht15"&&(L.textContent=fl),Ne=s(e),m(q.$$.fragment,e),Ee=s(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1xyrfe1"&&(K.textContent=bl),Fe=s(e),U=p(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),oe(U).forEach(t),Ye=s(e),m(ee.$$.fragment,e),He=s(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-11f5ljd"&&(le.textContent=hl),De=s(e),m(te.$$.fragment,e),Oe=s(e),j=p(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),oe(j).forEach(t),Pe=s(e),m(ae.$$.fragment,e),Le=s(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-15alen6"&&(ne.textContent=gl),qe=s(e),m(se.$$.fragment,e),Ke=s(e),d=p(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),oe(d).forEach(t),el=s(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-5dp67z"&&(ie.textContent=zl),ll=s(e),m(pe.$$.fragment,e),tl=s(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-11kcv9w"&&(re.textContent=Al),al=s(e),m(Me.$$.fragment,e),nl=s(e),ue=p(e,"P",{}),oe(ue).forEach(t),this.h()},h(){c(J,"name","hf:doc:metadata"),c(J,"content",El),il(U.src,Il="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_length.py&embed=true&show-chrome=false")||c(U,"src",Il),c(U,"title","Marimo Notebook"),c(U,"width","100%"),c(U,"height","800px"),c(U,"frameborder","0"),c(U,"allow","clipboard-write"),il(j.src,Bl="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_math.py&embed=true&show-chrome=false")||c(j,"src",Bl),c(j,"title","Marimo Notebook"),c(j,"width","100%"),c(j,"height","800px"),c(j,"frameborder","0"),c(j,"allow","clipboard-write"),il(d.src,Gl="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_format.py&embed=true&show-chrome=false")||c(d,"src",Gl),c(d,"title","Marimo Notebook"),c(d,"width","100%"),c(d,"height","800px"),c(d,"frameborder","0"),c(d,"allow","clipboard-write")},m(e,l){Wl(document.head,J),a(e,b,l),a(e,T,l),a(e,me,l),u(I,e,l),a(e,we,l),u(h,e,l),a(e,Je,l),a(e,B,l),a(e,Ue,l),a(e,g,l),a(e,je,l),u(f,e,l),a(e,de,l),a(e,G,l),a(e,Te,l),a(e,z,l),a(e,Ce,l),a(e,A,l),a(e,fe,l),a(e,$,l),a(e,be,l),a(e,R,l),a(e,Ie,l),u(Z,e,l),a(e,he,l),u(V,e,l),a(e,Be,l),u(Q,e,l),a(e,ge,l),a(e,k,l),a(e,Ge,l),u(v,e,l),a(e,ze,l),a(e,W,l),a(e,Ae,l),u(X,e,l),a(e,$e,l),u(_,e,l),a(e,Re,l),a(e,x,l),a(e,Ze,l),u(S,e,l),a(e,Ve,l),a(e,N,l),a(e,Qe,l),a(e,E,l),a(e,ke,l),a(e,F,l),a(e,ve,l),u(Y,e,l),a(e,We,l),a(e,H,l),a(e,Xe,l),u(D,e,l),a(e,_e,l),a(e,O,l),a(e,xe,l),u(P,e,l),a(e,Se,l),a(e,L,l),a(e,Ne,l),u(q,e,l),a(e,Ee,l),a(e,K,l),a(e,Fe,l),a(e,U,l),a(e,Ye,l),u(ee,e,l),a(e,He,l),a(e,le,l),a(e,De,l),u(te,e,l),a(e,Oe,l),a(e,j,l),a(e,Pe,l),u(ae,e,l),a(e,Le,l),a(e,ne,l),a(e,qe,l),u(se,e,l),a(e,Ke,l),a(e,d,l),a(e,el,l),a(e,ie,l),a(e,ll,l),u(pe,e,l),a(e,tl,l),a(e,re,l),a(e,al,l),u(Me,e,l),a(e,nl,l),a(e,ue,l),sl=!0},p(e,[l]){const $l={};l&2&&($l.$$scope={dirty:l,ctx:e}),f.$set($l)},i(e){sl||(o(I.$$.fragment,e),o(h.$$.fragment,e),o(f.$$.fragment,e),o(Z.$$.fragment,e),o(V.$$.fragment,e),o(Q.$$.fragment,e),o(v.$$.fragment,e),o(X.$$.fragment,e),o(_.$$.fragment,e),o(S.$$.fragment,e),o(Y.$$.fragment,e),o(D.$$.fragment,e),o(P.$$.fragment,e),o(q.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(ae.$$.fragment,e),o(se.$$.fragment,e),o(pe.$$.fragment,e),o(Me.$$.fragment,e),sl=!0)},o(e){y(I.$$.fragment,e),y(h.$$.fragment,e),y(f.$$.fragment,e),y(Z.$$.fragment,e),y(V.$$.fragment,e),y(Q.$$.fragment,e),y(v.$$.fragment,e),y(X.$$.fragment,e),y(_.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),sl=!1},d(e){e&&(t(b),t(T),t(me),t(we),t(Je),t(B),t(Ue),t(g),t(je),t(de),t(G),t(Te),t(z),t(Ce),t(A),t(fe),t($),t(be),t(R),t(Ie),t(he),t(Be),t(ge),t(k),t(Ge),t(ze),t(W),t(Ae),t($e),t(Re),t(x),t(Ze),t(Ve),t(N),t(Qe),t(E),t(ke),t(F),t(ve),t(We),t(H),t(Xe),t(_e),t(O),t(xe),t(Se),t(L),t(Ne),t(Ee),t(K),t(Fe),t(U),t(Ye),t(He),t(le),t(De),t(Oe),t(j),t(Pe),t(Le),t(ne),t(qe),t(Ke),t(d),t(el),t(ie),t(ll),t(tl),t(re),t(al),t(nl),t(ue)),t(J),w(I,e),w(h,e),w(f,e),w(Z,e),w(V,e),w(Q,e),w(v,e),w(X,e),w(_,e),w(S,e),w(Y,e),w(D,e),w(P,e),w(q,e),w(ee,e),w(te,e),w(ae,e),w(se,e),w(pe,e),w(Me,e)}}}const El='{"title":"Implementarea GRPO în TRL","local":"implementarea-grpo-în-trl","sections":[{"title":"Componentele Cheie","local":"componentele-cheie","sections":[{"title":"1. Formatul Setului de Date","local":"1-formatul-setului-de-date","sections":[],"depth":3},{"title":"2. Funcția de Recompensă","local":"2-funcția-de-recompensă","sections":[],"depth":3},{"title":"3. Configurația Antrenamentului","local":"3-configurația-antrenamentului","sections":[],"depth":3}],"depth":2},{"title":"Sfaturi pentru Succes","local":"sfaturi-pentru-succes","sections":[],"depth":2},{"title":"Designul Funcției de Recompensă","local":"designul-funcției-de-recompensă","sections":[{"title":"1. Recompense Bazate pe Lungime","local":"1-recompense-bazate-pe-lungime","sections":[],"depth":3}],"depth":2},{"title":"2. Recompense Bazate pe Reguli pentru Sarcini Verificabile","local":"2-recompense-bazate-pe-reguli-pentru-sarcini-verificabile","sections":[],"depth":2},{"title":"3. Recompense Bazate pe Format","local":"3-recompense-bazate-pe-format","sections":[],"depth":2},{"title":"Asta e tot!","local":"asta-e-tot","sections":[],"depth":2}],"depth":1}';function Fl(ye){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ll extends Ql{constructor(J){super(),kl(this,J,Fl,Nl,Rl,{})}}export{Ll as component};
