# Quiz de sfârșit de capitol[[test-de-sfârșit-de-capitol]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Acest capitol a acoperit o mulțime de subiecte! Nu vă faceți griji dacă nu ați înțeles toate detaliile; capitolele următoare vă vor ajuta să înțelegeți cum funcționează lucrurile în mecanismele lor interne.

Mai întâi, însă, să testăm ceea ce ați învățat în acest capitol!


### 1. Explorați Hub-ul și căutați checkpoint-ul `roberta-large-mnli`. Ce sarcină îndeplinește acesta?


<Question
	choices={[
		{
			text: "Sumarizare",
			explain: "Uitați-vă din nou pe pagina <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a>."
		},
		{
			text: "Clasificare de text",
			explain: "Mai precis, clasifică dacă două propoziții sunt legate logic folosind trei etichete (contradicție, neutru, implicație) — o sarcină numită și <em>inferență în limbaj natural</em>.",
			correct: true
		},
		{
			text: "Generare de text",
			explain: "Uitați-vă din nou pe pagina <a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli</a>."
		}
	]}
/>

### 2. Ce va returna următorul cod?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Va returna scoruri de clasificare pentru această propoziție, cu etichetele \"pozitiv\" sau \"negativ\".",
			explain: "Aceasta este incorect — acesta ar fi un pipeline de <code>sentiment-analysis</code>."
		},
		{
			text: "Va returna un text generat care completează această propoziție.",
			explain: "Aceasta este incorect — ar fi un pipeline de <code>text-generation</code>.",
		},
		{
			text: "Va returna cuvintele care reprezintă persoane, organizații sau locații.",
			explain: "În plus, cu <code>grouped_entities=True</code>, va grupa împreună cuvintele care aparțin aceleiași entități, precum \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. Ce ar trebui să înlocuiască ... în acest exemplu de cod?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "Aceasta este incorect. Verificați cardul modelului <code>bert-base-cased</code> și încercați să identificați greșeala."
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "Corect! Token-ul de mască al acestui model este [MASK].",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "Aceasta este incorect. Acest pipeline completează cuvinte mascate, deci are nevoie de un token de mască undeva."
		}
	]}
/>

### 4. De ce nu va funcționa acest cod?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "Acest pipeline necesită să fie furnizate etichete pentru a clasifica acest text.",
			explain: "Corect — codul corect trebuie să includă <code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "Acest pipeline necesită mai multe propoziții, nu doar una.",
			explain: "Aceasta este incorect, deși atunci când este utilizat corespunzător, acest pipeline poate primi o listă de propoziții de procesat (ca toate celelalte pipeline-uri)."
		},
		{
			text: "Biblioteca 🤗 Transformers este defectă, ca de obicei.",
			explain: "Nu vom onora acest răspuns cu un comentariu!"
		},
		{
			text: "Acest pipeline necesită intrări mai lungi; aceasta este prea scurtă.",
			explain: "Aceasta este incorect. Rețineți că un text foarte lung va fi trunchiat atunci când este procesat de acest pipeline."
		}
	]}
/>

### 5. Ce înseamnă „transfer learning"?

<Question
	choices={[
		{
			text: "Transferul cunoștințelor unui model preantrenat către un model nou prin antrenarea acestuia pe același set de date.",
			explain: "Nu, aceasta ar însemna două versiuni ale aceluiași model."
		},
		{
			text: "Transferul cunoștințelor unui model preantrenat către un model nou prin inițializarea celui de-al doilea model cu ponderile primului model.",
			explain: "Corect: când al doilea model este antrenat pe o nouă sarcină, acesta *transferă* cunoștințele primului model.",
			correct: true
		},
		{
			text: "Transferul cunoștințelor unui model preantrenat către un model nou prin construirea celui de-al doilea model cu aceeași arhitectură ca primul model.",
			explain: "Arhitectura este doar modul în care este construit modelul; nu există cunoștințe împărtășite sau transferate în acest caz."
		}
	]}
/>

### 6. Adevărat sau fals? De obicei, un model lingvistic nu are nevoie de etichete pentru preinstruire.

<Question
	choices={[
		{
			text: "Adevărat",
			explain: "Preantrenarea este de obicei <em>auto-supervizată</em>, ceea ce înseamnă că etichetele sunt create automat din intrări (cum ar fi prezicerea următorului cuvânt sau completarea unor cuvinte mascate).",
			correct: true
		},
		{
			text: "Fals",
			explain: "Incorect."
		}
	]}
/>

### 7. Selectați propoziția care descrie cel mai bine termenii „model", „arhitectură" și „greutăți".

<Question
	choices={[
		{
			text: "Dacă un model este o clădire, arhitectura sa este planul și greutățile sunt oamenii care locuiesc în interior.",
			explain: "Urmând această metaforă, greutățile ar fi cărămizile și alte materiale utilizate pentru construirea clădirii."
		},
		{
			text: "O arhitectură este o hartă pentru a construi un model, iar greutățile sale sunt orașele reprezentate pe hartă.",
			explain: "Problema cu această metaforă este că o hartă reprezintă de obicei o realitate existentă (există doar un singur oraș în Franța numit Paris). Pentru o arhitectură dată, sunt posibile multiple greutăți."
		},
		{
			text: "O arhitectură este o succesiune de funcții matematice pentru a construi un model, iar greutățile sale sunt parametrii acelor funcții.",
			explain: "Același set de funcții matematice (arhitectură) poate fi utilizat pentru a construi modele diferite prin utilizarea unor parametri diferiți (greutăți).",
			correct: true
		}
	]}
/>


### 8. Care dintre aceste tipuri de modele le-ați folosi pentru a completa prompt-urile cu text generat?

<Question
	choices={[
		{
			text: "Un model encoder",
			explain: "Un model encoder generează o reprezentare a întregii propoziții care este mai potrivită pentru sarcini precum clasificarea."
		},
		{
			text: "Un model decoder",
			explain: "Modelele decoder sunt perfect potrivite pentru generarea de text din prompt-uri.",
			correct: true
		},
		{
			text: "Un model sequence-to-sequence",
			explain: "Modelele sequence-to-sequence sunt mai potrivite pentru sarcini în care doriți să generați propoziții în relație cu propozițiile de intrare, nu cu un prompt dat."
		}
	]}
/>

### 9. Care dintre aceste tipuri de modele le-ați folosi pentru a rezuma texte?

<Question
	choices={[
		{
			text: "Un model encoder",
			explain: "Un model encoder generează o reprezentare a întregii propoziții care este mai potrivită pentru sarcini precum clasificarea."
		},
		{
			text: "Un model decoder",
			explain: "Modelele decoder sunt bune pentru generarea de text de ieșire (cum ar fi rezumatele), dar nu au capacitatea de a exploata un context precum întregul text de rezumat."
		},
		{
			text: "Un model sequence-to-sequence",
			explain: "Modelele sequence-to-sequence sunt perfect potrivite pentru o sarcină de sumarizare.",
			correct: true
		}
	]}
/>

### 10. Care dintre aceste tipuri de modele le-ați utiliza pentru a clasifica intrările de text în funcție de anumite etichete?

<Question
	choices={[
		{
			text: "Un model encoder",
			explain: "Un model encoder generează o reprezentare a întregii propoziții care este perfect potrivită pentru o sarcină precum clasificarea.",
			correct: true
		},
		{
			text: "Un model decoder",
			explain: "Modelele decoder sunt bune pentru generarea de texte de ieșire, nu pentru extragerea unei etichete dintr-o propoziție."
		},
		{
			text: "Un model sequence-to-sequence",
			explain: "Modelele sequence-to-sequence sunt mai potrivite pentru sarcini în care doriți să generați text bazat pe o propoziție de intrare, nu o etichetă.",
		}
	]}
/>

### 11. Ce sursă posibilă poate avea prejudecata observată într-un model?

<Question
	choices={[
		{
			text: "Modelul este o versiune fine-tuned a unui model preantrenat și a preluat prejudecata de la acesta.",
			explain: "Când aplicați Transfer Learning, prejudecata din modelul preantrenat utilizat persistă în modelul fine-tuned.",
			correct: true
		},
		{
			text: "Datele pe care a fost antrenat modelul sunt părtinitoare.",
			explain: "Aceasta este cea mai evidentă sursă de prejudecată, dar nu singura.",
			correct: true
		},
		{
			text: "Metrica pe care modelul o optimiza este părtinitoare.",
			explain: "O sursă mai puțin evidentă de prejudecată este modul în care modelul este antrenat. Modelul dvs. va optimiza orb pentru orice metrică ați ales, fără alte considerații.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter1/10.mdx" />