# Prejudecăți și limitări[[prejudecăți-și-limitări]]

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb"},
]} />

În cazul în care intenționați să utilizați un model preantrenat sau o versiune ajustată în producție, vă rugăm să fiți conștienți de faptul că, deși aceste modele sunt instrumente puternice, ele au anumite limitări. Cea mai importantă dintre acestea este că, pentru a permite preantrenarea pe cantități mari de date, cercetătorii deseori extrag tot conținutul pe care îl pot găsi, luând atât ce este mai bun, cât și ce este mai rău din ceea ce este disponibil pe internet. 

Pentru a oferi o ilustrare rapidă, să ne întoarcem la exemplul unui pipeline `fill-mask` cu modelul BERT:
```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

Atunci când i se cere să completeze cuvântul care lipsește din aceste două propoziții, modelul dă un singur răspuns fără gen (chelner/ chelneriță). Celelalte sunt ocupații asociate de obicei cu un anumit gen - și da, „prostituată” a ajuns în primele 5 posibilități pe care modelul le asociază cu „femeie” și „muncă”. Acest lucru se întâmplă chiar dacă BERT este unul dintre puținele modele Transformer care nu este construit prin extragerea de date de pe întregul internet, ci mai degrabă folosind date aparent neutre (este antrenat pe seturile de date [English Wikipedia](https://huggingface.co/datasets/wikipedia) și [BookCorpus](https://huggingface.co/datasets/bookcorpus)). 

Prin urmare, atunci când utilizați aceste instrumente, este important să conștientizați că modelul original pe care îl utilizați ar putea genera cu ușurință conținut sexist, rasist sau homofob. Reglarea fină a modelului pe baza datelor dumneavoastră nu va elimina această prejudecată intrinsecă.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter1/8.mdx" />