# Introducere[[introducere]]

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

După cum ați văzut în [Capitolul 1](/course/chapter1), modelele Transformer sunt de obicei foarte voluminoase. Fiind alcătuite din milioane până la zeci de *miliarde* de parametri, instruirea și implementarea acestor modele este o sarcină complicată. În plus, cu noi modele lansate aproape zilnic și fiecare având propria sa implementare, testarea tuturor acestora nu este o sarcină ușoară.

Biblioteca 🤗 Transformers a fost creată pentru a rezolva această problemă. Scopul său este de a oferi un singur API prin care orice model Transformer poate fi încărcat, antrenat și salvat. Principalele caracteristici ale bibliotecii sunt:

- **Simplitate în utilizare**: Descărcarea, încărcarea și utilizarea unui model NLP de ultimă generație pentru inferență pot fi realizate în doar două linii de cod.
- **Flexibilitate**: În esența lor, toate modelele sunt simple clase PyTorch `nn.Module` sau TensorFlow `tf.keras.Model` și pot fi manipulate ca orice alte modele în framework-urile lor respective de învățare automată (ML).
- **Simplitate**: Aproape că nu se fac abstractizări în întreaga bibliotecă. "All in one file" este un concept de bază: trecerea înainte a unui model este definită în întregime într-un singur fișier, astfel încât codul în sine să fie ușor de înțeles și de modificat.

Această ultimă caracteristică face "🤗 Transformers" destul de diferită de alte biblioteci ML. Modelele nu sunt construite pe module 
care sunt partajate între fișiere; în schimb, fiecare model are propriile sale straturi. În plus, pe lângă faptul că modelele sunt mai ușor de abordat și de înțeles, acest lucru vă permite să experimentați cu ușurință pe un model fără a le afecta pe celelalte.

Acest capitol va începe cu un exemplu end-to-end în care folosim împreună un model și un tokenizer pentru a replica funcția `pipeline()` introdusă în [Capitolul 1](/course/chapter1). În continuare, vom discuta despre API-ul modelului: vom analiza clasele de model și de configurare și vă vom arăta cum să încărcați un model și cum acesta procesează intrările numerice pentru a genera predicții. 

Apoi vom analiza API-ul tokenizer, care este cealaltă componentă principală a funcției `pipeline()`. Tokenizerii se ocupă de prima și ultima etapă de procesare, gestionând conversia de la text la intrări numerice pentru rețeaua neuronală și conversia înapoi la text atunci când este necesar. În cele din urmă, vă vom arăta cum să vă ocupați de trimiterea mai multor propoziții printr-un model în cadrul unui batch pregătit, apoi vom încheia totul cu o examinare mai atentă a funcției  `tokenizer()`.


<Tip>
⚠️  
Pentru a beneficia de toate funcțiile disponibile cu Model Hub și 🤗 Transformers, vă recomandăm <a href="https://huggingface.co/join">să vă creați un cont</a>.
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter2/1.mdx" />