# Ce fac dacă dataset-ul meu nu este pe Hub?[[what-if-my-dataset-isnt-on-the-hub]]

<CourseFloatingBanner chapter={5}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section2.ipynb"},
]} />

Știți cum să folosiți [Hugging Face Hub](https://huggingface.co/datasets) pentru a descărca dataseturi, dar vă veți găsi adesea lucrând cu date care sunt stocate fie pe laptopul dumneavoastră, fie pe un server remote. În această secțiune vă vom arăta cum poate fi utilizat 🤗 Datasets pentru a încărca dataseturi care nu sunt disponibile pe Hugging Face Hub.

<Youtube id="HyQgpJTkRdE"/>

## Lucrând cu dataseturi locale și remote[[working-with-local-and-remote-datasets]]

🤗 Datasets oferă scripturi de încărcare pentru a gestiona încărcarea dataseturilor locale și remote. Suportă mai multe formate de date comune, cum ar fi:

|    Data format     | Loading script |                         Example                         |
| :----------------: | :------------: | :-----------------------------------------------------: |
|     CSV & TSV      |     `csv`      |     `load_dataset("csv", data_files="my_file.csv")`     |
|     Text files     |     `text`     |    `load_dataset("text", data_files="my_file.txt")`     |
| JSON & JSON Lines  |     `json`     |   `load_dataset("json", data_files="my_file.jsonl")`    |
| Pickled DataFrames |    `pandas`    | `load_dataset("pandas", data_files="my_dataframe.pkl")` |

Așa cum se arată în tabel, pentru fiecare format de date trebuie doar să specificăm tipul scriptului de încărcare în funcția `load_dataset()`, alături de un argument `data_files` care specifică calea către unul sau mai multe fișiere. Să începem prin încărcarea unui dataset din fișiere locale; mai târziu vom vedea cum să facem același lucru cu fișiere remote.

## Încărcarea unui dataset local[[loading-a-local-dataset]]

Pentru acest exemplu vom folosi [datasetul SQuAD-it](https://github.com/crux82/squad-it/), care este un dataset la scară largă pentru întrebări și răspunsuri în italiană.

Seturile de antrenare și test sunt găzduite pe GitHub, deci le putem descărca cu o comandă simplă `wget`:

```python
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-train.json.gz
!wget https://github.com/crux82/squad-it/raw/master/SQuAD_it-test.json.gz
```

Aceasta va descărca două fișiere comprimate numite *SQuAD_it-train.json.gz* și *SQuAD_it-test.json.gz*, pe care le putem decomprima cu comanda Linux `gzip`:

```python
!gzip -dkv SQuAD_it-*.json.gz
```

```bash
SQuAD_it-test.json.gz:	   87.4% -- replaced with SQuAD_it-test.json
SQuAD_it-train.json.gz:	   82.2% -- replaced with SQuAD_it-train.json
```

Putem vedea că fișierele comprimate au fost înlocuite cu _SQuAD_it-train.json_ și _SQuAD_it-test.json_, și că datele sunt stocate în formatul JSON.

<Tip>

✎ Dacă vă întrebați de ce există un caracter `!` în comenzile shell de mai sus, aceasta este pentru că le rulăm într-un notebook Jupyter. Pur și simplu eliminați prefixul dacă doriți să descărcați și să dezarhivați datasetul într-un terminal.

</Tip>

Pentru a încărca un fișier JSON cu funcția `load_dataset()`, trebuie doar să știm dacă avem de-a face cu JSON obișnuit (similar cu un dicționar imbricat) sau JSON Lines (JSON separat pe linii). Ca multe dataseturi de întrebări și răspunsuri, SQuAD-it folosește formatul imbricat, cu tot textul stocat într-un câmp `data`. Aceasta înseamnă că putem încărca datasetul specificând argumentul `field` după cum urmează:

```py
from datasets import load_dataset

squad_it_dataset = load_dataset("json", data_files="SQuAD_it-train.json", field="data")
```

În mod implicit, încărcarea fișierelor locale creează un obiect `DatasetDict` cu un split `train`. Putem vedea acest lucru prin inspectarea obiectului `squad_it_dataset`:

```py
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
})
```

Aceasta ne arată numărul de rânduri și numele coloanelor asociate cu setul de antrenare. Putem vizualiza unul dintre exemple prin indexarea în splitul `train` după cum urmează:

```py
squad_it_dataset["train"][0]
```

```python out
{
    "title": "Terremoto del Sichuan del 2008",
    "paragraphs": [
        {
            "context": "Il terremoto del Sichuan del 2008 o il terremoto...",
            "qas": [
                {
                    "answers": [{"answer_start": 29, "text": "2008"}],
                    "id": "56cdca7862d2951400fa6826",
                    "question": "In quale anno si è verificato il terremoto nel Sichuan?",
                },
                ...
            ],
        },
        ...
    ],
}
```

Excelent, am încărcat primul nostru dataset local! Dar în timp ce acest lucru a funcționat pentru setul de antrenare, ceea ce dorim cu adevărat este să includem atât spliturile `train` cât și `test` într-un singur obiect `DatasetDict` astfel încât să putem aplica funcțiile `Dataset.map()` pe ambele splituri deodată. Pentru a face acest lucru, putem furniza un dicționar argumentului `data_files` care mapează fiecare nume de split la un fișier asociat cu acel split:

```py
data_files = {"train": "SQuAD_it-train.json", "test": "SQuAD_it-test.json"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
squad_it_dataset
```

```python out
DatasetDict({
    train: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 442
    })
    test: Dataset({
        features: ['title', 'paragraphs'],
        num_rows: 48
    })
})
```

Acesta este exact ceea ce am dorit. Acum, putem aplica diverse tehnici de preprocesare pentru a curăța datele, tokeniza recenziile și așa mai departe.

<Tip>

Argumentul `data_files` al funcției `load_dataset()` este destul de flexibil și poate fi fie o singură cale de fișier, o listă de căi de fișiere, sau un dicționar care mapează numele spliturilor la căile fișierelor. De asemenea, puteți folosi glob pentru fișiere care se potrivesc unui model specificat conform regulilor folosite de shell-ul Unix (de exemplu, puteți face glob pentru toate fișierele JSON dintr-un director ca un singur split prin setarea `data_files="*.json"`). Consultați [documentația](https://huggingface.co/docs/datasets/loading#local-and-remote-files) 🤗 Datasets pentru mai multe detalii.

</Tip>

Scripturile de încărcare din 🤗 Datasets suportă de fapt decomprimarea automată a fișierelor de intrare, deci am fi putut să sărim peste folosirea `gzip` prin indicarea argumentului `data_files` direct către fișierele comprimate:

```py
data_files = {"train": "SQuAD_it-train.json.gz", "test": "SQuAD_it-test.json.gz"}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Acest lucru poate fi util dacă nu doriți să decomprimați manual multe fișiere GZIP. Decomprimarea automată se aplică și altor formate comune precum ZIP și TAR, deci trebuie doar să pointați `data_files` către fișierele comprimate și sunteți gata!

Acum că știți cum să încărcați fișiere locale pe laptopul sau desktop-ul dumneavoastră, să aruncăm o privire la încărcarea fișierelor remote.

## Încărcarea unui dataset remote[[loading-a-remote-dataset]]

Dacă lucrați ca data scientist sau programator într-o companie, există o șansă bună ca dataseturile pe care doriți să le analizați să fie stocate pe un server remote. Din fericire, încărcarea fișierelor remote este la fel de simplă ca încărcarea celor locale! În loc să furnizați o cale către fișiere locale, pointați argumentul `data_files` al `load_dataset()` către unul sau mai multe URL-uri unde sunt stocate fișierele remote. De exemplu, pentru datasetul SQuAD-it găzduit pe GitHub, putem pur și simplu să pointăm `data_files` către URL-urile _SQuAD_it-*.json.gz_ după cum urmează:

```py
url = "https://github.com/crux82/squad-it/raw/master/"
data_files = {
    "train": url + "SQuAD_it-train.json.gz",
    "test": url + "SQuAD_it-test.json.gz",
}
squad_it_dataset = load_dataset("json", data_files=data_files, field="data")
```

Aceasta returnează același obiect `DatasetDict` obținut mai sus, dar ne economisește pasul de a descărca și decomprima manual fișierele _SQuAD_it-*.json.gz_. Aceasta încheie incursiunea noastră în diversele modalități de încărcare a dataseturilor care nu sunt găzduite pe Hugging Face Hub. Acum că avem un dataset cu care să ne jucăm, să explorăm diverse tehnici de manipulare a datelor!

<Tip>

✏️ **Încercați!** Alegeți un alt dataset găzduit pe GitHub sau [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/index.php) și încercați să îl încărcați atât local cât și remote folosind tehnicile introduse mai sus. Pentru puncte bonus, încercați să încărcați un dataset care este stocat în format CSV sau text (consultați [documentația](https://huggingface.co/docs/datasets/loading#local-and-remote-files) pentru mai multe informații despre aceste formate).

</Tip>






<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter5/2.mdx" />