# Cum să scrieți un issue bun[[cum-sa-scrieti-un-issue-bun]]

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section5.ipynb"},
]} />

Când întâlniți ceva care nu pare corect cu una dintre bibliotecile Hugging Face, ar trebui cu siguranță să ne spuneți astfel încât să o putem repara (același lucru se aplică pentru orice bibliotecă open source, de altfel). Dacă nu sunteți complet siguri dacă bug-ul se află în propriul vostru cod sau într-una dintre bibliotecile noastre, primul loc de verificat sunt [forumurile](https://discuss.huggingface.co/). Comunitatea vă va ajuta să clarificați acest lucru, și echipa Hugging Face urmărește de asemenea îndeaproape discuțiile de acolo.

<Youtube id="_PAli-V4wj0"/>

Când sunteți siguri că aveți un bug în mână, primul pas este să construiți un exemplu minimal reproductibil.

## Crearea unui exemplu minimal reproductibil[[crearea-unui-exemplu-minimal-reproductibil]]

Este foarte important să izolați bucata de cod care produce bug-ul, deoarece nimeni din echipa Hugging Face nu este magician (încă), și nu pot repara ceea ce nu pot vedea. Un exemplu minimal reproductibil ar trebui, așa cum indică numele, să fie reproductibil. Aceasta înseamnă că nu ar trebui să se bazeze pe niciun fișier extern sau date pe care le-ați putea avea. Încercați să înlocuiți datele pe care le folosiți cu niște valori fictive care arată ca cele reale și încă produc aceeași eroare.

<Tip>

🚨 Multe probleme din repository-ul 🤗 Transformers sunt nerezolvate deoarece datele folosite pentru a le reproduce nu sunt accesibile.

</Tip>

Odată ce aveți ceva care este autonom, puteți încerca să îl reduceți la și mai puține linii de cod, construind ceea ce numim un _exemplu minimal reproductibil_. Deși aceasta necesită puțină muncă suplimentară din partea voastră, veți fi aproape garantat să primiți ajutor și o reparație dacă furnizați un reproductor de bug frumos și scurt.

Dacă vă simțiți suficient de confortabil, mergeți să inspectați codul sursă unde se întâmplă bug-ul vostru. Ați putea găsi o soluție la problema voastră (caz în care puteți chiar sugera un pull request pentru a o repara), dar mai general, aceasta poate ajuta întreținătorii să înțeleagă mai bine sursa când citesc raportul vostru.

## Completarea șablonului de issue[[completarea-sablonului-de-issue]]

Când depuneți un issue, veți observa că există un șablon de completat. Vom urma pe cel pentru [problemele 🤗 Transformers](https://github.com/huggingface/transformers/issues/new/choose) aici, dar același tip de informații va fi necesar dacă raportați o problemă într-un alt repository. Nu lăsați șablonul gol: luarea timpului pentru a-l completa va maximiza șansele voastre de a primi un răspuns și de a vă rezolva problema.

În general, când depuneți un issue, rămâneți întotdeauna politicoși. Acesta este un proiect open source, deci folosiți software gratuit, și nimeni nu are nicio obligație să vă ajute. Puteți include ceea ce simțiți că este critică justificată în problema voastră, dar atunci întreținătorii s-ar putea să o ia prost și să nu se grăbească să vă ajute. Asigurați-vă că citiți [codul de conduită](https://github.com/huggingface/transformers/blob/master/CODE_OF_CONDUCT.md) al proiectului.

### Includerea informațiilor despre mediul vostru[[includerea-informatiilor-despre-mediul-vostru]]

🤗 Transformers oferă un utilitar pentru a obține toate informațiile de care avem nevoie despre mediul vostru. Doar tastați următoarele în terminalul vostru:

```
transformers-cli env
```

și ar trebui să obțineți ceva ca aceasta:

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```

Puteți de asemenea adăuga un `!` la începutul comenzii `transformers-cli env` pentru a o executa dintr-o celulă de notebook, și apoi să copiați și lipiți rezultatul la începutul problemei voastre.

### Etichetarea persoanelor[[etichetarea-persoanelor]]

Etichetarea persoanelor prin tastarea unui `@` urmat de handle-ul lor GitHub le va trimite o notificare astfel încât să vă vadă problema și ar putea răspunde mai repede. Folosiți aceasta cu moderație, deoarece persoanele pe care le etichetați s-ar putea să nu aprecieze să fie notificate dacă este ceva cu care nu au nicio legătură directă. Dacă v-ați uitat la fișierele sursă legate de bug-ul vostru, ar trebui să etichetați ultima persoană care a făcut modificări la linia pe care credeți că este responsabilă pentru problema voastră (puteți găsi această informație uitându-vă la acea linie pe GitHub, selectând-o, apoi făcând clic pe "View git blame").

Altfel, șablonul oferă sugestii de persoane de etichetat. În general, nu etichetați niciodată mai mult de trei persoane!

### Includerea unui exemplu reproductibil[[includerea-unui-exemplu-reproductibil]]

Dacă ați reușit să creați un exemplu autonom care produce bug-ul, acum este momentul să îl includeți! Tastați o linie cu trei backtick-uri urmată de `python`, astfel:

```
```python
```

Apoi lipiți exemplul vostru minimal reproductibil și tastați o linie nouă cu trei backtick-uri. Aceasta va asigura că codul vostru este formatat corespunzător.

Dacă nu ați reușit să creați un exemplu reproductibil, explicați în pași clari cum ați ajuns la problema voastră. Includeți un link către un notebook Google Colab unde ați primit eroarea dacă puteți. Cu cât mai multe informații partajați, cu atât mai bine vor putea întreținătorii să vă răspundă.

În toate cazurile, ar trebui să copiați și să lipiți întregul mesaj de eroare pe care îl primiți. Dacă lucrați în Colab, amintiți-vă că unele dintre frame-uri pot fi comprimate automat în stack trace, așa că asigurați-vă că le extindeți înainte de copiere. Ca și cu exemplul de cod, puneți acel mesaj de eroare între două linii cu trei backtick-uri, astfel încât să fie formatat corespunzător.

### Descrierea comportamentului așteptat[[descrierea-comportamentului-asteptat]]

Explicați în câteva linii ce ați așteptat să obțineți, astfel încât întreținătorii să înțeleagă complet problema. Această parte este în general destul de evidentă, așa că ar trebui să încapă într-o propoziție, dar în unele cazuri ați putea avea multe de spus.

## Și apoi ce?[[si-apoi-ce]]

Odată ce problema voastră este depusă, asigurați-vă să verificați rapid că totul arată în regulă. Puteți edita problema dacă ați făcut o greșeală, sau chiar să îi schimbați titlul dacă realizați că problema este diferită de ceea ce ați gândit inițial.

Nu are sens să faceți ping la oameni dacă nu primiți un răspuns. Dacă nimeni nu vă ajută în câteva zile, este probabil că nimeni nu a putut înțelege problema voastră. Nu ezitați să vă întoarceți la exemplul reproductibil. Îl puteți face mai scurt și mai la obiect? Dacă nu primiți un răspuns într-o săptămână, puteți lăsa un mesaj cerând cu blândețe ajutor, mai ales dacă v-ați editat problema pentru a include mai multe informații despre problemă. 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter8/5.mdx" />