# Итоги

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

В этой главе вы увидели, как подходить к различным задачам NLP, используя высокоуровневую функцию `pipeline()` из библиотеки 🤗 Transformers. Вы также увидели, как искать и использовать модели в Hub, а также как использовать Inference API для тестирования моделей прямо в браузере.

Мы обсудили, как трансформеры работают на высоком уровне, и поговорили о важности трансферного обучения и дообучения. Ключевым аспектом является то, что вы можете использовать всю архитектуру или только кодировщик или декодировщик, в зависимости от того, какую задачу вы хотите решить. Следующая таблица резюмирует это:


| Модель                  | Примеры                                    | Задачи                                                                                                  |
|-------------------------|--------------------------------------------|---------------------------------------------------------------------------------------------------------|
| Кодировщик              | ALBERT, BERT, DistilBERT, ELECTRA, RoBERTa | Классификация предложений, распознавание именованных сущностей, выделительные вопросно-ответные системы |
| Декодировщик            | CTRL, GPT, GPT-2, Transformer XL           | Генерация текста                                                                                        |
| Кодировщик-декодировщик | BART, T5, Marian, mBART                    | Автоматическое реферирование, перевод, генеративные вопросно-ответные системы                            |


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter1/9.mdx" />