# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

Эта глава охватила много вопросов! Не волнуйтесь, если вы не поняли всех деталей; следующие главы помогут вам понять, как все работает внутри.

Однако, прежде чем двигаться дальше, давайте проверим то, что вы узнали в этой главе.
### Из каких источников функция `load_dataset()` в 🤗 Datasets позволяет загружать наборы данных?

<Question
	choices={[
		{
			text: "Локальных, то есть с моего компьютера",
			explain: "Правильно! Вы можете передать пути к локальным файлам в аргумент <code>data_files</code> функции <code>load_dataset()</code> для загрузки локальных наборов данных.",
			correct: true
		},
		{
			text: "Hugging Face Hub",
			explain: "Правильно! Вы можете загружать наборы данных в Hub, указав идентификатор набора данных, например. <code>load_dataset('emotion')</code>.",
			correct: true
		},
		{
			text: "Удаленный сервер",
			explain: "Правильно! Вы можете передать URLs в аргумент <code>data_files</code> фунции  <code>load_dataset()</code>. ",
			correct: true
		},
	]}
/>

### 2. Предположим, вы загружаете одну из задач GLUE следующим образом:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Какая из следующих команд создаст случайную выборку из 50 элементов из `dataset`?

<Question
	choices={[
		{
			text: "<code>dataset.sample(50)</code>",
			explain: "Это неверно — нет метода <code>Dataset.sample()</code>."
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "Правильный! Как вы видели в этой главе, вы сначала перемешиваете набор данных, а затем выбираете из него подмножества.",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "Это неверно — хотя код запустится, он перемешает только первые 50 элементов в наборе данных."
		}
	]}
/>

### 3. Предположим, у вас есть набор данных о домашних питомцах под названием `pets_dataset`, в котором есть столбец `name`, обозначающий имя каждого питомца. Какой из следующих подходов позволит вам отфильтровать набор данных для всех домашних животных, имена которых начинаются с буквы «L»?

<Question
	choices={[
		{
			text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
			explain: "Правильно! Использование лямбда-функции Python для этих быстрых фильтров — отличная идея. Можете ли вы придумать другое решение?",
			correct: true
		},
		{
			text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
			explain: "Это неверно — лямбда-функция принимает общую форму <code>lambda *arguments* : *expression*</code>, поэтому в этом случае вам необходимо предоставить аргументы."
		},
		{
			text: "Create a function like <code>def filter_names(x): return x['name'].startswith('L')</code> and run <code>pets_dataset.filter(filter_names)</code>.",
			explain: "Правильно! Как и в случае с <code>Dataset.map()</code>, вы можете передавать явные функции в <code>Dataset.filter()</code>. Это полезно, когда у вас есть сложная логика, которая не подходит для короткой лямбда-функции. Какое из других решений будет работать?",
			correct: true
		}
	]}
/>

### 4. Что такое отображение в память?

<Question
	choices={[
		{
			text: "Сопоставление между ЦП (CPU) и ОЗУ (RAM) графического процессора",
			explain: "Нет, попробуй еще раз!",
		},
		{
			text: "Отображение между RAM и файловой системой компьютера",
			explain: "Правильно! 🤗 Datasets рассматриваtт каждый набор данных как файл с отображением в памяти. Это позволяет библиотеке получать доступ к элементам набора данных и работать с ними без необходимости полной загрузки его в память.",
			correct: true
		},
		{
			text: "Сопоставление между двумя файлами в кэшэ 🤗 Datasets",
			explain: "Нет, попробуй еще раз!"
		}
	]}
/>

### 5. Что из перечисленного ниже является основным преимуществом отображения памяти?

<Question
	choices={[
		{
			text: "Доступ к файлам, отображенным в памяти, быстрее, чем чтение или запись на диск.",
			explain: "Правильно! Это позволяет 🤗 Datasets работать быстро. Однако это не единственное преимущество.",
			correct: true
		},
		{
			text: "Приложения могут получать доступ к сегментам данных в очень большом файле без необходимости сначала считывать весь файл в ОЗУ.",
			explain: "Правильно! Это позволяет 🤗 Datasets загружать многогигабайтные наборы данных на ваш ноутбук, не нагружая ваш процессор. Какие еще преимущества предлагает сопоставление памяти?",
			correct: true
		},
		{
			text: "Он потребляет меньше энергии, поэтому батарея работает дольше.",
			explain: "Это неправильно - попробуй еще раз!"
		}
	]}
/>

### 6. Почему следующий код не работает?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "Он пытается передать набор данных, который слишком велик для размещения в ОЗУ.",
			explain: "Это неверно — потоковые наборы данных распаковываются на лету, и вы можете обрабатывать наборы данных размером в терабайт с очень небольшим объемом оперативной памяти!",
		},
		{
			text: "Он пытается получить доступ к <code>IterableDataset</code>.",
			explain: "Правильно! <code>IterableDataset</code> — это генератор, а не контейнер, поэтому вы должны получить доступ к его элементам, используя <code>next(iter(dataset))</code>.",
			correct: true
		},
		{
			text: "Набор данных <code>allocine</code> не имеет разделения <code>train</code>.",
			explain: "Это неверно — проверьте [<code>allocine</code> карточку набора данных](https://huggingface.co/datasets/allocine) в Hub, чтобы увидеть, какие разбиения он содержит."
		}
	]}
/>

### 7. Что из перечисленного является основными преимуществами создания карточки датасета?

<Question
	choices={[
		{
			text: "Она предоставляет информацию о предполагаемом использовании и поддерживаемых задачах набора данных, чтобы другие участники сообщества могли принять обоснованное решение об его использовании.",
			explain: "Правильно! Недокументированные наборы данных могут использоваться для обучения моделей, которые могут не отражать намерения создателей наборов данных, или могут создавать модели с неясным юридическим статусом, если они обучены на данных, нарушающих конфиденциальность или лицензионные ограничения. Но это не единственный плюс!",
			correct : true
		},
		{
			text: "Это помогает привлечь внимание к искажениям, присутствующим в корпусе.",
			explain: "Правильно! Почти все наборы данных имеют некоторую форму предвзятости, которая может привести к негативным последствиям в дальнейшем. Знание о них помогает разработчикам моделей понять, как устранять подобные искажения. В чем еще помогают карточки наборов данных?»",
			correct : true
		},
		{
			text: "Это повышает шансы на то, что другие участники сообщества будут использовать мой набор данных.",
			explain: "Правильно! Хорошо написанная карточка набора данных, как правило, приведет к более активному использованию вашего драгоценного датасета. Какие еще могут быть преимущества?",
			correct: true
		},
	]}
/>


### 8. Что такое семантический поиск?

<Question
	choices={[
		{
			text: "Способ поиска точных совпадений между словами в запросе и документами в корпусе",
			explain: "Это неверно — этот тип поиска называется *лексическим поиском*, и это то, что вы обычно видите в традиционных поисковых системах"
		},
		{
			text: "Способ поиска совпадающих документов путем понимания контекстного значения запроса",
			explain: "Правильно! Семантический поиск использует вложенные векторы для представления запросов и документов и использует метрику подобия для измерения степени совпадения между ними. Как еще вы могли бы это описать?",
			correct: true
		},
		{
			text: "Способ повысить точность поиска",
			explain: "Правильно! Семантические поисковые системы могут улавливать цель запроса намного лучше, чем сопоставление ключевых слов, и обычно извлекают документы с более высокой точностью. Но это не единственный правильный ответ - что еще дает семантический поиск?",
			correct: true
		}
	]}
/>

### 9. Для асимметричного семантического поиска можно использовать:

<Question
	choices={[
		{
			text: "Короткий запрос и более длинный абзац, отвечающий на запрос. ",
			explain: "Правильно!",
			correct : true
		},
		{
			text: "Запросы и абзацы примерно одинаковой длины. ",
			explain: "Это пример симметричного семантического поиска – попробуй еще раз!"
		},
		{
			text: "Длинный запрос и более короткий абзац, который отвечает на запрос.",
			explain: "Неправильно, попробуй еще раз!"
		}
	]}
/>

### 10. Могу ли я использовать 🤗 Datasets для загрузки данных и решения задач в других областях, например для обработки речи?

<Question
	choices={[
		{
			text: "Нет",
			explain: "Это неверно — 🤗 Datasets в настоящее время поддерживают табличные данные, аудио и компьютерное зрение. Ознакомьтесь с <a href='https://huggingface.co/datasets/mnist'>набором данных MNIST</a> в Hub для примера компьютерного зрения."
		},
		{
			text: "Да",
			explain: "Правильно! Ознакомьтесь с захватывающими разработками в области речи и зрения в библиотеке 🤗 Transformers, чтобы узнать, как 🤗 Datasets используются в этих областях.",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter5/8.mdx" />