# 🤗 Transformerలు పనులను ఎలా పరిష్కరిస్తాయి

<Youtube id="zsfR7eY9Uho" />

[Transformers, what can they do?](/course/chapter1/3)లో, మీరు సహజ భాషా ప్రాసెసింగ్ (NLP), ప్రసంగం మరియు ఆడియో, కంప్యూటర్ విజన్ పనులు మరియు వాటి కొన్ని ముఖ్యమైన అనువర్తనాల గురించి తెలుసుకున్నారు. ఈ పేజీ మోడల్స్ ఈ పనులను ఎలా పరిష్కరిస్తాయో నిశితంగా పరిశీలిస్తుంది మరియు తెరవెనుక ఏమి జరుగుతుందో వివరిస్తుంది. ఒక నిర్దిష్ట పనిని పరిష్కరించడానికి చాలా మార్గాలు ఉన్నాయి, కొన్ని మోడల్స్ నిర్దిష్ట టెక్నిక్‌లను అమలు చేయవచ్చు లేదా పనిని కొత్త కోణం నుండి కూడా సంప్రదించవచ్చు, కానీ Transformer మోడల్స్ కోసం, సాధారణ ఆలోచన ఒకటే. దాని సౌకర్యవంతమైన ఆర్కిటెక్చర్ కారణంగా, చాలా మోడల్స్ ఒక ఎన్‌కోడర్, ఒక డీకోడర్, లేదా ఒక ఎన్‌కోడర్-డీకోడర్ నిర్మాణం యొక్క వైవిధ్యాలుగా ఉంటాయి.

<Tip>

నిర్దిష్ట ఆర్కిటెక్చరల్ వైవిధ్యాలలోకి ప్రవేశించే ముందు, చాలా పనులు ఒకే విధమైన పద్ధతిని అనుసరిస్తాయని అర్థం చేసుకోవడం సహాయపడుతుంది: ఇన్‌పుట్ డేటా ఒక మోడల్ ద్వారా ప్రాసెస్ చేయబడుతుంది మరియు అవుట్‌పుట్ ఒక నిర్దిష్ట పని కోసం వ్యాఖ్యానించబడుతుంది. తేడాలు డేటాను ఎలా తయారు చేస్తారు, ఏ మోడల్ ఆర్కిటెక్చర్ వైవిధ్యం ఉపయోగించబడుతుంది మరియు అవుట్‌పుట్ ఎలా ప్రాసెస్ చేయబడుతుంది అనే దానిలో ఉంటాయి.

</Tip>

పనులు ఎలా పరిష్కరించబడతాయో వివరించడానికి, ఉపయోగకరమైన అంచనాలను అవుట్‌పుట్ చేయడానికి మోడల్ లోపల ఏమి జరుగుతుందో మేము వివరిస్తాము. మేము ఈ క్రింది మోడల్స్ మరియు వాటి సంబంధిత పనులను కవర్ చేస్తాము:

- [Wav2Vec2](https://huggingface.co/docs/transformers/model_doc/wav2vec2) ఆడియో వర్గీకరణ మరియు ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్ (ASR) కోసం
- [Vision Transformer (ViT)](https://huggingface.co/docs/transformers/model_doc/vit) మరియు [ConvNeXT](https://huggingface.co/docs/transformers/model_doc/convnext) ఇమేజ్ వర్గీకరణ కోసం
- [DETR](https://huggingface.co/docs/transformers/model_doc/detr) వస్తువు గుర్తింపు కోసం
- [Mask2Former](https://huggingface.co/docs/transformers/model_doc/mask2former) ఇమేజ్ సెగ్మెంటేషన్ కోసం
- [GLPN](https://huggingface.co/docs/transformers/model_doc/glpn) డెప్త్ ఎస్టిమేషన్ కోసం
- [BERT](https://huggingface.co/docs/transformers/model_doc/bert) ఎన్‌కోడర్‌ను ఉపయోగించే టెక్స్ట్ వర్గీకరణ, టోకెన్ వర్గీకరణ మరియు ప్రశ్నలకు సమాధానాలు వంటి NLP పనుల కోసం
- [GPT2](https://huggingface.co/docs/transformers/model_doc/gpt2) డీకోడర్‌ను ఉపయోగించే టెక్స్ట్ జనరేషన్ వంటి NLP పనుల కోసం
- [BART](https://huggingface.co/docs/transformers/model_doc/bart) ఎన్‌కోడర్-డీకోడర్‌ను ఉపయోగించే సారాంశం మరియు అనువాదం వంటి NLP పనుల కోసం

<Tip>

మీరు ముందుకు వెళ్లే ముందు, అసలు Transformer ఆర్కిటెక్చర్ గురించి কিছু ప్రాథమిక పరిజ్ఞానం కలిగి ఉండటం మంచిది. ఎన్‌కోడర్‌లు, డీకోడర్‌లు మరియు అటెన్షన్ ఎలా పనిచేస్తుందో తెలుసుకోవడం వేర్వేరు Transformer మోడల్స్ ఎలా పనిచేస్తాయో అర్థం చేసుకోవడంలో మీకు సహాయపడుతుంది. మరింత సమాచారం కోసం మా [మునుపటి విభాగాన్ని](https://huggingface.co/course/chapter1/4?fw=pt) తప్పకుండా చూడండి!

</Tip>

## భాష కోసం Transformer మోడల్స్

భాషా నమూనాలు ఆధునిక NLP యొక్క గుండెకాయ. అవి టెక్స్ట్‌లోని పదాలు లేదా టోకెన్‌ల మధ్య గణాంక నమూనాలు మరియు సంబంధాలను నేర్చుకోవడం ద్వారా మానవ భాషను అర్థం చేసుకోవడానికి మరియు ఉత్పత్తి చేయడానికి రూపొందించబడ్డాయి.

Transformer మొదట యంత్ర అనువాదం కోసం రూపొందించబడింది, మరియు అప్పటి నుండి, ఇది అన్ని AI పనులను పరిష్కరించడానికి డిఫాల్ట్ ఆర్కిటెక్చర్‌గా మారింది. కొన్ని పనులు Transformer యొక్క ఎన్‌కోడర్ నిర్మాణానికి అనుకూలంగా ఉంటాయి, మరికొన్ని డీకోడర్‌కు బాగా సరిపోతాయి. మరికొన్ని పనులు Transformer యొక్క ఎన్‌కోడర్-డీకోడర్ నిర్మాణాన్ని రెండింటినీ ఉపయోగిస్తాయి.

### భాషా నమూనాలు ఎలా పనిచేస్తాయి

భాషా నమూనాలు చుట్టుపక్కల పదాల సందర్భాన్ని బట్టి ఒక పదం యొక్క సంభావ్యతను అంచనా వేయడానికి శిక్షణ పొందడం ద్వారా పనిచేస్తాయి. ఇది వాటికి భాషపై ప్రాథమిక అవగాహనను ఇస్తుంది, ఇది ఇతర పనులకు సాధారణీకరించగలదు.

ఒక Transformer మోడల్‌కు శిక్షణ ఇవ్వడానికి రెండు ప్రధాన విధానాలు ఉన్నాయి:

1. **మాస్క్డ్ లాంగ్వేజ్ మోడలింగ్ (MLM)**: BERT వంటి ఎన్‌కోడర్ మోడల్స్ ద్వారా ఉపయోగించబడుతుంది, ఈ విధానం ఇన్‌పుట్‌లో కొన్ని టోకెన్‌లను యాదృచ్ఛికంగా మాస్క్ చేస్తుంది మరియు చుట్టుపక్కల సందర్భం ఆధారంగా అసలు టోకెన్‌లను అంచనా వేయడానికి మోడల్‌కు శిక్షణ ఇస్తుంది. ఇది మోడల్ ద్విదిశాత్మక సందర్భాన్ని (మాస్క్ చేసిన పదం ముందు మరియు తరువాత ఉన్న పదాలను చూడటం) నేర్చుకోవడానికి అనుమతిస్తుంది.

2. **కాజల్ లాంగ్వేజ్ మోడలింగ్ (CLM)**: GPT వంటి డీకోడర్ మోడల్స్ ద్వారా ఉపయోగించబడుతుంది, ఈ విధానం క్రమంలోని అన్ని మునుపటి టోకెన్‌ల ఆధారంగా తదుపరి టోకెన్‌ను అంచనా వేస్తుంది. మోడల్ తదుపరి టోకెన్‌ను అంచనా వేయడానికి ఎడమ వైపు (మునుపటి టోకెన్‌లు) నుండి మాత్రమే సందర్భాన్ని ఉపయోగించగలదు.

### భాషా నమూనాల రకాలు

Transformers లైబ్రరీలో, భాషా నమూనాలు సాధారణంగా మూడు ఆర్కిటెక్చరల్ వర్గాలలోకి వస్తాయి:

1. **ఎన్‌కోడర్-మాత్రమే మోడల్స్** (BERT వంటివి): ఈ మోడల్స్ రెండు దిశల నుండి సందర్భాన్ని అర్థం చేసుకోవడానికి ఒక ద్విదిశాత్మక విధానాన్ని ఉపయోగిస్తాయి. వర్గీకరణ, పేరున్న ఎంటిటీ గుర్తింపు మరియు ప్రశ్నలకు సమాధానాలు వంటి టెక్స్ట్ యొక్క లోతైన అవగాహన అవసరమయ్యే పనులకు ఇవి ఉత్తమంగా సరిపోతాయి.

2. **డీకోడర్-మాత్రమే మోడల్స్** (GPT, Llama వంటివి): ఈ మోడల్స్ ఎడమ నుండి కుడికి టెక్స్ట్‌ను ప్రాసెస్ చేస్తాయి మరియు ముఖ్యంగా టెక్స్ట్ జనరేషన్ పనులలో మంచివి. అవి ఒక ప్రాంప్ట్ ఆధారంగా వాక్యాలను పూర్తి చేయగలవు, వ్యాసాలు రాయగలవు లేదా కోడ్‌ను కూడా ఉత్పత్తి చేయగలవు.

3. **ఎన్‌కోడర్-డీకోడర్ మోడల్స్** (T5, BART వంటివి): ఈ మోడల్స్ రెండు విధానాలను మిళితం చేస్తాయి, ఇన్‌పుట్‌ను అర్థం చేసుకోవడానికి ఒక ఎన్‌కోడర్‌ను మరియు అవుట్‌పుట్‌ను ఉత్పత్తి చేయడానికి ఒక డీకోడర్‌ను ఉపయోగిస్తాయి. అనువాదం, సారాంశం మరియు ప్రశ్నలకు సమాధానాలు వంటి సీక్వెన్స్-టు-సీక్వెన్స్ పనులలో ఇవి రాణిస్తాయి.
   ![transformer-models-for-language](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_architecture.png)

మునుపటి విభాగంలో మనం కవర్ చేసినట్లుగా, భాషా నమూనాలు సాధారణంగా స్వీయ-పర్యవేక్షిత పద్ధతిలో (మానవ ఉల్లేఖనలు లేకుండా) పెద్ద మొత్తంలో టెక్స్ట్ డేటాపై ముందే శిక్షణ పొందుతాయి, ఆపై నిర్దిష్ట పనులపై ఫైన్-ట్యూన్ చేయబడతాయి. ఈ విధానం, ట్రాన్స్‌ఫర్ లెర్నింగ్ అని పిలవబడుతుంది, ఈ మోడల్స్ సాపేక్షంగా తక్కువ మొత్తంలో పని-నిర్దిష్ట డేటాతో అనేక విభిన్న NLP పనులకు అనుగుణంగా ఉండటానికి అనుమతిస్తుంది.

తరువాతి విభాగాలలో, మేము నిర్దిష్ట మోడల్ ఆర్కిటెక్చర్లను మరియు అవి ప్రసంగం, దృష్టి మరియు టెక్స్ట్ డొమైన్‌లలోని వివిధ పనులకు ఎలా వర్తింపజేయబడతాయో అన్వేషిస్తాము.

<Tip>

ఒక నిర్దిష్ట NLP పనికి ఏ Transformer ఆర్కిటెక్చర్ భాగం (ఎన్‌కోడర్, డీకోడర్, లేదా రెండూ) ఉత్తమంగా సరిపోతుందో అర్థం చేసుకోవడం సరైన మోడల్‌ను ఎంచుకోవడంలో కీలకం. సాధారణంగా, ద్విదిశాత్మక సందర్భం అవసరమయ్యే పనులు ఎన్‌కోడర్‌లను ఉపయోగిస్తాయి, టెక్స్ట్‌ను ఉత్పత్తి చేసే పనులు డీకోడర్‌లను ఉపయోగిస్తాయి మరియు ఒక క్రమాన్ని మరొకదానికి మార్చే పనులు ఎన్‌కోడర్-డీకోడర్‌లను ఉపయోగిస్తాయి.

</Tip>

### టెక్స్ట్ జనరేషన్

టెక్స్ట్ జనరేషన్ అనేది ఒక ప్రాంప్ట్ లేదా ఇన్‌పుట్ ఆధారంగా పొందికైన మరియు సందర్భోచితంగా ఉండే టెక్స్ట్‌ను సృష్టించడం.

[GPT-2](https://huggingface.co/docs/transformers/model_doc/gpt2) అనేది పెద్ద మొత్తంలో టెక్స్ట్‌పై ముందే శిక్షణ పొందిన డీకోడర్-మాత్రమే మోడల్. ఇది ఒక ప్రాంప్ట్ ఇచ్చినప్పుడు నమ్మదగిన (ఎల్లప్పుడూ నిజం కానప్పటికీ!) టెక్స్ట్‌ను ఉత్పత్తి చేయగలదు మరియు స్పష్టంగా శిక్షణ పొందనప్పటికీ ప్రశ్నలకు సమాధానాలు వంటి ఇతర NLP పనులను పూర్తి చేయగలదు.

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/gpt2_architecture.png" />
</div>
1. GPT-2 పదాలను టోకనైజ్ చేయడానికి మరియు టోకెన్ ఎంబెడ్డింగ్‌ను రూపొందించడానికి [byte
pair encoding (BPE)](https://huggingface.co/docs/transformers/tokenizer_summary#bytepair-encoding-bpe)
ను ఉపయోగిస్తుంది. క్రమంలో ప్రతి టోకెన్ యొక్క స్థానాన్ని సూచించడానికి టోకెన్ ఎంబెడ్డింగ్‌లకు
పొజిషనల్ ఎన్‌కోడింగ్‌లు జోడించబడతాయి. ఇన్‌పుట్ ఎంబెడ్డింగ్‌లు చివరి దాచిన స్థితిని
అవుట్‌పుట్ చేయడానికి బహుళ డీకోడర్ బ్లాక్‌ల ద్వారా పంపబడతాయి. ప్రతి డీకోడర్ బ్లాక్
లోపల, GPT-2 ఒక *masked self-attention* లేయర్‌ను ఉపయోగిస్తుంది, దీని అర్థం GPT-2 భవిష్యత్
టోకెన్‌లకు అటెన్షన్ ఇవ్వలేదు. ఇది ఎడమ వైపు ఉన్న టోకెన్‌లకు మాత్రమే అటెన్షన్ ఇవ్వడానికి
అనుమతించబడుతుంది. ఇది BERT యొక్క [`mask`] టోకెన్ నుండి భిన్నంగా ఉంటుంది, ఎందుకంటే
masked self-attention లో, భవిష్యత్ టోకెన్‌ల కోసం స్కోర్‌ను `0` కు సెట్ చేయడానికి
ఒక అటెన్షన్ మాస్క్ ఉపయోగించబడుతుంది.

2. డీకోడర్ నుండి వచ్చే అవుట్‌పుట్‌ను ఒక లాంగ్వేజ్ మోడలింగ్ హెడ్‌కు పంపబడుతుంది, ఇది దాచిన స్థితులను లాజిట్స్‌గా మార్చడానికి ఒక లీనియర్ ట్రాన్స్‌ఫర్మేషన్ చేస్తుంది. లేబుల్ క్రమంలోని తర్వాతి టోకెన్, ఇది లాజిట్స్‌ను కుడివైపు ఒక స్థానం జరపడం ద్వారా సృష్టించబడుతుంది. షిఫ్ట్ చేయబడిన లాజిట్స్ మరియు లేబుల్స్ మధ్య క్రాస్-ఎంట్రోపీ నష్టం లెక్కించబడుతుంది, తద్వారా తదుపరి అత్యంత సంభావ్య టోకెన్‌ను అవుట్‌పుట్ చేయవచ్చు.

GPT-2 యొక్క ప్రీ-ట్రైనింగ్ లక్ష్యం పూర్తిగా [causal language modeling](https://huggingface.co/docs/transformers/glossary#causal-language-modeling) పై ఆధారపడి ఉంటుంది, ఒక క్రమంలోని తర్వాతి పదాన్ని అంచనా వేయడం. ఇది GPT-2ను ముఖ్యంగా టెక్స్ట్ ఉత్పత్తికి సంబంధించిన పనులలో మంచిదిగా చేస్తుంది.

టెక్స్ట్ జనరేషన్‌లో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? DistilGPT-2ను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [causal language modeling guide](https://huggingface.co/docs/transformers/tasks/language_modeling#causal-language-modeling)ను చూడండి!

<Tip>
  టెక్స్ట్ జనరేషన్ గురించి మరింత సమాచారం కోసం, [text generation
  strategies](generation_strategies) గైడ్‌ను చూడండి!
</Tip>

### టెక్స్ట్ వర్గీకరణ

టెక్స్ట్ వర్గీకరణ అనేది టెక్స్ట్ పత్రాలకు ముందుగా నిర్వచించిన వర్గాలను కేటాయించడం, సెంటిమెంట్ విశ్లేషణ, అంశ వర్గీకరణ, లేదా స్పామ్ గుర్తింపు వంటివి.

[BERT](https://huggingface.co/docs/transformers/model_doc/bert) ఒక ఎన్‌కోడర్-మాత్రమే మోడల్ మరియు ఇది రెండు వైపులా ఉన్న పదాలకు అటెన్షన్ ఇవ్వడం ద్వారా టెక్స్ట్ యొక్క గొప్ప ప్రాతినిధ్యాలను నేర్చుకోవడానికి లోతైన ద్విదిశాత్మకతను సమర్థవంతంగా అమలు చేసిన మొదటి మోడల్.

1. BERT టెక్స్ట్ యొక్క టోకెన్ ఎంబెడ్డింగ్‌ను రూపొందించడానికి [WordPiece](https://huggingface.co/docs/transformers/tokenizer_summary#wordpiece) టోకనైజేషన్‌ను ఉపయోగిస్తుంది. ఒకే వాక్యం మరియు వాక్యాల జత మధ్య తేడాను చెప్పడానికి, వాటిని వేరు చేయడానికి ఒక ప్రత్యేక `[SEP]` టోకెన్ జోడించబడుతుంది. ప్రతి టెక్స్ట్ క్రమం ప్రారంభంలో ఒక ప్రత్యేక `[CLS]` టోకెన్ జోడించబడుతుంది. `[CLS]` టోకెన్‌తో ఉన్న చివరి అవుట్‌పుట్ వర్గీకరణ పనుల కోసం వర్గీకరణ హెడ్‌కు ఇన్‌పుట్‌గా ఉపయోగించబడుతుంది. BERT ఒక టోకెన్ వాక్యాల జతలోని మొదటి లేదా రెండవ వాక్యానికి చెందినదా అని సూచించడానికి ఒక సెగ్మెంట్ ఎంబెడ్డింగ్‌ను కూడా జోడిస్తుంది.

2. BERT రెండు లక్ష్యాలతో ముందే శిక్షణ పొందింది: మాస్క్డ్ లాంగ్వేజ్ మోడలింగ్ మరియు నెక్స్ట్-సెంటెన్స్ ప్రిడిక్షన్. మాస్క్డ్ లాంగ్వేజ్ మోడలింగ్‌లో, ఇన్‌పుట్ టోకెన్‌లలో కొంత శాతం యాదృచ్ఛికంగా మాస్క్ చేయబడతాయి, మరియు మోడల్ వీటిని అంచనా వేయాలి. ఇది ద్విదిశాత్మకత సమస్యను పరిష్కరిస్తుంది, ఇక్కడ మోడల్ మోసం చేసి అన్ని పదాలను చూసి తర్వాతి పదాన్ని "అంచనా" వేయగలదు. అంచనా వేయబడిన మాస్క్ టోకెన్‌ల యొక్క చివరి దాచిన స్థితులు మాస్క్ చేయబడిన పదాన్ని అంచనా వేయడానికి ఒక ఫీడ్‌ఫార్వర్డ్ నెట్‌వర్క్‌కు పదజాలంపై సాఫ్ట్‌మాక్స్‌తో పంపబడతాయి.

   రెండవ ప్రీ-ట్రైనింగ్ లక్ష్యం నెక్స్ట్-సెంటెన్స్ ప్రిడిక్షన్. మోడల్ వాక్యం B వాక్యం A ను అనుసరిస్తుందా లేదా అని అంచనా వేయాలి. సగం సార్లు వాక్యం B తర్వాతి వాక్యం, మరియు మిగిలిన సగం సార్లు, వాక్యం B ఒక యాదృచ్ఛిక వాక్యం. అంచనా, అది తర్వాతి వాక్యమా కాదా అనేది, రెండు వర్గాలపై (`IsNext` మరియు `NotNext`) సాఫ్ట్‌మాక్స్‌తో ఉన్న ఒక ఫీడ్‌ఫార్వర్డ్ నెట్‌వర్క్‌కు పంపబడుతుంది.

3. ఇన్‌పుట్ ఎంబెడ్డింగ్‌లు చివరి దాచిన స్థితులను అవుట్‌పుట్ చేయడానికి బహుళ ఎన్‌కోడర్ లేయర్‌ల ద్వారా పంపబడతాయి.

టెక్స్ట్ వర్గీకరణ కోసం ముందే శిక్షణ పొందిన మోడల్‌ను ఉపయోగించడానికి, బేస్ BERT మోడల్ పైన ఒక సీక్వెన్స్ వర్గీకరణ హెడ్‌ను జోడించండి. సీక్వెన్స్ వర్గీకరణ హెడ్ అనేది ఒక లీనియర్ లేయర్, ఇది చివరి దాచిన స్థితులను అంగీకరించి మరియు వాటిని లాజిట్స్‌గా మార్చడానికి ఒక లీనియర్ ట్రాన్స్‌ఫర్మేషన్ చేస్తుంది. లాజిట్స్ మరియు టార్గెట్ మధ్య క్రాస్-ఎంట్రోపీ నష్టం లెక్కించబడుతుంది, తద్వారా అత్యంత సంభావ్య లేబుల్‌ను కనుగొనవచ్చు.

టెక్స్ట్ వర్గీకరణలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? DistilBERTను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [text classification guide](https://huggingface.co/docs/transformers/tasks/sequence_classification)ను చూడండి!

### టోకెన్ వర్గీకరణ

టోకెన్ వర్గీకరణ అనేది ఒక క్రమంలోని ప్రతి టోకెన్‌కు ఒక లేబుల్‌ను కేటాయించడం, పేరున్న ఎంటిటీ గుర్తింపు లేదా పార్ట్-ఆఫ్-స్పీచ్ ట్యాగింగ్ వంటివి.

పేరున్న ఎంటిటీ గుర్తింపు (NER) వంటి టోకెన్ వర్గీకరణ పనుల కోసం BERTను ఉపయోగించడానికి, బేస్ BERT మోడల్ పైన ఒక టోకెన్ వర్గీకరణ హెడ్‌ను జోడించండి. టోకెన్ వర్గీకరణ హెడ్ అనేది ఒక లీనియర్ లేయర్, ఇది చివరి దాచిన స్థితులను అంగీకరించి మరియు వాటిని లాజిట్స్‌గా మార్చడానికి ఒక లీనియర్ ట్రాన్స్‌ఫర్మేషన్ చేస్తుంది. లాజిట్స్ మరియు ప్రతి టోకెన్ మధ్య క్రాస్-ఎంట్రోపీ నష్టం లెక్కించబడుతుంది, తద్వారా అత్యంత సంభావ్య లేబుల్‌ను కనుగొనవచ్చు.

టోకెన్ వర్గీకరణలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? DistilBERTను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [token classification guide](https://huggingface.co/docs/transformers/tasks/token_classification)ను చూడండి!

### ప్రశ్నలకు సమాధానాలు

ప్రశ్నలకు సమాధానాలు అనేది ఇచ్చిన సందర్భం లేదా పేరాలో ఒక ప్రశ్నకు సమాధానాన్ని కనుగొనడం.

ప్రశ్నలకు సమాధానాల కోసం BERTను ఉపయోగించడానికి, బేస్ BERT మోడల్ పైన ఒక స్పాన్ వర్గీకరణ హెడ్‌ను జోడించండి. ఈ లీనియర్ లేయర్ చివరి దాచిన స్థితులను అంగీకరించి మరియు సమాధానానికి సంబంధించిన `span` ప్రారంభ మరియు ముగింపు లాజిట్స్‌ను లెక్కించడానికి ఒక లీనియర్ ట్రాన్స్‌ఫర్మేషన్ చేస్తుంది. లాజిట్స్ మరియు లేబుల్ పొజిషన్ మధ్య క్రాస్-ఎంట్రోపీ నష్టం లెక్కించబడుతుంది, తద్వారా సమాధానానికి సంబంధించిన అత్యంత సంభావ్య టెక్స్ట్ స్పాన్‌ను కనుగొనవచ్చు.

ప్రశ్నలకు సమాధానాలలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? DistilBERTను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [question answering guide](https://huggingface.co/docs/transformers/tasks/question_answering)ను చూడండి!

<Tip>

💡 BERT ముందే శిక్షణ పొందిన తర్వాత వివిధ పనుల కోసం ఉపయోగించడం ఎంత సులభమో గమనించండి. మీ దాచిన స్థితులను మీ కావలసిన అవుట్‌పుట్‌గా మార్చడానికి ముందే శిక్షణ పొందిన మోడల్‌కు ఒక నిర్దిష్ట హెడ్‌ను జోడించడం మాత్రమే మీకు అవసరం!

</Tip>

### సారాంశం

సారాంశం అనేది దాని కీలక సమాచారం మరియు అర్థాన్ని కాపాడుకుంటూ ఒక పొడవైన టెక్స్ట్‌ను చిన్న వెర్షన్‌గా కుదించడం.

[BART](https://huggingface.co/docs/transformers/model_doc/bart) మరియు [T5](model_doc/t5) వంటి ఎన్‌కోడర్-డీకోడర్ మోడల్స్ ఒక సారాంశం పని యొక్క సీక్వెన్స్-టు-సీక్వెన్స్ నమూనా కోసం రూపొందించబడ్డాయి. మేము ఈ విభాగంలో BART ఎలా పనిచేస్తుందో వివరిస్తాము, ఆపై మీరు చివరిలో T5ను ఫైన్‌ట్యూన్ చేయడానికి ప్రయత్నించవచ్చు.

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bart_architecture.png" />
</div>

1. BART యొక్క ఎన్‌కోడర్ ఆర్కిటెక్చర్ BERTకు చాలా సారూప్యంగా ఉంటుంది మరియు టెక్స్ట్ యొక్క టోకెన్ మరియు పొజిషనల్ ఎంబెడ్డింగ్‌ను అంగీకరిస్తుంది. BART ఇన్‌పుట్‌ను పాడు చేసి ఆపై దానిని డీకోడర్‌తో పునర్నిర్మించడం ద్వారా ముందే శిక్షణ పొందింది. నిర్దిష్ట కరప్షన్ వ్యూహాలు ఉన్న ఇతర ఎన్‌కోడర్‌ల వలె కాకుండా, BART ఏ రకమైన కరప్షన్‌ను అయినా వర్తింపజేయగలదు. _text infilling_ కరప్షన్ వ్యూహం ఉత్తమంగా పనిచేస్తుంది. టెక్స్ట్ ఇన్ఫిలింగ్‌లో, అనేక టెక్స్ట్ స్పాన్‌లు ఒక **సింగిల్** [`mask`] టోకెన్‌తో భర్తీ చేయబడతాయి. ఇది ముఖ్యం ఎందుకంటే మోడల్ మాస్క్ చేసిన టోకెన్‌లను అంచనా వేయాలి, మరియు ఇది మోడల్‌కు తప్పిపోయిన టోకెన్‌ల సంఖ్యను అంచనా వేయడం నేర్పుతుంది. ఇన్‌పుట్ ఎంబెడ్డింగ్‌లు మరియు మాస్క్ చేసిన స్పాన్‌లు ఎన్‌కోడర్ ద్వారా పంపబడి చివరి దాచిన స్థితులను అవుట్‌పుట్ చేస్తాయి, కానీ BERT వలె కాకుండా, BART ఒక పదాన్ని అంచనా వేయడానికి చివరిలో ఒక ఫైనల్ ఫీడ్‌ఫార్వర్డ్ నెట్‌వర్క్‌ను జోడించదు.

2. ఎన్‌కోడర్ యొక్క అవుట్‌పుట్ డీకోడర్‌కు పంపబడుతుంది, ఇది మాస్క్ చేసిన టోకెన్‌లను మరియు ఎన్‌కోడర్ యొక్క అవుట్‌పుట్ నుండి ఏదైనా పాడవని టోకెన్‌లను అంచనా వేయాలి. ఇది డీకోడర్‌కు అసలు టెక్స్ట్‌ను పునరుద్ధరించడానికి అదనపు సందర్భాన్ని ఇస్తుంది. డీకోడర్ నుండి వచ్చే అవుట్‌పుట్‌ను ఒక లాంగ్వేజ్ మోడలింగ్ హెడ్‌కు పంపబడుతుంది, ఇది దాచిన స్థితులను లాజిట్స్‌గా మార్చడానికి ఒక లీనియర్ ట్రాన్స్‌ఫర్మేషన్ చేస్తుంది. లాజిట్స్ మరియు లేబుల్ మధ్య క్రాస్-ఎంట్రోపీ నష్టం లెక్కించబడుతుంది, ఇది కేవలం కుడివైపు షిఫ్ట్ చేయబడిన టోకెన్.

సారాంశంలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? T5ను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [summarization guide](https://huggingface.co/docs/transformers/tasks/summarization)ను చూడండి!

<Tip>

టెక్స్ట్ జనరేషన్ గురించి మరింత సమాచారం కోసం, [text generation strategies](https://huggingface.co/docs/transformers/generation_strategies) గైడ్‌ను చూడండి!

</Tip>

### అనువాదం

అనువాదం అనేది ఒక భాష నుండి మరొక భాషకు టెక్స్ట్‌ను దాని అర్థాన్ని కాపాడుకుంటూ మార్చడం. అనువాదం కూడా ఒక సీక్వెన్స్-టు-సీక్వెన్స్ పనికి ఉదాహరణ, అంటే మీరు దీన్ని చేయడానికి [BART](https://huggingface.co/docs/transformers/model_doc/bart) లేదా [T5](model_doc/t5) వంటి ఎన్‌కోడర్-డీకోడర్ మోడల్‌ను ఉపయోగించవచ్చు. మేము ఈ విభాగంలో BART ఎలా పనిచేస్తుందో వివరిస్తాము, ఆపై మీరు చివరిలో T5ను ఫైన్‌ట్యూన్ చేయడానికి ప్రయత్నించవచ్చు.

BART ఒక మూల భాషను లక్ష్య భాషలోకి డీకోడ్ చేయగల ఇన్‌పుట్‌గా మ్యాప్ చేయడానికి ఒక ప్రత్యేక యాదృచ్ఛికంగా ప్రారంభించబడిన ఎన్‌కోడర్‌ను జోడించడం ద్వారా అనువాదానికి అనుగుణంగా ఉంటుంది. ఈ కొత్త ఎన్‌కోడర్ యొక్క ఎంబెడ్డింగ్‌లు అసలు వర్డ్ ఎంబెడ్డింగ్‌లకు బదులుగా ముందే శిక్షణ పొందిన ఎన్‌కోడర్‌కు పంపబడతాయి. మూల ఎన్‌కోడర్ మోడల్ అవుట్‌పుట్ నుండి క్రాస్-ఎంట్రోపీ నష్టంతో మూల ఎన్‌కోడర్, పొజిషనల్ ఎంబెడ్డింగ్‌లు మరియు ఇన్‌పుట్ ఎంబెడ్డింగ్‌లను నవీకరించడం ద్వారా శిక్షణ పొందుతుంది. మోడల్ పారామితులు ఈ మొదటి దశలో ఫ్రీజ్ చేయబడతాయి, మరియు అన్ని మోడల్ పారామితులు రెండవ దశలో కలిసి శిక్షణ పొందుతాయి.
BART తరువాత అనేక విభిన్న భాషలపై ముందే శిక్షణ పొందిన అనువాదం కోసం ఉద్దేశించిన బహుభాషా వెర్షన్, mBART, ను అనుసరించింది.

అనువాదంలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? T5ను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [translation guide](https://huggingface.co/docs/transformers/tasks/translation)ను చూడండి!

<Tip>

ఈ గైడ్ అంతటా మీరు చూసినట్లుగా, అనేక మోడల్స్ వేర్వేరు పనులను పరిష్కరించినప్పటికీ ఇలాంటి నమూనాలను అనుసరిస్తాయి. ఈ సాధారణ నమూనాలను అర్థం చేసుకోవడం కొత్త మోడల్స్ ఎలా పనిచేస్తాయో మరియు మీ నిర్దిష్ట అవసరాలకు అనుగుణంగా ఉన్న మోడల్స్‌ను ఎలా మార్చుకోవాలో త్వరగా గ్రహించడంలో మీకు సహాయపడుతుంది.

</Tip>

## టెక్స్ట్ దాటిన మోడాలిటీలు

Transformers టెక్స్ట్‌కు పరిమితం కాదు. అవి ప్రసంగం మరియు ఆడియో, చిత్రాలు మరియు వీడియో వంటి ఇతర మోడాలిటీలకు కూడా వర్తింపజేయబడతాయి. వాస్తవానికి, ఈ కోర్సులో మనం టెక్స్ట్‌పై దృష్టి పెడతాము, కానీ మనం ఇతర మోడాలిటీలను క్లుప్తంగా పరిచయం చేయవచ్చు.

### ప్రసంగం మరియు ఆడియో

టెక్స్ట్ లేదా చిత్రాలతో పోలిస్తే ప్రత్యేకమైన సవాళ్లను ఎదుర్కొనే ప్రసంగం మరియు ఆడియో డేటాను Transformer మోడల్స్ ఎలా నిర్వహిస్తాయో అన్వేషించడం ద్వారా ప్రారంభిద్దాం.

[Whisper](https://huggingface.co/docs/transformers/main/en/model_doc/whisper) అనేది 680,000 గంటల లేబుల్ చేయబడిన ఆడియో డేటాపై ముందే శిక్షణ పొందిన ఒక ఎన్‌కోడర్-డీకోడర్ (సీక్వెన్స్-టు-సీక్వెన్స్) ట్రాన్స్‌ఫార్మర్. ఈ మొత్తం ప్రీ-ట్రైనింగ్ డేటా ఇంగ్లీష్ మరియు అనేక ఇతర భాషలలో ఆడియో పనులపై జీరో-షాట్ పనితీరును సాధ్యం చేస్తుంది. డీకోడర్ Whisperకు దాని నేర్చుకున్న ప్రసంగ ప్రాతినిధ్యాలను టెక్స్ట్ వంటి ఉపయోగకరమైన అవుట్‌పుట్‌లకు, అదనపు ఫైన్-ట్యూనింగ్ లేకుండా మ్యాప్ చేయడానికి అనుమతిస్తుంది. Whisper బాక్స్ నుండి నేరుగా పనిచేస్తుంది.

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/whisper_architecture.png" />
</div>

ఈ రేఖాచిత్రం [Whisper పేపర్](https://huggingface.co/papers/2212.04356) నుండి తీసుకోబడింది.

ఈ మోడల్‌లో రెండు ప్రధాన భాగాలు ఉన్నాయి:

1. ఒక **ఎన్‌కోడర్** ఇన్‌పుట్ ఆడియోను ప్రాసెస్ చేస్తుంది. ముడి ఆడియో మొదట ఒక లాగ్-మెల్ స్పెక్ట్రోగ్రామ్‌గా మార్చబడుతుంది. ఈ స్పెక్ట్రోగ్రామ్ ఆపై ఒక Transformer ఎన్‌కోడర్ నెట్‌వర్క్ ద్వారా పంపబడుతుంది.

2. ఒక **డీకోడర్** ఎన్‌కోడ్ చేయబడిన ఆడియో ప్రాతినిధ్యాన్ని తీసుకుని మరియు అనుగుణమైన టెక్స్ట్ టోకెన్‌లను ఆటోరిగ్రెసివ్‌గా అంచనా వేస్తుంది. ఇది ఒక ప్రామాణిక Transformer డీకోడర్, ఇది మునుపటి టోకెన్‌లు మరియు ఎన్‌కోడర్ అవుట్‌పుట్ ఆధారంగా తదుపరి టెక్స్ట్ టోకెన్‌ను అంచనా వేయడానికి శిక్షణ పొందింది. డీకోడర్ ఇన్‌పుట్ ప్రారంభంలో ప్రత్యేక టోకెన్‌లు ట్రాన్స్‌క్రిప్షన్, అనువాదం, లేదా భాషా గుర్తింపు వంటి నిర్దిష్ట పనుల వైపు మోడల్‌ను నడిపించడానికి ఉపయోగించబడతాయి.

Whisper వెబ్ నుండి సేకరించిన 680,000 గంటల లేబుల్ చేయబడిన ఆడియో డేటా యొక్క భారీ మరియు విభిన్న డేటాసెట్‌పై ముందే శిక్షణ పొందింది. ఈ భారీ-స్థాయి, బలహీనంగా పర్యవేక్షించబడిన ప్రీ-ట్రైనింగ్ దాని బలమైన జీరో-షాట్ పనితీరుకు అనేక భాషలు మరియు పనులలో కీలకం.

ఇప్పుడు Whisper ముందే శిక్షణ పొందింది, మీరు దానిని జీరో-షాట్ ఇన్ఫరెన్స్ కోసం నేరుగా ఉపయోగించవచ్చు లేదా ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్ లేదా స్పీచ్ ట్రాన్స్‌లేషన్ వంటి నిర్దిష్ట పనులపై మెరుగైన పనితీరు కోసం మీ డేటాపై ఫైన్‌ట్యూన్ చేయవచ్చు!

<Tip>

Whisperలోని కీలకమైన ఆవిష్కరణ దాని శిక్షణ, ఇది ఇంటర్నెట్ నుండి అపూర్వమైన స్థాయిలో విభిన్న, బలహీనంగా పర్యవేక్షించబడిన ఆడియో డేటాపై జరిగింది. ఇది పని-నిర్దిష్ట ఫైన్‌ట్యూనింగ్ లేకుండా విభిన్న భాషలు, యాసలు మరియు పనులకు అసాధారణంగా బాగా సాధారణీకరించడానికి అనుమతిస్తుంది.

</Tip>

### ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్

ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్ కోసం ముందే శిక్షణ పొందిన మోడల్‌ను ఉపయోగించడానికి, మీరు దాని పూర్తి ఎన్‌కోడర్-డీకోడర్ నిర్మాణాన్ని ఉపయోగించుకుంటారు. ఎన్‌కోడర్ ఆడియో ఇన్‌పుట్‌ను ప్రాసెస్ చేస్తుంది, మరియు డీకోడర్ ట్రాన్స్‌క్రిప్ట్‌ను టోకెన్ ద్వారా టోకెన్ ఆటోరిగ్రెసివ్‌గా ఉత్పత్తి చేస్తుంది. ఫైన్-ట్యూనింగ్ చేసేటప్పుడు, ఆడియో ఇన్‌పుట్ ఆధారంగా సరైన టెక్స్ట్ టోకెన్‌లను అంచనా వేయడానికి మోడల్ సాధారణంగా ఒక ప్రామాణిక సీక్వెన్స్-టు-సీక్వెన్స్ నష్టాన్ని (క్రాస్-ఎంట్రోపీ వంటివి) ఉపయోగించి శిక్షణ పొందుతుంది.

ఇన్ఫరెన్స్ కోసం ఫైన్-ట్యూన్ చేసిన మోడల్‌ను ఉపయోగించడానికి సులభమైన మార్గం `pipeline` లోపల.

```python
from transformers import pipeline

transcriber = pipeline(
    task="automatic-speech-recognition", model="openai/whisper-base.en"
)
transcriber("https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac")
# Output: {'text': ' I have a dream that one day this nation will rise up and live out the true meaning of its creed.'}
```

ఆటోమేటిక్ స్పీచ్ రికగ్నిషన్‌లో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? Whisperను ఫైన్‌ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [automatic speech recognition guide](https://huggingface.co/docs/transformers/tasks/asr)ను చూడండి!

### కంప్యూటర్ విజన్

ఇప్పుడు మనం కంప్యూటర్ విజన్ పనులకు వెళ్దాం, ఇవి చిత్రాలు లేదా వీడియోల నుండి దృశ్య సమాచారాన్ని అర్థం చేసుకోవడం మరియు వ్యాఖ్యానించడంతో వ్యవహరిస్తాయి.

కంప్యూటర్ విజన్ పనులను సంప్రదించడానికి రెండు మార్గాలు ఉన్నాయి:

1. ఒక చిత్రాన్ని ప్యాచ్‌ల క్రమంగా విభజించి మరియు వాటిని ఒక Transformerతో సమాంతరంగా ప్రాసెస్ చేయండి.
2. [ConvNeXT](https://huggingface.co/docs/transformers/model_doc/convnext) వంటి ఆధునిక CNNను ఉపయోగించండి, ఇది కన్వల్యూషనల్ లేయర్‌లపై ఆధారపడుతుంది కానీ ఆధునిక నెట్‌వర్క్ డిజైన్‌లను అనుసరిస్తుంది.

<Tip>

మూడవ విధానం Transformersను కన్వల్యూషన్‌లతో మిళితం చేస్తుంది (ఉదాహరణకు, [Convolutional Vision Transformer](https://huggingface.co/docs/transformers/model_doc/cvt) లేదా [LeViT](https://huggingface.co/docs/transformers/model_doc/levit)). మనం వాటిని చర్చించము ఎందుకంటే అవి ఇక్కడ మనం పరిశీలించే రెండు విధానాలను మిళితం చేస్తాయి.

</Tip>

ViT మరియు ConvNeXT సాధారణంగా ఇమేజ్ వర్గీకరణ కోసం ఉపయోగించబడతాయి, కానీ వస్తువు గుర్తింపు, సెగ్మెంటేషన్, మరియు డెప్త్ ఎస్టిమేషన్ వంటి ఇతర దృష్టి పనుల కోసం, మనం వరుసగా DETR, Mask2Former మరియు GLPNలను పరిశీలిస్తాము; ఈ మోడల్స్ ఆ పనులకు బాగా సరిపోతాయి.

### ఇమేజ్ వర్గీకరణ

ఇమేజ్ వర్గీకరణ అనేది ప్రాథమిక కంప్యూటర్ విజన్ పనులలో ఒకటి. వివిధ మోడల్ ఆర్కిటెక్చర్లు ఈ సమస్యను ఎలా సంప్రదిస్తాయో చూద్దాం.

ViT మరియు ConvNeXT రెండూ ఇమేజ్ వర్గీకరణ కోసం ఉపయోగించబడతాయి; ప్రధాన వ్యత్యాసం ఏమిటంటే ViT ఒక అటెన్షన్ మెకానిజంను ఉపయోగిస్తుంది, అయితే ConvNeXT కన్వల్యూషన్‌లను ఉపయోగిస్తుంది.

[ViT](https://huggingface.co/docs/transformers/model_doc/vit) కన్వల్యూషన్‌లను పూర్తిగా ఒక స్వచ్ఛమైన Transformer ఆర్కిటెక్చర్‌తో భర్తీ చేస్తుంది. మీరు అసలు Transformerతో పరిచయం ఉంటే, మీరు ఇప్పటికే ViTను అర్థం చేసుకోవడానికి చాలా దూరం వచ్చారు.

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vit_architecture.jpg" />
</div>

ViT ప్రవేశపెట్టిన ప్రధాన మార్పు చిత్రాలు ఒక Transformerకు ఎలా ఇవ్వబడతాయి అనే దానిలో ఉంది:

1. ఒక చిత్రం చదరపు అతివ్యాప్తి లేని ప్యాచ్‌లుగా విభజించబడుతుంది, ప్రతి ఒక్కటి ఒక వెక్టర్ లేదా *ప్యాచ్ ఎంబెడ్డింగ్‌*గా మార్చబడుతుంది. ప్యాచ్ ఎంబెడ్డింగ్‌లు ఒక కన్వల్యూషనల్ 2D లేయర్ నుండి రూపొందించబడతాయి, ఇది సరైన ఇన్‌పుట్ డైమెన్షన్‌లను సృష్టిస్తుంది (ఇది బేస్ Transformer కోసం ప్రతి ప్యాచ్ ఎంబెడ్డింగ్‌కు 768 విలువలు). మీరు ఒక 224x224 పిక్సెల్ చిత్రం కలిగి ఉంటే, మీరు దానిని 196 16x16 ఇమేజ్ ప్యాచ్‌లుగా విభజించవచ్చు. టెక్స్ట్ పదాలుగా టోకనైజ్ చేయబడినట్లే, ఒక చిత్రం ప్యాచ్‌ల క్రమంగా "టోకనైజ్" చేయబడుతుంది.

2. ఒక _లెర్నబుల్ ఎంబెడ్డింగ్_ - ఒక ప్రత్యేక `[CLS]` టోకెన్ - BERT వలె ప్యాచ్ ఎంబెడ్డింగ్‌ల ప్రారంభంలో జోడించబడుతుంది. `[CLS]` టోకెన్ యొక్క చివరి దాచిన స్థితి జతచేయబడిన వర్గీకరణ హెడ్‌కు ఇన్‌పుట్‌గా ఉపయోగించబడుతుంది; ఇతర అవుట్‌పుట్‌లు విస్మరించబడతాయి. ఈ టోకెన్ మోడల్‌కు చిత్రం యొక్క ప్రాతినిధ్యాన్ని ఎలా ఎన్‌కోడ్ చేయాలో నేర్చుకోవడంలో సహాయపడుతుంది.

3. ప్యాచ్ మరియు లెర్నబుల్ ఎంబెడ్డింగ్‌లకు జోడించాల్సిన చివరి విషయం _పొజిషన్ ఎంబెడ్డింగ్‌లు_ ఎందుకంటే మోడల్‌కు ఇమేజ్ ప్యాచ్‌లు ఎలా ఆర్డర్ చేయబడ్డాయో తెలియదు. పొజిషన్ ఎంబెడ్డింగ్‌లు కూడా లెర్నబుల్ మరియు ప్యాచ్ ఎంబెడ్డింగ్‌ల వలె అదే పరిమాణాన్ని కలిగి ఉంటాయి. చివరగా, అన్ని ఎంబెడ్డింగ్‌లు Transformer ఎన్‌కోడర్‌కు పంపబడతాయి.

4. అవుట్‌పుట్, ప్రత్యేకంగా `[CLS]` టోకెన్‌తో ఉన్న అవుట్‌పుట్ మాత్రమే, ఒక మల్టీలేయర్ పెర్సెప్ట్రాన్ హెడ్ (MLP)కు పంపబడుతుంది. ViT యొక్క ప్రీ-ట్రైనింగ్ లక్ష్యం కేవలం వర్గీకరణ. ఇతర వర్గీకరణ హెడ్‌ల వలె, MLP హెడ్ అవుట్‌పుట్‌ను తరగతి లేబుల్స్‌పై లాజిట్స్‌గా మార్చి మరియు అత్యంత సంభావ్య తరగతిని కనుగొనడానికి క్రాస్-ఎంట్రోపీ నష్టాన్ని లెక్కిస్తుంది.

ఇమేజ్ వర్గీకరణలో మీ నైపుణ్యాన్ని ప్రయత్నించడానికి సిద్ధంగా ఉన్నారా? ViTను ఫైన్-ట్యూన్ చేయడం మరియు దానిని ఇన్ఫరెన్స్ కోసం ఉపయోగించడం ఎలాగో తెలుసుకోవడానికి మా పూర్తి [image classification guide](https://huggingface.co/docs/transformers/tasks/image_classification)ను చూడండి!

<Tip>

ViT మరియు BERT మధ్య సమాంతరాన్ని గమనించండి: రెండూ మొత్తం ప్రాతినిధ్యాన్ని సంగ్రహించడానికి ఒక ప్రత్యేక టోకెన్ (<code>[CLS]</code>)ను ఉపయోగిస్తాయి, రెండూ వాటి ఎంబెడ్డింగ్‌లకు స్థాన సమాచారాన్ని జోడిస్తాయి, మరియు రెండూ టోకెన్‌లు/ప్యాచ్‌ల క్రమాన్ని ప్రాసెస్ చేయడానికి ఒక Transformer ఎన్‌కోడర్‌ను ఉపయోగిస్తాయి.

</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/5.mdx" />