# LLMలతో టెక్స్ట్ జనరేషన్ ఇన్ఫరెన్స్ పై లోతైన పరిశీలన [[inference-with-llms]]

<CourseFloatingBanner chapter={1} classNames="absolute z-10 right-0 top-0" />

<Youtube id="Xp2w1_LKZN4" />

ఇప్పటివరకు, మనం టెక్స్ట్ వర్గీకరణ లేదా సారాంశీకరణ వంటి వివిధ రకాల పనులకు సంబంధించి ట్రాన్స్‌ఫార్మర్ ఆర్కిటెక్చర్‌ను అన్వేషించాము. అయితే, Large Language Models (LLMలు) ఎక్కువగా టెక్స్ట్ జనరేషన్ కోసం ఉపయోగించబడతాయి మరియు ఈ అధ్యాయంలో మనం దీనినే అన్వేషిస్తాము.

ఈ పేజీలో, మనం LLM ఇన్ఫరెన్స్ వెనుక ఉన్న ముఖ్యమైన భావనలను అన్వేషిస్తాము. ఈ మోడల్స్ టెక్స్ట్‌ను ఎలా ఉత్పత్తి చేస్తాయి మరియు ఇన్ఫరెన్స్ ప్రక్రియలో కీలకమైన అంశాలు ఏమిటో సమగ్ర అవగాహనను అందిస్తాము.

## ప్రాథమికాలను అర్థం చేసుకోవడం

ప్రాథమిక అంశాలతో ప్రారంభిద్దాం. ఇన్ఫరెన్స్ అనేది, శిక్షణ పొందిన LLMను ఉపయోగించి, ఇచ్చిన ఇన్‌పుట్ ప్రాంప్ట్ నుండి మానవ-సహజమైన టెక్స్ట్‌ను ఉత్పత్తి చేసే ప్రక్రియ. భాషా నమూనాలు తమ శిక్షణ నుండి పొందిన జ్ఞానాన్ని ఉపయోగించి, ఒకేసారి ఒక్కో పదాన్ని స్పందనలుగా రూపొందిస్తాయి. మోడల్, బిలియన్ల పారామితుల నుండి నేర్చుకున్న సంభావ్యతలను (probabilities) ఉపయోగించి, ఒక క్రమంలో తదుపరి టోకెన్‌ను అంచనా వేసి, ఉత్పత్తి చేస్తుంది. ఈ వరుస ఉత్పత్తి ప్రక్రియే LLMలను పొందికగా మరియు సందర్భోచితంగా ఉండే టెక్స్ట్‌ను రూపొందించడానికి అనుమతిస్తుంది.

## అటెన్షన్ పాత్ర

అటెన్షన్ మెకానిజం, LLMలకు సందర్భాన్ని అర్థం చేసుకుని, పొందికైన ప్రతిస్పందనలను ఉత్పత్తి చేసే సామర్థ్యాన్ని ఇస్తుంది. తదుపరి పదాన్ని అంచనా వేసేటప్పుడు, ఒక వాక్యంలోని ప్రతి పదానికి సమాన ప్రాధాన్యత ఉండదు - ఉదాహరణకు, "The capital of France is ..." అనే వాక్యంలో, "France" మరియు "capital" అనే పదాలు తదుపరి పదం "Paris" అని నిర్ధారించడానికి చాలా ముఖ్యమైనవి. సంబంధిత సమాచారంపై దృష్టి పెట్టే ఈ సామర్థ్యాన్ని మనం అటెన్షన్ అని పిలుస్తాము.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AttentionSceneFinal.gif" alt="Visual Gif of Attention" width="60%">

తదుపరి టోకెన్‌ను అంచనా వేయడానికి అత్యంత సంబంధిత పదాలను గుర్తించే ఈ ప్రక్రియ అద్భుతంగా ప్రభావవంతమైనదని నిరూపించబడింది. BERT మరియు GPT-2 కాలం నుండి LLMలకు శిక్షణ ఇచ్చే ప్రాథమిక సూత్రం — తదుపరి టోకెన్‌ను అంచనా వేయడం — సాధారణంగా స్థిరంగా ఉన్నప్పటికీ, న్యూరల్ నెట్‌వర్క్‌లను స్కేల్ చేయడంలో మరియు అటెన్షన్ మెకానిజంను తక్కువ ఖర్చుతో, సుదీర్ఘమైన సీక్వెన్స్‌ల కోసం పనిచేసేలా చేయడంలో గణనీయమైన పురోగతి సాధించబడింది.

<Tip>

సంక్షిప్తంగా, LLMలు పొందికగా మరియు సందర్భానుసారంగా ఉండే టెక్స్ట్‌ను ఉత్పత్తి చేయగలగడానికి అటెన్షన్ మెకానిజం కీలకం. ఇది ఆధునిక LLMలను పాత తరం భాషా నమూనాల నుండి వేరుగా నిలుపుతుంది.

</Tip>

### కాంటెక్స్ట్ లెంగ్త్ మరియు అటెన్షన్ స్పాన్

ఇప్పుడు మనం అటెన్షన్ గురించి అర్థం చేసుకున్నాం కాబట్టి, ఒక LLM వాస్తవానికి ఎంత కాంటెక్స్ట్‌ను నిర్వహించగలదో అన్వేషిద్దాం. ఇది మనల్ని కాంటెక్స్ట్ లెంగ్త్, లేదా మోడల్ యొక్క 'అటెన్షన్ స్పాన్' వద్దకు తీసుకువస్తుంది.

కాంటెక్స్ట్ లెంగ్త్ అనేది LLM ఒకేసారి ప్రాసెస్ చేయగల గరిష్ట సంఖ్య టోకెన్‌లను (పదాలు లేదా పదాల భాగాలు) సూచిస్తుంది. దీనిని మోడల్ యొక్క వర్కింగ్ మెమరీ పరిమాణంగా భావించండి.

ఈ సామర్థ్యాలు అనేక ఆచరణాత్మక కారకాల ద్వారా పరిమితం చేయబడ్డాయి:

- మోడల్ యొక్క ఆర్కిటెక్చర్ మరియు పరిమాణం
- అందుబాటులో ఉన్న కంప్యూటేషనల్ వనరులు
- ఇన్‌పుట్ మరియు కావలసిన అవుట్‌పుట్ యొక్క సంక్లిష్టత

ఒక ఆదర్శ ప్రపంచంలో, మనం మోడల్‌కు అపరిమితమైన కాంటెక్స్ట్‌ను అందించవచ్చు, కానీ హార్డ్‌వేర్ పరిమితులు మరియు గణన ఖర్చులు దీనిని అసాధ్యం చేస్తాయి. అందుకే సామర్థ్యాన్ని మరియు సమర్థతను సమతుల్యం చేయడానికి వివిధ మోడల్స్ వివిధ కాంటెక్స్ట్ లెంగ్త్‌లతో రూపొందించబడ్డాయి.

<Tip>

కాంటెక్స్ట్ లెంగ్త్ అనేది, స్పందనను ఉత్పత్తి చేసేటప్పుడు మోడల్ ఒకేసారి పరిగణించగల గరిష్ట టోకెన్‌ల సంఖ్య.

</Tip>

### ప్రాంప్టింగ్ కళ

మనం LLMలకు సమాచారాన్ని అందించినప్పుడు, LLM యొక్క జనరేషన్‌ను కావలసిన అవుట్‌పుట్ వైపు నడిపించే విధంగా మన ఇన్‌పుట్‌ను రూపొందిస్తాము. దీనిని ప్రాంప్టింగ్ అని అంటారు.

LLMలు సమాచారాన్ని ఎలా ప్రాసెస్ చేస్తాయో అర్థం చేసుకోవడం, మెరుగైన ప్రాంప్ట్‌లను రూపొందించడంలో మనకు సహాయపడుతుంది. మోడల్ యొక్క ప్రాథమిక విధి ప్రతి ఇన్‌పుట్ టోకెన్ యొక్క ప్రాముఖ్యతను విశ్లేషించడం ద్వారా తదుపరి టోకెన్‌ను అంచనా వేయడం కాబట్టి, మీ ఇన్‌పుట్ సీక్వెన్స్ యొక్క పదజాలం చాలా కీలకమైనది.

<Tip>

ప్రాంప్ట్‌ను జాగ్రత్తగా రూపొందించడం వల్ల LLM జనరేషన్‌ను కావలసిన అవుట్‌పుట్ వైపు నడిపించడం సులభం అవుతుంది.

</Tip>

## రెండు-దశల ఇన్ఫరెన్స్ ప్రక్రియ

ఇప్పుడు మనం ప్రాథమిక భాగాలను అర్థం చేసుకున్నాం కాబట్టి, LLMలు వాస్తవానికి టెక్స్ట్‌ను ఎలా ఉత్పత్తి చేస్తాయో లోతుగా చూద్దాం. ఈ ప్రక్రియను రెండు ప్రధాన దశలుగా విభజించవచ్చు: ప్రీఫిల్ (prefill) మరియు డీకోడ్ (decode). ఈ దశలు ఒక అసెంబ్లీ లైన్ లాగా కలిసి పనిచేస్తాయి, పొందికైన టెక్స్ట్‌ను ఉత్పత్తి చేయడంలో ప్రతి ఒక్కటి కీలక పాత్ర పోషిస్తుంది.

### ప్రీఫిల్ దశ

ప్రీఫిల్ దశ వంటలో తయారీ దశ లాంటిది - ఇక్కడ అన్ని ప్రారంభ పదార్థాలు ప్రాసెస్ చేయబడి సిద్ధంగా ఉంటాయి. ఈ దశలో మూడు కీలక దశలు ఉంటాయి:

1. **టోకనైజేషన్**: ఇన్‌పుట్ టెక్స్ట్‌ను టోకెన్‌లుగా మార్చడం (వీటిని మోడల్ అర్థం చేసుకునే ప్రాథమిక బిల్డింగ్ బ్లాక్‌లుగా భావించండి)
2. **ఎంబెడ్డింగ్ మార్పిడి**: ఈ టోకెన్‌లను వాటి అర్థాన్ని సంగ్రహించే సంఖ్యా ప్రాతినిధ్యాలుగా మార్చడం
3. **ప్రారంభ ప్రాసెసింగ్**: కాంటెక్స్ట్ యొక్క గొప్ప అవగాహనను సృష్టించడానికి ఈ ఎంబెడ్డింగ్‌లను మోడల్ యొక్క న్యూరల్ నెట్‌వర్క్‌ల ద్వారా అమలు చేయడం

ఈ దశ కంప్యూటేషనల్‌గా చాలా తీవ్రమైనది ఎందుకంటే ఇది అన్ని ఇన్‌పుట్ టోకెన్‌లను ఒకేసారి ప్రాసెస్ చేయాలి. ఒక ప్రతిస్పందన రాయడం ప్రారంభించే ముందు ఒక పూర్తి పేరా చదివి అర్థం చేసుకున్నట్లుగా దీనిని భావించండి.

కింది ఇంటరాక్టివ్ ప్లేగ్రౌండ్‌లో మీరు వివిధ టోకనైజర్‌లతో ప్రయోగాలు చేయవచ్చు:

<iframe
  src="https://agents-course-the-tokenizer-playground.static.hf.space"
  frameborder="0"
  width="850"
  height="450"
></iframe>

### డీకోడ్ దశ

ప్రీఫిల్ దశ ఇన్‌పుట్‌ను ప్రాసెస్ చేసిన తర్వాత, మనం డీకోడ్ దశకు వెళ్తాము - ఇక్కడే అసలు టెక్స్ట్ జనరేషన్ జరుగుతుంది. మోడల్ ఒక ఆటోరిగ్రెసివ్ ప్రక్రియలో (ఇక్కడ ప్రతి కొత్త టోకెన్ మునుపటి అన్ని టోకెన్లపై ఆధారపడి ఉంటుంది) ఒకేసారి ఒక్కో టోకెన్‌ను ఉత్పత్తి చేస్తుంది.

డీకోడ్ దశలో ప్రతి కొత్త టోకెన్ కోసం జరిగే అనేక కీలక దశలు ఉంటాయి:

1. **అటెన్షన్ కంప్యూటేషన్**: కాంటెక్స్ట్‌ను అర్థం చేసుకోవడానికి మునుపటి అన్ని టోకెన్‌లను తిరిగి చూడటం
2. **సంభావ్యత గణన**: సాధ్యమయ్యే ప్రతి తదుపరి టోకెన్ యొక్క సంభావ్యతను నిర్ణయించడం
3. **టోకెన్ ఎంపిక**: ఈ సంభావ్యతల ఆధారంగా తదుపరి టోకెన్‌ను ఎంచుకోవడం
4. **కొనసాగింపు తనిఖీ**: జనరేషన్‌ను కొనసాగించాలా లేదా ఆపాలా అని నిర్ణయించడం

ఈ దశ మెమరీ-ఇంటెన్సివ్ ఎందుకంటే మోడల్ గతంలో ఉత్పత్తి చేయబడిన అన్ని టోకెన్‌లను మరియు వాటి సంబంధాలను గుర్తుంచుకోవాలి.

## శాంప్లింగ్ వ్యూహాలు

ఇప్పుడు మనం మోడల్ టెక్స్ట్‌ను ఎలా ఉత్పత్తి చేస్తుందో అర్థం చేసుకున్నాం కాబట్టి, ఈ జనరేషన్ ప్రక్రియను మనం నియంత్రించగల వివిధ మార్గాలను అన్వేషిద్దాం. ఒక రచయిత మరింత సృజనాత్మకంగా లేదా మరింత కచ్చితంగా ఉండటానికి మధ్య ఎంచుకున్నట్లే, మోడల్ తన టోకెన్ ఎంపికలను ఎలా చేయాలో మనం సర్దుబాటు చేయవచ్చు.

ఈ స్పేస్‌లో SmolLM2 తో మీరు ప్రాథమిక డీకోడింగ్ ప్రక్రియతో స్వయంగా ఇంటరాక్ట్ అవ్వవచ్చు (గుర్తుంచుకోండి, ఇది ఈ మోడల్‌కు **EOS** అయిన `<|im_end|>` టోకెన్‌ను చేరుకునే వరకు డీకోడ్ చేస్తుంది):

<iframe
  src="https://agents-course-decoding-visualizer.hf.space"
  frameborder="0"
  width="850"
  height="450"
></iframe>

### టోకెన్ ఎంపికను అర్థం చేసుకోవడం: సంభావ్యతల నుండి టోకెన్ ఎంపికల వరకు

మోడల్ తదుపరి టోకెన్‌ను ఎంచుకోవలసి వచ్చినప్పుడు, అది దాని పదజాలంలోని ప్రతి పదానికి ముడి సంభావ్యతలతో (logits అని పిలుస్తారు) ప్రారంభమవుతుంది. కానీ ఈ సంభావ్యతలను మనం అసలు ఎంపికలుగా ఎలా మారుస్తాం? ప్రక్రియను విభజించి చూద్దాం:

![image](https://huggingface.co/reasoning-course/images/resolve/main/inference/1.png)

1. **రా లాజిట్స్ (Raw Logits)**: సాధ్యమైన ప్రతి తదుపరి పదం గురించి మోడల్ యొక్క ప్రారంభ అంతర్ దృష్టిగా వీటిని భావించండి
2. **టెంపరేచర్ కంట్రోల్**: ఒక క్రియేటివిటీ డయల్ లాంటిది - అధిక సెట్టింగ్‌లు `(>1.0)` ఎంపికలను మరింత యాదృచ్ఛికంగా మరియు సృజనాత్మకంగా చేస్తాయి, తక్కువ సెట్టింగ్‌లు `(<1.0)` వాటిని మరింత కేంద్రీకృతంగా మరియు నిర్ధారితంగా చేస్తాయి
3. **టాప్-పి (న్యూక్లియస్) శాంప్లింగ్**: సాధ్యమయ్యే అన్ని పదాలను పరిగణలోకి తీసుకోకుండా, మనం ఎంచుకున్న సంభావ్యత థ్రెషోల్డ్‌కు (ఉదా., టాప్ 90%) సరిపోయే అత్యంత సంభావ్య పదాలను మాత్రమే చూస్తాము
4. **టాప్-కె ఫిల్టరింగ్**: ఒక ప్రత్యామ్నాయ విధానం, ఇక్కడ మనం k అత్యంత సంభావ్య తదుపరి పదాలను మాత్రమే పరిగణలోకి తీసుకుంటాము

### పునరావృత్తిని నిర్వహించడం: అవుట్‌పుట్‌ను తాజాగా ఉంచడం

LLMలతో ఒక సాధారణ సవాలు ఏమిటంటే, అవి తమను తాము పునరావృతం చేసుకునే ధోరణి - ఒకే పాయింట్లకు పదేపదే తిరిగివచ్చే స్పీకర్ లాగా. దీనిని పరిష్కరించడానికి, మేము రెండు రకాల పెనాల్టీలను ఉపయోగిస్తాము:

1. **ప్రెజెన్స్ పెనాల్టీ (Presence Penalty)**: ఇదివరకు కనిపించిన ఏ టోకెన్‌కైనా, అది ఎంత తరచుగా కనిపించినా వర్తించే ఒక స్థిరమైన పెనాల్టీ. ఇది మోడల్ అదే పదాలను తిరిగి ఉపయోగించకుండా నిరోధించడానికి సహాయపడుతుంది.
2. **ఫ్రీక్వెన్సీ పెనాల్టీ (Frequency Penalty)**: ఒక టోకెన్ ఎంత తరచుగా ఉపయోగించబడిందనే దానిపై ఆధారపడి పెరిగే స్కేలింగ్ పెనాల్టీ. ఒక పదం ఎంత ఎక్కువగా కనిపిస్తే, అది మళ్లీ ఎంపికయ్యే అవకాశం అంత తక్కువ.

![image](https://huggingface.co/reasoning-course/images/resolve/main/inference/2.png)

ఇతర శాంప్లింగ్ వ్యూహాలు వర్తించే ముందు, ఈ పెనాల్టీలు టోకెన్ ఎంపిక ప్రక్రియలో ప్రారంభంలోనే వర్తింపజేయబడతాయి, ముడి సంభావ్యతలను సర్దుబాటు చేస్తాయి. కొత్త పదజాలాన్ని అన్వేషించడానికి మోడల్‌ను ప్రోత్సహించే సున్నితమైన ప్రోత్సాహకాలుగా వీటిని భావించండి.

### జనరేషన్ పొడవును నియంత్రించడం: సరిహద్దులను సెట్ చేయడం

ఒక మంచి కథకు సరైన వేగం మరియు పొడవు అవసరమైనట్లే, మన LLM ఎంత టెక్స్ట్ ఉత్పత్తి చేస్తుందో నియంత్రించడానికి మనకు మార్గాలు అవసరం. ఆచరణాత్మక అనువర్తనాలకు ఇది చాలా ముఖ్యం - మనం ట్వీట్-పొడవు ప్రతిస్పందనను ఉత్పత్తి చేస్తున్నా లేదా పూర్తి బ్లాగ్ పోస్ట్‌ను ఉత్పత్తి చేస్తున్నా.

మనం జనరేషన్ పొడవును అనేక విధాలుగా నియంత్రించవచ్చు:

1. **టోకెన్ పరిమితులు**: కనీస మరియు గరిష్ట టోకెన్ల సంఖ్యను సెట్ చేయడం
2. **స్టాప్ సీక్వెన్సులు**: జనరేషన్ ముగింపును సూచించే నిర్దిష్ట నమూనాలను నిర్వచించడం
3. **ఎండ్-ఆఫ్-సీక్వెన్స్ డిటెక్షన్**: మోడల్ తన ప్రతిస్పందనను సహజంగా ముగించనివ్వడం

ఉదాహరణకు, మనం ఒకే పేరాగ్రాఫ్‌ను రూపొందించాలనుకుంటే, గరిష్టంగా 100 టోకెన్‌లను సెట్ చేసి "\n\n" ను స్టాప్ సీక్వెన్స్‌గా ఉపయోగించవచ్చు. ఇది మన అవుట్‌పుట్ దాని ప్రయోజనం కోసం కేంద్రీకృతమై మరియు తగిన పరిమాణంలో ఉండేలా చేస్తుంది.

![image](https://huggingface.co/reasoning-course/images/resolve/main/inference/3.png)

### బీమ్ సెర్చ్: మెరుగైన పొందిక కోసం ముందుకు చూడటం

ఇప్పటివరకు మనం చర్చించిన వ్యూహాలు ఒక సమయంలో ఒక్కో టోకెన్‌కు మాత్రమే నిర్ణయాలు తీసుకుంటాయి, కానీ బీమ్ సెర్చ్ మరింత సమగ్రమైన విధానాన్ని తీసుకుంటుంది. ప్రతి దశలో ఒకే ఎంపికకు కట్టుబడి ఉండటానికి బదులుగా, ఇది ఒకేసారి అనేక సాధ్యమైన మార్గాలను అన్వేషిస్తుంది - చదరంగం ఆటగాడు అనేక ఎత్తుగడలను ముందుకు ఆలోచించినట్లుగా.

![image](https://huggingface.co/reasoning-course/images/resolve/main/inference/4.png)

ఇది ఎలా పనిచేస్తుందో ఇక్కడ ఉంది:

1. ప్రతీ దశలో, అనేక అభ్యర్థి సీక్వెన్సులను (సాధారణంగా 5-10) నిర్వహించండి
2. ప్రతి అభ్యర్థికి, తదుపరి టోకెన్ కోసం సంభావ్యతలను గణించండి
3. సీక్వెన్సులు మరియు తదుపరి టోకెన్‌ల యొక్క అత్యంత ఆశాజనకమైన కలయికలను మాత్రమే ఉంచండి
4. కావలసిన పొడవు లేదా స్టాప్ కండిషన్ చేరే వరకు ఈ ప్రక్రియను కొనసాగించండి
5. అత్యధిక మొత్తం సంభావ్యత ఉన్న సీక్వెన్స్‌ను ఎంచుకోండి

మీరు బీమ్ సెర్చ్‌ను దృశ్యమానంగా ఇక్కడ అన్వేషించవచ్చు:

<iframe
  src="https://agents-course-beam-search-visualizer.hf.space"
  frameborder="0"
  width="850"
  height="450"
></iframe>

ఈ విధానం తరచుగా మరింత పొందికైన మరియు వ్యాకరణపరంగా సరైన టెక్స్ట్‌ను ఉత్పత్తి చేస్తుంది, కానీ ఇది సరళమైన పద్ధతుల కంటే ఎక్కువ కంప్యూటేషనల్ వనరులను తీసుకుంటుంది.

## ఆచరణాత్మక సవాళ్లు మరియు ఆప్టిమైజేషన్

LLM ఇన్ఫరెన్స్ అన్వేషణను ముగించే ముందు, ఈ మోడల్స్‌ను అమలు చేసేటప్పుడు మీరు ఎదుర్కొనే ఆచరణాత్మక సవాళ్లను, మరియు వాటి పనితీరును ఎలా కొలవాలి మరియు ఆప్టిమైజ్ చేయాలో చూద్దాం.

### కీలక పనితీరు కొలమానాలు

LLMలతో పనిచేసేటప్పుడు, నాలుగు కీలకమైన కొలమానాలు మీ అమలు నిర్ణయాలను తీర్చిదిద్దుతాయి:

1. **టైమ్ టు ఫస్ట్ టోకెన్ (TTFT)**: మొదటి ప్రతిస్పందనను ఎంత త్వరగా పొందగలరు? ఇది వినియోగదారు అనుభవం కోసం చాలా ముఖ్యం మరియు దీనిపై ప్రధానంగా ప్రీఫిల్ దశ ప్రభావం చూపుతుంది.
2. **టైమ్ పర్ అవుట్‌పుట్ టోకెన్ (TPOT)**: తర్వాతి టోకెన్‌లను ఎంత వేగంగా ఉత్పత్తి చేయగలరు? ఇది మొత్తం జనరేషన్ వేగాన్ని నిర్ధారిస్తుంది.
3. **త్రూపుట్ (Throughput)**: ఒకేసారి ఎన్ని అభ్యర్థనలను మీరు నిర్వహించగలరు? ఇది స్కేలింగ్ మరియు ఖర్చు సమర్థతపై ప్రభావం చూపుతుంది.
4. **VRAM వినియోగం**: మీకు ఎంత GPU మెమరీ అవసరం? వాస్తవ ప్రపంచ అప్లికేషన్‌లలో ఇది తరచుగా ప్రధాన పరిమితిగా మారుతుంది.

### కాంటెక్స్ట్ లెంగ్త్ సవాలు

LLM ఇన్ఫరెన్స్‌లో అత్యంత ముఖ్యమైన సవాళ్లలో ఒకటి కాంటెక్స్ట్ లెంగ్త్‌ను సమర్థవంతంగా నిర్వహించడం. పొడవైన కాంటెక్స్ట్‌లు ఎక్కువ సమాచారాన్ని అందిస్తాయి కానీ గణనీయమైన ఖర్చులతో వస్తాయి:

- **మెమరీ వినియోగం**: కాంటెక్స్ట్ లెంగ్త్‌తో వర్గానుపాతంలో (quadratically) పెరుగుతుంది
- **ప్రాసెసింగ్ వేగం**: పొడవైన కాంటెక్స్ట్‌లతో సరళంగా (linearly) తగ్గుతుంది
- **వనరుల కేటాయింపు**: VRAM వినియోగాన్ని జాగ్రత్తగా సమతుల్యం చేయడం అవసరం

[Qwen2.5-1M](https://huggingface.co/Qwen/Qwen2.5-14B-Instruct-1M) వంటి ఇటీవలి మోడల్స్ 1M టోకెన్ కాంటెక్స్ట్ విండోలను అందిస్తాయి, కానీ ఇది గణనీయంగా నెమ్మదిగా ఉండే ఇన్ఫరెన్స్ సమయాల ఖర్చుతో వస్తుంది. మీ నిర్దిష్ట వినియోగ సందర్భానికి సరైన సమతుల్యాన్ని కనుగొనడం కీలకం.

<div
  style="max-width: 800px; margin: 20px auto; padding: 20px; 
font-family: system-ui;"
>
  <div
    style="border: 2px solid #ddd; border-radius: 8px; 
    padding: 20px; margin-bottom: 20px;"
  >
    <div
      style="display: flex; align-items: center; 
        margin-bottom: 15px;"
    >
      <div
        style="flex: 1; text-align: center; padding: 
            10px; background: #f0f0f0; border-radius: 4px;"
      >
        Input Text (Raw)
      </div>
      <div style="margin: 0 10px;">→</div>
      <div
        style="flex: 1; text-align: center; padding: 
            10px; background: #e1f5fe; border-radius: 4px;"
      >
        Tokenized Input
      </div>
    </div>
    <div style="display: flex; margin-bottom: 15px;">
      <div
        style="flex: 1; border: 1px solid #ccc; 
            padding: 10px; margin: 5px; background: #e8f5e9; 
            border-radius: 4px; text-align: center;"
      >
        Context Window
        <br />
        (e.g., 4K tokens)
        <div style="display: flex; margin-top: 10px;">
          <div
            style="flex: 1; background: #81c784; 
                    margin: 2px; height: 20px; border-radius: 
                    2px;"
          ></div>
          <div
            style="flex: 1; background: #81c784; 
                    margin: 2px; height: 20px; border-radius: 
                    2px;"
          ></div>
          <div
            style="flex: 1; background: #81c784; 
                    margin: 2px; height: 20px; border-radius: 
                    2px;"
          ></div>
          <div
            style="flex: 1; background: #81c784; 
                    margin: 2px; height: 20px; border-radius: 
                    2px;"
          ></div>
        </div>
      </div>
    </div>
    <div
      style="display: flex; justify-content: 
        space-between; text-align: center; font-size: 0.9em; 
        color: #666;"
    >
      <div style="flex: 1;">
        <div
          style="border: 1px solid #ffcc80; padding: 
                8px; margin: 5px; background: #fff3e0; 
                border-radius: 4px;"
        >
          Memory Usage
          <br />∝ Length²
        </div>
      </div>
      <div style="flex: 1;">
        <div
          style="border: 1px solid #90caf9; padding: 
                8px; margin: 5px; background: #e3f2fd; 
                border-radius: 4px;"
        >
          Processing Time
          <br />∝ Length
        </div>
      </div>
    </div>
  </div>
</div>

### KV కాష్ ఆప్టిమైజేషన్

ఈ సవాళ్లను ఎదుర్కోవడానికి, అత్యంత శక్తివంతమైన ఆప్టిమైజేషన్‌లలో ఒకటి KV (కీ-వాల్యూ) కాషింగ్. ఈ టెక్నిక్ మధ్యంతర గణనలను నిల్వ చేయడం మరియు తిరిగి ఉపయోగించడం ద్వారా ఇన్ఫరెన్స్ వేగాన్ని గణనీయంగా మెరుగుపరుస్తుంది. ఈ ఆప్టిమైజేషన్:

- పునరావృత గణనలను తగ్గిస్తుంది
- జనరేషన్ వేగాన్ని మెరుగుపరుస్తుంది
- సుదీర్ఘ-సందర్భ (long-context) జనరేషన్‌ను ఆచరణాత్మకంగా చేస్తుంది

దీని ప్రతికూలత అదనపు మెమరీ వినియోగం, కానీ పనితీరు ప్రయోజనాలు సాధారణంగా ఈ ఖర్చును అధిగమిస్తాయి.

## ముగింపు

ఈ శక్తివంతమైన మోడల్స్‌ను సమర్థవంతంగా అమలు చేయడానికి మరియు ఆప్టిమైజ్ చేయడానికి LLM ఇన్ఫరెన్స్‌ను అర్థం చేసుకోవడం చాలా ముఖ్యం. మేము కవర్ చేసిన ముఖ్య అంశాలు:

- అటెన్షన్ మరియు కాంటెక్స్ట్ యొక్క ప్రాథమిక పాత్ర
- రెండు-దశల ఇన్ఫరెన్స్ ప్రక్రియ
- జనరేషన్‌ను నియంత్రించడానికి వివిధ శాంప్లింగ్ వ్యూహాలు
- ఆచరణాత్మక సవాళ్లు మరియు ఆప్టిమైజేషన్లు

ఈ భావనలపై పట్టు సాధించడం ద్వారా, LLMలను సమర్థవంతంగా మరియు ప్రభావవంతంగా ఉపయోగించుకునే అప్లికేషన్‌లను రూపొందించడానికి మీరు మరింత మెరుగ్గా సిద్ధమవుతారు.

LLM ఇన్ఫరెన్స్ రంగం వేగంగా అభివృద్ధి చెందుతోందని, కొత్త టెక్నిక్‌లు మరియు ఆప్టిమైజేషన్‌లు క్రమం తప్పకుండా వస్తున్నాయని గుర్తుంచుకోండి. ఆసక్తిగా ఉండండి మరియు మీ నిర్దిష్ట వినియోగ సందర్భాలకు ఏది ఉత్తమంగా పనిచేస్తుందో కనుగొనడానికి వివిధ విధానాలతో ప్రయోగాలు చేస్తూ ఉండండి.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/8.mdx" />