# คำถามท้ายบท

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

บทนี้พูดถึงพื้นฐานค่อนข้างเยอะมาก ไม่ต้องกังวลไปหากคุณไม่เข้าใจรายละเอียดทั้งหมด บทหน้าจะช่วยอธิบายว่าแต่ละอย่างทำงานกันเบื้องหลังอย่างไร

ตอนนี้มาทดสอบกันดีกว่าว่าคุณได้เรียนรู้อะไรมาบ้างในบทนี้!

### 1. เปิดหา checkpoint `roberta-large-mnli` ใน Hub โมเดลนี้ใช้ในงานอะไร


<Question
	choices={[
		{
			text: "การสรุปความ",
			explain: "โปรดดูที่<a href=\"https://huggingface.co/roberta-large-mnli\">หน้าเพจ roberta-large-mnli</a>อีกครั้ง"
		},
		{
			text: "การแยกแยะข้อความ",
			explain: "โมเดลนี้แยกแยะว่าประโยคสองประโยคนั้นเข้าข่ายกรณีใดดังต่อไปนี้ (หักล้างกัน, กลาง, ส่งเสริมกัน) หรือเรียกอีกชื่อหนึ่งว่า<em>การอนุมาน</em>",
			correct: true
		},
		{
			text: "การสร้างข้อความ",
			explain: "โปรดดูที่<a href=\"https://huggingface.co/roberta-large-mnli\">หน้าเพจ roberta-large-mnli</a>อีกครั้ง"
		}
	]}
/>

### 2. โค้ดต่อไปนี้ให้ผลลัพธ์ว่าอย่างไร?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "ได้ผลออกมาเป็นคะแนนระบุว่าประโยคดังกล่าวเป็นข้อความ \"ด้านบวก\" หรือ \"ด้านลบ\" ",
			explain: "ข้อนี้ผิด — ผลลัพธ์นี้ได้จาก pipeline <code>sentiment-analysis</code>"
		},
		{
			text: "ได้ผลออกมาเป็นข้อความที่ทำให้ประโยคสมบูรณ์",
			explain: "ข้อนี้ผิด — ผลลัพธ์นี้ได้จาก pipeline <code>text-generation</code>",
		},
		{
			text: "ได้ผลออกมาระบุว่าคำใดเป็นบุคคล, องค์กร, หรือสถานที่",
			explain: "หากตั้งค่าว่า <code>grouped_entities=True</code> จะสามารถรวมคำหลายคำที่ระบุสิ่งเดียวกันไว้ได้ เช่น \"Hugging Face\" ประกอบด้วยคำสองคำ แต่ระบุถึงสิ่งสิ่งเดียว",
			correct: true
		}
	]}
/>

### 3. เราควรแทนค่า ... ในโค้ดด้านล่างว่าอะไร?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "ข้อนี้ผิด โปรดดูรายละเอียดของโมเดล <code>bert-base-cased</code> แล้วลองตรวจสอบว่าทำผิดตรงไหนไป"
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "ถูกต้อง! โมเดลนี้ เว้นช่องว่างด้วยโทเคน [MASK]",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "ข้อนี้ผิด pipeline ระบุว่าทำงาน `fill-mask` ซึ่งก็คือการเติมคำในช่องว่าง แต่ไม่มีโทเคนใดระบุช่องว่างในประโยคเลย"
		}
	]}
/>

### 4. ทำไมโค้ดด้านล่างรันไม่ออก?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "pipline นี้ต้องการระบุ label เพื่อใช้ในการแยกแยะประโยค",
			explain: "ถูกต้อง โค้ดที่รันออกจะต้องเพิ่ม <code>candidate_labels=[...]</code> เข้าไปด้วย",
			correct: true
		},
		{
			text: "pipeline นี้ต้องการประโยค input มากกว่าหนึ่งประโยค",
			explain: "ข้อนี้ผิด ถึงแม้ว่าความจริงแล้วจะสามารถใส่ประโยคหลายประโยคเป็น list เข้าไปเป็น input เพื่อรันได้(เหมือน pipeline อื่น ๆ)"
		},
		{
			text: "library 🤗 Transformers พังแบบงง ๆ เหมือนทุกทีน่ะแหละ",
			explain: "ขออนุญาตงดแสดงความคิดเห็นกับคนเลือกข้อนี้นะ"
		},
		{
			text: "pipeline นี้ต้องการประโยค input ที่ยาวกว่านี้ ประโยคนี้สั้นเกินไป",
			explain: "ข้อนี้ผิด และหากใส่ประโยคที่ยาวเกินไปใน pipeline นี้ก็จะโดนตัดให้สั้นลงอยู่ดี"
		}
	]}
/>

### 5. "transfer learning" (การเรียนรู้แบบส่งต่อ) หมายความว่าอย่างไร?

<Question
	choices={[
		{
			text: "ส่งต่อความรู้จาก pretrain model ไปยังโมเดลใหม่โดยเทรนกับข้อมูลเดิม",
			explain: "ข้อนี้ผิด หากทำแบบนี้ก็จะเป็นการสร้างโมเดลเดิมสองครั้ง"
		},
		{
			text: "ส่งต่อความรู้จาก pretrain model ไปยังโมเดลใหม่โดยโมเดลใหม่นี้จะเริ่มต้นการเทรนจาก weight ของโมเดลแรก",
			explain: "ถูกต้อง พอเราเริ่มเทรนโมเดลกับงานใหม่ ความรู้จะถูก*ส่งต่อ*มาจากจากโมเดลแรก",
			correct: true
		},
		{
			text: "ส่งต่อความรู้จาก pretrain model ไปยังโมเดลใหม่โดยสร้างโมเดลใหม่ด้วยสถาปัตยกรรมเดียวกับโมเดลแรก",
			explain: "สถาปัตยกรรมเป็นเพียงวิธีการสร้างโมเดล ไม่มีความรู้ใด ๆ รวมอยู่ข้างใน"
		}
	]}
/>

### 6. ประโยคต่อไปนี้ถูกหรือผิด? โมเดลบริบทภาษาเป็นการเทรนล่วงหน้าที่ไม่ต้องการ label ในการเทรน


<Question
	choices={[
		{
			text: "ถูก",
			explain: "การเทรนล่วงหน้านั้นส่วนใหญ่จะเป็นการ <em>self-supervise</em> นั่นคือ label จะถูกสร้างขึ้นอัตโนมัติจาก input เอง (เช่นการทำนายคำต่อไปในข้อความ หรือเติมคำในช่องว่าง)",
			correct: true
		},
		{
			text: "ผิด",
			explain: "คำตอบนี้ผิด"
		}
	]}
/>

### 7. โปรดเลือกประโยคที่อธิบายคำว่า "model", "architecture" และ "weight" ได้อย่างถูกต้อง"

<Question
	choices={[
		{
			text: "หากเปรียบ model เป็นตึก architecture ก็เป็นแผนผัง และ weight ก็เป็นผู้คนด้านใน",
			explain: "หากเทียบตามคำเปรียบเปรยนี้ weight ควรจะเป็นอิฐหรือวัสดุอื่น ๆ ในการสร้างตึกมากกว่า"
		},
		{
			text: "หากเปรียบ architecture เป็นแผนที่ในการสร้าง model ค่า weight แต่ละค่าก็เป็นเหมือนเมืองต่าง ๆ ในแผนที่",
			explain: "ข้อนี้เปรียบเทียบได้ไม่ถูกต้องเท่าไหร่ เพราะว่าจะมีเพียงเมืองเดียวที่อยู่บนแผนที่ที่ตำแหน่งเดียวกัน (ตัวอย่างเช่น มีเมืองเพียงเมืองเดียวในฝรั่งเศสที่ชื่อปารีส) สำหรับ architecture ใด ๆ ค่าชุด weight สามารถตั้งค่าหลากหลายแตกต่างกันได้"
		},
		{
			text: "architecture คือฟังก์ชันทางคณิตศาสตร์ที่ใช้ในการสร้าง model โดย weight ก็คือค่าคงที่ที่ใช้ในฟังก์ชันเหล่านั้น",
			explain: "ฟังก์ชันทางคณิตศาสตร์ชุดเดิม (architecture) สามารถใช้ในการสร้าง model ต่าง ๆ กันได้โดยใช้ค่าคงที่ (weight) ที่แตกต่างกัน",
			correct: true
		}
	]}
/>


### 8. โมเดลใดต่อไปนี้เหมาะสมในการใช้สำหรับงานสร้างคำที่หายไปในประโยค?

<Question
	choices={[
		{
			text: "โมเดล encoder",
			explain: "โมเดล encoder สร้างตัวแทนของประโยคทั้งประโยค เหมาะสำหรับงานเช่น การแยกแยะประเภทของประโยค"
		},
		{
			text: "โมเดล decoder",
			explain: "โมเดล decoder เหมาะสำหรับงานสร้างคำที่หายไปจากข้อความในประโยคมากที่สุด",
			correct: true
		},
		{
			text: "โมเดล sequence-to-sequence",
			explain: "โมเดล sequence-to-sequence เหมาะสำหรับงานที่ต้องการสร้างประโยคที่มีความสัมพันธ์กับประโยคที่ใส่เข้ามา ไม่ใช่แค่คำบางคำจากในประโยค"
		}
	]}
/>

### 9. โมเดลประเภทใดต่อไปนี้เหมาะสำหรับงานในการสรุปความ?

<Question
	choices={[
		{
			text: "โมเดล encoder",
			explain: "โมเดล encoder สร้างตัวแทนของประโยคทั้งประโยค เหมาะสำหรับงานเช่น การแยกแยะประเภทของประโยค"
		},
		{
			text: "โมเดล decoder",
			explain: "โมเดล decoder สามารถใช้ในการสร้างข้อความได้ (เช่น ข้อความสรุป) แต่โมเดลนี้ไม่สามารถเข้าใจข้อความทั้งหมดเพื่อทำการสรุปได้"
		},
		{
			text: "โมเดล sequence-to-sequence",
			explain: "โมเดล sequence-to-sequence เหมาะสำหรับงานสรุปความที่สุด",
			correct: true
		}
	]}
/>

### 10. โมเดลประเภทใดต่อไปนี้เหมาะสำหรับงานในการแยกแยะประเภทประโยคตาม label ที่กำหนดให้?

<Question
	choices={[
		{
			text: "โมเดล encoder",
			explain: "โมเดล encoder สร้างตัวแทนของประโยคทั้งประโยค เหมาะสำหรับงานเช่น การแยกแยะประเภทของประโยคแบบนี้ที่สุด",
			correct: true
		},
		{
			text: "โมเดล decoder",
			explain: "โมเดล decoder เหมาะสำหรับงานในการสร้างข้อความ ไม่เหมาะสำหรับการสกัด label ออกจากประโยคแบบนี้"
		},
		{
			text: "โมเดล sequence-to-sequence",
			explain: "โมเดล sequence-to-sequence เหมาะสำหรับงานที่คุณต้องการสร้างข้อความจากประโยค input ไม่ใช่จาก label",
		}
	]}
/>

### 11. อคติของโมเดลสามารถเกิดได้จากข้อใดต่อไปนี้ได้บ้าง?

<Question
	choices={[
		{
			text: "fine-tune โมเดลมาจากโมเดล pretrain ทำให้โมเดลที่ fine-tune นั้นรับอคติมาจากโมเดล pretrain",
			explain: "เมื่อคุณใช้งาน transfer learning อคติจากโมเดล pretrain จะส่งต่อไปยังโมเดลที่ fine-tune",
			correct: true
		},
		{
			text: "ข้อมูลที่ใช้เทรนโมเดลเป็นข้อมูลที่มีอคติปนอยู่",
			explain: "ข้อนี้เป็นแหล่งกำเนิดอคติที่ชัดที่สุด แต่ว่าไม่ได้มีข้อนี้ข้อเดียว",
			correct: true
		},
		{
			text: "metric ที่ใช้วัดระหว่างการ optimize มีอคติปนอยู่",
			explain: "ข้อนี้อาจดูไม่เหมือนว่าจะทำให้เกิดอคติในโมเดล แต่ว่าโมเดลของคุณจะปรับปรุงตัวเองไปเรื่อย ๆ ระหว่างเทรนตาม metric ที่เราเลือกโดยไม่มีการคิดซ้ำอีกครั้ง",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter1/10.mdx" />