# แบบทดสอบท้ายบท

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. ลำดับขั้นตอนใน pipeline ของการทำโมเดลด้านภาษา(language modeling)เป็นอย่างไร ?

<Question
	choices={[
		{
			text: "ขั้นตอนแรก โมเดลจะทำการประมวลผลข้อความและให้ผลการทำนายออกมา หลังจากนั้น tokenizer จะทำการวิเคราะห์ผลการทำนายเหล่านี้และแปลงมันกลับมาเป็นข้อความเมื่อจำเป็น",
			explain: "โมเดลไม่สามารถเข้าใจข้อความได้! tokenizer จำเป็นต้องทำการ tokenize ข้อความก่อนและแปลงมันไปเป็น IDs ที่โมเดลสามารถเข้าใจมันได้"
		},
		{
			text: "ขั้นตอนแรก tokenizer จะประมวลผลข้อความและให้ IDs ออกมา หลังจากนั้นโมเดลจะประมวลผล IDs เหล่านี้และให้ผลการทำนายออกมา ซึ่งอาจจะเป็นข้อความบางอย่าง",
			explain: "ผลการทำนายของโมเดลไม่สามารถเป็นข้อความออกมาได้โดยตรง tokenizer จำเป็นต้องถูกใช้สำหรับการแปลงผลการทำนายกลับไปเป็นข้อความ!"
		},
		{
			text: "tokenizer ประมวลผลข้อความและให้ IDs ออกมา หลังจากนั้นโมเดลจะประมวลผล IDs เหล่านี้และให้ผลการทำนายออกมา จากนั้น tokenizer จะถูกใช้อีกครั้งในการแปลงผลการทำนายเหล่านี้กลับไปเป็นข้อความ",
			explain: "ถูกต้อง! tokenizer สามารถถูกใช้สำหรับทั้งการแปลงข้อความไปเป็น IDs (tokenizing) และการแปลงผลการทำนายกลับไปเป็นข้อความ(de-tokenizing)",
            correct: true
		}
	]}
/>

### 2. tensor ที่เป็นเอาท์พุตออกมาจากโมเดล Transformer แบบพื้นฐานมีขนาดกี่มิติ และมิติเหล่านั้นเป็นอะไรบ้าง?

<Question
	choices={[
		{
			text: "2: ความยาวของประโยค(sequence length) และขนาดของชุดข้อมูล(batch size)",
			explain: "ผิด! tensor ที่ออกมาจากโมเดลมีมิติที่สามด้วย: ขนาดของเลเยอร์ภายใน(hidden size)"
		},
		{
			text: "2: ความยาวของประโยค(sequence length) และขนาดของเลเยอร์ภายใน(hidden size)",
			explain: "ผิด! โมเดล Transformer ทุกโมเดลจะรับข้อมูลแบบชุด(batch), ถึงแม้จะมีประโยคเพียงประโยคเดียว; ขนาดของชุด(batch size) ก็เป็น 1!"
		},
		{
			text: "3: ความยาวของประโยค(sequence length) ขนาดของชุดข้อมูล(batch size) และขนาดของเลเยอร์ภายใน(hidden size)",
			explain: "ถูกต้อง!",
            correct: true
		}
	]}
/>

### 3. ข้อใดต่อไปนี้เป็นตัวอย่างของ tokenization แบบคำย่อย(subword)?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "ถูกต้อง, ข้อนี้เป็นตัวอย่างหนึ่งของ tokenization แบบคำย่อย(subword)!",
            correct: true
		},
		{
			text: "tokenization ที่เน้นที่ตัวอักษร(Character-based)",
			explain: "tokenization ที่เน้นที่ตัวอักษร(Character-based) ไม่ได้เป็นประเภทของ tokenization แบบคำย่อย(subword)"
		},
		{
			text: "Splitting on whitespace and punctuation",
			explain: "อันนี้เป็น tokenization ประเภทเน้นคำ(word-based)!"
		},
		{
			text: "BPE",
			explain: "ถูกต้อง, ข้อนี้เป็นตัวอย่างหนึ่งของ tokenization แบบคำย่อย(subword)!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "ถูกต้อง, ข้อนี้เป็นตัวอย่างหนึ่งของ tokenization แบบคำย่อย(subword)!",
            correct: true
        },
		{
			text: "ไม่มีคำตอบที่ถูกต้อง",
			explain: "ผิด!"
        }
	]}
/>

### 4. model head คืออะไร?

<Question
	choices={[
		{
			text: "ส่วนประกอบหนึ่งของโมเดล Transformer พื้นฐาน ที่ส่งต่อ tensor ไปยังเลเยอร์ที่ถูกต้องของมัน",
			explain: "ผิด! ไม่มีส่วนประกอบแบบนั้น."
		},
		{
			text: "มันถูกเรียกอีกอย่างหนึ่งว่าเป็นกระบวนการ self-attention, มันดัดแปลงตัวแทน(representation) ของ token หนึ่งๆ เทียบกับ tokens อื่นๆ ในประโยค",
			explain: "ผิด! เลเยอร์ self-attention นั้นมี attention \"heads,\" แต่มันไม่ใช่ตัวที่เอาไว้ดัดแปลงข้อมูล(not adaptation heads)"
		},
		{
			text: "เป็นส่วนประกอบเสริม ที่ประกอบด้วยเลเยอร์อย่างน้อยหนึ่งเลเยอร์ ใช้สำหรับแปลงผลการทำนายของ transformer ไปเป็นผลลัพท์เฉพาะสำหรับงานหนึ่งๆ",
			explain: "ถูกต้อง. Adaptation heads เรียกง่ายๆ ก็คือ heads, มีหลากหลายรูปแบบ:  heads สำหรับโมเดลด้านภาษา(language modeling), heads สำหรับการตอบคำถาม(question answering), heads สำหรับการจำแนกประโยค(sequence classification) ... ",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. AutoModel คืออะไร?

<Question
	choices={[
		{
			text: "โมเดลที่เทรนด้วยข้อมูลของคุณแบบอัตโนมัติ",
			explain: "ผิด คุณสับสนกับผลิตภัณฑ์ <a href='https://huggingface.co/autonlp'>AutoNLP</a> ของเราหรือเปล่า?"
		},
		{
			text: "เป็น object ที่ให้สถาปัตยกรรมที่ถูกต้องสำหรับ checkpoint นั้นๆออกมา",
			explain: "ถูกต้อง: <code>AutoModel</code> จำเป็นต้องรู้เพียงแค่ว่า checkpoint ใดที่จะใช้ในการสร้างโมเดลและให้สถาปัตยกรรมที่ถูกต้องกลับมา",
			correct: true
		},
		{
			text: "โมเดลที่ตรวจหาภาษาที่ใช้สำหรับเป็นอินพุตของมันโดยอัตโนมัติเพื่อที่จะโหลด weights ที่ถูกต้อง",
			explain: "ผิด; ในขณะที่บาง checkpoints และโมเดล นั้นสามารถประมวลผลได้หลายภาษา, แต่ไม่มีเครื่องมือแบบ built-in สำหรับเลือก checkpoint ที่ตรงกับภาษาแบบอัตโนมัติเลย คุณลองไปดูที่ <a href='https://huggingface.co/models'>Model Hub</a> เพื่อหา checkpoint ที่ดีที่สุดสำหรับงานของคุณ!"
		} 
	]}
/>

{:else}
### 5. TFAutoModel คืออะไร?

<Question
	choices={[
		{
			text: "โมเดลที่เทรนด้วยข้อมูลของคุณแบบอัตโนมัติ",
			explain: "ผิด คุณสับสนกับผลิตภัณฑ์ <a href='https://huggingface.co/autonlp'>AutoNLP</a> ของเราหรือเปล่า?"
		},
		{
			text: "เป็น object ที่ให้สถาปัตยกรรมที่ถูกต้องสำหรับ checkpoint นั้นๆออกมา",
			explain: "ถูกต้อง: <code>AutoModel</code> จำเป็นต้องรู้เพียงแค่ว่า checkpoint ใดที่จะใช้ในการสร้างโมเดลและให้สถาปัตยกรรมที่ถูกต้องกลับมา",
			correct: true
		},
		{
			text:"โมเดลที่ตรวจหาภาษาที่ใช้สำหรับเป็นอินพุตของมันโดยอัตโนมัติเพื่อที่จะโหลด weights ที่ถูกต้อง",
			explain: "ผิด; ในขณะที่บาง checkpoints และโมเดล นั้นสามารถประมวลผลได้หลายภาษา, แต่ไม่มีเครื่องมือแบบ built-in สำหรับเลือก checkpoint ที่ตรงกับภาษาแบบอัตโนมัติเลย คุณลองไปดูที่ <a href='https://huggingface.co/models'>Model Hub</a> เพื่อหา checkpoint ที่ดีที่สุดสำหรับงานของคุณ!"
		} 
	]}
/>

{/if}

### 6. มีเทคนิคอะไรบ้างที่เราต้องคำนึงถึงเมื่อจะต้องทำการจัดประโยคที่มีความยาวแตกต่างกันเข้าเป็นชุดเดียวกัน(batching)?
<Question
	choices={[
		{
			text: "การตัด(Truncating)",
			explain: "ถูกต้อง, การตัด(truncation) เป็นวิธีที่ถูกต้องในการทำให้ประโยคนั้นมีความยาวเท่ากันเพื่อให้สามารถใส่เข้าไปแล้วชุดข้อมูลมีขนาดเป็นจตุรัส แต่มันมีเพียงแค่เทคนิคนี้เทคนิคเดียวหรือเปล่า?",
			correct: true
		},
		{
			text: "ให้ผลลัพท์ที่เป็น tensors ออกมา",
			explain: "ในขณะที่ใช้เทคนิคอื่นๆ นั้น คุณสามารถได้ผลลัพท์ที่เป็น tensors แบบจตุรัสได้, ดังนั้นการให้ผลลัพท์ที่เป็นเพียง tensor นั้นไม่ได้เป็นประโยชน์เมื่อทำการรวมประโยคเข้าเป็นชุดเดียวกัน"
		},
		{
			text: "การเติม(Padding)",
			explain: "ถูกต้อง, การเติม(padding) เป็นวิธีที่ถูกต้องในการทำให้ประโยคนั้นมีความยาวเท่ากันเพื่อให้สามารถใส่เข้าไปแล้วชุดข้อมูลมีขนาดเป็นจตุรัส แต่มันมีเพียงแค่เทคนิคนี้เทคนิคเดียวหรือเปล่า?",
			correct: true
		}, 
		{
			text: "Attention masking",
			explain: "ถูกต้องเลย! Attention masks เป็นกระบวนการที่สำคัญมากในการจัดการประโยคที่มีความยาวแตกต่างกัน แต่นั้นก็ไม่ใช่เพียงวิธีเดียว",
			correct: true
		} 
	]}
/>

### 7. อะไรคือจุดประสงค์ของการใช้ฟังก์ชัน SoftMax กับผลลัพท์ที่เป็น logits ที่ได้จากโมเดลสำหรับจำแนกประโยค (sequence classification model)?

<Question
	choices={[
		{
			text: "มันจะช่วยลดค่าของ logits ลงทำให้มันมีความน่าเชื่อถือมากขึ้น",
			explain: "ผิด, ฟังก์ชัน SoftMax ไม่ได้ส่งผลอะไรกับความน่าเชื่อถือของผลลัพท์"
		},
		{
			text: "มันกำหนดขอบเขตค่าบนและล่าง เพื่อทำให้ค่าที่ได้สามารถเป็นที่เข้าใจได้",
			explain: "ถูกต้อง! ค่าผลลัพท์ที่ได้มีขอบเขตระหว่าง 0 และ 1 แต่นี่ก็ไม่ได้เป็นเพียงเหตุผลเดียวที่เราใช้ฟังก์ชัน SoftMax",
            correct: true
		},
		{
			text: "ผลรวมของผลลัพท์เท่ากับ 1 ส่งผลให้สามารถแปลความหมายทางสถิติได้",
			explain: "ถูกต้อง! แต่นี่ก็ไม่ได้เป็นเพียงเหตุผลเดียวที่เราใช้ฟังก์ชัน SoftMax",
            correct: true
		}
	]}
/>

### 8. วิธีใดที่เป็นหัวใจหลักของ tokenizer API ส่วนใหญ่?

<Question
	choices={[
		{
			text: "<code>encode</code>, เพราะมันสามารถเข้ารหัสข้อความไปเป็น IDs และ IDs ไปเป็นคำทำนายได้",
			explain: "ผิด! ในขณะที่วิธีการ <code>encode</code> นั้นไม่มีอยู่ใน tokenizers, มันก็ไม่มีอยู่ในโมเดลเช่นเดียวกัน"
		},
		{
			text: "การเรียก tokenizer object โดยตรง",
			explain: "ถูกต้อง! วิธี <code>__call__</code> ของ tokenizer เป็นวิธีการที่ทรงพลังมากที่สามารถจัดการได้เกือบทุกอย่าง และมันก็เป็นวิธีการที่ถูกใช้ในการเอาผลการทำนายออกมาจากโมเดลด้วย",
			correct: true
		},
		{
			text: "<code>pad</code>",
			explain: "ผิด! การเติม(Padding) เป็นประโยชน์มาก แต่มันก็เป็นแค่ส่วนหนึ่งของ tokenizer API"
		},
		{
			text: "<code>tokenize</code>",
			explain: "วิธี <code>tokenize</code> เป็นหนึ่งวิธีที่มีประโยชน์มากแต่มันก็ไม่ใช่หัวใจหลักของ tokenizer API"
		}
	]}
/>

### 9. ตัวแปร `result` ในตัวอย่างโค้ดนี้มีค่าอะไรอยู่บ้าง?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "ลิสท์ของกลุ่มตัวอักษร(A list of strings), โดยที่แต่ละ string นั้นเป็น token",
			explain: "ถูกต้อง! แปลง token ไปเป็น IDs และส่งเข้าไปยังโมเดล!",
            correct: true
		},
		{
			text: "ลิสท์ของ IDs",
			explain: "ไม่ถูกต้อง; นั้นเป็นหน้าที่ของ <code>__call__</code> หรือ <code>convert_tokens_to_ids</code>!"
		},
		{
			text: "string ที่ประกอบด้วย tokens ทั้งหมด",
			explain: "นั้นอาจจะไม่ใช่วิธีที่ดีที่สุด, เมื่อเป้าหมายคือการแบ่ง string ออกเป็นหลายๆ tokens "
		}
	]}
/>

{#if fw === 'pt'}
### 10. มีอะไรบางอย่างที่ผิดปกติกับโค้ดต่อไปนี้หรือไม่?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "ไม่ ดูเหมือนว่ามันจะปกติ",
			explain: "โชคไม่ดีเลย, การต่อโมเดลกับ tokenizer ที่ผ่านการเทรนที่มาจาก checkpoint ที่แตกต่างกันนั้นเป็นไอเดียที่ไม่ค่อยดีเท่าไหร่ โมเดลไม่ได้ถูกเทรนมาให้สามารถเข้าใจผลลัพท์ที่ได้จาก tokenizer นี้ ดังนั้นผลลัพท์ของโมเดล(ถ้ามันสามารถรันได้!)ก็จะดูไม่เป็นเหตุเป็นผลซักเท่าไหร่"
		},
		{
			text: "tokenizer และโมเดลควรจะมาจาก checkpoint เดียวกันเสมอ",
			explain: "ถูกต้อง!",
            correct: true
		},
		{
			text: "มันเป็นสิ่งที่ดีในการเติม(pad) และ ตัด(truncate) โดยใช้ tokenizer ซึ่งทุกอินพุดก็เป็นชุดของข้อมูลอยู่แล้ว",
			explain: "ถูกต้องที่ว่าทุกอินพุตของโมเดลจำเป็นต้องอยู่ในรูปแบบของชุด(batch) แต่อย่างไรก็ตาม การตัด(truncating) หรือ การเติม(padding) ประโยคนี้อาจจะไม่สมเหตุสมผล เนื่องจากมันมีแค่ประโยคเดียวและเทคนิคเหล่านั้นเป็นเทคนิคสำหรับการรวมกลุ่มประโยค(a list of sentences)เข้าด้วยกันให้เป็นชุดๆ(batch)"
		}
	]}
/>

{:else}
### 10. มีอะไรบางอย่างที่ผิดปกติกับโค้ดต่อไปนี้หรือไม่?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "ไม่ ดูเหมือนว่ามันจะปกติ",
			explain:  "โชคไม่ดีเลย, การต่อโมเดลกับ tokenizer ที่ผ่านการเทรนที่มาจาก checkpoint ที่แตกต่างกันนั้นเป็นไอเดียที่ไม่ค่อยดีเท่าไหร่ โมเดลไม่ได้ถูกเทรนมาให้สามารถเข้าใจผลลัพท์ที่ได้จาก tokenizer นี้ ดังนั้นผลลัพท์ของโมเดล(ถ้ามันสามารถรันได้!)ก็จะดูไม่เป็นเหตุเป็นผลซักเท่าไหร่"
		},
		{
			text: "tokenizer และโมเดลควรจะมาจาก checkpoint เดียวกันเสมอ",
			explain: "ถูกต้อง!",
            correct: true
		},
		{
			text: "มันเป็นสิ่งที่ดีในการเติม(pad) และ ตัด(truncate) โดยใช้ tokenizer ซึ่งทุกอินพุดก็เป็นชุดของข้อมูลอยู่แล้ว",
			explain: "ถูกต้องที่ว่าทุกอินพุตของโมเดลจำเป็นต้องอยู่ในรูปแบบของชุด(batch) แต่อย่างไรก็ตาม การตัด(truncating) หรือ การเติม(padding) ประโยคนี้อาจจะไม่สมเหตุสมผล เนื่องจากมันมีแค่ประโยคเดียวและเทคนิคเหล่านั้นเป็นเทคนิคสำหรับการรวมกลุ่มประโยค(a list of sentences)เข้าด้วยกันให้เป็นชุดๆ(batch)"
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter2/8.mdx" />